/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import no.geosoft.cc.graphics.GStyleListener;

public class GStyle
implements Cloneable {
    private static final int MASK_FOREGROUNDCOLOR = 1;
    private static final int MASK_BACKGROUNDCOLOR = 2;
    private static final int MASK_LINEWIDTH = 4;
    private static final int MASK_FONT = 8;
    private static final int MASK_FILLPATTERN = 16;
    private static final int MASK_LINESTYLE = 32;
    private static final int MASK_CAPSTYLE = 64;
    private static final int MASK_JOINSTYLE = 128;
    private static final int MASK_ANTIALIAS = 256;
    private static final int MASK_GRADIENT = 512;
    public static final int LINESTYLE_SOLID = 1;
    public static final int LINESTYLE_DASHED = 2;
    public static final int LINESTYLE_DOTTED = 3;
    public static final int LINESTYLE_DASHDOT = 4;
    public static final int LINESTYLE_INVISIBLE = 5;
    public static final int FILL_NONE = 0;
    public static final int FILL_SOLID = 1;
    public static final int FILL_10 = 2;
    public static final int FILL_25 = 3;
    public static final int FILL_50 = 4;
    public static final int FILL_75 = 5;
    public static final int FILL_HORIZONTAL = 6;
    public static final int FILL_VERTICAL = 7;
    public static final int FILL_DIAGONAL = 8;
    private final Collection listeners_ = new ArrayList();
    private int validMask_ = 0;
    private Color foregroundColor_ = Color.black;
    private Color backgroundColor_ = null;
    private int lineWidth_ = 1;
    private float[] dashPattern_ = null;
    private float dashOffset_ = 0.0f;
    private boolean isLineVisible_ = true;
    private Font font_ = Font.decode("dialog");
    private BufferedImage fillPattern_ = null;
    private int fillWidth_;
    private int fillHeight_;
    private int[] fillData_ = null;
    private Stroke stroke_;
    private Paint paint_ = null;
    private int capStyle_ = 1;
    private int joinStyle_ = 1;
    private float miterLimit_ = 0.0f;
    private boolean isAntialiased_ = true;
    private Color gradientColor1_ = null;
    private Color gradientColor2_ = null;

    public Object clone() {
        int i;
        GStyle style = new GStyle();
        style.validMask_ = this.validMask_;
        style.foregroundColor_ = null;
        if (this.foregroundColor_ != null) {
            style.foregroundColor_ = new Color(this.foregroundColor_.getRed(), this.foregroundColor_.getGreen(), this.foregroundColor_.getBlue(), this.foregroundColor_.getAlpha());
        }
        style.backgroundColor_ = null;
        if (this.backgroundColor_ != null) {
            style.backgroundColor_ = new Color(this.backgroundColor_.getRed(), this.backgroundColor_.getGreen(), this.backgroundColor_.getBlue(), this.backgroundColor_.getAlpha());
        }
        style.lineWidth_ = this.lineWidth_;
        style.font_ = null;
        if (this.font_ != null) {
            style.font_ = new Font(this.font_.getName(), this.font_.getStyle(), this.font_.getSize());
        }
        style.dashPattern_ = null;
        if (this.dashPattern_ != null) {
            style.dashPattern_ = new float[this.dashPattern_.length];
            for (i = 0; i < this.dashPattern_.length; ++i) {
                style.dashPattern_[i] = this.dashPattern_[i];
            }
        }
        style.fillPattern_ = null;
        style.fillData_ = null;
        if (this.fillData_ != null) {
            style.fillData_ = new int[this.fillData_.length];
            for (i = 0; i < this.fillData_.length; ++i) {
                style.fillData_[i] = this.fillData_[i];
            }
        }
        style.capStyle_ = this.capStyle_;
        style.joinStyle_ = this.joinStyle_;
        style.miterLimit_ = this.miterLimit_;
        style.dashOffset_ = this.dashOffset_;
        style.isLineVisible_ = this.isLineVisible_;
        style.isAntialiased_ = this.isAntialiased_;
        style.gradientColor1_ = this.gradientColor1_;
        style.gradientColor2_ = this.gradientColor2_;
        return style;
    }

    void update(GStyle style) {
        if (style.isValid(1)) {
            this.setForegroundColor(style.foregroundColor_);
        }
        if (style.isValid(2)) {
            this.setBackgroundColor(style.backgroundColor_);
        }
        if (style.isValid(4)) {
            this.setLineWidth(style.lineWidth_);
        }
        if (style.isValid(8)) {
            this.setFont(style.font_);
        }
        if (style.isValid(16)) {
            if (style.fillData_ != null) {
                this.setFillPattern(style.fillWidth_, style.fillHeight_, style.fillData_);
            } else {
                this.setFillPattern(style.fillPattern_);
            }
        }
        if (style.isValid(32)) {
            this.setLineStyle(style.dashPattern_);
            this.isLineVisible_ = style.isLineVisible_;
        }
        if (style.isValid(64)) {
            this.setCapStyle(style.capStyle_);
        }
        if (style.isValid(128)) {
            this.setJoinStyle(style.joinStyle_);
        }
        if (style.isValid(256)) {
            this.setAntialiased(style.isAntialiased_);
        }
        if (style.isValid(512)) {
            this.setGradient(style.gradientColor1_, style.gradientColor2_);
        }
    }

    private void setValid(int validMask) {
        this.validMask_ |= validMask;
    }

    private void setInvalid(int validMask) {
        this.validMask_ &= ~validMask;
    }

    private boolean isValid(int validMask) {
        return (this.validMask_ & validMask) != 0;
    }

    public void setForegroundColor(Color foregroundColor) {
        if (foregroundColor == null) {
            foregroundColor = Color.black;
        }
        this.foregroundColor_ = foregroundColor;
        this.setValid(1);
        if (this.fillData_ != null) {
            this.fillPattern_ = null;
        }
        this.notifyListeners();
    }

    public void unsetForegroundColor() {
        this.foregroundColor_ = null;
        this.setInvalid(1);
        if (this.fillData_ != null) {
            this.fillPattern_ = null;
        }
        this.notifyListeners();
    }

    public Color getForegroundColor() {
        return this.foregroundColor_;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor_ = backgroundColor;
        this.setValid(2);
        if (this.fillData_ != null) {
            this.fillPattern_ = null;
        }
        this.notifyListeners();
    }

    public void unsetBackgroundColor() {
        this.backgroundColor_ = null;
        this.setInvalid(2);
        if (this.fillData_ != null) {
            this.fillPattern_ = null;
        }
        this.notifyListeners();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor_;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 1) {
            lineWidth = 1;
        }
        this.lineWidth_ = lineWidth;
        this.setValid(4);
        this.stroke_ = null;
        this.notifyListeners();
    }

    public void unsetLineWidth() {
        this.setInvalid(4);
        this.stroke_ = null;
        this.notifyListeners();
    }

    public int getLineWidth() {
        return this.lineWidth_;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Font.decode("dialog");
        }
        this.font_ = font;
        this.setValid(8);
        this.notifyListeners();
    }

    public void unsetFont() {
        this.setInvalid(8);
        this.notifyListeners();
    }

    public Font getFont() {
        return this.font_;
    }

    public void setCapStyle(int capStyle) {
        this.capStyle_ = capStyle;
        this.setValid(64);
        this.stroke_ = null;
        this.notifyListeners();
    }

    public void unsetCapStyle() {
        this.setInvalid(64);
        this.notifyListeners();
    }

    public int getCapStyle() {
        return this.capStyle_;
    }

    public void setJoinStyle(int joinStyle) {
        this.joinStyle_ = joinStyle;
        this.setValid(128);
        this.stroke_ = null;
        this.notifyListeners();
    }

    public void unsetJoinStyle() {
        this.setInvalid(128);
        this.notifyListeners();
    }

    public int getJoinStyle() {
        return this.joinStyle_;
    }

    public void setAntialiased(boolean isAntialiased) {
        this.isAntialiased_ = isAntialiased;
        this.setValid(256);
        this.notifyListeners();
    }

    public void unsetAntialias() {
        this.setInvalid(256);
        this.notifyListeners();
    }

    public boolean isAntialiased() {
        return this.isAntialiased_;
    }

    public void setGradient(Color color1, Color color2) {
        this.gradientColor1_ = color1;
        this.gradientColor2_ = color2;
        this.setValid(512);
        this.paint_ = null;
        this.notifyListeners();
    }

    public void unsetGradient() {
        this.setInvalid(512);
        this.notifyListeners();
    }

    public void setFillPattern(int fillType) {
        int height;
        int width;
        switch (fillType) {
            case 0: {
                width = 0;
                height = 0;
                break;
            }
            case 1: {
                width = 1;
                height = 1;
                break;
            }
            case 2: {
                width = 3;
                height = 3;
                break;
            }
            case 3: {
                width = 2;
                height = 2;
                break;
            }
            case 4: {
                width = 2;
                height = 2;
                break;
            }
            case 5: {
                width = 2;
                height = 2;
                break;
            }
            case 6: {
                width = 1;
                height = 2;
                break;
            }
            case 7: {
                width = 2;
                height = 1;
                break;
            }
            case 8: {
                width = 3;
                height = 3;
                break;
            }
            default: {
                return;
            }
        }
        int[] data = new int[width * height];
        switch (fillType) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                data[0] = 1;
                break;
            }
            case 4: {
                data[0] = 1;
                data[3] = 1;
                break;
            }
            case 5: {
                data[1] = 1;
                data[2] = 1;
                data[3] = 1;
                break;
            }
            case 8: {
                data[0] = 1;
                data[4] = 1;
                data[8] = 1;
            }
        }
        this.setFillPattern(width, height, data);
    }

    public void setFillPattern(int width, int height, int[] data) {
        this.fillWidth_ = width;
        this.fillHeight_ = height;
        int size = width * height;
        this.fillData_ = size > 0 ? new int[size] : null;
        for (int i = 0; i < size; ++i) {
            this.fillData_[i] = data != null && data.length > i ? data[i] : 0;
        }
        this.fillPattern_ = null;
        this.paint_ = null;
        this.setValid(16);
        this.notifyListeners();
    }

    public void setFillPattern(BufferedImage image) {
        this.fillData_ = null;
        this.fillPattern_ = image;
        this.setValid(16);
        this.paint_ = null;
        this.notifyListeners();
    }

    public void setFillPattern(String fileName) {
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(fileName));
            this.fillPattern_ = ImageIO.read(stream);
            this.paint_ = null;
            this.setValid(16);
            this.notifyListeners();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void unsetFillPattern() {
        this.setInvalid(16);
        this.notifyListeners();
    }

    public BufferedImage getFillPattern() {
        return this.fillPattern_;
    }

    public void setLineStyle(float[] dashPattern) {
        if (dashPattern != null) {
            this.dashPattern_ = new float[dashPattern.length];
            System.arraycopy(dashPattern, 0, this.dashPattern_, 0, dashPattern.length);
            this.isLineVisible_ = true;
        } else {
            this.dashPattern_ = null;
        }
        this.setValid(32);
        this.stroke_ = null;
        this.notifyListeners();
    }

    public void setLineStyle(int lineStyle) {
        float[] dashPattern = null;
        switch (lineStyle) {
            case 1: {
                this.isLineVisible_ = true;
                break;
            }
            case 2: {
                dashPattern = new float[]{5.0f, 5.0f};
                break;
            }
            case 3: {
                dashPattern = new float[]{2.0f, 5.0f};
                break;
            }
            case 4: {
                dashPattern = new float[]{8.0f, 3.0f, 2.0f, 3.0f};
                break;
            }
            case 5: {
                this.isLineVisible_ = false;
            }
        }
        this.setLineStyle(dashPattern);
    }

    public void unsetLineStyle() {
        this.setInvalid(32);
        this.stroke_ = null;
        this.notifyListeners();
    }

    public float[] getLineStyle() {
        return this.dashPattern_;
    }

    Stroke getStroke() {
        if (this.stroke_ == null) {
            float[] dashPattern = null;
            if (this.dashPattern_ != null) {
                dashPattern = new float[this.dashPattern_.length];
                for (int i = 0; i < this.dashPattern_.length; ++i) {
                    dashPattern[i] = this.dashPattern_[i] * (float)this.lineWidth_;
                }
            }
            this.stroke_ = new BasicStroke(this.lineWidth_, this.capStyle_, this.joinStyle_, this.miterLimit_, dashPattern, this.dashOffset_);
        }
        return this.stroke_;
    }

    Paint getPaint() {
        if (this.fillPattern_ == null && this.fillData_ != null) {
            this.fillPattern_ = new BufferedImage(this.fillWidth_, this.fillHeight_, 2);
            int pointNo = 0;
            for (int i = 0; i < this.fillHeight_; ++i) {
                for (int j = 0; j < this.fillWidth_; ++j) {
                    if (this.fillData_[pointNo] == 0 && this.backgroundColor_ != null) {
                        this.fillPattern_.setRGB(i, j, this.backgroundColor_.getRGB());
                    } else if (this.fillData_[pointNo] != 0) {
                        this.fillPattern_.setRGB(i, j, this.foregroundColor_.getRGB());
                    }
                    ++pointNo;
                }
            }
            this.paint_ = null;
        }
        if (this.paint_ == null && this.fillPattern_ != null) {
            this.paint_ = new TexturePaint(this.fillPattern_, new Rectangle(0, 0, this.fillWidth_, this.fillHeight_));
        } else if (this.paint_ == null && this.gradientColor1_ != null) {
            this.paint_ = new GradientPaint(-100.0f, 0.0f, this.gradientColor1_, 100.0f, 0.0f, this.gradientColor2_, true);
        } else if (this.backgroundColor_ != null) {
            this.paint_ = this.backgroundColor_;
        }
        return this.paint_;
    }

    float getMiterLimit() {
        return this.miterLimit_;
    }

    boolean isLineVisible() {
        return this.isLineVisible_;
    }

    boolean isDefiningFill() {
        return this.fillPattern_ != null || this.fillData_ != null || this.backgroundColor_ != null;
    }

    private void notifyListeners() {
        Iterator i = this.listeners_.iterator();
        while (i.hasNext()) {
            WeakReference reference = (WeakReference)i.next();
            GStyleListener listener = (GStyleListener)reference.get();
            if (listener == null) {
                i.remove();
                continue;
            }
            listener.styleChanged(this);
        }
    }

    void addListener(GStyleListener listener) {
        for (WeakReference reference : this.listeners_) {
            if (reference.get() != listener) continue;
            return;
        }
        this.listeners_.add(new WeakReference<GStyleListener>(listener));
    }

    void removeListener(GStyleListener listener) {
        Iterator i = this.listeners_.iterator();
        while (i.hasNext()) {
            WeakReference reference = (WeakReference)i.next();
            if (reference.get() != listener) continue;
            i.remove();
            break;
        }
    }
}

