/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import no.geosoft.cc.geometry.Box;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.geometry.Rect;
import no.geosoft.cc.geometry.Region;
import no.geosoft.cc.graphics.GComponent;
import no.geosoft.cc.graphics.GImage;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GPositional;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GStyleListener;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GTransformer;

public class GSegment
implements GStyleListener {
    private GObject owner_ = null;
    private int[] x_ = null;
    private int[] y_ = null;
    private GImage vertexImage_ = null;
    private Rect rectangle_ = null;
    private Object userData_;
    private GStyle style_ = null;
    private GStyle actualStyle_ = new GStyle();
    private boolean isVisible_ = false;
    private List texts_ = null;
    private Collection components_ = null;
    private Collection images_ = null;

    public GObject getOwner() {
        return this.owner_;
    }

    void setOwner(GObject owner) {
        this.owner_ = owner;
        this.updateContext();
    }

    GScene getScene() {
        return this.owner_ == null ? null : this.owner_.getScene();
    }

    public void setUserData(Object userData) {
        this.userData_ = userData;
    }

    public Object getUserData() {
        return this.userData_;
    }

    int[] getX() {
        return this.x_;
    }

    int[] getY() {
        return this.y_;
    }

    int getNPoints() {
        return this.x_ == null ? 0 : this.x_.length;
    }

    Rect getRectangle() {
        return this.rectangle_;
    }

    Region getRegion() {
        Region region = new Region();
        if (this.rectangle_ != null) {
            region.union(this.rectangle_);
        }
        if (this.texts_ != null) {
            for (GText text : this.texts_) {
                region.union(text.getRectangle());
            }
        }
        if (this.images_ != null) {
            for (GImage image : this.images_) {
                region.union(image.getRectangle());
            }
        }
        if (this.images_ != null) {
            for (GComponent component : this.images_) {
                region.union(component.getRectangle());
            }
        }
        return region;
    }

    int getCenterX() {
        return this.rectangle_ == null ? 0 : this.rectangle_.getCenterX();
    }

    int getCenterY() {
        return this.rectangle_ == null ? 0 : this.rectangle_.getCenterY();
    }

    private void updateContext() {
        this.isVisible_ = false;
        if (this.owner_ == null) {
            return;
        }
        this.owner_.flagRegionValid(false);
        if (this.owner_.getScene() == null) {
            return;
        }
        if (this.rectangle_ != null) {
            this.isVisible_ = this.owner_.getScene().getRegion().isIntersecting(this.rectangle_);
        }
        this.updateDamage();
        if (this.texts_ != null) {
            this.owner_.getScene().setAnnotationValid(false);
        }
        if (this.images_ != null) {
            this.owner_.getScene().computePositions(this.images_);
        }
    }

    void updateDamage() {
        if (this.isVisible_ && this.rectangle_ != null && !this.rectangle_.isEmpty() && this.owner_ != null && this.owner_.getWindow() != null) {
            this.owner_.getWindow().updateDamageArea(this.rectangle_);
        }
    }

    private void computeRectangle() {
        int lineWidth = this.actualStyle_.getLineWidth() - 1;
        if (this.x_ != null) {
            if (this.rectangle_ == null) {
                this.rectangle_ = new Rect();
            }
            this.rectangle_.set(this.x_, this.y_);
            this.rectangle_.expand(lineWidth + 1, lineWidth + 1);
        }
    }

    public void setGeometry(int x, int y) {
        this.setGeometry(new int[]{x}, new int[]{y});
    }

    public void setGeometry(int x0, int y0, int x1, int y1) {
        this.setGeometry(new int[]{x0, x1}, new int[]{y0, y1});
    }

    public void setGeometry(int[] x, int[] y) {
        this.updateDamage();
        if (x == null) {
            this.x_ = null;
            this.y_ = null;
            this.rectangle_ = null;
        } else {
            int nPoints = x.length;
            if (this.x_ == null || this.x_.length != nPoints) {
                this.x_ = new int[nPoints];
                this.y_ = new int[nPoints];
            }
            for (int i = 0; i < nPoints; ++i) {
                this.x_[i] = x[i];
                this.y_[i] = y[i];
            }
            this.computeRectangle();
        }
        this.updateContext();
    }

    public void setGeometry(int[] xy) {
        this.updateDamage();
        if (xy == null) {
            this.x_ = null;
            this.y_ = null;
            this.rectangle_ = null;
        } else {
            int nPoints = xy.length / 2;
            if (this.x_ == null || this.x_.length != nPoints) {
                this.x_ = new int[nPoints];
                this.y_ = new int[nPoints];
            }
            for (int i = 0; i < nPoints; ++i) {
                this.x_[i] = xy[i * 2 + 0];
                this.y_[i] = xy[i * 2 + 1];
            }
            this.computeRectangle();
        }
        this.updateContext();
    }

    public void setGeometry(double x, double y, double z) {
        this.setGeometry(new double[]{x}, new double[]{y}, new double[]{z});
    }

    public void setGeometry(double x, double y) {
        this.setGeometry(x, y, 0.0);
    }

    public void setGeometry(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.setGeometry(new double[]{x0, x1}, new double[]{y0, y1}, new double[]{z0, z1});
    }

    public void setGeometry(double x0, double y0, double x1, double y1) {
        this.setGeometry(new double[]{x0, x1}, new double[]{y0, y1}, new double[]{0.0, 0.0});
    }

    public void setGeometry(double[] x, double[] y, double[] z) {
        GTransformer transformer = this.owner_.getScene().getTransformer();
        int nPoints = x.length;
        double[] world = new double[3];
        int[] device = new int[2];
        int[] devx = new int[nPoints];
        int[] devy = new int[nPoints];
        for (int i = 0; i < x.length; ++i) {
            world[0] = x[i];
            world[1] = y[i];
            world[2] = z == null ? 0.0 : z[i];
            device = transformer.worldToDevice(world);
            devx[i] = device[0];
            devy[i] = device[1];
        }
        this.setGeometry(devx, devy);
    }

    public void setGeometry(double[] x, double[] y) {
        this.setGeometry(x, y, null);
    }

    public void setGeometry(double[] xyz) {
        GTransformer transformer = this.owner_.getScene().getTransformer();
        int nPoints = xyz.length / 3;
        int[] devxy = new int[nPoints * 2];
        double[] world = new double[3];
        int[] device = new int[2];
        int wIndex = 0;
        int dIndex = 0;
        for (int i = 0; i < nPoints; ++i) {
            world[0] = xyz[wIndex + 0];
            world[1] = xyz[wIndex + 1];
            world[2] = xyz[wIndex + 2];
            device = transformer.worldToDevice(world);
            devxy[dIndex + 0] = device[0];
            devxy[dIndex + 1] = device[1];
            wIndex += 3;
            dIndex += 2;
        }
        this.setGeometry(devxy);
    }

    public void setGeometryXy(double[] xy) {
        GTransformer transformer = this.owner_.getScene().getTransformer();
        int nPoints = xy.length / 2;
        int[] devxy = new int[nPoints * 2];
        double[] world = new double[3];
        int[] device = new int[2];
        int wIndex = 0;
        int dIndex = 0;
        for (int i = 0; i < nPoints; ++i) {
            world[0] = xy[wIndex + 0];
            world[1] = xy[wIndex + 1];
            world[2] = 0.0;
            device = transformer.worldToDevice(world);
            devxy[dIndex + 0] = device[0];
            devxy[dIndex + 1] = device[1];
            wIndex += 2;
            dIndex += 2;
        }
        this.setGeometry(devxy);
    }

    public void translate(int dx, int dy) {
        if (this.x_ == null) {
            return;
        }
        int[] newX = new int[this.x_.length];
        int[] newY = new int[this.x_.length];
        for (int i = 0; i < this.x_.length; ++i) {
            newX[i] = this.x_[i] + dx;
            newY[i] = this.y_[i] + dy;
        }
        this.setGeometry(newX, newY);
    }

    public void setStyle(GStyle style) {
        if (this.style_ != null) {
            this.style_.removeListener(this);
        }
        this.style_ = style;
        if (this.style_ != null) {
            this.style_.addListener(this);
        }
        this.updateStyle();
    }

    public GStyle getStyle() {
        return this.style_;
    }

    GStyle getActualStyle() {
        return this.actualStyle_;
    }

    void updateStyle() {
        this.actualStyle_ = new GStyle();
        if (this.owner_ != null) {
            this.actualStyle_.update(this.owner_.getActualStyle());
        }
        if (this.style_ != null) {
            this.actualStyle_.update(this.style_);
        }
        if (this.texts_ != null) {
            for (GText text : this.texts_) {
                text.updateStyle();
            }
        }
        this.computeRectangle();
        this.updateContext();
    }

    private Region findRegion(Collection positionals) {
        Region region = new Region();
        for (GPositional positional : positionals) {
            if (!positional.isVisible()) continue;
            region.union(positional.getRectangle());
        }
        return region;
    }

    public void addText(GText text) {
        if (this.texts_ == null) {
            this.texts_ = new ArrayList();
        }
        this.texts_.add(text);
        text.setSegment(this);
        if (this.owner_ != null) {
            this.owner_.flagRegionValid(false);
            if (this.owner_.getScene() != null) {
                this.owner_.getScene().setAnnotationValid(false);
            }
        }
    }

    public void setText(GText text) {
        this.removeText();
        this.addText(text);
    }

    public List getTexts() {
        return this.texts_;
    }

    public GText getText() {
        return this.texts_ != null ? (GText)this.texts_.iterator().next() : null;
    }

    public void removeText() {
        if (this.owner_ != null && this.owner_.getWindow() != null && this.texts_ != null) {
            Region damage = this.findRegion(this.texts_);
            this.owner_.getWindow().updateDamageArea(damage);
        }
        this.texts_ = null;
    }

    public void addImage(GImage image) {
        if (this.images_ == null) {
            this.images_ = new ArrayList();
        }
        this.images_.add(image);
        image.setSegment(this);
        if (this.owner_ != null) {
            this.owner_.flagRegionValid(false);
        }
    }

    public void setImage(GImage image) {
        this.removeImages();
        this.addImage(image);
    }

    public Collection getImages() {
        return this.images_;
    }

    public void removeImages() {
        if (this.owner_ != null && this.owner_.getWindow() != null && this.images_ != null) {
            Region damage = this.findRegion(this.images_);
            this.owner_.getWindow().updateDamageArea(damage);
        }
        this.images_ = null;
    }

    public void setVertexImage(GImage image) {
        this.vertexImage_ = image;
    }

    public GImage getVertexImage() {
        return this.vertexImage_;
    }

    public void addComponent(GComponent component) {
        if (this.components_ == null) {
            this.components_ = new ArrayList();
        }
        component.setSegment(this);
        this.components_.add(component);
    }

    public void setComponent(GComponent component) {
        this.removeComponents();
        this.addComponent(component);
    }

    public Collection getComponents() {
        return this.components_;
    }

    public void removeComponents() {
        if (this.owner_ != null && this.owner_.getWindow() != null && this.components_ != null) {
            Region damage = this.findRegion(this.components_);
            this.owner_.getWindow().updateDamageArea(damage);
        }
        this.components_ = null;
    }

    boolean isVisible() {
        return this.isVisible_;
    }

    boolean isFilled() {
        return this.actualStyle_.isDefiningFill();
    }

    boolean isInsideRectangle(int x0, int y0, int x1, int y1) {
        if (this.rectangle_ == null) {
            return false;
        }
        Box box = new Box(this.rectangle_);
        return box.isInsideOf(new Box(x0, y0, x1, y1));
    }

    boolean isIntersectingRectangle(int x0, int y0, int x1, int y1) {
        if (this.x_ == null) {
            return false;
        }
        return this.isFilled() && Geometry.isPolygonIntersectingRectangle(this.x_, this.y_, x0, y0, x1, y1) || !this.isFilled() && Geometry.isPolylineIntersectingRectangle(this.x_, this.y_, x0, y0, x1, y1);
    }

    boolean isIntersectingPoint(int x, int y) {
        if (this.x_ == null) {
            return false;
        }
        return this.isFilled() && Geometry.isPointInsidePolygon(this.x_, this.y_, x, y) || !this.isFilled() && Geometry.isPolylineIntersectingRectangle(this.x_, this.y_, x - 1, y - 1, x + 1, y + 1);
    }

    @Override
    public void styleChanged(GStyle style) {
        this.updateStyle();
    }
}

