/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.awt.Adjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GTransformer;
import no.geosoft.cc.graphics.GViewport;
import no.geosoft.cc.graphics.GWorldExtent;

class GScrollHandler
implements AdjustmentListener {
    private final GScene scene_;
    private final Adjustable hScrollBar_;
    private final Adjustable vScrollBar_;

    GScrollHandler(GScene scene, Adjustable hScrollBar, Adjustable vScrollBar) {
        this.scene_ = scene;
        this.hScrollBar_ = hScrollBar;
        this.vScrollBar_ = vScrollBar;
        this.hScrollBar_.addAdjustmentListener(this);
        this.vScrollBar_.addAdjustmentListener(this);
        this.updateScrollBars();
    }

    void updateScrollBars() {
        int blockIncrement;
        int unitIncrement;
        int visibleAmount;
        int value;
        int maximum;
        int minimum;
        this.hScrollBar_.removeAdjustmentListener(this);
        this.vScrollBar_.removeAdjustmentListener(this);
        GWorldExtent worldExtent = this.scene_.getInitialWorldExtent();
        GViewport viewport = this.scene_.getViewport();
        GTransformer transformer = this.scene_.getTransformer();
        int[] viewport0 = viewport.get(0);
        int[] world0 = transformer.worldToDevice(worldExtent.get(2));
        int[] viewport1 = viewport.get(1);
        int[] world1 = transformer.worldToDevice(worldExtent.get(1));
        int[] viewport2 = viewport.get(2);
        int[] world2 = transformer.worldToDevice(worldExtent.get(0));
        if (this.hScrollBar_ != null) {
            minimum = Math.min(viewport0[0], world0[0]);
            maximum = Math.max(viewport1[0], world1[0]);
            value = viewport0[0];
            visibleAmount = viewport1[0] - viewport0[0];
            unitIncrement = (int)Math.max(1L, Math.round((double)visibleAmount * 0.1));
            blockIncrement = (int)Math.max(1L, Math.round((double)visibleAmount * 0.9));
            this.hScrollBar_.setMinimum(minimum);
            this.hScrollBar_.setMaximum(maximum);
            this.hScrollBar_.setValue(value);
            this.hScrollBar_.setVisibleAmount(visibleAmount);
            this.hScrollBar_.setUnitIncrement(unitIncrement);
            this.hScrollBar_.setBlockIncrement(blockIncrement);
        }
        if (this.vScrollBar_ != null) {
            minimum = Math.min(viewport0[1], world0[1]);
            maximum = Math.max(viewport2[1], world2[1]);
            value = viewport0[1];
            visibleAmount = viewport2[1] - viewport0[1];
            unitIncrement = (int)Math.max(1L, Math.round((double)visibleAmount * 0.1));
            blockIncrement = (int)Math.max(1L, Math.round((double)visibleAmount * 0.9));
            this.vScrollBar_.setMinimum(minimum);
            this.vScrollBar_.setMaximum(maximum);
            this.vScrollBar_.setValue(value);
            this.vScrollBar_.setVisibleAmount(visibleAmount);
            this.vScrollBar_.setUnitIncrement(unitIncrement);
            this.vScrollBar_.setBlockIncrement(blockIncrement);
        }
        this.hScrollBar_.addAdjustmentListener(this);
        this.vScrollBar_.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        GViewport viewport = this.scene_.getViewport();
        int x0 = viewport.getX0();
        int y0 = viewport.getY0();
        int x1 = viewport.getX3();
        int y1 = viewport.getY3();
        if (this.hScrollBar_ != null) {
            int hValue = this.hScrollBar_.getValue();
            int hVisibleAmount = this.hScrollBar_.getVisibleAmount();
            x0 = hValue;
            x1 = hValue + hVisibleAmount;
        }
        if (this.vScrollBar_ != null) {
            int vValue = this.vScrollBar_.getValue();
            int vVisibleAmount = this.vScrollBar_.getVisibleAmount();
            y0 = vValue;
            y1 = vValue + vVisibleAmount;
        }
        this.scene_.zoom(x0, y0, x1, y1);
    }
}

