/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.awt.Adjustable;
import java.util.Collection;
import no.geosoft.cc.geometry.Rect;
import no.geosoft.cc.graphics.GAnnotator;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GPositional;
import no.geosoft.cc.graphics.GScrollHandler;
import no.geosoft.cc.graphics.GTransformer;
import no.geosoft.cc.graphics.GViewport;
import no.geosoft.cc.graphics.GWindow;
import no.geosoft.cc.graphics.GWorldExtent;

public class GScene
extends GObject {
    private final GWindow window_;
    private final GTransformer transformer_;
    private final GAnnotator annotator_;
    private GViewport viewport_;
    private GWorldExtent initialWorldExtent_;
    private GWorldExtent currentWorldExtent_;
    private boolean shouldZoomOnResize_ = true;
    private boolean shouldWorldExtentFitViewport_ = true;
    private boolean isAnnotationValid_;
    private GScrollHandler scrollHandler_;
    private boolean isViewportFixed_;

    public GScene(GWindow window, String name) {
        super(name);
        this.window_ = window;
        this.window_.addScene(this);
        int viewportWidth = this.window_.getWidth();
        int viewportHeight = this.window_.getHeight();
        this.viewport_ = new GViewport(0, 0, viewportWidth, viewportHeight);
        this.isViewportFixed_ = false;
        double[] w0 = new double[]{0.0, viewportHeight, 0.0};
        double[] w1 = new double[]{viewportWidth, viewportHeight, 0.0};
        double[] w2 = new double[]{0.0, 0.0, 0.0};
        this.initialWorldExtent_ = new GWorldExtent(w0, w1, w2);
        this.currentWorldExtent_ = new GWorldExtent(w0, w1, w2);
        this.transformer_ = new GTransformer(this.viewport_, this.currentWorldExtent_);
        this.annotator_ = new GAnnotator(this);
        this.scrollHandler_ = null;
        this.updateRegion();
    }

    public GScene(GWindow window) {
        this(window, null);
    }

    @Override
    public GScene getScene() {
        return this;
    }

    @Override
    public GWindow getWindow() {
        return this.window_;
    }

    @Override
    public GTransformer getTransformer() {
        return this.transformer_;
    }

    public void shouldZoomOnResize(boolean shouldZoomOnResize) {
        this.shouldZoomOnResize_ = shouldZoomOnResize;
    }

    public void shouldWorldExtentFitViewport(boolean shouldWorldExtentFitViewport) {
        this.shouldWorldExtentFitViewport_ = shouldWorldExtentFitViewport;
    }

    public void setViewport(int x0, int y0, int x1, int y1, int x2, int y2) {
        this.isViewportFixed_ = true;
        this.window_.updateDamageArea(this.getRegion());
        this.viewport_.set(x0, y0, x1, y1, x2, y2);
        this.updateRegion();
        this.window_.updateDamageArea(this.getRegion());
        this.adjustCurrentWorldExtent();
        this.transformer_.update(this.viewport_, this.currentWorldExtent_);
        this.annotator_.reset();
        this.redraw(this.getVisibility());
        if (this.scrollHandler_ != null) {
            this.scrollHandler_.updateScrollBars();
        }
    }

    public void setViewport(int x0, int y0, int width, int height) {
        this.setViewport(x0, y0, x0 + width - 1, y0, x0, y0 + height - 1);
    }

    public GViewport getViewport() {
        return this.viewport_;
    }

    public void setWorldExtent(double[] w0, double[] w1, double[] w2) {
        this.initialWorldExtent_.set(w0, w1, w2);
        this.currentWorldExtent_.set(w0, w1, w2);
        this.adjustCurrentWorldExtent();
        this.transformer_.update(this.viewport_, this.currentWorldExtent_);
        this.window_.updateDamageArea(this.getRegion());
        this.redraw(this.getVisibility());
        if (this.scrollHandler_ != null) {
            this.scrollHandler_.updateScrollBars();
        }
    }

    public void setWorldExtent(double x0, double y0, double width, double height) {
        double[] w0 = new double[]{x0, y0, 0.0};
        double[] w1 = new double[]{x0 + width, y0, 0.0};
        double[] w2 = new double[]{x0, y0 + height, 0.0};
        this.setWorldExtent(w0, w1, w2);
    }

    GWorldExtent getInitialWorldExtent() {
        return this.initialWorldExtent_;
    }

    public GWorldExtent getWorldExtent() {
        return this.currentWorldExtent_;
    }

    private void adjustCurrentWorldExtent() {
        double newWorldHeight;
        double newWorldWidth;
        double worldHeight;
        if (this.shouldWorldExtentFitViewport_) {
            return;
        }
        double viewportWidth = this.viewport_.getWidth();
        double viewportHeight = this.viewport_.getHeight();
        double worldWidth = this.currentWorldExtent_.getWidth();
        if (worldWidth / (worldHeight = this.currentWorldExtent_.getHeight()) > viewportWidth / viewportHeight) {
            newWorldWidth = worldWidth;
            newWorldHeight = viewportHeight / viewportWidth * worldWidth;
        } else {
            newWorldWidth = viewportWidth / viewportHeight * worldHeight;
            newWorldHeight = worldHeight;
        }
        this.currentWorldExtent_.extendWidth(newWorldWidth);
        this.currentWorldExtent_.extendHeight(newWorldHeight);
    }

    private void updateRegion() {
        if (!this.viewport_.isSkewed()) {
            Rect rectangle = new Rect(this.viewport_.getX0(), this.viewport_.getY0(), (int)this.viewport_.getWidth(), (int)this.viewport_.getHeight());
            this.getRegion().set(rectangle);
        }
        this.flagRegionValid(true);
    }

    protected void resize(double dx, double dy) {
        if (this.isViewportFixed_) {
            return;
        }
        this.viewport_.resize(dx, dy);
        if (!this.shouldWorldExtentFitViewport_) {
            if (!this.shouldZoomOnResize_) {
                this.initialWorldExtent_.resize(dx, dy);
                this.currentWorldExtent_.resize(dx, dy);
            }
            this.adjustCurrentWorldExtent();
        }
        this.transformer_.update(this.viewport_, this.currentWorldExtent_);
        this.updateRegion();
        if (this.scrollHandler_ != null) {
            this.scrollHandler_.updateScrollBars();
        }
    }

    public void zoom(double zoomFactor) {
        double x = this.viewport_.getCenterX();
        double y = this.viewport_.getCenterY();
        this.zoom((int)Math.round(x), (int)Math.round(y), zoomFactor);
    }

    public void zoom(int x, int y, double zoomFactor) {
        int x0 = this.viewport_.getX0();
        int y0 = this.viewport_.getY0();
        int x1 = this.viewport_.getX3();
        int y1 = this.viewport_.getY3();
        double width = this.viewport_.getWidth();
        double height = this.viewport_.getHeight();
        x0 = (int)((double)x0 + (1.0 - zoomFactor) * (double)(x - x0));
        x1 = (int)((double)x1 - (1.0 - zoomFactor) * (double)(x1 - x));
        y0 = (int)((double)y0 + (1.0 - zoomFactor) * (double)(y - y0));
        y1 = (int)((double)y1 - (1.0 - zoomFactor) * (double)(y1 - y));
        this.zoom(x0, y0, x1, y1);
    }

    public void zoom(int x0, int y0, int x1, int y1) {
        int temp;
        if (x1 < x0) {
            temp = x1;
            x1 = x0;
            x0 = temp;
        }
        if (y1 < y0) {
            temp = y1;
            y1 = y0;
            y0 = temp;
        }
        double[] w0 = this.transformer_.deviceToWorld(x0, y1);
        double[] w1 = this.transformer_.deviceToWorld(x1, y1);
        double[] w2 = this.transformer_.deviceToWorld(x0, y0);
        this.zoom(w0, w1, w2);
    }

    public void zoom(double[] w0, double[] w1, double[] w2) {
        this.currentWorldExtent_.set(w0, w1, w2);
        this.window_.updateDamageArea(this.getRegion());
        this.adjustCurrentWorldExtent();
        this.transformer_.update(this.viewport_, this.currentWorldExtent_);
        this.window_.redraw();
        this.window_.refresh();
        if (this.scrollHandler_ != null) {
            this.scrollHandler_.updateScrollBars();
        }
    }

    public void unzoom() {
        this.zoom(this.initialWorldExtent_.get(0), this.initialWorldExtent_.get(1), this.initialWorldExtent_.get(2));
    }

    public void pan(int dx, int dy) {
        int x0 = this.viewport_.getX0() - dx;
        int y0 = this.viewport_.getY0() - dy;
        int x1 = this.viewport_.getX3() - dx;
        int y1 = this.viewport_.getY3() - dy;
        this.zoom(x0, y0, x1, y1);
    }

    void setAnnotationValid(boolean isAnnotationValid) {
        this.isAnnotationValid_ = isAnnotationValid;
    }

    boolean isAnnotationValid() {
        return this.isAnnotationValid_;
    }

    @Override
    void computeTextPositions() {
        this.annotator_.reset();
        super.computeTextPositions();
        this.isAnnotationValid_ = true;
    }

    @Override
    void computeComponentPositions() {
        super.computeComponentPositions();
    }

    void computePositions(Collection positionals) {
        this.annotator_.computePositions(positionals);
    }

    void computeVertexPositions(GPositional positional) {
        this.annotator_.computeVertexPositions(positional);
    }

    public void installScrollHandler(Adjustable hScrollBar, Adjustable vScrollBar) {
        this.scrollHandler_ = hScrollBar == null && vScrollBar == null ? null : new GScrollHandler(this, hScrollBar, vScrollBar);
    }
}

