/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import no.geosoft.cc.geometry.Rect;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;

abstract class GPositional {
    protected GSegment segment_;
    protected int positionHint_;
    protected Rect rectangle_ = new Rect();
    protected boolean isVisible_ = false;
    protected GStyle style_;
    protected GStyle actualStyle_;
    private final boolean isAllowingOverlaps_;

    GPositional(int positionHint, boolean isAllowingOverlaps) {
        this.isAllowingOverlaps_ = isAllowingOverlaps;
        this.segment_ = null;
        this.style_ = null;
        this.actualStyle_ = new GStyle();
        this.setPositionHint(positionHint);
    }

    void setSegment(GSegment segment) {
        this.segment_ = segment;
        this.updateStyle();
    }

    GSegment getSegment() {
        return this.segment_;
    }

    protected GObject getObject() {
        return this.segment_ != null ? this.segment_.getOwner() : null;
    }

    public void setPositionHint(int positionHint) {
        this.positionHint_ = positionHint;
        if ((this.positionHint_ & 0x1FF00) == 0) {
            if ((this.positionHint_ & 8) != 0) {
                this.positionHint_ |= 0x400;
            } else if ((this.positionHint_ & 0x10) != 0) {
                this.positionHint_ |= 0x8000;
            } else if ((this.positionHint_ & 0x20) != 0) {
                this.positionHint_ |= 0x1000;
            } else if ((this.positionHint_ & 0x40) != 0) {
                this.positionHint_ |= 0x2000;
            }
        }
        if ((this.positionHint_ & 0x20000) == 0 && (this.positionHint_ & 0x40000) == 0) {
            this.positionHint_ |= 0x20000;
        }
    }

    public int getPositionHint() {
        return this.positionHint_;
    }

    boolean isAllowingOverlaps() {
        return this.isAllowingOverlaps_;
    }

    boolean isLinePositional() {
        return (this.positionHint_ & 0xFE) != 0;
    }

    boolean isVisible() {
        return this.isVisible_;
    }

    void setVisible(boolean isVisible) {
        this.isVisible_ = isVisible;
    }

    Rect getRectangle() {
        return this.rectangle_;
    }

    abstract void computeSize();

    int getMargin() {
        return 0;
    }

    public void setStyle(GStyle style) {
        this.style_ = style;
        this.updateStyle();
    }

    public GStyle getStyle() {
        return this.style_;
    }

    GStyle getActualStyle() {
        return this.actualStyle_;
    }

    void updateStyle() {
        GObject object;
        GScene scene;
        this.actualStyle_ = new GStyle();
        if (this.segment_ != null) {
            this.actualStyle_.update(this.segment_.getActualStyle());
        }
        if (this.style_ != null) {
            this.actualStyle_.update(this.style_);
        }
        GScene gScene = scene = (object = this.getObject()) != null ? object.getScene() : null;
        if (object != null) {
            object.flagRegionValid(false);
        }
        if (scene != null) {
            scene.setAnnotationValid(false);
        }
        this.updateDamage();
    }

    void updateDamage() {
        GObject object = this.getObject();
        if (this.isVisible() && this.rectangle_ != null && !this.rectangle_.isEmpty() && object != null && object.getWindow() != null) {
            object.getWindow().updateDamageArea(this.rectangle_);
        }
    }
}

