/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import no.geosoft.cc.geometry.Rect;
import no.geosoft.cc.geometry.Region;
import no.geosoft.cc.graphics.GComponent;
import no.geosoft.cc.graphics.GImage;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GWindow;
import no.geosoft.cc.io.GifEncoder;

class GCanvas
extends JComponent
implements Printable,
LayoutManager,
MouseListener,
MouseMotionListener,
ComponentListener {
    private final GWindow window_;
    private final RepaintManager repaintManager_;
    private Graphics graphics_;
    private Image backBuffer_;
    private Area clipArea_;
    private Rect cleared_;

    GCanvas(GWindow window) {
        this.window_ = window;
        this.setLayout(this);
        this.repaintManager_ = RepaintManager.currentManager(this);
        this.repaintManager_.setDoubleBufferingEnabled(true);
        this.backBuffer_ = null;
        this.clipArea_ = null;
        this.cleared_ = null;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    @Override
    public void repaint() {
    }

    @Override
    public void update(Graphics graphics) {
    }

    private void createBackBuffer() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        this.backBuffer_ = this.createImage(width, height);
        if (this.backBuffer_ != null) {
            Graphics2D canvas = (Graphics2D)this.backBuffer_.getGraphics();
            canvas.setColor(this.getBackground());
            canvas.fillRect(0, 0, width, height);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.backBuffer_ == null || graphics == null || this.cleared_ == null) {
            return;
        }
        this.graphics_ = graphics;
        Graphics2D frontBuffer = (Graphics2D)this.graphics_;
        frontBuffer.drawImage(this.backBuffer_, this.cleared_.x, this.cleared_.y, this.cleared_.width, this.cleared_.height, this.cleared_.x, this.cleared_.y, this.cleared_.width, this.cleared_.height, this);
        if (this.repaintManager_.getDirtyRegion(this).isEmpty()) {
            return;
        }
        this.repaintManager_.paintDirtyRegions();
        this.repaintManager_.markCompletelyClean(this);
        this.cleared_ = null;
    }

    void clear(Rect rectangle) {
        if (this.graphics_ == null || this.backBuffer_ == null) {
            return;
        }
        Graphics2D canvas = (Graphics2D)this.backBuffer_.getGraphics();
        canvas.setClip(this.clipArea_);
        canvas.setColor(this.getBackground());
        canvas.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void refresh() {
        this.paintComponent(this.getGraphics());
    }

    void setClipArea(Region region) {
        this.clipArea_ = region == null || region.isEmpty() ? null : region.createArea();
    }

    void render(int[] x, int[] y, GStyle style) {
        if (this.backBuffer_ == null) {
            this.createBackBuffer();
        }
        if (this.backBuffer_ == null) {
            return;
        }
        Graphics2D canvas = (Graphics2D)this.backBuffer_.getGraphics();
        canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, style.isAntialiased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        canvas.setColor(style.getForegroundColor());
        canvas.setStroke(style.getStroke());
        canvas.setClip(this.clipArea_);
        Paint paint = style.getPaint();
        if (paint != null) {
            Paint defaultPaint = canvas.getPaint();
            canvas.setPaint(paint);
            canvas.fill(new Polygon(x, y, x.length));
            canvas.setPaint(defaultPaint);
            if (style.isLineVisible()) {
                canvas.drawPolyline(x, y, x.length);
            }
        } else if (style.isLineVisible()) {
            canvas.drawPolyline(x, y, x.length);
        }
    }

    void render(GText text, GStyle style) {
        if (this.backBuffer_ == null) {
            return;
        }
        String string = text.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        Graphics2D canvas = (Graphics2D)this.backBuffer_.getGraphics();
        canvas.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, style.isAntialiased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        canvas.setFont(style.getFont());
        int fontSize = style.getFont().getSize();
        Color foregroundColor = style.getForegroundColor();
        Color backgroundColor = style.getBackgroundColor();
        Rect rectangle = text.getRectangle();
        if (backgroundColor != null) {
            canvas.setColor(backgroundColor);
            canvas.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        canvas.setColor(foregroundColor);
        TextLayout layout = new TextLayout(text.getText(), style.getFont(), canvas.getFontRenderContext());
        Rectangle2D bounds = layout.getBounds();
        double textWidth = bounds.getWidth();
        double textHeight = bounds.getHeight();
        int x = rectangle.x + (int)Math.round(((double)rectangle.width - textWidth) / 2.0) - (int)Math.floor(bounds.getX());
        int y = rectangle.y + (int)Math.round(((double)rectangle.height - textHeight) / 2.0) - (int)Math.floor(bounds.getY());
        layout.draw(canvas, x, y);
    }

    void render(GImage image) {
        Graphics2D canvas = (Graphics2D)this.backBuffer_.getGraphics();
        Rect rectangle = image.getRectangle();
        canvas.drawImage(image.getImage(), rectangle.x, rectangle.y, this);
    }

    void render(int[] x, int[] y, GImage image) {
        Graphics2D canvas = (Graphics2D)this.backBuffer_.getGraphics();
        int dx = image.getRectangle().x;
        int dy = image.getRectangle().y;
        int nPoints = x.length;
        for (int i = 0; i < nPoints; ++i) {
            canvas.drawImage(image.getImage(), x[i] + dx, y[i] + dy, this);
        }
    }

    void render(GComponent component) {
        Component c = component.getComponent();
        c.setLocation(component.getRectangle().x, component.getRectangle().y);
        if (!this.isAncestorOf(c)) {
            this.add(c);
        }
    }

    Rect getStringBox(String string, Font font) {
        Graphics2D graphics = (Graphics2D)this.getGraphics();
        if (graphics == null) {
            return new Rect(0, 0, 0, 0);
        }
        TextLayout textLayout = new TextLayout(string, font, graphics.getFontRenderContext());
        Rectangle2D bounds = textLayout.getBounds();
        int width = (int)Math.ceil(bounds.getWidth());
        int height = (int)Math.ceil(bounds.getHeight());
        return new Rect(0, 0, width, height);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D paper = (Graphics2D)graphics;
        paper.drawImage(this.backBuffer_, 0, 0, this.getWidth(), this.getHeight(), this);
        return 0;
    }

    void saveAsGif(File file) throws IOException {
        try {
            GifEncoder gifEncoder = new GifEncoder(this.backBuffer_);
            FileOutputStream stream = new FileOutputStream(file);
            gifEncoder.write(stream);
            ((OutputStream)stream).close();
        }
        catch (AWTException exception) {
            throw new IOException("Failed to save as GIF");
        }
    }

    void save(File file, String format) throws IOException {
        ImageIO.write((RenderedImage)((BufferedImage)this.backBuffer_), format, file);
    }

    boolean print() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this);
            printerJob.print();
            return true;
        }
        catch (PrinterException exception) {
            return false;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            int x = component.getX();
            int y = component.getY();
            int width = component.getPreferredSize().width;
            int height = component.getPreferredSize().height;
            component.setBounds(x, y, width, height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.window_.mouseEntered(event.getX(), event.getY());
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.window_.mouseExited(event.getX(), event.getY());
    }

    @Override
    public void mousePressed(MouseEvent event) {
        int modifiers = event.getModifiers();
        int buttonEvent = modifiers == 16 ? 3 : (modifiers == 8 ? 7 : 11);
        this.window_.mousePressed(buttonEvent, event.getX(), event.getY());
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        int modifiers = event.getModifiers();
        int buttonEvent = modifiers == 16 ? 5 : (modifiers == 8 ? 9 : 13);
        this.window_.mouseReleased(buttonEvent, event.getX(), event.getY());
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int modifiers = event.getModifiers();
        int buttonEvent = modifiers == 16 ? 4 : (modifiers == 8 ? 8 : 12);
        this.window_.mouseDragged(buttonEvent, event.getX(), event.getY());
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.window_.mouseMoved(event.getX(), event.getY());
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.createBackBuffer();
        this.cleared_ = new Rect(0, 0, this.getWidth(), this.getHeight());
        this.window_.resize();
    }
}

