/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.util.Collection;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.geometry.Rect;
import no.geosoft.cc.geometry.Region;
import no.geosoft.cc.graphics.GPositional;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GViewport;

class GAnnotator {
    private static final int MAX_ATTEMTS = 300;
    private static final double DLENGTH = 8.0;
    private final GScene scene_;
    private final Region region_ = new Region();
    private int vx0_;
    private int vy0_;
    private int vx1_;
    private int vy1_;
    private int vx2_;
    private int vy2_;
    private int vx3_;
    private int vy3_;
    private double distance_;

    GAnnotator(GScene scene) {
        this.scene_ = scene;
    }

    void reset() {
        this.region_.set(this.scene_.getRegion());
        GViewport viewport = this.scene_.getViewport();
        int[] p0 = viewport.getP0();
        int[] p1 = viewport.getP1();
        int[] p2 = viewport.getP2();
        this.vx0_ = p0[0];
        this.vy0_ = p0[1];
        this.vx1_ = p1[0];
        this.vy1_ = p1[1];
        this.vx2_ = p2[0];
        this.vy2_ = p2[1];
        this.vx3_ = this.vx2_ + this.vx1_ - this.vx0_;
        this.vy3_ = this.vy1_ + this.vy2_ - this.vy0_;
    }

    void computePositions(Collection positionals) {
        if (positionals == null) {
            return;
        }
        int objectNo = 0;
        for (GPositional positional : positionals) {
            GSegment segment = positional.getSegment();
            int positionHint = positional.getPositionHint();
            Rect oldRectangle = new Rect(positional.getRectangle());
            boolean wasVisible = positional.isVisible();
            if (segment.isVisible()) {
                int[] x = segment.getX();
                int[] y = segment.getY();
                int x0 = segment.getCenterX();
                int y0 = segment.getCenterY();
                positional.computeSize();
                if (positional.getRectangle().isEmpty()) {
                    positional.setVisible(false);
                    continue;
                }
                int pointNo = this.findPreferredPosition(positional, x, y, x0, y0, objectNo);
                if ((positionHint & 0x20000) != 0 && (positionHint & 0x80) == 0) {
                    positional.setVisible(true);
                    this.distance_ = 0.0;
                    if (!this.scene_.getRegion().isInside(positional.getRectangle().x, positional.getRectangle().y)) {
                        pointNo = this.moveInsideWindow(positional, x, y, pointNo);
                    }
                } else {
                    positional.setVisible(this.scene_.getRegion().isInside(positional.getRectangle().x, positional.getRectangle().y));
                }
                if (positional.isVisible()) {
                    this.adjustPosition(positional);
                    if ((positionHint & 0x40000) != 0 | (positionHint & 0x80) != 0) {
                        positional.setVisible(this.region_.isIntersecting(positional.getRectangle()));
                    } else if (!positional.isAllowingOverlaps() && !this.region_.isInside(positional.getRectangle())) {
                        this.findNonOverlappingPosition(positional, x, y, pointNo);
                    }
                }
            }
            if (!oldRectangle.equals(positional.getRectangle())) {
                if (wasVisible) {
                    this.scene_.getWindow().updateDamageArea(oldRectangle);
                }
                if (positional.isVisible()) {
                    this.scene_.getWindow().updateDamageArea(positional.getRectangle());
                }
                if (wasVisible || positional.isVisible()) {
                    segment.getOwner().flagRegionValid(false);
                }
            }
            if (positional.isVisible() && (positional.getPositionHint() & 0x40000) == 0 && !positional.isAllowingOverlaps()) {
                this.region_.subtract(positional.getRectangle());
            }
            if (positional.isLinePositional()) continue;
            ++objectNo;
        }
    }

    private int findPreferredPosition(GPositional positional, int[] x, int[] y, int x0, int y0, int pointNo) {
        int positionHint = positional.getPositionHint();
        int nPoints = x.length;
        if (positional.isLinePositional()) {
            if ((positionHint & 4) != 0) {
                pointNo = nPoints - 1;
            } else {
                if ((positionHint & 0x80) != 0) {
                    positional.getRectangle().x = x0;
                    positional.getRectangle().y = y0;
                    return -1;
                }
                if ((positionHint & 8) != 0) {
                    int yMin = y[0];
                    for (int i = 0; i < nPoints; ++i) {
                        if (y[i] >= yMin) continue;
                        yMin = y[i];
                        pointNo = i;
                    }
                } else if ((positionHint & 0x10) != 0) {
                    int yMax = y[0];
                    for (int i = 0; i < nPoints; ++i) {
                        if (y[i] <= yMax) continue;
                        yMax = y[i];
                        pointNo = i;
                    }
                } else if ((positionHint & 0x20) != 0) {
                    int xMin = x[0];
                    for (int i = 0; i < nPoints; ++i) {
                        if (x[i] >= xMin) continue;
                        xMin = x[i];
                        pointNo = i;
                    }
                } else if ((positionHint & 0x40) != 0) {
                    int xMax = x[0];
                    for (int i = 0; i < nPoints; ++i) {
                        if (x[i] <= xMax) continue;
                        xMax = x[i];
                        pointNo = i;
                    }
                }
            }
        }
        positional.getRectangle().x = x[pointNo];
        positional.getRectangle().y = y[pointNo];
        return pointNo;
    }

    private void adjustPosition(GPositional positional) {
        int positionHint = positional.getPositionHint();
        int x = positional.getRectangle().x;
        int y = positional.getRectangle().y;
        int width = positional.getRectangle().width;
        int height = positional.getRectangle().height;
        int halfWidth = (int)Math.ceil((double)width / 2.0);
        int halfHeight = (int)Math.ceil((double)height / 2.0);
        if ((positionHint & 0x200) != 0) {
            x -= width + positional.getMargin();
            y -= height + positional.getMargin();
        } else if ((positionHint & 0x800) != 0) {
            x += positional.getMargin();
            y -= height + positional.getMargin();
        } else if ((positionHint & 0x4000) != 0) {
            x -= width + positional.getMargin();
            y += positional.getMargin();
        } else if ((positionHint & 0x10000) != 0) {
            x += positional.getMargin();
            y += positional.getMargin();
        } else if ((positionHint & 0x400) != 0) {
            x -= halfWidth;
            y -= height + positional.getMargin();
        } else if ((positionHint & 0x1000) != 0) {
            x -= width + positional.getMargin();
            y -= halfHeight;
        } else if ((positionHint & 0x2000) != 0) {
            x += positional.getMargin();
            y -= halfHeight;
        } else if ((positionHint & 0x8000) != 0) {
            x -= halfWidth;
            y += positional.getMargin();
        } else {
            x -= halfWidth;
            y -= halfHeight;
        }
        positional.getRectangle().x = x;
        positional.getRectangle().y = y;
    }

    private void findNonOverlappingPosition(GPositional positional, int[] x, int[] y, int pointNo) {
        int y0;
        int x0;
        if (this.distance_ == 0.0) {
            x0 = x[pointNo];
            y0 = y[pointNo];
        } else {
            double legLength = Geometry.length(x[pointNo], y[pointNo], x[pointNo + 1], y[pointNo + 1]);
            double fraction = this.distance_ / legLength;
            x0 = (int)Math.round((double)x[pointNo] + fraction * (double)(x[pointNo + 1] - x[pointNo]));
            y0 = (int)Math.round((double)y[pointNo] + fraction * (double)(y[pointNo + 1] - y[pointNo]));
        }
        double totalLength = 0.0;
        for (int i = 0; i < pointNo; ++i) {
            totalLength += Geometry.length(x[i], y[i], x[i + 1], y[i + 1]);
        }
        totalLength += this.distance_;
        boolean isDoneLeft = false;
        boolean isDoneRight = false;
        int nAttempts = 0;
        boolean isDone = false;
        double left = totalLength -= 8.0;
        double right = totalLength += 8.0;
        int[] leftPosition = new int[]{x0, y0};
        int[] rightPosition = new int[]{x0, y0};
        int[] position = new int[2];
        Rect leftRectangle = new Rect(positional.getRectangle());
        Rect rightRectangle = new Rect(positional.getRectangle());
        while (!isDone) {
            int dy;
            int dx;
            if (!isDoneLeft) {
                boolean bl = isDoneLeft = !Geometry.findPolygonPosition(x, y, left, position);
                if (!isDoneLeft) {
                    dx = leftPosition[0] - position[0];
                    dy = leftPosition[1] - position[1];
                    leftRectangle.x -= dx;
                    leftRectangle.y -= dy;
                    if (this.region_.isInside(leftRectangle)) {
                        positional.getRectangle().copy(leftRectangle);
                        return;
                    }
                }
                leftPosition[0] = position[0];
                leftPosition[1] = position[1];
                ++nAttempts;
            }
            if (!isDoneRight) {
                boolean bl = isDoneRight = !Geometry.findPolygonPosition(x, y, right, position);
                if (!isDoneRight) {
                    dx = rightPosition[0] - position[0];
                    dy = rightPosition[1] - position[1];
                    rightRectangle.x -= dx;
                    rightRectangle.y -= dy;
                    if (this.region_.isInside(rightRectangle)) {
                        positional.getRectangle().copy(rightRectangle);
                        return;
                    }
                }
                rightPosition[0] = position[0];
                rightPosition[1] = position[1];
                ++nAttempts;
            }
            left -= 8.0;
            right += 8.0;
            isDone = isDoneLeft && isDoneRight || nAttempts > 300;
        }
        positional.setVisible(false);
    }

    private int moveInsideWindow(GPositional positional, int[] x, int[] y, int pointNo) {
        int iPoint;
        int[] intersection = null;
        for (iPoint = pointNo - 1; iPoint >= 0 && (intersection = this.findViewportIntersection(x[iPoint + 1], y[iPoint + 1], x[iPoint], y[iPoint])) == null; --iPoint) {
        }
        if (intersection == null) {
            for (iPoint = pointNo; iPoint < x.length - 1 && (intersection = this.findViewportIntersection(x[iPoint], y[iPoint], x[iPoint + 1], y[iPoint + 1])) == null; ++iPoint) {
            }
        }
        if (intersection == null) {
            positional.setVisible(false);
        } else {
            positional.setVisible(true);
            positional.getRectangle().x = intersection[0];
            positional.getRectangle().y = intersection[1];
            this.distance_ = Geometry.length(intersection[0], intersection[1], x[iPoint], y[iPoint]);
        }
        return iPoint;
    }

    private int[] findViewportIntersection(int x0, int y0, int x1, int y1) {
        double[] length = new double[2];
        int[] x = new int[2];
        int[] y = new int[2];
        double[] intersection = new double[2];
        int[] result = new int[2];
        int n = 0;
        int type = Geometry.findLineSegmentIntersection(x0, y0, x1, y1, this.vx0_, this.vy0_, this.vx1_, this.vy1_, intersection);
        if ((long)type == 1L) {
            x[n] = (int)Math.round(intersection[0]);
            y[n] = (int)Math.round(intersection[1]);
            length[n] = Geometry.length(x0, y0, x[n], y[n]);
            ++n;
        }
        if ((type = Geometry.findLineSegmentIntersection(x0, y0, x1, y1, this.vx0_, this.vy0_, this.vx2_, this.vy2_, intersection)) == 1) {
            x[n] = (int)Math.round(intersection[0]);
            y[n] = (int)Math.round(intersection[1]);
            length[n] = Geometry.length(x0, y0, x[n], y[n]);
            ++n;
        }
        if (n < 2 && (type = Geometry.findLineSegmentIntersection(x0, y0, x1, y1, this.vx1_, this.vy1_, this.vx3_, this.vy3_, intersection)) == 1) {
            x[n] = (int)Math.round(intersection[0]);
            y[n] = (int)Math.round(intersection[1]);
            length[n] = Geometry.length(x0, y0, x[n], y[n]);
            ++n;
        }
        if (n < 2 && (type = Geometry.findLineSegmentIntersection(x0, y0, x1, y1, this.vx2_, this.vy2_, this.vx3_, this.vy3_, intersection)) == 1) {
            x[n] = (int)Math.round(intersection[0]);
            y[n] = (int)Math.round(intersection[1]);
            length[n] = Geometry.length(x0, y0, x[n], y[n]);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            result[0] = x[0];
            result[1] = y[0];
        } else if (length[0] < length[1]) {
            result[0] = x[0];
            result[1] = y[0];
        } else {
            result[0] = x[1];
            result[1] = y[1];
        }
        return result;
    }

    void computeVertexPositions(GPositional positional) {
        int y;
        int x;
        positional.computeSize();
        int width = positional.getRectangle().width;
        int height = positional.getRectangle().height;
        int positionHint = positional.getPositionHint();
        if ((positionHint & 0x400) != 0) {
            x = -((int)Math.floor((double)width / 2.0));
            y = -height;
        } else if ((positionHint & 0x8000) != 0) {
            x = -((int)Math.floor((double)width / 2.0));
            y = 0;
        } else if ((positionHint & 0x1000) != 0) {
            x = -width;
            y = -((int)Math.floor((double)height / 2.0));
        } else if ((positionHint & 0x2000) != 0) {
            y = -((int)Math.floor((double)height / 2.0));
            x = 0;
        } else if ((positionHint & 0x200) != 0) {
            x = -width;
            y = -height;
        } else if ((positionHint & 0x800) != 0) {
            x = 0;
            y = -height;
        } else if ((positionHint & 0x4000) != 0) {
            x = -width;
            y = 0;
        } else if ((positionHint & 0x10000) != 0) {
            x = 0;
            y = 0;
        } else {
            x = -((int)Math.floor((double)width / 2.0));
            y = -((int)Math.floor((double)height / 2.0));
        }
        positional.getRectangle().x = x;
        positional.getRectangle().y = y;
    }
}

