/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry;

import java.awt.Rectangle;
import java.awt.geom.Area;
import no.geosoft.cc.geometry.Box;
import no.geosoft.cc.geometry.Rect;

public class Region
implements Cloneable {
    private static final int OPERATION_UNION = 0;
    private static final int OPERATION_INTERSECTION = 1;
    private static final int OPERATION_SUBTRACTION = 2;
    private static final int OPERATION_XOR = 3;
    private static final int INITIAL_SIZE = 40;
    private static int[] gRectangles_ = new int[40];
    private static int gNRectangles_ = 0;
    private static boolean isLocked_ = false;
    private Box extent_;
    private int[] rectangles_;
    private int nRectangles_;

    public Region() {
        this.extent_ = new Box(0, 0, 0, 0);
        this.rectangles_ = new int[40];
        this.nRectangles_ = 0;
    }

    public Region(int[] x, int[] y) {
    }

    public Region(Rect rectangle) {
        this();
        this.set(rectangle);
    }

    public Region(int x, int y, int width, int height) {
        this(new Rect(x, y, width, height));
    }

    public Region(Box box) {
        this(new Rect(box));
    }

    public Region(Region region) {
        this.extent_ = new Box();
        this.rectangles_ = new int[region.nRectangles_ << 2];
        this.set(region);
    }

    public Object clone() {
        return new Region(this);
    }

    public Area createArea() {
        if (this.nRectangles_ == 0) {
            return null;
        }
        Rectangle rectangle = new Rectangle(this.rectangles_[2], this.rectangles_[0], this.rectangles_[3] - this.rectangles_[2], this.rectangles_[1] - this.rectangles_[0]);
        Area area = new Area(rectangle);
        for (int i = 1; i < this.nRectangles_; ++i) {
            int j = i * 4;
            rectangle = new Rectangle(this.rectangles_[j + 2], this.rectangles_[j + 0], this.rectangles_[j + 3] - this.rectangles_[j + 2], this.rectangles_[j + 1] - this.rectangles_[j + 0]);
            area.add(new Area(rectangle));
        }
        return area;
    }

    private static void checkMemory(Region region, int nRectangles) {
        int nEntries = nRectangles << 2;
        if (region == null) {
            if (gRectangles_.length < nEntries) {
                int newSize = nEntries * 2;
                int[] newArray = new int[newSize];
                System.arraycopy(gRectangles_, 0, newArray, 0, gRectangles_.length);
                gRectangles_ = newArray;
            }
        } else if (region.rectangles_.length < nEntries) {
            int newSize = nEntries * 2;
            int[] newArray = new int[newSize];
            System.arraycopy(region.rectangles_, 0, newArray, 0, region.rectangles_.length);
            region.rectangles_ = newArray;
        }
    }

    public void set(Region region) {
        this.extent_.copy(region.extent_);
        Region.checkMemory(this, region.nRectangles_);
        System.arraycopy(region.rectangles_, 0, this.rectangles_, 0, region.nRectangles_ << 2);
        this.nRectangles_ = region.nRectangles_;
    }

    public void set(Rect rectangle) {
        this.rectangles_ = new int[40];
        if (rectangle.isEmpty()) {
            this.extent_ = new Box();
            this.nRectangles_ = 0;
        } else {
            this.extent_ = new Box(rectangle);
            this.rectangles_[0] = this.extent_.y1;
            this.rectangles_[1] = this.extent_.y2;
            this.rectangles_[2] = this.extent_.x1;
            this.rectangles_[3] = this.extent_.x2;
            this.nRectangles_ = 1;
        }
    }

    public void clear() {
        this.nRectangles_ = 0;
        this.extent_.set(0, 0, 0, 0);
    }

    public boolean equals(Object object) {
        Region region = (Region)object;
        if (this.nRectangles_ != region.nRectangles_) {
            return false;
        }
        if (this.nRectangles_ == 0) {
            return true;
        }
        if (this.extent_.x1 != region.extent_.x1) {
            return false;
        }
        if (this.extent_.x2 != region.extent_.x2) {
            return false;
        }
        if (this.extent_.y1 != region.extent_.y1) {
            return false;
        }
        if (this.extent_.y2 != region.extent_.y2) {
            return false;
        }
        for (int i = 0; i < this.nRectangles_ << 2; ++i) {
            if (this.rectangles_[i] == region.rectangles_[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.nRectangles_ == 0;
    }

    public void offset(int dx, int dy) {
        for (int i = 0; i < this.rectangles_.length; i += 4) {
            int n = i + 0;
            this.rectangles_[n] = this.rectangles_[n] + dy;
            int n2 = i + 1;
            this.rectangles_[n2] = this.rectangles_[n2] + dy;
            int n3 = i + 2;
            this.rectangles_[n3] = this.rectangles_[n3] + dx;
            int n4 = i + 3;
            this.rectangles_[n4] = this.rectangles_[n4] + dx;
        }
        this.extent_.offset(dx, dy);
    }

    public boolean isIntersecting(Region region) {
        Region r = (Region)this.clone();
        r.intersect(region);
        return !r.isEmpty();
    }

    public boolean isIntersecting(Rect rectangle) {
        Region region = new Region(rectangle);
        return this.isIntersecting(region);
    }

    public boolean isInside(int x, int y) {
        int i;
        if (this.isEmpty()) {
            return false;
        }
        if (!this.extent_.isInside(x, y)) {
            return false;
        }
        int rEnd = this.nRectangles_ << 2;
        for (i = 0; i < rEnd && this.rectangles_[i + 1] < y; i += 4) {
            if (this.rectangles_[i] <= y) continue;
            return false;
        }
        while (i < rEnd && this.rectangles_[i] <= y) {
            if (x >= this.rectangles_[i + 2] && x < this.rectangles_[i + 3]) {
                return true;
            }
            i += 4;
        }
        return false;
    }

    public boolean isInside(Rect rectangle) {
        if (this.isEmpty() || rectangle.isEmpty()) {
            return false;
        }
        if (!this.extent_.isOverlapping(rectangle)) {
            return false;
        }
        int x1 = rectangle.x;
        int x2 = rectangle.x + rectangle.width;
        int y1 = rectangle.y;
        int y2 = rectangle.y + rectangle.height;
        int rEnd = this.nRectangles_ << 2;
        if (this.rectangles_[0] > y1) {
            return false;
        }
        int i = 0;
        while (i < rEnd && this.rectangles_[i + 1] <= y1) {
            if (this.rectangles_[i += 4] <= y1) continue;
            return false;
        }
        while (i < rEnd) {
            int yTop = this.rectangles_[i];
            int yBottom = this.rectangles_[i + 1];
            while (i < rEnd && this.rectangles_[i + 3] <= x1) {
                if (this.rectangles_[i += 4] <= yTop) continue;
                return false;
            }
            if (i == rEnd) {
                return false;
            }
            if (x1 < this.rectangles_[i + 2] || x2 > this.rectangles_[i + 3]) {
                return false;
            }
            if (this.rectangles_[i + 1] >= y2) {
                return true;
            }
            i += 4;
            while (i < rEnd && this.rectangles_[i] == yTop) {
                i += 4;
            }
            if (i == rEnd) {
                return false;
            }
            if (this.rectangles_[i] <= yBottom) continue;
            return false;
        }
        return false;
    }

    public boolean isInsideOf(Rect rectangle) {
        return Region.subtract(this, rectangle).isEmpty();
    }

    public Rect getExtent() {
        return new Rect(this.extent_);
    }

    public int getNRectangles() {
        return this.nRectangles_;
    }

    public void collapse() {
        this.rectangles_[0] = this.extent_.y1;
        this.rectangles_[1] = this.extent_.y2;
        this.rectangles_[2] = this.extent_.x1;
        this.rectangles_[3] = this.extent_.x2;
        this.nRectangles_ = 1;
    }

    private void combine(Region region, int operationType) {
        int bottom;
        int top;
        int r2BandEnd;
        int r1BandEnd;
        int currentBand;
        while (isLocked_) {
        }
        isLocked_ = true;
        int r1 = 0;
        int r2 = 0;
        int r1End = this.nRectangles_ << 2;
        int r2End = region.nRectangles_ << 2;
        gNRectangles_ = 0;
        int yTop = 0;
        int yBottom = this.extent_.y1 < region.extent_.y1 ? this.extent_.y1 : region.extent_.y1;
        int previousBand = 0;
        do {
            currentBand = gNRectangles_;
            for (r1BandEnd = r1 + 4; r1BandEnd != r1End && this.rectangles_[r1BandEnd] == this.rectangles_[r1]; r1BandEnd += 4) {
            }
            for (r2BandEnd = r2 + 4; r2BandEnd != r2End && region.rectangles_[r2BandEnd] == region.rectangles_[r2]; r2BandEnd += 4) {
            }
            if (this.rectangles_[r1] < region.rectangles_[r2]) {
                top = Math.max(this.rectangles_[r1], yBottom);
                if (top != (bottom = Math.min(this.rectangles_[r1 + 1], region.rectangles_[r2]))) {
                    this.nonOverlap1(this.rectangles_, r1, r1BandEnd, top, bottom, operationType);
                }
                yTop = region.rectangles_[r2];
            } else if (region.rectangles_[r2] < this.rectangles_[r1]) {
                top = Math.max(region.rectangles_[r2], yBottom);
                if (top != (bottom = Math.min(region.rectangles_[r2 + 1], this.rectangles_[r1]))) {
                    this.nonOverlap2(region.rectangles_, r2, r2BandEnd, top, bottom, operationType);
                }
                yTop = this.rectangles_[r1];
            } else {
                yTop = this.rectangles_[r1];
            }
            if (gNRectangles_ != currentBand) {
                previousBand = this.coalesceBands(previousBand, currentBand);
            }
            currentBand = gNRectangles_;
            yBottom = Math.min(this.rectangles_[r1 + 1], region.rectangles_[r2 + 1]);
            if (yBottom > yTop) {
                this.overlap(this.rectangles_, r1, r1BandEnd, region.rectangles_, r2, r2BandEnd, yTop, yBottom, operationType);
            }
            if (gNRectangles_ != currentBand) {
                previousBand = this.coalesceBands(previousBand, currentBand);
            }
            if (this.rectangles_[r1 + 1] == yBottom) {
                r1 = r1BandEnd;
            }
            if (region.rectangles_[r2 + 1] != yBottom) continue;
            r2 = r2BandEnd;
        } while (r1 != r1End && r2 != r2End);
        currentBand = gNRectangles_;
        if (r1 != r1End) {
            do {
                for (r1BandEnd = r1; r1BandEnd < r1End && this.rectangles_[r1BandEnd] == this.rectangles_[r1]; r1BandEnd += 4) {
                }
                top = Math.max(this.rectangles_[r1], yBottom);
                bottom = this.rectangles_[r1 + 1];
                this.nonOverlap1(this.rectangles_, r1, r1BandEnd, top, bottom, operationType);
            } while ((r1 = r1BandEnd) != r1End);
        } else if (r2 != r2End) {
            do {
                for (r2BandEnd = r2; r2BandEnd < r2End && region.rectangles_[r2BandEnd] == region.rectangles_[r2]; r2BandEnd += 4) {
                }
                top = Math.max(region.rectangles_[r2], yBottom);
                bottom = region.rectangles_[r2 + 1];
                this.nonOverlap2(region.rectangles_, r2, r2BandEnd, top, bottom, operationType);
            } while ((r2 = r2BandEnd) != r2End);
        }
        if (currentBand != gNRectangles_) {
            this.coalesceBands(previousBand, currentBand);
        }
        Region.checkMemory(this, gNRectangles_);
        System.arraycopy(gRectangles_, 0, this.rectangles_, 0, gNRectangles_ << 2);
        this.nRectangles_ = gNRectangles_;
        isLocked_ = false;
    }

    private void nonOverlap1(int[] rectangles, int r, int rEnd, int yTop, int yBottom, int operationType) {
        int i = gNRectangles_ << 2;
        if (operationType == 0 || operationType == 2) {
            while (r != rEnd) {
                Region.checkMemory(null, gNRectangles_ + 1);
                Region.gRectangles_[i] = yTop;
                Region.gRectangles_[++i] = yBottom;
                Region.gRectangles_[++i] = rectangles[r + 2];
                Region.gRectangles_[++i] = rectangles[r + 3];
                ++i;
                ++gNRectangles_;
                r += 4;
            }
        }
    }

    private void nonOverlap2(int[] rectangles, int r, int rEnd, int yTop, int yBottom, int operationType) {
        int i = gNRectangles_ << 2;
        if (operationType == 0) {
            while (r != rEnd) {
                Region.checkMemory(null, gNRectangles_ + 1);
                Region.gRectangles_[i] = yTop;
                Region.gRectangles_[++i] = yBottom;
                Region.gRectangles_[++i] = rectangles[r + 2];
                Region.gRectangles_[++i] = rectangles[r + 3];
                ++i;
                ++gNRectangles_;
                r += 4;
            }
        }
    }

    private void overlap(int[] rectangles1, int r1, int r1End, int[] rectangles2, int r2, int r2End, int yTop, int yBottom, int operationType) {
        block29: {
            block30: {
                block28: {
                    int i = gNRectangles_ << 2;
                    if (operationType != 0) break block28;
                    while (r1 != r1End && r2 != r2End) {
                        if (rectangles1[r1 + 2] < rectangles2[r2 + 2]) {
                            if (gNRectangles_ > 0 && gRectangles_[i - 4] == yTop && gRectangles_[i - 3] == yBottom && gRectangles_[i - 1] >= rectangles1[r1 + 2]) {
                                if (gRectangles_[i - 1] < rectangles1[r1 + 3]) {
                                    Region.gRectangles_[i - 1] = rectangles1[r1 + 3];
                                }
                            } else {
                                Region.checkMemory(null, gNRectangles_ + 1);
                                Region.gRectangles_[i] = yTop;
                                Region.gRectangles_[i + 1] = yBottom;
                                Region.gRectangles_[i + 2] = rectangles1[r1 + 2];
                                Region.gRectangles_[i + 3] = rectangles1[r1 + 3];
                                i += 4;
                                ++gNRectangles_;
                            }
                            r1 += 4;
                            continue;
                        }
                        if (gNRectangles_ > 0 && gRectangles_[i - 4] == yTop && gRectangles_[i - 3] == yBottom && gRectangles_[i - 1] >= rectangles2[r2 + 2]) {
                            if (gRectangles_[i - 1] < rectangles2[r2 + 3]) {
                                Region.gRectangles_[i - 1] = rectangles2[r2 + 3];
                            }
                        } else {
                            Region.checkMemory(null, gNRectangles_ + 1);
                            Region.gRectangles_[i] = yTop;
                            Region.gRectangles_[i + 1] = yBottom;
                            Region.gRectangles_[i + 2] = rectangles2[r2 + 2];
                            Region.gRectangles_[i + 3] = rectangles2[r2 + 3];
                            i += 4;
                            ++gNRectangles_;
                        }
                        r2 += 4;
                    }
                    if (r1 != r1End) {
                        do {
                            if (gNRectangles_ > 0 && gRectangles_[i - 4] == yTop && gRectangles_[i - 3] == yBottom && gRectangles_[i - 1] >= rectangles1[r1 + 2]) {
                                if (gRectangles_[i - 1] >= rectangles1[r1 + 3]) continue;
                                Region.gRectangles_[i - 1] = rectangles1[r1 + 3];
                                continue;
                            }
                            Region.checkMemory(null, gNRectangles_ + 1);
                            Region.gRectangles_[i] = yTop;
                            Region.gRectangles_[i + 1] = yBottom;
                            Region.gRectangles_[i + 2] = rectangles1[r1 + 2];
                            Region.gRectangles_[i + 3] = rectangles1[r1 + 3];
                            i += 4;
                            ++gNRectangles_;
                        } while ((r1 += 4) != r1End);
                    } else {
                        while (r2 != r2End) {
                            if (gNRectangles_ > 0 && gRectangles_[i - 4] == yTop && gRectangles_[i - 3] == yBottom && gRectangles_[i - 1] >= rectangles2[r2 + 2]) {
                                if (gRectangles_[i - 1] < rectangles2[r2 + 3]) {
                                    Region.gRectangles_[i - 1] = rectangles2[r2 + 3];
                                }
                            } else {
                                Region.checkMemory(null, gNRectangles_ + 1);
                                Region.gRectangles_[i] = yTop;
                                Region.gRectangles_[i + 1] = yBottom;
                                Region.gRectangles_[i + 2] = rectangles2[r2 + 2];
                                Region.gRectangles_[i + 3] = rectangles2[r2 + 3];
                                i += 4;
                                ++gNRectangles_;
                            }
                            r2 += 4;
                        }
                    }
                    break block29;
                }
                if (operationType != 2) break block30;
                int x1 = rectangles1[r1 + 2];
                while (r1 != r1End && r2 != r2End) {
                    if (rectangles2[r2 + 3] <= x1) {
                        r2 += 4;
                        continue;
                    }
                    if (rectangles2[r2 + 2] <= x1) {
                        x1 = rectangles2[r2 + 3];
                        if (x1 >= rectangles1[r1 + 3]) {
                            if ((r1 += 4) == r1End) continue;
                            x1 = rectangles1[r1 + 2];
                            continue;
                        }
                        r2 += 4;
                        continue;
                    }
                    if (rectangles2[r2 + 2] < rectangles1[r1 + 3]) {
                        Region.checkMemory(null, gNRectangles_ + 1);
                        Region.gRectangles_[i + 0] = yTop;
                        Region.gRectangles_[i + 1] = yBottom;
                        Region.gRectangles_[i + 2] = x1;
                        Region.gRectangles_[i + 3] = rectangles2[r2 + 2];
                        i += 4;
                        ++gNRectangles_;
                        x1 = rectangles2[r2 + 3];
                        if (x1 < rectangles1[r1 + 3]) continue;
                        if ((r1 += 4) != r1End) {
                            x1 = rectangles1[r1 + 2];
                            continue;
                        }
                        r2 += 4;
                        continue;
                    }
                    if (rectangles1[r1 + 3] > x1) {
                        Region.checkMemory(null, gNRectangles_ + 1);
                        Region.gRectangles_[i + 0] = yTop;
                        Region.gRectangles_[i + 1] = yBottom;
                        Region.gRectangles_[i + 2] = x1;
                        Region.gRectangles_[i + 3] = rectangles1[r1 + 3];
                        i += 4;
                        ++gNRectangles_;
                    }
                    if ((r1 += 4) == r1End) continue;
                    x1 = rectangles1[r1 + 2];
                }
                while (r1 != r1End) {
                    Region.checkMemory(null, gNRectangles_ + 1);
                    Region.gRectangles_[i + 0] = yTop;
                    Region.gRectangles_[i + 1] = yBottom;
                    Region.gRectangles_[i + 2] = x1;
                    Region.gRectangles_[i + 3] = rectangles1[r1 + 3];
                    i += 4;
                    ++gNRectangles_;
                    if ((r1 += 4) == r1End) continue;
                    x1 = rectangles1[r1 + 2];
                }
                break block29;
            }
            if (operationType != 1) break block29;
            while (r1 != r1End && r2 != r2End) {
                int x2;
                int x1 = Math.max(rectangles1[r1 + 2], rectangles2[r2 + 2]);
                if (x1 < (x2 = Math.min(rectangles1[r1 + 3], rectangles2[r2 + 3]))) {
                    Region.checkMemory(null, gNRectangles_ + 1);
                    Region.gRectangles_[i] = yTop;
                    Region.gRectangles_[i + 1] = yBottom;
                    Region.gRectangles_[i + 2] = x1;
                    Region.gRectangles_[i + 3] = x2;
                    i += 4;
                    ++gNRectangles_;
                }
                if (rectangles1[r1 + 3] < rectangles2[r2 + 3]) {
                    r1 += 4;
                    continue;
                }
                if (rectangles2[r2 + 3] < rectangles1[r1 + 3]) {
                    r2 += 4;
                    continue;
                }
                r1 += 4;
                r2 += 4;
            }
        }
    }

    private int coalesceBands(int previousBand, int currentBand) {
        int r;
        int r1 = previousBand << 2;
        int r2 = currentBand << 2;
        int rEnd = gNRectangles_ << 2;
        int nRectanglesInPreviousBand = currentBand - previousBand;
        int nRectanglesInCurrentBand = 0;
        int y = gRectangles_[r2];
        for (r = r2; r != rEnd && gRectangles_[r] == y; r += 4) {
            ++nRectanglesInCurrentBand;
        }
        if (r != rEnd) {
            rEnd -= 4;
            while (gRectangles_[rEnd - 4] == gRectangles_[rEnd]) {
                rEnd -= 4;
            }
            currentBand = rEnd >> 2 - gNRectangles_;
            rEnd = gNRectangles_ << 2;
        }
        if (nRectanglesInCurrentBand == nRectanglesInPreviousBand && nRectanglesInCurrentBand != 0 && gRectangles_[r1 + 1] == gRectangles_[r2]) {
            do {
                if (gRectangles_[r1 + 2] != gRectangles_[r2 + 2] || gRectangles_[r1 + 3] != gRectangles_[r2 + 3]) {
                    return currentBand;
                }
                r1 += 4;
                r2 += 4;
            } while (--nRectanglesInPreviousBand != 0);
            gNRectangles_ -= nRectanglesInCurrentBand;
            r1 -= nRectanglesInCurrentBand << 2;
            r2 -= nRectanglesInCurrentBand << 2;
            do {
                Region.gRectangles_[r1 + 1] = gRectangles_[r2 + 1];
                r1 += 4;
                r2 += 4;
            } while (--nRectanglesInCurrentBand != 0);
            if (r2 == rEnd) {
                currentBand = previousBand;
            } else {
                do {
                    Region.gRectangles_[r1] = gRectangles_[r2];
                    ++r1;
                } while (++r2 != rEnd);
            }
        }
        return currentBand;
    }

    private void updateExtent() {
        if (this.nRectangles_ == 0) {
            this.extent_.set(0, 0, 0, 0);
        } else {
            this.extent_.y1 = this.rectangles_[0];
            this.extent_.y2 = this.rectangles_[(this.nRectangles_ << 2) - 3];
            this.extent_.x1 = this.rectangles_[2];
            this.extent_.x2 = this.rectangles_[3];
            for (int i = 4; i < this.nRectangles_ << 2; i += 4) {
                if (this.rectangles_[i + 2] < this.extent_.x1) {
                    this.extent_.x1 = this.rectangles_[i + 2];
                }
                if (this.rectangles_[i + 3] <= this.extent_.x2) continue;
                this.extent_.x2 = this.rectangles_[i + 3];
            }
        }
    }

    public void union(Region region) {
        if (this == region || region.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.set(region);
            return;
        }
        if (this.rectangles_.length == 1 && region.extent_.isInsideOf(this.extent_)) {
            return;
        }
        if (region.rectangles_.length == 1 && this.extent_.isInsideOf(region.extent_)) {
            this.set(region);
            return;
        }
        this.combine(region, 0);
        this.extent_.x1 = Math.min(this.extent_.x1, region.extent_.x1);
        this.extent_.y1 = Math.min(this.extent_.y1, region.extent_.y1);
        this.extent_.x2 = Math.max(this.extent_.x2, region.extent_.x2);
        this.extent_.y2 = Math.max(this.extent_.y2, region.extent_.y2);
    }

    public void union(Rect rectangle) {
        if (rectangle.isEmpty()) {
            return;
        }
        this.union(new Region(rectangle));
    }

    public static Region union(Region r1, Region r2) {
        Region region = new Region(r1);
        region.union(r2);
        return region;
    }

    public static Region union(Region region, Rect rectangle) {
        if (rectangle.isEmpty()) {
            return new Region(region);
        }
        return Region.union(region, new Region(rectangle));
    }

    public void intersect(Region region) {
        if (this.isEmpty() || region.isEmpty() || !this.extent_.isOverlapping(region.extent_)) {
            this.clear();
            return;
        }
        this.combine(region, 1);
        this.updateExtent();
    }

    public void intersect(Rect rectangle) {
        if (rectangle.isEmpty()) {
            this.clear();
        } else {
            this.intersect(new Region(rectangle));
        }
    }

    public static Region intersect(Region r1, Region r2) {
        Region region = new Region(r1);
        region.intersect(r2);
        return region;
    }

    public static Region intersect(Region region, Rect rectangle) {
        if (rectangle.isEmpty()) {
            return new Region();
        }
        return Region.intersect(region, new Region(rectangle));
    }

    public void subtract(Region region) {
        if (this.isEmpty() || region.isEmpty() || !this.extent_.isOverlapping(region.extent_)) {
            return;
        }
        this.combine(region, 2);
        this.updateExtent();
    }

    public void subtract(Rect rectangle) {
        if (rectangle.isEmpty()) {
            return;
        }
        this.subtract(new Region(rectangle));
    }

    public static Region subtract(Region r1, Region r2) {
        Region region = new Region(r1);
        region.subtract(r2);
        return region;
    }

    public static Region subtract(Region region, Rect rectangle) {
        if (rectangle.isEmpty()) {
            return new Region(region);
        }
        return Region.subtract(region, new Region(rectangle));
    }

    public void xor(Region region) {
        Region r = (Region)region.clone();
        r.subtract(this);
        this.subtract(region);
        this.union(r);
    }

    public void xor(Rect rectangle) {
        if (rectangle.isEmpty()) {
            this.clear();
        } else {
            this.xor(new Region(rectangle));
        }
    }

    public static Region xor(Region r1, Region r2) {
        Region region = new Region(r1);
        region.xor(r2);
        return region;
    }

    public static Region xor(Region region, Rect rectangle) {
        if (rectangle.isEmpty()) {
            return new Region();
        }
        return Region.xor(region, new Region(rectangle));
    }

    private boolean isExtentCorrect() {
        int yMin = 0;
        int yMax = 0;
        int xMin = 0;
        int xMax = 0;
        if (this.nRectangles_ > 0) {
            yMin = this.rectangles_[0];
            yMax = this.rectangles_[1];
            xMin = this.rectangles_[2];
            xMax = this.rectangles_[3];
            for (int i = 4; i < this.nRectangles_ << 2; i += 4) {
                if (this.rectangles_[i + 0] < yMin) {
                    yMin = this.rectangles_[i + 0];
                }
                if (this.rectangles_[i + 1] > yMax) {
                    yMax = this.rectangles_[i + 1];
                }
                if (this.rectangles_[i + 2] < xMin) {
                    xMin = this.rectangles_[i + 2];
                }
                if (this.rectangles_[i + 3] <= xMax) continue;
                xMax = this.rectangles_[i + 3];
            }
        }
        if (this.extent_.x1 != xMin) {
            System.out.println("Extent error x1");
            return false;
        }
        if (this.extent_.x2 != xMax) {
            System.out.println("Extent error x2");
            return false;
        }
        if (this.extent_.y1 != yMin) {
            System.out.println("Extent error y1");
            return false;
        }
        if (this.extent_.y2 != yMax) {
            System.out.println("Extent error y2");
            return false;
        }
        return true;
    }

    private boolean isCoalesced() {
        if (this.nRectangles_ < 2) {
            return true;
        }
        int rEnd = this.nRectangles_ << 2;
        int thisBand = 0;
        while (thisBand != rEnd) {
            int nextBand;
            for (nextBand = thisBand; nextBand != rEnd && this.rectangles_[nextBand] == this.rectangles_[thisBand]; nextBand += 4) {
            }
            if (nextBand == rEnd) {
                return true;
            }
            if (this.rectangles_[thisBand + 1] == this.rectangles_[nextBand + 1]) {
                int j;
                int thisY = this.rectangles_[thisBand];
                int nextY = this.rectangles_[nextBand];
                int i = thisBand;
                for (j = nextBand; j != rEnd && this.rectangles_[i] == thisY && this.rectangles_[j] == nextY && this.rectangles_[i + 2] == this.rectangles_[j + 2] && this.rectangles_[i + 3] == this.rectangles_[j + 3]; j += 4) {
                    i += 4;
                }
                if (this.rectangles_[i] != thisY && (this.rectangles_[j] != nextY || j == rEnd)) {
                    System.out.println("Coalesce error at Y=" + thisY);
                }
            }
            thisBand = nextBand;
        }
        return true;
    }

    private boolean isConsistent() {
        boolean isExtentCorrect = this.isExtentCorrect();
        if (!isExtentCorrect) {
            return false;
        }
        if (this.nRectangles_ == 0) {
            return true;
        }
        for (int i = 0; i < this.nRectangles_; i += 4) {
            int y1 = this.rectangles_[i + 0];
            int y2 = this.rectangles_[i + 1];
            int x1 = this.rectangles_[i + 2];
            int x2 = this.rectangles_[i + 3];
            if (y2 <= y1) {
                System.out.println("Rectangle error y2 > y1");
                return false;
            }
            if (x2 <= x1) {
                System.out.println("Rectangle error x2 > x1");
                return false;
            }
            if (i + 4 >= this.nRectangles_) continue;
            int y1next = this.rectangles_[i + 4];
            int y2next = this.rectangles_[i + 5];
            int x1next = this.rectangles_[i + 6];
            int x2next = this.rectangles_[i + 7];
            if (y1next < y1) {
                System.out.println("Band alignment top error");
                return false;
            }
            if (y1next != y1) continue;
            if (y2next != y2) {
                System.out.println("Band alignment bottom error");
                return false;
            }
            if (x1next < x2) {
                System.out.println("X bands intersect error");
                return false;
            }
            if (x1next != x2) continue;
            System.out.println("X bands touch error");
            return false;
        }
        return this.isCoalesced();
    }

    private void print() {
        System.out.println("-------------------------------");
        System.out.println(this.extent_);
        System.out.println("nRectangles = " + this.nRectangles_);
        for (int i = 0; i < this.nRectangles_; ++i) {
            System.out.print("y1=" + this.rectangles_[i * 4 + 0] + ", ");
            System.out.print("y2=" + this.rectangles_[i * 4 + 1] + ", ");
            System.out.print("x1=" + this.rectangles_[i * 4 + 2] + ", ");
            System.out.println("x2=" + this.rectangles_[i * 4 + 3]);
        }
    }

    private void printRects() {
        for (int i = 0; i < this.nRectangles_ << 2; ++i) {
            if (i % 4 == 0 && i != 0) {
                System.out.print("  ");
            }
            System.out.print(this.rectangles_[i]);
            if ((i + 1) % 4 == 0) continue;
            System.out.print(',');
        }
        System.out.println();
    }
}

