/*
 * Decompiled with CFR 0.152.
 */
package i2m.traguardi;

import i2m.Language;
import i2m.mappa.Mappa2D;
import i2m.traguardi.Circuit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ModificaCircuito
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton openB;
    JButton esciB;
    DefaultListModel elencoCircuitiLM = new DefaultListModel();
    JList list;
    Circuit circuitoSelezionato;
    Mappa2D mappa;
    int indiceSCelto = -1;

    public ModificaCircuito(JDialog owner) {
        super(owner, Language.string("Modifica circuito"), true);
        this.elencoCircuitiLM.clear();
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.openB = new JButton(Language.string("Modifica"));
        this.openB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.openB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.list = new JList(this.elencoCircuitiLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        pannelloPrincipale.add((Component)listScroller, "Center");
        this.list.setSelectionMode(0);
        try {
            File f = new File("./defaultCircuits.cir");
            System.out.println(f.toString());
            this.caricaDaFile(f);
        }
        catch (NullPointerException ex) {
            JOptionPane.showMessageDialog(this, Language.string("File dei circuiti corrotto o inesistente!"), Language.string("ATTENZIONE"), 0);
        }
        if (this.elencoCircuitiLM.size() > 0) {
            this.list.setSelectedIndex(0);
        } else {
            this.openB.setEnabled(false);
        }
        this.pack();
        this.setResizable(false);
        this.setSize(new Dimension(230, 230));
    }

    public void caricaDaFile(File f) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    this.elencoCircuitiLM.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)this.elencoCircuitiLM.elementAt(this.elencoCircuitiLM.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int getSelectedCircuit() {
        return this.indiceSCelto;
    }

    public String getNomeCircuito(int index) {
        return ((Circuit)this.elencoCircuitiLM.elementAt(index)).toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source.equals(this.esciB)) {
            this.dispose();
        }
        if (source.equals(this.openB)) {
            this.indiceSCelto = this.list.getSelectedIndex();
            this.dispose();
        }
    }
}

