/*
 * Decompiled with CFR 0.152.
 */
package i2m.traguardi;

import i2m.DanasPreferences;
import i2m.Language;
import i2m.mappa.Mappa2D;
import i2m.traguardi.Circuit;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ModificaCircuitiDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String CIRC_EXTENSIONS = "cir";
    JButton nuovoB;
    JButton eliminaB;
    JButton esciB;
    JButton splitB;
    JButton openB;
    JButton save;
    JButton addB;
    JButton saveB;
    JButton mappaMoveB;
    JButton mappaViewPB;
    JButton mappaViewMB;
    JButton mappaSplitInB;
    JTextField nomeTF;
    JTextField direzioneTF;
    JTextField tempoTF;
    JComboBox<String> emisferoTF;
    JComboBox<String> versoTF;
    JComboBox<String> numeroSplitCB;
    JPanel cards;
    CardLayout centerCL;
    DefaultListModel<Object> elencoCircuitiLM;
    JList<Object> list;
    File fileDestinazione;
    JFormattedTextField latitudineTF;
    JFormattedTextField longitudineTF;
    Mappa2D mappaGPS;
    Circuit circuitoAttuale = new Circuit(null, 0.0f, "N", 0.0f, "E", 0, 0);
    int indiceSplitPrecedente = 0;
    boolean avvio = true;

    public ModificaCircuitiDialog(Frame owner) {
        super(owner, Language.string("Modifica/Crea Traguardi"), true);
        this.elencoCircuitiLM = new DefaultListModel();
        this.elencoCircuitiLM.clear();
        this.costruisciInterfaccia();
        this.pack();
        this.setSize(new Dimension(850, 420));
        File f = new File("./defaultCircuits.cir");
        this.caricaDaFile(f);
        this.sort(this.elencoCircuitiLM);
        this.list.setSelectionMode(0);
        if (this.elencoCircuitiLM.size() > 0) {
            this.list.setSelectedIndex(0);
            this.visualizzaElemento(0);
            this.aggiornaComboBox();
        }
        this.fileDestinazione = f;
        this.avvio = false;
        this.setDefaultCloseOperation(2);
    }

    public void costruisciInterfaccia() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        JPanel pannelloBottoniLista = new JPanel();
        URL ImgUrl = this.getClass().getResource("/pix/fileopen.png");
        ImgUrl = this.getClass().getResource("/pix/filesave.png");
        this.saveB = new JButton(new ImageIcon(ImgUrl));
        this.saveB.addActionListener(this);
        this.saveB.setToolTipText(Language.string("Salva libreria"));
        pannelloBottoniLista.add(this.saveB);
        ImgUrl = this.getClass().getResource("/pix/add.png");
        this.addB = new JButton(new ImageIcon(ImgUrl));
        this.addB.addActionListener(this);
        this.addB.setToolTipText(Language.string("Aggiungi circuito"));
        pannelloBottoniLista.add(this.addB);
        ImgUrl = this.getClass().getResource("/pix/sub.png");
        this.eliminaB = new JButton(new ImageIcon(ImgUrl));
        this.eliminaB.addActionListener(this);
        this.eliminaB.setToolTipText(Language.string("Elimina circuito"));
        pannelloBottoniLista.add(this.eliminaB);
        JPanel pannelloCentrale = new JPanel(new BorderLayout());
        this.list = new JList<Object>(this.elencoCircuitiLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        String[] splitList = new String[]{"1", "2"};
        this.numeroSplitCB = new JComboBox<String>(splitList);
        this.numeroSplitCB.setSelectedIndex(0);
        this.numeroSplitCB.setPreferredSize(new Dimension(120, 20));
        this.numeroSplitCB.setMaximumSize(new Dimension(120, 20));
        this.numeroSplitCB.removeAllItems();
        this.numeroSplitCB.addActionListener(this);
        this.indiceSplitPrecedente = 0;
        JLabel numeroSplitLabel = new JLabel("N\u00b0         :");
        numeroSplitLabel.setLabelFor(this.latitudineTF);
        NumberFormat latitudineFormat = NumberFormat.getNumberInstance(Locale.US);
        latitudineFormat.setMinimumIntegerDigits(4);
        latitudineFormat.setMaximumIntegerDigits(4);
        latitudineFormat.setMinimumFractionDigits(4);
        latitudineFormat.setMaximumFractionDigits(4);
        latitudineFormat.setGroupingUsed(false);
        this.latitudineTF = new JFormattedTextField(latitudineFormat);
        this.latitudineTF.setHorizontalAlignment(11);
        this.latitudineTF.setMaximumSize(new Dimension(120, 20));
        this.latitudineTF.addActionListener(this);
        JLabel latitudineLabel = new JLabel(Language.string("Latitudine :"));
        latitudineLabel.setLabelFor(this.latitudineTF);
        String[] emisferoList = new String[]{"N", "S"};
        this.emisferoTF = new JComboBox<String>(emisferoList);
        this.emisferoTF.setSelectedIndex(0);
        this.emisferoTF.setMaximumSize(new Dimension(120, 20));
        this.emisferoTF.addActionListener(this);
        JLabel emisferoLabel = new JLabel(Language.string("Emisfero :"));
        emisferoLabel.setLabelFor(this.emisferoTF);
        NumberFormat longitudineFormat = NumberFormat.getNumberInstance(Locale.US);
        longitudineFormat.setMinimumIntegerDigits(5);
        longitudineFormat.setMaximumIntegerDigits(5);
        longitudineFormat.setMinimumFractionDigits(4);
        longitudineFormat.setMaximumFractionDigits(4);
        longitudineFormat.setGroupingUsed(false);
        this.longitudineTF = new JFormattedTextField(longitudineFormat);
        this.longitudineTF.setHorizontalAlignment(11);
        this.longitudineTF.setMaximumSize(new Dimension(120, 20));
        this.longitudineTF.addActionListener(this);
        JLabel longitudineLabel = new JLabel(Language.string("Longitudine :"));
        longitudineLabel.setLabelFor(this.longitudineTF);
        String[] versoList = new String[]{"E", "W"};
        this.versoTF = new JComboBox<String>(versoList);
        this.versoTF.setSelectedIndex(0);
        this.versoTF.setMaximumSize(new Dimension(120, 20));
        this.versoTF.addActionListener(this);
        JLabel versoLabel = new JLabel(Language.string("Verso :"));
        versoLabel.setLabelFor(this.versoTF);
        this.direzioneTF = new JTextField("", 20);
        this.direzioneTF.setHorizontalAlignment(11);
        this.direzioneTF.setMaximumSize(new Dimension(120, 20));
        this.direzioneTF.addActionListener(this);
        JLabel direzioneLabel = new JLabel(Language.string("Direzione :"));
        direzioneLabel.setLabelFor(this.direzioneTF);
        this.tempoTF = new JTextField("", 20);
        this.tempoTF.setHorizontalAlignment(11);
        this.tempoTF.setMaximumSize(new Dimension(120, 20));
        this.tempoTF.addActionListener(this);
        JLabel tempoLabel = new JLabel(Language.string("Tempo min[s] :"));
        tempoLabel.setLabelFor(this.tempoTF);
        JPanel pannelloCoordinate = new JPanel();
        pannelloCoordinate.setLayout(new BoxLayout(pannelloCoordinate, 1));
        TitledBorder title = BorderFactory.createTitledBorder(Language.string("Info"));
        pannelloCoordinate.setBorder(title);
        pannelloCoordinate.setMinimumSize(new Dimension(600, 300));
        pannelloCoordinate.setPreferredSize(new Dimension(600, 300));
        pannelloCoordinate.setMaximumSize(new Dimension(600, 300));
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 25)));
        this.nomeTF = new JTextField("", 20);
        this.nomeTF.setHorizontalAlignment(2);
        this.nomeTF.setMaximumSize(new Dimension(120, 20));
        JLabel nomeLabel = new JLabel(Language.string("Nome :"));
        nomeLabel.setLabelFor(this.nomeTF);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(nomeLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.nomeTF);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 10)));
        panel = new JPanel();
        panel.setAlignmentX(1.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(numeroSplitLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.numeroSplitCB);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 10)));
        panel = new JPanel();
        panel.setAlignmentX(1.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(latitudineLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.latitudineTF);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 10)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(emisferoLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.emisferoTF);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 10)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(longitudineLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.longitudineTF);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 10)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(versoLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.versoTF);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 10)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(direzioneLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.direzioneTF);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 10)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(tempoLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(this.tempoTF);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 0)));
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setBackground(null);
        URL testoURL = DanasPreferences.getPrefLanguage().equals("it") ? this.getClass().getResource("/res/SpiegazioneModificaCircuiti.html") : this.getClass().getResource("/res/SpiegazioneModificaCircuiti_en.html");
        try {
            editorPane.setPage(testoURL);
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL: " + testoURL);
        }
        editorPane.setAlignmentX(1.0f);
        editorPane.setPreferredSize(new Dimension(200, 50));
        pannelloCoordinate.add(editorPane);
        this.splitB = new JButton(Language.string("Aggiungi/Rimuovi split"));
        this.splitB.setPreferredSize(new Dimension(250, 32));
        this.splitB.addActionListener(this);
        JPanel pannelloSplit = new JPanel();
        pannelloSplit.add(this.splitB);
        JPanel pannelloBottoniMappa = new JPanel();
        ImgUrl = this.getClass().getResource("/pix/move.png");
        this.mappaMoveB = new JButton(new ImageIcon(ImgUrl));
        this.mappaMoveB.addActionListener(this);
        this.mappaMoveB.setToolTipText(Language.string("Muovi"));
        pannelloBottoniMappa.add(this.mappaMoveB);
        ImgUrl = this.getClass().getResource("/pix/viewmag+.png");
        this.mappaViewPB = new JButton(new ImageIcon(ImgUrl));
        this.mappaViewPB.addActionListener(this);
        this.mappaViewPB.setToolTipText(Language.string("Zoom In"));
        pannelloBottoniMappa.add(this.mappaViewPB);
        ImgUrl = this.getClass().getResource("/pix/viewmag-.png");
        this.mappaViewMB = new JButton(new ImageIcon(ImgUrl));
        this.mappaViewMB.addActionListener(this);
        this.mappaViewMB.setToolTipText(Language.string("Zoom Out"));
        pannelloBottoniMappa.add(this.mappaViewMB);
        ImgUrl = this.getClass().getResource("/pix/flag.png");
        this.mappaSplitInB = new JButton(new ImageIcon(ImgUrl));
        this.mappaSplitInB.addActionListener(this);
        this.mappaSplitInB.setToolTipText(Language.string("Aggiungi posizione"));
        pannelloBottoniMappa.add(this.mappaSplitInB);
        this.mappaGPS = new Mappa2D(null, null);
        this.mappaGPS.setMappaTracciatiDialog(true, this);
        this.mappaGPS.attivaModalitaGoogleMaps(true);
        this.mappaGPS.setMode(5);
        this.mappaViewMB.setBackground(null);
        this.mappaMoveB.setBackground(new Color(0.72f, 0.81f, 0.89f, 1.0f));
        this.mappaViewPB.setBackground(null);
        this.mappaSplitInB.setBackground(null);
        this.mappaGPS.mostraVersi(true);
        JPanel pannelloSx = new JPanel(new BorderLayout());
        JPanel pannelloDx = new JPanel(new BorderLayout());
        pannelloDx.add((Component)pannelloCoordinate, "Center");
        pannelloDx.add((Component)pannelloSplit, "South");
        pannelloSx.add((Component)listScroller, "Center");
        pannelloSx.add((Component)pannelloBottoniLista, "South");
        pannelloCentrale.add((Component)pannelloSx, "West");
        pannelloCentrale.add((Component)pannelloDx, "Center");
        JPanel pannelloMappa = new JPanel(new BorderLayout());
        pannelloMappa.add(this.mappaGPS.getMappa(), "Center");
        pannelloMappa.add((Component)pannelloBottoniMappa, "South");
        pannelloMappa.setMinimumSize(new Dimension(400, 400));
        pannelloMappa.setPreferredSize(new Dimension(400, 400));
        pannelloCentrale.add((Component)pannelloMappa, "East");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
    }

    public void aggiungiCircuito(Circuit circuitoEsterno) {
        System.out.println(String.format("Numero circuiti = %d", this.elencoCircuitiLM.size()));
        this.elencoCircuitiLM.addElement(circuitoEsterno);
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.fileDestinazione)));
            for (int i = 0; i < this.elencoCircuitiLM.size(); ++i) {
                Circuit c = (Circuit)this.elencoCircuitiLM.elementAt(i);
                for (int split = 0; split < c.numeroAttraversamenti(); ++split) {
                    out.println(c.getMinilapString(i, split));
                }
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void sostituisciCircuito(Circuit circuitoEsterno, int index) {
        this.elencoCircuitiLM.remove(index);
        this.elencoCircuitiLM.add(index, circuitoEsterno);
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.fileDestinazione)));
            for (int i = 0; i < this.elencoCircuitiLM.size(); ++i) {
                Circuit c = (Circuit)this.elencoCircuitiLM.elementAt(i);
                for (int split = 0; split < c.numeroAttraversamenti(); ++split) {
                    out.println(c.getMinilapString(i, split));
                }
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void aggiornaComboBox() {
        int numeroAttraversamenti = this.circuitoAttuale.numeroAttraversamenti();
        this.numeroSplitCB.removeActionListener(this);
        this.numeroSplitCB.removeAllItems();
        this.numeroSplitCB.insertItemAt("TRAGUARDO", 0);
        if (numeroAttraversamenti > 0) {
            for (int i = 1; i < numeroAttraversamenti; ++i) {
                this.numeroSplitCB.insertItemAt(this.circuitoAttuale.getAttraversamento(i).toString(), i);
            }
        }
        this.numeroSplitCB.insertItemAt(Language.string("Inserisci.."), numeroAttraversamenti);
        this.numeroSplitCB.setSelectedIndex(0);
        this.indiceSplitPrecedente = 0;
        this.numeroSplitCB.addActionListener(this);
    }

    public void visualizzaElemento(int indice) {
        Circuit c = new Circuit(null, 0.0f, "N", 0.0f, "E", 0, 0);
        if (indice != -1) {
            c = (Circuit)this.elencoCircuitiLM.elementAt(indice);
        }
        this.nomeTF.setText(c.toString());
        if (c.numeroAttraversamenti() != 0) {
            this.latitudineTF.setValue(c.getAttraversamento(0).getLatitudine());
            if (c.getAttraversamento(0).getEmisfero().equals("N")) {
                this.emisferoTF.setSelectedIndex(0);
            } else {
                this.emisferoTF.setSelectedIndex(1);
            }
            this.longitudineTF.setValue(c.getAttraversamento(0).getLongitudine());
            if (c.getAttraversamento(0).getVerso().equals("E")) {
                this.versoTF.setSelectedIndex(0);
            } else {
                this.versoTF.setSelectedIndex(1);
            }
            this.direzioneTF.setText(Integer.valueOf(c.getAttraversamento(0).getDirezione()).toString());
            if (!c.getAttraversamento(0).isDirezioneValida()) {
                this.direzioneTF.setText("");
            }
            this.mappaGPS.centraMappaGoogle(c.getAttraversamento(0).getLatitudineDecimale(), c.getAttraversamento(0).getLongitudineDecimale());
            this.mappaGPS.importaTraguardiDialog(c);
            this.tempoTF.setText(Integer.valueOf((int)c.getTempoMinimo() / 1000).toString());
        } else {
            this.latitudineTF.setValue(0);
            this.longitudineTF.setValue(0);
            this.emisferoTF.setSelectedIndex(0);
            this.versoTF.setSelectedIndex(0);
            this.direzioneTF.setText("");
            this.tempoTF.setText("0");
        }
        this.circuitoAttuale.copiaCircuito(c);
        this.indiceSplitPrecedente = 0;
        if (this.direzioneTF.getText().equals("")) {
            this.direzioneTF.setBackground(Color.RED);
        } else {
            this.direzioneTF.setBackground(Color.WHITE);
        }
    }

    public void visualizzaElementoCircuitoAttuale(int split) {
        this.emisferoTF.removeActionListener(this);
        this.versoTF.removeActionListener(this);
        this.numeroSplitCB.removeActionListener(this);
        this.nomeTF.setText(this.circuitoAttuale.toString());
        if (split < this.circuitoAttuale.numeroAttraversamenti()) {
            this.direzioneTF.setText(Integer.valueOf(this.circuitoAttuale.getAttraversamento(split).getDirezione()).toString());
            this.latitudineTF.setValue(this.circuitoAttuale.getAttraversamento(split).getLatitudine());
            this.longitudineTF.setValue(this.circuitoAttuale.getAttraversamento(split).getLongitudine());
            if (this.circuitoAttuale.getAttraversamento(split).getEmisfero().equals("N")) {
                this.emisferoTF.setSelectedIndex(0);
            } else {
                this.emisferoTF.setSelectedIndex(1);
            }
            if (this.circuitoAttuale.getAttraversamento(split).getVerso().equals("E")) {
                this.versoTF.setSelectedIndex(0);
            } else {
                this.versoTF.setSelectedIndex(1);
            }
            if (!this.circuitoAttuale.getAttraversamento(split).isDirezioneValida()) {
                this.direzioneTF.setText("");
            }
            this.tempoTF.setText(Integer.valueOf((int)this.circuitoAttuale.getTempoMinimo() / 1000).toString());
        } else {
            this.latitudineTF.setValue(0);
            this.longitudineTF.setValue(0);
            this.emisferoTF.setSelectedIndex(0);
            this.versoTF.setSelectedIndex(0);
            this.direzioneTF.setText("");
            this.tempoTF.setText("0");
        }
        if (this.direzioneTF.getText().equals("")) {
            this.direzioneTF.setBackground(Color.RED);
        } else {
            this.direzioneTF.setBackground(Color.WHITE);
        }
        this.emisferoTF.addActionListener(this);
        this.versoTF.addActionListener(this);
        this.numeroSplitCB.addActionListener(this);
    }

    public void inserisciDatiDaPannelloCircuitoAttuale(int numeroAttraversamento) {
        if (this.circuitoAttuale.getAttraversamento(numeroAttraversamento) == null) {
            return;
        }
        this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setEmisfero((String)this.emisferoTF.getSelectedItem());
        this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setVerso((String)this.versoTF.getSelectedItem());
        if (this.direzioneTF.getText().equals(null)) {
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setDirezioneValida(false);
        } else {
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setDirezioneValida(true);
        }
        try {
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setDirezione(Integer.parseInt(this.direzioneTF.getText()));
        }
        catch (NumberFormatException ex) {
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setDirezioneValida(false);
        }
        try {
            this.circuitoAttuale.setTempoMinimo(1000.0 * Double.parseDouble(this.tempoTF.getText()));
        }
        catch (NumberFormatException ex) {
            this.circuitoAttuale.setTempoMinimo(0.0);
        }
        try {
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setLatitudine(Double.valueOf(this.latitudineTF.getText()));
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setLongitudine(Double.valueOf(this.longitudineTF.getText()));
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setLatitudine(0.0);
            this.circuitoAttuale.getAttraversamento(numeroAttraversamento).setLongitudine(0.0);
            JOptionPane.showMessageDialog(this, Language.string("Dati inseriti non accettabili"), Language.string("ATTENZIONE"), 0);
        }
    }

    public void copiaNellaLista(int numeroCircuito) {
        ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).copiaCircuito(this.circuitoAttuale);
    }

    public void modificaTraguardoAttuale(double x, double y) {
        if (this.convertiCoordinateDoubleToFloat(y) < 0.0f) {
            this.emisferoTF.setSelectedIndex(1);
        } else {
            this.emisferoTF.setSelectedIndex(0);
        }
        if (this.convertiCoordinateDoubleToFloat(x) < 0.0f) {
            this.versoTF.setSelectedIndex(1);
        } else {
            this.versoTF.setSelectedIndex(0);
        }
        this.latitudineTF.setValue(Float.valueOf(Math.abs(this.convertiCoordinateDoubleToFloat(y))));
        this.longitudineTF.setValue(Float.valueOf(Math.abs(this.convertiCoordinateDoubleToFloat(x))));
        this.inserisciDatiDaPannelloCircuitoAttuale(this.numeroSplitCB.getSelectedIndex());
        this.mappaGPS.importaTraguardiDialog(this.circuitoAttuale);
    }

    public float convertiCoordinateDoubleToFloat(double coordinata) {
        float segno = 1.0f;
        long dato = Math.round(coordinata);
        if (dato < 0L) {
            dato = Math.abs(dato);
            segno = -1.0f;
        }
        long temp = dato / 10000L;
        long decimillesimi = dato - temp * 10000L;
        long gradi = temp / 60L;
        long primi = temp - gradi * 60L;
        String s = String.format("%03d%02d.%04d", gradi, primi, decimillesimi);
        return segno * Float.valueOf(s).floatValue();
    }

    public void caricaDaFile(File f) {
        try {
            String line;
            this.elencoCircuitiLM.removeAllElements();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    this.elencoCircuitiLM.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)this.elencoCircuitiLM.elementAt(this.elencoCircuitiLM.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.elencoCircuitiLM.getSize() != 0) {
            this.abilitaTutto(true);
        }
        this.fileDestinazione = f;
    }

    void sort(DefaultListModel<Object> dlm) {
        Object[] dlma = dlm.toArray();
        Arrays.sort(dlma);
        dlm.clear();
        for (Object x : dlma) {
            dlm.addElement(x);
        }
    }

    public void verificaFormato() {
        try {
            Integer i = Integer.parseInt(this.direzioneTF.getText());
            if (i > 360 || i < 0) {
                i = 0;
            }
            this.direzioneTF.setText(i.toString());
        }
        catch (NumberFormatException ex) {
            this.direzioneTF.setText(null);
        }
        try {
            Integer t = Integer.parseInt(this.tempoTF.getText());
            if (t < 0) {
                t = 0;
            }
            this.tempoTF.setText(t.toString());
        }
        catch (NumberFormatException ex) {
            this.tempoTF.setText("0");
        }
        String s = this.latitudineTF.getText();
        if (Integer.parseInt(s.substring(0, 2)) > 90 || Integer.parseInt(s.substring(2, 4)) > 59) {
            this.latitudineTF.setValue(0);
        }
        if (Integer.parseInt((s = this.longitudineTF.getText()).substring(0, 3)) > 180 || Integer.parseInt(s.substring(3, 5)) > 59) {
            this.longitudineTF.setValue(0);
        }
    }

    public void abilitaTutto(boolean abilita) {
        this.nomeTF.setEnabled(abilita);
        this.latitudineTF.setEnabled(abilita);
        this.longitudineTF.setEnabled(abilita);
        this.direzioneTF.setEnabled(abilita);
        this.tempoTF.setEnabled(abilita);
        this.emisferoTF.setEnabled(abilita);
        this.versoTF.setEnabled(abilita);
        this.numeroSplitCB.setEnabled(abilita);
        this.eliminaB.setEnabled(abilita);
        if (!abilita) {
            this.splitB.setEnabled(abilita);
        }
    }

    public void selezionaSplit(int indice) {
        this.numeroSplitCB.removeActionListener(this);
        if (indice < 1) {
            this.splitB.setEnabled(false);
        } else {
            this.splitB.setEnabled(true);
        }
        this.numeroSplitCB.setSelectedIndex(indice);
        this.indiceSplitPrecedente = indice;
        this.visualizzaElementoCircuitoAttuale(indice);
        this.numeroSplitCB.addActionListener(this);
    }

    public int salvaLista() {
        int split = 0;
        if (!this.fileDestinazione.getName().endsWith(".cir")) {
            this.fileDestinazione = new File(this.fileDestinazione.getPath() + "." + CIRC_EXTENSIONS);
        }
        if (!this.fileDestinazione.isAbsolute()) {
            this.fileDestinazione = new File(this.fileDestinazione.getAbsolutePath());
        }
        if (!this.fileDestinazione.exists() || !this.fileDestinazione.canWrite()) {
            if (!this.fileDestinazione.exists() && this.fileDestinazione.getParentFile().exists() && this.fileDestinazione.getParentFile().isDirectory() && this.fileDestinazione.getParentFile().canWrite()) {
                try {
                    this.fileDestinazione.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
                return -1;
            }
        }
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.fileDestinazione)));
            for (int i = 0; i < this.elencoCircuitiLM.size(); ++i) {
                Circuit c = (Circuit)this.elencoCircuitiLM.elementAt(i);
                for (split = 0; split < c.numeroAttraversamenti(); ++split) {
                    out.println(c.getMinilapString(i, split));
                }
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.visualizzaElemento(this.list.getSelectedIndex());
        this.aggiornaComboBox();
        this.selezionaSplit(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.direzioneTF)) {
            if (this.direzioneTF.getText().equals("")) {
                this.direzioneTF.setBackground(Color.RED);
            } else {
                this.direzioneTF.setBackground(Color.WHITE);
            }
        }
        if (e.getSource().equals(this.tempoTF) && this.tempoTF.getText().equals("")) {
            this.tempoTF.setText("0");
        }
        if (!this.avvio && (e.getSource().equals(this.latitudineTF) || e.getSource().equals(this.longitudineTF) || e.getSource().equals(this.emisferoTF) || e.getSource().equals(this.versoTF) || e.getSource().equals(this.direzioneTF) || e.getSource().equals(this.tempoTF))) {
            this.inserisciDatiDaPannelloCircuitoAttuale(this.indiceSplitPrecedente);
            if (this.numeroSplitCB.getSelectedIndex() == 0 && !e.getSource().equals(this.direzioneTF) && !e.getSource().equals(this.tempoTF)) {
                this.mappaGPS.centraMappaGoogle(this.circuitoAttuale.getAttraversamento(0).getLatitudineDecimale(), this.circuitoAttuale.getAttraversamento(0).getLongitudineDecimale());
            }
            this.mappaGPS.importaTraguardiDialog(this.circuitoAttuale);
        }
        if (e.getSource().equals(this.eliminaB)) {
            int indiceSelezionato = this.list.getSelectedIndex();
            if (indiceSelezionato != -1) {
                int proseguire = JOptionPane.showConfirmDialog(this, Language.string("Vuoi cancellare definitivamente il circuito selezionato?"), Language.string("ATTENZIONE"), 0);
                if (proseguire == -1 || proseguire == 1) {
                    return;
                }
                this.visualizzaElemento(indiceSelezionato - 1);
                this.selezionaSplit(0);
                this.list.setSelectedIndex(indiceSelezionato - 1);
                this.elencoCircuitiLM.remove(indiceSelezionato);
                if (indiceSelezionato == 0 && this.elencoCircuitiLM.getSize() != 0) {
                    this.list.setSelectedIndex(0);
                }
                this.salvaLista();
            }
            if (this.elencoCircuitiLM.getSize() == 0) {
                this.abilitaTutto(false);
            }
        }
        if (e.getSource().equals(this.addB)) {
            Circuit c = new Circuit("NUOVO", 0.0f, "N", 0.0f, "E", 0, 0);
            this.elencoCircuitiLM.addElement(c);
            this.list.setSelectedIndex(this.elencoCircuitiLM.size() - 1);
            this.abilitaTutto(true);
            this.salvaLista();
        }
        if (e.getSource().equals(this.mappaViewPB)) {
            this.mappaGPS.setMode(3);
            this.mappaViewPB.setBackground(new Color(0.72f, 0.81f, 0.89f, 1.0f));
            this.mappaMoveB.setBackground(null);
            this.mappaViewMB.setBackground(null);
            this.mappaSplitInB.setBackground(null);
        }
        if (e.getSource().equals(this.mappaViewMB)) {
            this.mappaGPS.setMode(4);
            this.mappaViewMB.setBackground(new Color(0.72f, 0.81f, 0.89f, 1.0f));
            this.mappaMoveB.setBackground(null);
            this.mappaViewPB.setBackground(null);
            this.mappaSplitInB.setBackground(null);
        }
        if (e.getSource().equals(this.mappaMoveB)) {
            this.mappaGPS.setMode(5);
            this.mappaViewMB.setBackground(null);
            this.mappaMoveB.setBackground(new Color(0.72f, 0.81f, 0.89f, 1.0f));
            this.mappaViewPB.setBackground(null);
            this.mappaSplitInB.setBackground(null);
        }
        if (e.getSource().equals(this.mappaSplitInB)) {
            this.mappaGPS.setMode(10);
            this.mappaViewMB.setBackground(null);
            this.mappaSplitInB.setBackground(new Color(0.72f, 0.81f, 0.89f, 1.0f));
            this.mappaViewPB.setBackground(null);
            this.mappaMoveB.setBackground(null);
        }
        if (e.getSource().equals(this.saveB)) {
            boolean split = false;
            if (this.nomeTF.getText().length() > 8) {
                this.nomeTF.setText(this.nomeTF.getText().substring(0, 7));
                JOptionPane.showMessageDialog(this, Language.string("Il nome del circuito deve avere massimo 8 caratteri"), Language.string("ATTENZIONE"), 0);
            }
            this.verificaFormato();
            this.circuitoAttuale.getAttraversamento(0).setNome(this.nomeTF.getText());
            try {
                this.circuitoAttuale.setTempoMinimo(1000.0 * Double.parseDouble(this.tempoTF.getText()));
            }
            catch (NumberFormatException ex) {
                this.circuitoAttuale.setTempoMinimo(0.0);
            }
            ((Circuit)this.elencoCircuitiLM.elementAt(this.list.getSelectedIndex())).copiaCircuito(this.circuitoAttuale);
            int res = this.salvaLista();
            this.list.updateUI();
            if (res != -1) {
                JOptionPane.showMessageDialog(this, Language.string("Circuiti salvati correttamente"), Language.string("INFO"), 1);
            }
        }
        if (e.getSource().equals(this.splitB)) {
            int indice = this.numeroSplitCB.getSelectedIndex();
            if (indice > 0 && indice < this.circuitoAttuale.numeroAttraversamenti()) {
                int proseguire = JOptionPane.showConfirmDialog(this, Language.string("Vuoi cancellare definitivamente l'intertempo selezionato?"), Language.string("ATTENZIONE"), 0);
                if (proseguire == -1 || proseguire == 1) {
                    return;
                }
                this.circuitoAttuale.rimuoviSplit(indice);
                this.circuitoAttuale.riordinaNomiSplit();
                this.aggiornaComboBox();
                this.selezionaSplit(indice - 1);
            } else if (indice > 0) {
                this.circuitoAttuale.aggiungiSplit(this.circuitoAttuale.numeroAttraversamenti(), 0.0f, "N", 0.0f, "E", 0, 0, 0);
                this.inserisciDatiDaPannelloCircuitoAttuale(this.circuitoAttuale.numeroAttraversamenti() - 1);
                this.aggiornaComboBox();
                this.selezionaSplit(this.circuitoAttuale.numeroAttraversamenti() - 1);
                this.direzioneTF.setBackground(Color.RED);
            }
            this.mappaGPS.importaTraguardiDialog(this.circuitoAttuale);
        }
        if (e.getSource().equals(this.numeroSplitCB)) {
            this.inserisciDatiDaPannelloCircuitoAttuale(this.indiceSplitPrecedente);
            if (this.numeroSplitCB.getSelectedIndex() < 1) {
                this.splitB.setEnabled(false);
            } else {
                this.splitB.setEnabled(true);
            }
            if (this.numeroSplitCB.getSelectedIndex() != -1) {
                this.indiceSplitPrecedente = this.numeroSplitCB.getSelectedIndex();
            }
            if (this.list.getSelectedIndex() != -1 && this.numeroSplitCB.getSelectedIndex() != -1) {
                this.visualizzaElementoCircuitoAttuale(this.numeroSplitCB.getSelectedIndex());
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModificaCircuitiDialog d = new ModificaCircuitiDialog(null);
                d.setLocationRelativeTo(null);
                d.setVisible(true);
            }
        });
    }
}

