/*
 * Decompiled with CFR 0.152.
 */
package i2m.traguardi;

import i2m.DanasPreferences;
import i2m.Language;
import i2m.traguardi.Circuit;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CircuitSplitDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String CIRC_EXTENSIONS = "cir";
    JButton nuovoB;
    JButton eliminaB;
    JButton esciB;
    JButton splitB;
    JButton apriB;
    JButton salvaB;
    JButton salva2B;
    JButton openB;
    JButton saveB;
    JButton addB;
    JButton cancelB;
    JButton upB;
    JButton downB;
    JButton importaB;
    JTextField apriTF;
    JTextField salvaTF;
    JTextField nomeTF;
    JTextField direzioneTF;
    JComboBox emisferoTF;
    JComboBox versoTF;
    JComboBox numeroSplitCB;
    JPanel cards;
    CardLayout centerCL;
    DefaultListModel elencoCircuitiLM = new DefaultListModel();
    JList list;
    File fileDestinazione;
    JFormattedTextField latitudineTF;
    JFormattedTextField longitudineTF;

    public CircuitSplitDialog(Frame owner) {
        super(owner, Language.string("Traguardi e split"), true);
        this.elencoCircuitiLM.clear();
        this.costruisciInterfaccia();
        this.pack();
        this.setResizable(false);
        this.setSize(new Dimension(390, 420));
        File f = new File("./defaultCircuits.cir");
        System.out.println(f.toString());
        this.caricaDaFile(f);
        this.list.setSelectionMode(0);
        this.upB.setEnabled(false);
        if (this.elencoCircuitiLM.size() > 0) {
            this.list.setSelectedIndex(0);
            this.aggiornaComboBox(0);
            this.visualizzaElemento(0, 0);
        }
        this.fileDestinazione = f;
        this.salvaTF.setText(f.getName());
    }

    public void costruisciInterfaccia() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        JToolBar topToolBar = new JToolBar(Language.string("Barra icone"));
        pannelloPrincipale.add((Component)topToolBar, "North");
        URL ImgUrl = this.getClass().getResource("/pix/fileopen.png");
        this.openB = new JButton(new ImageIcon(ImgUrl));
        this.openB.addActionListener(this);
        this.openB.setToolTipText(Language.string("Apri libreria"));
        topToolBar.add(this.openB);
        ImgUrl = this.getClass().getResource("/pix/filesave.png");
        this.saveB = new JButton(new ImageIcon(ImgUrl));
        this.saveB.addActionListener(this);
        this.saveB.setToolTipText(Language.string("Salva libreria"));
        ImgUrl = this.getClass().getResource("/pix/add.png");
        this.addB = new JButton(new ImageIcon(ImgUrl));
        this.addB.addActionListener(this);
        this.addB.setToolTipText(Language.string("Aggiungi circuito"));
        topToolBar.add(this.addB);
        ImgUrl = this.getClass().getResource("/pix/sub.png");
        this.cancelB = new JButton(new ImageIcon(ImgUrl));
        this.cancelB.addActionListener(this);
        this.cancelB.setToolTipText(Language.string("Elimina circuito"));
        topToolBar.add(this.cancelB);
        ImgUrl = this.getClass().getResource("/pix/su.png");
        this.upB = new JButton(new ImageIcon(ImgUrl));
        this.upB.addActionListener(this);
        this.upB.setToolTipText(Language.string("Muovi su"));
        topToolBar.add(this.upB);
        ImgUrl = this.getClass().getResource("/pix/giu.png");
        this.downB = new JButton(new ImageIcon(ImgUrl));
        this.downB.addActionListener(this);
        this.downB.setToolTipText(Language.string("Muovi gi\u00f9"));
        topToolBar.add(this.downB);
        this.nuovoB = new JButton(Language.string("Nuovo"));
        this.nuovoB.addActionListener(this);
        this.eliminaB = new JButton(Language.string("Elimina"));
        this.eliminaB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.salva2B = new JButton(Language.string("Salva"));
        this.salva2B.addActionListener(this);
        this.importaB = new JButton(Language.string("Importa"));
        this.importaB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.nuovoB);
        pannelloBottoni.add(this.eliminaB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.add(this.salva2B);
        pannelloBottoni.add(this.importaB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        JPanel pannelloCentrale = new JPanel(new BorderLayout());
        this.list = new JList(this.elencoCircuitiLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        JPanel pannelloDati = new JPanel();
        pannelloDati.setLayout(new BoxLayout(pannelloDati, 1));
        JPanel pannelloLibreria = new JPanel();
        pannelloLibreria.setLayout(new BoxLayout(pannelloLibreria, 1));
        this.apriTF = new JTextField("", 30);
        this.apriTF.setHorizontalAlignment(11);
        this.apriTF.setMaximumSize(new Dimension(130, 20));
        this.apriTF.setEditable(false);
        this.salvaTF = new JTextField("", 30);
        this.salvaTF.setHorizontalAlignment(11);
        this.salvaTF.setMaximumSize(new Dimension(130, 20));
        this.salvaTF.setEditable(false);
        this.apriB = new JButton("  IN  ");
        this.apriB.addActionListener(this);
        this.salvaB = new JButton("OUT");
        this.salvaB.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setAlignmentX(1.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.apriTF);
        panel.add(new JLabel("   "));
        panel.add(this.apriB);
        pannelloLibreria.add(panel);
        panel = new JPanel();
        panel.setAlignmentX(1.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.salvaTF);
        panel.add(new JLabel("   "));
        panel.add(this.salvaB);
        pannelloLibreria.add(Box.createRigidArea(new Dimension(0, 2)));
        pannelloLibreria.add(panel);
        TitledBorder title = BorderFactory.createTitledBorder(Language.string("Libreria"));
        pannelloLibreria.setBorder(title);
        pannelloLibreria.setMinimumSize(new Dimension(600, 80));
        pannelloLibreria.setPreferredSize(new Dimension(600, 80));
        pannelloLibreria.setMaximumSize(new Dimension(600, 80));
        JPanel pannelloCircuito = new JPanel();
        pannelloCircuito.setLayout(new BoxLayout(pannelloCircuito, 1));
        title = BorderFactory.createTitledBorder(Language.string("Circuito"));
        pannelloCircuito.setBorder(title);
        this.nomeTF = new JTextField("", 20);
        this.nomeTF.setHorizontalAlignment(2);
        this.nomeTF.setMaximumSize(new Dimension(100, 20));
        JLabel nomeLabel = new JLabel(Language.string("Nome circuito :"));
        nomeLabel.setLabelFor(this.nomeTF);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(nomeLabel);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.nomeTF);
        pannelloCircuito.add(panel);
        pannelloCircuito.add(Box.createRigidArea(new Dimension(0, 2)));
        String[] splitList = new String[]{"1", "2"};
        this.numeroSplitCB = new JComboBox<String>(splitList);
        this.numeroSplitCB.setSelectedIndex(0);
        this.numeroSplitCB.setMaximumSize(new Dimension(100, 20));
        this.numeroSplitCB.removeAllItems();
        this.numeroSplitCB.addActionListener(this);
        JLabel numeroSplitLabel = new JLabel("N\u00b0         :");
        numeroSplitLabel.setLabelFor(this.latitudineTF);
        NumberFormat latitudineFormat = NumberFormat.getNumberInstance(Locale.US);
        latitudineFormat.setMinimumIntegerDigits(4);
        latitudineFormat.setMaximumIntegerDigits(4);
        latitudineFormat.setMinimumFractionDigits(4);
        latitudineFormat.setMaximumFractionDigits(4);
        latitudineFormat.setGroupingUsed(false);
        this.latitudineTF = new JFormattedTextField(latitudineFormat);
        this.latitudineTF.setHorizontalAlignment(11);
        this.latitudineTF.setMaximumSize(new Dimension(100, 20));
        JLabel latitudineLabel = new JLabel(Language.string("Latitudine :"));
        latitudineLabel.setLabelFor(this.latitudineTF);
        String[] emisferoList = new String[]{"N", "S"};
        this.emisferoTF = new JComboBox<String>(emisferoList);
        this.emisferoTF.setSelectedIndex(0);
        this.emisferoTF.setMaximumSize(new Dimension(100, 20));
        JLabel emisferoLabel = new JLabel(Language.string("Emisfero :"));
        emisferoLabel.setLabelFor(this.emisferoTF);
        NumberFormat longitudineFormat = NumberFormat.getNumberInstance(Locale.US);
        longitudineFormat.setMinimumIntegerDigits(5);
        longitudineFormat.setMaximumIntegerDigits(5);
        longitudineFormat.setMinimumFractionDigits(4);
        longitudineFormat.setMaximumFractionDigits(4);
        longitudineFormat.setGroupingUsed(false);
        this.longitudineTF = new JFormattedTextField(longitudineFormat);
        this.longitudineTF.setHorizontalAlignment(11);
        this.longitudineTF.setMaximumSize(new Dimension(100, 20));
        JLabel longitudineLabel = new JLabel(Language.string("Longitudine :"));
        longitudineLabel.setLabelFor(this.longitudineTF);
        String[] versoList = new String[]{"E", "W"};
        this.versoTF = new JComboBox<String>(versoList);
        this.versoTF.setSelectedIndex(0);
        this.versoTF.setMaximumSize(new Dimension(100, 20));
        JLabel versoLabel = new JLabel(Language.string("Verso :"));
        versoLabel.setLabelFor(this.versoTF);
        this.direzioneTF = new JTextField("", 20);
        this.direzioneTF.setHorizontalAlignment(11);
        this.direzioneTF.setMaximumSize(new Dimension(100, 20));
        JLabel direzioneLabel = new JLabel(Language.string("Direzione :"));
        direzioneLabel.setLabelFor(this.direzioneTF);
        JPanel pannelloCoordinate = new JPanel();
        pannelloCoordinate.setLayout(new BoxLayout(pannelloCoordinate, 1));
        title = BorderFactory.createTitledBorder(Language.string("Coordinate"));
        pannelloCoordinate.setBorder(title);
        pannelloCoordinate.setMinimumSize(new Dimension(600, 300));
        pannelloCoordinate.setPreferredSize(new Dimension(600, 300));
        pannelloCoordinate.setMaximumSize(new Dimension(600, 300));
        panel = new JPanel();
        panel.setAlignmentX(1.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(numeroSplitLabel);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.numeroSplitCB);
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 2)));
        panel = new JPanel();
        panel.setAlignmentX(1.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(latitudineLabel);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.latitudineTF);
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 2)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(emisferoLabel);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.emisferoTF);
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 2)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(longitudineLabel);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.longitudineTF);
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 2)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(versoLabel);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.versoTF);
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 2)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(1.0f);
        panel.add(direzioneLabel);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.direzioneTF);
        pannelloCoordinate.add(panel);
        pannelloCoordinate.add(Box.createRigidArea(new Dimension(0, 30)));
        this.splitB = new JButton(Language.string("Aggiungi/Rimuovi split"));
        this.splitB.addActionListener(this);
        JPanel pannelloDx = new JPanel(new BorderLayout());
        pannelloDati.add(pannelloLibreria);
        pannelloDati.add(pannelloCircuito);
        pannelloDati.add(pannelloCoordinate);
        pannelloDx.add((Component)pannelloDati, "Center");
        pannelloDx.add((Component)this.splitB, "South");
        pannelloCentrale.add((Component)listScroller, "West");
        pannelloCentrale.add((Component)pannelloDx, "Center");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
    }

    public void aggiungiCircuito(Circuit circuitoEsterno) {
        System.out.println(String.format("Numero circuiti = %d", this.elencoCircuitiLM.size()));
        this.elencoCircuitiLM.addElement(circuitoEsterno);
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.fileDestinazione)));
            for (int i = 0; i < this.elencoCircuitiLM.size(); ++i) {
                Circuit c = (Circuit)this.elencoCircuitiLM.elementAt(i);
                for (int split = 0; split < c.numeroAttraversamenti(); ++split) {
                    out.println(c.getMinilapString(i, split));
                }
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void sostituisciCircuito(Circuit circuitoEsterno, int index) {
        this.elencoCircuitiLM.remove(index);
        this.elencoCircuitiLM.add(index, circuitoEsterno);
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.fileDestinazione)));
            for (int i = 0; i < this.elencoCircuitiLM.size(); ++i) {
                Circuit c = (Circuit)this.elencoCircuitiLM.elementAt(i);
                for (int split = 0; split < c.numeroAttraversamenti(); ++split) {
                    out.println(c.getMinilapString(i, split));
                }
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void aggiornaComboBox(int numeroCircuito) {
        if (numeroCircuito > -1) {
            Circuit c = (Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito);
            int numeroAttraversamenti = c.numeroAttraversamenti();
            this.numeroSplitCB.removeAllItems();
            this.numeroSplitCB.insertItemAt("TRAGUARDO", 0);
            if (numeroAttraversamenti > 0) {
                for (int i = 1; i < numeroAttraversamenti; ++i) {
                    this.numeroSplitCB.insertItemAt(c.getAttraversamento(i).toString(), i);
                }
            }
            this.numeroSplitCB.insertItemAt(Language.string("Inserisci.."), numeroAttraversamenti);
            this.numeroSplitCB.setSelectedIndex(0);
        }
    }

    public void visualizzaElemento(int indice, int split) {
        Circuit c = new Circuit(null, 0.0f, "N", 0.0f, "E", 0, 0);
        if (indice != -1) {
            c = (Circuit)this.elencoCircuitiLM.elementAt(indice);
        }
        this.nomeTF.setText(c.toString());
        if (split < c.numeroAttraversamenti()) {
            this.latitudineTF.setValue(c.getAttraversamento(split).getLatitudine());
            if (c.getAttraversamento(split).getEmisfero().equals("N")) {
                this.emisferoTF.setSelectedIndex(0);
            } else {
                this.emisferoTF.setSelectedIndex(1);
            }
            this.longitudineTF.setValue(c.getAttraversamento(split).getLongitudine());
            if (c.getAttraversamento(split).getVerso().equals("E")) {
                this.versoTF.setSelectedIndex(0);
            } else {
                this.versoTF.setSelectedIndex(1);
            }
            this.direzioneTF.setText(Integer.valueOf(c.getAttraversamento(split).getDirezione()).toString());
            if (!c.getAttraversamento(split).isDirezioneValida()) {
                this.direzioneTF.setText("");
            }
        } else {
            this.latitudineTF.setValue(0);
            this.longitudineTF.setValue(0);
            this.emisferoTF.setSelectedIndex(0);
            this.versoTF.setSelectedIndex(0);
            this.direzioneTF.setText("");
        }
    }

    public void inserisciDatiDaPannello(int numeroCircuito, int numeroAttraversamento) {
        ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setEmisfero((String)this.emisferoTF.getSelectedItem());
        ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setVerso((String)this.versoTF.getSelectedItem());
        if (this.direzioneTF.getText().equals(null)) {
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setDirezioneValida(false);
        } else {
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setDirezioneValida(true);
        }
        try {
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setDirezione(Integer.parseInt(this.direzioneTF.getText()));
        }
        catch (NumberFormatException ex) {
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setDirezioneValida(false);
        }
        try {
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setLatitudine(Float.valueOf(this.latitudineTF.getText()).floatValue());
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setLongitudine(Float.valueOf(this.longitudineTF.getText()).floatValue());
        }
        catch (NumberFormatException ex) {
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setLatitudine(0.0);
            ((Circuit)this.elencoCircuitiLM.elementAt(numeroCircuito)).getAttraversamento(numeroAttraversamento).setLongitudine(0.0);
            JOptionPane.showMessageDialog(this, Language.string("Dati inseriti non accettabili"), Language.string("ATTENZIONE"), 0);
        }
    }

    public void caricaDaFile(File f) {
        try {
            String line;
            this.elencoCircuitiLM.removeAllElements();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    this.elencoCircuitiLM.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)this.elencoCircuitiLM.elementAt(this.elencoCircuitiLM.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.elencoCircuitiLM.getSize() != 0) {
            this.abilitaTutto(true);
        }
        this.apriTF.setText(f.getName());
        this.fileDestinazione = f;
        this.salvaTF.setText(f.getName());
        this.controllaSuGiu();
        System.out.println("libreria=" + this.apriTF.getText());
        if (this.apriTF.getText().endsWith("defaultCircuits.cir")) {
            this.importaB.setEnabled(false);
        } else {
            this.importaB.setEnabled(true);
        }
    }

    public void verificaFormato() {
        try {
            Integer i = Integer.parseInt(this.direzioneTF.getText());
            if (i > 360 || i < 0) {
                i = 0;
            }
            this.direzioneTF.setText(i.toString());
        }
        catch (NumberFormatException ex) {
            this.direzioneTF.setText(null);
        }
        String s = this.latitudineTF.getText();
        if (Integer.parseInt(s.substring(0, 2)) > 90 || Integer.parseInt(s.substring(2, 4)) > 59) {
            this.latitudineTF.setValue(0);
        }
        if (Integer.parseInt((s = this.longitudineTF.getText()).substring(0, 3)) > 180 || Integer.parseInt(s.substring(3, 5)) > 59) {
            this.longitudineTF.setValue(0);
        }
    }

    public void abilitaTutto(boolean abilita) {
        this.nomeTF.setEnabled(abilita);
        this.latitudineTF.setEnabled(abilita);
        this.longitudineTF.setEnabled(abilita);
        this.direzioneTF.setEnabled(abilita);
        this.emisferoTF.setEnabled(abilita);
        this.versoTF.setEnabled(abilita);
        this.numeroSplitCB.setEnabled(abilita);
        this.salva2B.setEnabled(abilita);
        this.eliminaB.setEnabled(abilita);
        this.cancelB.setEnabled(abilita);
        if (!abilita) {
            this.splitB.setEnabled(abilita);
        }
    }

    public void muoviGiu() {
        int indice = this.list.getSelectedIndex();
        if (indice == -1 || indice == this.elencoCircuitiLM.getSize() - 1) {
            return;
        }
        Object selValue = this.elencoCircuitiLM.remove(indice);
        this.elencoCircuitiLM.add(indice + 1, selValue);
        this.list.setSelectedIndex(indice + 1);
    }

    public void muoviSu() {
        int indice = this.list.getSelectedIndex();
        if (indice == -1 || indice == 0) {
            return;
        }
        Object selValue = this.elencoCircuitiLM.remove(indice);
        this.elencoCircuitiLM.add(indice - 1, selValue);
        this.list.setSelectedIndex(indice - 1);
    }

    public void salvaLista() {
        int split = 0;
        if (!this.fileDestinazione.getName().endsWith(".cir")) {
            this.fileDestinazione = new File(this.fileDestinazione.getPath() + "." + CIRC_EXTENSIONS);
        }
        if (!this.fileDestinazione.isAbsolute()) {
            this.fileDestinazione = new File(this.fileDestinazione.getAbsolutePath());
        }
        if (!this.fileDestinazione.exists() || !this.fileDestinazione.canWrite()) {
            if (!this.fileDestinazione.exists() && this.fileDestinazione.getParentFile().exists() && this.fileDestinazione.getParentFile().isDirectory() && this.fileDestinazione.getParentFile().canWrite()) {
                try {
                    this.fileDestinazione.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
                return;
            }
        }
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.fileDestinazione)));
            for (int i = 0; i < this.elencoCircuitiLM.size(); ++i) {
                Circuit c = (Circuit)this.elencoCircuitiLM.elementAt(i);
                for (split = 0; split < c.numeroAttraversamenti(); ++split) {
                    out.println(c.getMinilapString(i, split));
                }
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void controllaSuGiu() {
        if (this.list.getSelectedIndex() == 0 || this.list.getSelectedIndex() == -1) {
            this.upB.setEnabled(false);
        } else {
            this.upB.setEnabled(true);
        }
        if (this.list.getSelectedIndex() == this.elencoCircuitiLM.getSize() - 1 || this.list.getSelectedIndex() == -1) {
            this.downB.setEnabled(false);
        } else {
            this.downB.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.aggiornaComboBox(this.list.getSelectedIndex());
        this.visualizzaElemento(this.list.getSelectedIndex(), 0);
        this.numeroSplitCB.setSelectedIndex(0);
        this.controllaSuGiu();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().getClass().equals(this.apriB.getClass())) {
            Circuit c;
            int split;
            String s;
            JFileChooser fileChooser;
            JButton source = (JButton)e.getSource();
            if (source.equals(this.eliminaB) || source.equals(this.cancelB)) {
                int indiceSelezionato = this.list.getSelectedIndex();
                if (indiceSelezionato != -1) {
                    int proseguire = JOptionPane.showConfirmDialog(this, Language.string("Vuoi cancellare definitivamente il circuito selezionato?"), Language.string("ATTENZIONE"), 0);
                    if (proseguire == -1 || proseguire == 1) {
                        return;
                    }
                    this.visualizzaElemento(indiceSelezionato - 1, 0);
                    this.numeroSplitCB.setSelectedIndex(0);
                    this.list.setSelectedIndex(indiceSelezionato - 1);
                    this.elencoCircuitiLM.remove(indiceSelezionato);
                    if (indiceSelezionato == 0 && this.elencoCircuitiLM.getSize() != 0) {
                        this.list.setSelectedIndex(0);
                    }
                    this.salvaLista();
                }
                if (this.elencoCircuitiLM.getSize() == 0) {
                    this.abilitaTutto(false);
                }
                this.controllaSuGiu();
            }
            if (source.equals(this.esciB)) {
                this.dispose();
            }
            if (source.equals(this.nuovoB) || source.equals(this.addB)) {
                Circuit c2 = new Circuit("NUOVO", 0.0f, "N", 0.0f, "E", 0, 0);
                this.elencoCircuitiLM.addElement(c2);
                if (this.list.getSelectedIndex() == -1) {
                    this.list.setSelectedIndex(0);
                    this.abilitaTutto(true);
                }
                this.controllaSuGiu();
                this.salvaLista();
            }
            if (source.equals(this.apriB) || source.equals(this.openB)) {
                fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter(Language.string("Elenco circuiti"), CIRC_EXTENSIONS));
                s = DanasPreferences.getPrefDirectory("libreriaCircuitiIn");
                if (s != null) {
                    fileChooser.setCurrentDirectory(new File(s));
                }
                int res = fileChooser.showOpenDialog(this);
                DanasPreferences.setPrefDirectory("libreriaCircuitiIn", fileChooser.getCurrentDirectory().toString());
                if (res == 0) {
                    File f = fileChooser.getSelectedFile();
                    try {
                        f.setReadable(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.caricaDaFile(f);
                    this.list.setSelectionMode(0);
                    this.list.setSelectedIndex(0);
                    this.visualizzaElemento(0, 0);
                }
            }
            if (source.equals(this.salvaB) | source.equals(this.saveB)) {
                fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter(Language.string("Elenco circuiti"), CIRC_EXTENSIONS));
                s = DanasPreferences.getPrefDirectory("libreriaCircuitiOut");
                if (s != null) {
                    fileChooser.setCurrentDirectory(new File(s));
                }
                int returnVal = fileChooser.showSaveDialog(this);
                DanasPreferences.setPrefDirectory("libreriaCircuitiOut", fileChooser.getCurrentDirectory().toString());
                File f = fileChooser.getSelectedFile();
                if (returnVal == 0) {
                    this.fileDestinazione = f;
                    this.salvaTF.setText(f.getName());
                }
            }
            if (source.equals(this.salva2B)) {
                split = 0;
                if (this.nomeTF.getText().length() > 8) {
                    this.nomeTF.setText(this.nomeTF.getText().substring(0, 7));
                    JOptionPane.showMessageDialog(this, Language.string("Il nome del circuito deve avere massimo 8 caratteri"), Language.string("ATTENZIONE"), 0);
                }
                this.verificaFormato();
                split = this.numeroSplitCB.getSelectedIndex();
                if (split < ((Circuit)this.elencoCircuitiLM.elementAt(this.list.getSelectedIndex())).numeroAttraversamenti()) {
                    ((Circuit)this.elencoCircuitiLM.elementAt(this.list.getSelectedIndex())).getAttraversamento(0).setNome(this.nomeTF.getText());
                    this.inserisciDatiDaPannello(this.list.getSelectedIndex(), split);
                }
                this.salvaLista();
            }
            if (source.equals(this.importaB)) {
                System.out.println("premuto importa");
                int indice = -1;
                indice = this.list.getSelectedIndex();
                if (indice == -1) {
                    return;
                }
                c = (Circuit)this.elencoCircuitiLM.elementAt(indice);
                CircuitSplitDialog d = new CircuitSplitDialog(null);
                d.aggiungiCircuito(c);
                JOptionPane.showMessageDialog(this, Language.string("Circuito inserito nei circuiti di Default"), Language.string("INFO"), 1);
            }
            if (source.equals(this.splitB)) {
                split = this.numeroSplitCB.getSelectedIndex();
                c = (Circuit)this.elencoCircuitiLM.elementAt(this.list.getSelectedIndex());
                if (split > 0 && split < ((Circuit)this.elencoCircuitiLM.elementAt(this.list.getSelectedIndex())).numeroAttraversamenti()) {
                    int proseguire = JOptionPane.showConfirmDialog(this, Language.string("Vuoi cancellare definitivamente l'intertempo selezionato?"), Language.string("ATTENZIONE"), 0);
                    if (proseguire == -1 || proseguire == 1) {
                        return;
                    }
                    c.rimuoviSplit(split);
                    c.riordinaNomiSplit();
                    this.aggiornaComboBox(this.list.getSelectedIndex());
                    this.numeroSplitCB.setSelectedIndex(split - 1);
                    this.salvaLista();
                } else if (split > 0) {
                    c.aggiungiSplit(c.numeroAttraversamenti(), 0.0f, "N", 0.0f, "E", 0, 0, 0);
                    this.inserisciDatiDaPannello(this.list.getSelectedIndex(), c.numeroAttraversamenti() - 1);
                    this.aggiornaComboBox(this.list.getSelectedIndex());
                    this.numeroSplitCB.setSelectedIndex(c.numeroAttraversamenti() - 1);
                    this.salvaLista();
                }
            }
            if (source.equals(this.upB)) {
                this.muoviSu();
            }
            if (source.equals(this.downB)) {
                this.muoviGiu();
            }
        } else {
            JComboBox source2 = (JComboBox)e.getSource();
            if (source2.equals(this.numeroSplitCB)) {
                if (source2.getSelectedIndex() < 1) {
                    this.splitB.setEnabled(false);
                } else {
                    this.splitB.setEnabled(true);
                }
                if (this.list.getSelectedIndex() != -1 && source2.getSelectedIndex() != -1) {
                    this.visualizzaElemento(this.list.getSelectedIndex(), source2.getSelectedIndex());
                }
            }
        }
    }
}

