/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;

public class convertiDasy6 {
    private char[] data = new char[100000];
    private int posizioneFineBuffer = 0;
    InputStream in;
    int c = 0;
    int posizioneAttuale = 0;
    PrintWriter outputStream = null;
    private final int LUNGHEZZA_MAX = 97;
    private final int DIMENSIONE_BUFFER = 100000;
    private final int LUNGHEZZA_IMPOS = 97;
    private final int LUNGHEZZA_DATE = 13;
    private final int LUNGHEZZA_NEW_SESS = 8;
    private final int LUNGHEZZA_VALUE = 27;
    private final int LUNGHEZZA_GPS = 28;

    public convertiDasy6(String fileName) throws IOException {
        System.out.println("Chiamata la Converti Dasy6 su:" + fileName);
        if (!convertiDasy6.isFileDasy6(fileName)) {
            return;
        }
        System.out.println("Ok converto.");
        File lettura = new File(fileName);
        File temporaneo = new File(File.createTempFile("danas_conv_", ".tmp").getAbsolutePath());
        this.outputStream = new PrintWriter(new FileWriter(temporaneo));
        this.inizializzaBuffer(fileName);
        while (this.posizioneAttuale <= this.posizioneFineBuffer || this.c != -1) {
            int inizioFrase;
            if (this.posizioneAttuale == this.posizioneFineBuffer && this.c != -1) {
                this.aggiornaBuffer(this.posizioneAttuale);
            }
            if ((inizioFrase = this.cercaInizioFrase()) == -1) continue;
            this.identificaFrase();
        }
        this.in.close();
        this.outputStream.close();
        lettura.delete();
        this.copy(temporaneo, lettura);
    }

    void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static boolean isFileDasy6(String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(new File(fileName)));
        String l = in.readLine();
        if (l == null) {
            in.close();
            return false;
        }
        boolean res = l.length() >= 6 && l.substring(0, 6).equals("$DASY6") || l.length() >= 5 && l.substring(0, 5).equals("$Last");
        in.close();
        return res;
    }

    private void converti(char[] frase, SentenceType tipo) {
        switch (tipo) {
            case IMPOS: {
                this.outputStream.println(frase);
                break;
            }
            case DATE: {
                this.outputStream.println(frase);
                break;
            }
            case NEW_SESS: {
                this.outputStream.println("$NEW SESSION");
                break;
            }
            case VALUE: {
                this.stampaValue(frase);
                break;
            }
            case GPS: {
                this.stampaGPS(frase);
            }
        }
    }

    private void stampaValue(char[] frase) {
        String stringaOut = null;
        stringaOut = "$VALUE," + String.format("%07d,", this.getValore(frase, 23, 4, false)) + String.format("%04d,", this.getValore(frase, 5, 2, false)) + String.format("%04d,", this.getValore(frase, 7, 2, false)) + String.format("%05d,", this.getValore(frase, 19, 2, false)) + String.format("%05d,", this.getValore(frase, 21, 2, false)) + String.format("%05d,", this.getValore(frase, 17, 2, false)) + "0,0," + String.format("%04d,", this.getValore(frase, 9, 2, false)) + String.format("%04d,", this.getValore(frase, 11, 2, false)) + String.format("%04d,", this.getValore(frase, 13, 2, false)) + String.format("%04d,", this.getValore(frase, 15, 2, false));
        this.outputStream.println(stringaOut);
    }

    private void stampaGPS(char[] frase) {
        String stringaOut = null;
        stringaOut = "$GPS," + String.format("%07d", this.getValore(frase, 5, 4, false)) + ",A," + this.stampaLatitudineLongitudine(this.getValore(frase, 13, 4, true), true) + ",";
        stringaOut = this.getValore(frase, 13, 4, true) > 0 ? stringaOut + "N," : stringaOut + "S,";
        stringaOut = stringaOut + this.stampaLatitudineLongitudine(this.getValore(frase, 9, 4, true), false) + ",";
        stringaOut = this.getValore(frase, 9, 4, true) > 0 ? stringaOut + "E," : stringaOut + "W,";
        stringaOut = stringaOut + this.stampaVelocita(this.getValore(frase, 21, 4, false)) + ",";
        stringaOut = stringaOut + this.stampaOra(this.getValore(frase, 17, 4, false)) + ",";
        this.outputStream.println(stringaOut);
    }

    public String stampaVelocita(int valore) {
        int dato = valore;
        int registro2 = dato / 100;
        int registro1 = dato - registro2 * 100;
        String s = String.format("%03d.%02d", registro2, registro1);
        return s;
    }

    public String stampaOra(int valore) {
        int dato = valore;
        int decimali = 0;
        int interi = valore / 1000;
        decimali = dato - interi * 1000;
        String s = String.format("%06d.%03d", interi, decimali);
        return s;
    }

    public String stampaLatitudineLongitudine(int valore, boolean latitudine) {
        int dato = valore;
        if (dato < 0) {
            dato = -dato;
        }
        int temp = dato / 10000;
        int decimillesimi = dato - temp * 10000;
        int gradi = temp / 60;
        int primi = temp - gradi * 60;
        if (latitudine) {
            return String.format("%02d%02d.%04d", gradi, primi, decimillesimi);
        }
        return String.format("%03d%02d.%04d", gradi, primi, decimillesimi);
    }

    private int getValore(char[] frase, int posizioneIniziale, int numeroByte, boolean signed) {
        int valore = 0;
        valore = frase[posizioneIniziale];
        if (numeroByte > 1) {
            valore += frase[posizioneIniziale + 1] * 256;
        }
        if (numeroByte > 2) {
            valore += frase[posizioneIniziale + 2] * 256 * 256;
        }
        if (numeroByte > 3) {
            valore += frase[posizioneIniziale + 3] * 256 * 256 * 256;
        }
        if (signed && valore > -1) {
            valore = valore - 1 - -1;
        }
        return valore;
    }

    private void inizializzaBuffer(String fileName) throws IOException {
        this.in = new BufferedInputStream(new FileInputStream(fileName));
        int i = 0;
        while (i < this.data.length && (this.c = this.in.read()) != -1) {
            this.data[i] = (char)this.c;
            this.posizioneFineBuffer = i++;
        }
        if (this.c == -1) {
            this.in.close();
        }
    }

    private void aggiornaBuffer(int posizionePartenza) throws IOException {
        int i;
        if (this.c == -1) {
            return;
        }
        char[] dataNew = new char[this.data.length];
        for (i = posizionePartenza; i < this.data.length; ++i) {
            dataNew[i - posizionePartenza] = this.data[i];
        }
        this.posizioneFineBuffer = this.data.length - posizionePartenza - 1;
        for (i = 0; i < posizionePartenza && (this.c = this.in.read()) != -1; ++i) {
            dataNew[i + this.data.length - posizionePartenza] = (char)this.c;
            this.posizioneFineBuffer = i + this.data.length - posizionePartenza;
        }
        this.data = dataNew;
        this.posizioneAttuale = 0;
        if (this.c == -1) {
            this.in.close();
        }
    }

    private int cercaInizioFrase() throws IOException {
        while (this.posizioneAttuale <= this.posizioneFineBuffer || this.c != -1) {
            if (this.data[this.posizioneAttuale] == '$') {
                return this.posizioneAttuale;
            }
            if (this.posizioneAttuale == this.posizioneFineBuffer && this.c != -1) {
                this.aggiornaBuffer(this.posizioneAttuale);
                continue;
            }
            ++this.posizioneAttuale;
        }
        return -1;
    }

    private void identificaFrase() throws IOException {
        Enum tipo = null;
        int lunghezza = 0;
        int byteRimanenti = this.posizioneFineBuffer - this.posizioneAttuale;
        if (byteRimanenti < 97) {
            this.aggiornaBuffer(this.posizioneAttuale);
        }
        if ((byteRimanenti = this.posizioneFineBuffer - this.posizioneAttuale) > 3 && this.data[this.posizioneAttuale + 1] == 'V' && this.data[this.posizioneAttuale + 2] == 'A' && this.data[this.posizioneAttuale + 3] == 'L') {
            tipo = SentenceType.VALUE;
        } else if (byteRimanenti > 3 && this.data[this.posizioneAttuale + 1] == 'G' && this.data[this.posizioneAttuale + 2] == 'P' && this.data[this.posizioneAttuale + 3] == 'S') {
            tipo = SentenceType.GPS;
        } else if (byteRimanenti > 4 && this.data[this.posizioneAttuale + 1] == 'D' && this.data[this.posizioneAttuale + 2] == 'A' && this.data[this.posizioneAttuale + 3] == 'T' && this.data[this.posizioneAttuale + 4] == 'E') {
            tipo = SentenceType.DATE;
        } else if (byteRimanenti > 5 && this.data[this.posizioneAttuale + 1] == 'I' && this.data[this.posizioneAttuale + 2] == 'M' && this.data[this.posizioneAttuale + 3] == 'P' && this.data[this.posizioneAttuale + 4] == 'O' && this.data[this.posizioneAttuale + 5] == 'S') {
            tipo = SentenceType.IMPOS;
        } else if (byteRimanenti > 7 && this.data[this.posizioneAttuale + 1] == 'S' && this.data[this.posizioneAttuale + 2] == 'E' && this.data[this.posizioneAttuale + 3] == 'S' && this.data[this.posizioneAttuale + 4] == 'S' && this.data[this.posizioneAttuale + 5] == 'I' && this.data[this.posizioneAttuale + 6] == 'O' && this.data[this.posizioneAttuale + 7] == 'N') {
            tipo = SentenceType.NEW_SESS;
        }
        if (tipo != null) {
            switch (1.$SwitchMap$i2m$onLine$convertiDasy6$SentenceType[tipo.ordinal()]) {
                case 1: {
                    lunghezza = 97;
                    break;
                }
                case 2: {
                    lunghezza = 13;
                    break;
                }
                case 3: {
                    lunghezza = 8;
                    break;
                }
                case 4: {
                    lunghezza = 27;
                    break;
                }
                case 5: {
                    lunghezza = 28;
                }
            }
            if (byteRimanenti < lunghezza - 1) {
                ++this.posizioneAttuale;
                return;
            }
            char[] frase = new char[lunghezza];
            for (int i = 0; i < lunghezza; ++i) {
                frase[i] = this.data[this.posizioneAttuale + i];
            }
            this.converti(frase, (SentenceType)tipo);
            this.posizioneAttuale += lunghezza;
        } else {
            ++this.posizioneAttuale;
        }
    }

    public static void main(String[] args) {
        System.out.println("Test conversione Dasy6");
        JFrame fr = new JFrame();
        fr.setVisible(true);
        while (true) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileNameExtensionFilter("Sessioni", "dat"));
            int res = fileChooser.showOpenDialog(fr);
            if (res != 0) continue;
            File f = fileChooser.getSelectedFile();
            try {
                new convertiDasy6(f.getAbsolutePath());
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static enum SentenceType {
        IMPOS,
        DATE,
        NEW_SESS,
        VALUE,
        GPS;

    }
}

