/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import i2m.Language;
import i2m.onLine.UnknownPortException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class SerialConnection {
    private static final String APPLICATION_NAME = "I2M Danas2";
    private String portName;
    private SerialPort port;
    private InputStream in;
    private OutputStream out;
    private int[] buf;
    public static final int DASY4 = 0;
    public static final int MINILAP = 1;
    public static final int DASY6 = 2;
    public static final int DAE = 3;
    public static final int TC = 4;
    public static final int TPMS = 5;
    public static final int DASYPRO = 6;
    private boolean miniLAP2 = false;

    public SerialConnection(String portName) throws UnknownPortException {
        this.portName = portName;
        this.buf = new int[65535];
    }

    public static List<String> getAvailablePorts() {
        ArrayList<String> res = new ArrayList<String>();
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)en.nextElement();
            if (id.getPortType() != 1) continue;
            res.add(id.getName());
        }
        return res;
    }

    public void open(int tipoDispositivo) throws IOException {
        int flowControl;
        int timeOutApertura = 2000;
        int baudRate = 115200;
        if (tipoDispositivo == 3) {
            baudRate = 4800;
        }
        if (tipoDispositivo == 5) {
            baudRate = 19200;
        }
        if (tipoDispositivo == 4) {
            baudRate = 38400;
        }
        if (tipoDispositivo == 6) {
            baudRate = 921600;
        }
        if (tipoDispositivo == 2) {
            baudRate = 921600;
            flowControl = 1;
        } else {
            flowControl = 0;
        }
        try {
            try {
                this.port = CommPortIdentifier.getPortIdentifier(this.portName).open(APPLICATION_NAME, timeOutApertura);
            }
            catch (PortInUseException e) {
                System.out.println("Porta gi\u00e0 aperta");
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, Language.string("Errore nell'apertura della porta: riavviare Danas"), Language.string("ATTENZIONE"), 0);
            }
            try {
                this.port.setSerialPortParams(baudRate, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                JOptionPane.showMessageDialog(null, Language.string("Errore nell'apertura della porta: riavviare Danas"), Language.string("ATTENZIONE"), 0);
                e.printStackTrace();
            }
            this.port.setFlowControlMode(flowControl);
            this.port.enableReceiveTimeout(10000);
            Thread.sleep(500L);
            this.out = this.port.getOutputStream();
            this.in = this.port.getInputStream();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Opening port " + this.portName + ": " + ex);
        }
    }

    public void setTimeOut(int time) {
        try {
            this.port.enableReceiveTimeout(time);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
    }

    public boolean isMinilap2() {
        return this.miniLAP2;
    }

    public void chiudiTutto() {
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        try {
            System.out.println("chiudo porta");
            if (this.port != null) {
                this.port.close();
            }
            this.port = null;
            System.out.println("porta chiusa");
        }
        catch (Exception e) {
            System.out.println("Errore chiusura porta");
            e.printStackTrace();
        }
        this.in = null;
        this.out = null;
    }

    public String readLine() throws IOException {
        Arrays.fill(this.buf, 0);
        int pos = 0;
        while ((this.buf[pos] = this.read()) != -1) {
            if (this.buf[pos] == 13 && pos > 0 && this.buf[pos - 1] == 10) {
                this.buf[pos] = 0;
                this.buf[pos - 1] = 0;
                --pos;
                break;
            }
            ++pos;
        }
        if (this.buf[pos] == -1 && pos == 0) {
            return null;
        }
        if (this.buf[pos] == -1 && pos > 0) {
            this.buf[pos] = 0;
        }
        return new String(this.buf, 0, pos);
    }

    public String readLineTPMS() throws IOException {
        Arrays.fill(this.buf, 0);
        int pos = 0;
        while ((this.buf[pos] = this.read()) != -1) {
            if (this.buf[pos] == 10 && pos > 0 && this.buf[pos - 1] == 13) {
                this.buf[pos] = 0;
                this.buf[pos - 1] = 0;
                --pos;
                break;
            }
            ++pos;
        }
        if (this.buf[pos] == -1 && pos == 0) {
            return null;
        }
        if (this.buf[pos] == -1 && pos > 0) {
            this.buf[pos] = 0;
        }
        return new String(this.buf, 0, pos);
    }

    public void clear() throws IOException {
        try {
            this.port.enableReceiveTimeout(100);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        while (this.in.read() != -1) {
        }
        try {
            this.port.enableReceiveTimeout(10000);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
    }

    public void clear(int timeoutms) throws IOException {
        String line;
        try {
            this.port.enableReceiveTimeout(100);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        int letto = this.in.read();
        while (letto != -1) {
            letto = this.in.read();
        }
        while ((line = this.readLine()) != null) {
        }
        try {
            this.port.enableReceiveTimeout(timeoutms);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
    }

    public char readChar() throws IOException {
        int data = this.in.read();
        if (data == -1) {
            return '\u0000';
        }
        return (char)data;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public void writeVeloce(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.write(s.charAt(i));
        }
    }

    public void write(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.write(s.charAt(i));
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void write(char c) throws IOException {
        this.out.write(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SerialConnection conn = null;
        try {
            if (args.length == 0) {
                System.err.println("USAGE: java danas.communication.SerialConnection -list | -read <port>");
                System.exit(1);
            }
            if (args[0].equals("-list")) {
                List<String> ports = SerialConnection.getAvailablePorts();
                if (ports.isEmpty()) {
                    System.out.println("Strange: I could not find any available port.");
                } else {
                    System.out.println("Available ports:");
                    Iterator it = ports.iterator();
                    while (it.hasNext()) {
                        System.out.println("\t" + (String)it.next());
                    }
                }
                return;
            }
            if (args[0].equals("-read")) {
                conn = new SerialConnection(args[1]);
                System.out.print("Opening serial port...");
                conn.open(0);
                System.out.println("done!");
                System.out.println("Parameters: " + conn.port.getBaudRate() + " " + conn.port.getDataBits() + " " + conn.port.getParity() + " " + conn.port.getStopBits());
                System.out.print("Writing 'i<ret>'...");
                conn.write("i\r");
                System.out.println("done!");
                System.out.println("--------------");
                while (conn.readLine() != null) {
                }
                System.out.println("\n--------------");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

