/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.Language;
import i2m.onLine.DeviceConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SensoriDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton esciButton;
    private JButton nextButton;
    JRadioButton bottoneAnalog1;
    JRadioButton bottoneAnalog2;
    JRadioButton bottoneAnalog3;
    JRadioButton bottoneAnalog4;
    JRadioButton bottoneAnalog5;
    JRadioButton bottoneAnalog6;
    JRadioButton bottoneAnalog7;
    JRadioButton bottoneAnalog8;
    JComboBox sensoriCB;
    boolean analog1Settato = false;
    boolean analog2Settato = false;
    boolean analog3Settato = false;
    boolean analog4Settato = false;
    boolean analog5Settato = false;
    boolean analog6Settato = false;
    boolean analog7Settato = false;
    boolean analog8Settato = false;
    float minAnalog1 = 0.0f;
    float maxAnalog1 = 1023.0f;
    float minAnalog2 = 0.0f;
    float maxAnalog2 = 1023.0f;
    float minAnalog3 = 0.0f;
    float maxAnalog3 = 1023.0f;
    float minAnalog4 = 0.0f;
    float maxAnalog4 = 1023.0f;
    float minAnalog5 = 0.0f;
    float maxAnalog5 = 1023.0f;
    float minAnalog6 = 0.0f;
    float maxAnalog6 = 1023.0f;
    float minAnalog7 = 0.0f;
    float maxAnalog7 = 1023.0f;
    float minAnalog8 = 0.0f;
    float maxAnalog8 = 1023.0f;
    DeviceConnection conn = null;

    public SensoriDialog(JDialog owner, DeviceConnection connessione) {
        super(owner, Language.string("Setting sensori"), true);
        this.conn = connessione;
        JPanel pannelloBottoni = new JPanel();
        this.esciButton = new JButton(Language.string("Esci"));
        this.esciButton.addActionListener(this);
        this.nextButton = new JButton(Language.string("Avanti"));
        this.nextButton.addActionListener(this);
        pannelloBottoni.add(this.esciButton);
        pannelloBottoni.add(this.nextButton);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel sceltaSensorePanel = new JPanel();
        String[] listaSensori = new String[]{"Potenziometro 50mm", "Potenziometro 75mm", "Potenziometro 100mm", "Potenziometro 150mm", "Temperatura gomme I2M", "Pressione 50Bar", "TPS"};
        this.sensoriCB = new JComboBox<String>(listaSensori);
        this.sensoriCB.setMaximumSize(new Dimension(90, 20));
        sceltaSensorePanel.add(this.sensoriCB);
        JPanel pannelloSotto = new JPanel(new BorderLayout());
        pannelloSotto.add((Component)sceltaSensorePanel, "North");
        pannelloSotto.add((Component)pannelloBottoni, "South");
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloMessaggio = new JPanel();
        pannelloMessaggio.setLayout(new BoxLayout(pannelloMessaggio, 1));
        JLabel messageLabel = new JLabel(Language.string("Scegliere l'ingresso e selezionare il sensore voluto "));
        messageLabel.setAlignmentX(0.5f);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloMessaggio.add(messageLabel);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloPrincipale.add((Component)pannelloMessaggio, "North");
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
        JPanel pannelloScelte = new JPanel();
        pannelloScelte.setLayout(new BoxLayout(pannelloScelte, 1));
        this.bottoneAnalog1 = new JRadioButton("Analog1");
        this.bottoneAnalog2 = new JRadioButton("Analog2");
        this.bottoneAnalog3 = new JRadioButton("Analog3");
        this.bottoneAnalog4 = new JRadioButton("Analog4");
        this.bottoneAnalog5 = new JRadioButton("Analog5");
        this.bottoneAnalog6 = new JRadioButton("Analog6");
        this.bottoneAnalog7 = new JRadioButton("Analog7");
        this.bottoneAnalog8 = new JRadioButton("Analog8");
        pannelloScelte.add(this.bottoneAnalog1);
        pannelloScelte.add(this.bottoneAnalog2);
        pannelloScelte.add(this.bottoneAnalog3);
        pannelloScelte.add(this.bottoneAnalog4);
        pannelloScelte.add(this.bottoneAnalog5);
        pannelloScelte.add(this.bottoneAnalog6);
        pannelloScelte.add(this.bottoneAnalog7);
        pannelloScelte.add(this.bottoneAnalog8);
        this.bottoneAnalog1.setSelected(true);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(30, 0)));
        pannelloCentrale.add(pannelloScelte);
        ButtonGroup group = new ButtonGroup();
        group.add(this.bottoneAnalog1);
        group.add(this.bottoneAnalog2);
        group.add(this.bottoneAnalog3);
        group.add(this.bottoneAnalog4);
        group.add(this.bottoneAnalog5);
        group.add(this.bottoneAnalog6);
        group.add(this.bottoneAnalog7);
        group.add(this.bottoneAnalog8);
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)pannelloSotto, "South");
        this.setContentPane(pannelloPrincipale);
        this.setSize(new Dimension(320, 350));
        this.setResizable(false);
    }

    public boolean isAnalogSet(int index) {
        switch (index) {
            case 1: {
                return this.analog1Settato;
            }
            case 2: {
                return this.analog2Settato;
            }
            case 3: {
                return this.analog3Settato;
            }
            case 4: {
                return this.analog4Settato;
            }
            case 5: {
                return this.analog5Settato;
            }
            case 6: {
                return this.analog6Settato;
            }
            case 7: {
                return this.analog7Settato;
            }
            case 8: {
                return this.analog8Settato;
            }
        }
        return false;
    }

    public boolean isSet() {
        return this.analog1Settato || this.analog2Settato || this.analog3Settato || this.analog4Settato || this.analog5Settato || this.analog6Settato || this.analog7Settato || this.analog8Settato;
    }

    public float getMinAnalog(int index) {
        switch (index) {
            case 1: {
                return this.minAnalog1;
            }
            case 2: {
                return this.minAnalog2;
            }
            case 3: {
                return this.minAnalog3;
            }
            case 4: {
                return this.minAnalog4;
            }
            case 5: {
                return this.minAnalog5;
            }
            case 6: {
                return this.minAnalog6;
            }
            case 7: {
                return this.minAnalog7;
            }
            case 8: {
                return this.minAnalog8;
            }
        }
        return 0.0f;
    }

    public float getMaxAnalog(int index) {
        switch (index) {
            case 1: {
                return this.maxAnalog1;
            }
            case 2: {
                return this.maxAnalog2;
            }
            case 3: {
                return this.maxAnalog3;
            }
            case 4: {
                return this.maxAnalog4;
            }
            case 5: {
                return this.maxAnalog5;
            }
            case 6: {
                return this.maxAnalog6;
            }
            case 7: {
                return this.maxAnalog7;
            }
            case 8: {
                return this.maxAnalog8;
            }
        }
        return 1023.0f;
    }

    public String acquisisciLinea() throws Exception {
        return this.conn.readOnLineData();
    }

    public int leggiAnalog(String stringa, int index) throws Exception {
        int rawAnalog1 = 0;
        int rawAnalog2 = 0;
        int rawFront = 0;
        int rawRear = 0;
        int rawAnalog5 = 0;
        int rawAnalog6 = 0;
        int rawAnalog7 = 0;
        int rawAnalog8 = 0;
        String stringTempPartialData = null;
        String stringTempDataLine = stringa;
        if (stringTempDataLine.startsWith("$VALUE")) {
            StringTokenizer st = new StringTokenizer(stringTempDataLine, ",");
            stringTempPartialData = st.nextToken();
            stringTempPartialData = st.nextToken();
            stringTempPartialData = st.nextToken();
            rawFront = Integer.valueOf(stringTempPartialData);
            stringTempPartialData = st.nextToken();
            rawRear = Integer.valueOf(stringTempPartialData);
            stringTempPartialData = st.nextToken();
            stringTempPartialData = st.nextToken();
            stringTempPartialData = st.nextToken();
            stringTempPartialData = st.nextToken();
            stringTempPartialData = st.nextToken();
            stringTempPartialData = st.nextToken();
            rawAnalog1 = Integer.valueOf(stringTempPartialData);
            stringTempPartialData = st.nextToken();
            rawAnalog2 = Integer.valueOf(stringTempPartialData);
            if (st.hasMoreTokens()) {
                stringTempPartialData = st.nextToken();
                rawAnalog5 = Integer.valueOf(stringTempPartialData);
            }
            if (st.hasMoreTokens()) {
                stringTempPartialData = st.nextToken();
                rawAnalog6 = Integer.valueOf(stringTempPartialData);
            }
            if (st.hasMoreTokens()) {
                stringTempPartialData = st.nextToken();
                rawAnalog7 = Integer.valueOf(stringTempPartialData);
            }
            if (st.hasMoreTokens()) {
                stringTempPartialData = st.nextToken();
                rawAnalog8 = Integer.valueOf(stringTempPartialData);
            }
        }
        switch (index) {
            case 1: {
                return rawAnalog1;
            }
            case 2: {
                return rawAnalog2;
            }
            case 3: {
                return rawFront;
            }
            case 4: {
                return rawRear;
            }
            case 5: {
                return rawAnalog5;
            }
            case 6: {
                return rawAnalog6;
            }
            case 7: {
                return rawAnalog7;
            }
            case 8: {
                return rawAnalog8;
            }
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int index = 1;
        if (this.bottoneAnalog1.isSelected()) {
            index = 1;
        }
        if (this.bottoneAnalog2.isSelected()) {
            index = 2;
        }
        if (this.bottoneAnalog3.isSelected()) {
            index = 3;
        }
        if (this.bottoneAnalog4.isSelected()) {
            index = 4;
        }
        if (this.bottoneAnalog5.isSelected()) {
            index = 5;
        }
        if (this.bottoneAnalog6.isSelected()) {
            index = 6;
        }
        if (this.bottoneAnalog7.isSelected()) {
            index = 7;
        }
        if (this.bottoneAnalog8.isSelected()) {
            index = 8;
        }
        if (evt.getSource() == this.esciButton) {
            this.dispose();
        }
        if (evt.getSource() == this.nextButton) {
            if (this.sensoriCB.getSelectedIndex() == 0 || this.sensoriCB.getSelectedIndex() == 1 || this.sensoriCB.getSelectedIndex() == 2 || this.sensoriCB.getSelectedIndex() == 3) {
                float lunghezza = 150.0f;
                if (this.sensoriCB.getSelectedIndex() == 0) {
                    lunghezza = 50.0f;
                }
                if (this.sensoriCB.getSelectedIndex() == 1) {
                    lunghezza = 75.0f;
                }
                if (this.sensoriCB.getSelectedIndex() == 2) {
                    lunghezza = 100.0f;
                }
                if (this.sensoriCB.getSelectedIndex() == 3) {
                    lunghezza = 150.0f;
                }
                JOptionPane.showMessageDialog(null, Language.string("Premere OK per fissare lo zero"), Language.string("Setting"), 1);
                float minimo = 0.0f;
                float massimo = 1023.0f;
                float zero = 0.0f;
                try {
                    zero = this.leggiAnalog(this.acquisisciLinea(), index);
                    minimo = -(zero * lunghezza / 1023.0f);
                    massimo = lunghezza - zero * lunghezza / 1023.0f;
                    if (this.bottoneAnalog1.isSelected()) {
                        this.analog1Settato = true;
                        this.minAnalog1 = minimo;
                        this.maxAnalog1 = massimo;
                    }
                    if (this.bottoneAnalog2.isSelected()) {
                        this.analog2Settato = true;
                        this.minAnalog2 = minimo;
                        this.maxAnalog2 = massimo;
                    }
                    if (this.bottoneAnalog3.isSelected()) {
                        this.analog3Settato = true;
                        this.minAnalog3 = minimo;
                        this.maxAnalog3 = massimo;
                    }
                    if (this.bottoneAnalog4.isSelected()) {
                        this.analog4Settato = true;
                        this.minAnalog4 = minimo;
                        this.maxAnalog4 = massimo;
                    }
                    if (this.bottoneAnalog5.isSelected()) {
                        this.analog5Settato = true;
                        this.minAnalog5 = minimo;
                        this.maxAnalog5 = massimo;
                    }
                    if (this.bottoneAnalog6.isSelected()) {
                        this.analog6Settato = true;
                        this.minAnalog6 = minimo;
                        this.maxAnalog6 = massimo;
                    }
                    if (this.bottoneAnalog7.isSelected()) {
                        this.analog7Settato = true;
                        this.minAnalog7 = minimo;
                        this.maxAnalog7 = massimo;
                    }
                    if (this.bottoneAnalog8.isSelected()) {
                        this.analog8Settato = true;
                        this.minAnalog8 = minimo;
                        this.maxAnalog8 = massimo;
                    }
                    JOptionPane.showMessageDialog(null, Language.string("potenziometro lineare configurato"), Language.string("Setting"), 1);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                }
            }
            if (this.sensoriCB.getSelectedIndex() == 4) {
                JOptionPane.showMessageDialog(null, Language.string("Sensore di Temperatura configurato"), Language.string("Setting"), 1);
                if (this.bottoneAnalog1.isSelected()) {
                    this.analog1Settato = true;
                    this.minAnalog1 = -37.5f;
                    this.maxAnalog1 = 262.5f;
                }
                if (this.bottoneAnalog2.isSelected()) {
                    this.analog2Settato = true;
                    this.minAnalog2 = -37.5f;
                    this.maxAnalog2 = 262.5f;
                }
                if (this.bottoneAnalog3.isSelected()) {
                    this.analog3Settato = true;
                    this.minAnalog3 = -37.5f;
                    this.maxAnalog3 = 262.5f;
                }
                if (this.bottoneAnalog4.isSelected()) {
                    this.analog4Settato = true;
                    this.minAnalog4 = -37.5f;
                    this.maxAnalog4 = 262.5f;
                }
                if (this.bottoneAnalog5.isSelected()) {
                    this.analog5Settato = true;
                    this.minAnalog5 = -37.5f;
                    this.maxAnalog5 = 262.5f;
                }
                if (this.bottoneAnalog6.isSelected()) {
                    this.analog6Settato = true;
                    this.minAnalog6 = -37.5f;
                    this.maxAnalog6 = 262.5f;
                }
                if (this.bottoneAnalog7.isSelected()) {
                    this.analog7Settato = true;
                    this.minAnalog7 = -37.5f;
                    this.maxAnalog7 = 262.5f;
                }
                if (this.bottoneAnalog8.isSelected()) {
                    this.analog8Settato = true;
                    this.minAnalog8 = -37.5f;
                    this.maxAnalog8 = 262.5f;
                }
            }
            if (this.sensoriCB.getSelectedIndex() == 5) {
                JOptionPane.showMessageDialog(null, Language.string("Sensore di pressione configurato"), Language.string("Setting"), 1);
                if (this.bottoneAnalog1.isSelected()) {
                    this.analog1Settato = true;
                    this.minAnalog1 = 0.0f;
                    this.maxAnalog1 = 50.0f;
                }
                if (this.bottoneAnalog2.isSelected()) {
                    this.analog2Settato = true;
                    this.minAnalog2 = 0.0f;
                    this.maxAnalog2 = 50.0f;
                }
                if (this.bottoneAnalog3.isSelected()) {
                    this.analog3Settato = true;
                    this.minAnalog3 = 0.0f;
                    this.maxAnalog3 = 50.0f;
                }
                if (this.bottoneAnalog4.isSelected()) {
                    this.analog4Settato = true;
                    this.minAnalog4 = 0.0f;
                    this.maxAnalog4 = 50.0f;
                }
                if (this.bottoneAnalog5.isSelected()) {
                    this.analog5Settato = true;
                    this.minAnalog5 = 0.0f;
                    this.maxAnalog5 = 50.0f;
                }
                if (this.bottoneAnalog7.isSelected()) {
                    this.analog7Settato = true;
                    this.minAnalog7 = 0.0f;
                    this.maxAnalog7 = 50.0f;
                }
                if (this.bottoneAnalog8.isSelected()) {
                    this.analog8Settato = true;
                    this.minAnalog8 = 0.0f;
                    this.maxAnalog8 = 50.0f;
                }
            }
            if (this.sensoriCB.getSelectedIndex() == 6) {
                JOptionPane.showMessageDialog(null, Language.string("Chiudere completamente il gas e premere OK"), Language.string("Setting"), 1);
                float TPSmin = 0.0f;
                try {
                    TPSmin = this.leggiAnalog(this.acquisisciLinea(), index);
                    JOptionPane.showMessageDialog(null, Language.string("Aprire completamente il gas e premere OK"), Language.string("Setting"), 1);
                    float TPSmax = 0.0f;
                    TPSmax = this.leggiAnalog(this.acquisisciLinea(), index);
                    JOptionPane.showMessageDialog(null, Language.string("Sensore TPS configurato"), Language.string("Setting"), 1);
                    float minimo = 0.0f;
                    float massimo = 1023.0f;
                    if (TPSmin != TPSmax) {
                        minimo = -TPSmin * (102300.0f / (TPSmax - TPSmin)) / 1023.0f;
                        massimo = 102300.0f / (TPSmax - TPSmin) + minimo;
                    }
                    System.out.println("TPS minimo=" + minimo + " massimo=" + massimo);
                    if (this.bottoneAnalog1.isSelected()) {
                        this.analog1Settato = true;
                        this.minAnalog1 = minimo;
                        this.maxAnalog1 = massimo;
                    }
                    if (this.bottoneAnalog2.isSelected()) {
                        this.analog2Settato = true;
                        this.minAnalog2 = minimo;
                        this.maxAnalog2 = massimo;
                    }
                    if (this.bottoneAnalog3.isSelected()) {
                        this.analog3Settato = true;
                        this.minAnalog3 = minimo;
                        this.maxAnalog3 = massimo;
                    }
                    if (this.bottoneAnalog4.isSelected()) {
                        this.analog4Settato = true;
                        this.minAnalog4 = minimo;
                        this.maxAnalog4 = massimo;
                    }
                    if (this.bottoneAnalog5.isSelected()) {
                        this.analog5Settato = true;
                        this.minAnalog5 = minimo;
                        this.maxAnalog5 = massimo;
                    }
                    if (this.bottoneAnalog6.isSelected()) {
                        this.analog6Settato = true;
                        this.minAnalog6 = minimo;
                        this.maxAnalog6 = massimo;
                    }
                    if (this.bottoneAnalog7.isSelected()) {
                        this.analog7Settato = true;
                        this.minAnalog7 = minimo;
                        this.maxAnalog7 = massimo;
                    }
                    if (this.bottoneAnalog8.isSelected()) {
                        this.analog8Settato = true;
                        this.minAnalog8 = minimo;
                        this.maxAnalog8 = massimo;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                }
            }
        }
    }

    public static void main(String[] args) {
        SensoriDialog test = new SensoriDialog(null, null);
        test.setVisible(true);
    }
}

