/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.Language;
import i2m.RiassuntoSessione;
import i2m.onLine.DeviceConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreviewSession
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    JButton aggiornaB;
    JButton caricaB;
    JButton caricaTutteB;
    JButton esciB;
    private JCheckBox filtroKmCB;
    private JCheckBox filtroGpsCB;
    private JFormattedTextField distanzaTF;
    private JCheckBox filtroNomeCB;
    private JComboBox circuitoCB;
    private JList listSessioni;
    private DefaultListModel sessioniLM;
    private DefaultListModel sessioniFiltrateLM;
    private JScrollPane listScroller;
    private boolean downloadEseguito = false;
    private DeviceConnection conn;
    private Thread downloadMonitorThread = null;
    private String nomeFile;

    public PreviewSession(Frame owner, String f, DeviceConnection con) {
        super(owner, Language.string("Anteprima"), true);
        this.nomeFile = f;
        this.conn = con;
        this.sessioniLM = new DefaultListModel();
        this.sessioniLM.clear();
        this.sessioniFiltrateLM = new DefaultListModel();
        this.sessioniFiltrateLM.clear();
        this.costruisciInterfaccia();
        this.caricaCircuiti();
        System.out.println("apro finestra preview");
        File f1 = this.conn.downloadRiassunto();
        System.out.println("Caricato riassunto");
        try {
            this.convertiRiassunto(f1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setResizable(false);
    }

    private void costruisciInterfaccia() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.aggiornaB = new JButton(Language.string("Filtra"));
        this.aggiornaB.addActionListener(this);
        this.caricaB = new JButton(Language.string("Apri selezionate"));
        this.caricaB.addActionListener(this);
        this.caricaTutteB = new JButton(Language.string("Apri tutte"));
        this.caricaTutteB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.aggiornaB);
        pannelloBottoni.add(this.caricaB);
        pannelloBottoni.add(this.caricaTutteB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        JPanel pannelloSinistro = new JPanel();
        pannelloSinistro.setLayout(new BoxLayout(pannelloSinistro, 1));
        JPanel filtriPanel = new JPanel();
        filtriPanel.setLayout(new BoxLayout(filtriPanel, 1));
        JLabel filtroLabel = new JLabel(Language.string("  Filtri: "));
        JPanel panelDistanza = new JPanel();
        panelDistanza.setLayout(new BoxLayout(panelDistanza, 0));
        this.filtroKmCB = new JCheckBox(Language.string("Solo le sessioni con indice > "));
        this.filtroKmCB.addActionListener(this);
        this.filtroKmCB.setSelected(false);
        NumberFormat KmFormat = NumberFormat.getNumberInstance(Locale.US);
        KmFormat.setMaximumIntegerDigits(10);
        KmFormat.setMaximumFractionDigits(0);
        KmFormat.setGroupingUsed(false);
        this.distanzaTF = new JFormattedTextField(KmFormat);
        this.distanzaTF.setHorizontalAlignment(11);
        this.distanzaTF.setMaximumSize(new Dimension(80, 20));
        this.distanzaTF.setPreferredSize(new Dimension(80, 20));
        this.distanzaTF.setValue(0);
        this.distanzaTF.setEnabled(false);
        panelDistanza.add(this.filtroKmCB);
        panelDistanza.add(Box.createRigidArea(new Dimension(63, 20)));
        panelDistanza.add(this.distanzaTF);
        panelDistanza.add(Box.createRigidArea(new Dimension(10, 20)));
        panelDistanza.setAlignmentX(0.0f);
        this.filtroGpsCB = new JCheckBox(Language.string("Solo se GPS valido"));
        this.filtroNomeCB = new JCheckBox(Language.string("Solo se circuito =      "));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        String[] listaCircuiti = new String[]{};
        this.circuitoCB = new JComboBox<String>(listaCircuiti);
        this.circuitoCB.setMaximumSize(new Dimension(90, 20));
        filtroLabel.setAlignmentX(0.0f);
        this.filtroGpsCB.setAlignmentX(0.0f);
        panel.setAlignmentX(0.0f);
        filtriPanel.setAlignmentX(1.0f);
        panel.add(this.filtroNomeCB);
        panel.add(Box.createRigidArea(new Dimension(100, 20)));
        panel.add(this.circuitoCB);
        filtriPanel.add(filtroLabel);
        filtriPanel.add(panelDistanza);
        filtriPanel.add(this.filtroGpsCB);
        filtriPanel.add(panel);
        filtriPanel.setBorder(BorderFactory.createEtchedBorder(0));
        filtriPanel.setAlignmentX(1.0f);
        this.listSessioni = new JList(this.sessioniFiltrateLM);
        this.listSessioni.setSelectionMode(2);
        this.listSessioni.setLayoutOrientation(0);
        this.listSessioni.setSelectedIndex(0);
        this.listSessioni.setPreferredSize(new Dimension(90, 8000));
        this.listSessioni.addListSelectionListener(this);
        this.listScroller = new JScrollPane(this.listSessioni);
        this.listScroller.setPreferredSize(new Dimension(90, 190));
        this.listScroller.setVerticalScrollBarPolicy(22);
        this.listScroller.setAlignmentX(0.0f);
        pannelloSinistro.add(this.listScroller);
        pannelloPrincipale.add((Component)pannelloSinistro, "West");
        pannelloPrincipale.add((Component)pannelloSinistro, "North");
        pannelloPrincipale.add((Component)filtriPanel, "Center");
        this.pack();
    }

    private void monitorDownload() {
        this.setEnabled(false);
        ProgressMonitor mon = new ProgressMonitor(this, Language.string("Scaricamento dati in corso"), "", 0, 100);
        while (!mon.isCanceled() && this.conn.getDownloadProgress() != -1 && this.conn.getDownloadProgress() < 100) {
            mon.setProgress(this.conn.getDownloadProgress());
            mon.setNote(Language.string("Completato: ") + this.conn.getDownloadProgress() + "%");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (mon.isCanceled()) {
            System.out.println("Premuto annulla");
            this.conn.stopDownloading();
            JOptionPane.showMessageDialog(this, Language.string("Download dati annullato"), "Download", 1);
        } else {
            mon.setProgress(100);
            this.downloadEseguito = true;
            if (this.conn.getDownloadProgress() == -1) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
            } else {
                JOptionPane.showMessageDialog(this, Language.string("Download dati completato"), "Download", 1);
            }
        }
        this.setEnabled(true);
        this.requestFocus();
        this.downloadMonitorThread = null;
        this.dispose();
    }

    public void caricaCircuiti() {
        int indice = 0;
        try {
            String line;
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.circuitoCB.removeAllItems();
            while ((line = in.readLine()) != null) {
                String[] temp = line.split(",");
                if (!line.startsWith("t")) continue;
                this.circuitoCB.insertItemAt(temp[2], indice);
                if (this.circuitoCB.getItemCount() != 0) {
                    this.circuitoCB.setSelectedIndex(0);
                }
                ++indice;
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Non sono riuscito ad aprire il buffer di lettura sul file dei circuiti");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public String stampaOra(int valore) {
        int dato = valore;
        int decimali = 0;
        int interi = valore / 1000;
        decimali = dato - interi * 1000;
        String s = String.format("%06d.%03d", interi, decimali);
        return s;
    }

    private void convertiRiassunto(File f) throws IOException {
        String line;
        String[] temp = null;
        RiassuntoSessione sessione = null;
        RiassuntoSessione precedente = null;
        int i = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        while ((line = in.readLine()) != null) {
            System.out.println("Linea scaricata=" + line);
            temp = line.split(",");
            if (line.startsWith("$SESSIONE:") || line.startsWith("$SESSIONE,")) {
                System.out.println("Trovata nuova sessione");
                sessione = new RiassuntoSessione(i);
                if (!this.conn.isMinilap2()) {
                    sessione.setPreviewDasy(true);
                    this.estraiDatiSessione(line, sessione);
                } else {
                    sessione.setPreviewMini(true);
                    this.estraiDatiSessioneMini(line, sessione);
                }
                this.sessioniFiltrateLM.addElement(sessione);
                if (i > 0 && !this.conn.isMinilap2()) {
                    precedente = (RiassuntoSessione)this.sessioniFiltrateLM.getElementAt(i - 1);
                    precedente.setFineMemoriaDasy(sessione.getInizioMemoriaDasy());
                }
                ++i;
            }
            if (!line.startsWith("$MEM FREE") || this.conn.isMinilap2() || this.sessioniFiltrateLM.size() == 0) continue;
            precedente = (RiassuntoSessione)this.sessioniFiltrateLM.getElementAt(i - 1);
            precedente.setFineMemoriaDasy(Integer.valueOf(temp[1]));
        }
        for (int j = 0; j < this.sessioniFiltrateLM.size(); ++j) {
            this.sessioniLM.addElement(this.sessioniFiltrateLM.getElementAt(j));
        }
        if (this.sessioniLM.size() > 0) {
            this.listSessioni.setSelectedIndex(this.sessioniLM.size() - 1);
        }
        in.close();
    }

    private void estraiDatiSessione(String line, RiassuntoSessione sessione) {
        String[] temp = null;
        temp = line.split(",");
        sessione.setInizioMemoriaDasy(Integer.valueOf(temp[2]));
        if (temp.length < 4) {
            return;
        }
        sessione.setGpsValido(true);
        sessione.setData(temp[4]);
        int ora = Integer.valueOf(temp[18]) + Integer.valueOf(temp[19]) * 256 + Integer.valueOf(temp[20]) * 256 * 256 + Integer.valueOf(temp[21]) * 256 * 256 * 256;
        sessione.setInizio(this.stampaOra(ora));
        int lati = this.estraiCoordinata(Integer.valueOf(temp[14]), Integer.valueOf(temp[15]), Integer.valueOf(temp[16]), Integer.valueOf(temp[17]));
        int longi = this.estraiCoordinata(Integer.valueOf(temp[10]), Integer.valueOf(temp[11]), Integer.valueOf(temp[12]), Integer.valueOf(temp[13]));
        sessione.setCircuito(this.trovaCircuito(lati, longi));
    }

    private void estraiDatiSessioneMini(String line, RiassuntoSessione sessione) {
        String[] temp = null;
        temp = line.split(",");
        sessione.setNumeroSessioneMini(Integer.valueOf(temp[1]));
        sessione.setGpsValido(true);
        sessione.setData(temp[3]);
        System.out.println("Data=" + temp[3]);
        sessione.setInizio(temp[12]);
        System.out.println("Inizio=" + temp[12]);
        int lati = Integer.valueOf(temp[7].substring(0, 2)) * 600000 + Integer.valueOf(temp[7].substring(2, 4)) * 10000 + Integer.valueOf(temp[7].substring(5));
        int longi = Integer.valueOf(temp[9].substring(0, 3)) * 600000 + Integer.valueOf(temp[9].substring(3, 5)) * 10000 + Integer.valueOf(temp[9].substring(6));
        if (temp[8].startsWith("S")) {
            lati = -lati;
        }
        if (temp[10].startsWith("W")) {
            longi = -longi;
        }
        sessione.setCircuito(this.trovaCircuito(lati, longi));
        sessione.setInizioMemoriaDasy(Integer.valueOf(temp[13]));
        sessione.setFineMemoriaDasy(Integer.valueOf(temp[14]));
    }

    private int estraiCoordinata(int b1, int b2, int b3, int b4) {
        int valore = b1 + b2 * 256 + b3 * 256 * 256 + b4 * 256 * 256 * 256;
        if (valore > -1) {
            valore = valore - 1 - -1;
        }
        return valore;
    }

    private void filtra() {
        int primaSessione = Integer.valueOf(this.distanzaTF.getValue().toString());
        this.sessioniFiltrateLM.clear();
        String nome = null;
        String circuitoScelto = this.circuitoCB.getSelectedIndex() != -1 ? (String)this.circuitoCB.getSelectedItem() : null;
        for (int i = 0; i < this.sessioniLM.size(); ++i) {
            boolean validGps = ((RiassuntoSessione)this.sessioniLM.getElementAt(i)).isGpsValido();
            nome = ((RiassuntoSessione)this.sessioniLM.getElementAt(i)).getCircuito();
            if ((!validGps || !this.filtroGpsCB.isSelected()) && this.filtroGpsCB.isSelected() || (i <= primaSessione || !this.filtroKmCB.isSelected()) && this.filtroKmCB.isSelected() || (!nome.equals(circuitoScelto) || !this.filtroNomeCB.isSelected()) && this.filtroNomeCB.isSelected()) continue;
            this.sessioniFiltrateLM.addElement(this.sessioniLM.getElementAt(i));
        }
        this.listSessioni.setModel(this.sessioniFiltrateLM);
        if (this.sessioniFiltrateLM.size() > 0) {
            this.listSessioni.setSelectedIndex(0);
        }
    }

    public boolean isConversioneFinita() {
        return this.conn.isConversioneFinita();
    }

    public String trovaCircuito(int lati, int longi) {
        String risultato = null;
        boolean trovato = false;
        try {
            String line;
            String emi = lati > 0 ? "N" : "S";
            String verso = longi > 0 ? "E" : "W";
            int latitudine = Math.abs(lati);
            int longitudine = Math.abs(longi);
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                String[] temp = line.split(",");
                if (!line.startsWith("t")) continue;
                int latitudineTraguardo = Integer.valueOf(temp[3].substring(0, 2)) * 600000 + Integer.valueOf(temp[3].substring(2, 4)) * 10000 + Integer.valueOf(temp[3].substring(5));
                int longitudineTraguardo = Integer.valueOf(temp[5].substring(0, 3)) * 600000 + Integer.valueOf(temp[5].substring(3, 5)) * 10000 + Integer.valueOf(temp[5].substring(6));
                if (trovato || !emi.equals(temp[4]) || !verso.equals(temp[6]) || Math.abs(latitudine - latitudineTraguardo) >= 7000 || Math.abs(longitudine - longitudineTraguardo) >= 7000) continue;
                trovato = true;
                risultato = temp[2];
            }
            in.close();
            if (trovato) {
                return risultato;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Non sono riuscito ad aprire il buffer di lettura sul file dei circuiti");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.out.println(e.toString());
            System.out.println("errore nel parsing dei dati GPS");
        }
        return Language.string("non in elenco");
    }

    public boolean isDownloadEseguito() {
        return this.downloadEseguito;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.esciB)) {
            this.downloadEseguito = false;
            this.setVisible(false);
        }
        if (e.getSource().equals(this.caricaTutteB) || e.getSource().equals(this.caricaB)) {
            try {
                if (e.getSource().equals(this.caricaTutteB)) {
                    this.conn.startDownloadSessioni(this.nomeFile, this.listSessioni.getSelectedIndices(), this.sessioniFiltrateLM, true);
                } else {
                    this.conn.startDownloadSessioni(this.nomeFile, this.listSessioni.getSelectedIndices(), this.sessioniFiltrateLM, false);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
            this.downloadMonitorThread = new Thread(){

                @Override
                public void run() {
                    PreviewSession.this.monitorDownload();
                }
            };
            this.downloadMonitorThread.setDaemon(true);
            this.downloadMonitorThread.start();
        }
        if (e.getSource().equals(this.aggiornaB)) {
            this.filtra();
        }
        if (e.getSource().equals(this.filtroKmCB)) {
            this.distanzaTF.setEnabled(this.filtroKmCB.isSelected());
        }
    }
}

