/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DanasPreferences;
import i2m.Language;
import i2m.onLine.DeviceConnection;
import i2m.onLine.PreviewSession;
import i2m.onLine.UnknownPortException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DownloadDialog
extends JDialog
implements WindowListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int NIENTE = 0;
    public static final int FORMATTA = 1;
    public static final int ANTEPRIMA = 2;
    public static final int DOWNLOAD = 3;
    private JButton downloadButton;
    private JButton connectionButton;
    private JButton formatButton;
    private JButton browseButton;
    private JButton previewButton;
    private JCheckBox saveCBox;
    private JTextField pathTField;
    private JFileChooser fileChooser;
    private Thread downloadMonitorThread;
    private boolean saveOnFile;
    private boolean dowloadedData;
    private DeviceConnection conn;
    private String portName;
    private String tempFileName;
    private Frame padre;
    JRadioButton bottoneMiniLap;
    JRadioButton bottoneDasyX;
    JRadioButton bottoneTC;
    private PreviewSession pDialog = null;
    private int tipoDispositivo = 0;
    private boolean miniLapTipo2 = false;
    public int postAction = 0;
    private int indiceFile = 0;

    public DownloadDialog(Frame owner, String portname) throws UnknownPortException {
        super(owner, Language.string("Download dati"), true);
        this.portName = portname;
        this.padre = owner;
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("Danas files", "dat", "txt"));
        String s = DanasPreferences.getPrefDirectory("downloaddirectory");
        if (s != null) {
            this.fileChooser.setCurrentDirectory(new File(s));
        }
        JPanel pannelloBottoni = new JPanel();
        this.downloadButton = new JButton("Download");
        this.downloadButton.addActionListener(this);
        this.formatButton = new JButton(Language.string("Formatta SD"));
        this.formatButton.addActionListener(this);
        this.connectionButton = new JButton(Language.string("Connetti"));
        this.connectionButton.addActionListener(this);
        this.previewButton = new JButton(Language.string("Anteprima"));
        this.previewButton.setEnabled(false);
        this.previewButton.addActionListener(this);
        pannelloBottoni.add(this.downloadButton);
        pannelloBottoni.add(this.formatButton);
        pannelloBottoni.add(this.previewButton);
        this.previewButton.setEnabled(true);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel filesavePanel = new JPanel();
        this.saveCBox = new JCheckBox(Language.string("Salva su File"));
        this.saveCBox.addActionListener(this);
        this.saveCBox.setSelected(DanasPreferences.getPrefSaveDownload());
        this.pathTField = new JTextField(30);
        this.browseButton = new JButton(Language.string("Sfoglia"));
        this.browseButton.addActionListener(this);
        if (s != null) {
            this.pathTField.setText(s + "/");
        }
        if (!this.saveCBox.isSelected()) {
            this.pathTField.setEnabled(false);
            this.browseButton.setEnabled(false);
        } else {
            this.pathTField.setEnabled(true);
            this.browseButton.setEnabled(true);
        }
        filesavePanel.add(this.saveCBox);
        filesavePanel.add(this.pathTField);
        filesavePanel.add(this.browseButton);
        JPanel pannelloSotto = new JPanel(new BorderLayout());
        pannelloSotto.add((Component)filesavePanel, "North");
        pannelloSotto.add((Component)pannelloBottoni, "South");
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloMessaggio = new JPanel();
        pannelloMessaggio.setLayout(new BoxLayout(pannelloMessaggio, 1));
        JLabel messageLabel = new JLabel(Language.string("Scegliere il sistema e premere connetti per il collegamento "));
        messageLabel.setAlignmentX(0.5f);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloMessaggio.add(messageLabel);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloPrincipale.add((Component)pannelloMessaggio, "North");
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
        JPanel pannelloScelte = new JPanel();
        pannelloScelte.setLayout(new BoxLayout(pannelloScelte, 1));
        this.bottoneMiniLap = new JRadioButton("MiniLAP vers. R");
        this.bottoneMiniLap.addActionListener(this);
        this.bottoneDasyX = new JRadioButton("Dasy X");
        this.bottoneDasyX.addActionListener(this);
        this.bottoneTC = new JRadioButton("TC GPS");
        JRadioButton bottoneDatalogger = new JRadioButton("Datalogger MTK");
        bottoneDatalogger.setEnabled(false);
        pannelloScelte.add(this.bottoneMiniLap);
        pannelloScelte.add(this.bottoneDasyX);
        this.bottoneDasyX.setSelected(true);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(30, 0)));
        pannelloCentrale.add(pannelloScelte);
        ButtonGroup group = new ButtonGroup();
        group.add(this.bottoneMiniLap);
        group.add(this.bottoneDasyX);
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)pannelloSotto, "South");
        this.setContentPane(pannelloPrincipale);
        this.setSize(new Dimension(600, 250));
        this.setResizable(true);
        this.addWindowListener(this);
        int ultimo = DanasPreferences.getUltimoDevice();
        switch (ultimo) {
            case 1: {
                this.bottoneMiniLap.setSelected(true);
                break;
            }
            case 3: {
                this.bottoneDasyX.setSelected(true);
            }
        }
        try {
            this.tempFileName = File.createTempFile("danas_dload_", ".tmp").getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.downloadMonitorThread = null;
        this.setConnected(false);
        this.conn = new DeviceConnection(this.portName);
    }

    private int getUltimoIndiceFile(String s) {
        int massimo = 0;
        if (s == null) {
            return 0;
        }
        File folder = new File(s);
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            int num;
            if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().startsWith("I2M_run-") || listOfFiles[i].getName().length() <= 12) continue;
            String numero = (String)listOfFiles[i].getName().subSequence(8, listOfFiles[i].getName().length() - 4);
            try {
                num = Integer.valueOf(numero);
            }
            catch (NumberFormatException e) {
                num = 0;
            }
            if (num <= massimo) continue;
            massimo = num;
        }
        return massimo;
    }

    private void connect(int postAzione) {
        this.postAction = postAzione;
        if (this.conn.isConnected()) {
            return;
        }
        int ultimo = 0;
        if (this.bottoneMiniLap.isSelected()) {
            ultimo = 1;
        }
        if (this.bottoneDasyX.isSelected()) {
            ultimo = 3;
        }
        DanasPreferences.setUltimoDevice(ultimo);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                System.out.println("Apro thread");
                JDialog f1 = new JDialog((Dialog)DownloadDialog.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                new JButton(new ImageIcon(ImgUrl));
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Il sistema sta verificando le porte COM disponibili") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                progressBar.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(progressBar);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                try {
                    int dispositivo = 1;
                    if (DownloadDialog.this.bottoneMiniLap.isSelected()) {
                        dispositivo = 1;
                    }
                    if (DownloadDialog.this.bottoneDasyX.isSelected()) {
                        dispositivo = 2;
                    }
                    DownloadDialog.this.tipoDispositivo = dispositivo;
                    System.out.println("Chiamo la connessione");
                    DownloadDialog.this.conn.connect(dispositivo);
                    if (dispositivo == 1) {
                        DownloadDialog.this.miniLapTipo2 = DownloadDialog.this.conn.isMinilap2();
                    }
                    DownloadDialog.this.setConnected(true);
                }
                catch (Exception e) {
                    f1.setVisible(false);
                    JOptionPane.showMessageDialog(DownloadDialog.this.padre, Language.string("Errore di connessione: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    DownloadDialog.this.setConnected(false);
                    DownloadDialog.this.requestFocus();
                    return;
                }
                finally {
                    f1.setVisible(false);
                    DownloadDialog.this.setVisible(true);
                    switch (DownloadDialog.this.postAction) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            DownloadDialog.this.format();
                            DownloadDialog.this.disconnect();
                            break;
                        }
                        case 2: {
                            DownloadDialog.this.preview();
                            DownloadDialog.this.disconnect();
                            break;
                        }
                        case 3: {
                            System.out.println("scarica dati");
                            DownloadDialog.this.scaricaDati();
                        }
                    }
                }
            }
        }.start();
        this.requestFocus();
        this.setVisible(true);
        this.padre.requestFocus();
        this.padre.setVisible(true);
    }

    public void setConnected(boolean connected) {
        if (connected) {
            this.connectionButton.setText(Language.string("Disconnetti"));
            this.downloadButton.setEnabled(false);
            this.formatButton.setEnabled(false);
            this.previewButton.setEnabled(false);
        } else {
            if (this.downloadMonitorThread != null) {
                try {
                    if (Thread.currentThread() != this.downloadMonitorThread) {
                        this.downloadMonitorThread.join();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.connectionButton.setText(Language.string("Connetti"));
            this.downloadButton.setEnabled(false);
            this.formatButton.setEnabled(true);
            if (this.bottoneDasyX.isSelected() || this.miniLapTipo2) {
                this.previewButton.setEnabled(true);
            } else {
                this.previewButton.setEnabled(false);
            }
            if (!this.bottoneDasyX.isSelected()) {
                this.downloadButton.setEnabled(true);
            } else {
                this.downloadButton.setEnabled(false);
            }
        }
    }

    private void disconnect() {
        if (!this.conn.isConnected()) {
            return;
        }
        try {
            if (this.tipoDispositivo == 4) {
                this.conn.disconnectTc();
            } else {
                this.conn.disconnect();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Language.string("Errore di disconnessione: impossibile chiudere la connessione"), Language.string("ATTENZIONE"), 0);
        }
        this.setConnected(false);
        this.requestFocus();
    }

    public String getFileName() {
        if (this.saveCBox.isSelected()) {
            return this.pathTField.getText();
        }
        return this.tempFileName;
    }

    public boolean isSavedOnFile() {
        return this.saveOnFile;
    }

    public boolean isDataDownloaded() {
        return this.dowloadedData;
    }

    private void monitorDownload() {
        this.setEnabled(false);
        ProgressMonitor mon = new ProgressMonitor(this, Language.string("Scaricamento dati in corso"), "", 0, 100);
        while (!mon.isCanceled() && this.conn.getDownloadProgress() != -1 && this.conn.getDownloadProgress() < 100) {
            mon.setProgress(this.conn.getDownloadProgress());
            if (this.conn.getDownloadProgress() == 99) {
                mon.setNote("Conversione in corso");
            }
            mon.setNote(Language.string("Completato: ") + this.conn.getDownloadProgress() + "%");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (mon.isCanceled()) {
            System.out.println("Premuto annulla");
            this.dowloadedData = false;
            this.conn.stopDownloading();
            JOptionPane.showMessageDialog(this, Language.string("Download dati annullato"), "Download", 1);
        } else {
            mon.setProgress(100);
            if (this.conn.getDownloadProgress() == -1) {
                this.dowloadedData = true;
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
            } else {
                this.dowloadedData = true;
                JOptionPane.showMessageDialog(this, Language.string("Download dati completato"), "Download", 1);
            }
        }
        this.setEnabled(true);
        this.requestFocus();
        this.connectionButton.setEnabled(true);
        this.disconnect();
        this.downloadMonitorThread = null;
    }

    public void controllaFile() {
        if (this.saveCBox.isSelected()) {
            File downloadFile;
            if (this.pathTField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, Language.string("Inserire il nome del file prima di procedere"), Language.string("ATTENZIONE"), 0);
                return;
            }
            if (new File(this.pathTField.getText()).isDirectory()) {
                this.indiceFile = this.getUltimoIndiceFile(this.pathTField.getText());
                this.pathTField.setText(this.pathTField.getText() + "I2M_run-" + (this.indiceFile + 1) + ".txt");
            }
            this.saveOnFile = true;
            if (!this.pathTField.getText().endsWith(".txt")) {
                this.pathTField.setText(this.pathTField.getText() + ".txt");
            }
            if (!(downloadFile = new File(this.pathTField.getText())).isAbsolute()) {
                downloadFile = new File(downloadFile.getAbsolutePath());
            }
            if (downloadFile.exists() && downloadFile.canWrite()) {
                int resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Sovrascrivere il file esistente?"), Language.string("ATTENZIONE"), 0);
                if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                    this.saveOnFile = false;
                    return;
                }
            } else if (!downloadFile.exists() && downloadFile.getParentFile().exists() && downloadFile.getParentFile().isDirectory() && downloadFile.getParentFile().canWrite()) {
                try {
                    downloadFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.saveOnFile = false;
                JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
                return;
            }
        }
    }

    public void DownloadDispose() {
        this.dispose();
    }

    public void preview() {
        this.controllaFile();
        if (this.saveCBox.isSelected() && !this.saveOnFile) {
            return;
        }
        PreviewSession p = new PreviewSession(this.padre, this.getFileName(), this.conn);
        p.setLocationRelativeTo(null);
        p.setVisible(true);
        this.pDialog = p;
        if (p.isDownloadEseguito()) {
            if (!p.isConversioneFinita()) {
                new Thread(){

                    @Override
                    public void run() {
                        JDialog f1 = new JDialog((Dialog)DownloadDialog.this, Language.string("ATTENZIONE!"));
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 0));
                        panel.add(new JLabel("      "));
                        panel.add(new JLabel("      "));
                        panel.add(new JLabel("<html>" + Language.string("Il sistema sta convertendo i dati..") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                        panel.add(new JLabel("      "));
                        JPanel pannelloCentrale = new JPanel();
                        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                        f1.setContentPane(pannelloCentrale);
                        pannelloCentrale.add(new JLabel("    "));
                        pannelloCentrale.add(panel);
                        pannelloCentrale.add(new JLabel("    "));
                        JProgressBar progressBar = new JProgressBar(0, 100);
                        progressBar.setIndeterminate(true);
                        progressBar.setMaximumSize(new Dimension(330, 40));
                        pannelloCentrale.add(progressBar);
                        pannelloCentrale.add(new JLabel("    "));
                        f1.pack();
                        f1.setLocationRelativeTo(null);
                        f1.setAlwaysOnTop(true);
                        f1.setVisible(true);
                        f1.setResizable(false);
                        while (!DownloadDialog.this.pDialog.isConversioneFinita()) {
                        }
                        DownloadDialog.this.dowloadedData = true;
                        DownloadDialog.this.DownloadDispose();
                    }
                }.start();
            } else {
                this.dowloadedData = true;
                this.dispose();
            }
        }
    }

    public void scaricaDati() {
        this.connectionButton.setEnabled(false);
        this.controllaFile();
        try {
            this.conn.startDownloadingStoredData(this.getFileName());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        this.downloadMonitorThread = new Thread(){

            @Override
            public void run() {
                DownloadDialog.this.monitorDownload();
            }
        };
        this.downloadMonitorThread.setDaemon(true);
        this.downloadMonitorThread.start();
    }

    public void format() {
        this.connectionButton.setEnabled(false);
        int result = JOptionPane.showConfirmDialog(this, Language.string("Continuare con la formattazione della memoria?"), "Attenzione", 0);
        if (result == 0) {
            try {
                if (this.bottoneMiniLap.isSelected()) {
                    this.conn.format(1);
                } else if (this.bottoneDasyX.isSelected()) {
                    this.conn.format(2);
                }
                JOptionPane.showMessageDialog(this, Language.string("Formattazione eseguita correttamente"), "Formattazione", 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                this.disconnect();
            }
        }
        this.connectionButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.bottoneMiniLap || evt.getSource() == this.bottoneDasyX) {
            if (!this.bottoneDasyX.isSelected()) {
                this.downloadButton.setEnabled(true);
                this.previewButton.setEnabled(false);
            } else {
                this.downloadButton.setEnabled(false);
                this.previewButton.setEnabled(true);
            }
        }
        if (evt.getSource() == this.connectionButton) {
            if (this.conn.isConnected()) {
                this.disconnect();
            } else {
                this.connect(0);
            }
        }
        if (evt.getSource() == this.previewButton) {
            DanasPreferences.setPrefSaveDownload(this.saveCBox.isSelected());
            this.connect(2);
        }
        if (evt.getSource() == this.downloadButton) {
            DanasPreferences.setPrefSaveDownload(this.saveCBox.isSelected());
            this.connect(3);
        } else if (evt.getSource() == this.saveCBox) {
            this.pathTField.setEnabled(this.saveCBox.isSelected());
            this.browseButton.setEnabled(this.saveCBox.isSelected());
        } else if (evt.getSource() == this.browseButton) {
            int returnVal = this.fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.pathTField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
                DanasPreferences.setPrefDirectory("downloaddirectory", this.fileChooser.getCurrentDirectory().toString());
            }
        } else if (evt.getSource() == this.formatButton) {
            this.connect(1);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.out.println("Chiudo finestra...");
        if (!this.conn.isConnected()) {
            return;
        }
        System.out.println("era connessa...");
        try {
            this.disconnect();
            System.out.println("disonnessa...");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

