/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.ParametriciDialog;
import i2m.Language;
import i2m.onLine.CanChannelsDialog;
import i2m.onLine.CanTableRow;
import i2m.onLine.SensoriDialogDasyPro;
import i2m.onLine.SerialConnection;
import i2m.wifi.FileDati;
import i2m.wifi.WifiDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.MaskFormatter;

public class DasyProSettingsDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    JTabbedPane tabbedPane;
    Frame padre;
    JButton importaB;
    JButton esportaB;
    JButton ripristinaB;
    JButton trasmettiWifiB;
    JButton riceviWifiB;
    JButton defaultInputB;
    JButton configuraSensoriB;
    JButton importaUsbB;
    JButton esportaUsbB;
    private JButton listaB;
    private JButton scaricaB;
    private JButton cancellaB;
    private JButton cancellaTuttiB;
    private JButton softwareB;
    private JButton firmwareB;
    private JButton resetSessionB;
    JButton acquisisciB;
    JButton connettiB;
    JButton configuraCanB;
    JButton sensoriButton;
    JFormattedTextField nomeTF;
    JFormattedTextField minimoTF;
    JFormattedTextField massimoTF;
    JFormattedTextField circonferenzaTF;
    JFormattedTextField anterioreTF;
    JFormattedTextField posterioreTF;
    JFormattedTextField primaTF;
    JFormattedTextField secondaTF;
    JFormattedTextField terzaTF;
    JFormattedTextField quartaTF;
    JFormattedTextField quintaTF;
    JFormattedTextField sestaTF;
    JFormattedTextField prefisso;
    JFormattedTextField rete;
    JFormattedTextField password;
    JFormattedTextField reteHot;
    JFormattedTextField passwordHot;
    JFormattedTextField neutro0TF;
    JFormattedTextField neutro1TF;
    JFormattedTextField neutro2TF;
    JFormattedTextField neutro3TF;
    JFormattedTextField neutro4TF;
    JFormattedTextField neutro5TF;
    JFormattedTextField neutro6TF;
    JComboBox tipoSensoreCB;
    JComboBox tpmsAntCB;
    JComboBox tpmsPostCB;
    JComboBox standCB;
    JComboBox velMinCB;
    JComboBox canaleStartCB;
    JComboBox frequenzaCB;
    JComboBox baudCanCB;
    JComboBox baudCan2CB;
    JComboBox<String> motoCB;
    JComboBox<String> sceltaCOM;
    JComboBox<String> salvataggioCB;
    JComboBox canaleDigitaleCB;
    JComboBox canaleAnalogicoCB;
    JComboBox pignoneCB;
    JComboBox coronaCB;
    JComboBox impulsiCB;
    JComboBox fusoCB;
    JTextField[] canaliRealTime;
    JTextField canaleRssiAnteriore;
    JTextField canaleRssiPosteriore;
    JTextField versioneSoftware;
    JTextField versioneFirmware;
    JTextField numeroSessioni;
    JTextField ultimaSessione;
    JLabel[] labelRealTime;
    JRadioButton wifiON;
    JRadioButton wifiOFF;
    JRadioButton hotON;
    JRadioButton hotOFF;
    String[] nomeCanali;
    private SerialConnection conn;
    private String[] elencoCom = null;
    float[] valoriMinimiCanali;
    float[] valoriMassimiCanali;
    int[] tipoSensoreCanali;
    int pignone1;
    int pignone2;
    int corona1;
    int corona2;
    int circonferenza1;
    int circonferenza2;
    int impulsi1;
    int impulsi2;
    int impulsiRpm;
    int indiceAnalogicoPrecedente;
    int indiceDigitalePrecedente;
    int indiceAnteriorePrecedente;
    int indicePosteriorePrecedente;
    String caratteriValidi = "qwertyuiopasdfghjklzxcvbnm QWERTYUIOPASDFGHJKLZXCVBNM1234567890";
    String caratteriValidiNoSpazio = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890";
    String caratteriNumerici = "1234567890 ";
    double[] sensoreA;
    double[] sensoreB;
    double[] sensoreC;
    int numeroA;
    int numeroB;
    int numeroC;
    String[] idAnteriori;
    String[] idPosteriori;
    CanChannelsDialog canDialog;
    Vector<CanTableRow> elencoRigheCan;
    boolean connected = false;
    boolean aggiornamentoTpms = false;
    private Thread continuousModeThread;
    private boolean parametriCambiati = false;
    private JList listFile;
    private DefaultListModel elencoFileLM;
    Vector<FileDati> elencoFileDati;
    private JProgressBar progress;
    String directoryDownload;
    private Thread downloadMonitorThread;
    private Thread downloadThread;
    private Thread gestoreDownloadThread;
    private int indiceFile = -1;
    private int percentualeDownload = 0;
    private boolean downloadAnnullato = false;
    private int valoreRssiAnteriore;
    private int valoreRssiPosteriore;
    private int valoreRssiAnterioreProvvisorio;
    private int valoreRssiPosterioreProvvisorio;
    ProgressMonitor mon;
    private final int YAMAHA = 8;
    private final int KAWASAKI = 9;
    private final int SUZUKI = 10;
    private final int HONDA = 11;
    private final int DUCATI = 12;
    private final int YAMAHA6 = 13;
    private final int KAWACAN = 14;
    private final int BMW = 15;
    private final int BMW_ABS = 16;
    private final int DUCATI_1198 = 17;
    private final int DUCATI_1198_TC = 18;
    private final int BMW_HP4 = 19;
    private final int BMW_HL = 20;
    private final int PEDERCINI = 21;
    private final int KAWA_RACE = 22;
    private final int K7_1000 = 23;
    private final int k7M_1000 = 24;
    private final int k9_1000 = 25;
    private final int k9M_1000 = 26;
    private final int k8_600 = 27;
    private final int k8M_600 = 28;
    private final int MV_F3_675 = 29;
    private final int CBR_1000_08 = 30;
    private final int ZX6R_07 = 31;
    private final int ZX10R_08 = 32;
    private final int R6_06 = 33;
    private final int CBR600_08 = 34;
    private final int R1_07 = 35;
    private final int EMU = 36;
    private final int MOTEC = 37;
    private final int DUCATI_899 = 38;
    private final int DUCATI_1199 = 39;
    private final int RSV4_ABS = 40;
    private final int RSV_08 = 41;
    private final int BMW2015 = 42;
    private final int BMW2015DDC = 43;
    private final int R1M_2015 = 44;
    private final int R1_2015 = 45;
    private final int MOTEC_AUTO = 46;
    private final int ZX10R_16 = 47;
    private final int CBR1000M = 48;
    private final int MKE7 = 49;
    private final int TEST_BIKE = 50;
    private final int DUCATI_1299 = 51;
    private final int DUCATI_1199R = 52;
    private final int GMT = 53;
    private final int NINJA300 = 54;
    private final int R62017 = 55;
    private final int RSV_APRC = 56;
    private final int GSXR_17 = 57;
    private final int F3_MEK = 58;
    private final int R6_MEK = 59;
    private final int R32017 = 60;
    private final int DUCATI_V4 = 61;
    private final int NINJA400 = 62;
    private final int R1_2018 = 63;
    private final int RSV4_17 = 64;
    private final int R1_SBK = 65;
    private final int CBR_2017 = 66;
    private final int NINJA400WSS = 67;
    private final int ZX_EWC = 68;
    private final int ZX636 = 69;
    private final int YZF250 = 70;
    private final int WSS19 = 71;
    private final int R1_2020 = 72;
    private final int GMT94_17 = 73;
    private final int FREE = 74;
    private final int RSV4_19 = 75;
    private final int BMW_19 = 76;
    private final int R1_TECH = 77;
    private final int R6_KIT = 78;
    private final int GMT94 = 79;
    private final int IGNITECH = 80;
    private final int GMT94_20 = 81;
    private final int DUCATI_959 = 82;
    private final int ZX10R_SBK = 83;
    private final int CBR1000_2020 = 84;
    private final int DUCATIV4S = 85;
    private final int R1_SBK2 = 86;
    private final int DUCATI_V4_20 = 87;
    private final int DUCATI_V4S_20 = 88;
    private final int CIV20 = 89;
    private final int CBR1000HRC = 90;
    private final int BIKE19 = 91;
    private final int DUCATI_V2 = 92;
    private final int DUCATI_V4R_19 = 93;
    private final int ZX10R_21 = 94;
    private final int ZX10R_21RACE = 95;
    private final int R7_2022 = 96;
    private final int DUCATIV4_22 = 97;
    private final int DUCATIV4S_22 = 98;
    private final int NG22 = 99;
    private final int RSV4_21 = 100;
    private final int CBR1000HRC22 = 101;
    private final int RS660 = 102;
    private final int DUCATIV4_23 = 104;
    private final int DUCATIV4S_23 = 105;
    private final int BMW_22 = 106;
    private final int BMW_23 = 107;
    private final int BMW2018DDC = 108;
    private final int CBR600_24 = 110;
    private final int CBR1000HRC24 = 114;
    private final int ZX6R_24 = 115;
    private final int R9_24 = 116;
    private final int DUCATIV4_25 = 117;
    private final int DUCATIV4S_25 = 118;
    private final int DUCATIV4_25E = 119;
    private final int DUCATIV4S_25E = 120;
    String[] motoList = new String[]{"Yamaha R1", "Yamaha R3 2017", "Yamaha R7 2022", "Yamaha R9 2024", "CIV Premoto3 2019", "Yamaha R6", "Yamaha R6 06-14", "R6 2017", "Yamaha R6 Mek", "Yamaha R6 Mek Kit", "Yamaha R1 07-08", "Yamaha R1 Mek KIT", "YAMAHA R1M 2015", "YAMAHA R1 2015", "R1 GMT94", "R1 GMT94 18-19", "R1 GMT94 2020", "R1 2018", "R1 2020", "Kawasaki", "Ninja 300", "Ninja 400", "Ninja 400WSS", "ZX6R 07-16", "ZX636", "ZX6R 2024", "ZX10R 08-10", "ZX10R 2011", "ZX10R 2011 Race", "ZX10R 2016", "ZX10R Pedercini", "ZX10R 2016 EWC", "ZX10R 2021 (beta)", "ZX10R 2021 kit (beta)", "Suzuki", "GSXR 1000 K7", "GSXR 1000 k7M", "GSXR 1000 k9", "GSXR 1000 k9M", "GSXR 1000 2017", "GSXR 600 k8", "GSXR 600 k8M", "Honda", "CBR600RR 08-13", "CBR600RR 2024", "CBR1000RR 08-10", "CBR1000RR 11-16", "CBR1000SP 17-19", "CBR1000RR 20-24", "CBR1000RR 2020 HRC", "CBR1000RR 2022 HRC", "CBR1000RR 2024 HRC", "Ducati", "DUCATI 1198", "DUCATI 1198 TC", "Ducati 899", "Ducati 1199", "Ducati 959 2017", "Ducati 1299", "Ducati V4 18-19", "Ducati V4S 18-19", "Ducati V4 2020", "Ducati V4S 2020", "Ducati V4 22-23 STD", "Ducati V4S 22-23 STD", "Ducati V4 22-23 EVO", "Ducati V4S 22-23 EVO", "Ducati V4 2025 STD", "Ducati V4S 2025 STD", "Ducati V4 2025 EVO", "Ducati V4S 2025 EVO", "Ducati V4R 2019", "Ducati V2", "BMW S1000RR ABS", "BMW S1000RR HP4", "BMW S1000RR HL", "BMW S1000RR 2015 HP", "BMW S1000RR 2018 HP", "BMW 2019", "BMW 2022", "BMW 2023", "MV F3", "MV F3 Mek", "ECU Master", "Motec M800", "MOTEC AUTO", "Aprilia RSV 08-12", "Aprilia RSV4APRC", "Aprilia RSV4APRC ABS", "RSV4 2017", "RSV4 2019", "RSV4 2021", "RS660", "MK7", "Test Bike", "Mecktronik WSS 2023", "Mecktronik NG 2023", "Ignitech", "MOTEC CIV 2021", "Mectronik Bike 2019"};
    private boolean ripristinoInCorso = false;
    private boolean cancellaContatori = false;
    Vector<String> frasiNonUtilizzate = new Vector();
    boolean aggiornamentoNomiInCorso = false;
    boolean salvataggioFallito = false;
    boolean importazioneInCorso = false;
    boolean acquisizioneInCorso = false;
    float[] datiLetti = new float[154];
    float[] datiProvvisori = new float[154];
    double[] sensoreAOld;
    double[] sensoreBOld;
    double[] sensoreCOld;
    String[] nomeCanaliOld;
    float[] valoriMinimiCanaliOld;
    float[] valoriMassimiCanaliOld;
    int[] tipoSensoreCanaliOld;
    String[] idAnterioriOld;
    String[] idPosterioriOld;
    int pignone1Old;
    int pignone2Old;
    int corona1Old;
    int corona2Old;
    int circonferenza1Old;
    int circonferenza2Old;
    int impulsi1Old;
    int impulsi2Old;
    int impulsiRpmOld;
    int indiceAnteriorePrecedenteOld;
    int indicePosteriorePrecedenteOld;
    Vector<CanTableRow> elencoRigheCanOld = new Vector();
    boolean primaConfigurazione = true;

    public DasyProSettingsDialog(Frame owner, String[] lista) {
        super(owner, Language.string("Configurazione settings DataLog-PRO"), false);
        this.elencoCom = lista;
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.inizializzaVariabili();
        this.tabbedPane = new JTabbedPane();
        JPanel pannelloCom = this.costruisciPannelloCom();
        this.tabbedPane.addTab(Language.string("Generale"), this.costruisciPanelAcquisizione());
        this.tabbedPane.addTab(Language.string("Ingressi"), this.costruisciPanelIngressi());
        this.tabbedPane.addTab(Language.string("TPMS e Can Bus"), this.costruisciPanelSensoriCan());
        this.costruisciPanelWiFi();
        this.tabbedPane.addTab(Language.string("Online"), this.costruisciPanelOnline());
        this.tabbedPane.addTab(Language.string("Download"), this.costruisciPanelDownload());
        this.tabbedPane.addTab(Language.string("Info"), this.costruisciPanelInfo());
        this.tabbedPane.addChangeListener(this);
        pannelloPrincipale.add((Component)pannelloCom, "North");
        pannelloPrincipale.add((Component)this.costruisciPannelloBottoni(), "South");
        pannelloPrincipale.add((Component)this.tabbedPane, "Center");
        this.ripristinaFabbrica();
        this.aggiornaCampi();
        this.aggiornaPorteCom();
        this.abilitaWifi(true);
        this.abilitaUsb(false);
        this.verificaMarce();
        this.aggiornaNomiOnline();
        this.pack();
        this.setSize(new Dimension(600, 800));
        this.addWindowListener(this);
        this.padre = owner;
    }

    public void inizializzaVariabili() {
        this.sensoreA = new double[10];
        this.sensoreB = new double[10];
        this.sensoreC = new double[10];
        this.nomeCanali = new String[12];
        this.valoriMinimiCanali = new float[12];
        this.valoriMassimiCanali = new float[12];
        this.tipoSensoreCanali = new int[12];
        this.idAnteriori = new String[4];
        this.idPosteriori = new String[4];
        this.canDialog = new CanChannelsDialog(this);
        this.canDialog.setVisible(false);
        this.elencoRigheCan = this.canDialog.getElencoRighe();
        this.elencoRigheCanOld = new Vector();
        for (int i = 0; i < this.canDialog.getElencoRighe().size(); ++i) {
            this.elencoRigheCanOld.add(this.canDialog.getElencoRighe().get(i).duplica());
        }
        this.sensoreAOld = new double[10];
        this.sensoreBOld = new double[10];
        this.sensoreCOld = new double[10];
        this.nomeCanaliOld = new String[12];
        this.valoriMinimiCanaliOld = new float[12];
        this.valoriMassimiCanaliOld = new float[12];
        this.tipoSensoreCanaliOld = new int[12];
        this.idAnterioriOld = new String[4];
        this.idPosterioriOld = new String[4];
    }

    public void consolidaValoriAttuali(boolean aggiornaPrima) {
        int i;
        if (aggiornaPrima) {
            this.primaConfigurazione = false;
        }
        for (i = 0; i < 10; ++i) {
            this.sensoreAOld[i] = this.sensoreA[i];
            this.sensoreBOld[i] = this.sensoreA[i];
            this.sensoreCOld[i] = this.sensoreA[i];
        }
        for (i = 0; i < 12; ++i) {
            this.valoriMinimiCanaliOld[i] = this.valoriMinimiCanali[i];
            this.valoriMassimiCanaliOld[i] = this.valoriMassimiCanali[i];
            this.tipoSensoreCanaliOld[i] = this.tipoSensoreCanali[i];
        }
        for (i = 0; i < 4; ++i) {
            this.idAnterioriOld[i] = this.idAnteriori[i];
            this.idPosterioriOld[i] = this.idPosteriori[i];
        }
        this.pignone1Old = this.pignone1;
        this.pignone2Old = this.pignone2;
        this.corona1Old = this.corona1;
        this.corona2Old = this.corona2;
        this.circonferenza1Old = this.circonferenza1;
        this.circonferenza2Old = this.circonferenza2;
        this.impulsi1Old = this.impulsi1;
        this.impulsi2Old = this.impulsi2;
        this.impulsiRpmOld = this.impulsiRpm;
        this.indiceAnteriorePrecedenteOld = this.indiceAnteriorePrecedente;
        this.indicePosteriorePrecedenteOld = this.indicePosteriorePrecedente;
        this.elencoRigheCanOld.clear();
        for (i = 0; i < this.canDialog.getElencoRighe().size(); ++i) {
            this.elencoRigheCanOld.add(this.canDialog.getElencoRighe().get(i).duplica());
        }
    }

    public boolean getValoriCambiati() {
        int i;
        boolean cambiati = false;
        for (i = 0; i < 10; ++i) {
            if (this.sensoreAOld[i] != this.sensoreA[i]) {
                cambiati = true;
            }
            if (this.sensoreBOld[i] != this.sensoreA[i]) {
                cambiati = true;
            }
            if (this.sensoreCOld[i] == this.sensoreA[i]) continue;
            cambiati = true;
        }
        for (i = 0; i < 12; ++i) {
            if (this.valoriMinimiCanaliOld[i] != this.valoriMinimiCanali[i]) {
                cambiati = true;
            }
            if (this.valoriMassimiCanaliOld[i] != this.valoriMassimiCanali[i]) {
                cambiati = true;
            }
            if (this.tipoSensoreCanaliOld[i] == this.tipoSensoreCanali[i]) continue;
            cambiati = true;
        }
        for (i = 0; i < 4; ++i) {
            if (!this.idAnterioriOld[i].equals(this.idAnteriori[i])) {
                cambiati = true;
            }
            if (this.idPosterioriOld[i].equals(this.idPosteriori[i])) continue;
            cambiati = true;
        }
        if (this.pignone1Old != this.pignone1) {
            cambiati = true;
        }
        if (this.pignone2Old != this.pignone2) {
            cambiati = true;
        }
        if (this.corona1Old != this.corona1) {
            cambiati = true;
        }
        if (this.corona2Old != this.corona2) {
            cambiati = true;
        }
        if (this.circonferenza1Old != this.circonferenza1) {
            cambiati = true;
        }
        if (this.circonferenza2Old != this.circonferenza2) {
            cambiati = true;
        }
        if (this.impulsi1Old != this.impulsi1) {
            cambiati = true;
        }
        if (this.impulsi2Old != this.impulsi2) {
            cambiati = true;
        }
        if (this.impulsiRpmOld != this.impulsiRpm) {
            cambiati = true;
        }
        if (this.indiceAnteriorePrecedenteOld != this.indiceAnteriorePrecedente) {
            cambiati = true;
        }
        if (this.indicePosteriorePrecedenteOld != this.indicePosteriorePrecedente) {
            cambiati = true;
        }
        for (i = 0; i < this.elencoRigheCan.size(); ++i) {
            if (this.elencoRigheCanOld.get(i).equals(this.elencoRigheCan.get(i))) continue;
            cambiati = true;
        }
        return cambiati;
    }

    public void aggiornaPorteCom() {
        if (this.elencoCom != null) {
            for (int i = 0; i < this.elencoCom.length; ++i) {
                this.sceltaCOM.addItem(this.elencoCom[i]);
            }
            if (this.elencoCom.length > 0) {
                this.sceltaCOM.setSelectedIndex(0);
            }
        }
    }

    public void ripristinaFabbrica() {
        int i;
        this.ripristinoInCorso = true;
        this.motoCB.setSelectedIndex(0);
        this.standCB.setSelectedIndex(0);
        this.fusoCB.setSelectedIndex(13);
        this.numeroC = 5;
        this.numeroB = 5;
        this.numeroA = 5;
        for (i = 0; i < 10; ++i) {
            this.sensoreA[i] = i;
            this.sensoreB[i] = i;
            this.sensoreC[i] = i;
        }
        for (i = 0; i < 4; ++i) {
            this.idAnteriori[i] = "0000000";
            this.idPosteriori[i] = "0000000";
            this.idAnterioriOld[i] = "0000000";
            this.idPosterioriOld[i] = "0000000";
        }
        this.setFrequencyCombo(10);
        this.velMinCB.setSelectedIndex(2);
        this.canaleStartCB.setSelectedIndex(1);
        this.prefisso.setText(this.getStringImportata("I2M", 10));
        this.wifiOFF.setSelected(true);
        this.rete.setValue("   ");
        this.password.setValue("    ");
        this.primaTF.setValue(Float.valueOf(1.0f));
        this.secondaTF.setValue(Float.valueOf(2.0f));
        this.terzaTF.setValue(Float.valueOf(3.0f));
        this.quartaTF.setValue(Float.valueOf(4.0f));
        this.quintaTF.setValue(Float.valueOf(5.0f));
        this.sestaTF.setValue(Float.valueOf(6.0f));
        for (i = 0; i < 12; ++i) {
            this.nomeCanali[i] = this.getStringImportata("Analog" + (i + 1), 10);
            this.valoriMinimiCanali[i] = 0.0f;
            this.valoriMassimiCanali[i] = 1023.0f;
            this.tipoSensoreCanali[i] = 0;
        }
        this.nomeCanali[4] = "Lambda";
        this.valoriMinimiCanali[4] = 8.0f;
        this.valoriMassimiCanali[4] = 22.0f;
        for (i = 0; i < 10; ++i) {
            this.sensoreA[i] = i * 1023 / 9;
            this.sensoreB[i] = i * 1023 / 9;
            this.sensoreC[i] = i * 1023 / 9;
        }
        this.numeroA = 10;
        this.numeroB = 10;
        this.numeroC = 10;
        this.pignone1 = 14;
        this.pignone2 = 0;
        this.corona1 = 43;
        this.corona2 = 0;
        this.circonferenza1 = 1950;
        this.circonferenza2 = 1980;
        this.impulsi1 = 3;
        this.impulsi2 = 0;
        this.impulsiRpm = 0;
        this.anterioreTF.setValue("0000000");
        this.posterioreTF.setValue("0000000");
        this.canDialog.ripristinaTabella();
        this.ripristinoInCorso = false;
    }

    public void setActionListener(boolean attiva) {
        if (attiva) {
            this.tipoSensoreCB.addActionListener(this);
            this.canaleAnalogicoCB.addActionListener(this);
        } else {
            this.tipoSensoreCB.removeActionListener(this);
            this.canaleAnalogicoCB.removeActionListener(this);
        }
    }

    public void aggiornaCampi() {
        this.setActionListener(false);
        this.nomeTF.setValue(this.getStringaPulita(this.nomeCanali[this.canaleAnalogicoCB.getSelectedIndex()]));
        this.minimoTF.setValue(Float.valueOf(this.valoriMinimiCanali[this.canaleAnalogicoCB.getSelectedIndex()]));
        this.massimoTF.setValue(Float.valueOf(this.valoriMassimiCanali[this.canaleAnalogicoCB.getSelectedIndex()]));
        this.tipoSensoreCB.setSelectedIndex(this.tipoSensoreCanali[this.canaleAnalogicoCB.getSelectedIndex()]);
        this.anterioreTF.setText(this.idAnteriori[this.tpmsAntCB.getSelectedIndex()]);
        this.posterioreTF.setText(this.idPosteriori[this.tpmsPostCB.getSelectedIndex()]);
        switch (this.canaleDigitaleCB.getSelectedIndex()) {
            case 0: {
                this.impulsiCB.setSelectedIndex(this.impulsiRpm);
                this.pignoneCB.setEnabled(false);
                this.coronaCB.setEnabled(false);
                this.circonferenzaTF.setEnabled(false);
                break;
            }
            case 1: {
                this.impulsiCB.setSelectedIndex(this.impulsi1);
                this.pignoneCB.setEnabled(true);
                this.coronaCB.setEnabled(true);
                this.circonferenzaTF.setEnabled(true);
                this.pignoneCB.setSelectedIndex(this.pignone1);
                this.coronaCB.setSelectedIndex(this.corona1);
                this.circonferenzaTF.setValue(this.circonferenza1);
                break;
            }
            case 2: {
                this.impulsiCB.setSelectedIndex(this.impulsi2);
                this.pignoneCB.setEnabled(true);
                this.coronaCB.setEnabled(true);
                this.circonferenzaTF.setEnabled(true);
                this.pignoneCB.setSelectedIndex(this.pignone2);
                this.coronaCB.setSelectedIndex(this.corona2);
                this.circonferenzaTF.setValue(this.circonferenza2);
            }
        }
        this.setActionListener(true);
        this.aggiornaNomiOnline();
    }

    public void abilitaWifi(boolean abilita) {
        this.trasmettiWifiB.setEnabled(abilita);
        this.riceviWifiB.setEnabled(abilita);
    }

    public void abilitaUsb(boolean abilita) {
        this.importaUsbB.setEnabled(abilita);
        this.esportaUsbB.setEnabled(abilita);
        this.acquisisciB.setEnabled(abilita);
        this.listaB.setEnabled(abilita);
        this.scaricaB.setEnabled(abilita);
        this.cancellaB.setEnabled(abilita);
        this.cancellaTuttiB.setEnabled(abilita);
        this.softwareB.setEnabled(abilita);
        this.firmwareB.setEnabled(abilita);
        this.resetSessionB.setEnabled(abilita);
    }

    public void connetti() {
        if (this.connected) {
            return;
        }
        if (this.sceltaCOM.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(null, Language.string("Selezionare una porta"), Language.string("Attenzione"), 2);
            return;
        }
        this.sceltaCOM.setEnabled(false);
        try {
            this.conn = new SerialConnection(this.elencoCom[this.sceltaCOM.getSelectedIndex()]);
            this.conn.open(1);
            this.conn.clear();
            this.conn.setTimeOut(1000);
            this.connected = true;
            this.conn.write("Ready\r");
            System.out.println("SCritto ready");
            String end = this.conn.readLine();
            if (end == null || !end.startsWith("Ready")) {
                this.conn.close();
                this.sceltaCOM.setEnabled(true);
                this.connected = false;
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return;
            }
            this.connettiB.setText(Language.string("Disconnetti"));
            this.aggiornaListaFile();
            this.abilitaUsb(true);
            this.riceviUsb();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sceltaCOM.setEnabled(true);
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        }
    }

    public void disconnetti() {
        if (this.getAcquisisciContinuo()) {
            this.setAcquisisciContinuo(false);
            try {
                if (Thread.currentThread() != this.continuousModeThread) {
                    this.continuousModeThread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.acquisisciB.setText(Language.string("Avvia lettura Online (USB)"));
        }
        if (!this.connected) {
            return;
        }
        try {
            this.sceltaCOM.setEnabled(true);
            this.connected = false;
            this.conn.clear(1000);
            while (this.conn.readLine() != null) {
            }
            this.conn.close();
            System.out.println("DEBUG: Chiusa connessione USB");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connettiB.setText(Language.string("Connetti"));
        this.abilitaUsb(false);
    }

    public void salvaValoriIngressiCorrenti(int indiceAnalogico, int indiceDigitale) {
        if (this.importazioneInCorso) {
            return;
        }
        switch (indiceDigitale) {
            case 0: {
                this.impulsiRpm = this.impulsiCB.getSelectedIndex();
                break;
            }
            case 1: {
                this.impulsi1 = this.impulsiCB.getSelectedIndex();
                this.pignone1 = this.pignoneCB.getSelectedIndex();
                this.corona1 = this.coronaCB.getSelectedIndex();
                this.circonferenza1 = Integer.valueOf(this.circonferenzaTF.getText());
                break;
            }
            case 2: {
                this.impulsi2 = this.impulsiCB.getSelectedIndex();
                this.pignone2 = this.pignoneCB.getSelectedIndex();
                this.corona2 = this.coronaCB.getSelectedIndex();
                this.circonferenza2 = Integer.valueOf(this.circonferenzaTF.getText());
            }
        }
        this.nomeCanali[indiceAnalogico] = this.nomeTF.getText();
        this.valoriMinimiCanali[indiceAnalogico] = Float.valueOf(this.minimoTF.getText()).floatValue();
        this.valoriMassimiCanali[indiceAnalogico] = Float.valueOf(this.massimoTF.getText()).floatValue();
        this.tipoSensoreCanali[indiceAnalogico] = this.tipoSensoreCB.getSelectedIndex();
    }

    public void salvaValoriTPMS(int indiceAnteriore, int indicePosteriore) {
        this.idAnteriori[indiceAnteriore] = this.anterioreTF.getText();
        this.idPosteriori[indicePosteriore] = this.posterioreTF.getText();
    }

    public JPanel costruisciPannelloCom() {
        this.sceltaCOM = new JComboBox();
        this.sceltaCOM.setFocusable(false);
        this.connettiB = new JButton(Language.string("Connetti"));
        this.connettiB.addActionListener(this);
        this.sceltaCOM.setMinimumSize(new Dimension(120, 25));
        this.sceltaCOM.setPreferredSize(new Dimension(120, 25));
        this.sceltaCOM.setMaximumSize(new Dimension(120, 25));
        this.connettiB.setMinimumSize(new Dimension(80, 25));
        this.connettiB.setMaximumSize(new Dimension(80, 25));
        this.connettiB.setFocusable(false);
        JLabel comLabel = new JLabel(Language.string("Scegli la porta su cui \u00e8 connessa il DataLog-PRO:"));
        comLabel.setForeground(Color.white);
        JPanel pannelloConnessione = new JPanel();
        pannelloConnessione.add(comLabel);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.sceltaCOM);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.connettiB);
        pannelloConnessione.setBackground(Color.gray);
        return pannelloConnessione;
    }

    public JPanel costruisciPannelloBottoni() {
        this.importaB = new JButton(Language.string("Importa"));
        this.importaB.addActionListener(this);
        this.esportaB = new JButton(Language.string("Esporta"));
        this.esportaB.addActionListener(this);
        this.trasmettiWifiB = new JButton(Language.string("Invia WiFi"));
        this.trasmettiWifiB.addActionListener(this);
        this.riceviWifiB = new JButton(Language.string("Ricevi WiFi"));
        this.riceviWifiB.addActionListener(this);
        this.importaUsbB = new JButton(Language.string("Ricevi Usb"));
        this.importaUsbB.addActionListener(this);
        this.esportaUsbB = new JButton(Language.string("Invia Usb"));
        this.esportaUsbB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.importaB);
        pannelloBottoni.add(this.esportaB);
        pannelloBottoni.add(this.importaUsbB);
        pannelloBottoni.add(this.esportaUsbB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        return pannelloBottoni;
    }

    public JPanel costruisciPanelWiFi() {
        JPanel pannelloPrincipale = new JPanel();
        pannelloPrincipale.setLayout(new GridLayout(2, 1));
        JPanel pannelloSotto = new JPanel();
        pannelloSotto.setLayout(new GridLayout(2, 1));
        Border blackline = BorderFactory.createEtchedBorder(0);
        JPanel pannelloWifi = new JPanel();
        pannelloWifi.setLayout(new GridLayout(1, 2));
        pannelloWifi.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Wifi")));
        JPanel pannelloLabelWifi = new JPanel();
        pannelloLabelWifi.setLayout(new GridLayout(8, 1, 0, 8));
        JPanel pannelloScelteWifi = new JPanel();
        pannelloScelteWifi.setLayout(new GridLayout(8, 1, 0, 8));
        MaskFormatter MascheraRetePassword = null;
        try {
            MascheraRetePassword = new MaskFormatter("********************");
            MascheraRetePassword.setValidCharacters(this.caratteriValidi);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.rete = new JFormattedTextField(MascheraRetePassword);
        this.rete.setHorizontalAlignment(11);
        this.rete.setText("----------");
        this.rete.setMaximumSize(new Dimension(60, 20));
        this.password = new JFormattedTextField(MascheraRetePassword);
        this.password.setHorizontalAlignment(11);
        this.password.setText("----------");
        this.password.setMaximumSize(new Dimension(60, 20));
        this.reteHot = new JFormattedTextField(MascheraRetePassword);
        this.reteHot.setHorizontalAlignment(11);
        this.reteHot.setText("----------");
        this.reteHot.setMaximumSize(new Dimension(60, 20));
        this.passwordHot = new JFormattedTextField(MascheraRetePassword);
        this.passwordHot.setHorizontalAlignment(11);
        this.passwordHot.setText("----------");
        this.passwordHot.setMaximumSize(new Dimension(60, 20));
        JLabel attivaWifiLabel = new JLabel(Language.string("Connessione : "));
        JLabel reteLabel = new JLabel(Language.string("Nome rete : "));
        JLabel passwordLabel = new JLabel(Language.string("Password rete : "));
        JLabel reteHotLabel = new JLabel(Language.string("Nome rete Hotspot: "));
        JLabel passwordHotLabel = new JLabel(Language.string("Password Hotspot : "));
        JLabel attivaHotLabel = new JLabel(Language.string("Hotspot : "));
        JLabel modelloFasciaLabel = new JLabel(Language.string("Modello fascia : "));
        JPanel pannello3 = new JPanel();
        pannello3.setLayout(new GridLayout(1, 4));
        JPanel pannello5 = new JPanel();
        pannello5.setLayout(new GridLayout(1, 4));
        this.wifiON = new JRadioButton("ON");
        this.wifiOFF = new JRadioButton("OFF");
        this.wifiON.addActionListener(this);
        this.wifiOFF.addActionListener(this);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.wifiON);
        group2.add(this.wifiOFF);
        this.wifiON.setSelected(true);
        pannello3.add(this.wifiON);
        pannello3.add(this.wifiOFF);
        pannello3.add(new JLabel(""));
        pannello3.add(new JLabel(""));
        this.hotON = new JRadioButton("ON");
        this.hotOFF = new JRadioButton("OFF");
        ButtonGroup group4 = new ButtonGroup();
        group4.add(this.hotON);
        group4.add(this.hotOFF);
        this.hotOFF.setSelected(true);
        pannello5.add(this.hotON);
        pannello5.add(this.hotOFF);
        pannello5.add(new JLabel(""));
        pannello5.add(new JLabel(""));
        pannelloLabelWifi.add(attivaWifiLabel);
        pannelloLabelWifi.add(reteLabel);
        pannelloLabelWifi.add(passwordLabel);
        pannelloLabelWifi.add(attivaHotLabel);
        pannelloLabelWifi.add(reteHotLabel);
        pannelloLabelWifi.add(passwordHotLabel);
        pannelloLabelWifi.add(new JLabel(""));
        pannelloLabelWifi.add(new JLabel(""));
        pannelloScelteWifi.add(pannello3);
        pannelloScelteWifi.add(this.rete);
        pannelloScelteWifi.add(this.password);
        pannelloScelteWifi.add(pannello5);
        pannelloScelteWifi.add(this.reteHot);
        pannelloScelteWifi.add(this.passwordHot);
        pannelloScelteWifi.add(new JLabel(""));
        pannelloScelteWifi.add(new JLabel(""));
        pannelloWifi.add(pannelloLabelWifi);
        pannelloWifi.add(pannelloScelteWifi);
        pannelloSotto.add(new JLabel(""));
        pannelloSotto.add(new JLabel(""));
        pannelloPrincipale.add(pannelloWifi);
        pannelloPrincipale.add(pannelloSotto);
        return pannelloPrincipale;
    }

    public JPanel costruisciPanelInfo() {
        JPanel pannelloPrincipale = new JPanel();
        pannelloPrincipale.setLayout(new GridLayout(2, 1));
        JPanel pannelloSotto = new JPanel();
        pannelloSotto.setLayout(new GridLayout(2, 1));
        Border blackline = BorderFactory.createEtchedBorder(0);
        JPanel pannelloWifi = new JPanel();
        pannelloWifi.setLayout(new GridLayout(1, 2));
        pannelloWifi.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Info")));
        JPanel pannelloLabelWifi = new JPanel();
        pannelloLabelWifi.setLayout(new GridLayout(8, 1, 0, 8));
        JPanel pannelloScelteWifi = new JPanel();
        pannelloScelteWifi.setLayout(new GridLayout(8, 1, 0, 8));
        this.softwareB = new JButton(Language.string("Update Software"));
        this.softwareB.addActionListener(this);
        this.firmwareB = new JButton(Language.string("Update Firmware"));
        this.firmwareB.addActionListener(this);
        this.resetSessionB = new JButton(Language.string("Reset sessioni"));
        this.resetSessionB.addActionListener(this);
        this.versioneSoftware = new JTextField();
        this.versioneSoftware.setHorizontalAlignment(11);
        this.versioneSoftware.setText("----------");
        this.versioneSoftware.setMaximumSize(new Dimension(40, 20));
        this.versioneSoftware.setEditable(false);
        this.versioneFirmware = new JTextField();
        this.versioneFirmware.setHorizontalAlignment(11);
        this.versioneFirmware.setText("----------");
        this.versioneFirmware.setMaximumSize(new Dimension(40, 20));
        this.versioneFirmware.setEditable(false);
        this.numeroSessioni = new JTextField();
        this.numeroSessioni.setHorizontalAlignment(11);
        this.numeroSessioni.setText("----------");
        this.numeroSessioni.setMaximumSize(new Dimension(40, 20));
        this.numeroSessioni.setEditable(false);
        this.ultimaSessione = new JTextField();
        this.ultimaSessione.setHorizontalAlignment(11);
        this.ultimaSessione.setText("----------");
        this.ultimaSessione.setMaximumSize(new Dimension(40, 20));
        this.ultimaSessione.setEditable(false);
        JLabel softwareLabel = new JLabel(Language.string("  Versione software : "));
        JLabel firmwareLabel = new JLabel(Language.string("  Versione firmware : "));
        JLabel sessioniLabel = new JLabel(Language.string("  Numero Sessione : "));
        JLabel ultimaLabel = new JLabel(Language.string("  Ultima sessione scaricata : "));
        JLabel updateSoftwareLabel = new JLabel(Language.string("  Aggiorna software : "));
        JLabel updateFirmwareLabel = new JLabel(Language.string("  Aggiorna firmware : "));
        JLabel resetLabel = new JLabel(Language.string("  Reset numero Sessioni : "));
        pannelloLabelWifi.add(softwareLabel);
        pannelloLabelWifi.add(firmwareLabel);
        pannelloLabelWifi.add(sessioniLabel);
        pannelloLabelWifi.add(ultimaLabel);
        pannelloLabelWifi.add(new JLabel(""));
        pannelloLabelWifi.add(resetLabel);
        pannelloLabelWifi.add(updateSoftwareLabel);
        pannelloLabelWifi.add(updateFirmwareLabel);
        pannelloScelteWifi.add(this.versioneSoftware);
        pannelloScelteWifi.add(this.versioneFirmware);
        pannelloScelteWifi.add(this.numeroSessioni);
        pannelloScelteWifi.add(this.ultimaSessione);
        pannelloScelteWifi.add(new JLabel(""));
        pannelloScelteWifi.add(this.resetSessionB);
        pannelloScelteWifi.add(this.softwareB);
        pannelloScelteWifi.add(this.firmwareB);
        pannelloWifi.add(pannelloLabelWifi);
        pannelloWifi.add(pannelloScelteWifi);
        pannelloSotto.add(new JLabel(""));
        pannelloSotto.add(new JLabel(""));
        pannelloPrincipale.add(pannelloWifi);
        pannelloPrincipale.add(pannelloSotto);
        return pannelloPrincipale;
    }

    public JPanel costruisciPanelSensoriCan() {
        JPanel pannelloPrincipale = new JPanel();
        pannelloPrincipale.setLayout(new GridLayout(2, 1));
        JPanel pannelloSopra = new JPanel();
        pannelloSopra.setLayout(new GridLayout(2, 1));
        Border blackline = BorderFactory.createEtchedBorder(0);
        JPanel pannelloTpms = new JPanel();
        pannelloTpms.setLayout(new GridLayout(1, 2));
        pannelloTpms.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Configurazione sensori TPMS")));
        JPanel pannelloCanPro = new JPanel(new BorderLayout());
        pannelloCanPro.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Configurazione canali CAN-BUS")));
        JPanel pannelloLabelTpms = new JPanel();
        pannelloLabelTpms.setLayout(new GridLayout(7, 1, 0, 8));
        JPanel pannelloScelteTpms = new JPanel();
        pannelloScelteTpms.setLayout(new GridLayout(7, 1, 0, 8));
        JPanel pannelloLabelCanPro = new JPanel();
        pannelloLabelCanPro.setLayout(new GridLayout(10, 1, 0, 3));
        JPanel pannelloScelteCanPro = new JPanel();
        pannelloScelteCanPro.setLayout(new GridLayout(10, 1, 0, 3));
        JLabel primaTpmsLabel = new JLabel(Language.string("ID sensore anteriore : "));
        JLabel secondaTpmsLabel = new JLabel(Language.string("ID sensore posteriore : "));
        JLabel anterioreLabel = new JLabel(Language.string("Sensore anteriore in uso :"));
        JLabel posterioreLabel = new JLabel(Language.string("Sensore posteriore in uso :"));
        JLabel neutro0Label = new JLabel(Language.string("Tensione neutro :"));
        JLabel neutro1Label = new JLabel(Language.string("Tensione marcia 1 :"));
        JLabel neutro2Label = new JLabel(Language.string("Tensione marcia 2 :"));
        JLabel neutro3Label = new JLabel(Language.string("Tensione marcia 3 :"));
        JLabel neutro4Label = new JLabel(Language.string("Tensione marcia 4 :"));
        JLabel neutro5Label = new JLabel(Language.string("Tensione marcia 5 :"));
        JLabel neutro6Label = new JLabel(Language.string("Tensione marcia 6 :"));
        JLabel baudLabel = new JLabel(Language.string("Baud rate Can Bus 1 :"));
        JLabel baud2Label = new JLabel(Language.string("Baud rate Can Bus 2 :"));
        String[] baudList = new String[]{"125k", "250k", "500k", "1M"};
        this.baudCanCB = new JComboBox<String>(baudList);
        this.baudCanCB.setSelectedIndex(0);
        this.baudCanCB.setMaximumSize(new Dimension(120, 20));
        this.baudCanCB.addActionListener(this);
        this.baudCan2CB = new JComboBox<String>(baudList);
        this.baudCan2CB.setSelectedIndex(0);
        this.baudCan2CB.setMaximumSize(new Dimension(120, 20));
        this.baudCan2CB.addActionListener(this);
        NumberFormat analogFormatt = NumberFormat.getNumberInstance(Locale.US);
        analogFormatt.setGroupingUsed(false);
        this.neutro0TF = new JFormattedTextField(analogFormatt);
        this.neutro0TF.setHorizontalAlignment(11);
        this.neutro0TF.setMaximumSize(new Dimension(70, 20));
        this.neutro0TF.setValue(0.5);
        this.neutro1TF = new JFormattedTextField(analogFormatt);
        this.neutro1TF.setHorizontalAlignment(11);
        this.neutro1TF.setMaximumSize(new Dimension(70, 20));
        this.neutro1TF.setValue(1.5);
        this.neutro2TF = new JFormattedTextField(analogFormatt);
        this.neutro2TF.setHorizontalAlignment(11);
        this.neutro2TF.setMaximumSize(new Dimension(70, 20));
        this.neutro2TF.setValue(2.0);
        this.neutro3TF = new JFormattedTextField(analogFormatt);
        this.neutro3TF.setHorizontalAlignment(11);
        this.neutro3TF.setMaximumSize(new Dimension(70, 20));
        this.neutro3TF.setValue(2.5);
        this.neutro4TF = new JFormattedTextField(analogFormatt);
        this.neutro4TF.setHorizontalAlignment(11);
        this.neutro4TF.setMaximumSize(new Dimension(70, 20));
        this.neutro4TF.setValue(3.0);
        this.neutro5TF = new JFormattedTextField(analogFormatt);
        this.neutro5TF.setHorizontalAlignment(11);
        this.neutro5TF.setMaximumSize(new Dimension(70, 20));
        this.neutro5TF.setValue(3.5);
        this.neutro6TF = new JFormattedTextField(analogFormatt);
        this.neutro6TF.setHorizontalAlignment(11);
        this.neutro6TF.setMaximumSize(new Dimension(70, 20));
        this.neutro6TF.setValue(4.0);
        this.configuraCanB = new JButton(Language.string("Configura canali Can Bus"));
        this.configuraCanB.addActionListener(this);
        JPanel pannelloMarce = new JPanel();
        pannelloMarce.setLayout(new GridLayout(1, 2));
        pannelloLabelCanPro.add(baudLabel);
        pannelloLabelCanPro.add(baud2Label);
        pannelloLabelCanPro.add(new JLabel(""));
        pannelloLabelCanPro.add(neutro0Label);
        pannelloLabelCanPro.add(neutro1Label);
        pannelloLabelCanPro.add(neutro2Label);
        pannelloLabelCanPro.add(neutro3Label);
        pannelloLabelCanPro.add(neutro4Label);
        pannelloLabelCanPro.add(neutro5Label);
        pannelloLabelCanPro.add(neutro6Label);
        pannelloScelteCanPro.add(this.baudCanCB);
        pannelloScelteCanPro.add(this.baudCan2CB);
        pannelloScelteCanPro.add(new JLabel(""));
        pannelloScelteCanPro.add(this.neutro0TF);
        pannelloScelteCanPro.add(this.neutro1TF);
        pannelloScelteCanPro.add(this.neutro2TF);
        pannelloScelteCanPro.add(this.neutro3TF);
        pannelloScelteCanPro.add(this.neutro4TF);
        pannelloScelteCanPro.add(this.neutro5TF);
        pannelloScelteCanPro.add(this.neutro6TF);
        pannelloMarce.add(pannelloLabelCanPro);
        pannelloMarce.add(pannelloScelteCanPro);
        pannelloCanPro.add((Component)pannelloMarce, "Center");
        pannelloCanPro.add((Component)this.configuraCanB, "South");
        MaskFormatter MascheraID = null;
        try {
            MascheraID = new MaskFormatter("*******");
            MascheraID.setValidCharacters(this.caratteriNumerici);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.anterioreTF = new JFormattedTextField(MascheraID);
        this.anterioreTF.setHorizontalAlignment(11);
        this.anterioreTF.setMaximumSize(new Dimension(70, 20));
        this.anterioreTF.setValue("0000000");
        this.posterioreTF = new JFormattedTextField(MascheraID);
        this.posterioreTF.setHorizontalAlignment(11);
        this.posterioreTF.setMaximumSize(new Dimension(70, 20));
        this.posterioreTF.setValue("0000000");
        String[] canaliCanList = new String[]{"Analog1", "Analog2", "Analog3", "Analog4", "Analog5", "Analog6", "Analog7", "Analog8", "EXT-1", "EXT-2", "EXT-3", "EXT-4"};
        String[] tipiCanList = new String[]{"Default", "Can"};
        String[] byteList = new String[]{"0", "1", "2", "3", "4", "5", "6", "7"};
        String[] divisioneList = new String[]{"1", "2", "4", "8", "16", "32", "64"};
        String caratteriBinari = "01";
        String[] tpmsList = new String[]{"A", "B", "C", "D"};
        this.tpmsAntCB = new JComboBox<String>(tpmsList);
        this.tpmsAntCB.setSelectedIndex(0);
        this.tpmsAntCB.setMaximumSize(new Dimension(120, 20));
        this.tpmsAntCB.addActionListener(this);
        this.tpmsPostCB = new JComboBox<String>(tpmsList);
        this.tpmsPostCB.setSelectedIndex(0);
        this.tpmsPostCB.setMaximumSize(new Dimension(120, 20));
        this.tpmsPostCB.addActionListener(this);
        pannelloLabelTpms.add(anterioreLabel);
        pannelloLabelTpms.add(primaTpmsLabel);
        pannelloLabelTpms.add(posterioreLabel);
        pannelloLabelTpms.add(secondaTpmsLabel);
        pannelloLabelTpms.add(new JLabel(""));
        pannelloLabelTpms.add(new JLabel(""));
        pannelloLabelTpms.add(new JLabel(""));
        pannelloScelteTpms.add(this.tpmsAntCB);
        pannelloScelteTpms.add(this.anterioreTF);
        pannelloScelteTpms.add(this.tpmsPostCB);
        pannelloScelteTpms.add(this.posterioreTF);
        pannelloScelteTpms.add(new JLabel(""));
        pannelloScelteTpms.add(new JLabel(""));
        pannelloScelteTpms.add(new JLabel(""));
        pannelloTpms.add(pannelloLabelTpms);
        pannelloTpms.add(pannelloScelteTpms);
        pannelloPrincipale.add(pannelloTpms);
        pannelloPrincipale.add(pannelloCanPro);
        return pannelloPrincipale;
    }

    public JPanel costruisciPanelDownload() {
        this.elencoFileDati = new Vector();
        this.elencoFileLM = new DefaultListModel();
        this.elencoFileLM.clear();
        this.listaB = new JButton(Language.string("Aggiorna"));
        this.listaB.addActionListener(this);
        this.scaricaB = new JButton(Language.string("Download su chiavetta"));
        this.scaricaB.addActionListener(this);
        this.cancellaB = new JButton(Language.string("Cancella"));
        this.cancellaB.addActionListener(this);
        this.cancellaTuttiB = new JButton(Language.string("Cancella tutti"));
        this.cancellaTuttiB.addActionListener(this);
        JPanel pannelloTesto = new JPanel();
        JLabel headerLabel = new JLabel(Language.string("            Circuito               Data                Dimensione             Ora            ID"));
        pannelloTesto.add(headerLabel);
        JPanel pannelloBottoni2 = new JPanel();
        pannelloBottoni2.add(this.listaB);
        pannelloBottoni2.add(this.scaricaB);
        pannelloBottoni2.add(this.cancellaB);
        pannelloBottoni2.add(this.cancellaTuttiB);
        pannelloBottoni2.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloBarra = new JPanel(new BorderLayout());
        JPanel pannelloCentrale = new JPanel(new BorderLayout());
        this.listFile = new JList(this.elencoFileLM);
        this.listFile.setSelectionMode(2);
        this.listFile.setLayoutOrientation(0);
        this.listFile.setFont(new Font("Courier", 0, 13));
        this.listFile.addListSelectionListener(this);
        JScrollPane listScroller2 = new JScrollPane(this.listFile);
        listScroller2.setPreferredSize(new Dimension(150, 100));
        listScroller2.setVerticalScrollBarPolicy(22);
        this.progress = new JProgressBar();
        this.progress.setValue(0);
        this.progress.setStringPainted(true);
        this.progress.setSize(new Dimension(50, 500));
        pannelloBarra.add((Component)this.progress, "Center");
        pannelloBarra.add((Component)new JLabel(Language.string("Memoria occupata:")), "North");
        pannelloBarra.add(Box.createRigidArea(new Dimension(3, 3)), "South");
        pannelloCentrale.add((Component)listScroller2, "Center");
        pannelloCentrale.add((Component)pannelloBarra, "South");
        pannelloPrincipale.add((Component)headerLabel, "North");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)pannelloBottoni2, "South");
        return pannelloPrincipale;
    }

    public JPanel costruisciPanelOnline() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloCanali = new JPanel();
        pannelloCanali.setLayout(new GridLayout(84, 4, 5, 5));
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.setLayout(new GridLayout(1, 1));
        JScrollPane scrollPane = new JScrollPane(pannelloCanali);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.acquisisciB = new JButton(Language.string("Avvia lettura Online (USB)"));
        this.acquisisciB.addActionListener(this);
        this.canaliRealTime = new JTextField[154];
        this.labelRealTime = new JLabel[154];
        for (int i = 0; i < 154; ++i) {
            this.canaliRealTime[i] = new JTextField();
            this.canaliRealTime[i].setEditable(false);
            this.canaliRealTime[i].setMaximumSize(new Dimension(50, 20));
            this.labelRealTime[i] = new JLabel("    Canale" + i);
        }
        this.canaleRssiAnteriore = new JTextField();
        this.canaleRssiAnteriore.setEditable(false);
        this.canaleRssiAnteriore.setMaximumSize(new Dimension(50, 20));
        this.canaleRssiPosteriore = new JTextField();
        this.canaleRssiPosteriore.setEditable(false);
        this.canaleRssiPosteriore.setMaximumSize(new Dimension(50, 20));
        String spazio = "    ";
        this.labelRealTime[0].setText(spazio + Language.string("Pressione ant."));
        this.labelRealTime[1].setText(spazio + Language.string("Pressione post."));
        this.labelRealTime[2].setText(spazio + Language.string("Temperatura ant."));
        this.labelRealTime[3].setText(spazio + Language.string("Temperatura post."));
        this.labelRealTime[4].setText(spazio + Language.string("Velocit\u00e0 ant."));
        this.labelRealTime[5].setText(spazio + Language.string("Velocit\u00e0 post."));
        this.labelRealTime[6].setText(spazio + Language.string("RPM"));
        Font bold = new Font("Arial Black", 1, 14);
        String spazio2 = "  ";
        JLabel labelTPMS = new JLabel(spazio2 + Language.string("Canali TPMS"));
        labelTPMS.setFont(bold);
        pannelloCanali.add(labelTPMS);
        pannelloCanali.add(new JLabel(""));
        pannelloCanali.add(new JLabel(""));
        pannelloCanali.add(new JLabel(""));
        for (int i = 0; i < 77; ++i) {
            switch (i) {
                case 2: {
                    JLabel label = new JLabel(spazio2 + Language.string("Canali Digitali"));
                    label.setFont(bold);
                    pannelloCanali.add(label);
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                    break;
                }
                case 4: {
                    JLabel label = new JLabel(spazio2 + Language.string("Canali Analogici"));
                    label.setFont(bold);
                    pannelloCanali.add(label);
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                    break;
                }
                case 8: {
                    JLabel label = new JLabel(spazio2 + Language.string("Canali Multi"));
                    label.setFont(bold);
                    pannelloCanali.add(label);
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                    break;
                }
                case 13: {
                    JLabel label = new JLabel(spazio2 + Language.string("Canali Can-Bus"));
                    label.setFont(bold);
                    pannelloCanali.add(label);
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                    pannelloCanali.add(new JLabel(""));
                }
            }
            pannelloCanali.add(this.labelRealTime[2 * i]);
            pannelloCanali.add(this.canaliRealTime[2 * i]);
            if (i != 3) {
                pannelloCanali.add(this.labelRealTime[2 * i + 1]);
                pannelloCanali.add(this.canaliRealTime[2 * i + 1]);
            } else {
                pannelloCanali.add(new JLabel(""));
                pannelloCanali.add(new JLabel(""));
            }
            if (i != 1) continue;
            pannelloCanali.add(new JLabel(spazio + Language.string("RSSI ant.")));
            pannelloCanali.add(this.canaleRssiAnteriore);
            pannelloCanali.add(new JLabel(spazio + Language.string("RSSI post.")));
            pannelloCanali.add(this.canaleRssiPosteriore);
        }
        pannelloCanali.add(new JLabel(""));
        pannelloCanali.add(new JLabel(""));
        pannelloCanali.add(new JLabel(""));
        pannelloCanali.add(new JLabel(""));
        pannelloBottoni.add(this.acquisisciB);
        pannelloPrincipale.add((Component)scrollPane, "Center");
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        return pannelloPrincipale;
    }

    public void aggiornaNomiOnline() {
        int i;
        String spazio = "    ";
        for (i = 0; i < 8; ++i) {
            this.labelRealTime[i + 8].setText(spazio + this.getStringaPulita(this.nomeCanali[i]));
        }
        for (i = 0; i < 10; ++i) {
            this.labelRealTime[i + 16].setText(spazio + DanasDataStructure.getInstance().getNomeMulti(this.getTipoMoto(this.motoCB.getSelectedIndex()), i));
        }
        for (i = 0; i < 128; ++i) {
            CanTableRow riga = this.elencoRigheCan.get(i + 7);
            this.labelRealTime[i + 26].setText(spazio + this.getStringaPulita(riga.getNome()));
            if (riga.getUsa()) {
                this.labelRealTime[i + 26].setEnabled(true);
                continue;
            }
            this.labelRealTime[i + 26].setEnabled(false);
        }
    }

    public JPanel costruisciPanelIngressi() {
        int i;
        JPanel pannelloPrincipale = new JPanel();
        pannelloPrincipale.setLayout(new GridLayout(2, 1));
        JPanel pannelloSecondario = new JPanel();
        pannelloSecondario.setLayout(new GridLayout(2, 1));
        JPanel pannelloInferiore = new JPanel();
        pannelloInferiore.setLayout(new GridLayout(2, 1));
        Border blackline = BorderFactory.createEtchedBorder(0);
        JPanel pannelloCanali = new JPanel();
        pannelloCanali.setLayout(new GridLayout(1, 2));
        pannelloCanali.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Configurazione ingressi")));
        JPanel pannelloMarce = new JPanel();
        pannelloMarce.setLayout(new GridLayout(1, 2));
        pannelloMarce.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Configurazione marce - NON CAN-BUS")));
        JPanel pannelloSensori = new JPanel();
        pannelloSensori.setLayout(new GridLayout(1, 1));
        pannelloSensori.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Configurazione Sensori parametrici")));
        JPanel pannelloAuto = new JPanel();
        pannelloAuto.setLayout(new GridLayout(1, 1));
        pannelloAuto.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Configurazione Sensori in automatico")));
        JPanel pannelloLabelCanali = new JPanel();
        pannelloLabelCanali.setLayout(new GridLayout(11, 1, 0, 3));
        JPanel pannelloScelteCanali = new JPanel();
        pannelloScelteCanali.setLayout(new GridLayout(11, 1, 0, 3));
        JPanel pannelloLabelMarce = new JPanel();
        pannelloLabelMarce.setLayout(new GridLayout(6, 1, 0, 3));
        JPanel pannelloScelteMarce = new JPanel();
        pannelloScelteMarce.setLayout(new GridLayout(6, 1, 0, 3));
        JLabel primaLabel = new JLabel(Language.string("Rapporto RPM/pignone 1a : "));
        JLabel secondaLabel = new JLabel(Language.string("Rapporto RPM/pignone 2a : "));
        JLabel terzaLabel = new JLabel(Language.string("Rapporto RPM/pignone 3a : "));
        JLabel quartaLabel = new JLabel(Language.string("Rapporto RPM/pignone 4a : "));
        JLabel quintaLabel = new JLabel(Language.string("Rapporto RPM/pignone 5a : "));
        JLabel sestaLabel = new JLabel(Language.string("Rapporto RPM/pignone 6a : "));
        JLabel digitaleLabel = new JLabel(Language.string("INGRESSO DIGITALE : "));
        JLabel impulsiLabel = new JLabel(Language.string("    Numero impulsi : "));
        JLabel pignoneLabel = new JLabel(Language.string("    Denti pignone : "));
        JLabel coronaLabel = new JLabel(Language.string("    Denti corona : "));
        JLabel circonferenzaLabel = new JLabel(Language.string("    Circonferenza (mm) : "));
        JLabel analogicoLabel = new JLabel(Language.string("INGRESSO ANALOGICO : "));
        JLabel nomeLabel = new JLabel(Language.string("    Nome : "));
        JLabel minimoLabel = new JLabel(Language.string("    Valore minimo : "));
        JLabel massimoLabel = new JLabel(Language.string("    Valore Massimo : "));
        JLabel tipoSensoreLabel = new JLabel(Language.string("    Tipo Sensore : "));
        NumberFormat analogFormatt = NumberFormat.getNumberInstance(Locale.US);
        analogFormatt.setGroupingUsed(false);
        this.primaTF = new JFormattedTextField(analogFormatt);
        this.primaTF.setHorizontalAlignment(11);
        this.primaTF.setMaximumSize(new Dimension(70, 20));
        this.secondaTF = new JFormattedTextField(analogFormatt);
        this.secondaTF.setHorizontalAlignment(11);
        this.secondaTF.setMaximumSize(new Dimension(70, 20));
        this.terzaTF = new JFormattedTextField(analogFormatt);
        this.terzaTF.setHorizontalAlignment(11);
        this.terzaTF.setMaximumSize(new Dimension(70, 20));
        this.quartaTF = new JFormattedTextField(analogFormatt);
        this.quartaTF.setHorizontalAlignment(11);
        this.quartaTF.setMaximumSize(new Dimension(70, 20));
        this.quintaTF = new JFormattedTextField(analogFormatt);
        this.quintaTF.setHorizontalAlignment(11);
        this.quintaTF.setMaximumSize(new Dimension(70, 20));
        this.sestaTF = new JFormattedTextField(analogFormatt);
        this.sestaTF.setHorizontalAlignment(11);
        this.sestaTF.setMaximumSize(new Dimension(70, 20));
        String[] canaliList = new String[]{"Analog1", "Analog2", "Analog3", "Analog4", "Analog5", "Analog6", "Analog7", "Analog8"};
        String[] digitaleList = new String[]{"Rpm", "Vel1", "Vel2"};
        this.configuraSensoriB = new JButton(Language.string("Configura sensori parametrici"));
        this.configuraSensoriB.addActionListener(this);
        this.sensoriButton = new JButton(Language.string("Configura ingressi analogici in automatico"));
        this.sensoriButton.addActionListener(this);
        NumberFormat KmFormat = NumberFormat.getNumberInstance(Locale.US);
        KmFormat.setMaximumIntegerDigits(4);
        KmFormat.setMaximumFractionDigits(0);
        KmFormat.setGroupingUsed(false);
        this.circonferenzaTF = new JFormattedTextField(KmFormat);
        this.circonferenzaTF.setHorizontalAlignment(11);
        this.circonferenzaTF.setMaximumSize(new Dimension(70, 20));
        this.circonferenzaTF.setValue(1500);
        MaskFormatter mascheraNome = null;
        try {
            mascheraNome = new MaskFormatter("**********");
            mascheraNome.setValidCharacters(this.caratteriValidi);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.nomeTF = new JFormattedTextField(mascheraNome);
        this.nomeTF.setHorizontalAlignment(11);
        this.nomeTF.setMaximumSize(new Dimension(70, 20));
        this.minimoTF = new JFormattedTextField(analogFormatt);
        this.minimoTF.setHorizontalAlignment(11);
        this.minimoTF.setMaximumSize(new Dimension(70, 20));
        this.massimoTF = new JFormattedTextField(analogFormatt);
        this.massimoTF.setHorizontalAlignment(11);
        this.massimoTF.setMaximumSize(new Dimension(70, 20));
        this.canaleDigitaleCB = new JComboBox<String>(digitaleList);
        this.canaleDigitaleCB.setSelectedIndex(0);
        this.indiceDigitalePrecedente = 0;
        this.canaleDigitaleCB.setMaximumSize(new Dimension(120, 20));
        this.canaleDigitaleCB.addActionListener(this);
        this.pignoneCB = new JComboBox();
        for (i = 1; i <= 100; ++i) {
            this.pignoneCB.addItem(i);
        }
        this.pignoneCB.setSelectedIndex(0);
        this.pignoneCB.setMaximumSize(new Dimension(120, 20));
        this.pignoneCB.addActionListener(this);
        this.coronaCB = new JComboBox();
        for (i = 1; i <= 100; ++i) {
            this.coronaCB.addItem(i);
        }
        this.coronaCB.setSelectedIndex(0);
        this.coronaCB.setMaximumSize(new Dimension(120, 20));
        this.coronaCB.addActionListener(this);
        this.canaleAnalogicoCB = new JComboBox<String>(canaliList);
        this.canaleAnalogicoCB.setSelectedIndex(0);
        this.indiceAnalogicoPrecedente = 0;
        this.indiceAnteriorePrecedente = 0;
        this.indicePosteriorePrecedente = 0;
        this.canaleAnalogicoCB.setMaximumSize(new Dimension(120, 20));
        this.canaleAnalogicoCB.addActionListener(this);
        this.impulsiCB = new JComboBox();
        for (i = 1; i <= 100; ++i) {
            this.impulsiCB.addItem(i);
        }
        this.impulsiCB.setSelectedIndex(0);
        this.impulsiCB.setMaximumSize(new Dimension(120, 20));
        this.impulsiCB.addActionListener(this);
        this.defaultInputB = new JButton(Language.string("Importa da Sessione di Default"));
        this.defaultInputB.addActionListener(this);
        String[] tipoSensoreList = new String[]{Language.string("Sensore lineare"), Language.string("Parametrico A"), Language.string("Parametrico B"), Language.string("Parametrico C")};
        this.tipoSensoreCB = new JComboBox<String>(tipoSensoreList);
        this.tipoSensoreCB.setSelectedIndex(0);
        this.tipoSensoreCB.setMaximumSize(new Dimension(120, 20));
        this.tipoSensoreCB.addActionListener(this);
        pannelloLabelCanali.add(digitaleLabel);
        pannelloLabelCanali.add(impulsiLabel);
        pannelloLabelCanali.add(pignoneLabel);
        pannelloLabelCanali.add(coronaLabel);
        pannelloLabelCanali.add(circonferenzaLabel);
        pannelloLabelCanali.add(analogicoLabel);
        pannelloLabelCanali.add(nomeLabel);
        pannelloLabelCanali.add(minimoLabel);
        pannelloLabelCanali.add(massimoLabel);
        pannelloLabelCanali.add(tipoSensoreLabel);
        pannelloLabelCanali.add(new JLabel(""));
        pannelloScelteCanali.add(this.canaleDigitaleCB);
        pannelloScelteCanali.add(this.impulsiCB);
        pannelloScelteCanali.add(this.pignoneCB);
        pannelloScelteCanali.add(this.coronaCB);
        pannelloScelteCanali.add(this.circonferenzaTF);
        pannelloScelteCanali.add(this.canaleAnalogicoCB);
        pannelloScelteCanali.add(this.nomeTF);
        pannelloScelteCanali.add(this.minimoTF);
        pannelloScelteCanali.add(this.massimoTF);
        pannelloScelteCanali.add(this.tipoSensoreCB);
        pannelloScelteCanali.add(this.defaultInputB);
        pannelloLabelMarce.add(primaLabel);
        pannelloLabelMarce.add(secondaLabel);
        pannelloLabelMarce.add(terzaLabel);
        pannelloLabelMarce.add(quartaLabel);
        pannelloLabelMarce.add(quintaLabel);
        pannelloLabelMarce.add(sestaLabel);
        pannelloScelteMarce.add(this.primaTF);
        pannelloScelteMarce.add(this.secondaTF);
        pannelloScelteMarce.add(this.terzaTF);
        pannelloScelteMarce.add(this.quartaTF);
        pannelloScelteMarce.add(this.quintaTF);
        pannelloScelteMarce.add(this.sestaTF);
        pannelloSensori.add(this.configuraSensoriB);
        pannelloAuto.add(this.sensoriButton);
        pannelloCanali.add(pannelloLabelCanali);
        pannelloCanali.add(pannelloScelteCanali);
        pannelloMarce.add(pannelloLabelMarce);
        pannelloMarce.add(pannelloScelteMarce);
        pannelloInferiore.add(pannelloAuto);
        pannelloInferiore.add(pannelloSensori);
        pannelloSecondario.add(pannelloMarce);
        pannelloSecondario.add(pannelloInferiore);
        pannelloPrincipale.add(pannelloCanali);
        pannelloPrincipale.add(pannelloSecondario);
        return pannelloPrincipale;
    }

    public JPanel costruisciPanelAcquisizione() {
        JPanel pannelloPrincipale = new JPanel();
        pannelloPrincipale.setLayout(new GridLayout(2, 1));
        Border blackline = BorderFactory.createEtchedBorder(0);
        JPanel pannelloBase = new JPanel();
        pannelloBase.setLayout(new GridLayout(1, 2));
        pannelloBase.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Generale")));
        JPanel pannelloLabelBase = new JPanel();
        pannelloLabelBase.setLayout(new GridLayout(9, 1, 0, 8));
        JPanel pannelloScelteBase = new JPanel();
        pannelloScelteBase.setLayout(new GridLayout(9, 1, 0, 8));
        pannelloPrincipale.add(pannelloBase);
        pannelloPrincipale.add(new JLabel(""));
        String[] salvataggioList = new String[]{Language.string("Interno"), Language.string("Interno e su chiavetta USB"), Language.string("Su chiavetta USB"), Language.string("Interno e su chiavetta alla chiusura")};
        String[] freqList = new String[]{"10", "100"};
        String[] velMinList = new String[]{"10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "65", "70", "75", "80", "85", "90", "95"};
        String[] canaliStartList = new String[]{"---", "GPS", Language.string("Vel1"), Language.string("GPS/Vel1"), "RPM"};
        String[] standList = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        this.salvataggioCB = new JComboBox<String>(salvataggioList);
        this.salvataggioCB.setSelectedIndex(0);
        this.salvataggioCB.setMaximumSize(new Dimension(120, 20));
        this.salvataggioCB.addActionListener(this);
        this.velMinCB = new JComboBox<String>(velMinList);
        this.velMinCB.setSelectedIndex(0);
        this.velMinCB.setMaximumSize(new Dimension(120, 20));
        this.velMinCB.addActionListener(this);
        this.canaleStartCB = new JComboBox<String>(canaliStartList);
        this.canaleStartCB.setSelectedIndex(0);
        this.canaleStartCB.setMaximumSize(new Dimension(120, 20));
        this.canaleStartCB.addActionListener(this);
        this.frequenzaCB = new JComboBox<String>(freqList);
        this.frequenzaCB.setSelectedIndex(0);
        this.frequenzaCB.setMaximumSize(new Dimension(120, 20));
        this.frequenzaCB.addActionListener(this);
        this.standCB = new JComboBox<String>(standList);
        this.standCB.setSelectedIndex(0);
        this.standCB.setMaximumSize(new Dimension(120, 20));
        this.standCB.addActionListener(this);
        MaskFormatter mascheraPrefisso = null;
        try {
            mascheraPrefisso = new MaskFormatter("**********");
            mascheraPrefisso.setValidCharacters(this.caratteriValidi);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.prefisso = new JFormattedTextField(mascheraPrefisso);
        this.prefisso.setHorizontalAlignment(11);
        this.prefisso.setText("I2M");
        this.prefisso.setMaximumSize(new Dimension(60, 20));
        JLabel frequenzaLabel = new JLabel(Language.string("Frequenza campionamento ingressi : "));
        JLabel velMinimaLabel = new JLabel(Language.string("Vel minima : "));
        JLabel canaleStartLabel = new JLabel(Language.string("Canale autostart : "));
        JLabel prefissoLabel = new JLabel(Language.string("Prefisso file : "));
        JLabel standLabel = new JLabel(Language.string("Durata standby dopo lo spegnimento : "));
        JLabel fusoLabel = new JLabel(Language.string("Fuso orario(rispetto a GMT) : "));
        JLabel motoLabel = new JLabel(Language.string("Tipo di moto : "));
        JLabel ripristinaLabel = new JLabel(Language.string("Ripristinare condizioni di fabbrica : "));
        JLabel salvataggioLabel = new JLabel(Language.string("Salvataggio dati : "));
        this.motoCB = new JComboBox<String>(this.motoList);
        this.motoCB.setSelectedIndex(0);
        this.motoCB.setMaximumSize(new Dimension(120, 20));
        this.motoCB.addActionListener(this);
        String[] fusoList = new String[]{"-12", "-11", "-10", "-9", "-8", "-7", "-6", "-5", "-4", "-3", "-2", "-1", "0", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+10", "+11", "+12"};
        this.fusoCB = new JComboBox<String>(fusoList);
        this.fusoCB.setSelectedIndex(0);
        this.fusoCB.setMaximumSize(new Dimension(120, 20));
        this.fusoCB.addActionListener(this);
        this.ripristinaB = new JButton(Language.string("RIpristina condizioni di fabbrica"));
        this.ripristinaB.addActionListener(this);
        JPanel pannello5 = new JPanel();
        pannello5.setLayout(new GridLayout(1, 4));
        ButtonGroup group5 = new ButtonGroup();
        pannello5.add(new JLabel(""));
        pannello5.add(new JLabel(""));
        pannello5.add(new JLabel(""));
        pannello5.add(new JLabel(""));
        pannelloLabelBase.add(frequenzaLabel);
        pannelloLabelBase.add(velMinimaLabel);
        pannelloLabelBase.add(canaleStartLabel);
        pannelloLabelBase.add(prefissoLabel);
        pannelloLabelBase.add(fusoLabel);
        pannelloLabelBase.add(standLabel);
        pannelloLabelBase.add(motoLabel);
        pannelloLabelBase.add(salvataggioLabel);
        pannelloLabelBase.add(ripristinaLabel);
        pannelloScelteBase.add(this.frequenzaCB);
        pannelloScelteBase.add(this.velMinCB);
        pannelloScelteBase.add(this.canaleStartCB);
        pannelloScelteBase.add(this.prefisso);
        pannelloScelteBase.add(this.fusoCB);
        pannelloScelteBase.add(this.standCB);
        pannelloScelteBase.add(this.motoCB);
        pannelloScelteBase.add(this.salvataggioCB);
        pannelloScelteBase.add(this.ripristinaB);
        pannelloBase.add(pannelloLabelBase);
        pannelloBase.add(pannelloScelteBase);
        return pannelloPrincipale;
    }

    public void aggiornaSensori(double[] a, double[] b, double[] c, int na, int nb, int nc) {
        for (int i = 0; i < 10; ++i) {
            this.sensoreA[i] = a[i];
            this.sensoreB[i] = b[i];
            this.sensoreC[i] = c[i];
        }
        this.numeroA = na;
        this.numeroB = nb;
        this.numeroC = nc;
    }

    private int getTipoMotoConfigurazione(int index) {
        switch (index) {
            case 0: {
                return 8;
            }
            case 1: {
                return 60;
            }
            case 2: {
                return 96;
            }
            case 3: {
                return 116;
            }
            case 4: {
                return 70;
            }
            case 5: {
                return 13;
            }
            case 6: {
                return 33;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 59;
            }
            case 9: {
                return 78;
            }
            case 10: {
                return 35;
            }
            case 11: {
                return 77;
            }
            case 12: {
                return 44;
            }
            case 13: {
                return 45;
            }
            case 14: {
                return 53;
            }
            case 15: {
                return 73;
            }
            case 16: {
                return 81;
            }
            case 17: {
                return 63;
            }
            case 18: {
                return 72;
            }
            case 19: {
                return 9;
            }
            case 20: {
                return 54;
            }
            case 21: {
                return 62;
            }
            case 22: {
                return 67;
            }
            case 23: {
                return 31;
            }
            case 24: {
                return 69;
            }
            case 25: {
                return 115;
            }
            case 26: {
                return 32;
            }
            case 27: {
                return 14;
            }
            case 28: {
                return 22;
            }
            case 29: {
                return 47;
            }
            case 30: {
                return 21;
            }
            case 31: {
                return 68;
            }
            case 32: {
                return 94;
            }
            case 33: {
                return 95;
            }
            case 34: {
                return 10;
            }
            case 35: {
                return 23;
            }
            case 36: {
                return 24;
            }
            case 37: {
                return 25;
            }
            case 38: {
                return 26;
            }
            case 39: {
                return 57;
            }
            case 40: {
                return 27;
            }
            case 41: {
                return 28;
            }
            case 42: {
                return 11;
            }
            case 43: {
                return 34;
            }
            case 44: {
                return 110;
            }
            case 45: {
                return 30;
            }
            case 46: {
                return 48;
            }
            case 47: {
                return 66;
            }
            case 48: {
                return 84;
            }
            case 49: {
                return 90;
            }
            case 50: {
                return 101;
            }
            case 51: {
                return 114;
            }
            case 52: {
                return 12;
            }
            case 53: {
                return 17;
            }
            case 54: {
                return 18;
            }
            case 55: {
                return 38;
            }
            case 56: {
                return 39;
            }
            case 57: {
                return 82;
            }
            case 58: {
                return 51;
            }
            case 59: {
                return 61;
            }
            case 60: {
                return 85;
            }
            case 61: {
                return 87;
            }
            case 62: {
                return 88;
            }
            case 63: {
                return 97;
            }
            case 64: {
                return 98;
            }
            case 65: {
                return 104;
            }
            case 66: {
                return 105;
            }
            case 67: {
                return 117;
            }
            case 68: {
                return 118;
            }
            case 69: {
                return 119;
            }
            case 70: {
                return 120;
            }
            case 71: {
                return 93;
            }
            case 72: {
                return 92;
            }
            case 73: {
                return 16;
            }
            case 74: {
                return 19;
            }
            case 75: {
                return 20;
            }
            case 76: {
                return 43;
            }
            case 77: {
                return 108;
            }
            case 78: {
                return 76;
            }
            case 79: {
                return 106;
            }
            case 80: {
                return 107;
            }
            case 81: {
                return 29;
            }
            case 82: {
                return 58;
            }
            case 83: {
                return 36;
            }
            case 84: {
                return 37;
            }
            case 85: {
                return 46;
            }
            case 86: {
                return 41;
            }
            case 87: {
                return 56;
            }
            case 88: {
                return 40;
            }
            case 89: {
                return 64;
            }
            case 90: {
                return 75;
            }
            case 91: {
                return 100;
            }
            case 92: {
                return 102;
            }
            case 93: {
                return 49;
            }
            case 94: {
                return 50;
            }
            case 95: {
                return 71;
            }
            case 96: {
                return 99;
            }
            case 97: {
                return 80;
            }
            case 98: {
                return 89;
            }
            case 99: {
                return 91;
            }
        }
        return 8;
    }

    private int getTipoMoto(int index) {
        switch (index) {
            case 0: {
                return 8;
            }
            case 1: {
                return 60;
            }
            case 2: {
                return 96;
            }
            case 3: {
                return 116;
            }
            case 4: {
                return 70;
            }
            case 5: {
                return 13;
            }
            case 6: {
                return 13;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 59;
            }
            case 9: {
                return 78;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 77;
            }
            case 12: {
                return 44;
            }
            case 13: {
                return 45;
            }
            case 14: {
                return 53;
            }
            case 15: {
                return 73;
            }
            case 16: {
                return 81;
            }
            case 17: {
                return 63;
            }
            case 18: {
                return 72;
            }
            case 19: {
                return 9;
            }
            case 20: {
                return 54;
            }
            case 21: {
                return 62;
            }
            case 22: {
                return 67;
            }
            case 23: {
                return 9;
            }
            case 24: {
                return 69;
            }
            case 25: {
                return 115;
            }
            case 26: {
                return 9;
            }
            case 27: {
                return 14;
            }
            case 28: {
                return 22;
            }
            case 29: {
                return 47;
            }
            case 30: {
                return 21;
            }
            case 31: {
                return 68;
            }
            case 32: {
                return 94;
            }
            case 33: {
                return 95;
            }
            case 34: {
                return 10;
            }
            case 35: {
                return 10;
            }
            case 36: {
                return 24;
            }
            case 37: {
                return 10;
            }
            case 38: {
                return 26;
            }
            case 39: {
                return 57;
            }
            case 40: {
                return 10;
            }
            case 41: {
                return 28;
            }
            case 42: {
                return 11;
            }
            case 43: {
                return 11;
            }
            case 44: {
                return 110;
            }
            case 45: {
                return 11;
            }
            case 46: {
                return 48;
            }
            case 47: {
                return 66;
            }
            case 48: {
                return 84;
            }
            case 49: {
                return 90;
            }
            case 50: {
                return 101;
            }
            case 51: {
                return 114;
            }
            case 52: {
                return 12;
            }
            case 53: {
                return 17;
            }
            case 54: {
                return 18;
            }
            case 55: {
                return 38;
            }
            case 56: {
                return 39;
            }
            case 57: {
                return 82;
            }
            case 58: {
                return 51;
            }
            case 59: {
                return 61;
            }
            case 60: {
                return 85;
            }
            case 61: {
                return 87;
            }
            case 62: {
                return 88;
            }
            case 63: {
                return 97;
            }
            case 64: {
                return 98;
            }
            case 65: {
                return 104;
            }
            case 66: {
                return 105;
            }
            case 67: {
                return 117;
            }
            case 68: {
                return 118;
            }
            case 69: {
                return 119;
            }
            case 70: {
                return 120;
            }
            case 71: {
                return 93;
            }
            case 72: {
                return 92;
            }
            case 73: {
                return 16;
            }
            case 74: {
                return 19;
            }
            case 75: {
                return 20;
            }
            case 76: {
                return 43;
            }
            case 77: {
                return 108;
            }
            case 78: {
                return 76;
            }
            case 79: {
                return 106;
            }
            case 80: {
                return 107;
            }
            case 81: {
                return 29;
            }
            case 82: {
                return 58;
            }
            case 83: {
                return 36;
            }
            case 84: {
                return 37;
            }
            case 85: {
                return 46;
            }
            case 86: {
                return 41;
            }
            case 87: {
                return 56;
            }
            case 88: {
                return 40;
            }
            case 89: {
                return 64;
            }
            case 90: {
                return 75;
            }
            case 91: {
                return 100;
            }
            case 92: {
                return 102;
            }
            case 93: {
                return 49;
            }
            case 94: {
                return 50;
            }
            case 95: {
                return 71;
            }
            case 96: {
                return 99;
            }
            case 97: {
                return 80;
            }
            case 98: {
                return 89;
            }
            case 99: {
                return 91;
            }
        }
        return 8;
    }

    private int getIndiceMoto(int index) {
        for (int i = 0; i < this.motoCB.getItemCount(); ++i) {
            if (this.getTipoMoto(i) != index) continue;
            return i;
        }
        return 0;
    }

    public String getStringaPulita(String origine) {
        if (origine == null) {
            origine = "";
        }
        String finale = origine;
        while (finale.endsWith(" ")) {
            finale = finale.substring(0, finale.length() - 1);
        }
        while (finale.startsWith(" ")) {
            finale = finale.substring(1, finale.length());
        }
        return finale;
    }

    public String getStringImportata(String origine, int caratteri) {
        String base = origine;
        if (base == "") {
            return "          ";
        }
        if (base.length() == caratteri) {
            return base;
        }
        String iniziale = base;
        while (iniziale.length() < caratteri) {
            iniziale = " " + iniziale;
        }
        return iniziale;
    }

    public boolean controllaValori() {
        if (this.circonferenza1 < 1500) {
            this.circonferenza1 = 1500;
        }
        if (this.circonferenza1 > 2500) {
            this.circonferenza1 = 2500;
        }
        if (this.circonferenza2 < 1500) {
            this.circonferenza2 = 1500;
        }
        if (this.circonferenza2 > 2500) {
            this.circonferenza2 = 2500;
        }
        return true;
    }

    public boolean controllaStringhe() {
        if (this.getStringaPulita(this.prefisso.getText()).contains(" ") || this.getStringaPulita(this.prefisso.getText()).length() == 0) {
            JOptionPane.showMessageDialog(this, Language.string("Il prefisso \u00e8 composto da pi\u00f9 parole o vuoto"), Language.string("ATTENZIONE"), 0);
            return false;
        }
        if (this.getStringaPulita(this.rete.getText()).contains(" ")) {
            JOptionPane.showMessageDialog(this, Language.string("Il nome di rete \u00e8 composto da pi\u00f9 parole o vuoto"), Language.string("ATTENZIONE"), 0);
            return false;
        }
        if (this.getStringaPulita(this.reteHot.getText()).contains(" ")) {
            JOptionPane.showMessageDialog(this, Language.string("Il nome della rete Hotspot \u00e8 composto da pi\u00f9 parole o vuoto"), Language.string("ATTENZIONE"), 0);
            return false;
        }
        if (this.getStringaPulita(this.passwordHot.getText()).contains(" ")) {
            JOptionPane.showMessageDialog(this, Language.string("La password dell'Hotspot \u00e8 composta da pi\u00f9 parole o vuoto"), Language.string("ATTENZIONE"), 0);
            return false;
        }
        if (this.getStringaPulita(this.password.getText()).contains(" ")) {
            JOptionPane.showMessageDialog(this, Language.string("La password di rete \u00e8 composta da pi\u00f9 parole o vuoto"), Language.string("ATTENZIONE"), 0);
            return false;
        }
        if (this.anterioreTF.getText().contains(" ") || this.posterioreTF.getText().contains(" ")) {
            JOptionPane.showMessageDialog(this, Language.string("ID Tpms contiene spazi."), Language.string("ATTENZIONE"), 0);
            return false;
        }
        for (int i = 0; i < 12; ++i) {
            if (this.getStringaPulita(this.nomeCanali[i]).length() != 0) continue;
            JOptionPane.showMessageDialog(this, Language.string("Almeno uno dei nomi degli ingressi \u00e8 vuoto"), Language.string("ATTENZIONE"), 0);
            return false;
        }
        return true;
    }

    public void setFrequencyCombo(int numero) {
        switch (numero) {
            case 10: {
                this.frequenzaCB.setSelectedIndex(0);
                break;
            }
            case 100: {
                this.frequenzaCB.setSelectedIndex(1);
            }
        }
    }

    public int getFrequencyCombo() {
        int frequency = 1;
        switch (this.frequenzaCB.getSelectedIndex()) {
            case 0: {
                frequency = 10;
                break;
            }
            case 1: {
                frequency = 100;
            }
        }
        return frequency;
    }

    public boolean isMotoMarcieCan() {
        int tipoMoto = this.getTipoMoto(this.motoCB.getSelectedIndex());
        return tipoMoto == 14 || tipoMoto == 15 || tipoMoto == 16 || tipoMoto == 19 || tipoMoto == 20 || tipoMoto == 21 || tipoMoto == 22 || tipoMoto == 29 || tipoMoto == 66 || tipoMoto == 110 || tipoMoto == 84 || tipoMoto == 90 || tipoMoto == 101 || tipoMoto == 114 || tipoMoto == 64 || tipoMoto == 63 || tipoMoto == 61 || tipoMoto == 85 || tipoMoto == 87 || tipoMoto == 88 || tipoMoto == 92 || tipoMoto == 93 || tipoMoto == 60 || tipoMoto == 97 || tipoMoto == 98 || tipoMoto == 104 || tipoMoto == 105 || tipoMoto == 118 || tipoMoto == 117 || tipoMoto == 120 || tipoMoto == 119 || tipoMoto == 57 || tipoMoto == 58 || tipoMoto == 59 || tipoMoto == 71 || tipoMoto == 99 || tipoMoto == 91 || tipoMoto == 72 || tipoMoto == 81 || tipoMoto == 73 || tipoMoto == 75 || tipoMoto == 116 || tipoMoto == 115 || tipoMoto == 100 || tipoMoto == 102 || tipoMoto == 76 || tipoMoto == 106 || tipoMoto == 107 || tipoMoto == 77 || tipoMoto == 78 || tipoMoto == 36 || tipoMoto == 69 || tipoMoto == 37 || tipoMoto == 38 || tipoMoto == 39 || tipoMoto == 51 || tipoMoto == 82 || tipoMoto == 56 || tipoMoto == 40 || tipoMoto == 42 || tipoMoto == 43 || tipoMoto == 108 || tipoMoto == 44 || tipoMoto == 45 || tipoMoto == 55 || tipoMoto == 46 || tipoMoto == 94 || tipoMoto == 95 || tipoMoto == 47 || tipoMoto == 68 || tipoMoto == 49 || tipoMoto == 48;
    }

    public void caricaSettaggio(int moto) {
        this.baudCan2CB.setSelectedIndex(2);
        this.canDialog.ripristinaTabella();
        this.baudCanCB.setSelectedIndex(2);
        this.nomeCanali[4] = "Lambda";
        this.valoriMinimiCanali[4] = 8.0f;
        this.valoriMassimiCanali[4] = 22.0f;
        this.circonferenza1 = 1950;
        this.circonferenza2 = 1980;
        switch (moto) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 42: 
            case 48: 
            case 54: {
                break;
            }
            case 44: 
            case 45: 
            case 63: 
            case 72: 
            case 73: 
            case 81: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 147.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 147.0f;
                this.nomeCanali[6] = "APS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "AX", 10, 1);
                this.canDialog.setCanaleDefault(1, "AY", 10, 1);
                this.canDialog.setCanaleDefault(2, "AZ", 10, 1);
                this.canDialog.setCanaleDefault(3, "Angle_rate_X", 10, 1);
                this.canDialog.setCanaleDefault(4, "Angle_rate_Y", 10, 1);
                this.canDialog.setCanaleDefault(5, "Angle_rate_Z", 10, 1);
                break;
            }
            case 116: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 100.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 100.0f;
                this.nomeCanali[6] = "APS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 62: 
            case 67: {
                this.pignone1 = 0;
                this.corona1 = 0;
                this.impulsiRpm = 1;
                this.impulsi1 = 49;
            }
            case 55: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 147.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 147.0f;
                this.nomeCanali[6] = "APS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 78: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = -20.0f;
                this.valoriMassimiCanali[1] = 184.6f;
                this.nomeCanali[1] = "FORK";
                this.valoriMinimiCanali[2] = -20.0f;
                this.valoriMassimiCanali[2] = 184.6f;
                this.nomeCanali[2] = "SHOCK";
                this.valoriMinimiCanali[3] = 0.0f;
                this.valoriMassimiCanali[3] = 81.84f;
                this.nomeCanali[3] = "BRK F";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 4.092f;
                this.nomeCanali[4] = "LAMBDA";
                this.valoriMinimiCanali[5] = 0.0f;
                this.valoriMassimiCanali[5] = 81.84f;
                this.nomeCanali[5] = "BRK R";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 102.3f;
                this.nomeCanali[6] = "GAS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "Cut Level";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 10.23f;
                this.nomeCanali[8] = "FPS";
                this.valoriMinimiCanali[9] = -1023.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "LOAD CELL";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 59: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = -20.0f;
                this.valoriMassimiCanali[1] = 184.6f;
                this.nomeCanali[1] = "FORK";
                this.valoriMinimiCanali[2] = -20.0f;
                this.valoriMassimiCanali[2] = 184.6f;
                this.nomeCanali[2] = "SHOCK";
                this.valoriMinimiCanali[3] = 0.0f;
                this.valoriMassimiCanali[3] = 81.84f;
                this.nomeCanali[3] = "BRK F";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 4.092f;
                this.nomeCanali[4] = "LAMBDA";
                this.valoriMinimiCanali[5] = 0.0f;
                this.valoriMassimiCanali[5] = 81.84f;
                this.nomeCanali[5] = "BRK R";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 102.3f;
                this.nomeCanali[6] = "GAS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 10.23f;
                this.nomeCanali[7] = "OPS";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 10.23f;
                this.nomeCanali[8] = "FPS";
                this.valoriMinimiCanali[9] = -1023.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "LOAD CELL";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 60: {
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 14: 
            case 22: 
            case 69: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 804.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 14614.0f;
                this.nomeCanali[7] = "TC";
                break;
            }
            case 115: {
                this.impulsiRpm = 1;
                this.impulsi1 = 7;
                this.pignone1 = 15;
                this.corona1 = 42;
                break;
            }
            case 21: 
            case 47: 
            case 68: {
                this.valoriMinimiCanali[0] = -18.74f;
                this.valoriMassimiCanali[0] = 118.2f;
                this.nomeCanali[0] = "GAS";
                this.valoriMinimiCanali[6] = -18.74f;
                this.valoriMassimiCanali[6] = 118.2f;
                this.nomeCanali[6] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "TC WHEELIE";
                break;
            }
            case 94: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 800.0f;
                this.nomeCanali[0] = "GAS";
                break;
            }
            case 95: {
                this.valoriMinimiCanali[0] = -18.74f;
                this.valoriMassimiCanali[0] = 118.2f;
                this.nomeCanali[0] = "GAS";
                this.valoriMinimiCanali[6] = -18.74f;
                this.valoriMassimiCanali[6] = 118.2f;
                this.nomeCanali[6] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "TC WHEELIE";
                this.canDialog.setCanaleDefault(0, "kqs up working", 100, 1);
                this.canDialog.setCanaleDefault(1, "kqs dn working", 100, 1);
                this.canDialog.setCanaleDefault(2, "SKTRC working", 100, 1);
                this.canDialog.setCanaleDefault(3, "wheelie working", 100, 1);
                this.canDialog.setCanaleDefault(4, "Battery voltage", 10, 1);
                this.canDialog.setCanaleDefault(5, "Shift sensor voltage", 100, 1);
                this.canDialog.setCanaleDefault(6, "Wheelie angle", 10, 1);
                this.canDialog.setCanaleDefault(7, "SKTRC active mode", 10, 1);
                this.canDialog.setCanaleDefault(8, "SKTRC setting level", 10, 1);
                this.canDialog.setCanaleDefault(9, "Wheelie active mode", 10, 1);
                this.canDialog.setCanaleDefault(10, "Wheeliw setting level", 10, 1);
                this.canDialog.setCanaleDefault(11, "KEBC setting level", 10, 1);
                break;
            }
            case 96: {
                this.valoriMinimiCanali[0] = -19.76f;
                this.valoriMassimiCanali[0] = 575.0f;
                this.nomeCanali[0] = "TPS";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 70: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 161.63f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[6] = -30.0f;
                this.valoriMassimiCanali[6] = 609.375f;
                this.nomeCanali[6] = "Air Temp.";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 509.454f;
                this.nomeCanali[7] = "MAP";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.circonferenza1 = 1950;
                this.circonferenza2 = 1980;
                break;
            }
            case 89: {
                this.valoriMinimiCanali[0] = -20.0f;
                this.valoriMassimiCanali[0] = 82.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = -10.0f;
                this.valoriMassimiCanali[1] = 0.23f;
                this.nomeCanali[1] = "Forcella";
                this.valoriMinimiCanali[2] = -10.0f;
                this.valoriMassimiCanali[2] = 0.23f;
                this.nomeCanali[2] = "Mono";
                this.valoriMinimiCanali[3] = -10.0f;
                this.valoriMassimiCanali[3] = 92.3f;
                this.nomeCanali[3] = "Freno ant";
                this.valoriMinimiCanali[4] = -10.0f;
                this.valoriMassimiCanali[4] = 92.3f;
                this.nomeCanali[4] = "Freno post";
                this.valoriMinimiCanali[6] = -20.0f;
                this.valoriMassimiCanali[6] = 82.3f;
                this.nomeCanali[6] = "Grip";
                this.valoriMinimiCanali[7] = -100.0f;
                this.valoriMassimiCanali[7] = 2.3f;
                this.nomeCanali[7] = "Lean angle";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 1023.0f;
                this.nomeCanali[8] = "Spare freno ant";
                this.valoriMinimiCanali[9] = 0.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "Spare freno post";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 91: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = -10.0f;
                this.valoriMassimiCanali[0] = 92.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = -30.0f;
                this.valoriMassimiCanali[1] = 72.3f;
                this.nomeCanali[1] = "FORK";
                this.valoriMinimiCanali[2] = -30.0f;
                this.valoriMassimiCanali[2] = 72.3f;
                this.nomeCanali[2] = "SHOCK";
                this.valoriMinimiCanali[3] = -10.0f;
                this.valoriMassimiCanali[3] = 0.23f;
                this.nomeCanali[3] = "BRK F";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 4.092f;
                this.nomeCanali[4] = "LAMBDA";
                this.valoriMinimiCanali[5] = -10.0f;
                this.valoriMassimiCanali[5] = 0.23f;
                this.nomeCanali[5] = "BRK R";
                this.valoriMinimiCanali[6] = -10.0f;
                this.valoriMassimiCanali[6] = 92.3f;
                this.nomeCanali[6] = "GAS";
                this.valoriMinimiCanali[7] = -10.0f;
                this.valoriMassimiCanali[7] = 0.23f;
                this.nomeCanali[7] = "Oil Pressure";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 102.3f;
                this.nomeCanali[8] = "CUT LEVEL";
                this.valoriMinimiCanali[9] = -1023.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "LOAD CELL";
                this.valoriMinimiCanali[10] = -10.0f;
                this.valoriMassimiCanali[10] = 92.3f;
                this.nomeCanali[10] = "Clutch slip";
                this.valoriMinimiCanali[11] = 0.0f;
                this.valoriMassimiCanali[11] = 1023.0f;
                this.nomeCanali[11] = "Virtual RPM";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Drum Volt", 500, 1);
                this.canDialog.setCanaleDefault(1, "Ct level", 500, 1);
                this.canDialog.setCanaleDefault(2, "Rider demand", 100, 1);
                this.canDialog.setCanaleDefault(3, "BAP", 100, 1);
                this.canDialog.setCanaleDefault(4, "Speed vehicle", 100, 1);
                this.canDialog.setCanaleDefault(5, "Torque rear", 100, 1);
                this.canDialog.setCanaleDefault(6, "Lambda Temp", 100, 1);
                this.canDialog.setCanaleDefault(7, "Inj corr Lambda", 100, 1);
                this.canDialog.setCanaleDefault(8, "Vref1", 10, 1);
                this.canDialog.setCanaleDefault(9, "Vref2", 10, 1);
                this.canDialog.setCanaleDefault(10, "Lean angle", 10, 1);
                this.canDialog.setCanaleDefault(11, "Vert acc", 10, 1);
                this.canDialog.setCanaleDefault(12, "Board Temp", 10, 1);
                this.canDialog.setCanaleDefault(13, "Stepper count", 10, 1);
                this.canDialog.setCanaleDefault(14, "Workmode", 10, 1);
                break;
            }
            case 99: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = -10.0f;
                this.valoriMassimiCanali[0] = 0.23f;
                this.nomeCanali[0] = "TPS A";
                this.valoriMinimiCanali[1] = -30.0f;
                this.valoriMassimiCanali[1] = 72.3f;
                this.nomeCanali[1] = "FORK";
                this.valoriMinimiCanali[2] = -30.0f;
                this.valoriMassimiCanali[2] = 72.3f;
                this.nomeCanali[2] = "SHOCK";
                this.valoriMinimiCanali[3] = -10.0f;
                this.valoriMassimiCanali[3] = 0.23f;
                this.nomeCanali[3] = "BRK F";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 4.092f;
                this.nomeCanali[4] = "LAMBDA 1";
                this.valoriMinimiCanali[5] = -10.0f;
                this.valoriMassimiCanali[5] = 0.23f;
                this.nomeCanali[5] = "BRK R";
                this.valoriMinimiCanali[6] = -10.0f;
                this.valoriMassimiCanali[6] = 0.23f;
                this.nomeCanali[6] = "GAS";
                this.valoriMinimiCanali[7] = -10.0f;
                this.valoriMassimiCanali[7] = 0.23f;
                this.nomeCanali[7] = "Oil Pressure";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 10.23f;
                this.nomeCanali[8] = "FPS";
                this.valoriMinimiCanali[9] = -1023.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "LOAD CELL";
                this.valoriMinimiCanali[10] = -10.0f;
                this.valoriMassimiCanali[10] = 0.23f;
                this.nomeCanali[10] = "TPS B";
                this.valoriMinimiCanali[11] = 0.0f;
                this.valoriMassimiCanali[11] = 4.092f;
                this.nomeCanali[11] = "LAMBDA 2";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Drum Volt", 500, 1);
                this.canDialog.setCanaleDefault(1, "Ct level", 500, 1);
                this.canDialog.setCanaleDefault(2, "Rider demand", 100, 1);
                this.canDialog.setCanaleDefault(3, "BAP", 100, 1);
                this.canDialog.setCanaleDefault(4, "Speed vehicle", 100, 1);
                this.canDialog.setCanaleDefault(5, "Torque rear", 100, 1);
                this.canDialog.setCanaleDefault(6, "Lambda 1 corr", 100, 1);
                this.canDialog.setCanaleDefault(7, "Lambda 2 corr", 100, 1);
                this.canDialog.setCanaleDefault(8, "Lambda 3 corr", 100, 1);
                this.canDialog.setCanaleDefault(9, "Lambda 4 corr", 100, 1);
                this.canDialog.setCanaleDefault(10, "Vref1", 10, 1);
                this.canDialog.setCanaleDefault(11, "Vref2", 10, 1);
                this.canDialog.setCanaleDefault(12, "Lean angle", 10, 1);
                this.canDialog.setCanaleDefault(13, "Cut strategy", 10, 1);
                this.canDialog.setCanaleDefault(14, "Board Temp", 10, 1);
                this.canDialog.setCanaleDefault(15, "Workmode", 10, 1);
                this.canDialog.setCanaleDefault(16, "Lambda 2", 100, 1);
                this.canDialog.setCanaleDefault(17, "Lambda 3", 100, 1);
                break;
            }
            case 71: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = -10.0f;
                this.valoriMassimiCanali[0] = 92.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = -30.0f;
                this.valoriMassimiCanali[1] = 72.3f;
                this.nomeCanali[1] = "FORK";
                this.valoriMinimiCanali[2] = -30.0f;
                this.valoriMassimiCanali[2] = 72.3f;
                this.nomeCanali[2] = "SHOCK";
                this.valoriMinimiCanali[3] = -10.0f;
                this.valoriMassimiCanali[3] = 0.23f;
                this.nomeCanali[3] = "BRK F";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 4.092f;
                this.nomeCanali[4] = "LAMBDA";
                this.valoriMinimiCanali[5] = -10.0f;
                this.valoriMassimiCanali[5] = 0.23f;
                this.nomeCanali[5] = "BRK R";
                this.valoriMinimiCanali[6] = -10.0f;
                this.valoriMassimiCanali[6] = 92.3f;
                this.nomeCanali[6] = "GAS";
                this.valoriMinimiCanali[7] = -10.0f;
                this.valoriMassimiCanali[7] = 0.23f;
                this.nomeCanali[7] = "Oil Pressure";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 10.23f;
                this.nomeCanali[8] = "FPS";
                this.valoriMinimiCanali[9] = -1023.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "LOAD CELL";
                this.valoriMinimiCanali[10] = -10.0f;
                this.valoriMassimiCanali[10] = 92.3f;
                this.nomeCanali[10] = "Clutch slip";
                this.valoriMinimiCanali[11] = 0.0f;
                this.valoriMassimiCanali[11] = 1023.0f;
                this.nomeCanali[11] = "Virtual RPM";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Drum Volt", 100, 1);
                this.canDialog.setCanaleDefault(1, "Ct level", 100, 1);
                this.canDialog.setCanaleDefault(2, "Rider demand", 100, 1);
                this.canDialog.setCanaleDefault(3, "BAP", 100, 1);
                this.canDialog.setCanaleDefault(4, "Speed vehicle", 100, 1);
                this.canDialog.setCanaleDefault(5, "Torque rear", 100, 1);
                this.canDialog.setCanaleDefault(6, "Lambda Temp", 100, 1);
                this.canDialog.setCanaleDefault(7, "Inj corr Lambda", 100, 1);
                this.canDialog.setCanaleDefault(8, "Vref1", 10, 1);
                this.canDialog.setCanaleDefault(9, "Vref2", 10, 1);
                this.canDialog.setCanaleDefault(10, "Lean angle", 10, 1);
                this.canDialog.setCanaleDefault(11, "Vert acc", 10, 1);
                this.canDialog.setCanaleDefault(12, "Board Temp", 10, 1);
                this.canDialog.setCanaleDefault(13, "Stepper count", 10, 1);
                this.canDialog.setCanaleDefault(14, "Workmode", 10, 1);
                break;
            }
            case 84: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "APS";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 90: {
                this.baudCanCB.setSelectedIndex(3);
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Throttle position TH", 10, 1);
                this.canDialog.setCanaleDefault(1, "THGRP", 10, 1);
                this.canDialog.setCanaleDefault(2, "Bank angle", 10, 1);
                this.canDialog.setCanaleDefault(3, "Pitch angle", 10, 1);
                this.canDialog.setCanaleDefault(4, "Relative pich", 10, 1);
                this.canDialog.setCanaleDefault(5, "GYXAC", 10, 1);
                this.canDialog.setCanaleDefault(6, "STRQTRG", 10, 1);
                this.canDialog.setCanaleDefault(7, "Shift drum angle", 10, 1);
                this.canDialog.setCanaleDefault(8, "Shift sensor input value", 10, 1);
                this.canDialog.setCanaleDefault(9, "AUXAD1", 10, 1);
                this.canDialog.setCanaleDefault(10, "AUXAD2", 10, 1);
                this.canDialog.setCanaleDefault(11, "AUXAD3", 10, 1);
                this.canDialog.setCanaleDefault(12, "AUXAD4", 10, 1);
                this.canDialog.setCanaleDefault(13, "Slip percentage", 10, 1);
                this.canDialog.setCanaleDefault(14, "target slip percentage", 10, 1);
                this.canDialog.setCanaleDefault(15, "Control torque intervener", 10, 1);
                this.canDialog.setCanaleDefault(16, "Retard control value", 10, 1);
                this.canDialog.setCanaleDefault(17, "Fuel consumption cc", 10, 1);
                this.canDialog.setCanaleDefault(18, "LAF", 10, 1);
                this.canDialog.setCanaleDefault(19, "LAFAD", 10, 1);
                this.canDialog.setCanaleDefault(20, "MAP sensor value", 10, 1);
                this.canDialog.setCanaleDefault(21, "Throttle position %", 10, 1);
                this.canDialog.setCanaleDefault(22, "Anti jerk control level", 100, 1);
                this.canDialog.setCanaleDefault(23, "TC effect level", 100, 1);
                this.canDialog.setCanaleDefault(24, "MIL CODE", 100, 1);
                this.canDialog.setCanaleDefault(25, "MODE-A", 100, 1);
                this.canDialog.setCanaleDefault(26, "MODE-B", 100, 1);
                this.canDialog.setCanaleDefault(27, "MODE-TYR", 100, 1);
                this.canDialog.setCanaleDefault(28, "FI MODE", 100, 1);
                this.canDialog.setCanaleDefault(29, "IG MODE", 100, 1);
                break;
            }
            case 101: {
                this.baudCanCB.setSelectedIndex(3);
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Throttle opening", 10, 1);
                this.canDialog.setCanaleDefault(1, "Grip opening", 10, 1);
                this.canDialog.setCanaleDefault(2, "Bank angle", 10, 1);
                this.canDialog.setCanaleDefault(3, "Pitch angle", 10, 1);
                this.canDialog.setCanaleDefault(4, "Relative pich", 10, 1);
                this.canDialog.setCanaleDefault(5, "GYXAC", 10, 1);
                this.canDialog.setCanaleDefault(6, "STRQTRG", 10, 1);
                this.canDialog.setCanaleDefault(7, "Shift drum angle", 10, 1);
                this.canDialog.setCanaleDefault(8, "Shift sensor input value", 10, 1);
                this.canDialog.setCanaleDefault(9, "AUXAD1", 10, 1);
                this.canDialog.setCanaleDefault(10, "AUXAD2", 10, 1);
                this.canDialog.setCanaleDefault(11, "AUXAD3", 10, 1);
                this.canDialog.setCanaleDefault(12, "AUXAD4", 10, 1);
                this.canDialog.setCanaleDefault(13, "Slip percentage", 10, 1);
                this.canDialog.setCanaleDefault(14, "target slip percentage", 10, 1);
                this.canDialog.setCanaleDefault(15, "Control torque intervener", 10, 1);
                this.canDialog.setCanaleDefault(16, "Retard control value", 10, 1);
                this.canDialog.setCanaleDefault(17, "Fuel consumption pulse", 10, 1);
                this.canDialog.setCanaleDefault(18, "LAF", 10, 1);
                this.canDialog.setCanaleDefault(19, "LAFAD", 10, 1);
                this.canDialog.setCanaleDefault(20, "MAP sensor value", 10, 1);
                this.canDialog.setCanaleDefault(21, "Throttle position", 10, 1);
                this.canDialog.setCanaleDefault(22, "Anti jerk control level", 100, 1);
                this.canDialog.setCanaleDefault(23, "TC effect level", 100, 1);
                this.canDialog.setCanaleDefault(24, "MIL CODE", 100, 1);
                this.canDialog.setCanaleDefault(25, "MODE-A", 100, 1);
                this.canDialog.setCanaleDefault(26, "MODE-B", 100, 1);
                this.canDialog.setCanaleDefault(27, "MODE-TYR", 100, 1);
                this.canDialog.setCanaleDefault(28, "FI MODE", 100, 1);
                this.canDialog.setCanaleDefault(29, "IG MODE", 100, 1);
                break;
            }
            case 114: {
                this.baudCan2CB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "APS";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Thr pos TH", 100, 2);
                this.canDialog.setCanaleDefault(1, "Grip pos% THGRP", 100, 2);
                this.canDialog.setCanaleDefault(2, "Bank angle", 100, 2);
                this.canDialog.setCanaleDefault(3, "Pitch angle", 100, 2);
                this.canDialog.setCanaleDefault(4, "Relative pich", 100, 2);
                this.canDialog.setCanaleDefault(5, "GYXAC", 100, 2);
                this.canDialog.setCanaleDefault(6, "STRQTRG", 100, 2);
                this.canDialog.setCanaleDefault(7, "Shift dr. angle", 100, 2);
                this.canDialog.setCanaleDefault(8, "Sh. sens val", 100, 2);
                this.canDialog.setCanaleDefault(9, "AUXAD1", 100, 2);
                this.canDialog.setCanaleDefault(10, "AUXAD2", 100, 2);
                this.canDialog.setCanaleDefault(11, "AUXAD3", 100, 2);
                this.canDialog.setCanaleDefault(12, "AUXAD4", 100, 2);
                this.canDialog.setCanaleDefault(13, "Slip %", 100, 2);
                this.canDialog.setCanaleDefault(14, "target slip %", 100, 2);
                this.canDialog.setCanaleDefault(15, "Control torque intervener", 100, 2);
                this.canDialog.setCanaleDefault(16, "IGTRQRTDL", 100, 2);
                this.canDialog.setCanaleDefault(17, "Fuel cons cc", 100, 2);
                this.canDialog.setCanaleDefault(18, "THLP", 100, 2);
                this.canDialog.setCanaleDefault(19, "THRP", 100, 2);
                this.canDialog.setCanaleDefault(20, "PBL", 100, 2);
                this.canDialog.setCanaleDefault(21, "PBR", 100, 2);
                this.canDialog.setCanaleDefault(22, "IGTRQRTDR", 10, 2);
                this.canDialog.setCanaleDefault(23, "TC effect level", 10, 2);
                this.canDialog.setCanaleDefault(24, "PWR MODE", 10, 2);
                this.canDialog.setCanaleDefault(25, "GRPPCT MODE", 10, 2);
                this.canDialog.setCanaleDefault(26, "TCS MODE", 10, 2);
                this.canDialog.setCanaleDefault(27, "WHEELIE MODE", 10, 2);
                this.canDialog.setCanaleDefault(28, "FI MODE", 10, 2);
                this.canDialog.setCanaleDefault(29, "IG MODE", 10, 2);
                break;
            }
            case 29: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 1023.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "RBW";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 58: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[4] = 0.512f;
                this.valoriMassimiCanali[4] = 1.535f;
                this.nomeCanali[4] = "Lambda";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 102.3f;
                this.nomeCanali[6] = "Demand";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "LoadCell";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 1023.0f;
                this.nomeCanali[8] = "MKL1 Temp";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 41: {
                this.baudCanCB.setSelectedIndex(1);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 1023.0f;
                this.nomeCanali[0] = "TPS";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.circonferenza1 = 1950;
                break;
            }
            case 46: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = 0.0f;
                this.valoriMassimiCanali[1] = 16.368f;
                this.nomeCanali[1] = "Fuel P";
                this.valoriMinimiCanali[2] = 0.0f;
                this.valoriMassimiCanali[2] = 16.368f;
                this.nomeCanali[2] = "Boost";
                this.valoriMinimiCanali[3] = 0.0f;
                this.valoriMassimiCanali[3] = 818.4f;
                this.nomeCanali[3] = "Oil Temp";
                this.valoriMinimiCanali[4] = 1.0f;
                this.valoriMassimiCanali[4] = 2047.0f;
                this.nomeCanali[4] = "Lambda";
                this.valoriMinimiCanali[5] = 1.0f;
                this.valoriMassimiCanali[5] = 2047.0f;
                this.nomeCanali[5] = "Lambda2";
                this.valoriMinimiCanali[6] = -102.3f;
                this.valoriMassimiCanali[6] = 102.3f;
                this.nomeCanali[6] = "Slip";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 16.368f;
                this.nomeCanali[7] = "Oil P";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 37: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = 0.0f;
                this.valoriMassimiCanali[1] = 150.0f;
                this.nomeCanali[1] = Language.string("Forcella");
                this.valoriMinimiCanali[2] = 0.0f;
                this.valoriMassimiCanali[2] = 75.0f;
                this.nomeCanali[2] = Language.string("Mono");
                this.valoriMinimiCanali[3] = 0.0f;
                this.valoriMassimiCanali[3] = 1023.0f;
                this.nomeCanali[3] = Language.string("Freno");
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 2.046f;
                this.nomeCanali[4] = "Lambda";
                this.valoriMinimiCanali[5] = -5.0f;
                this.valoriMassimiCanali[5] = 1018.0f;
                this.nomeCanali[5] = "TC Trim";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 102.3f;
                this.nomeCanali[6] = "Slip";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 401.17645f;
                this.nomeCanali[7] = "TC CUT";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 36: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 512.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[3] = 0.0f;
                this.valoriMassimiCanali[3] = 1023.0f;
                this.nomeCanali[3] = "Oil T";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 63.93f;
                this.nomeCanali[4] = "Oil P";
                this.valoriMinimiCanali[5] = 0.0f;
                this.valoriMassimiCanali[5] = 7.992f;
                this.nomeCanali[5] = "Lambda";
                break;
            }
            case 40: 
            case 56: 
            case 64: 
            case 75: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 401.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "TC";
                break;
            }
            case 100: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 1023.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 102.3f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 102: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 1023.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 102.3f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Clutch", 100, 1);
                this.canDialog.setCanaleDefault(1, "Lean angle", 100, 1);
                this.canDialog.setCanaleDefault(2, "Alarm", 100, 1);
                this.canDialog.setCanaleDefault(3, "AX", 100, 1);
                this.canDialog.setCanaleDefault(4, "AY", 100, 1);
                this.canDialog.setCanaleDefault(5, "AZ", 100, 1);
                this.canDialog.setCanaleDefault(6, "Roll rate", 100, 1);
                this.canDialog.setCanaleDefault(7, "Yaw rate", 100, 1);
                this.canDialog.setCanaleDefault(8, "Pitch rate", 100, 1);
                break;
            }
            case 43: 
            case 108: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 100.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 404.34f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 76: 
            case 106: 
            case 107: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 100.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[6] = -18.0f;
                this.valoriMassimiCanali[6] = 496.0f;
                this.nomeCanali[6] = "APS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 404.34f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 80: {
                this.baudCanCB.setSelectedIndex(1);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 102.3f;
                this.nomeCanali[4] = "LAMBDA";
                this.valoriMinimiCanali[5] = -100.0f;
                this.valoriMassimiCanali[5] = 923.0f;
                this.nomeCanali[5] = "AIR TEMP";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 77: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = -20.0f;
                this.valoriMassimiCanali[1] = 184.6f;
                this.nomeCanali[1] = "FORK";
                this.valoriMinimiCanali[2] = -20.0f;
                this.valoriMassimiCanali[2] = 184.6f;
                this.nomeCanali[2] = "SHOCK";
                this.valoriMinimiCanali[3] = 0.0f;
                this.valoriMassimiCanali[3] = 81.84f;
                this.nomeCanali[3] = "BRK F";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 4.092f;
                this.nomeCanali[4] = "LAMBDA";
                this.valoriMinimiCanali[5] = 0.0f;
                this.valoriMassimiCanali[5] = 81.84f;
                this.nomeCanali[5] = "BRK R";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 102.3f;
                this.nomeCanali[6] = "GAS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "Cut level";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 10.23f;
                this.nomeCanali[8] = "FPS";
                this.valoriMinimiCanali[9] = -1023.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "LOAD CELL";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 400.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 100.0f;
                this.nomeCanali[7] = "DtcTOT";
                if (moto != 20) {
                    this.valoriMinimiCanali[6] = 0.0f;
                    this.valoriMassimiCanali[6] = 100.0f;
                    this.nomeCanali[6] = "DtcSPN";
                }
                if (moto == 19) {
                    this.valoriMinimiCanali[1] = 0.0f;
                    this.valoriMassimiCanali[1] = 204.6f;
                    this.nomeCanali[1] = Language.string("Forcella");
                    this.valoriMinimiCanali[2] = 0.0f;
                    this.valoriMassimiCanali[2] = 84.4f;
                    this.nomeCanali[2] = Language.string("Mono");
                }
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 17: 
            case 18: {
                this.baudCanCB.setSelectedIndex(0);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 512.0f;
                this.nomeCanali[0] = "TPS";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 38: 
            case 39: 
            case 51: 
            case 82: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 512.0f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 512.0f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 61: 
            case 85: 
            case 87: 
            case 88: 
            case 92: 
            case 93: 
            case 97: 
            case 98: 
            case 104: 
            case 105: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 512.0f;
                this.nomeCanali[0] = "APS";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 163.68f;
                this.nomeCanali[6] = "TPS H";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 163.68f;
                this.nomeCanali[7] = "TPS V";
                this.valoriMinimiCanali[8] = 0.0f;
                this.valoriMassimiCanali[8] = 1023.0f;
                this.nomeCanali[8] = "TorqueRed S";
                this.valoriMinimiCanali[9] = 0.0f;
                this.valoriMassimiCanali[9] = 1023.0f;
                this.nomeCanali[9] = "TorqueRed F";
                this.valoriMinimiCanali[10] = -450.0f;
                this.valoriMassimiCanali[10] = 450.0f;
                this.nomeCanali[10] = "Lean Angle";
                this.valoriMinimiCanali[11] = -450.0f;
                this.valoriMassimiCanali[11] = 450.0f;
                this.nomeCanali[11] = "Pitch Angle";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                this.canDialog.setCanaleDefault(0, "Clutch status", 100, 1);
                this.canDialog.setCanaleDefault(1, "Atm. pressure", 100, 1);
                this.canDialog.setCanaleDefault(2, "Fuel alarm", 100, 1);
                this.canDialog.setCanaleDefault(3, "Fuel cons.", 100, 1);
                this.canDialog.setCanaleDefault(4, "Ax", 100, 1);
                this.canDialog.setCanaleDefault(5, "Ay", 100, 1);
                this.canDialog.setCanaleDefault(6, "Yaw rate", 100, 1);
                this.canDialog.setCanaleDefault(7, "Pitch rate", 100, 1);
                this.canDialog.setCanaleDefault(8, "Roll rate", 100, 1);
                break;
            }
            case 23: 
            case 24: {
                this.impulsiRpm = 0;
                this.impulsi1 = 3;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(83.6081f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(77.9579f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(69.6878f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(60.1048f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(51.2568f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(41.7721f)));
                this.pignone1 = 16;
                this.corona1 = 42;
                break;
            }
            case 25: 
            case 26: {
                this.impulsiRpm = 0;
                this.impulsi1 = 3;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(77.8688f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(72.8517f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(65.9875f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(57.7913f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(48.1701f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(38.6221f)));
                this.pignone1 = 16;
                this.corona1 = 42;
                break;
            }
            case 27: 
            case 28: {
                this.impulsiRpm = 0;
                this.impulsi1 = 3;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(65.8641f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(60.3091f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(53.2772f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(46.1798f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(38.5851f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(30.0826f)));
                this.pignone1 = 14;
                this.corona1 = 44;
                break;
            }
            case 57: {
                this.impulsiRpm = 0;
                this.impulsi1 = 47;
                this.impulsi2 = 47;
                this.pignone1 = 0;
                this.corona1 = 0;
                break;
            }
            case 33: {
                this.impulsiRpm = 1;
                this.impulsi1 = 19;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(77.2156f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(69.0919f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(61.4488f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(53.2569f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(44.3867f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(34.3408f)));
                this.pignone1 = 14;
                this.corona1 = 45;
                break;
            }
            case 35: {
                this.impulsiRpm = 1;
                this.impulsi1 = 32;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(83.6081f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(77.9579f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(69.6878f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(60.1048f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(51.2568f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(41.7721f)));
                this.pignone1 = 16;
                this.corona1 = 44;
                break;
            }
            case 49: {
                this.baudCanCB.setSelectedIndex(3);
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 102.3f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[1] = -20.0f;
                this.valoriMassimiCanali[1] = 1003.0f;
                this.nomeCanali[1] = "Trimmer";
                this.valoriMinimiCanali[2] = 0.0f;
                this.valoriMassimiCanali[2] = 102.3f;
                this.nomeCanali[2] = "E.VALVE";
                this.valoriMinimiCanali[3] = 0.0f;
                this.valoriMassimiCanali[3] = 50.0f;
                this.nomeCanali[3] = "DETO-1";
                this.valoriMinimiCanali[4] = 0.0f;
                this.valoriMassimiCanali[4] = 50.0f;
                this.nomeCanali[4] = "DETO-2";
                this.valoriMinimiCanali[5] = 0.0f;
                this.valoriMassimiCanali[5] = 50.0f;
                this.nomeCanali[5] = "DETO-3";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 50.0f;
                this.nomeCanali[6] = "DETO-4";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 10.23f;
                this.nomeCanali[7] = "FUEL P.";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 66: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 123.2f;
                this.nomeCanali[0] = "TPS";
                this.valoriMinimiCanali[6] = 0.0f;
                this.valoriMassimiCanali[6] = 155.0f;
                this.nomeCanali[6] = "APS";
                this.valoriMinimiCanali[7] = 0.0f;
                this.valoriMassimiCanali[7] = 1023.0f;
                this.nomeCanali[7] = "TC";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 110: {
                this.valoriMinimiCanali[0] = 0.0f;
                this.valoriMassimiCanali[0] = 123.2f;
                this.nomeCanali[0] = "APS";
                this.pignone1 = 0;
                this.corona1 = 0;
                this.pignone2 = 0;
                this.corona2 = 0;
                break;
            }
            case 34: {
                this.impulsiRpm = 1;
                this.impulsi1 = 21;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(82.719f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(76.6768f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(69.2766f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(59.9443f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(49.9697f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(36.2984f)));
                this.pignone1 = 15;
                this.corona1 = 44;
                break;
            }
            case 30: {
                this.impulsiRpm = 1;
                this.impulsi1 = 31;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(84.4293f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(79.4178f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(72.1336f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(64.1697f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(54.1524f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(42.0818f)));
                this.pignone1 = 15;
                this.corona1 = 44;
                break;
            }
            case 31: {
                this.impulsiRpm = 1;
                this.impulsi1 = 7;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(64.783f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(59.247f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(52.5941f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(45.5463f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(38.261f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(31.026f)));
                this.pignone1 = 15;
                this.corona1 = 42;
                break;
            }
            case 32: {
                this.impulsiRpm = 1;
                this.impulsi1 = 23;
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(95.2669f)));
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(88.6331f)));
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(80.0654f)));
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(71.4693f)));
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(60.5466f)));
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(47.7666f)));
                this.pignone1 = 15;
                this.corona1 = 42;
            }
        }
    }

    public String getRiassuntoCanale(int indice) {
        if (indice == 0) {
            return this.getTipoCanaleCan(indice) + ",canaleBase," + this.getFrequenza(indice) + ",0.0,1023.0,0,000,0,1,1111111111111111,1,0,8,0";
        }
        CanTableRow riga = this.elencoRigheCan.get(indice - 1);
        String riassunto = this.getTipoCanaleCan(indice) + "," + riga.getNome() + "," + this.getFrequenza(indice) + "," + this.getMinimo(indice) + "," + this.getMassimo(indice) + "," + this.getTipoSensore(indice) + "," + String.format("%04d", riga.getId()) + "," + riga.getByte1() + "," + riga.getByte2() + "," + riga.getMaschera() + "," + riga.getIndiceDivisione() + "," + this.getSegno(indice) + "," + this.getByteMultiplex(indice) + "," + riga.getValoreMultiplex() + "," + riga.getCan() + ",";
        return riassunto;
    }

    public int getSegno(int indice) {
        String segno = this.elencoRigheCan.get(indice - 1).getSegno();
        if (segno.startsWith("UNSIGNED")) {
            return 0;
        }
        if (segno.startsWith("SIGNED8")) {
            return 1;
        }
        if (segno.startsWith("SIGNED16")) {
            return 2;
        }
        return 0;
    }

    public int getByteMultiplex(int indice) {
        String byteMulti = this.elencoRigheCan.get(indice - 1).getByteMultiplex();
        if (byteMulti.startsWith("0")) {
            return 0;
        }
        if (byteMulti.startsWith("1")) {
            return 1;
        }
        if (byteMulti.startsWith("2")) {
            return 2;
        }
        if (byteMulti.startsWith("3")) {
            return 3;
        }
        if (byteMulti.startsWith("4")) {
            return 4;
        }
        if (byteMulti.startsWith("5")) {
            return 5;
        }
        if (byteMulti.startsWith("6")) {
            return 6;
        }
        if (byteMulti.startsWith("7")) {
            return 7;
        }
        if (byteMulti.startsWith("OFF")) {
            return 8;
        }
        return 0;
    }

    public int getTipoSensore(int indice) {
        String tipo = this.elencoRigheCan.get(indice - 1).getTipoSensore();
        if (tipo.startsWith("Linear")) {
            return 0;
        }
        if (tipo.startsWith("Parametric A")) {
            return 1;
        }
        if (tipo.startsWith("Parametric B")) {
            return 2;
        }
        if (tipo.startsWith("Parametric C")) {
            return 3;
        }
        return 0;
    }

    public void setTipoSensore(int indice, int tipo) {
        switch (tipo) {
            case 0: {
                this.elencoRigheCan.get(indice - 1).setTipoSensore("Linear");
                break;
            }
            case 1: {
                this.elencoRigheCan.get(indice - 1).setTipoSensore("Parametric A");
                break;
            }
            case 2: {
                this.elencoRigheCan.get(indice - 1).setTipoSensore("Parametric B");
                break;
            }
            case 3: {
                this.elencoRigheCan.get(indice - 1).setTipoSensore("Parametric C");
            }
        }
    }

    public void setSegno(int indice, int tipo) {
        switch (tipo) {
            case 0: {
                this.elencoRigheCan.get(indice - 1).setSegno("UNSIGNED");
                break;
            }
            case 1: {
                this.elencoRigheCan.get(indice - 1).setSegno("SIGNED8");
                break;
            }
            case 2: {
                this.elencoRigheCan.get(indice - 1).setSegno("SIGNED16");
            }
        }
    }

    public void setCan(int indice, int can) {
        switch (can) {
            case 1: {
                this.elencoRigheCan.get(indice - 1).setCan(1);
                break;
            }
            case 2: {
                this.elencoRigheCan.get(indice - 1).setCan(2);
                break;
            }
            default: {
                this.elencoRigheCan.get(indice - 1).setCan(1);
            }
        }
    }

    public void setByteMultiplex(int indice, int tipo) {
        switch (tipo) {
            case 0: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("0");
                break;
            }
            case 1: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("1");
                break;
            }
            case 2: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("2");
                break;
            }
            case 3: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("3");
                break;
            }
            case 4: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("4");
                break;
            }
            case 5: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("5");
                break;
            }
            case 6: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("6");
                break;
            }
            case 7: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("7");
                break;
            }
            case 8: {
                this.elencoRigheCan.get(indice - 1).setByteMultiplex("OFF");
            }
        }
    }

    public int getFrequenza(int indice) {
        if (indice == 0) {
            return this.baudCan2CB.getSelectedIndex();
        }
        int frequenza = this.elencoRigheCan.get(indice - 1).getFrequenza();
        switch (frequenza) {
            case 1: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 100: {
                return 2;
            }
            case 200: {
                return 3;
            }
            case 500: {
                return 4;
            }
        }
        return 1;
    }

    public void setFrequenza(int indice, int frequenza) {
        if (indice == 0) {
            this.baudCan2CB.setSelectedIndex(frequenza);
            return;
        }
        switch (frequenza) {
            case 0: {
                this.elencoRigheCan.get(indice - 1).setFrequenza(1);
                break;
            }
            case 1: {
                this.elencoRigheCan.get(indice - 1).setFrequenza(10);
                break;
            }
            case 2: {
                this.elencoRigheCan.get(indice - 1).setFrequenza(100);
                break;
            }
            case 3: {
                this.elencoRigheCan.get(indice - 1).setFrequenza(200);
                break;
            }
            case 4: {
                this.elencoRigheCan.get(indice - 1).setFrequenza(500);
            }
        }
    }

    public int getTipoCanaleCan(int indice) {
        if (indice == 0) {
            return this.baudCanCB.getSelectedIndex();
        }
        if (indice < 8) {
            if (this.elencoRigheCan.get(indice - 1).getTipo().equals("Default")) {
                return 0;
            }
            if (this.elencoRigheCan.get(indice - 1).getTipo().equals("Can Bus")) {
                return 2;
            }
            return 1;
        }
        if (!this.elencoRigheCan.get(indice - 1).getUsa()) {
            return 0;
        }
        if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Analog")) {
            return Integer.valueOf(this.elencoRigheCan.get(indice - 1).getTipo().substring(6, 7));
        }
        if (this.elencoRigheCan.get(indice - 1).getTipo().equals("Default")) {
            return 10;
        }
        return 9;
    }

    public void setTipoCanaleCan(int indice, int tipo) {
        if (indice == 0) {
            this.baudCanCB.setSelectedIndex(tipo);
            return;
        }
        if (indice < 8) {
            if (tipo == 0) {
                this.elencoRigheCan.get(indice - 1).setTipo("Default");
            }
            if (tipo == 1) {
                switch (indice) {
                    case 1: {
                        this.elencoRigheCan.get(indice - 1).setTipo("Rpm input");
                        break;
                    }
                    case 2: {
                        this.elencoRigheCan.get(indice - 1).setTipo(Language.string("Ingresso Vel2"));
                        break;
                    }
                    case 3: {
                        this.elencoRigheCan.get(indice - 1).setTipo(Language.string("Ingresso Vel1"));
                        break;
                    }
                    case 4: {
                        this.elencoRigheCan.get(indice - 1).setTipo(Language.string("Ingresso Acqua"));
                        break;
                    }
                    case 5: {
                        this.elencoRigheCan.get(indice - 1).setTipo(Language.string("Ingresso Olio"));
                        break;
                    }
                    case 6: {
                        this.elencoRigheCan.get(indice - 1).setTipo(Language.string("Ingresso Benzina"));
                        break;
                    }
                    case 7: {
                        this.elencoRigheCan.get(indice - 1).setTipo(Language.string("Ingresso Neutro"));
                    }
                }
            }
            if (tipo == 2) {
                this.elencoRigheCan.get(indice - 1).setTipo("Can Bus");
            }
            return;
        }
        if (tipo == 0) {
            this.elencoRigheCan.get(indice - 1).setUsa(false);
        } else {
            this.elencoRigheCan.get(indice - 1).setUsa(true);
        }
        switch (tipo) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.elencoRigheCan.get(indice - 1).setTipo("Analog" + tipo);
                break;
            }
            case 9: {
                this.elencoRigheCan.get(indice - 1).setTipo("Can Bus");
                break;
            }
            case 10: {
                this.elencoRigheCan.get(indice - 1).setTipo("Default");
            }
        }
    }

    public float getMinimo(int indice) {
        if (indice < 8) {
            if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Can Bus")) {
                return this.elencoRigheCan.get(indice - 1).getGuadagno();
            }
            return this.elencoRigheCan.get(indice - 1).getMinimo();
        }
        if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Analog")) {
            return this.elencoRigheCan.get(indice - 1).getMinimo();
        }
        return this.elencoRigheCan.get(indice - 1).getGuadagno();
    }

    public float getMassimo(int indice) {
        if (indice < 8) {
            if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Can Bus")) {
                return this.elencoRigheCan.get(indice - 1).getOffset();
            }
            return this.elencoRigheCan.get(indice - 1).getMassimo();
        }
        if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Analog")) {
            return this.elencoRigheCan.get(indice - 1).getMassimo();
        }
        return this.elencoRigheCan.get(indice - 1).getOffset();
    }

    public void setMinimo(int indice, float valore) {
        if (indice < 8) {
            if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Can Bus")) {
                this.elencoRigheCan.get(indice - 1).setGuadagno(valore);
            } else {
                this.elencoRigheCan.get(indice - 1).setMinimo(valore);
            }
        } else if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Analog")) {
            this.elencoRigheCan.get(indice - 1).setMinimo(valore);
        } else {
            this.elencoRigheCan.get(indice - 1).setGuadagno(valore);
        }
    }

    public void setMassimo(int indice, float valore) {
        if (indice < 8) {
            if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Can Bus")) {
                this.elencoRigheCan.get(indice - 1).setOffset(valore);
            } else {
                this.elencoRigheCan.get(indice - 1).setMassimo(valore);
            }
        } else if (this.elencoRigheCan.get(indice - 1).getTipo().startsWith("Analog")) {
            this.elencoRigheCan.get(indice - 1).setMassimo(valore);
        } else {
            this.elencoRigheCan.get(indice - 1).setOffset(valore);
        }
    }

    public void saveCanFile(String Directorypath, boolean temporaneo) {
        File f = null;
        if (temporaneo) {
            try {
                f = File.createTempFile("temp", ".tmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            f = new File(Directorypath, "canSettings.cfg");
        }
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            for (int i = 0; i < 136; ++i) {
                out.println("canale" + i + "=" + this.getRiassuntoCanale(i));
            }
            out.println("soglia0=" + this.neutro0TF.getValue());
            out.println("soglia1=" + this.neutro1TF.getValue());
            out.println("soglia2=" + this.neutro2TF.getValue());
            out.println("soglia3=" + this.neutro3TF.getValue());
            out.println("soglia4=" + this.neutro4TF.getValue());
            out.println("soglia5=" + this.neutro5TF.getValue());
            out.println("soglia6=" + this.neutro6TF.getValue());
            out.close();
        }
        catch (IOException ex) {
            this.salvataggioFallito = true;
            ex.printStackTrace();
        }
    }

    public float convertiMarcia(float dato) {
        if (dato == 0.0f) {
            return 1.0f;
        }
        return 160.0f / dato;
    }

    public String saveConversionFile(String Directorypath, boolean temporaneo) {
        String conversionWifi = "ConversionWifiSettings";
        File f = null;
        if (temporaneo) {
            try {
                f = File.createTempFile("temp", ".tmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            f = new File(Directorypath, "conversionSettings.cfg");
        }
        try {
            int i;
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            for (int i2 = 0; i2 < 10; ++i2) {
                out.println("I,ANALOG" + (i2 + 1) + "_MIN=" + this.valoriMinimiCanali[i2]);
                conversionWifi = conversionWifi + "," + this.valoriMinimiCanali[i2];
                out.println("I,ANALOG" + (i2 + 1) + "_MAX=" + this.valoriMassimiCanali[i2]);
                conversionWifi = conversionWifi + "," + this.valoriMassimiCanali[i2];
                out.println("I,ANALOG" + (i2 + 1) + "_NAM=" + this.getStringaPulita(this.nomeCanali[i2]));
                conversionWifi = conversionWifi + "," + this.getStringaPulita(this.nomeCanali[i2]);
            }
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            out.println("I,GEARS1=" + this.convertiMarcia(Float.valueOf(this.sestaTF.getText()).floatValue()));
            conversionWifi = conversionWifi + "," + this.convertiMarcia(Float.valueOf(this.sestaTF.getText()).floatValue());
            out.println("I,GEARS2=" + this.convertiMarcia(Float.valueOf(this.quintaTF.getText()).floatValue()));
            conversionWifi = conversionWifi + "," + this.convertiMarcia(Float.valueOf(this.quintaTF.getText()).floatValue());
            out.println("I,GEARS3=" + this.convertiMarcia(Float.valueOf(this.quartaTF.getText()).floatValue()));
            conversionWifi = conversionWifi + "," + this.convertiMarcia(Float.valueOf(this.quartaTF.getText()).floatValue());
            out.println("I,GEARS4=" + this.convertiMarcia(Float.valueOf(this.terzaTF.getText()).floatValue()));
            conversionWifi = conversionWifi + "," + this.convertiMarcia(Float.valueOf(this.terzaTF.getText()).floatValue());
            out.println("I,GEARS5=" + this.convertiMarcia(Float.valueOf(this.secondaTF.getText()).floatValue()));
            conversionWifi = conversionWifi + "," + this.convertiMarcia(Float.valueOf(this.secondaTF.getText()).floatValue());
            out.println("I,GEARS6=" + this.convertiMarcia(Float.valueOf(this.primaTF.getText()).floatValue()));
            conversionWifi = conversionWifi + "," + this.convertiMarcia(Float.valueOf(this.primaTF.getText()).floatValue());
            out.println("I,MOTORE_IMPU=" + (this.impulsiRpm + 1));
            conversionWifi = conversionWifi + "," + (this.impulsiRpm + 1);
            out.println("I,VELOC1_CIRC=" + this.circonferenza1);
            conversionWifi = conversionWifi + "," + this.circonferenza1;
            out.println("I,VELOC1_CORO=" + (this.corona1 + 1));
            conversionWifi = conversionWifi + "," + this.corona1;
            out.println("I,VELOC1_IMPU=" + (this.impulsi1 + 1));
            conversionWifi = conversionWifi + "," + this.impulsi1;
            out.println("I,VELOC1_PIGN=" + (this.pignone1 + 1));
            conversionWifi = conversionWifi + "," + this.pignone1;
            out.println("I,VELOC2_CIRC=" + this.circonferenza2);
            conversionWifi = conversionWifi + "," + this.circonferenza2;
            out.println("I,VELOC2_CORO=" + (this.corona2 + 1));
            conversionWifi = conversionWifi + "," + this.corona2;
            out.println("I,VELOC2_IMPU=" + (this.impulsi2 + 1));
            conversionWifi = conversionWifi + "," + this.impulsi2;
            out.println("I,VELOC2_PIGN=" + (this.pignone2 + 1));
            conversionWifi = conversionWifi + "," + this.pignone2;
            int tipoMoto = this.getTipoMoto(this.motoCB.getSelectedIndex());
            out.println("I,PEDERCINI=0");
            conversionWifi = conversionWifi + ",0";
            out.println("I,TIPO_SENSORE_ACQUA=" + tipoMoto);
            conversionWifi = conversionWifi + "," + tipoMoto;
            out.println("I,STECHIO_ATTIVA=0");
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",512";
            conversionWifi = conversionWifi + ",512";
            conversionWifi = conversionWifi + ",512";
            float temperatura = 512.0f;
            out.println("I,SOGLIA_TEMP=" + temperatura);
            conversionWifi = conversionWifi + "," + temperatura;
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            for (i = 10; i < 12; ++i) {
                out.println("I,ANALOG" + (i + 1) + "_MIN=" + this.valoriMinimiCanali[i]);
                conversionWifi = conversionWifi + "," + this.valoriMinimiCanali[i];
                out.println("I,ANALOG" + (i + 1) + "_MAX=" + this.valoriMassimiCanali[i]);
                conversionWifi = conversionWifi + "," + this.valoriMassimiCanali[i];
                out.println("I,ANALOG" + (i + 1) + "_NAM=" + this.getStringaPulita(this.nomeCanali[i]));
                conversionWifi = conversionWifi + "," + this.getStringaPulita(this.nomeCanali[i]);
            }
            conversionWifi = conversionWifi + ",0";
            conversionWifi = conversionWifi + ",0";
            for (i = 0; i < 12; ++i) {
                conversionWifi = conversionWifi + ",0";
                conversionWifi = conversionWifi + ",000";
                conversionWifi = conversionWifi + ",0";
                conversionWifi = conversionWifi + ",0";
                conversionWifi = conversionWifi + ",1111111111111111";
                conversionWifi = conversionWifi + ",0";
            }
            for (i = 0; i < 10; ++i) {
                out.println("P,SENSOR-" + i + "=" + this.tipoSensoreCanali[i]);
                conversionWifi = conversionWifi + "," + this.tipoSensoreCanali[i];
            }
            for (i = 0; i < 10; ++i) {
                out.println(i + ",SENSOR_A=" + this.sensoreA[i]);
                conversionWifi = conversionWifi + "," + this.sensoreA[i];
                out.println(i + ",SENSOR_B=" + this.sensoreB[i]);
                conversionWifi = conversionWifi + "," + this.sensoreB[i];
                out.println(i + ",SENSOR_C=" + this.sensoreC[i]);
                conversionWifi = conversionWifi + "," + this.sensoreC[i];
            }
            out.println("NUMERO_SENSOR_A=" + this.numeroA);
            conversionWifi = conversionWifi + "," + this.numeroA;
            out.println("NUMERO_SENSOR_B=" + this.numeroB);
            conversionWifi = conversionWifi + "," + this.numeroB;
            out.println("NUMERO_SENSOR_C=" + this.numeroC);
            conversionWifi = conversionWifi + "," + this.numeroC;
            conversionWifi = conversionWifi + ",0";
            for (i = 0; i < 128; ++i) {
                conversionWifi = conversionWifi + ",0";
            }
            conversionWifi = conversionWifi + ",";
            for (i = 0; i < this.frasiNonUtilizzate.size(); ++i) {
                out.println(this.frasiNonUtilizzate.get(i));
            }
            out.close();
        }
        catch (IOException ex) {
            this.salvataggioFallito = true;
            ex.printStackTrace();
        }
        return conversionWifi;
    }

    public String saveOpzioniFile(String Directorypath, boolean temporaneo) {
        String opzioniWifi = "OptionWifiSettings";
        File f = null;
        if (temporaneo) {
            try {
                f = File.createTempFile("temp", ".tmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            f = new File(Directorypath, "opzioniSettings.cfg");
        }
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            opzioniWifi = opzioniWifi + ",0";
            out.println("fuso=" + (this.fusoCB.getSelectedIndex() - 12));
            opzioniWifi = opzioniWifi + "," + (this.fusoCB.getSelectedIndex() - 12);
            opzioniWifi = opzioniWifi + ",0";
            out.println("standByTime=" + this.standCB.getSelectedIndex());
            opzioniWifi = opzioniWifi + "," + this.standCB.getSelectedIndex();
            opzioniWifi = opzioniWifi + ",0";
            opzioniWifi = opzioniWifi + ",0";
            opzioniWifi = opzioniWifi + ",0";
            opzioniWifi = opzioniWifi + ",0";
            int modalita = 0;
            opzioniWifi = opzioniWifi + "," + modalita + ",";
            out.close();
        }
        catch (IOException ex) {
            this.salvataggioFallito = true;
            ex.printStackTrace();
        }
        return opzioniWifi;
    }

    public String saveAcquisitionFile(String Directorypath, boolean temporaneo) {
        String acquisizioneWifi = "AcquisitionWifiSettings";
        File f = null;
        if (temporaneo) {
            try {
                f = File.createTempFile("temp", ".tmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            f = new File(Directorypath, "acquisitionSettings.cfg");
        }
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            acquisizioneWifi = acquisizioneWifi + ",XXXXXXXXXXXX";
            int frequency = this.getFrequencyCombo();
            out.println("acquisitionFrequency=" + frequency);
            acquisizioneWifi = acquisizioneWifi + "," + frequency;
            out.println("autoStartCriteria=" + this.canaleStartCB.getSelectedIndex());
            acquisizioneWifi = acquisizioneWifi + "," + this.canaleStartCB.getSelectedIndex();
            out.println("calibrazione=0");
            out.println("compresso=0");
            int specchio = 0;
            out.println("flipVideoActive=" + specchio);
            acquisizioneWifi = acquisizioneWifi + "," + specchio;
            int gopro = 0;
            out.println("goProActive=" + gopro);
            acquisizioneWifi = acquisizioneWifi + "," + gopro;
            out.println("minSpeed=" + (this.velMinCB.getSelectedIndex() * 5 + 10));
            acquisizioneWifi = acquisizioneWifi + "," + (this.velMinCB.getSelectedIndex() * 5 + 10);
            acquisizioneWifi = this.getStringaPulita(this.rete.getText()).equals("") ? acquisizioneWifi + ", " : acquisizioneWifi + "," + this.getStringaPulita(this.rete.getText());
            out.println("nomeRete=" + this.getStringaPulita(this.rete.getText()));
            out.println("password=" + this.getStringaPulita(this.password.getText()));
            acquisizioneWifi = this.getStringaPulita(this.password.getText()).equals("") ? acquisizioneWifi + ", " : acquisizioneWifi + "," + this.getStringaPulita(this.password.getText());
            out.println("prefisso=" + this.getStringaPulita(this.prefisso.getText()));
            acquisizioneWifi = acquisizioneWifi + "," + this.getStringaPulita(this.prefisso.getText());
            acquisizioneWifi = acquisizioneWifi + "," + 1;
            int record = 1;
            out.println("recordingActive=" + record);
            acquisizioneWifi = acquisizioneWifi + "," + record;
            int video = 0;
            out.println("recordingVideoActive=" + video);
            acquisizioneWifi = acquisizioneWifi + "," + video;
            int wifi = this.wifiON.isSelected() ? 1 : 0;
            out.println("wifiActive=" + wifi);
            acquisizioneWifi = acquisizioneWifi + "," + wifi;
            out.println("id1Code=" + this.anterioreTF.getText());
            acquisizioneWifi = acquisizioneWifi + "," + this.anterioreTF.getText();
            out.println("id2Code=" + this.posterioreTF.getText());
            acquisizioneWifi = acquisizioneWifi + "," + this.posterioreTF.getText();
            out.println("lapsActive=0");
            acquisizioneWifi = acquisizioneWifi + ",0";
            out.println("lapsPrivati=0");
            acquisizioneWifi = acquisizioneWifi + ",0";
            acquisizioneWifi = acquisizioneWifi + ", ";
            acquisizioneWifi = acquisizioneWifi + ", ";
            out.println("btActive=0");
            acquisizioneWifi = acquisizioneWifi + ",0";
            out.println("saturaBT=0");
            acquisizioneWifi = acquisizioneWifi + ",0";
            acquisizioneWifi = acquisizioneWifi + ",XXXXXXXXXXXX";
            out.println("id1Code_A=" + this.idAnteriori[0]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idAnteriori[0];
            out.println("id1Code_B=" + this.idAnteriori[1]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idAnteriori[1];
            out.println("id1Code_C=" + this.idAnteriori[2]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idAnteriori[2];
            out.println("id1Code_D=" + this.idAnteriori[3]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idAnteriori[3];
            out.println("id2Code_A=" + this.idPosteriori[0]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idPosteriori[0];
            out.println("id2Code_B=" + this.idPosteriori[1]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idPosteriori[1];
            out.println("id2Code_C=" + this.idPosteriori[2]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idPosteriori[2];
            out.println("id2Code_D=" + this.idPosteriori[3]);
            acquisizioneWifi = acquisizioneWifi + "," + this.idPosteriori[3];
            int periodica = 0;
            out.println("goProPeriodico=" + periodica);
            acquisizioneWifi = acquisizioneWifi + "," + periodica;
            acquisizioneWifi = acquisizioneWifi + "," + 1;
            out.println("code_corrente_front=" + this.tpmsAntCB.getSelectedIndex());
            acquisizioneWifi = acquisizioneWifi + "," + this.tpmsAntCB.getSelectedIndex();
            out.println("code_corrente_rear=" + this.tpmsPostCB.getSelectedIndex());
            acquisizioneWifi = acquisizioneWifi + "," + this.tpmsPostCB.getSelectedIndex();
            out.println("tipoFasciaBT=0");
            acquisizioneWifi = acquisizioneWifi + "," + 0;
            if (this.hotON.isSelected()) {
                out.println("hotspot=1");
                acquisizioneWifi = acquisizioneWifi + ",1";
            } else {
                out.println("hotspot=0");
                acquisizioneWifi = acquisizioneWifi + ",0";
            }
            out.println("nomeReteHot=" + this.getStringaPulita(this.reteHot.getText()));
            acquisizioneWifi = this.getStringaPulita(this.reteHot.getText()).equals("") ? acquisizioneWifi + ", " : acquisizioneWifi + "," + this.getStringaPulita(this.reteHot.getText());
            out.println("passwordHot=" + this.getStringaPulita(this.passwordHot.getText()));
            acquisizioneWifi = this.getStringaPulita(this.passwordHot.getText()).equals("") ? acquisizioneWifi + ", " : acquisizioneWifi + "," + this.getStringaPulita(this.passwordHot.getText());
            out.println("mostraSessioni=0");
            acquisizioneWifi = acquisizioneWifi + ",0";
            out.println("tipoMemoria=" + this.salvataggioCB.getSelectedIndex());
            acquisizioneWifi = acquisizioneWifi + "," + this.salvataggioCB.getSelectedIndex();
            acquisizioneWifi = acquisizioneWifi + ",";
            out.close();
        }
        catch (IOException ex) {
            this.salvataggioFallito = true;
            ex.printStackTrace();
        }
        return acquisizioneWifi;
    }

    public void trasmettiUsb() {
        String end = null;
        this.salvaValoriIngressiCorrenti(this.indiceAnalogicoPrecedente, this.indiceDigitalePrecedente);
        this.salvaValoriTPMS(this.indiceAnteriorePrecedente, this.indicePosteriorePrecedente);
        if (!this.controllaStringhe()) {
            return;
        }
        if (!this.controllaValori()) {
            return;
        }
        int resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("I settaggi del logger verrano sovrascritti. Procedere?"), Language.string("ATTENZIONE"), 0);
        if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
            return;
        }
        this.salvataggioFallito = false;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.conn.writeVeloce(this.saveOpzioniFile(null, true) + "\r");
            this.conn.writeVeloce(this.saveAcquisitionFile(null, true) + "\r");
            this.conn.writeVeloce(this.saveConversionFile(null, true) + "\r");
            for (int i = 0; i < 136; ++i) {
                this.conn.writeVeloce("CanWifiSettings," + i + "," + this.getRiassuntoCanale(i) + "\r");
            }
            String marce = "MarceWifiSettings," + this.neutro0TF.getValue() + "," + this.neutro1TF.getValue() + "," + this.neutro2TF.getValue() + "," + this.neutro3TF.getValue() + "," + this.neutro4TF.getValue() + "," + this.neutro5TF.getValue() + "," + this.neutro6TF.getValue() + ",";
            this.conn.writeVeloce(marce + "\r");
            this.conn.writeVeloce("SettaggiInviati\r");
            System.out.println("DEBUG: inviati tutti i settaggi, attendo risposta");
            this.conn.setTimeOut(10000);
            end = this.conn.readLine();
            this.conn.setTimeOut(1000);
            System.out.println("DEBUG: ricevuto:" + end);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (end == null || !end.startsWith("SettaggiRicevuti")) {
            this.salvataggioFallito = true;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.salvataggioFallito) {
            JOptionPane.showMessageDialog(this, Language.string("Invio non riuscito completamente"), Language.string("ATTENZIONE"), 0);
        } else {
            JOptionPane.showMessageDialog(this, Language.string("Invio completato"), Language.string("INFO"), 1);
            this.consolidaValoriAttuali(true);
        }
    }

    public void riceviUsb() {
        this.salvataggioFallito = false;
        int numeroSettaggi = 0;
        String end = null;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.conn.write("RiceviSettaggi\r");
            end = this.conn.readLine();
            this.importazioneInCorso = true;
            while (end != null && !end.startsWith("FineSettaggi")) {
                if (end.startsWith("AcquisitionWifiSettings")) {
                    System.out.println("DEBUG: AcquisitionWifiSettings ricevuti");
                    this.importaAcquisizioniWifi(end);
                    ++numeroSettaggi;
                }
                if (end.startsWith("OptionWifiSettings")) {
                    System.out.println("DEBUG: OptionWifiSettings ricevute");
                    this.importaOpzioniWifi(end);
                    ++numeroSettaggi;
                }
                if (end.startsWith("ConversionWifiSettings")) {
                    System.out.println("DEBUG: ConversionWifiSettings ricevuti");
                    this.importaConversionWifi(end);
                    ++numeroSettaggi;
                }
                if (end.startsWith("CanWifiSettings")) {
                    System.out.println("DEBUG: CanWifiSettings ricevuti");
                    this.importaCanWifi(end);
                    ++numeroSettaggi;
                }
                end = this.conn.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.salvataggioFallito = true;
        }
        this.importazioneInCorso = false;
        if (end == null || numeroSettaggi != 4) {
            this.salvataggioFallito = true;
            System.out.println("DEBUG: numero settaggi ricebuti=" + numeroSettaggi);
        }
        this.aggiornaCampi();
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.salvataggioFallito) {
            JOptionPane.showMessageDialog(this, Language.string("Ricezione non riuscita completamente"), Language.string("ATTENZIONE"), 0);
        } else {
            JOptionPane.showMessageDialog(this, Language.string("Ricezione completata"), Language.string("INFO"), 1);
            this.consolidaValoriAttuali(true);
        }
        this.verificaMarce();
    }

    public void estraiMarce(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, ",");
            st.nextToken();
            this.neutro0TF.setValue(Float.valueOf(st.nextToken()));
            this.neutro1TF.setValue(Float.valueOf(st.nextToken()));
            this.neutro2TF.setValue(Float.valueOf(st.nextToken()));
            this.neutro3TF.setValue(Float.valueOf(st.nextToken()));
            this.neutro4TF.setValue(Float.valueOf(st.nextToken()));
            this.neutro5TF.setValue(Float.valueOf(st.nextToken()));
            this.neutro6TF.setValue(Float.valueOf(st.nextToken()));
        }
        catch (Exception e) {
            this.salvataggioFallito = true;
            e.printStackTrace();
        }
    }

    public void estraiValoriCanali(String line, int index, boolean estraiNumero) {
        int indice = index;
        try {
            String campo;
            StringTokenizer st = new StringTokenizer(line, ",");
            if (estraiNumero) {
                campo = st.nextToken();
                indice = Integer.valueOf(campo);
            }
            if (indice == 0) {
                this.baudCanCB.setSelectedIndex(Integer.valueOf(st.nextToken()));
                campo = st.nextToken();
                this.baudCan2CB.setSelectedIndex(Integer.valueOf(st.nextToken()));
                return;
            }
            this.setTipoCanaleCan(indice, Integer.valueOf(st.nextToken()));
            this.elencoRigheCan.get(indice - 1).setNome(st.nextToken());
            campo = st.nextToken();
            this.setFrequenza(indice, Integer.valueOf(campo));
            this.setMinimo(indice, Float.valueOf(st.nextToken()).floatValue());
            this.setMassimo(indice, Float.valueOf(st.nextToken()).floatValue());
            campo = st.nextToken();
            this.setTipoSensore(indice, Integer.valueOf(campo));
            campo = st.nextToken();
            this.elencoRigheCan.get(indice - 1).setId(Integer.valueOf(campo));
            campo = st.nextToken();
            this.elencoRigheCan.get(indice - 1).setByte1(Integer.valueOf(campo));
            campo = st.nextToken();
            this.elencoRigheCan.get(indice - 1).setByte2(Integer.valueOf(campo));
            this.elencoRigheCan.get(indice - 1).setMaschera(st.nextToken());
            campo = st.nextToken();
            this.elencoRigheCan.get(indice - 1).setDivisione((int)Math.pow(2.0, Integer.valueOf(campo).intValue()));
            if (st.hasMoreTokens()) {
                campo = st.nextToken();
                this.setSegno(indice, Integer.valueOf(campo));
                campo = st.nextToken();
                this.setByteMultiplex(indice, Integer.valueOf(campo));
                campo = st.nextToken();
                this.elencoRigheCan.get(indice - 1).setValoreMultiplex(Integer.valueOf(campo));
            }
            if (st.hasMoreTokens()) {
                campo = st.nextToken();
                this.setCan(indice, Integer.valueOf(campo));
            }
        }
        catch (Exception e) {
            this.salvataggioFallito = true;
            e.printStackTrace();
        }
    }

    public void importaCanWifi(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, ";");
            String campo = st.nextToken();
            for (int i = 0; i < 136; ++i) {
                if (!st.hasMoreTokens()) continue;
                this.estraiValoriCanali(st.nextToken(), 0, true);
            }
            this.elencoRigheCan.get(0).setFrequenza(this.getFrequencyCombo());
            this.elencoRigheCan.get(1).setFrequenza(this.getFrequencyCombo());
            this.elencoRigheCan.get(2).setFrequenza(this.getFrequencyCombo());
            if (st.hasMoreTokens()) {
                this.estraiMarce(st.nextToken());
            }
        }
        catch (Exception e) {
            this.salvataggioFallito = true;
            e.printStackTrace();
        }
    }

    public void importaCanSettings(String Directorypath) {
        File f = new File(Directorypath, "CanSettings.cfg");
        if (!f.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                int numero;
                if (line.isEmpty()) continue;
                StringTokenizer st = new StringTokenizer(line, "=");
                String campo = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String valore = st.nextToken();
                if (campo.startsWith("canale")) {
                    numero = Integer.valueOf(campo.substring(6));
                    this.estraiValoriCanali(valore, numero, false);
                }
                if (campo.startsWith("soglia")) {
                    numero = Integer.valueOf(campo.substring(6, 7));
                    switch (numero) {
                        case 0: {
                            this.neutro0TF.setValue(Float.valueOf(valore));
                            break;
                        }
                        case 1: {
                            this.neutro1TF.setValue(Float.valueOf(valore));
                            break;
                        }
                        case 2: {
                            this.neutro2TF.setValue(Float.valueOf(valore));
                            break;
                        }
                        case 3: {
                            this.neutro3TF.setValue(Float.valueOf(valore));
                            break;
                        }
                        case 4: {
                            this.neutro4TF.setValue(Float.valueOf(valore));
                            break;
                        }
                        case 5: {
                            this.neutro5TF.setValue(Float.valueOf(valore));
                            break;
                        }
                        case 6: {
                            this.neutro6TF.setValue(Float.valueOf(valore));
                        }
                    }
                }
                this.elencoRigheCan.get(0).setFrequenza(this.getFrequencyCombo());
                this.elencoRigheCan.get(1).setFrequenza(this.getFrequencyCombo());
                this.elencoRigheCan.get(2).setFrequenza(this.getFrequencyCombo());
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void importaConversionWifi(String line) {
        boolean pedercini = false;
        try {
            block15: {
                Float numeroFloat;
                StringTokenizer st = new StringTokenizer(line, ",");
                String campo = st.nextToken();
                for (int i = 0; i < 10; ++i) {
                    campo = st.nextToken();
                    numeroFloat = Float.valueOf(campo);
                    this.valoriMinimiCanali[i] = numeroFloat.floatValue();
                    campo = st.nextToken();
                    numeroFloat = Float.valueOf(campo);
                    this.valoriMassimiCanali[i] = numeroFloat.floatValue();
                    campo = st.nextToken();
                    this.nomeCanali[i] = this.getStringImportata(campo, 10);
                }
                campo = st.nextToken();
                int numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(numeroFloat.floatValue())));
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(numeroFloat.floatValue())));
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(numeroFloat.floatValue())));
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(numeroFloat.floatValue())));
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(numeroFloat.floatValue())));
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                this.primaTF.setValue(Float.valueOf(this.convertiMarcia(numeroFloat.floatValue())));
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                if ((double)numero == 0.5) {
                    numeroFloat = Float.valueOf(1.0f);
                }
                this.impulsiRpm = (int)numeroFloat.floatValue() - 1;
                campo = st.nextToken();
                this.circonferenza1 = numero = Integer.valueOf(campo).intValue();
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.corona1 = numero - 1;
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.impulsi1 = numero - 1;
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.pignone1 = numero - 1;
                campo = st.nextToken();
                this.circonferenza2 = numero = Integer.valueOf(campo).intValue();
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.corona2 = numero - 1;
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.impulsi2 = numero - 1;
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.pignone2 = numero - 1;
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.ripristinoInCorso = true;
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                this.ripristinoInCorso = true;
                this.motoCB.setSelectedIndex(this.getIndiceMoto(numero));
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                campo = st.nextToken();
                numeroFloat = Float.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                boolean primoCampoVuoto = false;
                try {
                    int i;
                    if (st.hasMoreTokens()) {
                        for (i = 10; i < 12; ++i) {
                            campo = st.nextToken();
                            if (campo.isEmpty()) {
                                primoCampoVuoto = true;
                            }
                            numeroFloat = Float.valueOf(campo);
                            this.valoriMinimiCanali[i] = numeroFloat.floatValue();
                            campo = st.nextToken();
                            numeroFloat = Float.valueOf(campo);
                            this.valoriMassimiCanali[i] = numeroFloat.floatValue();
                            campo = st.nextToken();
                            this.nomeCanali[i] = this.getStringImportata(campo, 10);
                        }
                        campo = st.nextToken();
                        numero = Integer.valueOf(campo);
                        campo = st.nextToken();
                        numero = Integer.valueOf(campo);
                        for (i = 0; i < 12; ++i) {
                            campo = st.nextToken();
                            numero = Integer.valueOf(campo);
                            campo = st.nextToken();
                            campo = st.nextToken();
                            numero = Integer.valueOf(campo);
                            campo = st.nextToken();
                            numero = Integer.valueOf(campo);
                            campo = st.nextToken();
                            campo = st.nextToken();
                            numero = Integer.valueOf(campo);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        for (i = 0; i < 10; ++i) {
                            campo = st.nextToken();
                            this.tipoSensoreCanali[i] = numero = Integer.valueOf(campo).intValue();
                        }
                        for (i = 0; i < 10; ++i) {
                            campo = st.nextToken();
                            numeroFloat = Float.valueOf(campo);
                            this.sensoreA[i] = numeroFloat.floatValue();
                            campo = st.nextToken();
                            numeroFloat = Float.valueOf(campo);
                            this.sensoreB[i] = numeroFloat.floatValue();
                            campo = st.nextToken();
                            numeroFloat = Float.valueOf(campo);
                            this.sensoreC[i] = numeroFloat.floatValue();
                        }
                        campo = st.nextToken();
                        this.numeroA = numero = Integer.valueOf(campo).intValue();
                        campo = st.nextToken();
                        this.numeroB = numero = Integer.valueOf(campo).intValue();
                        campo = st.nextToken();
                        this.numeroC = numero = Integer.valueOf(campo).intValue();
                        campo = st.nextToken();
                        numero = Integer.valueOf(campo);
                    }
                    if (st.hasMoreTokens()) {
                        for (i = 0; i < 128 && st.hasMoreTokens(); ++i) {
                            campo = st.nextToken();
                            numero = Integer.valueOf(campo);
                        }
                    }
                }
                catch (Exception e) {
                    if (!primoCampoVuoto) break block15;
                    this.salvataggioFallito = true;
                }
            }
            this.ripristinoInCorso = false;
        }
        catch (Exception e) {
            this.salvataggioFallito = true;
            this.ripristinoInCorso = false;
            e.printStackTrace();
        }
    }

    public void importaConversion(String Directorypath) {
        File f = new File(Directorypath, "conversionSettings.cfg");
        if (!f.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            boolean pedercini = false;
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) continue;
                StringTokenizer st = new StringTokenizer(line, "=");
                String campo = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String valore = st.nextToken();
                if (campo.startsWith("I,VELOC2_PIGN")) {
                    int numero = Integer.valueOf(valore);
                    this.pignone2 = numero - 1;
                    continue;
                }
                if (campo.startsWith("I,VELOC2_IMPU")) {
                    int numero = Integer.valueOf(valore);
                    this.impulsi2 = numero - 1;
                    continue;
                }
                if (campo.startsWith("I,VELOC2_CORO")) {
                    int numero = Integer.valueOf(valore);
                    this.corona2 = numero - 1;
                    continue;
                }
                if (campo.startsWith("I,VELOC2_CIRC")) {
                    int numero;
                    this.circonferenza2 = numero = Integer.valueOf(valore).intValue();
                    continue;
                }
                if (campo.startsWith("I,VELOC1_PIGN")) {
                    int numero = Integer.valueOf(valore);
                    this.pignone1 = numero - 1;
                    continue;
                }
                if (campo.startsWith("I,VELOC1_IMPU")) {
                    int numero = Integer.valueOf(valore);
                    this.impulsi1 = numero - 1;
                    continue;
                }
                if (campo.startsWith("I,VELOC1_CORO")) {
                    int numero = Integer.valueOf(valore);
                    this.corona1 = numero - 1;
                    continue;
                }
                if (campo.startsWith("I,VELOC1_CIRC")) {
                    int numero;
                    this.circonferenza1 = numero = Integer.valueOf(valore).intValue();
                    continue;
                }
                if (campo.startsWith("I,MOTORE_IMPU")) {
                    Float numero = Float.valueOf(valore);
                    if ((double)numero.floatValue() == 0.5) {
                        numero = Float.valueOf(1.0f);
                    }
                    this.impulsiRpm = (int)numero.floatValue() - 1;
                    continue;
                }
                if (campo.startsWith("I,GEARS1")) {
                    Float numero = Float.valueOf(valore);
                    this.sestaTF.setValue(Float.valueOf(this.convertiMarcia(numero.floatValue())));
                    continue;
                }
                if (campo.startsWith("I,GEARS2")) {
                    Float numero = Float.valueOf(valore);
                    this.quintaTF.setValue(Float.valueOf(this.convertiMarcia(numero.floatValue())));
                    continue;
                }
                if (campo.startsWith("I,GEARS3")) {
                    Float numero = Float.valueOf(valore);
                    this.quartaTF.setValue(Float.valueOf(this.convertiMarcia(numero.floatValue())));
                    continue;
                }
                if (campo.startsWith("I,GEARS4")) {
                    Float numero = Float.valueOf(valore);
                    this.terzaTF.setValue(Float.valueOf(this.convertiMarcia(numero.floatValue())));
                    continue;
                }
                if (campo.startsWith("I,GEARS5")) {
                    Float numero = Float.valueOf(valore);
                    this.secondaTF.setValue(Float.valueOf(this.convertiMarcia(numero.floatValue())));
                    continue;
                }
                if (campo.startsWith("I,GEARS6")) {
                    Float numero = Float.valueOf(valore);
                    this.primaTF.setValue(Float.valueOf(this.convertiMarcia(numero.floatValue())));
                    continue;
                }
                if (campo.startsWith("I,TIPO_SENSORE_ACQUA")) {
                    int numero = Integer.valueOf(valore);
                    this.ripristinoInCorso = true;
                    this.motoCB.setSelectedIndex(this.getIndiceMoto(numero));
                    continue;
                }
                if (campo.startsWith("I,ANALOG")) {
                    Float numero;
                    StringTokenizer st2 = new StringTokenizer(campo, "_");
                    String funzione = st2.nextToken();
                    funzione = funzione.substring(8, funzione.length());
                    int numeroCanale = Integer.valueOf(funzione);
                    String canale = st2.nextToken();
                    if (canale.startsWith("MAX")) {
                        numero = Float.valueOf(valore);
                        this.valoriMassimiCanali[numeroCanale - 1] = numero.floatValue();
                    }
                    if (canale.startsWith("MIN")) {
                        numero = Float.valueOf(valore);
                        this.valoriMinimiCanali[numeroCanale - 1] = numero.floatValue();
                    }
                    if (!canale.startsWith("NAM")) continue;
                    this.nomeCanali[numeroCanale - 1] = this.getStringImportata(valore, 10);
                    continue;
                }
                if (campo.startsWith("P,SENSOR-")) {
                    int numero;
                    campo = campo.substring(9, campo.length());
                    int numeroCanale = Integer.valueOf(campo);
                    this.tipoSensoreCanali[numeroCanale] = numero = Integer.valueOf(valore).intValue();
                    continue;
                }
                if (campo.length() > 2 && campo.substring(2).startsWith("SENSOR_A")) {
                    double numero;
                    campo = campo.substring(0, 1);
                    int numeroCanale = Integer.valueOf(campo);
                    this.sensoreA[numeroCanale] = numero = Double.valueOf(valore).doubleValue();
                    continue;
                }
                if (campo.length() > 2 && campo.substring(2).startsWith("SENSOR_B")) {
                    double numero;
                    campo = campo.substring(0, 1);
                    int numeroCanale = Integer.valueOf(campo);
                    this.sensoreB[numeroCanale] = numero = Double.valueOf(valore).doubleValue();
                    continue;
                }
                if (campo.length() > 2 && campo.substring(2).startsWith("SENSOR_C")) {
                    double numero;
                    campo = campo.substring(0, 1);
                    int numeroCanale = Integer.valueOf(campo);
                    this.sensoreC[numeroCanale] = numero = Double.valueOf(valore).doubleValue();
                    continue;
                }
                if (campo.startsWith("NUMERO_SENSOR_A")) {
                    int numero;
                    this.numeroA = numero = Integer.valueOf(valore).intValue();
                    continue;
                }
                if (campo.startsWith("NUMERO_SENSOR_B")) {
                    int numero;
                    this.numeroB = numero = Integer.valueOf(valore).intValue();
                    continue;
                }
                if (campo.startsWith("NUMERO_SENSOR_C")) {
                    int numero;
                    this.numeroC = numero = Integer.valueOf(valore).intValue();
                    continue;
                }
                this.frasiNonUtilizzate.addElement(line);
            }
            this.ripristinoInCorso = false;
            in.close();
        }
        catch (IOException ex) {
            this.ripristinoInCorso = false;
            ex.printStackTrace();
        }
    }

    public void importaAcquisizioniWifi(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, ",");
            String campo = st.nextToken();
            campo = st.nextToken();
            campo = st.nextToken();
            int numero = Integer.valueOf(campo);
            this.setFrequencyCombo(numero);
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            this.canaleStartCB.setSelectedIndex(numero);
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            this.velMinCB.setSelectedIndex((numero - 10) / 5);
            campo = st.nextToken();
            this.rete.setText(this.getStringImportata(campo, 20));
            campo = st.nextToken();
            this.password.setText(this.getStringImportata(campo, 20));
            campo = st.nextToken();
            this.prefisso.setText(this.getStringImportata(campo, 10));
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            if (numero == 1) {
                this.wifiON.setSelected(true);
            } else {
                this.wifiOFF.setSelected(true);
            }
            if (st.hasMoreTokens()) {
                campo = st.nextToken();
                campo = st.nextToken();
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                campo = st.nextToken();
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                numero = Integer.valueOf(campo);
                campo = st.nextToken();
                if (st.hasMoreTokens()) {
                    this.idAnteriori[0] = campo = st.nextToken();
                    this.idAnteriori[1] = campo = st.nextToken();
                    this.idAnteriori[2] = campo = st.nextToken();
                    this.idAnteriori[3] = campo = st.nextToken();
                    this.idPosteriori[0] = campo = st.nextToken();
                    this.idPosteriori[1] = campo = st.nextToken();
                    this.idPosteriori[2] = campo = st.nextToken();
                    this.idPosteriori[3] = campo = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    campo = st.nextToken();
                    numero = Integer.valueOf(campo);
                    campo = st.nextToken();
                    numero = Integer.valueOf(campo);
                    campo = st.nextToken();
                    int numeroAnteriore = Integer.valueOf(campo);
                    this.anterioreTF.setValue(this.idAnteriori[this.tpmsAntCB.getSelectedIndex()]);
                    campo = st.nextToken();
                    int numeroPosteriore = Integer.valueOf(campo);
                    this.posterioreTF.setValue(this.idPosteriori[this.tpmsPostCB.getSelectedIndex()]);
                    this.tpmsAntCB.setSelectedIndex(numeroAnteriore);
                    this.tpmsPostCB.setSelectedIndex(numeroPosteriore);
                }
                if (st.hasMoreTokens()) {
                    campo = st.nextToken();
                    numero = Integer.valueOf(campo);
                    campo = st.nextToken();
                    numero = Integer.valueOf(campo);
                    campo = st.nextToken();
                    numero = Integer.valueOf(campo);
                    if (numero == 1) {
                        this.hotON.setSelected(true);
                    } else {
                        this.hotOFF.setSelected(true);
                    }
                    campo = st.nextToken();
                    this.reteHot.setValue(this.getStringImportata(campo, 20));
                    campo = st.nextToken();
                    this.passwordHot.setValue(this.getStringImportata(campo, 20));
                }
                if (st.hasMoreTokens()) {
                    campo = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    campo = st.nextToken();
                    numero = Integer.valueOf(campo);
                    this.salvataggioCB.setSelectedIndex(numero);
                    campo = st.nextToken();
                    this.versioneSoftware.setText(campo);
                    campo = st.nextToken();
                    this.versioneFirmware.setText(campo);
                }
                if (st.hasMoreTokens()) {
                    campo = st.nextToken();
                    this.numeroSessioni.setText(campo);
                }
                if (st.hasMoreTokens()) {
                    campo = st.nextToken();
                    this.ultimaSessione.setText(campo);
                }
            }
            if (this.wifiOFF.isSelected()) {
                this.hotOFF.setSelected(true);
                this.hotON.setEnabled(false);
                this.hotOFF.setEnabled(false);
            } else {
                this.hotON.setEnabled(true);
                this.hotOFF.setEnabled(true);
            }
        }
        catch (Exception e) {
            this.salvataggioFallito = true;
            System.out.println("DEBUG: linea=" + line);
            e.printStackTrace();
        }
    }

    public void importaOpzioni(String Directorypath) {
        File f = new File(Directorypath, "opzioniSettings.cfg");
        if (!f.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) continue;
                StringTokenizer st = new StringTokenizer(line, "=");
                String campo = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String valore = st.nextToken();
                int numero = Integer.valueOf(valore);
                if (campo.startsWith("fuso")) {
                    this.fusoCB.setSelectedIndex(numero + 12);
                }
                if (!campo.startsWith("standByTime")) continue;
                this.standCB.setSelectedIndex(numero);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void importaOpzioniWifi(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, ",");
            String campo = st.nextToken();
            campo = st.nextToken();
            campo = st.nextToken();
            int numero = Integer.valueOf(campo);
            this.fusoCB.setSelectedIndex(numero + 12);
            campo = st.nextToken();
            campo = st.nextToken();
            numero = Integer.valueOf(campo);
            this.standCB.setSelectedIndex(numero);
        }
        catch (Exception e) {
            this.salvataggioFallito = true;
            e.printStackTrace();
        }
    }

    public void importaAcquisizione(String Directorypath) {
        File f = new File(Directorypath, "acquisitionSettings.cfg");
        if (!f.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) continue;
                StringTokenizer st = new StringTokenizer(line, "=");
                String campo = st.nextToken();
                if (st.hasMoreTokens()) {
                    int numero;
                    String valore = st.nextToken();
                    if (campo.startsWith("acquisitionFrequency")) {
                        numero = Integer.valueOf(valore);
                        this.setFrequencyCombo(numero);
                    }
                    if (campo.startsWith("autoStartCriteria")) {
                        numero = Integer.valueOf(valore);
                        this.canaleStartCB.setSelectedIndex(numero);
                    }
                    if (campo.startsWith("code_corrente_front")) {
                        numero = Integer.valueOf(valore);
                        this.tpmsAntCB.setSelectedIndex(numero);
                    }
                    if (campo.startsWith("code_corrente_rear")) {
                        numero = Integer.valueOf(valore);
                        this.tpmsPostCB.setSelectedIndex(numero);
                    }
                    if (campo.startsWith("tipoMemoria")) {
                        numero = Integer.valueOf(valore);
                        this.salvataggioCB.setSelectedIndex(numero);
                    }
                    if (campo.startsWith("hotspot")) {
                        numero = Integer.valueOf(valore);
                        if (numero == 1) {
                            this.hotON.setSelected(true);
                        } else {
                            this.hotOFF.setSelected(true);
                        }
                    }
                    if (campo.startsWith("wifiActive")) {
                        numero = Integer.valueOf(valore);
                        if (numero == 1) {
                            this.wifiON.setSelected(true);
                        } else {
                            this.wifiOFF.setSelected(true);
                        }
                    }
                    if (campo.startsWith("minSpeed")) {
                        numero = Integer.valueOf(valore);
                        this.velMinCB.setSelectedIndex((numero - 10) / 5);
                    }
                    if (campo.equals("nomeRete")) {
                        this.rete.setText(this.getStringImportata(valore, 20));
                    }
                    if (campo.startsWith("prefisso")) {
                        this.prefisso.setText(this.getStringImportata(valore, 10));
                    }
                    if (campo.equals("password")) {
                        this.password.setText(this.getStringImportata(valore, 20));
                    }
                    if (campo.startsWith("nomeReteHot")) {
                        this.reteHot.setText(this.getStringImportata(valore, 20));
                    }
                    if (campo.startsWith("passwordHot")) {
                        this.passwordHot.setText(this.getStringImportata(valore, 20));
                    }
                    if (campo.equals("id1Code")) {
                        if (valore.length() == 8 || valore.length() == 7) {
                            this.anterioreTF.setValue(valore);
                        } else {
                            this.anterioreTF.setValue("0000000");
                        }
                    }
                    if (campo.startsWith("id1Code_A")) {
                        this.idAnteriori[0] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (campo.startsWith("id1Code_B")) {
                        this.idAnteriori[1] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (campo.startsWith("id1Code_C")) {
                        this.idAnteriori[2] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (campo.startsWith("id1Code_D")) {
                        this.idAnteriori[3] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (campo.startsWith("id2Code_A")) {
                        this.idPosteriori[0] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (campo.startsWith("id2Code_B")) {
                        this.idPosteriori[1] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (campo.startsWith("id2Code_C")) {
                        this.idPosteriori[2] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (campo.startsWith("id2Code_D")) {
                        this.idPosteriori[3] = valore.length() == 8 || valore.length() == 7 ? valore : "0000000";
                    }
                    if (!campo.equals("id2Code")) continue;
                    if (valore.length() == 8 || valore.length() == 7) {
                        this.posterioreTF.setValue(valore);
                        continue;
                    }
                    this.posterioreTF.setValue("0000000");
                    continue;
                }
                if (campo.startsWith("nomeRete")) {
                    this.rete.setValue("  ");
                }
                if (campo.startsWith("password")) {
                    this.password.setValue(" ");
                }
                if (campo.startsWith("nomeReteHot")) {
                    this.reteHot.setValue("  ");
                }
                if (!campo.startsWith("passwordHot")) continue;
                this.passwordHot.setValue(" ");
            }
            if (this.wifiOFF.isSelected()) {
                this.hotOFF.setSelected(true);
                this.hotON.setEnabled(false);
                this.hotOFF.setEnabled(false);
            } else {
                this.hotON.setEnabled(true);
                this.hotOFF.setEnabled(true);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void verificaMarce() {
        if (this.elencoRigheCan.get(6).getTipo().equals("Ingresso Neutro")) {
            this.abilitaMarce(true);
        } else {
            this.abilitaMarce(false);
        }
        this.aggiornaCampi();
    }

    public void abilitaMarce(boolean abilita) {
        this.neutro0TF.setEnabled(abilita);
        this.neutro1TF.setEnabled(abilita);
        this.neutro2TF.setEnabled(abilita);
        this.neutro3TF.setEnabled(abilita);
        this.neutro4TF.setEnabled(abilita);
        this.neutro5TF.setEnabled(abilita);
        this.neutro6TF.setEnabled(abilita);
    }

    public void configuraSensoriAutomatico() {
        SensoriDialogDasyPro sensD = new SensoriDialogDasyPro(this, this.conn);
        sensD.setLocationRelativeTo(null);
        this.salvaValoriIngressiCorrenti(this.indiceAnalogicoPrecedente, this.indiceDigitalePrecedente);
        for (int i = 0; i < 8; ++i) {
            sensD.setMinAnalog(i + 1, this.valoriMinimiCanali[i]);
            sensD.setMaxAnalog(i + 1, this.valoriMassimiCanali[i]);
        }
        sensD.setVisible(true);
        if (sensD.getAnalogSet() != -1) {
            int analog = sensD.getAnalogSet();
            this.valoriMinimiCanali[analog] = sensD.getMinAnalog(analog + 1);
            this.valoriMassimiCanali[analog] = sensD.getMaxAnalog(analog + 1);
            this.aggiornaCampi();
        }
    }

    public void updateVisualizzazione() {
        float[] valoriGrezzi = this.getCanaliLetti();
        float segnaleAnt = (float)this.valoreRssiAnteriore / 2.0f - 130.0f;
        float segnalePost = (float)this.valoreRssiPosteriore / 2.0f - 130.0f;
        this.canaleRssiAnteriore.setText(String.format("%.0f dbm", Float.valueOf(segnaleAnt)));
        this.canaleRssiPosteriore.setText(String.format("%.0f dbm", Float.valueOf(segnalePost)));
        if (DanasDataStructure.getInstance().isPressioneBar()) {
            this.canaliRealTime[0].setText(String.format("%.2f bar", Float.valueOf(valoriGrezzi[0])));
            this.canaliRealTime[1].setText(String.format("%.2f bar", Float.valueOf(valoriGrezzi[1])));
        } else {
            this.canaliRealTime[0].setText(String.format("%.2f PSI", MeasuresUtil.getPressione(valoriGrezzi[0])));
            this.canaliRealTime[1].setText(String.format("%.2f PSI", MeasuresUtil.getPressione(valoriGrezzi[1])));
        }
        if (DanasDataStructure.getInstance().isTemperaturaCelsius()) {
            this.canaliRealTime[2].setText(String.format("%.2f C", Float.valueOf(valoriGrezzi[2])));
            this.canaliRealTime[3].setText(String.format("%.2f C", Float.valueOf(valoriGrezzi[3])));
        } else {
            this.canaliRealTime[2].setText(String.format("%.2f F", MeasuresUtil.getTemperatura(valoriGrezzi[2])));
            this.canaliRealTime[3].setText(String.format("%.2f F", MeasuresUtil.getTemperatura(valoriGrezzi[3])));
        }
        if (DanasDataStructure.getInstance().isVelocitakmh()) {
            this.canaliRealTime[4].setText(String.format("%.2f km/h", Float.valueOf(valoriGrezzi[4])));
            this.canaliRealTime[5].setText(String.format("%.2f km/h", Float.valueOf(valoriGrezzi[5])));
        } else {
            this.canaliRealTime[4].setText(String.format("%.2f mph", MeasuresUtil.getVelocita(valoriGrezzi[4])));
            this.canaliRealTime[5].setText(String.format("%.2f mph", MeasuresUtil.getVelocita(valoriGrezzi[5])));
        }
        this.canaliRealTime[6].setText(String.format("%.2f rpm", Float.valueOf(valoriGrezzi[6])));
        for (int i = 7; i < 154; ++i) {
            if (i > 18 && i < 26) {
                this.canaliRealTime[i].setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(i - 16, this.getTipoMoto(this.motoCB.getSelectedIndex()), valoriGrezzi[i])));
                continue;
            }
            int tipoMoto = this.getTipoMoto(this.motoCB.getSelectedIndex());
            if (i == 17 && (tipoMoto == 99 || tipoMoto == 71)) {
                this.canaliRealTime[i].setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(i - 16, this.getTipoMoto(this.motoCB.getSelectedIndex()), valoriGrezzi[i])));
                continue;
            }
            this.canaliRealTime[i].setText(String.format("%.2f", Float.valueOf(valoriGrezzi[i])));
        }
    }

    public void updateCanaliRicevuti(String fraseLetta) throws Exception {
        int numeroCanali = 0;
        int posizione = 0;
        if (fraseLetta.startsWith("$ON_TPMS")) {
            numeroCanali = 4;
            posizione = 0;
        }
        if (fraseLetta.startsWith("$ON_DIGI")) {
            numeroCanali = 3;
            posizione = 4;
        }
        if (fraseLetta.startsWith("$ON_ANAL")) {
            numeroCanali = 8;
            posizione = 8;
        }
        if (fraseLetta.startsWith("$ON_MULTI")) {
            numeroCanali = 10;
            posizione = 16;
        }
        if (fraseLetta.startsWith("$ON_CAN1")) {
            numeroCanali = 20;
            posizione = 26;
        }
        if (fraseLetta.startsWith("$ON_CAN2")) {
            numeroCanali = 20;
            posizione = 46;
        }
        if (fraseLetta.startsWith("$ON_CAN3")) {
            numeroCanali = 20;
            posizione = 66;
        }
        if (fraseLetta.startsWith("$ON_CAN4")) {
            numeroCanali = 20;
            posizione = 86;
        }
        if (fraseLetta.startsWith("$ON_CAN5")) {
            numeroCanali = 20;
            posizione = 106;
        }
        if (fraseLetta.startsWith("$ON_CAN6")) {
            numeroCanali = 20;
            posizione = 126;
        }
        if (fraseLetta.startsWith("$ON_CAN7")) {
            numeroCanali = 20;
            posizione = 146;
        }
        if (fraseLetta.startsWith("$RSSI")) {
            this.updateCanaliRssi(fraseLetta);
            return;
        }
        if (numeroCanali == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(fraseLetta, ",");
        st.nextToken();
        for (int i = 0; i < numeroCanali; ++i) {
            if (!st.hasMoreTokens()) continue;
            String token = st.nextToken();
            if (posizione + i >= 154) continue;
            this.datiProvvisori[posizione + i] = Float.valueOf(token).floatValue();
        }
    }

    public void updateCanaliRssi(String fraseLetta) {
        String token;
        StringTokenizer st = new StringTokenizer(fraseLetta, ",");
        st.nextToken();
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            this.valoreRssiAnterioreProvvisorio = Integer.valueOf(token);
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            this.valoreRssiPosterioreProvvisorio = Integer.valueOf(token);
        }
    }

    public void scaricaContinuo() {
        String stringaLetta = null;
        while (this.getAcquisisciContinuo()) {
            try {
                for (int i = 0; i < 154; ++i) {
                    this.datiProvvisori[i] = 0.0f;
                }
                this.valoreRssiAnterioreProvvisorio = 0;
                this.valoreRssiPosterioreProvvisorio = 0;
                long inizio = System.currentTimeMillis();
                this.conn.writeVeloce("$ONLINE\r");
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                stringaLetta = this.conn.readLine();
                this.updateCanaliRicevuti(stringaLetta);
                this.updateCanaliLetti(this.datiProvvisori);
                long tempoEsecuzione = System.currentTimeMillis() - inizio;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DasyProSettingsDialog.this.updateVisualizzazione();
                    }
                });
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                this.disconnetti();
                break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void updateCanaliLetti(float[] nuoviDati) {
        for (int i = 0; i < 154; ++i) {
            this.datiLetti[i] = nuoviDati[i];
        }
        this.valoreRssiAnteriore = this.valoreRssiAnterioreProvvisorio;
        this.valoreRssiPosteriore = this.valoreRssiPosterioreProvvisorio;
    }

    public synchronized float[] getCanaliLetti() {
        float[] dati = new float[154];
        for (int i = 0; i < 154; ++i) {
            dati[i] = this.datiLetti[i];
        }
        return dati;
    }

    public synchronized void setAcquisisciContinuo(boolean attiva) {
        this.acquisizioneInCorso = attiva;
    }

    public synchronized boolean getAcquisisciContinuo() {
        return this.acquisizioneInCorso;
    }

    public void bloccaModalitaContinua() {
        this.setAcquisisciContinuo(false);
        try {
            if (this.continuousModeThread != null && Thread.currentThread() != this.continuousModeThread) {
                this.continuousModeThread.join();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.acquisisciB.setText(Language.string("Avvia lettura Online (USB)"));
        if (this.connected) {
            this.importaUsbB.setEnabled(true);
            this.esportaUsbB.setEnabled(true);
        }
    }

    private void aggiornaListaFile() {
        this.elencoFileLM.clear();
        this.elencoFileDati.removeAllElements();
        if (!this.connected) {
            return;
        }
        int occupazione = 0;
        try {
            String line;
            this.conn.write("$ListaFile\r");
            while ((line = this.conn.readLine()) != null && !line.startsWith("$FineLista")) {
                FileDati dato = new FileDati(line);
                occupazione += dato.getDimensione();
                System.out.println("linea file:" + line);
                this.elencoFileDati.addElement(dato);
                this.elencoFileLM.addElement(dato.getStringaTabella());
            }
            int percentuale = (int)((double)occupazione / 819200.0 * 100.0);
            this.progress.setValue(percentuale);
            if (line == null) {
                this.disconnetti();
            }
        }
        catch (IOException e1) {
            this.disconnetti();
        }
    }

    private void aggiornaSoftware() {
        if (!this.connected) {
            return;
        }
        String line = null;
        try {
            System.out.println("DEBUG: Pulisco seriale");
            this.conn.clear(100);
            System.out.println("DEBUG: Invio comando software update Datalog");
            this.conn.write("$UpdateSoftware\r");
            long tempoAttuale = System.currentTimeMillis();
            for (int i = 0; i < 20; ++i) {
                while (!((line = this.conn.readLine()) == null || line.startsWith("$ErroreChiavetta") || line.startsWith("$UpdateSoftwareSuperato") || line.startsWith("$ErroreUpdateSoftware"))) {
                    System.out.println("DEBUG: linea letta:" + line);
                }
                System.out.println("DEBUG: Frase ricevuta post software update:" + line + " t=" + (System.currentTimeMillis() - tempoAttuale));
                if (line != null) break;
            }
            if (line == null) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                this.disconnetti();
                return;
            }
            if (line.startsWith("$ErroreChiavetta")) {
                JOptionPane.showMessageDialog(this, Language.string("Impossibile accedere alla chiavetta USB"), "ERROR", 0);
            }
            if (line.startsWith("$ErroreUpdateSoftware")) {
                JOptionPane.showMessageDialog(this, Language.string("File non corretti, controllare la chiavetta."), "ERROR", 0);
            }
            if (line.startsWith("$UpdateSoftwareSuperato")) {
                JOptionPane.showMessageDialog(this, Language.string("Riavviare il DataLog-Pro per completare l'update"), "INFO", 1);
            }
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde: controllare la connessione"), Language.string("ATTENZIONE"), 0);
            this.disconnetti();
        }
    }

    private void azzeraSessioni() {
        if (!this.connected) {
            return;
        }
        try {
            String line;
            this.conn.write("$ResetSessioni\r");
            while ((line = this.conn.readLine()) != null && !line.startsWith("$NumeroAzzerato")) {
                System.out.println("DEBUG: linea letta:" + line);
            }
            if (line == null) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                this.disconnetti();
            }
            if (line.startsWith("$NumeroAzzerato")) {
                JOptionPane.showMessageDialog(this, Language.string("Numero Sessioni azzerato"), "INFO", 1);
                this.numeroSessioni.setText("1");
                this.ultimaSessione.setText("0");
            }
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
            this.disconnetti();
        }
    }

    private void cancellaFile(int[] index, boolean tutti) {
        if (tutti) {
            while (this.elencoFileLM.size() != 0) {
                String s = String.format("$CancellaFile,%d,\r", 0);
                try {
                    String line;
                    this.conn.write(s);
                    while ((line = this.conn.readLine()) != null && !line.startsWith("$FileCancellato")) {
                        System.out.println("linea file:" + line);
                    }
                    if (line == null) {
                        JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                        this.disconnetti();
                        return;
                    }
                    this.aggiornaListaFile();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                    this.disconnetti();
                    return;
                }
            }
            JOptionPane.showMessageDialog(this, Language.string("Files cancellati"), "INFO", 1);
        } else {
            int i;
            if (index.length == 0) {
                return;
            }
            String[] elencoFile = new String[index.length];
            for (i = 0; i < index.length; ++i) {
                elencoFile[i] = this.elencoFileDati.get(index[i]).getNome();
            }
            block7: for (i = 0; i < elencoFile.length; ++i) {
                for (int j = 0; j < this.elencoFileDati.size(); ++j) {
                    if (!this.elencoFileDati.get(j).getNome().equals(elencoFile[i])) continue;
                    String s = String.format("$CancellaFile,%d,\n", j);
                    try {
                        String line;
                        this.conn.write(s);
                        while ((line = this.conn.readLine()) != null && !line.startsWith("$FileCancellato")) {
                            System.out.println("Cancella USB:linea file:" + line);
                        }
                        if (line == null) {
                            JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                            this.disconnetti();
                            return;
                        }
                        this.aggiornaListaFile();
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                        this.disconnetti();
                    }
                    continue block7;
                }
            }
            JOptionPane.showMessageDialog(this, Language.string("File cancellati"), "INFO", 1);
        }
    }

    private void aggiornaFirmware() {
        this.gestoreDownloadThread = new Thread(){

            @Override
            public void run() {
                DasyProSettingsDialog.this.abilitaUsb(false);
                DasyProSettingsDialog.this.setPercentualeDownload(0);
                DasyProSettingsDialog.this.downloadMonitorThread = new Thread(){

                    @Override
                    public void run() {
                        DasyProSettingsDialog.this.monitorFirmware(null);
                    }
                };
                DasyProSettingsDialog.this.downloadMonitorThread.setDaemon(true);
                DasyProSettingsDialog.this.downloadMonitorThread.start();
                DasyProSettingsDialog.this.downloadThread = new Thread(){

                    @Override
                    public void run() {
                        DasyProSettingsDialog.this.avviaAggiornamentoFirmware();
                    }
                };
                DasyProSettingsDialog.this.downloadThread.setDaemon(true);
                DasyProSettingsDialog.this.downloadThread.start();
                try {
                    DasyProSettingsDialog.this.downloadThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (DasyProSettingsDialog.this.connected) {
                    DasyProSettingsDialog.this.abilitaUsb(true);
                }
                if (!DasyProSettingsDialog.this.getDownloadAnnullato()) {
                    JOptionPane.showMessageDialog(null, Language.string("Aggiornamento completato"), Language.string("INFO"), 1);
                }
            }
        };
        this.gestoreDownloadThread.setDaemon(true);
        this.gestoreDownloadThread.start();
    }

    private void downloadFile() {
        this.gestoreDownloadThread = new Thread(){

            @Override
            public void run() {
                DasyProSettingsDialog.this.abilitaUsb(false);
                int[] elencoIndici = DasyProSettingsDialog.this.listFile.getSelectedIndices();
                if (elencoIndici.length == 0) {
                    DasyProSettingsDialog.this.abilitaUsb(true);
                    return;
                }
                try {
                    System.out.println("DEBUG: invio comando monta chiavetta");
                    DasyProSettingsDialog.this.conn.setTimeOut(5000);
                    DasyProSettingsDialog.this.conn.clear(5000);
                    DasyProSettingsDialog.this.conn.write("$Monta\n");
                    String line = DasyProSettingsDialog.this.conn.readLine();
                    System.out.println("DEBUG: risposta al montaggio:" + line);
                    if (line == null) {
                        DasyProSettingsDialog.this.disconnetti();
                        JOptionPane.showMessageDialog(null, Language.string("Errore connessione"), "ERROR", 0);
                        return;
                    }
                    if (line.startsWith("$NO_CHIAVETTA")) {
                        JOptionPane.showMessageDialog(null, Language.string("ATTENZIONE: Impossibile accedere alla chiavetta USB"), "ERROR", 0);
                        DasyProSettingsDialog.this.abilitaUsb(true);
                        return;
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                JOptionPane.showMessageDialog(null, Language.string("Attendere il messaggio di fine download prima di disconnettere la USB."), Language.string("ATTENZIONE"), 1);
                for (int i = 0; i < elencoIndici.length; ++i) {
                    DasyProSettingsDialog.this.indiceFile = elencoIndici[i];
                    DasyProSettingsDialog.this.setPercentualeDownload(0);
                    DasyProSettingsDialog.this.downloadMonitorThread = new Thread(){

                        @Override
                        public void run() {
                            DasyProSettingsDialog.this.monitorDownload(DasyProSettingsDialog.this.elencoFileDati.get(DasyProSettingsDialog.this.indiceFile).getNome());
                        }
                    };
                    DasyProSettingsDialog.this.downloadMonitorThread.setDaemon(true);
                    DasyProSettingsDialog.this.downloadMonitorThread.start();
                    DasyProSettingsDialog.this.downloadThread = new Thread(){

                        @Override
                        public void run() {
                            DasyProSettingsDialog.this.eseguiDownload(DasyProSettingsDialog.this.indiceFile);
                        }
                    };
                    DasyProSettingsDialog.this.downloadThread.setDaemon(true);
                    DasyProSettingsDialog.this.downloadThread.start();
                    try {
                        System.out.println("DEBUG join thread indice:" + DasyProSettingsDialog.this.indiceFile);
                        DasyProSettingsDialog.this.downloadThread.join();
                        DasyProSettingsDialog.this.mon.close();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (DasyProSettingsDialog.this.getDownloadAnnullato()) break;
                }
                try {
                    System.out.println("DEBUG: invio comando Smonta chiavetta");
                    DasyProSettingsDialog.this.conn.write("$Smonta\n");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (DasyProSettingsDialog.this.connected) {
                    DasyProSettingsDialog.this.abilitaUsb(true);
                }
                if (DasyProSettingsDialog.this.mon != null) {
                    DasyProSettingsDialog.this.mon.close();
                }
                if (!DasyProSettingsDialog.this.getDownloadAnnullato()) {
                    JOptionPane.showMessageDialog(null, Language.string("File copiati correttamente"), Language.string("INFO"), 1);
                }
            }
        };
        this.gestoreDownloadThread.setDaemon(true);
        this.gestoreDownloadThread.start();
    }

    private void avviaAggiornamentoFirmware() {
        this.setDownloadAnnullato(false);
        String s = String.format("$UpdateFirmware\n", new Object[0]);
        try {
            String line;
            this.conn.write(s);
            this.conn.setTimeOut(10000);
            while (!((line = this.conn.readLine()) == null || line.startsWith("$ErroreUpdateFirmware") || line.startsWith("$ErroreChiavetta") || line.startsWith("$UpdateConcluso"))) {
                if (!line.startsWith("$Perc")) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                st.nextToken();
                String campo = st.nextToken();
                this.setPercentualeDownload(Integer.valueOf(campo));
            }
            if (line == null) {
                this.disconnetti();
                if (!this.getDownloadAnnullato()) {
                    JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                }
                this.setDownloadAnnullato(true);
            } else {
                if (line.startsWith("$ErroreChiavetta")) {
                    JOptionPane.showMessageDialog(this, Language.string("ATTENZIONE: Impossibile accedere alla chiavetta USB"), "ERROR", 0);
                    this.setDownloadAnnullato(true);
                }
                if (line.startsWith("$ErroreUpdateFirmware")) {
                    JOptionPane.showMessageDialog(this, Language.string("ATTENZIONE: File non corretti, controllare la chiavetta."), "ERROR", 0);
                    this.setDownloadAnnullato(true);
                }
                if (line.startsWith("$UpdateConcluso")) {
                    JOptionPane.showMessageDialog(this, Language.string("Aggiornamento firmware completato"), "INFO", 1);
                    this.setDownloadAnnullato(true);
                }
            }
            this.downloadThread = null;
            this.setPercentualeDownload(100);
        }
        catch (Exception e1) {
            this.disconnetti();
            if (!this.getDownloadAnnullato()) {
                JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
            }
            this.setDownloadAnnullato(true);
        }
        this.conn.setTimeOut(1000);
        this.setPercentualeDownload(100);
    }

    private void eseguiDownload(int indice) {
        this.setDownloadAnnullato(false);
        String s = String.format("$DownloadFileLogger,%d,\n", indice);
        System.out.println("DEBUG: eseguo download indice:" + indice);
        this.setPercentualeDownload(0);
        try {
            String line;
            this.conn.setTimeOut(50000);
            this.conn.write(s);
            while ((line = this.conn.readLine()) != null && !line.startsWith("$File copiato") && !line.startsWith("$NO_CHIAVETTA")) {
                if (!line.startsWith("$Perc")) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                st.nextToken();
                String campo = st.nextToken();
                this.setPercentualeDownload(Integer.valueOf(campo));
            }
            if (line == null) {
                this.disconnetti();
                if (!this.getDownloadAnnullato()) {
                    JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                }
                this.setDownloadAnnullato(true);
            } else {
                if (line.startsWith("$NO_CHIAVETTA")) {
                    JOptionPane.showMessageDialog(this, Language.string("ATTENZIONE: chiavetta non collegata"), "ERROR", 0);
                    this.setDownloadAnnullato(true);
                }
                if (line.startsWith("$File copiato")) {
                    System.out.println("DEBUG: file copiato indice:" + indice);
                }
            }
            this.downloadThread = null;
            this.setPercentualeDownload(100);
        }
        catch (Exception e1) {
            this.disconnetti();
            if (!this.getDownloadAnnullato()) {
                JOptionPane.showMessageDialog(this, Language.string("Errore connessione download"), "ERROR", 0);
            }
            this.setDownloadAnnullato(true);
        }
        this.setPercentualeDownload(100);
        this.conn.setTimeOut(1000);
    }

    private void monitorDownload(String nomeFile) {
        this.setEnabled(false);
        this.mon = new ProgressMonitor(this, Language.string("Download in corso: ") + nomeFile, "", 0, 100);
        while (this.getPercentualeDownload() < 100) {
            if (this.mon.isCanceled()) {
                JOptionPane.showMessageDialog(this, Language.string("Attendere completamento download corrente"), "INFO", 1);
                this.mon = new ProgressMonitor(this, Language.string("Download in corso: ") + nomeFile, "", 0, 100);
                this.setDownloadAnnullato(true);
            }
            this.mon.setProgress(this.getPercentualeDownload());
            this.mon.setNote(Language.string("Completato: ") + this.getPercentualeDownload() + "%");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.mon.close();
        this.setEnabled(true);
        this.requestFocus();
        this.downloadMonitorThread = null;
    }

    private void monitorFirmware(String nomeFile) {
        this.setEnabled(false);
        ProgressMonitor mon = new ProgressMonitor(this, Language.string("Update firmware DataLog Pro in corso..."), "", 0, 100);
        while (this.getPercentualeDownload() < 100) {
            if (mon.isCanceled()) {
                JOptionPane.showMessageDialog(this, Language.string("Attendere completamento upload"), "INFO", 1);
                mon = new ProgressMonitor(this, Language.string("Update firmware DataLog Pro in corso..."), "", 0, 100);
                this.setDownloadAnnullato(true);
            }
            mon.setProgress(this.getPercentualeDownload());
            mon.setNote(Language.string("Completato: ") + this.getPercentualeDownload() + "%");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        mon.close();
        this.setEnabled(true);
        this.requestFocus();
        this.downloadMonitorThread = null;
    }

    public synchronized boolean getDownloadAnnullato() {
        return this.downloadAnnullato;
    }

    public synchronized void setDownloadAnnullato(boolean annullato) {
        this.downloadAnnullato = annullato;
    }

    public synchronized int getPercentualeDownload() {
        return this.percentualeDownload;
    }

    public synchronized void setPercentualeDownload(int percentuale) {
        this.percentualeDownload = percentuale;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int res;
        int i;
        int resultSovrascrivo;
        if (e.getSource().equals(this.listaB)) {
            this.aggiornaListaFile();
        }
        if (e.getSource().equals(this.softwareB)) {
            this.aggiornaSoftware();
        }
        if (e.getSource().equals(this.resetSessionB)) {
            this.azzeraSessioni();
        }
        if (e.getSource().equals(this.acquisisciB)) {
            if (!this.getAcquisisciContinuo()) {
                if (this.primaConfigurazione || this.getValoriCambiati()) {
                    JOptionPane.showMessageDialog(this, Language.string("I parametri di configurazione potrebbero essere diversi da quelli presenti nel DataLog. Aggiornarli."), Language.string("ATTENZIONE"), 1);
                }
                this.setAcquisisciContinuo(true);
                this.importaUsbB.setEnabled(false);
                this.esportaUsbB.setEnabled(false);
                this.acquisisciB.setText(Language.string("Stop lettura Online (USB)"));
                this.continuousModeThread = new Thread(){

                    @Override
                    public void run() {
                        DasyProSettingsDialog.this.scaricaContinuo();
                    }
                };
                this.continuousModeThread.setDaemon(true);
                this.continuousModeThread.start();
            } else {
                this.bloccaModalitaContinua();
            }
        }
        if (e.getSource().equals(this.cancellaB)) {
            if (this.listFile.getSelectedIndex() == -1) {
                return;
            }
            resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Cancellare i file selezionati?"), Language.string("ATTENZIONE"), 0);
            if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                return;
            }
            this.cancellaFile(this.listFile.getSelectedIndices(), false);
        }
        if (e.getSource().equals(this.cancellaTuttiB)) {
            if (this.elencoFileLM.isEmpty()) {
                return;
            }
            resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Cancellare tutti i file?"), Language.string("ATTENZIONE"), 0);
            if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                return;
            }
            this.cancellaFile(this.listFile.getSelectedIndices(), true);
        }
        if (e.getSource().equals(this.scaricaB)) {
            if (this.listFile.getSelectedIndex() == -1) {
                return;
            }
            this.downloadFile();
        }
        if (e.getSource().equals(this.firmwareB)) {
            this.aggiornaFirmware();
        }
        if (e.getSource().equals(this.connettiB)) {
            if (this.connected) {
                this.disconnetti();
            } else {
                this.connetti();
            }
        }
        if (e.getSource() == this.sensoriButton) {
            this.configuraSensoriAutomatico();
        }
        if (e.getSource().equals(this.motoCB)) {
            int n = this.motoCB.getSelectedIndex();
            if (!this.ripristinoInCorso) {
                System.out.println("DEBUG: moto selezionata  =" + n);
                this.motoCB.setSelectedIndex(n);
            }
            int tipoMoto = this.getTipoMoto(this.motoCB.getSelectedIndex());
            if (this.isMotoMarcieCan()) {
                this.primaTF.setEnabled(false);
                this.secondaTF.setEnabled(false);
                this.terzaTF.setEnabled(false);
                this.quartaTF.setEnabled(false);
                this.quintaTF.setEnabled(false);
                this.sestaTF.setEnabled(false);
            } else {
                this.primaTF.setEnabled(true);
                this.secondaTF.setEnabled(true);
                this.terzaTF.setEnabled(true);
                this.quartaTF.setEnabled(true);
                this.quintaTF.setEnabled(true);
                this.sestaTF.setEnabled(true);
            }
            if (!this.ripristinoInCorso) {
                this.caricaSettaggio(this.getTipoMotoConfigurazione(this.motoCB.getSelectedIndex()));
                this.aggiornaCampi();
            }
        }
        if (e.getSource().equals(this.wifiON) || e.getSource().equals(this.wifiOFF)) {
            if (this.wifiOFF.isSelected()) {
                this.hotOFF.setSelected(true);
                this.hotON.setEnabled(false);
                this.hotOFF.setEnabled(false);
            } else {
                this.hotON.setEnabled(true);
                this.hotOFF.setEnabled(true);
            }
        }
        if (e.getSource().equals(this.configuraCanB)) {
            this.canDialog.setLocationRelativeTo(this);
            this.elencoRigheCan.get(0).setFrequenza(this.getFrequencyCombo());
            this.elencoRigheCan.get(1).setFrequenza(this.getFrequencyCombo());
            this.elencoRigheCan.get(2).setFrequenza(this.getFrequencyCombo());
            this.canDialog.ricaricaTutto();
            this.canDialog.setVisible(true);
        }
        if (e.getSource().equals(this.canaleAnalogicoCB)) {
            this.salvaValoriIngressiCorrenti(this.indiceAnalogicoPrecedente, this.indiceDigitalePrecedente);
            this.indiceAnalogicoPrecedente = this.canaleAnalogicoCB.getSelectedIndex();
            this.aggiornaCampi();
        }
        if (e.getSource().equals(this.tpmsAntCB)) {
            if (this.aggiornamentoTpms) {
                return;
            }
            this.salvaValoriTPMS(this.indiceAnteriorePrecedente, this.indicePosteriorePrecedente);
            this.indiceAnteriorePrecedente = this.tpmsAntCB.getSelectedIndex();
            this.aggiornaCampi();
        }
        if (e.getSource().equals(this.tpmsPostCB)) {
            if (this.aggiornamentoTpms) {
                return;
            }
            this.salvaValoriTPMS(this.indiceAnteriorePrecedente, this.indicePosteriorePrecedente);
            this.indicePosteriorePrecedente = this.tpmsPostCB.getSelectedIndex();
            this.aggiornaCampi();
        }
        if (e.getSource().equals(this.canaleDigitaleCB)) {
            this.salvaValoriIngressiCorrenti(this.indiceAnalogicoPrecedente, this.indiceDigitalePrecedente);
            this.indiceDigitalePrecedente = this.canaleDigitaleCB.getSelectedIndex();
            this.aggiornaCampi();
        }
        if (e.getSource().equals(this.ripristinaB)) {
            resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Confermi il ripristino alle condizioni di fabbrica?"), Language.string("ATTENZIONE"), 0);
            if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                return;
            }
            this.cancellaContatori = true;
            this.ripristinaFabbrica();
            this.aggiornaCampi();
            this.frasiNonUtilizzate.removeAllElements();
        }
        if (e.getSource().equals(this.riceviWifiB)) {
            if (!DanasDataStructure.getInstance().getMainFrame().isWifiOpen()) {
                JOptionPane.showMessageDialog(this, Language.string("Impossibile trasmettere: finestra download wifi chiusa"), Language.string("ATTENZIONE"), 0);
                return;
            }
            if (!DanasDataStructure.getInstance().getMainFrame().getWifiDialog().isConnesso()) {
                JOptionPane.showMessageDialog(this, Language.string("Impossibile trasmettere: nessun DataLog-Pro attualmente connesso"), Language.string("ATTENZIONE"), 0);
                return;
            }
            this.salvataggioFallito = false;
            this.frasiNonUtilizzate.removeAllElements();
            WifiDialog wifi = DanasDataStructure.getInstance().getMainFrame().getWifiDialog();
            Vector<Object> settaggiRicevuti = new Vector();
            this.setCursor(Cursor.getPredefinedCursor(3));
            settaggiRicevuti = wifi.riceviSettaggi();
            if (settaggiRicevuti.size() == 0) {
                this.salvataggioFallito = true;
            }
            this.importazioneInCorso = true;
            for (i = 0; i < settaggiRicevuti.size(); ++i) {
                if (((String)settaggiRicevuti.get(i)).startsWith("OptionWifiSettings")) {
                    this.importaOpzioniWifi((String)settaggiRicevuti.get(i));
                }
                if (((String)settaggiRicevuti.get(i)).startsWith("AcquisitionWifiSettings")) {
                    this.importaAcquisizioniWifi((String)settaggiRicevuti.get(i));
                }
                if (((String)settaggiRicevuti.get(i)).startsWith("ConversionWifiSettings")) {
                    this.importaConversionWifi((String)settaggiRicevuti.get(i));
                }
                if (!((String)settaggiRicevuti.get(i)).startsWith("CanWifiSettings")) continue;
                this.importaCanWifi((String)settaggiRicevuti.get(i));
            }
            this.aggiornaCampi();
            this.importazioneInCorso = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.salvataggioFallito) {
                JOptionPane.showMessageDialog(this, Language.string("Ricezione non riuscita completamente"), Language.string("ATTENZIONE"), 0);
            } else {
                JOptionPane.showMessageDialog(this, Language.string("Ricezione completata"), Language.string("INFO"), 1);
                this.consolidaValoriAttuali(true);
            }
            this.verificaMarce();
        }
        if (e.getSource().equals(this.trasmettiWifiB)) {
            this.salvaValoriIngressiCorrenti(this.indiceAnalogicoPrecedente, this.indiceDigitalePrecedente);
            this.salvaValoriTPMS(this.indiceAnteriorePrecedente, this.indicePosteriorePrecedente);
            if (!this.controllaStringhe()) {
                return;
            }
            if (!this.controllaValori()) {
                return;
            }
            if (!DanasDataStructure.getInstance().getMainFrame().isWifiOpen()) {
                JOptionPane.showMessageDialog(this, Language.string("Impossibile trasmettere: finestra download wifi chiusa"), Language.string("ATTENZIONE"), 0);
                return;
            }
            if (!DanasDataStructure.getInstance().getMainFrame().getWifiDialog().isConnesso()) {
                JOptionPane.showMessageDialog(this, Language.string("Impossibile trasmettere: nessun DataLog-Pro attualmente connesso"), Language.string("ATTENZIONE"), 0);
                return;
            }
            int resultSovrascrivo2 = JOptionPane.showConfirmDialog(this, Language.string("I settaggi del logger verrano sovrascritti. Procedere?"), Language.string("ATTENZIONE"), 0);
            if (resultSovrascrivo2 == -1 || resultSovrascrivo2 == 1) {
                return;
            }
            this.salvataggioFallito = false;
            WifiDialog wifi = DanasDataStructure.getInstance().getMainFrame().getWifiDialog();
            this.setCursor(Cursor.getPredefinedCursor(3));
            wifi.inviaFrase(this.saveOpzioniFile(null, true));
            wifi.inviaFrase(this.saveAcquisitionFile(null, true));
            wifi.inviaFrase(this.saveConversionFile(null, true));
            for (i = 0; i < 136; ++i) {
                wifi.inviaFrase("CanWifiSettings," + i + "," + this.getRiassuntoCanale(i) + "\r");
            }
            String marce = "MarceWifiSettings," + this.neutro0TF.getValue() + "," + this.neutro1TF.getValue() + "," + this.neutro2TF.getValue() + "," + this.neutro3TF.getValue() + "," + this.neutro4TF.getValue() + "," + this.neutro5TF.getValue() + "," + this.neutro6TF.getValue() + ",";
            wifi.inviaFrase(marce + "\r");
            res = wifi.richiediConfermaRicezione() ? 1 : 0;
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.salvataggioFallito || res == 0) {
                JOptionPane.showMessageDialog(this, Language.string("Invio non riuscito completamente"), Language.string("ATTENZIONE"), 0);
            } else {
                JOptionPane.showMessageDialog(this, Language.string("Invio completato"), Language.string("INFO"), 1);
                this.consolidaValoriAttuali(true);
            }
        }
        if (e.getSource().equals(this.defaultInputB)) {
            if (DanasDataStructure.getInstance().getDefaultSession() == null) {
                return;
            }
            for (int i2 = 0; i2 < 12; ++i2) {
                this.nomeCanali[i2] = this.getStringImportata(DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNomeAnalogici(i2 + 1), 10);
                this.valoriMinimiCanali[i2] = DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getMinimo(DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getValueAnalogico(i2 + 1));
                this.valoriMassimiCanali[i2] = DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getMassimo(DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getValueAnalogico(i2 + 1));
            }
            this.aggiornaCampi();
        }
        if (e.getSource().equals(this.configuraSensoriB)) {
            ParametriciDialog param = new ParametriciDialog(null, this);
            param.aggiornaSensori(this.sensoreA, this.sensoreB, this.sensoreC, this.numeroA, this.numeroB, this.numeroC);
            param.setLocationRelativeTo(null);
            param.setVisible(true);
        }
        if (e.getSource().equals(this.importaUsbB)) {
            if (!this.connected) {
                return;
            }
            this.riceviUsb();
        }
        if (e.getSource().equals(this.esportaUsbB)) {
            if (!this.connected) {
                return;
            }
            this.trasmettiUsb();
        }
        if (e.getSource().equals(this.importaB)) {
            this.cancellaContatori = false;
            boolean importazioneIncompleta = false;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            String s = DanasPreferences.getPrefDirectory("settingsdirectory");
            if (s != null) {
                fileChooser.setCurrentDirectory(new File(s));
            }
            if ((res = fileChooser.showOpenDialog(this)) == 0) {
                DanasPreferences.setPrefDirectory("settingsdirectory", fileChooser.getCurrentDirectory().toString());
                this.frasiNonUtilizzate.removeAllElements();
                this.importazioneInCorso = true;
                File f2 = new File(fileChooser.getSelectedFile().toString(), "conversionSettings.cfg");
                File f4 = new File(fileChooser.getSelectedFile().toString(), "acquisitionSettings.cfg");
                if (!f2.exists() || !f4.exists()) {
                    JOptionPane.showMessageDialog(this, Language.string("La cartella non contiene tutti i settaggi"), Language.string("ATTENZIONE"), 0);
                    importazioneIncompleta = true;
                }
                this.importaOpzioni(fileChooser.getSelectedFile().toString());
                this.importaConversion(fileChooser.getSelectedFile().toString());
                this.importaAcquisizione(fileChooser.getSelectedFile().toString());
                this.importaCanSettings(fileChooser.getSelectedFile().toString());
                this.aggiornaCampi();
                this.importazioneInCorso = false;
                if (importazioneIncompleta) {
                    JOptionPane.showMessageDialog(this, Language.string("Importazione NON completa"), Language.string("INFO"), 1);
                } else {
                    JOptionPane.showMessageDialog(this, Language.string("Importazione completata"), Language.string("INFO"), 1);
                }
            }
            this.verificaMarce();
        }
        if (e.getSource().equals(this.esportaB)) {
            int res2;
            this.salvataggioFallito = false;
            this.salvaValoriIngressiCorrenti(this.indiceAnalogicoPrecedente, this.indiceDigitalePrecedente);
            this.salvaValoriTPMS(this.indiceAnteriorePrecedente, this.indicePosteriorePrecedente);
            if (!this.controllaStringhe()) {
                return;
            }
            if (!this.controllaValori()) {
                return;
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            String s = DanasPreferences.getPrefDirectory("settingsdirectory");
            if (s != null) {
                fileChooser.setCurrentDirectory(new File(s));
            }
            if ((res2 = fileChooser.showSaveDialog(this)) == 0) {
                int resultSovrascrivo3;
                DanasPreferences.setPrefDirectory("settingsdirectory", fileChooser.getCurrentDirectory().toString());
                File f = new File(fileChooser.getSelectedFile().toString(), "acquisitionSettings.cfg");
                if (!f.isAbsolute()) {
                    f = new File(f.getAbsolutePath());
                }
                if (f.exists() && f.canWrite() && ((resultSovrascrivo3 = JOptionPane.showConfirmDialog(this, Language.string("Sovrascrivere i file esistenti?"), Language.string("ATTENZIONE"), 0)) == -1 || resultSovrascrivo3 == 1)) {
                    return;
                }
                if (!(!f.exists() && f.getParentFile().exists() && f.getParentFile().isDirectory() && f.getParentFile().canWrite() || f.exists() && f.canWrite())) {
                    JOptionPane.showMessageDialog(this, Language.string("I file non possono essere scritti"), Language.string("ATTENZIONE"), 0);
                    return;
                }
                this.saveOpzioniFile(fileChooser.getSelectedFile().toString(), false);
                this.saveAcquisitionFile(fileChooser.getSelectedFile().toString(), false);
                this.saveConversionFile(fileChooser.getSelectedFile().toString(), false);
                this.saveCanFile(fileChooser.getSelectedFile().toString(), false);
                if (this.salvataggioFallito) {
                    JOptionPane.showMessageDialog(this, Language.string("Salvataggio non riuscito completamente"), Language.string("ATTENZIONE"), 0);
                } else {
                    JOptionPane.showMessageDialog(this, Language.string("Esportazione completata"), Language.string("INFO"), 1);
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.tabbedPane)) {
            this.salvaValoriIngressiCorrenti(this.indiceAnalogicoPrecedente, this.indiceDigitalePrecedente);
            this.salvaValoriTPMS(this.indiceAnteriorePrecedente, this.indicePosteriorePrecedente);
            this.aggiornaCampi();
            if (this.getAcquisisciContinuo()) {
                this.bloccaModalitaContinua();
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] portNames = SerialConnection.getAvailablePorts().toArray(new String[0]);
        DasyProSettingsDialog test = new DasyProSettingsDialog(null, portNames);
        test.setLocationRelativeTo(null);
        test.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connected) {
            this.disconnetti();
        }
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }
}

