/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DanasPreferences;
import i2m.Language;
import i2m.onLine.DeviceConnection;
import i2m.onLine.UnknownPortException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DaeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    String portName;
    JButton connettiB;
    JButton leggiB;
    JButton applicaB;
    JButton esciB;
    JTextField pinRpmTF;
    JTextField pinVelTF;
    JTextField pinAnalogTF;
    JTextField massaTF;
    JTextField cinqueTF;
    JFormattedTextField impulsiRpmTF;
    JFormattedTextField impulsiVel1TF;
    JFormattedTextField impulsiVel2TF;
    JComboBox rpmCB;
    JComboBox velCB;
    JComboBox analogCB;
    Integer[] analogList = new Integer[]{3, 4};
    JRadioButton bottone5Hz;
    JRadioButton bottone10Hz;
    private DeviceConnection conn;
    Frame padre;

    public DaeDialog(Frame owner, String portname) throws UnknownPortException {
        super(owner, Language.string("Configurazione DAE"), true);
        this.portName = portname;
        this.costruisciInterfaccia();
        this.pack();
        this.setResizable(false);
        this.setSize(new Dimension(375, 620));
        this.setConnected(false);
        this.conn = new DeviceConnection(this.portName);
        this.padre = owner;
    }

    public void costruisciInterfaccia() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.connettiB = new JButton(Language.string("Connetti"));
        this.connettiB.addActionListener(this);
        this.leggiB = new JButton(Language.string("Leggi"));
        this.leggiB.addActionListener(this);
        this.applicaB = new JButton(Language.string("Applica"));
        this.applicaB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.connettiB);
        pannelloBottoni.add(this.leggiB);
        pannelloBottoni.add(this.applicaB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
        JPanel pannelloCampionamento = new JPanel();
        pannelloCampionamento.setLayout(new BoxLayout(pannelloCampionamento, 0));
        JPanel pannelloImpulsiRpm = new JPanel();
        pannelloImpulsiRpm.setLayout(new BoxLayout(pannelloImpulsiRpm, 0));
        JPanel pannelloImpulsiVel1 = new JPanel();
        pannelloImpulsiVel1.setLayout(new BoxLayout(pannelloImpulsiVel1, 0));
        JPanel pannelloImpulsiVel2 = new JPanel();
        pannelloImpulsiVel2.setLayout(new BoxLayout(pannelloImpulsiVel2, 0));
        JPanel pannelloRpm = new JPanel();
        pannelloRpm.setLayout(new BoxLayout(pannelloRpm, 0));
        JPanel pannelloVelocita = new JPanel();
        pannelloVelocita.setLayout(new BoxLayout(pannelloVelocita, 0));
        JPanel pannelloAnalog = new JPanel();
        pannelloAnalog.setLayout(new BoxLayout(pannelloAnalog, 0));
        JPanel pannelloMassa = new JPanel();
        pannelloMassa.setLayout(new BoxLayout(pannelloMassa, 0));
        JPanel pannello5V = new JPanel();
        pannello5V.setLayout(new BoxLayout(pannello5V, 0));
        JPanel pannelloTesto = new JPanel();
        pannelloTesto.setLayout(new BoxLayout(pannelloTesto, 0));
        JLabel label = new JLabel(Language.string("Frequenza campionamento :"));
        this.bottone5Hz = new JRadioButton("5Hz");
        this.bottone10Hz = new JRadioButton("10Hz");
        ButtonGroup group = new ButtonGroup();
        group.add(this.bottone5Hz);
        group.add(this.bottone10Hz);
        this.bottone5Hz.setSelected(true);
        pannelloCampionamento.add(label);
        pannelloCampionamento.add(Box.createRigidArea(new Dimension(45, 0)));
        pannelloCampionamento.add(this.bottone5Hz);
        pannelloCampionamento.add(Box.createRigidArea(new Dimension(10, 0)));
        pannelloCampionamento.add(this.bottone10Hz);
        Integer[] rpmList = new Integer[]{0, 1};
        this.rpmCB = new JComboBox<Integer>(rpmList);
        this.rpmCB.setSelectedIndex(0);
        this.rpmCB.setMaximumSize(new Dimension(60, 20));
        this.rpmCB.addActionListener(this);
        JLabel rpmLabel = new JLabel(Language.string("Numero ingressi RPM :     "));
        rpmLabel.setLabelFor(this.rpmCB);
        JLabel pinRpmLabel = new JLabel("pin N\u00b0 : ");
        this.pinRpmTF = new JTextField();
        this.pinRpmTF.setHorizontalAlignment(11);
        this.pinRpmTF.setText("--");
        this.pinRpmTF.setEditable(false);
        this.pinRpmTF.setMaximumSize(new Dimension(60, 20));
        rpmLabel.setLabelFor(this.pinRpmTF);
        pannelloRpm.add(rpmLabel);
        pannelloRpm.add(this.rpmCB);
        pannelloRpm.add(Box.createRigidArea(new Dimension(10, 0)));
        pannelloRpm.add(pinRpmLabel);
        pannelloRpm.add(this.pinRpmTF);
        NumberFormat KmFormat = NumberFormat.getNumberInstance(Locale.US);
        KmFormat.setMaximumIntegerDigits(2);
        KmFormat.setMaximumFractionDigits(0);
        KmFormat.setGroupingUsed(false);
        this.impulsiRpmTF = new JFormattedTextField(KmFormat);
        this.impulsiRpmTF.setHorizontalAlignment(11);
        this.impulsiRpmTF.setMaximumSize(new Dimension(70, 20));
        JLabel impulsiRpmLabel = new JLabel(Language.string("Numero impulsi per RPM :      "));
        rpmLabel.setLabelFor(this.impulsiRpmTF);
        pannelloImpulsiRpm.add(impulsiRpmLabel);
        pannelloImpulsiRpm.add(this.impulsiRpmTF);
        pannelloImpulsiRpm.add(Box.createRigidArea(new Dimension(80, 0)));
        long l = 1L;
        this.impulsiRpmTF.setValue(l);
        this.impulsiVel1TF = new JFormattedTextField(KmFormat);
        this.impulsiVel1TF.setHorizontalAlignment(11);
        this.impulsiVel1TF.setMaximumSize(new Dimension(70, 20));
        JLabel impulsiVel1Label = new JLabel(Language.string("Numero impulsi per Vel1 :      "));
        impulsiVel1Label.setLabelFor(this.impulsiVel1TF);
        pannelloImpulsiVel1.add(impulsiVel1Label);
        pannelloImpulsiVel1.add(this.impulsiVel1TF);
        pannelloImpulsiVel1.add(Box.createRigidArea(new Dimension(80, 0)));
        this.impulsiVel1TF.setValue(l);
        this.impulsiVel2TF = new JFormattedTextField(KmFormat);
        this.impulsiVel2TF.setHorizontalAlignment(11);
        this.impulsiVel2TF.setMaximumSize(new Dimension(70, 20));
        JLabel impulsiVel2Label = new JLabel(Language.string("Numero impulsi per Vel2 :      "));
        impulsiVel2Label.setLabelFor(this.impulsiVel2TF);
        pannelloImpulsiVel2.add(impulsiVel2Label);
        pannelloImpulsiVel2.add(this.impulsiVel2TF);
        pannelloImpulsiVel2.add(Box.createRigidArea(new Dimension(80, 0)));
        this.impulsiVel2TF.setValue(l);
        Integer[] velList = new Integer[]{0, 1, 2};
        this.velCB = new JComboBox<Integer>(velList);
        this.velCB.setSelectedIndex(0);
        this.velCB.setMaximumSize(new Dimension(60, 20));
        this.velCB.addActionListener(this);
        JLabel velLabel = new JLabel(Language.string("Numero ingressi Vel :        "));
        velLabel.setLabelFor(this.velCB);
        JLabel pinVelLabel = new JLabel("pin N\u00b0 : ");
        this.pinVelTF = new JTextField();
        this.pinVelTF.setHorizontalAlignment(11);
        this.pinVelTF.setText("--");
        this.pinVelTF.setEditable(false);
        this.pinVelTF.setMaximumSize(new Dimension(60, 20));
        rpmLabel.setLabelFor(this.pinRpmTF);
        pannelloVelocita.add(velLabel);
        pannelloVelocita.add(this.velCB);
        pannelloVelocita.add(Box.createRigidArea(new Dimension(10, 0)));
        pannelloVelocita.add(pinVelLabel);
        pannelloVelocita.add(this.pinVelTF);
        this.analogCB = new JComboBox<Integer>(this.analogList);
        this.analogCB.setSelectedIndex(1);
        this.analogCB.setMaximumSize(new Dimension(60, 20));
        this.analogCB.addActionListener(this);
        JLabel analogLabel = new JLabel(Language.string("Numero ingressi Analog : "));
        analogLabel.setLabelFor(this.analogCB);
        JLabel pinAnalogLabel = new JLabel("pin N\u00b0 : ");
        this.pinAnalogTF = new JTextField();
        this.pinAnalogTF.setHorizontalAlignment(11);
        this.pinAnalogTF.setEditable(false);
        this.pinAnalogTF.setText("2,3,4 e 5");
        this.pinAnalogTF.setMaximumSize(new Dimension(60, 20));
        pinAnalogLabel.setLabelFor(this.pinAnalogTF);
        pannelloAnalog.add(analogLabel);
        pannelloAnalog.add(this.analogCB);
        pannelloAnalog.add(Box.createRigidArea(new Dimension(10, 0)));
        pannelloAnalog.add(pinAnalogLabel);
        pannelloAnalog.add(this.pinAnalogTF);
        JLabel massaLabel = new JLabel(Language.string("Uscita collegamento di massa, pin: "));
        this.massaTF = new JTextField();
        this.massaTF.setHorizontalAlignment(11);
        this.massaTF.setText("1");
        this.massaTF.setEditable(false);
        this.massaTF.setMaximumSize(new Dimension(60, 20));
        massaLabel.setLabelFor(this.massaTF);
        pannelloMassa.add(massaLabel);
        pannelloMassa.add(Box.createRigidArea(new Dimension(58, 0)));
        pannelloMassa.add(this.massaTF);
        JLabel cinqueLabel = new JLabel(Language.string("Uscita collegamento +5V, pin:   "));
        this.cinqueTF = new JTextField();
        this.cinqueTF.setHorizontalAlignment(11);
        this.cinqueTF.setText("--");
        this.cinqueTF.setEditable(false);
        this.cinqueTF.setMaximumSize(new Dimension(60, 20));
        cinqueLabel.setLabelFor(this.cinqueTF);
        pannello5V.add(cinqueLabel);
        pannello5V.add(Box.createRigidArea(new Dimension(80, 0)));
        pannello5V.add(this.cinqueTF);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setBackground(null);
        URL testoURL = DanasPreferences.getPrefLanguage().equals("it") ? this.getClass().getResource("/res/SpiegazioneDAE.html") : this.getClass().getResource("/res/SpiegazioneDAE_en.html");
        try {
            editorPane.setPage(testoURL);
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL DAE: " + testoURL);
        }
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setBorder(BorderFactory.createEmptyBorder());
        pannelloTesto.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloTesto.add(editorScrollPane);
        pannelloTesto.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 15)));
        pannelloCentrale.add(pannelloCampionamento);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 25)));
        pannelloCentrale.add(pannelloImpulsiRpm);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 25)));
        pannelloCentrale.add(pannelloImpulsiVel1);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 25)));
        pannelloCentrale.add(pannelloImpulsiVel2);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 25)));
        pannelloCentrale.add(pannelloRpm);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloCentrale.add(pannelloVelocita);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloCentrale.add(pannelloAnalog);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloCentrale.add(pannelloMassa);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloCentrale.add(pannello5V);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloCentrale.add(pannelloTesto);
        ImageIcon logo = new ImageIcon(this.getClass().getResource("/pix/DAE.png"));
        JLabel topL = new JLabel(logo);
        topL.setAlignmentX(2.0f);
        new JPanel();
        topL.setBorder(BorderFactory.createLineBorder(Color.black));
        pannelloPrincipale.add((Component)topL, "North");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
    }

    private void connect() {
        if (this.conn.isConnected()) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DaeDialog.this.setEnabled(false);
                JDialog f1 = new JDialog((Dialog)DaeDialog.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                new JButton(new ImageIcon(ImgUrl));
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Il sistema sta verificando le porte COM disponibili") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                progressBar.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(progressBar);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                try {
                    DaeDialog.this.conn.connect(3);
                    DaeDialog.this.setConnected(true);
                    DaeDialog.this.leggiImpos();
                }
                catch (Exception e) {
                    f1.setVisible(false);
                    JOptionPane.showMessageDialog(DaeDialog.this, Language.string("Errore di connessione: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    DaeDialog.this.setEnabled(true);
                    DaeDialog.this.padre.requestFocus();
                    DaeDialog.this.requestFocus();
                    DaeDialog.this.setConnected(false);
                    return;
                }
                finally {
                    f1.setVisible(false);
                    DaeDialog.this.setEnabled(true);
                    DaeDialog.this.padre.requestFocus();
                    DaeDialog.this.requestFocus();
                }
            }
        }.start();
    }

    private void disconnect() {
        if (!this.conn.isConnected()) {
            return;
        }
        try {
            this.conn.disconnect();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Language.string("Errore di disconnessione: impossibile chiudere la connessione"), Language.string("ATTENZIONE"), 0);
        }
        this.setConnected(false);
        this.requestFocus();
    }

    public void setConnected(boolean connected) {
        if (connected) {
            this.connettiB.setText(Language.string("Disconnetti"));
            this.leggiB.setEnabled(true);
            this.applicaB.setEnabled(true);
        } else {
            this.connettiB.setText(Language.string("Connetti"));
            this.leggiB.setEnabled(false);
            this.applicaB.setEnabled(false);
        }
    }

    public void leggiImpos() {
        try {
            this.rpmCB.setSelectedItem(this.conn.getDaeRpm());
            this.velCB.setSelectedItem(this.conn.getDaeVel());
            this.analogCB.setSelectedItem(this.conn.getDaeAnalog());
            this.bottone5Hz.setSelected(this.conn.isDaeFrequency5Hz());
            this.bottone10Hz.setSelected(!this.conn.isDaeFrequency5Hz());
            this.impulsiRpmTF.setValue(this.conn.getDaeImpulsiRpm());
            this.impulsiVel1TF.setValue(this.conn.getDaeImpulsiVel1());
            this.impulsiVel2TF.setValue(this.conn.getDaeImpulsiVel2());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, Language.string("Errore di connessione: impossibile ricevere i dati"), Language.string("ATTENZIONE"), 0);
            this.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Integer n;
        String s = "";
        Integer numeroRPM = (Integer)this.rpmCB.getSelectedItem();
        Integer numeroVel = (Integer)this.velCB.getSelectedItem();
        int numeroMaxAnalog = 4 - numeroRPM - numeroVel;
        if (e.getSource().equals(this.esciB)) {
            this.disconnect();
            this.dispose();
        }
        if (e.getSource().equals(this.applicaB)) {
            try {
                int ii1 = Integer.valueOf(this.impulsiRpmTF.getValue().toString());
                int ii2 = Integer.valueOf(this.impulsiVel1TF.getValue().toString());
                int ii3 = Integer.valueOf(this.impulsiVel2TF.getValue().toString());
                this.conn.setDaeSettings((Integer)this.rpmCB.getSelectedItem(), (Integer)this.velCB.getSelectedItem(), (Integer)this.analogCB.getSelectedItem(), ii1, ii2, ii3);
                this.conn.setDaeFrequency10Hz(this.bottone10Hz.isSelected());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource().equals(this.leggiB)) {
            this.leggiImpos();
        }
        if (e.getSource().equals(this.connettiB)) {
            if (this.conn.isConnected()) {
                this.disconnect();
            } else {
                this.connect();
            }
        }
        if (e.getSource().equals(this.rpmCB) || e.getSource().equals(this.velCB)) {
            this.analogCB.removeAllItems();
            this.analogCB.insertItemAt(numeroMaxAnalog - 1, 0);
            this.analogCB.insertItemAt(numeroMaxAnalog, 1);
            this.analogCB.setSelectedIndex(1);
            if (numeroRPM == 1) {
                this.pinRpmTF.setText("5");
            } else {
                this.pinRpmTF.setText("--");
            }
            switch (numeroVel) {
                case 0: {
                    this.pinVelTF.setText("--");
                    break;
                }
                case 1: {
                    this.pinVelTF.setText("4");
                    break;
                }
                case 2: {
                    this.pinVelTF.setText("3 e 4");
                }
            }
        }
        Integer[] piedini = new Integer[]{0, 0, 0};
        Integer indice = 0;
        if (numeroRPM == 1) {
            piedini[indice.intValue()] = 5;
            Integer ii3 = indice;
            n = indice = Integer.valueOf(indice + 1);
        }
        if (numeroVel >= 1) {
            piedini[indice.intValue()] = 4;
            Integer ii3 = indice;
            n = indice = Integer.valueOf(indice + 1);
        }
        if (numeroVel == 2) {
            piedini[indice.intValue()] = 3;
            Integer ii3 = indice;
            n = indice = Integer.valueOf(indice + 1);
        }
        int ultimoPiedino = 1;
        if (this.analogCB.getSelectedIndex() == 0) {
            ultimoPiedino = 2;
            this.cinqueTF.setText("2");
        } else {
            this.cinqueTF.setText("--");
        }
        Integer j = 5;
        while (j > ultimoPiedino) {
            if (piedini[0] != j && piedini[1] != j && piedini[2] != j) {
                s = s.length() == 0 ? s.concat(j.toString()) : s.concat("," + j.toString());
            }
            Integer n2 = j;
            Integer n3 = j = Integer.valueOf(j - 1);
        }
        if (s.length() == 0) {
            s = "--";
        }
        this.pinAnalogTF.setText(s);
    }
}

