/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Language;
import i2m.onLine.SerialConnection;
import i2m.onLine.UnknownPortException;
import i2m.traguardi.Circuit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CircuitDialog
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final String[] CIRC_EXTENSIONS = new String[]{"cir"};
    private SerialConnection conn;
    private JFileChooser fileChooser;
    private MyAction openA;
    private MyAction saveasA;
    private MyAction sendA;
    private MyAction receiveA;
    private MyAction addA;
    private MyAction removeA;
    private MyAction upA;
    private MyAction downA;
    private JList availableCircJL;
    private JList chosenCircJL;
    private DefaultListModel availableCircLM;
    private DefaultListModel chosenCircLM;
    private Circuit libero = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,");
    private JCheckBox SplitCb;

    public CircuitDialog(Frame owner, String portname) throws UnknownPortException {
        super(owner, Language.string("Configurazione MiniLAP"), true);
        this.conn = new SerialConnection(portname);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("Circuiti", CIRC_EXTENSIONS));
        this.openA = new MyAction(Language.string("Apri"), Language.string("Apri nuova libreria"), "/pix/open.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doOpen();
            }
        };
        this.openA.setEnabled(true);
        this.saveasA = new MyAction(Language.string("Salva"), Language.string("Salva elenco scelto"), "/pix/saveas.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doSaveas();
            }
        };
        this.saveasA.setEnabled(false);
        this.sendA = new MyAction(Language.string("Invia"), Language.string("Invia i circuiti selezionati al minilap"), "/pix/send.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doSend();
            }
        };
        this.sendA.setEnabled(false);
        this.receiveA = new MyAction("Download", Language.string("Scarica i circuiti dal minilap"), "/pix/receive.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doReceive();
            }
        };
        this.receiveA.setEnabled(true);
        this.addA = new MyAction(Language.string("Aggiungi"), Language.string("Aggiungi tra i circuiti selezionati"), "/pix/add.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doAdd();
            }
        };
        this.addA.setEnabled(true);
        this.removeA = new MyAction(Language.string("Elimina"), Language.string("Elimina dai circuiti selezionati"), "/pix/sub.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doRemove();
            }
        };
        this.removeA.setEnabled(true);
        this.upA = new MyAction(Language.string("Su"), Language.string("Sposta in su il circuito selezionato"), "/pix/su.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doUp();
            }
        };
        this.upA.setEnabled(true);
        this.downA = new MyAction(Language.string("Giu'"), Language.string("Sposta in giu' il circuito selezionato"), "/pix/giu.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CircuitDialog.this.doDown();
            }
        };
        this.downA.setEnabled(true);
        JToolBar topToolbar = new JToolBar("Main");
        topToolbar.add(this.openA);
        topToolbar.add(this.saveasA);
        topToolbar.addSeparator();
        topToolbar.add(this.sendA);
        topToolbar.add(this.receiveA);
        this.SplitCb = new JCheckBox("Trasmnetti SPLIT (solo miniLAP2)");
        this.SplitCb.setSelected(true);
        this.availableCircLM = new DefaultListModel();
        this.chosenCircLM = new DefaultListModel();
        this.availableCircJL = new JList(this.availableCircLM);
        this.chosenCircJL = new JList(this.chosenCircLM);
        this.availableCircJL.addListSelectionListener(this);
        this.chosenCircJL.addListSelectionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        cc.anchor = 21;
        cc.gridwidth = 3;
        cc.fill = 2;
        cc.weightx = 1.0;
        this.getContentPane().add((Component)topToolbar, cc);
        cc.gridx = 0;
        cc.gridy = 1;
        cc.anchor = 10;
        cc.gridwidth = 1;
        cc.fill = 0;
        cc.weightx = 0.0;
        cc.ipady = 10;
        this.getContentPane().add((Component)new JLabel(Language.string("Circuiti disponibili")), cc);
        cc.gridx = 2;
        this.getContentPane().add((Component)new JLabel(Language.string("Circuiti MiniLap")), cc);
        cc.ipady = 0;
        cc.gridx = 0;
        cc.gridy = 2;
        cc.gridheight = 4;
        cc.fill = 1;
        cc.weightx = 0.5;
        cc.weighty = 0.5;
        this.getContentPane().add((Component)new JScrollPane(this.availableCircJL, 22, 30), cc);
        cc.gridx = 2;
        this.getContentPane().add((Component)new JScrollPane(this.chosenCircJL, 22, 30), cc);
        cc.gridx = 1;
        cc.gridheight = 1;
        cc.fill = 2;
        cc.weightx = 0.0;
        cc.weighty = 0.5;
        cc.ipadx = 40;
        cc.anchor = 20;
        JButton b = new JButton(this.addA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        cc.gridy = 3;
        cc.anchor = 19;
        b = new JButton(this.removeA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        cc.gridy = 4;
        cc.anchor = 20;
        b = new JButton(this.upA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        cc.gridy = 5;
        cc.anchor = 19;
        b = new JButton(this.downA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        this.pack();
        File f = new File("./defaultCircuits.cir");
        this.apriLibreria(f);
        this.setSize(new Dimension(500, 350));
    }

    public void doOpen() {
        this.availableCircJL.removeAll();
        int res = this.fileChooser.showOpenDialog(this);
        if (res == 0) {
            File f = this.fileChooser.getSelectedFile();
            try {
                String line;
                try {
                    f.setReadable(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                this.availableCircJL.clearSelection();
                this.chosenCircJL.clearSelection();
                this.availableCircLM.clear();
                Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("T,") || line.startsWith("t,")) {
                        ultimoCircuito = new Circuit(line);
                        this.availableCircLM.addElement(ultimoCircuito);
                    }
                    if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                    ultimoCircuito.aggiungiSplit(line);
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean verificaCircuiti(File f) {
        int numeroSplit = 0;
        boolean valido = true;
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    numeroSplit = 0;
                    if (!ultimoCircuito.versoValido(line)) {
                        valido = false;
                    }
                }
                if (!line.startsWith("S,") && !line.startsWith("s,") || ++numeroSplit >= 3 || ultimoCircuito.versoValido(line)) continue;
                valido = false;
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return valido;
    }

    public void apriLibreria(File f) {
        int numeroSplit = 0;
        Circuit c = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
        if (!this.verificaCircuiti(f)) {
            JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame(), Language.string("Alcuni traguardi non hanno il verso di attraversamento impostato: NON verranno quindi caricati."), Language.string("ATTENZIONE"), 0);
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.availableCircJL.clearSelection();
            this.chosenCircJL.clearSelection();
            this.availableCircLM.clear();
            Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    numeroSplit = 0;
                    if (c.versoValido(line)) {
                        ultimoCircuito = new Circuit(line);
                        this.availableCircLM.addElement(ultimoCircuito);
                    } else {
                        ultimoCircuito = null;
                    }
                }
                if (!line.startsWith("S,") && !line.startsWith("s,") || ultimoCircuito == null || ++numeroSplit >= 3) continue;
                if (c.versoValido(line)) {
                    ultimoCircuito.aggiungiSplit(line);
                    continue;
                }
                this.availableCircLM.removeElement(ultimoCircuito);
                ultimoCircuito = null;
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void doSaveas() {
        int res = this.fileChooser.showSaveDialog(this);
        if (res == 0) {
            File f = this.fileChooser.getSelectedFile();
            if (!f.getName().endsWith("." + CIRC_EXTENSIONS[0])) {
                f = new File(f.getPath() + "." + CIRC_EXTENSIONS[0]);
            }
            if (!f.isAbsolute()) {
                f = new File(f.getAbsolutePath());
            }
            if (f.exists() && f.canWrite()) {
                int resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Sovrascrivere il file esistente?"), Language.string("ATTENZIONE"), 0);
                if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                    return;
                }
            } else if (f.exists() || !f.getParentFile().exists() || !f.getParentFile().isDirectory() || !f.getParentFile().canWrite()) {
                JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
                return;
            }
            try {
                PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
                this.availableCircJL.clearSelection();
                this.chosenCircJL.clearSelection();
                for (int i = 0; i < this.chosenCircLM.size(); ++i) {
                    Circuit c = (Circuit)this.chosenCircLM.elementAt(i);
                    out.println(c.getMinilapString(i + 1, 0));
                }
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void doSend() {
        new Thread(){

            @Override
            public void run() {
                CircuitDialog.this.sendCircuits();
            }
        }.start();
    }

    public void doReceive() {
        new Thread(){

            @Override
            public void run() {
                CircuitDialog.this.receiveCircuits();
            }
        }.start();
    }

    public void doAdd() {
        Object[] circs = this.availableCircJL.getSelectedValues();
        for (int i = 0; i < circs.length; ++i) {
            if (this.chosenCircLM.size() >= 20) {
                this.addA.setEnabled(false);
                break;
            }
            this.chosenCircLM.addElement(circs[i]);
        }
        this.availableCircJL.clearSelection();
        if (this.chosenCircLM.getSize() != 0) {
            this.sendA.setEnabled(true);
            this.saveasA.setEnabled(true);
        }
    }

    public void doRemove() {
        int[] selIndexes = this.chosenCircJL.getSelectedIndices();
        for (int i = selIndexes.length - 1; i >= 0; --i) {
            this.chosenCircLM.remove(selIndexes[i]);
        }
        this.chosenCircJL.clearSelection();
        if (this.chosenCircLM.getSize() == 0) {
            this.sendA.setEnabled(false);
            this.saveasA.setEnabled(false);
        } else {
            this.sendA.setEnabled(true);
            this.saveasA.setEnabled(true);
        }
        if (this.chosenCircLM.size() < 20) {
            this.addA.setEnabled(true);
        }
    }

    public void doUp() {
        int[] selIndexes = this.chosenCircJL.getSelectedIndices();
        if (selIndexes.length != 1) {
            return;
        }
        int selIndex = selIndexes[0];
        if (selIndex == 0) {
            return;
        }
        Object selValue = this.chosenCircLM.remove(selIndex);
        this.chosenCircLM.add(selIndex - 1, selValue);
        this.chosenCircJL.setSelectedIndex(selIndex - 1);
        this.sendA.setEnabled(true);
        this.saveasA.setEnabled(true);
    }

    public void doDown() {
        int[] selIndexes = this.chosenCircJL.getSelectedIndices();
        if (selIndexes.length != 1) {
            return;
        }
        int selIndex = selIndexes[0];
        if (selIndex == this.chosenCircLM.getSize() - 1) {
            return;
        }
        Object selValue = this.chosenCircLM.remove(selIndex);
        this.chosenCircLM.add(selIndex + 1, selValue);
        this.chosenCircJL.setSelectedIndex(selIndex + 1);
        this.sendA.setEnabled(true);
        this.saveasA.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCircuits() {
        boolean miniLAP2 = false;
        String[] elenco = new String[20];
        Circuit[] elencoTrasmessi = new Circuit[20];
        int proseguire = JOptionPane.showConfirmDialog(this, Language.string("Tutti i circuiti precedenti verranno cancellati (vedi istruzioni).Proseguire?"), Language.string("ATTENZIONE"), 0);
        if (proseguire == -1 || proseguire == 1) {
            return;
        }
        this.SplitCb.setEnabled(false);
        ProgressMonitor pm = new ProgressMonitor(this, Language.string("Invio dati in corso"), "", 0, 100);
        this.setEnabled(false);
        this.setFocusableWindowState(true);
        try {
            pm.setProgress(0);
            this.conn.open(1);
            this.conn.write("?\r");
            System.out.println("Chiedo la versione del miniLAP");
            String end = this.conn.readLine();
            if (end.startsWith("$miniLAP2")) {
                miniLAP2 = true;
                System.out.println("miniLAP versione2");
                end = this.conn.readLine();
            } else {
                System.out.println("miniLAP versione1");
            }
            this.conn.clear();
            pm.setProgress(15);
            for (int i = 0; i < 20 && !pm.isCanceled(); ++i) {
                Circuit circ = i < this.chosenCircLM.size() ? (Circuit)this.chosenCircLM.elementAt(i) : this.libero;
                this.conn.write(circ.getMinilapString(i, 0));
                this.conn.write('\r');
                System.out.println(circ.getMinilapString(i, 0));
                elencoTrasmessi[i] = circ;
                elenco[i] = circ.getMinilapString(i, 0);
                String line = this.conn.readLine();
                System.out.println(line);
                if (line == null || !line.equals("READY")) {
                    throw new IOException("Letto '" + line + "' invece di 'READY'");
                }
                if (miniLAP2 && this.SplitCb.isSelected()) {
                    for (int j = 1; j < 3; ++j) {
                        if (circ.numeroAttraversamenti() <= j) continue;
                        this.conn.write(circ.getMinilapString(i, j));
                        this.conn.write('\r');
                        System.out.println(circ.getMinilapString(i, j));
                        line = this.conn.readLine();
                        System.out.println(line);
                        if (line != null && line.equals("READY")) continue;
                        throw new IOException("Letto '" + line + "' invece di 'READY'");
                    }
                }
                pm.setProgress((i + 1) * 4 + 15);
                Thread.sleep(150L);
            }
            this.setEnabled(true);
            this.setFocusableWindowState(true);
            this.requestFocus();
            pm.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Language.string("Impossibile inviare i dati. Problemi di connessione"));
            ex.printStackTrace();
            this.SplitCb.setEnabled(true);
        }
        finally {
            try {
                this.conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                this.receiveCircuits();
                for (int i = 0; i < 20; ++i) {
                    if (elencoTrasmessi[i].ugualeMini((Circuit)this.chosenCircLM.elementAt(i), miniLAP2)) continue;
                    this.chosenCircLM.clear();
                    for (int j = 0; j < 20; ++j) {
                        this.chosenCircLM.addElement(new Circuit(elenco[j]));
                    }
                    JOptionPane.showMessageDialog(this, Language.string("I dati trasmessi sono risultati corrotti.Provare a inviarli nuovamente"));
                }
            }
            catch (Exception ex) {
                this.SplitCb.setEnabled(true);
            }
            this.setEnabled(true);
            this.setFocusableWindowState(true);
            this.requestFocus();
            this.SplitCb.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveCircuits() {
        this.chosenCircLM.clear();
        ProgressMonitor pm = new ProgressMonitor(this, Language.string("Ricezione dati in corso"), "", 0, 100);
        this.setEnabled(false);
        this.setFocusableWindowState(true);
        try {
            String line;
            pm.setProgress(0);
            this.conn.open(1);
            System.out.println("porta aperta");
            this.conn.write('l');
            pm.setProgress(4);
            int progress = 4;
            Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
            while ((line = this.conn.readLine()) != null && !pm.isCanceled() && !line.equals("READY")) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    ultimoCircuito = new Circuit(line);
                    this.chosenCircLM.addElement(ultimoCircuito);
                    this.saveasA.setEnabled(true);
                }
                if (line.startsWith("S,") || line.startsWith("s,")) {
                    ultimoCircuito.aggiungiSplit(line);
                }
                pm.setProgress(progress);
                progress += 4;
                System.out.println("Ricevuto:" + line);
            }
            if (!line.equals("READY")) {
                JOptionPane.showMessageDialog(this, Language.string("Impossibile ricevere i dati. Problemi di connessione"));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Language.string("Impossibile ricevere i dati. Problemi di connessione"));
        }
        finally {
            try {
                this.conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setEnabled(true);
            this.setFocusableWindowState(true);
            this.requestFocus();
            pm.close();
            this.chosenCircLM.addElement("aaa");
            this.chosenCircLM.removeElement("aaa");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.chosenCircJL && this.chosenCircJL.getSelectedIndex() != -1) {
            this.availableCircJL.clearSelection();
        } else if (e.getSource() == this.availableCircJL && this.availableCircJL.getSelectedIndex() != -1) {
            this.chosenCircJL.clearSelection();
        }
    }

    abstract class MyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        MyAction(String name, String shortDesc, String imgFileName) {
            this.setName(name);
            this.setDescription(shortDesc);
            this.setImage(imgFileName);
        }

        void setName(String name) {
            this.putValue("Name", name);
        }

        void setDescription(String shortDesc) {
            this.putValue("ShortDescription", shortDesc);
        }

        void setImage(String imgFileName) {
            if (imgFileName != null) {
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource(imgFileName)));
            }
        }
    }
}

