/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

public class CanTableRow {
    private boolean usa;
    private int numero;
    private String nome;
    private String tipo;
    private int frequenza;
    private int id;
    private int byte1;
    private int byte2;
    private String maschera;
    private int divisione;
    private float guadagno;
    private float offset;
    private float minimo;
    private float massimo;
    private String tipoSensore;
    private String segno;
    private String byteMultiplex;
    private int valoreMultiplex;
    private int can;

    public CanTableRow(int numero, boolean usa, String nome, String tipo, int frequenza, int id, int byte1, int byte2, String maschera, int divisione, float guadagno, float offset, float minimo, float massimo, String tipoSensore, String segno, String byteMultiplex, int valoreMultiplex, int can) {
        this.usa = usa;
        this.numero = numero;
        this.nome = nome;
        this.tipo = tipo;
        this.frequenza = frequenza;
        this.id = id;
        this.byte1 = byte1;
        this.byte2 = byte2;
        this.maschera = maschera;
        this.divisione = divisione;
        this.guadagno = guadagno;
        this.offset = offset;
        this.minimo = minimo;
        this.massimo = massimo;
        this.tipoSensore = tipoSensore;
        this.segno = segno;
        this.byteMultiplex = byteMultiplex;
        this.valoreMultiplex = valoreMultiplex;
        this.can = can;
    }

    public void reset() {
        this.usa = false;
        this.nome = "Can" + this.numero;
        this.tipo = "Default";
        this.frequenza = 10;
        this.id = 0;
        this.byte1 = 1;
        this.byte2 = 2;
        this.maschera = "1111111111111111";
        this.divisione = 1;
        this.guadagno = 1.0f;
        this.offset = 0.0f;
        this.minimo = 0.0f;
        this.massimo = 1023.0f;
        this.tipoSensore = "Linear";
        this.segno = "UNSIGNED";
        this.byteMultiplex = "OFF";
        this.valoreMultiplex = 0;
        this.can = 1;
    }

    public boolean equals(CanTableRow origine) {
        boolean uguale = true;
        if (this.usa != origine.getUsa()) {
            uguale = false;
        }
        if (!this.usa && !origine.getUsa()) {
            return true;
        }
        if (this.numero != origine.getNumero()) {
            uguale = false;
        }
        if (this.frequenza != origine.getFrequenza()) {
            uguale = false;
        }
        if (this.id != origine.getId()) {
            uguale = false;
        }
        if (this.byte1 != origine.getByte1()) {
            uguale = false;
        }
        if (this.byte2 != origine.getByte2()) {
            uguale = false;
        }
        if (this.divisione != origine.getDivisione()) {
            uguale = false;
        }
        if (this.guadagno != origine.getGuadagno()) {
            uguale = false;
        }
        if (this.offset != origine.getOffset()) {
            uguale = false;
        }
        if (this.minimo != origine.getMinimo()) {
            uguale = false;
        }
        if (this.massimo != origine.getMassimo()) {
            uguale = false;
        }
        if (!this.tipoSensore.equals(origine.getTipoSensore())) {
            uguale = false;
        }
        if (!this.maschera.equals(origine.getMaschera())) {
            uguale = false;
        }
        if (!this.tipo.equals(origine.getTipo())) {
            uguale = false;
        }
        if (!this.nome.equals(origine.getNome())) {
            uguale = false;
        }
        if (!this.segno.equals(origine.getSegno())) {
            uguale = false;
        }
        if (!this.byteMultiplex.equals(origine.getByteMultiplex())) {
            uguale = false;
        }
        if (this.valoreMultiplex != origine.getValoreMultiplex()) {
            uguale = false;
        }
        if (this.can != origine.getCan()) {
            uguale = false;
        }
        return uguale;
    }

    public CanTableRow duplica() {
        CanTableRow riga = new CanTableRow(this.numero, this.usa, this.nome, this.tipo, this.frequenza, this.id, this.byte1, this.byte2, this.maschera, this.divisione, this.guadagno, this.offset, this.minimo, this.massimo, this.tipoSensore, this.segno, this.byteMultiplex, this.valoreMultiplex, this.can);
        return riga;
    }

    public String getSegno() {
        return this.segno;
    }

    public String getByteMultiplex() {
        return this.byteMultiplex;
    }

    public int getValoreMultiplex() {
        return this.valoreMultiplex;
    }

    public int getNumero() {
        return this.numero;
    }

    public int getCan() {
        return this.can;
    }

    public void setCan(int can) {
        this.can = can;
    }

    public void setSegno(String segno) {
        this.segno = segno;
    }

    public void setByteMultiplex(String byteMultiplex) {
        this.byteMultiplex = byteMultiplex;
    }

    public void setValoreMultiplex(int valoreMultiplex) {
        this.valoreMultiplex = valoreMultiplex;
    }

    public void setUsa(boolean usa) {
        this.usa = usa;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setTipoSensore(String tipoSensore) {
        this.tipoSensore = tipoSensore;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setByte1(int byte1) {
        this.byte1 = byte1;
    }

    public void setByte2(int byte2) {
        this.byte2 = byte2;
    }

    public void setMaschera(String maschera) {
        this.maschera = maschera;
    }

    public void setDivisione(int divisione) {
        this.divisione = divisione;
    }

    public void setFrequenza(int frequenza) {
        this.frequenza = frequenza;
    }

    public void setMinimo(float min) {
        this.minimo = min;
    }

    public void setMassimo(float max) {
        this.massimo = max;
    }

    public void setGuadagno(float guadagno) {
        this.guadagno = guadagno;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public boolean getUsa() {
        return this.usa;
    }

    public String getNome() {
        return this.nome;
    }

    public String getTipo() {
        return this.tipo;
    }

    public String getTipoSensore() {
        return this.tipoSensore;
    }

    public int getId() {
        return this.id;
    }

    public int getByte1() {
        return this.byte1;
    }

    public int getByte2() {
        return this.byte2;
    }

    public String getMaschera() {
        return this.maschera;
    }

    public int getDivisione() {
        return this.divisione;
    }

    public int getIndiceDivisione() {
        switch (this.divisione) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
        }
        return 0;
    }

    public int getFrequenza() {
        return this.frequenza;
    }

    public float getMinimo() {
        return this.minimo;
    }

    public float getMassimo() {
        return this.massimo;
    }

    public float getGuadagno() {
        return this.guadagno;
    }

    public float getOffset() {
        return this.offset;
    }

    public Object getCampo(int index) {
        if (index == 0) {
            return this.getUsa();
        }
        if (index == 1) {
            return this.getNumero();
        }
        if (index == 2) {
            return this.getNome();
        }
        if (index == 3) {
            return this.getTipo();
        }
        if (index == 4) {
            return this.getFrequenza();
        }
        if (index == 5) {
            return this.getId();
        }
        if (index == 6) {
            return this.getByte1();
        }
        if (index == 7) {
            return this.getByte2();
        }
        if (index == 8) {
            return this.getMaschera();
        }
        if (index == 9) {
            return this.getDivisione();
        }
        if (index == 10) {
            return Float.valueOf(this.getGuadagno());
        }
        if (index == 11) {
            return Float.valueOf(this.getOffset());
        }
        if (index == 12) {
            return Float.valueOf(this.getMinimo());
        }
        if (index == 13) {
            return Float.valueOf(this.getMassimo());
        }
        if (index == 14) {
            return this.getTipoSensore();
        }
        if (index == 15) {
            return this.getSegno();
        }
        if (index == 16) {
            return this.getByteMultiplex();
        }
        if (index == 17) {
            return this.getValoreMultiplex();
        }
        if (index == 18) {
            return this.getCan();
        }
        return null;
    }

    public void setCampo(Object obj, int index) {
        if (index == 0) {
            this.setUsa((Boolean)obj);
        }
        if (index == 2) {
            this.setNome((String)obj);
        }
        if (index == 3) {
            this.setTipo((String)obj);
        }
        if (index == 4) {
            this.setFrequenza((Integer)obj);
        }
        if (index == 5) {
            this.setId((Integer)obj);
        }
        if (index == 6) {
            this.setByte1((Integer)obj);
        }
        if (index == 7) {
            this.setByte2((Integer)obj);
        }
        if (index == 8) {
            this.setMaschera((String)obj);
        }
        if (index == 9) {
            this.setDivisione((Integer)obj);
        }
        if (index == 10) {
            this.setGuadagno(((Float)obj).floatValue());
        }
        if (index == 11) {
            this.setOffset(((Float)obj).floatValue());
        }
        if (index == 12) {
            this.setMinimo(((Float)obj).floatValue());
        }
        if (index == 13) {
            this.setMassimo(((Float)obj).floatValue());
        }
        if (index == 14) {
            this.setTipoSensore((String)obj);
        }
        if (index == 15) {
            this.setSegno((String)obj);
        }
        if (index == 16) {
            this.setByteMultiplex((String)obj);
        }
        if (index == 17) {
            this.setValoreMultiplex((Integer)obj);
        }
        if (index == 18) {
            this.setCan((Integer)obj);
        }
    }
}

