/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.Language;
import i2m.onLine.CanTableRow;
import i2m.onLine.ChromeSettingsDialog;
import i2m.onLine.DasyProSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.MaskFormatter;

public class CanChannelsDialog
extends JDialog
implements KeyListener,
WindowListener,
TableModelListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    JTableX table;
    MyTableModel model;
    JScrollPane scrollPane;
    Vector<CanTableRow> elencoRighe = new Vector();
    Vector<CanTableRow> elencoRigheSelezionate = new Vector();
    JPanel tablePanel;
    ChromeSettingsDialog padre;
    DasyProSettingsDialog padreDasy;
    private JTextField ricercaTF;
    private JButton searchB;
    private JPanel panelSearch;
    private boolean filtrata = false;
    Dimension dimensioni = new Dimension(1360, 500);
    Dimension dimensioniMax = new Dimension(1430, 1600);
    boolean isDasy = false;

    public CanChannelsDialog(ChromeSettingsDialog owner) {
        super(owner, Language.string("Configurazione Canali Can Bus Chrome Pro2"), true);
        this.padre = owner;
        this.padreDasy = null;
        this.isDasy = false;
        this.costruisciFinestra();
    }

    public CanChannelsDialog(DasyProSettingsDialog ownerDasy) {
        super(ownerDasy, Language.string("Configurazione Canali Can Bus DataLog PRO"), true);
        this.padre = null;
        this.padreDasy = ownerDasy;
        this.isDasy = true;
        this.costruisciFinestra();
    }

    public void costruisciFinestra() {
        this.setDefaultCloseOperation(2);
        this.model = new MyTableModel();
        this.table = new JTableX(this.model);
        this.table.setFillsViewportHeight(false);
        this.table.getModel().addTableModelListener(this);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(this.table);
        MyTableCellRenderer2 renderer = new MyTableCellRenderer2();
        this.table.setDefaultRenderer(String.class, renderer);
        this.table.setDefaultRenderer(Float.class, renderer);
        this.table.setDefaultRenderer(Integer.class, renderer);
        this.table.setDefaultRenderer(Boolean.class, renderer);
        this.scrollPane = new JScrollPane(this.tablePanel);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloTabella = new JPanel(new BorderLayout());
        this.panelSearch = new JPanel();
        this.panelSearch.setLayout(new BoxLayout(this.panelSearch, 0));
        this.ricercaTF = new JTextField(2);
        this.ricercaTF.setEditable(true);
        this.ricercaTF.setEnabled(true);
        this.ricercaTF.setMaximumSize(new Dimension(180, 25));
        this.ricercaTF.setMinimumSize(new Dimension(80, 25));
        this.ricercaTF.addKeyListener(this);
        URL ImgUrl = this.getClass().getResource("/pix/search.png");
        this.searchB = new JButton(new ImageIcon(ImgUrl));
        this.searchB.setPreferredSize(new Dimension(25, 25));
        this.searchB.setMaximumSize(new Dimension(25, 25));
        this.searchB.setMinimumSize(new Dimension(25, 25));
        this.searchB.addActionListener(this);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        this.panelSearch.add(this.ricercaTF);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        this.panelSearch.add(this.searchB);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        this.table.getTableHeader().setFont(new Font("Arial", 1, 12));
        pannelloTabella.add((Component)this.table.getTableHeader(), "North");
        pannelloTabella.add((Component)this.scrollPane, "Center");
        pannelloPrincipale.add((Component)this.panelSearch, "North");
        pannelloPrincipale.add((Component)pannelloTabella, "Center");
        this.costruisciTabella();
        this.aggiornaAspetto();
        this.aggiorna();
        this.setContentPane(pannelloPrincipale);
        this.addWindowListener(this);
        this.pack();
        this.refresh();
        this.setSize(this.dimensioni);
    }

    public void costruisciTabella() {
        this.addRiga(new CanTableRow(0, true, "Rpm", "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Vel2"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Vel1"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Temp. Acqua"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Olio"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Benzina"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Marce"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        for (int i = 1; i < 129; ++i) {
            this.addRiga(new CanTableRow(i, false, "Can" + i, "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        }
    }

    public void ripristinaTabella() {
        this.table.getModel().removeTableModelListener(this);
        this.model.rimuoviTutto();
        this.elencoRighe.clear();
        this.elencoRigheSelezionate.clear();
        this.addRiga(new CanTableRow(0, true, "Rpm", "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Vel2"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Vel1"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Temp. Acqua"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Olio"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Benzina"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        this.addRiga(new CanTableRow(0, true, Language.string("Marce"), "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        for (int i = 1; i < 129; ++i) {
            this.addRiga(new CanTableRow(i, false, "Can" + i, "Default", 10, 0, 1, 2, "1111111111111111", 1, 1.0f, 0.0f, 0.0f, 1023.0f, "Linear", "UNSIGNED", "OFF", 0, 1), false);
        }
        this.refresh();
        this.table.getModel().addTableModelListener(this);
    }

    public void aggiornaAspetto() {
        int i;
        this.table.getColumnModel().getColumn(0).setPreferredWidth(22);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(45);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(45);
        this.table.getColumnModel().getColumn(8).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(9).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(10).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(11).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(12).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(13).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(14).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(15).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(16).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(17).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(18).setPreferredWidth(40);
        JComboBox<Object> comboBox = new JComboBox<Object>();
        comboBox.addItem("Analog1");
        comboBox.addItem("Analog2");
        comboBox.addItem("Analog3");
        comboBox.addItem("Analog4");
        comboBox.addItem("Analog5");
        comboBox.addItem("Analog6");
        comboBox.addItem("Analog7");
        comboBox.addItem("Analog8");
        comboBox.addItem("Can Bus");
        comboBox.addItem("Default");
        TableColumn colonna = this.table.getColumnModel().getColumn(3);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        comboBox.addItem(10);
        comboBox.addItem(100);
        comboBox.addItem(200);
        comboBox.addItem(500);
        colonna = this.table.getColumnModel().getColumn(4);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        for (i = 0; i < 4096; ++i) {
            comboBox.addItem(i);
        }
        colonna = this.table.getColumnModel().getColumn(5);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        comboBox.addItem("UNSIGNED");
        comboBox.addItem("SIGNED8");
        comboBox.addItem("SIGNED16");
        colonna = this.table.getColumnModel().getColumn(15);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        comboBox.addItem("0");
        comboBox.addItem("1");
        comboBox.addItem("2");
        comboBox.addItem("3");
        comboBox.addItem("4");
        comboBox.addItem("5");
        comboBox.addItem("6");
        comboBox.addItem("7");
        comboBox.addItem("OFF");
        colonna = this.table.getColumnModel().getColumn(16);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        for (i = 0; i < 255; ++i) {
            comboBox.addItem(i);
        }
        colonna = this.table.getColumnModel().getColumn(17);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        comboBox.addItem(1);
        comboBox.addItem(2);
        colonna = this.table.getColumnModel().getColumn(18);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        MaskFormatter mask = null;
        try {
            mask = new MaskFormatter("################");
            mask.setValidCharacters("01");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        JFormattedTextField maschera = new JFormattedTextField(mask);
        DefaultCellEditor dce = new DefaultCellEditor(maschera);
        this.table.getColumnModel().getColumn(8).setCellEditor(dce);
        comboBox = new JComboBox();
        comboBox.addItem(0);
        comboBox.addItem(1);
        comboBox.addItem(2);
        comboBox.addItem(3);
        comboBox.addItem(4);
        comboBox.addItem(5);
        comboBox.addItem(6);
        comboBox.addItem(7);
        colonna = this.table.getColumnModel().getColumn(6);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        comboBox.addItem(0);
        comboBox.addItem(1);
        comboBox.addItem(2);
        comboBox.addItem(3);
        comboBox.addItem(4);
        comboBox.addItem(5);
        comboBox.addItem(6);
        comboBox.addItem(7);
        colonna = this.table.getColumnModel().getColumn(7);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        comboBox.addItem(1);
        comboBox.addItem(2);
        comboBox.addItem(4);
        comboBox.addItem(8);
        comboBox.addItem(16);
        comboBox.addItem(32);
        comboBox.addItem(64);
        colonna = this.table.getColumnModel().getColumn(9);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        comboBox = new JComboBox();
        comboBox.addItem("Linear");
        comboBox.addItem("Parametric A");
        comboBox.addItem("Parametric B");
        comboBox.addItem("Parametric C");
        colonna = this.table.getColumnModel().getColumn(14);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public void setCanaliTpms(boolean attiva, boolean wss) {
        if (attiva) {
            if (wss) {
                CanTableRow riga = this.getRiga(129);
                riga.setUsa(true);
                riga.setNome("FrontPress");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(3);
                riga.setByte2(3);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(0.01376f);
                riga.setOffset(-0.013759971f);
                riga.setCan(1);
                riga = this.getRiga(128);
                riga.setUsa(true);
                riga.setNome("FrontTemp");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(2);
                riga.setByte2(2);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(-55.0f);
                riga.setCan(1);
                riga = this.getRiga(127);
                riga.setUsa(true);
                riga.setNome("Reserved");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(5);
                riga.setByte2(5);
                riga.setMaschera("0000000000000000");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(1);
                riga = this.getRiga(126);
                riga.setUsa(true);
                riga.setNome("LsbFrontID");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(1);
                riga.setByte2(0);
                riga.setMaschera("1111111111111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(1);
                riga = this.getRiga(125);
                riga.setUsa(true);
                riga.setNome("Reserved");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(1);
                riga.setByte2(1);
                riga.setMaschera("0000000000000000");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(1);
                riga = this.getRiga(134);
                riga.setUsa(true);
                riga.setNome("RearPress");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(7);
                riga.setByte2(7);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(0.01376f);
                riga.setOffset(-0.013759971f);
                riga.setCan(1);
                riga = this.getRiga(133);
                riga.setUsa(true);
                riga.setNome("RearTemp");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(6);
                riga.setByte2(6);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(-55.0f);
                riga.setCan(1);
                riga = this.getRiga(132);
                riga.setUsa(true);
                riga.setNome("Reserved");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(5);
                riga.setByte2(5);
                riga.setMaschera("0000000000000000");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(1);
                riga = this.getRiga(131);
                riga.setUsa(true);
                riga.setNome("LsbRearID");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(5);
                riga.setByte2(4);
                riga.setMaschera("1111111111111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(1);
                riga = this.getRiga(130);
                riga.setUsa(true);
                riga.setNome("Reserved");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(223);
                riga.setByte1(1);
                riga.setByte2(1);
                riga.setMaschera("0000000000000000");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(1);
            } else {
                CanTableRow riga = this.getRiga(129);
                riga.setUsa(true);
                riga.setNome("FrontPress");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1688);
                riga.setByte1(7);
                riga.setByte2(7);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(0.01376f);
                riga.setOffset(-0.013759971f);
                riga.setCan(2);
                riga = this.getRiga(128);
                riga.setUsa(true);
                riga.setNome("FrontTemp");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1688);
                riga.setByte1(6);
                riga.setByte2(6);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(-55.0f);
                riga.setCan(2);
                riga = this.getRiga(127);
                riga.setUsa(true);
                riga.setNome("FrontBattery");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1688);
                riga.setByte1(5);
                riga.setByte2(5);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(2);
                riga = this.getRiga(126);
                riga.setUsa(true);
                riga.setNome("LsbFrontID");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1688);
                riga.setByte1(3);
                riga.setByte2(2);
                riga.setMaschera("1111111111111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(2);
                riga = this.getRiga(125);
                riga.setUsa(true);
                riga.setNome("MsbFrontID");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1688);
                riga.setByte1(1);
                riga.setByte2(1);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(2);
                riga = this.getRiga(134);
                riga.setUsa(true);
                riga.setNome("RearPress");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1689);
                riga.setByte1(7);
                riga.setByte2(7);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(0.01376f);
                riga.setOffset(-0.013759971f);
                riga.setCan(2);
                riga = this.getRiga(133);
                riga.setUsa(true);
                riga.setNome("RearTemp");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1689);
                riga.setByte1(6);
                riga.setByte2(6);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(-55.0f);
                riga.setCan(2);
                riga = this.getRiga(132);
                riga.setUsa(true);
                riga.setNome("RearBattery");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1689);
                riga.setByte1(5);
                riga.setByte2(5);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(2);
                riga = this.getRiga(131);
                riga.setUsa(true);
                riga.setNome("LsbRearID");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1689);
                riga.setByte1(3);
                riga.setByte2(2);
                riga.setMaschera("1111111111111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(2);
                riga = this.getRiga(130);
                riga.setUsa(true);
                riga.setNome("MsbRearID");
                riga.setTipo("Can Bus");
                riga.setFrequenza(10);
                riga.setId(1689);
                riga.setByte1(1);
                riga.setByte2(1);
                riga.setMaschera("0000000011111111");
                riga.setGuadagno(1.0f);
                riga.setOffset(0.0f);
                riga.setCan(2);
            }
        } else {
            CanTableRow riga = this.getRiga(125);
            riga.reset();
            riga = this.getRiga(126);
            riga.reset();
            riga = this.getRiga(127);
            riga.reset();
            riga = this.getRiga(128);
            riga.reset();
            riga = this.getRiga(129);
            riga.reset();
            riga = this.getRiga(130);
            riga.reset();
            riga = this.getRiga(131);
            riga.reset();
            riga = this.getRiga(132);
            riga.reset();
            riga = this.getRiga(133);
            riga.reset();
            riga = this.getRiga(134);
            riga.reset();
        }
    }

    public void setCanaleDefault(int indiceCanaleCan, String nome, int frequenza, int can) {
        if (indiceCanaleCan < 0 || indiceCanaleCan > 127) {
            return;
        }
        CanTableRow riga = this.getRiga(indiceCanaleCan + 7);
        riga.setUsa(true);
        riga.setNome(nome);
        riga.setTipo("Default");
        riga.setFrequenza(frequenza);
        riga.setCan(can);
    }

    public String getStringaPulita(String origine) {
        String finale = origine;
        while (finale.endsWith(" ")) {
            finale = finale.substring(0, finale.length() - 1);
        }
        while (finale.startsWith(" ")) {
            finale = finale.substring(1, finale.length());
        }
        return finale;
    }

    public void addRiga(CanTableRow riga, boolean refresh) {
        this.table.getModel().removeTableModelListener(this);
        this.model.addRow(riga);
        this.elencoRighe.add(riga);
        if (refresh) {
            this.refresh();
        }
        this.table.getModel().addTableModelListener(this);
    }

    public CanTableRow getRiga(int indice) {
        return this.model.getRow(indice);
    }

    public Vector<CanTableRow> getElencoRighe() {
        return this.elencoRighe;
    }

    public Vector<CanTableRow> getElencoRigheTabella() {
        return ((MyTableModel)this.table.getModel()).getListaRighe();
    }

    public void aggiorna() {
        this.model.fireTableDataChanged();
    }

    public void refresh() {
        this.table.getModel().removeTableModelListener(this);
        this.aggiorna();
        this.table.getModel().addTableModelListener(this);
    }

    public void eseguiRicerca(String testo) {
        int i;
        this.table.getModel().removeTableModelListener(this);
        this.elencoRigheSelezionate.clear();
        for (i = 0; i < this.elencoRighe.size(); ++i) {
            if (!this.elencoRighe.get(i).getNome().toLowerCase().contains(testo.toLowerCase())) continue;
            this.elencoRigheSelezionate.add(this.elencoRighe.get(i));
        }
        this.model.rimuoviTutto();
        for (i = 0; i < this.elencoRigheSelezionate.size(); ++i) {
            this.model.addRow(this.elencoRigheSelezionate.get(i));
        }
        this.refresh();
        this.table.getModel().addTableModelListener(this);
    }

    public void pulisciricerca() {
        this.filtrata = false;
        this.ricercaTF.setText("");
    }

    public void ricaricaTutto() {
        this.table.getModel().removeTableModelListener(this);
        this.model.rimuoviTutto();
        for (int i = 0; i < this.elencoRighe.size(); ++i) {
            this.model.addRow(this.elencoRighe.get(i));
        }
        this.refresh();
        this.table.getModel().addTableModelListener(this);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this.isDasy) {
            this.padreDasy.verificaMarce();
        } else {
            this.padre.verificaMarce();
            this.padre.aggiornaNomiCanali();
        }
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.ricercaTF.getText().length() == 0) {
            this.filtrata = false;
            this.ricaricaTutto();
            this.setSize(this.dimensioni);
        }
        if (this.ricercaTF.getText().length() == 1 && !this.filtrata) {
            this.dimensioni = this.getSize();
        }
        if (this.ricercaTF.getText().length() >= 1) {
            this.filtrata = true;
            this.eseguiRicerca(this.ricercaTF.getText());
            if (this.elencoRigheSelezionate.size() < (this.dimensioni.height - 70) / 16) {
                this.pack();
            } else {
                this.setSize(this.dimensioni);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int col = e.getColumn();
        int row = e.getFirstRow();
        if (row >= this.table.getModel().getRowCount()) {
            return;
        }
        switch (col) {
            case 8: {
                String maschera = this.getStringaPulita((String)this.table.getModel().getValueAt(row, col));
                if (maschera.length() >= 16 && !maschera.contains(" ")) break;
                JOptionPane.showMessageDialog(this, Language.string("La maschera inserita non ha 16 caratteri"), Language.string("ATTENZIONE"), 0);
                this.table.getModel().setValueAt("1111111111111111", row, col);
            }
        }
        this.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.searchB)) {
            if (this.ricercaTF.getText().length() == 0) {
                this.filtrata = false;
                this.ricaricaTutto();
                this.setSize(this.dimensioni);
            } else {
                if (this.ricercaTF.getText().length() == 1 && !this.filtrata) {
                    this.dimensioni = this.getSize();
                }
                this.filtrata = true;
                this.eseguiRicerca(this.ricercaTF.getText());
                if (this.elencoRigheSelezionate.size() < (this.dimensioni.height - 70) / 16) {
                    this.pack();
                } else {
                    this.setSize(this.dimensioni);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        CanChannelsDialog i = new CanChannelsDialog((ChromeSettingsDialog)null);
        i.setVisible(true);
    }

    public class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        Vector<String> columnNames = new Vector();
        private Vector<CanTableRow> datiInfo = new Vector();

        public MyTableModel() {
            this.columnNames.add("");
            this.columnNames.add(Language.string(""));
            this.columnNames.add(Language.string("Nome"));
            this.columnNames.add(Language.string("Tipo"));
            this.columnNames.add(Language.string("Frequenza"));
            this.columnNames.add("ID");
            this.columnNames.add("Byte1");
            this.columnNames.add("Byte2");
            this.columnNames.add("Mask");
            this.columnNames.add("Divisione");
            this.columnNames.add(Language.string("Guadagno"));
            this.columnNames.add(Language.string("Offset"));
            this.columnNames.add(Language.string("Minimo"));
            this.columnNames.add(Language.string("Massimo"));
            this.columnNames.add(Language.string("Tipo sensore"));
            this.columnNames.add(Language.string("Segno"));
            this.columnNames.add(Language.string("Byte Multi."));
            this.columnNames.add(Language.string("Valore Multi."));
            this.columnNames.add(Language.string("Can"));
        }

        @Override
        public int getColumnCount() {
            return 19;
        }

        @Override
        public int getRowCount() {
            return this.datiInfo.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 1 && (Integer)this.datiInfo.get(row).getCampo(1) == 0) {
                return "";
            }
            return this.datiInfo.get(row).getCampo(col);
        }

        public Vector<CanTableRow> getListaRighe() {
            return this.datiInfo;
        }

        public Class<? extends Object> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            int numeroRiga = (Integer)this.datiInfo.get(row).getCampo(1);
            if (numeroRiga == 0 && col < 3) {
                return false;
            }
            if (col == 1) {
                return false;
            }
            boolean usa = (Boolean)CanChannelsDialog.this.table.getValueAt(row, 0);
            if (!usa) {
                if (col > 0) {
                    return false;
                }
            } else {
                String tipo = (String)CanChannelsDialog.this.table.getValueAt(row, 3);
                String segno = (String)CanChannelsDialog.this.table.getValueAt(row, 15);
                if (this.isDefault(tipo) && col > 3) {
                    return false;
                }
                if (this.isCanBus(tipo) && col > 11 && col < 15) {
                    return false;
                }
                if (this.isCanBus(tipo) && col == 18) {
                    return true;
                }
                if (this.isCanBus(tipo) && !segno.equals("UNSIGNED") && (col == 8 || col == 9)) {
                    return false;
                }
                if (!this.isCanBus(tipo) && !this.isDefault(tipo)) {
                    return (col <= 4 || col >= 12) && col <= 14;
                }
            }
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.datiInfo.get(row).setCampo(value, col);
            this.fireTableCellUpdated(row, col);
        }

        public void addRow(CanTableRow riga) {
            this.datiInfo.add(riga);
        }

        public CanTableRow getRow(int indice) {
            return this.datiInfo.get(indice);
        }

        public void rimuoviTutto() {
            this.datiInfo.clear();
        }

        public boolean isDefault(String tipo) {
            return tipo.equals("Default");
        }

        public boolean isCanBus(String tipo) {
            return tipo.equals("Can Bus");
        }

        public boolean isAnalog(String tipo) {
            return tipo.equals("Analog1") || tipo.equals("Analog2") || tipo.equals("Analog3") || tipo.equals("Analog4") || tipo.equals("Analog5") || tipo.equals("Analog6") || tipo.equals("Analog7") || tipo.equals("Analog8");
        }
    }

    public class MyTableCellRenderer2
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int numeroRiga = 0;
            try {
                numeroRiga = (Integer)table.getValueAt(row, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (numeroRiga == 0) {
                this.setBackground(new Color(215, 250, 215));
            } else if (row % 2 == 1) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(new Color(240, 250, 250));
            }
            if (value.getClass().equals(Boolean.class)) {
                Boolean f1 = (Boolean)value;
                JCheckBox jc = new JCheckBox();
                jc.setSelected(f1);
                jc.setHorizontalAlignment(0);
                if (row < 7) {
                    jc.setEnabled(false);
                }
                return jc;
            }
            this.setHorizontalAlignment(0);
            boolean usa = (Boolean)table.getValueAt(row, 0);
            if (usa && (!CanChannelsDialog.this.isDasy || row != 4 && row != 5)) {
                String tipo = (String)table.getValueAt(row, 3);
                String segno = (String)table.getValueAt(row, 15);
                if (this.isDefault(tipo) && column > 3) {
                    this.setForeground(Color.LIGHT_GRAY);
                    return this;
                }
                if (this.isDigital(tipo) && column > 4) {
                    this.setForeground(Color.LIGHT_GRAY);
                    return this;
                }
                if (this.isCanBus(tipo) && column > 11 && column < 15) {
                    this.setForeground(Color.LIGHT_GRAY);
                    return this;
                }
                if (this.isCanBus(tipo) && !segno.equals("UNSIGNED") && (column == 8 || column == 9)) {
                    this.setForeground(Color.LIGHT_GRAY);
                    return this;
                }
                if (!this.isCanBus(tipo) && !this.isDefault(tipo)) {
                    if (column > 4 && column < 12 || column > 14) {
                        this.setForeground(Color.LIGHT_GRAY);
                        return this;
                    }
                    this.setForeground(Color.DARK_GRAY);
                    return this;
                }
                this.setForeground(Color.DARK_GRAY);
                return this;
            }
            this.setForeground(Color.LIGHT_GRAY);
            return this;
        }

        public boolean isDigital(String tipo) {
            return tipo.equals("Rpm input") || tipo.equals(Language.string("Ingresso Vel2")) || tipo.equals("Ingresso Vel1") || tipo.equals("Ingresso Neutro");
        }

        public boolean isDefault(String tipo) {
            return tipo.equals("Default");
        }

        public boolean isCanBus(String tipo) {
            return tipo.equals("Can Bus");
        }

        public boolean isAnalog(String tipo) {
            return tipo.startsWith("Analog");
        }
    }

    public class JTableX
    extends JTable {
        public JTableX() {
        }

        public JTableX(TableModel tm) {
            super(tm);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (CanChannelsDialog.this.isDasy && row == 4 || row == 5) {
                return null;
            }
            if (col == 18 && row < 7) {
                return null;
            }
            if (row < 7 && col == 3) {
                String ingresso = "";
                switch (row) {
                    case 0: {
                        ingresso = "Rpm input";
                        break;
                    }
                    case 1: {
                        ingresso = Language.string("Ingresso Vel2");
                        break;
                    }
                    case 2: {
                        ingresso = Language.string("Ingresso Vel1");
                        break;
                    }
                    case 3: {
                        ingresso = Language.string("Ingresso Acqua");
                        break;
                    }
                    case 4: {
                        ingresso = Language.string("Ingresso Olio");
                        break;
                    }
                    case 5: {
                        ingresso = Language.string("Ingresso Benzina");
                        break;
                    }
                    case 6: {
                        ingresso = Language.string("Ingresso Neutro");
                    }
                }
                JComboBox<String> comboBox = new JComboBox<String>();
                comboBox.addItem("Default");
                comboBox.addItem(ingresso);
                comboBox.addItem("Can Bus");
                return new DefaultCellEditor(comboBox);
            }
            if (row < 7 && col == 4) {
                JComboBox<Integer> comboBox = new JComboBox<Integer>();
                comboBox.addItem(10);
                comboBox.addItem(100);
                return null;
            }
            return super.getCellEditor(row, col);
        }
    }
}

