/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DanasPreferences;
import i2m.Language;
import i2m.onLine.SerialConnection;
import i2m.onLine.UnknownPortException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class COMDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JComboBox sceltaCOM = null;
    private JButton okB;
    private JButton annullaB;
    private JButton cercaB;
    private SerialConnection conn;
    private String[] elenco = null;
    private JProgressBar progressBar = null;
    private JPanel pannelloPrincipale;
    private Thread scansionaPorteThread = null;
    private boolean annullato = false;

    public COMDialog(Frame owner, String[] lista) {
        super(owner, Language.string("COM settings"), true);
        this.elenco = lista;
        this.pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(this.pannelloPrincipale);
        this.setSize(new Dimension(430, 110));
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(20, 30)), "East");
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(20, 30)), "West");
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        JLabel l = new JLabel(Language.string("Scegli la porta su cui \u00e8 connesso il sistema e premi OK"));
        panel1.setAlignmentX(1.0f);
        panel1.add(l);
        panel1.add(Box.createRigidArea(new Dimension(1, 30)));
        this.sceltaCOM = new JComboBox();
        this.cercaB = new JButton(Language.string("Cerca"));
        this.annullaB = new JButton(Language.string("Annulla"));
        this.annullaB.addActionListener(this);
        this.okB = new JButton("OK");
        this.cercaB.addActionListener(this);
        this.okB.addActionListener(this);
        this.sceltaCOM.setMinimumSize(new Dimension(120, 25));
        this.sceltaCOM.setMaximumSize(new Dimension(120, 25));
        this.okB.setMinimumSize(new Dimension(80, 25));
        this.okB.setMaximumSize(new Dimension(80, 25));
        this.cercaB.setMinimumSize(new Dimension(80, 25));
        this.cercaB.setMaximumSize(new Dimension(80, 25));
        this.annullaB.setMinimumSize(new Dimension(90, 25));
        this.annullaB.setMaximumSize(new Dimension(90, 25));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.sceltaCOM);
        panel.add(Box.createRigidArea(new Dimension(10, 40)));
        panel.add(this.cercaB);
        panel.add(Box.createRigidArea(new Dimension(5, 40)));
        panel.add(this.okB);
        panel.add(Box.createRigidArea(new Dimension(5, 40)));
        panel.add(this.annullaB);
        panel1.setAlignmentX(0.0f);
        panel.setAlignmentX(0.0f);
        pannelloCentrale.add(panel1);
        pannelloCentrale.add(panel);
        pannelloCentrale.setAlignmentX(0.0f);
        this.pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        for (int i = 0; i < lista.length; ++i) {
            this.sceltaCOM.addItem(lista[i]);
        }
        this.sceltaCOM.setSelectedIndex(0);
    }

    private synchronized void setAnnullato(boolean annulla) {
        this.annullato = annulla;
    }

    private synchronized boolean getAnnullato() {
        return this.annullato;
    }

    public void scansiona() {
        int indicePorta = -1;
        System.out.println("Inizio scansione porte COM");
        for (int i = 0; i < this.elenco.length; ++i) {
            try {
                this.sceltaCOM.setSelectedIndex(i);
                float percentuale = 25 / this.elenco.length * 4 * i;
                this.progressBar.setValue((int)percentuale);
                if (this.getAnnullato()) break;
                System.out.println("Provo miniLAP su porta " + i);
                this.conn = new SerialConnection(this.elenco[i]);
                this.conn.open(1);
                this.conn.clear();
                this.conn.setTimeOut(1000);
                this.conn.write("q\r");
                String end = this.conn.readLine();
                System.out.println("Letto:" + end);
                if (end != null && end.endsWith("READY")) {
                    this.conn.close();
                    indicePorta = i;
                    break;
                }
                this.conn.close();
                percentuale = 25 / this.elenco.length * (4 * i + 1);
                this.progressBar.setValue((int)percentuale);
                if (this.getAnnullato()) break;
                this.conn = new SerialConnection(this.elenco[i]);
                this.conn.open(3);
                this.conn.clear();
                this.conn.setTimeOut(1000);
                this.conn.write("$I2MSRLDAE\r");
                System.out.println("Provo DAE su porta " + i);
                end = this.conn.readLine();
                System.out.println("Letto:" + end);
                if (end != null && end.equals("READY")) {
                    this.conn.close();
                    indicePorta = i;
                    break;
                }
                this.conn.close();
                percentuale = 25 / this.elenco.length * (4 * i + 1);
                this.progressBar.setValue((int)percentuale);
                if (this.getAnnullato()) break;
                this.conn = new SerialConnection(this.elenco[i]);
                this.conn.open(4);
                this.conn.clear();
                this.conn.setTimeOut(1000);
                this.conn.write("$I2MSRLDAE\r");
                System.out.println("Provo TC su porta " + i);
                end = this.conn.readLine();
                System.out.println("Letto:" + end);
                if (end != null && end.equals("READY")) {
                    this.conn.close();
                    indicePorta = i;
                    break;
                }
                this.conn.close();
                percentuale = 25 / this.elenco.length * (4 * i + 1);
                this.progressBar.setValue((int)percentuale);
                if (this.getAnnullato()) break;
                this.conn = new SerialConnection(this.elenco[i]);
                this.conn.open(2);
                this.conn.clear();
                this.conn.setTimeOut(1000);
                this.conn.write("\r");
                System.out.println("Provo DASY su porta " + i);
                end = this.conn.readLine();
                System.out.println("Letto:" + end);
                if (end != null && end.equals("READY")) {
                    this.conn.close();
                    indicePorta = i;
                    break;
                }
                this.conn.close();
                continue;
            }
            catch (UnknownPortException ex1) {
                ex1.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.getAnnullato()) {
            if (indicePorta == -1) {
                this.sceltaCOM.setSelectedIndex(0);
                JOptionPane.showMessageDialog(this, Language.string("Nessun dispositivo trovato"), Language.string("Error"), 0);
                System.out.println("non trovato");
            } else {
                JOptionPane.showMessageDialog(this, Language.string("Dispositivo trovato su ") + this.elenco[indicePorta], Language.string("Info"), 1);
                this.sceltaCOM.setSelectedIndex(indicePorta);
            }
        }
        this.sceltaCOM.setEnabled(true);
        this.okB.setEnabled(true);
        this.cercaB.setEnabled(true);
        this.pannelloPrincipale.remove(this.progressBar);
        this.setSize(new Dimension(500, 110));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.okB)) {
            DanasPreferences.setPrefCom((String)this.sceltaCOM.getSelectedItem());
            System.out.println("porta=" + (String)this.sceltaCOM.getSelectedItem());
            this.dispose();
        }
        if (arg0.getSource().equals(this.annullaB)) {
            this.setAnnullato(true);
            if (this.scansionaPorteThread == null || !this.scansionaPorteThread.isAlive()) {
                this.dispose();
            }
            try {
                if (this.scansionaPorteThread != null) {
                    this.scansionaPorteThread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (arg0.getSource().equals(this.cercaB)) {
            this.sceltaCOM.setEnabled(false);
            this.okB.setEnabled(false);
            this.cercaB.setEnabled(false);
            JOptionPane.showMessageDialog(this, Language.string("Con il miniLAP impostere la modalit\u00e0 'download' prima di procedere"), Language.string("ATTENZIONE"), 1);
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.pannelloPrincipale.add((Component)this.progressBar, "South");
            this.setSize(new Dimension(360, 120));
            this.scansionaPorteThread = new Thread(){

                @Override
                public void run() {
                    COMDialog.this.scansiona();
                }
            };
            this.scansionaPorteThread.start();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        String[] array = new String[]{"COM", "Com2"};
        COMDialog test = new COMDialog((Frame)frame, array);
        test.setVisible(true);
    }
}

