/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.Language;
import i2m.onLine.ChromeSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class AllarmiMarcia
extends JDialog
implements WindowListener,
TableModelListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    JTableX table;
    MyTableModel model;
    JPanel tablePanel;
    JButton resetB;
    JButton applyB;
    ChromeSettingsDialog padre;
    final int maxRpm = 18000;

    public AllarmiMarcia(ChromeSettingsDialog owner) {
        super(owner, Language.string("Configurazione soglie led per ogni marcia"), true);
        this.padre = owner;
        this.costruisciFinestra();
    }

    public void costruisciFinestra() {
        this.setDefaultCloseOperation(2);
        this.model = new MyTableModel();
        this.table = new JTableX(this.model);
        this.table.setFillsViewportHeight(false);
        this.table.getModel().addTableModelListener(this);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(this.table);
        MyTableCellRenderer2 renderer = new MyTableCellRenderer2();
        this.table.setDefaultRenderer(String.class, renderer);
        this.table.setDefaultRenderer(Float.class, renderer);
        this.table.setDefaultRenderer(Integer.class, renderer);
        this.table.setDefaultRenderer(Boolean.class, renderer);
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloTabella = new JPanel(new BorderLayout());
        this.table.getTableHeader().setFont(new Font("Arial", 1, 12));
        JPanel pannelloBottoni = new JPanel();
        this.resetB = new JButton(Language.string("Reset"));
        this.applyB = new JButton(Language.string("Applica"));
        this.resetB.addActionListener(this);
        this.applyB.addActionListener(this);
        pannelloBottoni.add(this.resetB);
        pannelloBottoni.add(this.applyB);
        pannelloTabella.add((Component)this.table.getTableHeader(), "North");
        pannelloTabella.add((Component)this.tablePanel, "Center");
        pannelloPrincipale.add((Component)pannelloTabella, "Center");
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.costruisciTabella();
        this.aggiorna();
        this.setContentPane(pannelloPrincipale);
        this.addWindowListener(this);
        this.pack();
    }

    public void costruisciTabella() {
    }

    public ArrayList<Integer[]> getAllData() {
        return this.model.getAllData();
    }

    public void setValue(int valore, int marcia, int led) {
        this.model.setValueAt(valore, marcia - 1, led);
    }

    public void setValueAt(int valore, int row, int col) {
        this.model.setValueAt(valore, row, col);
    }

    public void aggiorna() {
        this.model.fireTableDataChanged();
    }

    public void refresh() {
        this.table.getModel().removeTableModelListener(this);
        this.aggiorna();
        this.table.getModel().addTableModelListener(this);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int col = e.getColumn();
        int row = e.getFirstRow();
        if (row < 0 || col < 0) {
            return;
        }
        int valore = (Integer)this.table.getModel().getValueAt(row, col);
        if (valore < 0 || valore > 18000) {
            this.table.getModel().setValueAt(0, row, col);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.resetB)) {
            this.model.resetTable(this.padre.getMinRpm(), this.padre.getMaxRpm());
        }
        if (e.getSource().equals(this.applyB)) {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        AllarmiMarcia i = new AllarmiMarcia((ChromeSettingsDialog)null);
        i.setVisible(true);
    }

    public class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        Vector<String> columnNames = new Vector();
        private ArrayList<Integer[]> listaDati = new ArrayList();

        public MyTableModel() {
            this.columnNames.add(Language.string("Gear"));
            this.columnNames.add(Language.string("LED 1"));
            this.columnNames.add(Language.string("LED 2"));
            this.columnNames.add(Language.string("LED 3"));
            this.columnNames.add(Language.string("LED 4"));
            this.columnNames.add(Language.string("LED 5"));
            this.columnNames.add(Language.string("LED 6"));
            this.columnNames.add(Language.string("LED 7"));
            for (int i = 0; i < 6; ++i) {
                Integer[] riga = new Integer[8];
                riga[1] = 6000;
                riga[2] = 6500;
                riga[3] = 7000;
                riga[4] = 7500;
                riga[5] = 8000;
                riga[6] = 8500;
                riga[7] = 9000;
                riga[0] = i + 1;
                this.listaDati.add(riga);
                this.fireTableStructureChanged();
            }
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        public void resetTable(int minRpm, int maxRpm) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.listaDati.get((int)i)[j + 1] = minRpm + j * ((maxRpm - minRpm) / 6);
                }
            }
            this.fireTableDataChanged();
        }

        public ArrayList<Integer[]> getAllData() {
            return this.listaDati;
        }

        @Override
        public int getRowCount() {
            return this.listaDati.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.listaDati.get(row)[col];
        }

        public Class<? extends Object> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.listaDati.get((int)row)[col] = (Integer)value;
            this.fireTableCellUpdated(row, col);
        }
    }

    public class MyTableCellRenderer2
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                this.setBackground(new Color(215, 250, 215));
            } else {
                this.setBackground(Color.white);
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    public class JTableX
    extends JTable {
        public JTableX() {
        }

        public JTableX(TableModel tm) {
            super(tm);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return null;
            }
            return super.getDefaultEditor(this.getClass());
        }
    }
}

