/*
 * Decompiled with CFR 0.152.
 */
package i2m.mappa;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasTable.TableWindow;
import i2m.Language;
import i2m.mappa.Mappa2D;
import i2m.mappa.PuntoTraguardo;
import i2m.traguardi.Circuit;
import java.awt.Color;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;

public class TracciatoTraguardi
extends GObject {
    DefaultListModel elencoTraguardiLM = new DefaultListModel();
    GScene scene;
    boolean modalitaDialog = false;
    double tempoMinimo = 0.0;

    public TracciatoTraguardi() {
        this.elencoTraguardiLM.clear();
        GStyle cerchio = new GStyle();
        cerchio.setLineStyle(5);
        cerchio.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.3f));
        this.setStyle(cerchio);
    }

    public void setTempoMinimo(double tempo) {
        this.tempoMinimo = tempo;
    }

    public double getTempoMinimo() {
        return this.tempoMinimo;
    }

    public void setModalitaDialog() {
        GStyle cerchio = new GStyle();
        cerchio.setLineStyle(5);
        cerchio.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        this.setStyle(cerchio);
        this.modalitaDialog = true;
    }

    public int traguardoVicino(double x, double y, double distanza) {
        if (this.elencoTraguardiLM.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.elencoTraguardiLM.size(); ++i) {
            if (!(Mappa2D.distanza(x, y, ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getX(), ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getY()) < distanza)) continue;
            return i;
        }
        return -1;
    }

    public double[] getTraguardo(int index) {
        double[] coordinate = new double[2];
        if (this.elencoTraguardiLM.size() <= index) {
            return coordinate;
        }
        coordinate[0] = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(index)).getX();
        coordinate[1] = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(index)).getY();
        return coordinate;
    }

    public PuntoTraguardo getPuntoTraguardo(int index) {
        if (this.elencoTraguardiLM.size() <= index) {
            return null;
        }
        return (PuntoTraguardo)this.elencoTraguardiLM.elementAt(index);
    }

    public long getVersoTraguardo(int index) {
        if (this.elencoTraguardiLM.size() < index + 1) {
            return -1L;
        }
        return ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(index)).getVerso();
    }

    public void setVersoTraguardo(int index, long verso) {
        if (this.elencoTraguardiLM.size() < index + 1) {
            return;
        }
        ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(index)).setVerso(verso);
        double y0 = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(index)).getY();
        double x0 = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(index)).getX();
        if (index == 0) {
            DanasDataStructure.getInstance().calcolaGiri(y0, Mappa2D.GeometricaToLatitudine(x0, y0), Mappa2D.dimensioneTraguardo, this.getVersoTraguardo(0), 0, this.tempoMinimo);
        }
        this.aggiornaSplit();
        System.out.println("Ricalcola valorigiri 4");
        DanasDataStructure.getInstance().ricalcolaValoriGiri();
    }

    public void aggiungiTraguardo(GScene scena, Double x0, Double y0) {
        this.scene = scena;
        final long tempoAttesa = System.currentTimeMillis();
        final double xx0 = x0;
        final double yy0 = y0;
        System.out.println("Aggiungo tragiuardo");
        boolean traguardoPresente = false;
        PuntoTraguardo puntoNew = new PuntoTraguardo(x0, y0);
        if (this.elencoTraguardiLM.size() != 0) {
            this.elencoTraguardiLM.removeElementAt(0);
            traguardoPresente = true;
        }
        final boolean traguardoFinale = traguardoPresente;
        this.elencoTraguardiLM.add(0, puntoNew);
        this.tempoMinimo = Double.MIN_VALUE;
        this.refresh();
        this.draw();
        if (this.modalitaDialog) {
            return;
        }
        DanasDataStructure.getInstance().getMainFrame().mostraFinestraRicalcoloVisibile(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DanasDataStructure.getInstance().setDefaultLap(null);
                DanasDataStructure.getInstance().calcolaGiri(yy0, Mappa2D.GeometricaToLatitudine(xx0, yy0), Mappa2D.dimensioneTraguardo, TracciatoTraguardi.this.getVersoTraguardo(0), 0, TracciatoTraguardi.this.tempoMinimo);
                System.out.println("Log:tempo calcolo giri per posizionamento traguardo:" + (double)(System.currentTimeMillis() - tempoAttesa) / 1000.0);
                if (traguardoFinale) {
                    TracciatoTraguardi.this.aggiornaSplit();
                }
                System.out.println("Ricalcola valorigiri 5");
                DanasDataStructure.getInstance().ricalcolaValoriGiri();
                System.out.println("Log:tempo ricalcolo valori giri per posizionamento traguardo:" + (double)(System.currentTimeMillis() - tempoAttesa) / 1000.0);
                DanasDataStructure.getInstance().getMainFrame().mostraFinestraRicalcoloVisibile(false);
            }
        });
    }

    public boolean esisteTraguardo() {
        return this.elencoTraguardiLM.size() != 0;
    }

    public int getNSplit() {
        if (this.elencoTraguardiLM.size() == 0 || this.elencoTraguardiLM.size() == 1) {
            return 0;
        }
        return this.elencoTraguardiLM.size() - 1;
    }

    public void aggiungiTraguardo(GScene scena, Double x0, Double y0, long verso, int sens) {
        this.scene = scena;
        PuntoTraguardo puntoNew = new PuntoTraguardo(x0, y0);
        if (this.elencoTraguardiLM.size() != 0) {
            this.elencoTraguardiLM.removeElementAt(0);
        }
        this.elencoTraguardiLM.add(0, puntoNew);
        ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(0)).setVerso(verso);
        ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(0)).setSensibilita(sens);
        this.refresh();
        this.draw();
        if (!this.modalitaDialog) {
            DanasDataStructure.getInstance().calcolaGiri(y0, Mappa2D.GeometricaToLatitudine(x0, y0), Mappa2D.dimensioneTraguardo, this.getVersoTraguardo(0), 0, this.tempoMinimo);
        }
    }

    public void aggiungiSplit(GScene scena, Double x0, Double y0) {
        if (this.elencoTraguardiLM.size() == 0) {
            JOptionPane.showMessageDialog(null, Language.string("Nessun traguardo impostato, impossibile aggiungere split"), Language.string("ATTENZIONE"), 0);
            return;
        }
        this.scene = scena;
        PuntoTraguardo puntoNew = new PuntoTraguardo(x0, y0);
        this.elencoTraguardiLM.addElement(puntoNew);
        this.refresh();
        this.draw();
        DanasDataStructure.getInstance().calcolaSplit(y0, Mappa2D.GeometricaToLatitudine(x0, y0), Mappa2D.dimensioneTraguardo, this.getVersoTraguardo(this.elencoTraguardiLM.size() - 1), 0);
        System.out.println("Log:Ricalcola valorigiri (aggiungi split)");
        DanasDataStructure.getInstance().ricalcolaValoriGiri();
    }

    public void aggiungiSplit(GScene scena, Double x0, Double y0, long verso, int sens) {
        if (this.elencoTraguardiLM.size() == 0) {
            JOptionPane.showMessageDialog(null, "Nessun traguardo impostato, impossibile aggiungere split", "ATTENZIONE", 0);
            return;
        }
        this.scene = scena;
        PuntoTraguardo puntoNew = new PuntoTraguardo(x0, y0);
        this.elencoTraguardiLM.addElement(puntoNew);
        ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(this.elencoTraguardiLM.size() - 1)).setVerso(verso);
        ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(this.elencoTraguardiLM.size() - 1)).setSensibilita(sens);
        this.refresh();
        this.draw();
        DanasDataStructure.getInstance().calcolaSplit(y0, Mappa2D.GeometricaToLatitudine(x0, y0), Mappa2D.dimensioneTraguardo, this.getVersoTraguardo(this.elencoTraguardiLM.size() - 1), 0);
    }

    public void setScene(GScene scena) {
        this.scene = scena;
    }

    public void rimuoviTutti(GScene scena) {
        if (this.elencoTraguardiLM.size() == 0) {
            return;
        }
        this.elencoTraguardiLM.clear();
        this.tempoMinimo = 0.0;
        DanasDataStructure.getInstance().removeAllLaps();
        this.refresh();
        this.draw();
    }

    public void rimuoviTuttiDialog(GScene scena) {
        if (this.elencoTraguardiLM.size() == 0) {
            return;
        }
        this.elencoTraguardiLM.clear();
        this.tempoMinimo = 0.0;
        this.refresh();
        this.draw();
    }

    public void importaCircuito(GScene scena, Circuit circuito, boolean aggiornaData) {
        int sensibilita = 0;
        if (aggiornaData) {
            this.rimuoviTutti(scena);
        } else {
            this.rimuoviTuttiDialog(scena);
        }
        if (circuito == null || circuito.numeroAttraversamenti() == 0) {
            return;
        }
        for (int i = 0; i < circuito.numeroAttraversamenti(); ++i) {
            double latitudine = circuito.getAttraversamento(i).getLatitudineDecimale();
            double longitudine = circuito.getAttraversamento(i).getLongitudineDecimale();
            sensibilita = circuito.getAttraversamento(i).getSensibilita();
            longitudine = Mappa2D.convertiX(longitudine, latitudine);
            long direzione = -1L;
            if (circuito.getAttraversamento(i).isDirezioneValida()) {
                direzione = circuito.getAttraversamento(i).getDirezione();
            }
            this.tempoMinimo = circuito.getTempoMinimo();
            if (i == 0) {
                this.aggiungiTraguardo(scena, longitudine, latitudine, direzione, sensibilita);
                continue;
            }
            this.aggiungiSplit(scena, longitudine, latitudine, direzione, sensibilita);
        }
        this.refresh();
        this.redraw();
    }

    public float convertiCoordinateDoubleToFloat(double coordinata) {
        long dato = Math.round(coordinata);
        long temp = dato / 10000L;
        long decimillesimi = dato - temp * 10000L;
        long gradi = temp / 60L;
        long primi = temp - gradi * 60L;
        String s = String.format("%03d%02d.%04d", gradi, primi, decimillesimi);
        return Float.valueOf(s).floatValue();
    }

    public Circuit esportaTraguardi(String nome) {
        int direzioneValida = 1;
        int sensibilita = 0;
        if (this.elencoTraguardiLM.size() == 0) {
            return null;
        }
        double longitudine = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(0)).getX();
        double latitudine = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(0)).getY();
        longitudine = Mappa2D.GeometricaToLatitudine(longitudine, latitudine);
        String emisfero = latitudine >= 0.0 ? "N" : "S";
        String versoLatitudine = longitudine >= 0.0 ? "E" : "W";
        longitudine = Math.abs(longitudine);
        latitudine = Math.abs(latitudine);
        int verso = Integer.valueOf(Long.valueOf(((PuntoTraguardo)this.elencoTraguardiLM.elementAt(0)).getVerso()).toString());
        sensibilita = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(0)).getSensibilita();
        if (verso == -1) {
            verso = 0;
            direzioneValida = 0;
        }
        Circuit circuito = new Circuit(nome, this.convertiCoordinateDoubleToFloat(latitudine), emisfero, this.convertiCoordinateDoubleToFloat(longitudine), versoLatitudine, verso, direzioneValida);
        circuito.getAttraversamento(0).setSensibilita(sensibilita);
        if (this.elencoTraguardiLM.size() > 1) {
            for (int i = 1; i < this.elencoTraguardiLM.size(); ++i) {
                direzioneValida = 1;
                longitudine = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getX();
                latitudine = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getY();
                longitudine = Mappa2D.GeometricaToLatitudine(longitudine, latitudine);
                emisfero = latitudine >= 0.0 ? "N" : "S";
                versoLatitudine = longitudine >= 0.0 ? "E" : "W";
                longitudine = Math.abs(longitudine);
                latitudine = Math.abs(latitudine);
                verso = Integer.valueOf(Long.valueOf(((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getVerso()).toString());
                if (verso == -1) {
                    verso = 0;
                    direzioneValida = 0;
                }
                circuito.aggiungiSplit(i, this.convertiCoordinateDoubleToFloat(latitudine), emisfero, this.convertiCoordinateDoubleToFloat(longitudine), versoLatitudine, verso, direzioneValida, 0);
                sensibilita = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getSensibilita();
                circuito.getAttraversamento(i).setSensibilita(sensibilita);
            }
        }
        return circuito;
    }

    public void rimuoviTraguardo(GScene scena, Double x0, Double y0) {
        if (this.elencoTraguardiLM.size() != 0) {
            for (int i = 1; i < this.elencoTraguardiLM.size(); ++i) {
                Double xx = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getX();
                Double yy = ((PuntoTraguardo)this.elencoTraguardiLM.elementAt(i)).getY();
                int[] traguardo = scena.getTransformer().worldToDevice(x0, y0);
                int[] punto = scena.getTransformer().worldToDevice(xx, yy);
                int[] d = this.scene.getTransformer().worldToDevice(x0 + Mappa2D.dimensioneTraguardo, y0 + Mappa2D.dimensioneTraguardo);
                int dimensioneInteraTraguardo = 1;
                dimensioneInteraTraguardo = d[0] - traguardo[0] != 0 ? d[0] - traguardo[0] : d[1] - traguardo[1];
                if (dimensioneInteraTraguardo < 0) {
                    dimensioneInteraTraguardo = -dimensioneInteraTraguardo;
                }
                if (Math.abs(punto[0] - traguardo[0]) >= dimensioneInteraTraguardo || Math.abs(punto[1] - traguardo[1]) >= dimensioneInteraTraguardo) continue;
                this.elencoTraguardiLM.removeElementAt(i);
                --i;
                this.aggiornaSplit();
            }
            this.refresh();
            this.draw();
        }
    }

    public void aggiornaSplit() {
        DanasDataStructure.getInstance().rimuoviAllSplit();
        TableWindow.removeAllSplits();
        int numeroSplit = this.getNSplit();
        for (int j = 1; j <= numeroSplit; ++j) {
            PuntoTraguardo p = (PuntoTraguardo)this.elencoTraguardiLM.elementAt(j);
            double x0Split = p.getX();
            double y0Split = p.getY();
            long versoSplit = p.getVerso();
            DanasDataStructure.getInstance().calcolaSplit(y0Split, Mappa2D.GeometricaToLatitudine(x0Split, y0Split), Mappa2D.dimensioneTraguardo, versoSplit, 0);
            DanasDataStructure.getInstance().ricalcolaValoriGiri();
        }
        if (numeroSplit == 0) {
            DanasDataStructure.getInstance().ricalcolaValoriGiri();
        }
    }

    @Override
    public void draw() {
        this.removeSegments();
        if (this.elencoTraguardiLM.size() != 0) {
            for (int i = 0; i < this.elencoTraguardiLM.size(); ++i) {
                GSegment segmento = new GSegment();
                this.addSegment(segmento);
                PuntoTraguardo punto = (PuntoTraguardo)this.elencoTraguardiLM.getElementAt(i);
                GText text = i == 0 ? new GText("Start", 128) : new GText(String.format("S-%d", i), 128);
                text.setStyle(Mappa2D.textStyle);
                int[] w = this.scene.getTransformer().worldToDevice(punto.getX(), punto.getY());
                int[] d = this.scene.getTransformer().worldToDevice(punto.getX() + Mappa2D.dimensioneTraguardo, punto.getY() + Mappa2D.dimensioneTraguardo);
                int dimensioneInteraTraguardo = d[0] - w[0];
                segmento.setGeometry(Geometry.createCircle(w[0], w[1], dimensioneInteraTraguardo));
                segmento.setText(text);
            }
        }
    }
}

