/*
 * Decompiled with CFR 0.152.
 */
package i2m.mappa;

import i2m.mappa.Mappa2D;
import java.awt.Color;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;

public class Tracciato
extends GObject {
    GObject oggetto;
    GSegment segmento;
    GSegment[] elencoSegmenti;
    GStyle lineStyle;
    double[] xx;
    double[] yy;
    double[] time;
    double[] valore;
    double minimo;
    double massimo;
    double rapporto;
    boolean monocolore;
    Color colore;
    int spessore;
    double valoreMinimo;
    double valoreMassimo;
    String nome = null;

    public Tracciato(double[] x, double[] y, double[] t, double[] val, float min, float max, Color col, boolean singoloColore, String name) {
        this.xx = y;
        this.yy = x;
        this.time = t;
        this.valore = val;
        this.monocolore = singoloColore;
        this.minimo = min;
        this.massimo = max;
        this.colore = col;
        this.nome = name;
        if (this.xx.length == 0 || this.yy.length == 0 || this.xx.length != this.yy.length) {
            return;
        }
        this.valoreMinimo = this.valore[0];
        this.valoreMassimo = this.valore[0];
        for (int i = 0; i < this.xx.length; ++i) {
            this.xx[i] = Mappa2D.convertiX(this.xx[i], this.yy[i]);
            if (this.valore[i] < this.valoreMinimo) {
                this.valoreMinimo = this.valore[i];
            }
            if (!(this.valore[i] > this.valoreMassimo)) continue;
            this.valoreMassimo = this.valore[i];
        }
        this.lineStyle = new GStyle();
        this.lineStyle.setForegroundColor(this.colore);
        this.lineStyle.setBackgroundColor(null);
        this.lineStyle.setLineWidth(Mappa2D.spessoreLinea);
        this.elencoSegmenti = new GSegment[this.xx.length];
        for (int j = 0; j < this.xx.length; ++j) {
            this.elencoSegmenti[j] = new GSegment();
            if (this.monocolore) continue;
            this.addSegment(this.elencoSegmenti[j]);
        }
        this.aggiornaColori();
        this.segmento = new GSegment();
        this.segmento.setStyle(this.lineStyle);
        if (this.monocolore) {
            this.addSegment(this.segmento);
        }
    }

    public double getValoreMinimo() {
        return this.valoreMinimo;
    }

    public double getValoreMassimo() {
        return this.valoreMassimo;
    }

    private void aggiornaColori() {
        for (int j = 0; j < this.xx.length; ++j) {
            GStyle stileSegmento = new GStyle();
            if (this.valore[j] > this.minimo && this.valore[j] < this.massimo) {
                this.rapporto = (this.valore[j] - this.minimo) / (this.massimo - this.minimo);
                this.rapporto = 1.0 - this.rapporto;
                stileSegmento.setForegroundColor(Color.getHSBColor((float)this.rapporto * 0.69f, 1.0f, 1.0f));
            }
            if (this.valore[j] >= this.massimo) {
                stileSegmento.setForegroundColor(Color.getHSBColor(0.0f, 1.0f, 1.0f));
            }
            if (this.valore[j] <= this.minimo) {
                stileSegmento.setForegroundColor(Color.getHSBColor(0.69f, 1.0f, 1.0f));
            }
            stileSegmento.setBackgroundColor(null);
            stileSegmento.setLineWidth(Mappa2D.spessoreLinea);
            this.spessore = Mappa2D.spessoreLinea;
            this.elencoSegmenti[j].setStyle(stileSegmento);
        }
    }

    public void setMinimo(float min) {
        this.minimo = min;
        this.aggiornaColori();
    }

    public void setMassimo(float max) {
        this.massimo = max;
        this.aggiornaColori();
    }

    public void setId(String id) {
        this.nome = id;
    }

    public String getId() {
        return this.nome;
    }

    public void setModoColore(boolean mono) {
        this.removeSegments();
        this.monocolore = mono;
        if (this.monocolore) {
            this.addSegment(this.segmento);
        } else {
            for (int i = 0; i < this.xx.length; ++i) {
                this.addSegment(this.elencoSegmenti[i]);
            }
        }
    }

    public void setColore(Color col) {
        this.colore = col;
        this.lineStyle.setForegroundColor(this.colore);
        this.segmento.setStyle(this.lineStyle);
        this.draw();
    }

    public void print() {
        for (int j = 0; j < this.xx.length; ++j) {
            System.out.println("x=" + this.xx[j] + "y=" + this.yy[j]);
        }
    }

    @Override
    public void draw() {
        if (this.spessore != Mappa2D.spessoreLinea) {
            this.aggiornaColori();
        }
        if (this.lineStyle != null) {
            this.lineStyle.setLineWidth(Mappa2D.spessoreLinea);
            this.segmento.setStyle(this.lineStyle);
        }
        if (this.monocolore) {
            if (this.segmento != null) {
                this.segmento.setGeometry(this.xx, this.yy);
            }
        } else {
            double x0 = this.xx[0];
            double y0 = this.yy[0];
            for (int j = 0; j < this.xx.length; ++j) {
                this.elencoSegmenti[j].setGeometry(x0, y0, this.xx[j], this.yy[j]);
                x0 = this.xx[j];
                y0 = this.yy[j];
            }
        }
    }
}

