/*
 * Decompiled with CFR 0.152.
 */
package i2m.mappa;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasDataStructure.GPSPoint;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.MainFrame;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.grafico.SincronizzatoreGrafico;
import i2m.mappa.BoxDati;
import i2m.mappa.Legenda;
import i2m.mappa.LegendaBox;
import i2m.mappa.PuntoTraguardo;
import i2m.mappa.Serpentello;
import i2m.mappa.Tracciato;
import i2m.mappa.TracciatoTraguardi;
import i2m.mappa.TrattinoCurva;
import i2m.traguardi.Circuit;
import i2m.traguardi.ModificaCircuitiDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GImage;
import no.geosoft.cc.graphics.GInteraction;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GWindow;

public class Mappa2D
implements GInteraction,
MouseWheelListener,
MouseListener,
MouseMotionListener,
ChangeListener,
Printable {
    private Color coloreBackground = Color.black;
    private Color coloreTesto = Color.WHITE;
    public static int spessoreLinea = 2;
    private GWindow window;
    private Component canvas;
    private GScene scene;
    private GObject cerchioPuntamento;
    private GObject selezione;
    private GSegment cerchioPuntamentoSegment;
    private GObject testo;
    private Legenda legendaColore;
    private LegendaBox legendaCanaliBox;
    public static GStyle textStyle;
    private Font fontCarattere;
    private TracciatoTraguardi traguardi;
    private int mode = 5;
    private int canale = 1;
    private int visualizza = 1;
    private int modoColore = 0;
    private boolean autoscaling = false;
    public static final int VISUALIZZA_SESSIONI = 1;
    public static final int VISUALIZZA_GIRI = 2;
    public static final int MODO_COLORE_COLORE = 0;
    public static final int MODO_COLORE_DATI = 1;
    public static final int CANALE_VELOCITA_GPS = 0;
    public static final int CANALE_RPM = 1;
    public static final int CANALE_VEL1 = 2;
    public static final int CANALE_VEL2 = 3;
    public static final int CANALE_ANALOG1 = 4;
    public static final int CANALE_ANALOG2 = 5;
    public static final int CANALE_ANALOG3 = 6;
    public static final int CANALE_ANALOG4 = 7;
    public static final int CANALE_ANALOG5 = 8;
    public static final int CANALE_ANALOG6 = 9;
    public static final int CANALE_DVELOCITA_GPS = 10;
    public static final int CANALE_DRPM = 11;
    public static final int CANALE_DVEL1 = 12;
    public static final int CANALE_DVEL2 = 13;
    public static final int CANALE_DANALOG1 = 14;
    public static final int CANALE_DANALOG2 = 15;
    public static final int CANALE_DANALOG3 = 16;
    public static final int CANALE_DANALOG4 = 17;
    public static final int CANALE_DANALOG5 = 18;
    public static final int CANALE_DANALOG6 = 19;
    public static final int CANALE_MARCE = 20;
    public static final int CANALE_RATIO_MARCE = 21;
    public static final int POSIZIONA_SPLIT = 1;
    public static final int POSIZIONA_TRAGUARDO = 10;
    public static final int ZOOM_WINDOW = 2;
    public static final int ZOOM_IN = 3;
    public static final int ZOOM_OUT = 4;
    public static final int MUOVI = 5;
    public static final int RIMUOVI_SPLIT = 6;
    public static final int CURSORE = 7;
    public static final int RIGHELLO = 8;
    public static final int VERSO = 9;
    public static Double dimensioneTraguardo;
    private int x0;
    private int y0;
    private double xRighello0;
    private double yRighello0;
    private Vector<Tracciato> elencoTracciati;
    private DanasDataStructure dati;
    private double posizioneCursoreAttualeX = 0.0;
    private double posizioneCursoreAttualeY = 0.0;
    private double posizioneCursoreProssimoX = 0.0;
    private double posizioneCursoreProssimoY = 0.0;
    private double tempoAttualeCursore = 0.0;
    private double angoloCursore = 0.0;
    private Cursore cursor;
    private Righello metro;
    private ImmagineSfondo sfondoPista;
    private float minimoLegenda = 0.0f;
    private float massimoLegenda = 100.0f;
    private FrecciaVerso freccia = new FrecciaVerso(0.0, 0.0, 0L);
    private TestoAiuto aiutoVerso = new TestoAiuto(Language.string("Tasto dx per aggiungere/rimuovere"));
    private boolean mostraLegenda = true;
    private SincronizzatoreMappaGraficoVideo multiSincro = null;
    long angoloVisualizzatoVerso = -1L;
    private MainFrame padre;
    private int angoloRotazione = 0;
    boolean popupAttivo = false;
    boolean vistaTrattini = false;
    boolean vistaTrattiniSpeciali = false;
    boolean sfondoMaps = false;
    private SincronizzatoreGrafico sincro;
    private ZoomBuffer zb;
    public int i = 0;
    public int tempo = 0;
    public int lastTime = 0;
    public boolean isRunning = false;
    private FrecciaVerso[] elencoFrecce;
    private TrattinoCurva[] elencoTrattiniInizio;
    private TrattinoCurva[] elencoTrattiniFine;
    private BoxDati[] elencoBoxDati;
    private PuntoTraguardo[] coordinateBox;
    private int boxVicino = -1;
    private DanasDataStructureConstants.ValueType canaleRiga1 = DanasDataStructureConstants.ValueType.RPM;
    private DanasDataStructureConstants.ValueType canaleRiga2 = DanasDataStructureConstants.ValueType.VEL_GPS;
    private DanasDataStructureConstants.ValueType canaleRiga3 = DanasDataStructureConstants.ValueType.GEARS;
    private DanasDataStructureConstants.ValueType canaleRiga4 = DanasDataStructureConstants.ValueType.ANALOG2;
    private DanasDataStructureConstants.ValueType canaleRiga5 = DanasDataStructureConstants.ValueType.ANALOG3;
    private boolean analizzaCurve = true;
    private boolean cercaMinimi = true;
    private Serpentello serpentello;
    long tempoClick = 0L;
    int Xzoom = 0;
    int Yzoom = 0;
    int notchesZoom = 0;
    boolean zoomBufferPieno = false;
    int bufferZoomValue = 0;
    int bufferZoomNotches = 0;
    Thread zoomThread = null;
    public static int latitudineAttuale;
    boolean traslazioneInCorso = false;
    boolean mappaTraguardiDialog = false;
    ModificaCircuitiDialog circuitDialog;

    public Mappa2D(DanasDataStructure ds, MainFrame owner) {
        this.padre = owner;
        this.window = new GWindow(this.coloreBackground);
        this.scene = new GScene(this.window);
        this.scene.shouldWorldExtentFitViewport(false);
        this.scene.shouldZoomOnResize(false);
        this.canvas = this.window.getCanvas();
        this.canvas.addMouseWheelListener(this);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.dati = ds;
        this.elencoTracciati = ds != null ? this.dati.getTracciatoSelected(DanasDataStructureConstants.ValueType.SPEED2, this.modoColore == 0) : new Vector();
        this.cerchioPuntamento = new GObject();
        GStyle interaction = new GStyle();
        interaction.setLineStyle(5);
        interaction.setBackgroundColor(new Color(1.0f, 0.0f, 0.0f, 0.7f));
        this.cerchioPuntamento.setStyle(interaction);
        this.cerchioPuntamentoSegment = new GSegment();
        this.cerchioPuntamento.addSegment(this.cerchioPuntamentoSegment);
        this.scene.add(this.cerchioPuntamento);
        this.cerchioPuntamento.toFront();
        this.selezione = new GObject();
        GStyle selezioneStyle = new GStyle();
        selezioneStyle.setLineStyle(new float[]{10.0f, 10.0f});
        selezioneStyle.setForegroundColor(Color.WHITE);
        selezioneStyle.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.4f));
        this.selezione.setStyle(selezioneStyle);
        this.scene.add(this.selezione);
        this.selezione.toFront();
        this.sfondoPista = new ImmagineSfondo();
        this.sfondoPista.toBack();
        textStyle = new GStyle();
        textStyle.setForegroundColor(this.coloreTesto);
        textStyle.setBackgroundColor(null);
        this.fontCarattere = new Font("Dialog", 1, 14);
        textStyle.setFont(this.fontCarattere);
        this.testo = new GObject();
        this.scene.add(this.testo);
        this.traguardi = new TracciatoTraguardi();
        this.serpentello = new Serpentello();
        if (DanasDataStructure.getInstance().mostraSerpentello()) {
            this.scene.add(this.serpentello);
        }
        this.serpentello.toBack();
        this.scene.add(this.traguardi);
        this.traguardi.toFront();
        this.cursor = new Cursore(this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY, 0.0);
        this.legendaColore = new Legenda(this.scene);
        this.minimoLegenda = this.legendaColore.getValoreMinimo();
        this.massimoLegenda = this.legendaColore.getValoreMassimo();
        if (this.modoColore == 1 && this.mostraLegenda) {
            this.scene.add(this.legendaColore);
            if (this.legendaCanaliBox != null) {
                this.legendaCanaliBox.setLegendaAffiancata(this.modoColore == 1 && this.mostraLegenda);
            }
        }
        this.metro = new Righello(0.0, 0.0, 0.0, 0.0);
        this.metro.toFront();
        this.scene.setWorldExtent(0.0, 0.0, 1000.0, 1000.0);
        this.aggiornaTracciati();
        this.window.startInteraction(this);
        this.refresh();
        if (this.dati != null) {
            this.dati.addChangeListener(this);
        }
        this.zb = new ZoomBuffer();
    }

    public void aggiungiSincronizzazione(SincronizzatoreMappaGraficoVideo sincro) {
        this.multiSincro = sincro;
        this.multiSincro.addChangeListener(this);
    }

    public void rimuoviSincronizzatore(SincronizzatoreMappaGraficoVideo sincro) {
        sincro.removeChangeListener(this);
        this.multiSincro = null;
    }

    public void aggiungiSincronizzatore(SincronizzatoreGrafico sincro) {
        this.sincro = sincro;
        sincro.addChangeListener(this);
    }

    public void aggiornaTracciati() {
        this.serpentello.aggiornaDati();
        if (this.visualizza == 1) {
            this.scegliSessioniVisibili();
        } else {
            this.scegliGiriVisibili();
        }
    }

    public void setMappaTracciatiDialog(boolean isTracciatiDialog, ModificaCircuitiDialog padre) {
        this.mappaTraguardiDialog = isTracciatiDialog;
        this.traguardi.setModalitaDialog();
        this.circuitDialog = padre;
    }

    public boolean isModalit\u00e0GoogleMaps() {
        return this.sfondoMaps;
    }

    public void attivaModalitaGoogleMaps(boolean attiva) {
        if (attiva) {
            if (this.sfondoMaps) {
                return;
            }
            this.sfondoMaps = attiva;
            this.scene.add(this.sfondoPista);
            this.sfondoPista.toBack();
            this.sfondoPista.ricaricaImmagineSfondo();
        } else {
            DanasDataStructure.getInstance().getMainFrame().getContenitoreMappa().setCursor(Cursor.getPredefinedCursor(0));
            if (!this.sfondoMaps) {
                return;
            }
            this.sfondoMaps = attiva;
            this.scene.remove(this.sfondoPista);
            this.refresh();
        }
    }

    public int getNumeroTracciati() {
        return this.elencoTracciati.size();
    }

    public void aggiornaMostraSerpentello() {
        if (DanasDataStructure.getInstance().mostraSerpentello()) {
            this.scene.add(this.serpentello);
            double start = this.sincro.getMin();
            double stop = this.sincro.getMax();
            this.serpentello.estraiParte(start, stop);
        } else {
            this.scene.remove(this.serpentello);
        }
        this.refresh();
    }

    public void aggiornaSerpentello() {
        this.serpentello.aggiornaDati();
        this.refresh();
    }

    public void scegliSessioniVisibili() {
        boolean fitta = false;
        if (this.elencoTracciati.size() == 0) {
            fitta = true;
        }
        this.scene.removeAll();
        if (this.sfondoMaps) {
            this.scene.add(this.sfondoPista);
            this.sfondoPista.toBack();
        }
        this.elencoTracciati.clear();
        if (this.dati == null) {
            return;
        }
        this.elencoTracciati = this.dati.getTracciatoSelected(0);
        for (int i = 0; i < this.elencoTracciati.size(); ++i) {
            if (this.elencoTracciati.elementAt(i) == null) continue;
            this.scene.add(this.elencoTracciati.elementAt(i));
        }
        if (this.elencoTracciati.size() != 0) {
            if (DanasDataStructure.getInstance().mostraSerpentello()) {
                this.scene.add(this.serpentello);
            }
            this.serpentello.toBack();
        }
        if (this.getMode() == 1 || this.getMode() == 6 || this.getMode() == 10) {
            this.scene.add(this.cerchioPuntamento);
        }
        this.scene.add(this.selezione);
        this.scene.add(this.testo);
        this.scene.add(this.traguardi);
        if (this.mode == 7) {
            this.scene.add(this.cursor);
        }
        if (this.modoColore == 1 && this.mostraLegenda) {
            this.scene.add(this.legendaColore);
            if (this.legendaCanaliBox != null) {
                this.legendaCanaliBox.setLegendaAffiancata(this.modoColore == 1 && this.mostraLegenda);
            }
        }
        if (this.vistaTrattini) {
            this.mostraTrattiniCurve(true);
        }
        if (this.vistaTrattiniSpeciali) {
            this.mostraDatiSpeciali(true);
        }
        if (this.elencoTracciati.size() != 0 & fitta) {
            this.centraMappa();
        }
        this.refresh();
    }

    public boolean getVistaTrattini() {
        return this.vistaTrattini;
    }

    public void aggiungiTracciatoSessione(String id) {
        Tracciato newSess;
        boolean fitta = false;
        if (this.elencoTracciati.size() == 0) {
            fitta = true;
        }
        if ((newSess = this.dati.getTracciato(DanasDataStructureConstants.ValueType.VEL_GPS, Integer.valueOf(id), true)) == null) {
            return;
        }
        this.elencoTracciati.add(newSess);
        this.scene.add(newSess);
        if (this.elencoTracciati.size() != 0 & fitta) {
            this.centraMappa();
        }
        this.refresh();
    }

    public void mostraVersi(boolean mostra) {
        if (mostra) {
            this.elencoFrecce = new FrecciaVerso[this.traguardi.getNSplit() + 1];
            for (int i = 0; i <= this.traguardi.getNSplit(); ++i) {
                long angoloGradi = this.traguardi.getVersoTraguardo(i);
                double[] xyVerso = this.traguardi.getTraguardo(i);
                this.elencoFrecce[i] = new FrecciaVerso(xyVerso[0], xyVerso[1], angoloGradi);
                this.scene.add(this.elencoFrecce[i]);
                this.elencoFrecce[i].toFront();
                this.elencoFrecce[i].draw();
            }
        } else {
            for (int i = 0; i < this.elencoFrecce.length; ++i) {
                this.scene.remove(this.elencoFrecce[i]);
            }
        }
        this.refresh();
    }

    public void setVistaTrattini(boolean attiva) {
        this.vistaTrattini = attiva;
        this.mostraTrattiniCurve(attiva);
    }

    public void setVistaDatiSpeciali(boolean attiva) {
        this.vistaTrattiniSpeciali = attiva;
        this.mostraDatiSpeciali(attiva);
    }

    public boolean getTrattiniSpeciali() {
        return this.vistaTrattiniSpeciali;
    }

    public void setParametriVistaTrattini(boolean analizzaMinimi, boolean analizzaCurva, DanasDataStructureConstants.ValueType chiave, DanasDataStructureConstants.ValueType linea2, DanasDataStructureConstants.ValueType linea3, DanasDataStructureConstants.ValueType linea4, DanasDataStructureConstants.ValueType linea5) {
        this.canaleRiga1 = chiave;
        this.canaleRiga2 = linea2;
        this.canaleRiga3 = linea3;
        this.canaleRiga4 = linea4;
        this.canaleRiga5 = linea5;
        this.analizzaCurve = analizzaCurva;
        this.cercaMinimi = analizzaMinimi;
    }

    public void setParametroBox(DanasDataStructureConstants.ValueType canale, int posizione) {
        switch (posizione) {
            case 1: {
                this.canaleRiga1 = canale;
                break;
            }
            case 2: {
                this.canaleRiga2 = canale;
                break;
            }
            case 3: {
                this.canaleRiga3 = canale;
                break;
            }
            case 4: {
                this.canaleRiga4 = canale;
                break;
            }
            case 5: {
                this.canaleRiga5 = canale;
            }
        }
        DanasPreferences.setPrefCanaleBox(posizione, canale.ordinal());
    }

    public void mostraTrattiniCurve(boolean mostra) {
        DanasLap ref = DanasDataStructure.getInstance().getDefaultLap();
        if (ref == null) {
            return;
        }
        ref.calcolaInizioFineCurve();
        List<Integer> inizio = ref.getElencoIndiciInizioCurva();
        List<Integer> fine = ref.getElencoIndiciFineCurva();
        if (mostra) {
            int i;
            this.rimuoviTrattiniBox();
            this.elencoTrattiniInizio = new TrattinoCurva[inizio.size()];
            this.elencoTrattiniFine = new TrattinoCurva[fine.size()];
            for (i = 0; i < this.elencoTrattiniInizio.length; ++i) {
                this.elencoTrattiniInizio[i] = ref.getTrattino(inizio.get(i), true, i + 1);
                this.elencoTrattiniInizio[i].setScene(this.scene);
                this.scene.add(this.elencoTrattiniInizio[i]);
                this.elencoTrattiniInizio[i].toFront();
                this.elencoTrattiniInizio[i].draw();
            }
            for (i = 0; i < this.elencoTrattiniFine.length; ++i) {
                this.elencoTrattiniFine[i] = ref.getTrattino(fine.get(i), false, i + 1);
                this.elencoTrattiniFine[i].setScene(this.scene);
                this.scene.add(this.elencoTrattiniFine[i]);
                this.elencoTrattiniFine[i].toFront();
                this.elencoTrattiniFine[i].draw();
            }
            this.calcolaBoxDati();
            this.posizionaBoxDati();
            this.aggiornaLegendaBox();
        } else {
            this.rimuoviTrattiniBox();
            this.scene.add(this.traguardi);
            this.traguardi.toFront();
        }
        this.refresh();
    }

    public void aggiornaLegendaBox() {
        if (this.legendaCanaliBox != null) {
            this.scene.remove(this.legendaCanaliBox);
        }
        this.legendaCanaliBox = new LegendaBox();
        this.legendaCanaliBox.setLegendaAffiancata(this.modoColore == 1 && this.mostraLegenda);
        this.legendaCanaliBox.setColoreSfondo(this.coloreBackground);
        this.legendaCanaliBox.setScene(this.scene);
        this.legendaCanaliBox.setTextLinea(1, this.padre.getColoreCanale(this.canaleRiga1), this.padre.getNomeAsse(this.canaleRiga1));
        this.legendaCanaliBox.setTextLinea(2, this.padre.getColoreCanale(this.canaleRiga2), this.padre.getNomeAsse(this.canaleRiga2));
        this.legendaCanaliBox.setTextLinea(3, this.padre.getColoreCanale(this.canaleRiga3), this.padre.getNomeAsse(this.canaleRiga3));
        this.legendaCanaliBox.setTextLinea(4, this.padre.getColoreCanale(this.canaleRiga4), this.padre.getNomeAsse(this.canaleRiga4));
        this.legendaCanaliBox.setTextLinea(5, this.padre.getColoreCanale(this.canaleRiga5), this.padre.getNomeAsse(this.canaleRiga5));
        this.scene.add(this.legendaCanaliBox);
        this.scene.remove(this.traguardi);
    }

    public void mostraDatiSpeciali(boolean mostra) {
        DanasLap ref = DanasDataStructure.getInstance().getDefaultLap();
        if (ref == null) {
            return;
        }
        if (mostra) {
            int[] elenco = DanasDataStructure.getElencoDistanze();
            if (elenco == null) {
                return;
            }
            this.calcolaBoxSpeciali(elenco);
            this.posizionaBoxDati();
            this.aggiornaLegendaBox();
        } else {
            this.rimuoviTrattiniBox();
            this.scene.add(this.traguardi);
            this.traguardi.toFront();
        }
        this.refresh();
    }

    public void rimuoviTrattiniBox() {
        int i;
        if (this.elencoTrattiniInizio != null) {
            for (i = 0; i < this.elencoTrattiniInizio.length; ++i) {
                this.scene.remove(this.elencoTrattiniInizio[i]);
            }
        }
        if (this.elencoTrattiniFine != null) {
            for (i = 0; i < this.elencoTrattiniFine.length; ++i) {
                this.scene.remove(this.elencoTrattiniFine[i]);
            }
        }
        if (this.elencoBoxDati != null) {
            for (i = 0; i < this.elencoBoxDati.length; ++i) {
                this.scene.remove(this.elencoBoxDati[i]);
            }
        }
        if (this.legendaCanaliBox != null) {
            this.scene.remove(this.legendaCanaliBox);
        }
    }

    public void posizionaBoxDati() {
        if (this.coordinateBox == null || this.coordinateBox.length != this.elencoBoxDati.length) {
            this.coordinateBox = new PuntoTraguardo[this.elencoBoxDati.length];
            for (int i = 0; i < this.elencoBoxDati.length; ++i) {
                this.coordinateBox[i] = new PuntoTraguardo(this.elencoBoxDati[i].getFineX(), this.elencoBoxDati[i].getFineY());
            }
        } else {
            for (int i = 0; i < this.elencoBoxDati.length; ++i) {
                this.elencoBoxDati[i].setPosizioneBox(this.coordinateBox[i].getX(), this.coordinateBox[i].getY());
            }
        }
    }

    public void calcolaBoxDati() {
        DanasLap ref = DanasDataStructure.getInstance().getDefaultLap();
        if (ref == null) {
            return;
        }
        DanasSession sess = ref.getSession();
        if (this.canaleRiga1 == DanasDataStructureConstants.ValueType.DELAY) {
            return;
        }
        if (this.canaleRiga1 == null) {
            return;
        }
        if (this.elencoBoxDati != null) {
            for (int i = 0; i < this.elencoBoxDati.length; ++i) {
                this.scene.remove(this.elencoBoxDati[i]);
            }
        }
        List<Integer> inizio = ref.getElencoIndiciInizioCurva();
        List<Integer> fine = ref.getElencoIndiciFineCurva();
        int indiceGpsStart = ref.getStartIndexGPS();
        if (this.analizzaCurve) {
            this.elencoBoxDati = new BoxDati[fine.size()];
            for (int i = 0; i < fine.size(); ++i) {
                double timeStart = sess.getTimeAtIndex(DanasDataStructureConstants.ValueType.VEL_GPS, indiceGpsStart + inizio.get(i));
                double timeStop = sess.getTimeAtIndex(DanasDataStructureConstants.ValueType.VEL_GPS, indiceGpsStart + fine.get(i));
                double tempoTrovato = this.getTimeRicerca(timeStart, timeStop, sess);
                this.aggiungiBox(i, tempoTrovato, sess);
            }
        } else {
            double tempoTrovato;
            double timeStop;
            this.elencoBoxDati = new BoxDati[fine.size()];
            if (fine.size() >= 2) {
                for (int i = 0; i < fine.size() - 1; ++i) {
                    double timeStart = sess.getTimeAtIndex(DanasDataStructureConstants.ValueType.VEL_GPS, indiceGpsStart + fine.get(i));
                    timeStop = sess.getTimeAtIndex(DanasDataStructureConstants.ValueType.VEL_GPS, indiceGpsStart + inizio.get(i + 1));
                    tempoTrovato = this.getTimeRicerca(timeStart, timeStop, sess);
                    this.aggiungiBox(i, tempoTrovato, sess);
                }
            }
            double timeStart = ref.getStart();
            timeStop = sess.getTimeAtIndex(DanasDataStructureConstants.ValueType.VEL_GPS, indiceGpsStart + inizio.get(0));
            double tempoTrovato1 = this.getTimeRicerca(timeStart, timeStop, sess);
            timeStart = sess.getTimeAtIndex(DanasDataStructureConstants.ValueType.VEL_GPS, indiceGpsStart + fine.get(fine.size() - 1));
            timeStop = ref.getEnd();
            double tempoTrovato2 = this.getTimeRicerca(timeStart, timeStop, sess);
            double val1 = sess.getDatoAtTime(this.canaleRiga1, tempoTrovato1, DanasDataStructureConstants.BoundLap.NEAREST, true);
            double val2 = sess.getDatoAtTime(this.canaleRiga1, tempoTrovato2, DanasDataStructureConstants.BoundLap.NEAREST, true);
            tempoTrovato = this.cercaMinimi ? (val1 <= val2 ? tempoTrovato1 : tempoTrovato2) : (val1 >= val2 ? tempoTrovato1 : tempoTrovato2);
            this.aggiungiBox(this.elencoBoxDati.length - 1, tempoTrovato, sess);
        }
    }

    public void calcolaBoxSpeciali(int[] distanze) {
        int i;
        DanasLap ref = DanasDataStructure.getInstance().getDefaultLap();
        if (ref == null) {
            return;
        }
        DanasSession sess = ref.getSession();
        if (this.canaleRiga1 == DanasDataStructureConstants.ValueType.DELAY) {
            return;
        }
        if (this.canaleRiga1 == null) {
            return;
        }
        if (this.elencoBoxDati != null) {
            for (i = 0; i < this.elencoBoxDati.length; ++i) {
                this.scene.remove(this.elencoBoxDati[i]);
            }
        }
        this.elencoBoxDati = new BoxDati[distanze.length];
        for (i = 0; i < distanze.length; ++i) {
            this.aggiungiBox(i, sess.getTimeAtSpazio((double)distanze[i] + ref.getDistanzaInizio(), DanasDataStructureConstants.BoundLap.NEAREST), sess);
        }
    }

    private void aggiungiBox(int indice, double time, DanasSession sess) {
        double y = sess.getDatoAtTime(DanasDataStructureConstants.ValueType.LAT, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
        double x = sess.getDatoAtTime(DanasDataStructureConstants.ValueType.LONG, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
        x = Mappa2D.convertiX(x, y);
        this.elencoBoxDati[indice] = new BoxDati(x, y);
        this.elencoBoxDati[indice].setScene(this.scene);
        this.scene.add(this.elencoBoxDati[indice]);
        this.elencoBoxDati[indice].toFront();
        this.elencoBoxDati[indice].draw();
        this.elencoBoxDati[indice].setTextLinea(1, this.padre.getColoreCanale(this.canaleRiga1), this.getStringaBox(sess, time, this.canaleRiga1));
        this.elencoBoxDati[indice].setTextLinea(2, this.padre.getColoreCanale(this.canaleRiga2), this.getStringaBox(sess, time, this.canaleRiga2));
        this.elencoBoxDati[indice].setTextLinea(3, this.padre.getColoreCanale(this.canaleRiga3), this.getStringaBox(sess, time, this.canaleRiga3));
        this.elencoBoxDati[indice].setTextLinea(4, this.padre.getColoreCanale(this.canaleRiga4), this.getStringaBox(sess, time, this.canaleRiga4));
        this.elencoBoxDati[indice].setTextLinea(5, this.padre.getColoreCanale(this.canaleRiga5), this.getStringaBox(sess, time, this.canaleRiga5));
        this.elencoBoxDati[indice].setColoreSfondo(this.coloreBackground);
        this.elencoBoxDati[indice].setColore(this.coloreTesto);
    }

    public String getStringaBox(DanasSession sess, double time, DanasDataStructureConstants.ValueType canale) {
        String s = "0";
        if (canale == null) {
            return "0";
        }
        double valore = sess.getDatoAtTime(canale, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
        s = valore > 10000.0 ? String.format("%.0f", valore) : (valore > 1000.0 ? String.format("%.1f", valore) : String.format("%.2f", valore));
        return s;
    }

    public double getTimeRicerca(double startTime, double endTime, DanasSession sess) {
        double timeTrovato = startTime;
        double valoreRiferimento = sess.getDatoAtTime(this.canaleRiga1, startTime, DanasDataStructureConstants.BoundLap.NEAREST, true);
        for (double j = startTime; j < endTime; j += sess.getRisoluzioneTemporale()) {
            double valore = sess.getDatoAtTime(this.canaleRiga1, j, DanasDataStructureConstants.BoundLap.NEAREST, true);
            if (this.cercaMinimi && valore < valoreRiferimento) {
                valoreRiferimento = valore;
                timeTrovato = j;
            }
            if (this.cercaMinimi || !(valore > valoreRiferimento)) continue;
            valoreRiferimento = valore;
            timeTrovato = j;
        }
        return timeTrovato;
    }

    public void aggiungiTracciatoGiri(String id) {
        boolean fitta = false;
        String[] sessioniGiri = id.split("-");
        if (this.elencoTracciati.size() == 0) {
            fitta = true;
        }
        Tracciato newSess = this.dati.getTracciatoLap(MeasuresUtil.getValueType(this.canale), Integer.valueOf(sessioniGiri[0]), Integer.valueOf(sessioniGiri[1]));
        this.elencoTracciati.add(newSess);
        this.scene.add(newSess);
        if (this.modoColore == 1) {
            if (this.elencoTracciati.size() < 6) {
                newSess.setModoColore(false);
                newSess.setMinimo(this.minimoLegenda);
                newSess.setMassimo(this.massimoLegenda);
            } else {
                this.setModoColore(0);
                this.aggiornaTracciati();
            }
        }
        if (this.elencoTracciati.size() != 0 & fitta) {
            this.centraMappa();
        }
        this.refresh();
    }

    public void rimuoviTracciato(String id) {
        Tracciato oldSess = null;
        if (this.elencoTracciati.size() == 0) {
            return;
        }
        System.out.println("DEBUG: num tracciati=" + this.elencoTracciati.size());
        for (int i = 0; i < this.elencoTracciati.size(); ++i) {
            if (this.elencoTracciati.elementAt(i) == null || !this.elencoTracciati.elementAt(i).getId().equals(id)) continue;
            oldSess = this.elencoTracciati.elementAt(i);
            this.scene.remove(oldSess);
            this.elencoTracciati.remove(i);
        }
        if (this.elencoTracciati.size() == 0) {
            this.scene.remove(this.serpentello);
        }
        this.refresh();
    }

    public float getMinimoLegenda() {
        return this.minimoLegenda;
    }

    public float getMassimoLegenda() {
        return this.massimoLegenda;
    }

    public void calcolaMinMaxLegenda() {
        if (this.elencoTracciati.size() == 0) {
            return;
        }
        double min = this.elencoTracciati.firstElement().getValoreMinimo();
        double max = this.elencoTracciati.firstElement().getValoreMassimo();
        for (int i = 0; i < this.elencoTracciati.size(); ++i) {
            if (this.elencoTracciati.elementAt(i).getValoreMinimo() < min) {
                min = this.elencoTracciati.elementAt(i).getValoreMinimo();
            }
            if (!(this.elencoTracciati.elementAt(i).getValoreMassimo() > max)) continue;
            max = this.elencoTracciati.elementAt(i).getValoreMassimo();
        }
        this.minimoLegenda = Mappa2D.getNumeroPulito((float)min);
        this.massimoLegenda = Mappa2D.getNumeroPulito((float)max);
    }

    public static float getNumeroPulito(float valore) {
        int numeroZeri = 3;
        if (valore == 0.0f) {
            return 0.0f;
        }
        int nz = (int)Math.log10(Math.abs(valore));
        if (Math.abs(valore) >= 1.0f) {
            float value = valore * (float)Math.pow(10.0, numeroZeri - nz);
            int valInt = (int)value;
            value = (float)((double)valInt * Math.pow(10.0, nz - numeroZeri));
            return value;
        }
        float value = valore * (float)Math.pow(10.0, numeroZeri + 1 - nz);
        int valInt = (int)value;
        value = (float)((double)valInt / Math.pow(10.0, numeroZeri + 1 - nz));
        return value;
    }

    public boolean esisteTraguardo() {
        return this.traguardi.esisteTraguardo();
    }

    public PuntoTraguardo getPuntoTraguardo(int index) {
        return this.traguardi.getPuntoTraguardo(index);
    }

    public int getNSplit() {
        return this.traguardi.getNSplit();
    }

    public void scegliGiriVisibili() {
        boolean fitta = false;
        if (this.elencoTracciati.size() == 0) {
            fitta = true;
        }
        this.scene.removeAll();
        if (this.sfondoMaps) {
            this.scene.add(this.sfondoPista);
            this.sfondoPista.toBack();
        }
        this.elencoTracciati.clear();
        this.elencoTracciati = this.dati.getTracciatoSelectedLap(this.canale);
        if (this.autoscaling && this.modoColore == 1) {
            this.calcolaMinMaxLegenda();
            this.legendaColore.setValoreMinimo(Float.valueOf(this.minimoLegenda));
            this.legendaColore.setValoreMassimo(Float.valueOf(this.massimoLegenda));
            this.legendaColore.draw();
        }
        for (int i = 0; i < this.elencoTracciati.size(); ++i) {
            if (this.elencoTracciati.elementAt(i) == null) continue;
            this.scene.add(this.elencoTracciati.elementAt(i));
            if (this.modoColore != 1) continue;
            if (this.elencoTracciati.size() < 6) {
                this.elencoTracciati.elementAt(i).setModoColore(false);
                this.elencoTracciati.elementAt(i).setMinimo(this.minimoLegenda);
                this.elencoTracciati.elementAt(i).setMassimo(this.massimoLegenda);
                continue;
            }
            this.setModoColore(0);
        }
        if (this.elencoTracciati.size() != 0) {
            if (DanasDataStructure.getInstance().mostraSerpentello()) {
                this.scene.add(this.serpentello);
            }
            this.serpentello.toBack();
        }
        if (this.getMode() == 1 || this.getMode() == 6 || this.getMode() == 10) {
            this.scene.add(this.cerchioPuntamento);
        }
        this.scene.add(this.selezione);
        this.scene.add(this.testo);
        this.scene.add(this.traguardi);
        if (this.mode == 7) {
            this.scene.add(this.cursor);
        }
        if (this.modoColore == 1 && this.mostraLegenda) {
            this.scene.add(this.legendaColore);
            if (this.legendaCanaliBox != null) {
                this.legendaCanaliBox.setLegendaAffiancata(this.modoColore == 1 && this.mostraLegenda);
            }
        }
        if (this.vistaTrattini) {
            this.mostraTrattiniCurve(true);
        }
        if (this.vistaTrattiniSpeciali) {
            this.mostraDatiSpeciali(true);
        }
        if (this.elencoTracciati.size() != 0 && fitta) {
            this.centraMappa();
        }
        this.refresh();
    }

    public void aggiornaGradazioneColore(float min, float max) {
        int i;
        if (this.elencoTracciati.size() == 0) {
            return;
        }
        if (this.minimoLegenda != min) {
            for (i = 0; i < this.elencoTracciati.size(); ++i) {
                this.elencoTracciati.elementAt(i).setMinimo(min);
            }
        }
        if (this.massimoLegenda != max) {
            for (i = 0; i < this.elencoTracciati.size(); ++i) {
                this.elencoTracciati.elementAt(i).setMassimo(max);
            }
        }
    }

    public int getNumeroOggetti() {
        return this.elencoTracciati.size();
    }

    public double calcolaAngolo(double x1, double y1, double x2, double y2) {
        if (x1 == x2 && y1 == y2) {
            return 0.0;
        }
        if (x1 == x2) {
            if (y2 > y1) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        double res = Math.atan2(y2 - y1, x2 - x1);
        if (res >= 0.0) {
            return res;
        }
        return res + Math.PI * 2;
    }

    public static double distanza(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double convertiX(double x, double y) {
        double conversioneGradiRad = 2.908882086657216E-8;
        int latiIntera = (int)(y / 600000.0);
        if (Math.abs(latiIntera - latitudineAttuale) > 2) {
            latitudineAttuale = latiIntera;
        }
        return x * Math.cos((double)(latitudineAttuale * 600000) * conversioneGradiRad);
    }

    public static double convertiIndietroX(double x, double y) {
        double conversioneGradiRad = 2.908882086657216E-8;
        int latiIntera = (int)(y / 600000.0);
        if (Math.abs(latiIntera - latitudineAttuale) > 2) {
            latitudineAttuale = latiIntera;
        }
        return x / Math.cos((double)(latitudineAttuale * 600000) * conversioneGradiRad);
    }

    public static double GeometricaToLatitudine(double x, double y) {
        double conversioneGradiRad = 2.908882086657216E-8;
        int latiIntera = (int)(y / 600000.0);
        if (Math.abs(latiIntera - latitudineAttuale) > 2) {
            latitudineAttuale = latiIntera;
        }
        return x / Math.cos((double)(latitudineAttuale * 600000) * conversioneGradiRad);
    }

    public static long distanzaGeografica(double x1, double y1, double x2, double y2) {
        double raggioTerra = 6371010.0;
        double conversioneGradiRad = 2.908882086657216E-8;
        double y = (y2 - y1) * raggioTerra * conversioneGradiRad;
        double x = (x2 - x1) * conversioneGradiRad * raggioTerra;
        double d = Math.sqrt(x * x + y * y);
        return Math.round(d);
    }

    public static double distanzaGeograficaDouble(double x1, double y1, double x2, double y2) {
        double raggioTerra = 6371010.0;
        double conversioneGradiRad = 2.908882086657216E-8;
        double y = (y2 - y1) * raggioTerra * conversioneGradiRad;
        double x = (x2 - x1) * raggioTerra * conversioneGradiRad;
        double d = Math.sqrt(x * x + y * y);
        return d;
    }

    public void setPosizioneCursore(double tempo) {
        this.angoloCursore = 0.0;
        if (this.getModoVisualizzazioni() == 2 && this.dati.getDefaultLap() == null) {
            return;
        }
        if (this.getModoVisualizzazioni() == 1 && this.dati.getDefaultSession() == null) {
            return;
        }
        if (tempo < 0.0) {
            tempo = 0.0;
        }
        double TempoSessione = tempo * 100.0;
        if (this.getModoVisualizzazioni() == 2 && TempoSessione >= this.dati.getDefaultLap().getDuration() / 10.0) {
            TempoSessione = this.dati.getDefaultLap().getDuration() / 10.0;
            tempo = TempoSessione / 100.0;
        }
        if (this.getModoVisualizzazioni() == 1 && TempoSessione >= this.dati.getDefaultSession().getEndTelemetryTime() - this.dati.getDefaultSession().getStartTelemetryTime()) {
            TempoSessione = this.dati.getDefaultSession().getEndTelemetryTime() - this.dati.getDefaultSession().getStartTelemetryTime();
            tempo = TempoSessione / 100.0;
        }
        if (this.getModoVisualizzazioni() == 1) {
            if (this.dati.getDefaultSession().getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) == 0) {
                return;
            }
            int indiceUltimoPunto = this.dati.getDefaultSession().getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) - 1;
            int indiceAttualeCursore = this.dati.getDefaultSession().getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, TempoSessione += this.dati.getDefaultSession().getStartTelemetryTime().doubleValue(), DanasDataStructureConstants.BoundLap.NEAREST);
            this.posizioneCursoreAttualeX = this.dati.getDefaultSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indiceAttualeCursore);
            this.posizioneCursoreAttualeY = this.dati.getDefaultSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indiceAttualeCursore);
            int j = -1;
            while (indiceAttualeCursore + ++j <= indiceUltimoPunto && Mappa2D.distanza(this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY, this.dati.getDefaultSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indiceAttualeCursore + j), this.dati.getDefaultSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indiceAttualeCursore + j)) == 0.0) {
            }
            if (indiceAttualeCursore + j <= indiceUltimoPunto) {
                this.posizioneCursoreProssimoX = this.dati.getDefaultSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indiceAttualeCursore + j);
                this.posizioneCursoreProssimoY = this.dati.getDefaultSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indiceAttualeCursore + j);
                this.angoloCursore = this.calcolaAngolo(this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY, this.posizioneCursoreProssimoX, this.posizioneCursoreProssimoY);
            }
        }
        if (this.getModoVisualizzazioni() == 2) {
            if (this.dati.getDefaultLap().getNumPuntiGps() == 0) {
                return;
            }
            TempoSessione += this.dati.getDefaultLap().getStart();
            double tempoUltimoPunto = this.dati.getDefaultLap().getTempoFineGps();
            double tempoPrimoPunto = this.dati.getDefaultLap().getTempoInizioGps();
            if (TempoSessione > tempoUltimoPunto) {
                TempoSessione = tempoUltimoPunto;
            }
            if (TempoSessione < tempoPrimoPunto) {
                TempoSessione = tempoPrimoPunto;
            }
            int indiceUltimoPunto = this.dati.getDefaultLap().getSession().getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, tempoUltimoPunto, DanasDataStructureConstants.BoundLap.NEAREST);
            int indiceAttualeCursore = this.dati.getDefaultLap().getSession().getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, TempoSessione, DanasDataStructureConstants.BoundLap.NEAREST);
            this.posizioneCursoreAttualeX = this.dati.getDefaultLap().getSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indiceAttualeCursore);
            this.posizioneCursoreAttualeY = this.dati.getDefaultLap().getSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indiceAttualeCursore);
            int j = -1;
            while (indiceAttualeCursore + ++j <= indiceUltimoPunto && Mappa2D.distanza(this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY, this.dati.getDefaultLap().getSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indiceAttualeCursore + j), this.dati.getDefaultLap().getSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indiceAttualeCursore + j)) == 0.0) {
            }
            if (indiceAttualeCursore + j <= indiceUltimoPunto) {
                this.posizioneCursoreProssimoX = this.dati.getDefaultLap().getSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indiceAttualeCursore + j);
                this.posizioneCursoreProssimoY = this.dati.getDefaultLap().getSession().getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indiceAttualeCursore + j);
                this.angoloCursore = this.calcolaAngolo(this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY, this.posizioneCursoreProssimoX, this.posizioneCursoreProssimoY);
            }
        }
        this.cursor.setCursore(this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY, this.angoloCursore);
        this.tempoAttualeCursore = tempo;
    }

    public double controllaTempo(double t) {
        if (t < 0.0) {
            t = 0.0;
        }
        if (this.getModoVisualizzazioni() == 2 && this.dati.getDefaultLap() == null) {
            return t;
        }
        if (this.getModoVisualizzazioni() == 1 && this.dati.getDefaultSession() == null) {
            return t;
        }
        if (this.getModoVisualizzazioni() == 2 && t >= this.dati.getDefaultLap().getDuration() / 10.0) {
            t = this.dati.getDefaultLap().getDuration() / 10.0;
        }
        if (this.getModoVisualizzazioni() == 1 && t >= this.dati.getDefaultSession().getEndTelemetryTime() - this.dati.getDefaultSession().getStartTelemetryTime()) {
            t = this.dati.getDefaultSession().getEndTelemetryTime() - this.dati.getDefaultSession().getStartTelemetryTime();
        }
        return t;
    }

    public double getPosizioneCursore() {
        return this.tempoAttualeCursore;
    }

    public void centraMappaGoogle(double latitudine, double longitudine) {
        double delta = 1500.0;
        double miny = latitudine - delta;
        double maxy = latitudine + delta;
        double minx = Mappa2D.convertiX(longitudine - delta, latitudine);
        double maxx = Mappa2D.convertiX(longitudine + delta, latitudine);
        double[] w0 = new double[3];
        double[] w1 = new double[3];
        double[] w2 = new double[3];
        w0[2] = 0.0;
        w1[2] = 0.0;
        w2[2] = 0.0;
        this.scene.setWorldExtent(minx - 0.02 * (maxx - minx), miny - 0.02 * (maxy - miny), 1.04 * (maxx - minx), 1.04 * (maxy - miny));
        this.sfondoPista.ricaricaImmagineSfondo();
    }

    public void centraMappa() {
        if (this.elencoTracciati.size() == 0) {
            return;
        }
        GPSPoint[] estremi = this.dati.getGPSBound();
        if (estremi == null) {
            return;
        }
        if (estremi[0] != null && estremi[1] != null && estremi[2] != null && estremi[3] != null) {
            GPSPoint north = estremi[0];
            GPSPoint east = estremi[1];
            GPSPoint south = estremi[2];
            GPSPoint west = estremi[3];
            double miny = south.getLat();
            double maxy = north.getLat();
            double minx = Mappa2D.convertiX(west.getLon(), west.getLat());
            double maxx = Mappa2D.convertiX(east.getLon(), east.getLat());
            double[] w0 = new double[3];
            double[] w1 = new double[3];
            double[] w2 = new double[3];
            w0[2] = 0.0;
            w1[2] = 0.0;
            w2[2] = 0.0;
            switch (this.angoloRotazione) {
                case 90: {
                    w0[0] = maxx + 0.02 * (maxx - minx);
                    w0[1] = miny - 0.02 * (maxy - miny);
                    w1[0] = w0[0];
                    w1[1] = w0[1] + 1.04 * (maxy - miny);
                    w2[0] = minx - 0.02 * (maxx - minx);
                    w2[1] = miny - 0.02 * (maxy - miny);
                    this.scene.setWorldExtent(w0, w1, w2);
                    break;
                }
                case -90: {
                    w0[0] = minx - 0.02 * (maxx - minx);
                    w0[1] = maxy + 0.02 * (maxy - miny);
                    w1[0] = w0[0];
                    w1[1] = miny - 0.02 * (maxy - miny);
                    w2[0] = maxx + 0.02 * (maxx - minx);
                    w2[1] = maxy + 0.02 * (maxy - miny);
                    this.scene.setWorldExtent(w0, w1, w2);
                    break;
                }
                case 180: {
                    w0[0] = maxx + 0.02 * (maxx - minx);
                    w0[1] = maxy + 0.02 * (maxy - miny);
                    w1[0] = minx - 0.02 * (maxx - minx);
                    w1[1] = maxy + 0.02 * (maxy - miny);
                    w2[0] = maxx + 0.02 * (maxx - minx);
                    w2[1] = miny - 0.02 * (maxy - miny);
                    this.scene.setWorldExtent(w0, w1, w2);
                    break;
                }
                default: {
                    this.scene.setWorldExtent(minx - 0.02 * (maxx - minx), miny - 0.02 * (maxy - miny), 1.04 * (maxx - minx), 1.04 * (maxy - miny));
                }
            }
            this.sfondoPista.ricaricaImmagineSfondo();
        }
    }

    public void setCanale(int can) {
        this.canale = can;
    }

    public int getCanale() {
        return this.canale;
    }

    public void setMinimoLegenda(float min) {
        if (min == this.minimoLegenda) {
            return;
        }
        this.legendaColore.setValoreMinimo(Float.valueOf(min));
        this.aggiornaGradazioneColore(min, this.massimoLegenda);
        this.minimoLegenda = min;
        if (this.modoColore == 1 && this.mostraLegenda) {
            this.legendaColore.draw();
        }
    }

    public void setMassimoLegenda(float max) {
        if (max == this.massimoLegenda) {
            return;
        }
        this.legendaColore.setValoreMassimo(Float.valueOf(max));
        this.aggiornaGradazioneColore(this.minimoLegenda, max);
        this.massimoLegenda = max;
        if (this.modoColore == 1 && this.mostraLegenda) {
            this.legendaColore.draw();
        }
    }

    public void importaTraguardi(Circuit circuito) {
        this.traguardi.importaCircuito(this.scene, circuito, true);
        this.traguardi.setTempoMinimo(circuito.getTempoMinimo());
    }

    public void importaTraguardiDialog(Circuit circuito) {
        this.mostraVersi(false);
        this.traguardi.importaCircuito(this.scene, circuito, false);
        this.traguardi.setTempoMinimo(circuito.getTempoMinimo());
        this.scene.add(this.traguardi);
        this.traguardi.toFront();
        this.mostraVersi(true);
    }

    public double getTempoMinimo() {
        return this.traguardi.getTempoMinimo();
    }

    public Circuit esportaTraguardi() {
        return this.traguardi.esportaTraguardi("circuito");
    }

    public void refresh() {
        if (this.padre != null && this.padre.isMenuSelected()) {
            return;
        }
        this.scene.redraw();
        this.scene.refresh();
    }

    private void refreshScene() {
        if (this.padre != null && this.padre.isMenuSelected()) {
            return;
        }
        this.scene.refresh();
    }

    public Component getMappa() {
        return this.window.getCanvas();
    }

    public GWindow getWindow() {
        return this.window;
    }

    public void stampa() {
        try {
            this.window.saveAsPng(new File("testStampa3Java.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setModoColore(int modocolore) {
        this.modoColore = modocolore;
        if (this.modoColore == 1) {
            if (this.mostraLegenda) {
                this.scene.add(this.legendaColore);
            }
        } else {
            this.scene.remove(this.legendaColore);
        }
        if (this.legendaCanaliBox != null) {
            this.legendaCanaliBox.setLegendaAffiancata(this.modoColore == 1 && this.mostraLegenda);
        }
    }

    public int getModoColore() {
        return this.modoColore;
    }

    public void setMode(int modo) {
        this.mode = modo;
        if (this.mode == 7) {
            this.scene.add(this.cursor);
            this.tempoAttualeCursore = 0.0;
            if (this.multiSincro != null) {
                this.setPosizioneCursore(this.multiSincro.getPosizioneCursore() / 100.0);
            }
        } else {
            this.scene.remove(this.cursor);
        }
        if (this.mode != 1 && this.mode != 6 && this.mode != 10) {
            this.scene.remove(this.cerchioPuntamento);
        }
        if (this.mode != 8) {
            this.scene.remove(this.metro);
        }
        if (this.mode != 9) {
            this.scene.remove(this.freccia);
            this.scene.remove(this.aiutoVerso);
        } else {
            this.scene.add(this.aiutoVerso);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public int getModoVisualizzazioni() {
        return this.visualizza;
    }

    public void setAutoscaling(boolean auto) {
        this.autoscaling = auto;
    }

    public void setLegendaVisibile(boolean visibile) {
        this.mostraLegenda = visibile;
        if (this.modoColore != 1) {
            return;
        }
        if (visibile) {
            this.scene.add(this.legendaColore);
        } else {
            this.scene.remove(this.legendaColore);
        }
        if (this.legendaCanaliBox != null) {
            this.legendaCanaliBox.setLegendaAffiancata(this.modoColore == 1 && this.mostraLegenda);
        }
        this.refreshScene();
    }

    public void zoomPoint(int x, int y, double zoom) {
        this.scene.zoom(x, y, zoom);
        this.refreshScene();
    }

    public void setModoVisualizzazione(int modoVisualizzazione) {
        this.visualizza = modoVisualizzazione;
        if (this.getMode() == 7) {
            try {
                this.setPosizioneCursore(this.multiSincro.getPosizioneCursore() / 100.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refresh();
        }
    }

    public void setDimensioneTraguardo(Double dim) {
        dimensioneTraguardo = 2.7 * dim;
    }

    public double getDimensioneTraguardo() {
        return dimensioneTraguardo / 2.7;
    }

    public void setDimensioneCarattere(int dim) {
        this.fontCarattere = new Font("Dialog", 1, dim);
        textStyle.setFont(this.fontCarattere);
    }

    public int getDimensioneCarattere() {
        return this.fontCarattere.getSize();
    }

    public void rimuoviTuttiTraguardi() {
        this.traguardi.rimuoviTutti(this.scene);
        this.traguardi.setTempoMinimo(0.0);
    }

    public void rimuoviTuttiTraguardiDialog() {
        this.traguardi.rimuoviTuttiDialog(this.scene);
        this.traguardi.setTempoMinimo(0.0);
    }

    public void setBackgroundColor(Color backColor) {
        if (backColor != this.coloreBackground) {
            DanasDataStructure.getInstance().getMainFrame().spegniModalitaMaps();
            DefaultListModel<GObject> elencoOggettiLM = new DefaultListModel<GObject>();
            elencoOggettiLM.clear();
            if (this.scene.getNChildren() != 0) {
                for (int i = 0; i < this.scene.getNChildren(); ++i) {
                    elencoOggettiLM.addElement(this.scene.getChild(i));
                }
            }
            double[] w0 = this.scene.getWorldExtent().get(0);
            double[] w1 = this.scene.getWorldExtent().get(1);
            double[] w2 = this.scene.getWorldExtent().get(2);
            this.scene.removeAll();
            if (this.elencoTracciati.size() != 0) {
                if (DanasDataStructure.getInstance().mostraSerpentello()) {
                    this.scene.add(this.serpentello);
                }
                this.serpentello.toBack();
            }
            this.coloreBackground = backColor;
            this.window = new GWindow(this.coloreBackground);
            this.canvas = this.window.getCanvas();
            this.canvas.addMouseWheelListener(this);
            this.canvas.addMouseListener(this);
            this.canvas.addMouseMotionListener(this);
            this.scene = new GScene(this.window);
            this.scene.shouldWorldExtentFitViewport(false);
            this.scene.shouldZoomOnResize(false);
            if (elencoOggettiLM.size() != 0) {
                for (int i = 0; i < elencoOggettiLM.size(); ++i) {
                    this.scene.add((GObject)elencoOggettiLM.elementAt(i));
                }
            }
            this.scene.setWorldExtent(w0, w1, w2);
            this.traguardi.setScene(this.scene);
            this.scene.redraw();
            this.window.startInteraction(this);
        }
    }

    public void ruotaMappa(int gradi) {
        switch (gradi) {
            case -90: {
                this.angoloRotazione = -90;
                break;
            }
            case 90: {
                this.angoloRotazione = 90;
                break;
            }
            case 180: {
                this.angoloRotazione = 180;
                break;
            }
            default: {
                this.angoloRotazione = 0;
            }
        }
        this.centraMappa();
    }

    public void setPopUFalse() {
        this.popupAttivo = false;
    }

    public Color getBackgroundColor() {
        return this.coloreBackground;
    }

    public void setLineWidth(int spessore) {
        spessoreLinea = spessore;
    }

    public int getLineWidth() {
        return spessoreLinea;
    }

    public void setColoreTesto(Color textColor) {
        if (textColor != this.coloreTesto) {
            this.coloreTesto = textColor;
            textStyle.setForegroundColor(this.coloreTesto);
            this.scene.redraw();
        }
    }

    public Color getColoreTesto() {
        return this.coloreTesto;
    }

    @Override
    public void event(GScene scene_, int event, int x, int y) {
        if (this.zoomThread != null && this.zoomThread.isAlive()) {
            Mappa2D mappa2D = this;
            if (!mappa2D.zoomThread.interrupted()) {
                return;
            }
        }
        if (event == 3) {
            long tempoAttuale = System.currentTimeMillis();
            if (this.tempoClick != 0L && tempoAttuale - this.tempoClick < 200L) {
                if (DanasDataStructure.getInstance().mostraSerpentello()) {
                    DanasDataStructure.getInstance().getMainFrame().setMostraSerpentello(false);
                } else {
                    DanasDataStructure.getInstance().getMainFrame().setMostraSerpentello(true);
                }
                return;
            }
        }
        if (event == 5) {
            this.tempoClick = System.currentTimeMillis();
        }
        if (event == 16 && !this.popupAttivo) {
            this.scene.remove(this.cerchioPuntamento);
            this.traguardi.toFront();
            this.refreshScene();
            return;
        }
        if (event == 3 && this.popupAttivo) {
            this.popupAttivo = false;
            return;
        }
        if (event == 13) {
            if (!this.traslazioneInCorso && !this.mappaTraguardiDialog) {
                DanasDataStructure.getInstance().getMainFrame().mostraPopupMappa(x, y);
                this.popupAttivo = true;
            }
            this.traslazioneInCorso = false;
        }
        block1 : switch (this.mode) {
            case 7: {
                if (event == 4) {
                    double[] w2 = this.scene.getTransformer().deviceToWorld(x, y);
                    w2[0] = Mappa2D.GeometricaToLatitudine(w2[0], w2[1]);
                    double distanzaPuntoAttuale = Mappa2D.distanza(w2[0], w2[1], this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY);
                    double distanzaPuntoProssimo = Mappa2D.distanza(w2[0], w2[1], this.posizioneCursoreProssimoX, this.posizioneCursoreProssimoY);
                    double distanzaDuePunti = Mappa2D.distanza(this.posizioneCursoreAttualeX, this.posizioneCursoreAttualeY, this.posizioneCursoreProssimoX, this.posizioneCursoreProssimoY);
                    if (distanzaPuntoAttuale < 6.0 * dimensioneTraguardo && distanzaPuntoAttuale > distanzaDuePunti) {
                        if (distanzaPuntoProssimo < distanzaPuntoAttuale) {
                            if (this.multiSincro.getAggionrnaMappaGrafico()) {
                                this.multiSincro.setPosizioneCursore(this.controllaTempo((this.tempoAttualeCursore + 1.0) * 100.0));
                                this.multiSincro.setAggiornaPosizioneCursore(true);
                            }
                        } else if (this.multiSincro.getAggionrnaMappaGrafico()) {
                            this.multiSincro.setPosizioneCursore(this.controllaTempo((this.tempoAttualeCursore - 1.0) * 100.0));
                            this.multiSincro.setAggiornaPosizioneCursore(true);
                        }
                        this.refreshScene();
                    }
                }
                if (event == 11) {
                    this.x0 = x;
                    this.y0 = y;
                    break;
                }
                if (event != 12) break;
                this.scene.pan(x - this.x0, y - this.y0);
                this.sfondoPista.aggiornaSfondo();
                this.refreshScene();
                this.x0 = x;
                this.y0 = y;
                this.traslazioneInCorso = true;
                break;
            }
            case 9: {
                this.scene.remove(this.cerchioPuntamento);
                long angoloGradi = this.angoloVisualizzatoVerso;
                double[] w5 = this.scene.getTransformer().deviceToWorld(x, y);
                int res = this.traguardi.traguardoVicino(w5[0], w5[1], 2.0 * dimensioneTraguardo);
                this.scene.remove(this.freccia);
                if (res != -1) {
                    if (event != 5) {
                        angoloGradi = this.traguardi.getVersoTraguardo(res);
                    }
                    double[] xyVerso = this.traguardi.getTraguardo(res);
                    if (event == 11) {
                        this.traslazioneInCorso = true;
                        if (this.traguardi.getVersoTraguardo(res) == -1L) {
                            this.traguardi.setVersoTraguardo(res, 0L);
                        } else {
                            this.traguardi.setVersoTraguardo(res, -1L);
                        }
                    }
                    if (event == 4 && this.traguardi.getVersoTraguardo(res) != -1L) {
                        double angolo = this.calcolaAngolo(xyVerso[0], xyVerso[1], w5[0], w5[1]);
                        angoloGradi = Math.round(angolo * 180.0 / Math.PI);
                    }
                    this.freccia = new FrecciaVerso(xyVerso[0], xyVerso[1], angoloGradi);
                    this.angoloVisualizzatoVerso = angoloGradi;
                    this.scene.add(this.freccia);
                    this.freccia.toFront();
                    this.freccia.draw();
                } else {
                    this.angoloVisualizzatoVerso = -1L;
                }
                this.refreshScene();
                if (event != 5 || this.angoloVisualizzatoVerso == -1L) break;
                this.traguardi.setVersoTraguardo(res, this.angoloVisualizzatoVerso);
                this.angoloVisualizzatoVerso = -1L;
                break;
            }
            case 6: {
                switch (event) {
                    case 2: {
                        if (this.popupAttivo) break;
                        this.scene.add(this.cerchioPuntamento);
                        double[] w1 = this.scene.getTransformer().deviceToWorld(x, y);
                        int[] d = this.scene.getTransformer().worldToDevice(w1[0] + dimensioneTraguardo, w1[1] + dimensioneTraguardo);
                        int dimensioneInteraTraguardo = 1;
                        dimensioneInteraTraguardo = d[0] - x != 0 ? d[0] - x : d[1] - y;
                        if (dimensioneInteraTraguardo < 0) {
                            dimensioneInteraTraguardo = -dimensioneInteraTraguardo;
                        }
                        this.cerchioPuntamentoSegment.setGeometry(Geometry.createRectangle(x - dimensioneInteraTraguardo, y - dimensioneInteraTraguardo, 2 * dimensioneInteraTraguardo, 2 * dimensioneInteraTraguardo));
                        this.refreshScene();
                        break;
                    }
                    case 3: {
                        double[] w = this.scene.getTransformer().deviceToWorld(x, y);
                        this.traguardi.rimuoviTraguardo(this.scene, w[0], w[1]);
                        this.refreshScene();
                    }
                }
                break;
            }
            case 1: 
            case 10: {
                switch (event) {
                    case 2: {
                        if (this.popupAttivo) break;
                        this.scene.add(this.cerchioPuntamento);
                        double[] w1 = this.scene.getTransformer().deviceToWorld(x, y);
                        int[] d = this.scene.getTransformer().worldToDevice(w1[0] + dimensioneTraguardo, w1[1] + dimensioneTraguardo);
                        int dimensionePixelTraguardo = 1;
                        dimensionePixelTraguardo = d[0] - x != 0 ? d[0] - x : d[1] - y;
                        if (dimensionePixelTraguardo < 0) {
                            dimensionePixelTraguardo = -dimensionePixelTraguardo;
                        }
                        this.cerchioPuntamentoSegment.setGeometry(Geometry.createCircle(x, y, dimensionePixelTraguardo));
                        this.traguardi.toFront();
                        this.refreshScene();
                        break;
                    }
                    case 3: {
                        try {
                            double[] w = scene_.getTransformer().deviceToWorld(x, y);
                            if (this.mappaTraguardiDialog) {
                                this.circuitDialog.modificaTraguardoAttuale(Mappa2D.convertiIndietroX(w[0], w[1]), w[1]);
                                return;
                            }
                            if (this.mode == 10) {
                                this.traguardi.aggiungiTraguardo(this.scene, w[0], w[1]);
                            }
                            if (this.mode == 1) {
                                this.traguardi.aggiungiSplit(this.scene, w[0], w[1]);
                            }
                            this.refreshScene();
                            break;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
            case 2: {
                switch (event) {
                    case 3: {
                        this.x0 = x;
                        this.y0 = y;
                        this.selezione.addSegment(new GSegment());
                        break;
                    }
                    case 5: {
                        this.selezione.removeSegments();
                        this.scene.zoom(this.x0, this.y0, x, y);
                        this.sfondoPista.aggiornaSfondo();
                        this.refreshScene();
                        break;
                    }
                    case 4: {
                        int[] xSelezione = new int[]{this.x0, x, x, this.x0, this.x0};
                        int[] ySelezione = new int[]{this.y0, this.y0, y, y, this.y0};
                        GSegment segmentoSelezione = this.selezione.getSegment();
                        segmentoSelezione.setGeometry(xSelezione, ySelezione);
                        this.refreshScene();
                    }
                }
                break;
            }
            case 8: {
                switch (event) {
                    case 3: {
                        double[] w3 = scene_.getTransformer().deviceToWorld(x, y);
                        this.xRighello0 = w3[0];
                        this.yRighello0 = w3[1];
                        this.scene.add(this.metro);
                        this.sfondoPista.toBack();
                        break;
                    }
                    case 4: {
                        double[] w4 = scene_.getTransformer().deviceToWorld(x, y);
                        this.scene.remove(this.metro);
                        this.metro = new Righello(this.xRighello0, this.yRighello0, w4[0], w4[1]);
                        this.scene.add(this.metro);
                        this.sfondoPista.toBack();
                        this.metro.draw();
                        this.refreshScene();
                    }
                }
                break;
            }
            case 4: {
                if (event != 3) break;
                this.scene.zoom(x, y, 1.3);
                this.sfondoPista.aggiornaSfondo();
                this.refreshScene();
                break;
            }
            case 3: {
                if (event != 3) break;
                this.scene.zoom(x, y, 0.7);
                this.sfondoPista.aggiornaSfondo();
                this.refreshScene();
                break;
            }
            case 5: {
                switch (event) {
                    case 3: {
                        if (this.elencoBoxDati != null) {
                            for (int i = 0; i < this.elencoBoxDati.length; ++i) {
                                int[] d = this.scene.getTransformer().worldToDevice(this.elencoBoxDati[i].getFineX(), this.elencoBoxDati[i].getFineY());
                                if (x - d[0] <= 0 || x - d[0] >= 50 || y - d[1] <= 0 || y - d[1] >= 75) continue;
                                this.x0 = x;
                                this.y0 = y;
                                this.boxVicino = i;
                                return;
                            }
                        }
                        this.boxVicino = -1;
                        this.x0 = x;
                        this.y0 = y;
                        break block1;
                    }
                    case 4: {
                        if (this.boxVicino == -1) {
                            this.scene.pan(x - this.x0, y - this.y0);
                            this.refreshScene();
                            this.sfondoPista.aggiornaSfondo();
                            this.x0 = x;
                            this.y0 = y;
                            return;
                        }
                        double[] w = this.scene.getTransformer().deviceToWorld(x, y);
                        double[] w1 = this.scene.getTransformer().deviceToWorld(this.x0, this.y0);
                        this.elencoBoxDati[this.boxVicino].trasla(w[0] - w1[0], w[1] - w1[1]);
                        this.refreshScene();
                        break block1;
                    }
                    case 5: {
                        if (this.boxVicino == -1) {
                            return;
                        }
                        this.elencoBoxDati[this.boxVicino].consolidaPosizioneBox();
                        this.coordinateBox[this.boxVicino] = new PuntoTraguardo(this.elencoBoxDati[this.boxVicino].getFineX(), this.elencoBoxDati[this.boxVicino].getFineY());
                        this.refreshScene();
                    }
                }
            }
        }
    }

    public void aggiornaSfondoMaps() {
        if (!this.sfondoMaps) {
            return;
        }
        this.sfondoPista.aggiornaSfondo();
    }

    public void zoomWheel() {
        if (this.getMode() == 5) {
            if (this.notchesZoom < 0) {
                this.zoomPoint(this.Xzoom, this.Yzoom, 0.85);
                this.sfondoPista.aggiornaSfondo();
            } else {
                this.zoomPoint(this.Xzoom, this.Yzoom, 1.15);
                this.sfondoPista.aggiornaSfondo();
            }
            if (this.zoomBufferPieno) {
                if (this.bufferZoomNotches < 0) {
                    this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(0.9, this.bufferZoomValue));
                    this.sfondoPista.aggiornaSfondo();
                } else {
                    this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(1.1, this.bufferZoomValue));
                    this.sfondoPista.aggiornaSfondo();
                }
            }
            this.zoomBufferPieno = false;
            this.bufferZoomValue = 0;
            this.bufferZoomNotches = 0;
        }
        if (this.getMode() == 7) {
            if (this.notchesZoom < 0) {
                if (this.multiSincro.getAggionrnaMappaGrafico()) {
                    this.multiSincro.setPosizioneCursore(this.controllaTempo(this.tempoAttualeCursore + 2.0) * 100.0);
                    this.multiSincro.setAggiornaPosizioneCursore(true);
                }
            } else if (this.multiSincro.getAggionrnaMappaGrafico()) {
                this.multiSincro.setPosizioneCursore(this.controllaTempo(this.tempoAttualeCursore - 2.0) * 100.0);
                this.multiSincro.setAggiornaPosizioneCursore(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.getMode() != 5) {
            if (this.getMode() != 7) return;
        }
        try {
            if (event.getWheelRotation() == 0) {
                return;
            }
            if (this.zoomThread != null && this.zoomThread.isAlive()) {
                Mappa2D mappa2D = this;
                if (!mappa2D.zoomThread.interrupted()) {
                    this.bufferZoomNotches += event.getWheelRotation();
                    ++this.bufferZoomValue;
                    this.zoomBufferPieno = true;
                    return;
                }
            }
            this.zoomBufferPieno = false;
            this.bufferZoomValue = 0;
            this.bufferZoomNotches = 0;
            this.notchesZoom = event.getWheelRotation();
            this.Xzoom = event.getX();
            this.Yzoom = event.getY();
            this.zoomThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Mappa2D.this.zoomWheel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            this.zoomThread.start();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource().equals(this.sincro) && DanasDataStructure.getInstance().mostraSerpentello()) {
            double start = this.sincro.getMin();
            double stop = this.sincro.getMax();
            this.serpentello.estraiParte(start, stop);
            this.refresh();
        }
        if (arg0.getSource().equals(this.multiSincro) && this.getMode() == 7) {
            if (DanasDataStructure.getInstance().getMainFrame().getFftMode()) {
                return;
            }
            if (this.tempoAttualeCursore * 100.0 == this.multiSincro.getPosizioneCursore()) {
                return;
            }
            this.setPosizioneCursore(this.multiSincro.getPosizioneCursore() / 100.0);
            this.refresh();
            return;
        }
        if (arg0.getSource().equals(DanasDataStructure.getInstance())) {
            if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_REF_SESSION || this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_REF_LAP) {
                if (this.multiSincro != null) {
                    this.setPosizioneCursore(this.multiSincro.getPosizioneCursore() / 100.0);
                }
                this.aggiornaTracciati();
                DanasDataStructure.getInstance().getMainFrame().getContenitoreMappa().aggiornaNomi();
                this.refresh();
                return;
            }
            if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.NEW_DATA) {
                DanasDataStructure.getInstance().getMainFrame().getContenitoreMappa().getNomiDaSettare();
                DanasDataStructure.getInstance().getMainFrame().getContenitoreMappa().aggiornaNomi();
            }
            if (this.visualizza == 1) {
                if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SEL_SESSION) {
                    this.aggiungiTracciatoSessione(this.dati.getChangeParameter());
                } else if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.DESEL_SESSION) {
                    this.rimuoviTracciato(this.dati.getChangeParameter());
                } else if (this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.DESEL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_ALL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.DESEL_ALL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.ADD_SPLIT && this.dati.getChange() != DanasDataStructureConstants.ChangeType.REMOVE_SPLIT && this.dati.getChange() != DanasDataStructureConstants.ChangeType.NOTES && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SET_REF_SESSION && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SET_REF_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SET_GOAL && this.dati.getChange() != DanasDataStructureConstants.ChangeType.LAP_COLOR) {
                    this.aggiornaTracciati();
                }
            } else {
                if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SEL_LAP) {
                    this.aggiungiTracciatoGiri(this.dati.getChangeParameter());
                } else if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.DESEL_LAP) {
                    this.rimuoviTracciato(this.dati.getChangeParameter());
                } else if (this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_SESSION && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_ALL_SESSION && this.dati.getChange() != DanasDataStructureConstants.ChangeType.NOTES && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SET_REF_SESSION && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SET_REF_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SESSION_COLOR) {
                    this.aggiornaTracciati();
                    System.out.println("Aggiorno tracciati mappa dopo");
                }
                if (MeasuresUtil.getValueType(this.canale) == DanasDataStructureConstants.ValueType.DELAY) {
                    this.aggiornaTracciati();
                    this.calcolaMinMaxLegenda();
                    this.minimoLegenda = (float)(Math.rint((double)this.minimoLegenda * 100.0) / 100.0);
                    this.massimoLegenda = (float)(Math.rint((double)this.massimoLegenda * 100.0) / 100.0);
                    this.legendaColore.setValoreMinimo(Float.valueOf(this.minimoLegenda));
                    this.legendaColore.setValoreMassimo(Float.valueOf(this.massimoLegenda));
                    this.legendaColore.draw();
                    this.refresh();
                }
            }
        }
    }

    @Override
    public int print(Graphics arg0, PageFormat arg1, int arg2) throws PrinterException {
        return 0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        DanasDataStructure.getInstance().getMainFrame().startDragMappa((int)e.getPoint().getX(), (int)e.getPoint().getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        DanasDataStructure.getInstance().getMainFrame().muoviMappa((int)e.getPoint().getX(), (int)e.getPoint().getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    static {
        dimensioneTraguardo = 200.0;
        latitudineAttuale = 0;
    }

    private class ZoomTimer
    extends Thread {
        private ZoomTimer() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    ZoomTimer.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (Mappa2D.this.getMode() == 5) {
                    if (Mappa2D.this.zb.getZoomCount() == 0) continue;
                    Mappa2D.this.zb.oldCount = Mappa2D.this.zb.getZoomCount();
                    try {
                        Mappa2D.this.zb.zoom();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (Mappa2D.this.getMode() != 7 || Mappa2D.this.zb.getZoomCount() == 0) continue;
                Mappa2D.this.zb.oldCount = Mappa2D.this.zb.getZoomCount();
                Mappa2D.this.zb.avanzaCursore();
            }
        }
    }

    private class ZoomBuffer {
        private int zoomCount = 0;
        private int notches;
        private int X;
        private int Y;
        private int oldCount = 0;

        public synchronized void setZoomCount(int count) {
            this.zoomCount = count;
        }

        public synchronized int getZoomCount() {
            return this.zoomCount;
        }

        public synchronized void incrementa() {
            ++this.zoomCount;
        }

        public void init(int X, int Y, int notches) {
            this.X = X;
            this.Y = Y;
            this.notches = notches;
        }

        public synchronized void reset() {
            if (this.oldCount == this.zoomCount) {
                this.zoomCount = 0;
                this.X = 0;
                this.Y = 0;
            } else {
                this.zoomCount -= this.oldCount;
            }
        }

        public synchronized void zoom() {
            if (this.notches < 0) {
                Mappa2D.this.zoomPoint(this.X, this.Y, Math.pow(0.8, this.zoomCount));
            } else {
                Mappa2D.this.zoomPoint(this.X, this.Y, Math.pow(1.2, this.zoomCount));
            }
            this.reset();
        }

        public synchronized void avanzaCursore() {
            if (this.notches < 0) {
                if (Mappa2D.this.multiSincro.getAggionrnaMappaGrafico()) {
                    Mappa2D.this.multiSincro.setPosizioneCursore(Mappa2D.this.controllaTempo(Mappa2D.this.tempoAttualeCursore + (double)this.zoomCount) * 100.0);
                    Mappa2D.this.multiSincro.setAggiornaPosizioneCursore(true);
                }
            } else if (Mappa2D.this.multiSincro.getAggionrnaMappaGrafico()) {
                Mappa2D.this.multiSincro.setPosizioneCursore(Mappa2D.this.controllaTempo(Mappa2D.this.tempoAttualeCursore - (double)this.zoomCount) * 100.0);
                Mappa2D.this.multiSincro.setAggiornaPosizioneCursore(true);
            }
            this.reset();
        }
    }

    public class TestoAiuto
    extends GObject {
        GSegment segmento = new GSegment();
        GText testo;
        GStyle stile;

        public TestoAiuto(String text) {
            this.testo = new GText(text, 256);
            this.segmento.setText(this.testo);
            this.addSegment(this.segmento);
            this.toFront();
        }

        @Override
        public void draw() {
            this.testo.setStyle(textStyle);
            Mappa2D.this.scene.getWorldExtent().getHeight();
            double larghezza = Mappa2D.this.scene.getWorldExtent().getWidth();
            double[] w0 = Mappa2D.this.scene.getWorldExtent().get(0);
            int[] d = Mappa2D.this.scene.getTransformer().worldToDevice(w0[0] + larghezza / 2.0, w0[1]);
            this.segmento.setGeometry(d[0], d[1] - 10);
        }
    }

    public class FrecciaVerso
    extends GObject {
        double x;
        double y;
        double inizioX;
        double inizioY;
        double fineX;
        double fineY;
        long angolo;
        int[] i;
        int[] f;
        GSegment segmento;
        GSegment punta;

        public FrecciaVerso(double x0, double y0, long angolo0) {
            this.x = x0;
            this.y = y0;
            this.angolo = angolo0;
            GStyle stile = new GStyle();
            stile.setBackgroundColor(null);
            stile.setForegroundColor(Mappa2D.this.coloreTesto);
            stile.setLineWidth(4);
            GStyle stile2 = new GStyle();
            stile2.setBackgroundColor(Mappa2D.this.coloreTesto);
            stile2.setForegroundColor(Mappa2D.this.coloreTesto);
            stile2.setLineWidth(4);
            this.segmento = new GSegment();
            this.segmento.setStyle(stile);
            this.punta = new GSegment();
            this.punta.setStyle(stile2);
            double angoloRad = this.angolo;
            angoloRad = angoloRad * Math.PI / 180.0;
            this.inizioX = this.x - 1.5 * dimensioneTraguardo * Math.cos(angoloRad);
            this.inizioY = this.y - 1.5 * dimensioneTraguardo * Math.sin(angoloRad);
            this.fineX = this.x + 1.5 * dimensioneTraguardo * Math.cos(angoloRad);
            this.fineY = this.y + 1.5 * dimensioneTraguardo * Math.sin(angoloRad);
            this.addSegment(this.segmento);
            this.addSegment(this.punta);
        }

        @Override
        public void draw() {
            this.i = Mappa2D.this.scene.getTransformer().worldToDevice(this.inizioX, this.inizioY);
            this.f = Mappa2D.this.scene.getTransformer().worldToDevice(this.fineX, this.fineY);
            int[] d = Mappa2D.this.scene.getTransformer().worldToDevice(this.fineX + dimensioneTraguardo, this.fineY + dimensioneTraguardo);
            int larghezza = 1;
            larghezza = d[0] - this.f[0] != 0 ? d[0] - this.f[0] : d[1] - this.f[1];
            if (larghezza < 0) {
                larghezza = -larghezza;
            }
            if (this.angolo != -1L) {
                this.segmento.setGeometry(this.i[0], this.i[1], this.f[0], this.f[1]);
                this.punta.setGeometry(Geometry.createArrow(this.i[0], this.i[1], this.f[0], this.f[1], larghezza, 0.4, 1.0));
            }
        }
    }

    public class Righello
    extends GObject {
        double x1;
        double y1;
        double x2;
        double y2;
        GSegment segmento;
        GSegment start;
        GSegment end;

        public Righello(double xi, double yi, double xf, double yf) {
            this.x1 = xi;
            this.y1 = yi;
            this.x2 = xf;
            this.y2 = yf;
            this.segmento = new GSegment();
            this.start = new GSegment();
            this.end = new GSegment();
            this.addSegment(this.start);
            this.addSegment(this.end);
            GStyle stile = new GStyle();
            stile.setLineWidth(2);
            stile.setForegroundColor(Color.RED);
            this.segmento.setStyle(stile);
            this.end.setStyle(stile);
            this.start.setStyle(stile);
            this.addSegment(this.segmento);
            GStyle stileTesto = new GStyle();
            stileTesto.setBackgroundColor(Color.WHITE);
            stileTesto.setForegroundColor(Color.BLACK);
            stileTesto.setFont(Mappa2D.this.fontCarattere);
            GText text = new GText(String.valueOf(Mappa2D.distanzaGeografica(this.x1, this.y1, this.x2, this.y2)) + "m", 1152);
            text.setStyle(stileTesto);
            this.segmento.setText(text);
        }

        @Override
        public void draw() {
            int[] d1 = Mappa2D.this.scene.getTransformer().worldToDevice(this.x1, this.y1);
            int[] d2 = Mappa2D.this.scene.getTransformer().worldToDevice(this.x2, this.y2);
            this.end.setGeometry(Geometry.createArrow(d1[0], d1[1], d2[0], d2[1], 10.0, 0.3, 0.0));
            this.start.setGeometry(Geometry.createArrow(d2[0], d2[1], d1[0], d1[1], 10.0, 0.3, 0.0));
            this.segmento.setGeometry(this.x1, this.y1, this.x2, this.y2);
        }
    }

    public class Cursore
    extends GObject {
        double x;
        double y;
        GSegment segmento;
        GSegment segmento2;
        double angolo = 1.5707963267948966;
        int inizioX;
        int inizioY;
        int fineX;
        int fineY;
        int raggio = 15;

        public Cursore(double x0, double y0, double teta) {
            this.x = Mappa2D.convertiX(x0, y0);
            this.y = y0;
            this.angolo = teta;
            GStyle stile = new GStyle();
            stile.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            stile.setForegroundColor(Color.BLACK);
            GStyle stile2 = new GStyle();
            stile2.setBackgroundColor(Color.BLACK);
            stile2.setForegroundColor(Color.BLACK);
            this.segmento = new GSegment();
            this.segmento.setStyle(stile);
            this.segmento2 = new GSegment();
            this.segmento2.setStyle(stile2);
            this.addSegment(this.segmento);
            this.addSegment(this.segmento2);
        }

        public void setCursore(double x0, double y0, double teta) {
            this.x = Mappa2D.convertiX(x0, y0);
            this.y = y0;
            this.angolo = teta;
            this.draw();
        }

        @Override
        public void draw() {
            int[] w = Mappa2D.this.scene.getTransformer().worldToDevice(this.x, this.y);
            double[] d = Mappa2D.this.scene.getTransformer().deviceToWorld(w[0] + this.raggio, w[1] + this.raggio);
            double dimensioneDoubleRaggio = d[0] - this.x != 0.0 ? d[0] - this.x : d[1] - this.y;
            if (dimensioneDoubleRaggio < 0.0) {
                dimensioneDoubleRaggio = -dimensioneDoubleRaggio;
            }
            int[] fine = Mappa2D.this.scene.getTransformer().worldToDevice(this.x + dimensioneDoubleRaggio * (Math.cos(this.angolo) * 0.7), this.y + dimensioneDoubleRaggio * (Math.sin(this.angolo) * 0.7));
            int[] inizio = Mappa2D.this.scene.getTransformer().worldToDevice(this.x - 10.0 * dimensioneDoubleRaggio * (Math.cos(this.angolo) * 0.7), this.y - 10.0 * dimensioneDoubleRaggio * (Math.sin(this.angolo) * 0.7));
            this.segmento.setGeometry(Geometry.createCircle(w[0], w[1], this.raggio));
            this.segmento2.setGeometry(Geometry.createArrow(inizio[0], inizio[1], fine[0], fine[1], 15.0, 60.0, 1.0));
        }
    }

    public class ImmagineSfondo
    extends GObject
    implements Runnable {
        GSegment segmento = new GSegment();
        double minX = 0.0;
        double maxY = 0.0;
        ImageIcon immagineGoogle;
        double larghezzaReale;
        double x = 0.0;
        double y = 0.0;
        String ricercaThread = null;
        boolean forzaRidisegnoThread = false;
        int altezzaThread = 0;
        int larghezzaThread = 0;
        int numeroTentativi = 0;

        public ImmagineSfondo() {
            this.addSegment(this.segmento);
            new Thread(this).start();
        }

        public void forzaRidisegno() {
            this.forzaRidisegnoThread = true;
        }

        @Override
        public void run() {
            int altezzaLocale = 0;
            int larghezzaLocale = 0;
            while (true) {
                DatiSfondo dati;
                if ((dati = this.verificaRicerca(null, 1, 1, null)) == null) {
                    continue;
                }
                String ricercaLocale = dati.getRicerca();
                altezzaLocale = dati.getAltezza();
                larghezzaLocale = dati.getLarghezza();
                try {
                    URL url;
                    ImageIcon imageIcon;
                    if (!Mappa2D.this.mappaTraguardiDialog) {
                        DanasDataStructure.getInstance().getMainFrame().getContenitoreMappa().setCursor(Cursor.getPredefinedCursor(3));
                    }
                    if ((imageIcon = new ImageIcon(url = new URL(ricercaLocale))).getIconWidth() <= 0) {
                        ++this.numeroTentativi;
                        System.out.println("DEBUG: errore google...:" + url);
                        if (this.numeroTentativi < 10) continue;
                        URL urlDefault = this.getClass().getResource("/pix/googleDefault.jpg");
                        imageIcon = new ImageIcon(urlDefault);
                    }
                    this.numeroTentativi = 0;
                    ImageIcon im = new ImageIcon(imageIcon.getImage().getScaledInstance(larghezzaLocale, altezzaLocale, 2));
                    this.verificaRicerca(ricercaLocale, altezzaLocale, larghezzaLocale, im);
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public synchronized void setRicerca(String nuovaRicerca, int altezza, int larghezza) {
            this.ricercaThread = nuovaRicerca;
            this.altezzaThread = altezza;
            this.larghezzaThread = larghezza;
            this.notifyAll();
        }

        public synchronized DatiSfondo verificaRicerca(String ricercaAttuale, int altezza, int larghezza, ImageIcon icona) {
            if (icona != null && this.ricercaThread.equals(ricercaAttuale) && this.altezzaThread == altezza && this.larghezzaThread == larghezza) {
                final ImageIcon iconaThread = icona;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImmagineSfondo.this.setImmagine(iconaThread);
                    }
                });
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
            if (this.ricercaThread == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
            return new DatiSfondo(this.ricercaThread, this.altezzaThread, this.larghezzaThread);
        }

        public void ricaricaImmagineSfondo() {
            if (!Mappa2D.this.sfondoMaps) {
                return;
            }
            double[] w0 = Mappa2D.this.scene.getWorldExtent().get(0);
            double[] w1 = Mappa2D.this.scene.getWorldExtent().get(1);
            double[] w2 = Mappa2D.this.scene.getWorldExtent().get(2);
            double latMin = w0[1] / 600000.0;
            double latMax = w2[1] / 600000.0;
            double longMin = Mappa2D.convertiIndietroX(w0[0], w0[1]) / 600000.0;
            double longMax = Mappa2D.convertiIndietroX(w1[0], w1[1]) / 600000.0;
            int altezza = Mappa2D.this.canvas.getHeight();
            int larghezza = Mappa2D.this.canvas.getWidth();
            if (altezza == 0 || larghezza == 0) {
                return;
            }
            Object url = null;
            double conversioneGradiRad = Math.PI / 180;
            double fattoreScalaMaxSize = 1.0;
            int larghezzaAggiornata = larghezza;
            if (larghezza >= altezza) {
                if (larghezza > 640) {
                    larghezzaAggiornata = 640;
                }
            } else if (altezza > 630) {
                fattoreScalaMaxSize = (double)altezza / 630.0;
                larghezzaAggiornata = (int)((double)larghezza / fattoreScalaMaxSize);
            }
            double centroH = (longMax + longMin) / 2.0;
            double centroV = (latMax + latMin) / 2.0;
            double deltaH = Math.abs(longMin - longMax);
            double deltaV = Math.abs(latMin - latMax);
            double gradiPerPixelH = deltaH / (double)larghezzaAggiornata;
            double zoomDoubleH = Math.abs(1.40625 / gradiPerPixelH);
            int zoomIntero = (int)(Math.log(zoomDoubleH) / Math.log(2.0));
            int pixelH = (int)(deltaH * 0.7111111111111111 * Math.pow(2.0, zoomIntero));
            int pixelV = (int)(deltaV * 0.7111111111111111 * Math.pow(2.0, zoomIntero) / Math.abs(Math.cos(centroV * conversioneGradiRad)));
            String imageUrl = "https://maps.googleapis.com/maps/api/staticmap?center=" + centroV + "," + centroH + "&zoom=" + zoomIntero + "&size=" + pixelH + "x" + pixelV + "&scale=2&maptype=satellite&key=" + DanasPreferences.getApiKey() + "";
            this.setRicerca(imageUrl, altezza, larghezza);
            System.out.println("DEBUG: richiesta a google 2:" + imageUrl);
        }

        public void setImmagine(ImageIcon im) {
            if (!Mappa2D.this.sfondoMaps) {
                return;
            }
            if (im.getIconWidth() <= 0 || im.getIconHeight() <= 0) {
                return;
            }
            double[] w = Mappa2D.this.scene.getTransformer().deviceToWorld(0, 0);
            double[] w1 = Mappa2D.this.scene.getWorldExtent().get(1);
            this.minX = w[0];
            this.maxY = w[1];
            this.larghezzaReale = w1[0] - w[0];
            this.x = this.minX;
            this.y = this.maxY;
            this.immagineGoogle = im;
            GImage image = new GImage(im.getImage());
            image.setPositionHint(65536);
            this.segmento.setImage(image);
            this.draw();
            this.refresh();
            if (!Mappa2D.this.mappaTraguardiDialog) {
                DanasDataStructure.getInstance().getMainFrame().getContenitoreMappa().setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void aggiornaSfondo() {
            if (!Mappa2D.this.sfondoMaps) {
                return;
            }
            if (this.immagineGoogle == null) {
                return;
            }
            int startX = 0;
            int startY = 0;
            int width = this.immagineGoogle.getIconWidth();
            int height = this.immagineGoogle.getIconHeight();
            double[] w0 = Mappa2D.this.scene.getWorldExtent().get(0);
            double[] w1 = Mappa2D.this.scene.getWorldExtent().get(1);
            double fattoreScala = Math.abs(this.larghezzaReale / (double)width / ((w1[0] - w0[0]) / (double)Mappa2D.this.canvas.getWidth()));
            int larghezzaNuova = (int)((double)width * fattoreScala);
            int altezzaNuova = (int)((double)height * fattoreScala);
            int[] d = Mappa2D.this.scene.getTransformer().worldToDevice(this.minX, this.maxY);
            if (d[0] <= -larghezzaNuova || d[1] <= -altezzaNuova) {
                return;
            }
            if (d[0] < 0) {
                startX = -d[0];
            }
            if (d[1] < 0) {
                startY = -d[1];
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            bufferedImage.getGraphics().drawImage(this.immagineGoogle.getImage(), 0, 0, null);
            BufferedImage crop = bufferedImage.getSubimage((int)((double)startX / fattoreScala), (int)((double)startY / fattoreScala), width - (int)((double)startX / fattoreScala), height - (int)((double)startY / fattoreScala));
            Image imCrop = crop.getScaledInstance(larghezzaNuova - startX, altezzaNuova - startY, 2);
            ImageIcon iconCrop = new ImageIcon(imCrop, "");
            double[] w = Mappa2D.this.scene.getTransformer().deviceToWorld(0, 0);
            this.x = startX > 0 ? w[0] : this.minX;
            this.y = startY > 0 ? w[1] : this.maxY;
            GImage image = new GImage(iconCrop.getImage());
            image.setPositionHint(65536);
            this.segmento.setImage(image);
            this.draw();
            this.refresh();
            this.ricaricaImmagineSfondo();
        }

        @Override
        public void draw() {
            int[] d = Mappa2D.this.scene.getTransformer().worldToDevice(this.x, this.y);
            this.segmento.setGeometry(d[0], d[1]);
        }
    }

    public class DatiSfondo {
        int altezza;
        int larghezza;
        String ricerca;

        public DatiSfondo(String ricerca, int altezza, int larghezza) {
            this.altezza = altezza;
            this.larghezza = larghezza;
            this.ricerca = ricerca;
        }

        public int getLarghezza() {
            return this.larghezza;
        }

        public int getAltezza() {
            return this.altezza;
        }

        public String getRicerca() {
            return this.ricerca;
        }
    }
}

