/*
 * Decompiled with CFR 0.152.
 */
package i2m.mappa;

import i2m.ColorEditor;
import i2m.ColorRenderer;
import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.MainFrame;
import i2m.mappa.Mappa2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ContenitoreMappa
extends JTabbedPane
implements WindowListener,
ChangeListener,
ActionListener,
TableModelListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private Mappa2D mappa;
    private ImageIcon iconaSottile = new ImageIcon(this.getClass().getResource("/pix/line_normal.gif"));
    private ImageIcon iconaMedia = new ImageIcon(this.getClass().getResource("/pix/line_medium.gif"));
    private ImageIcon iconaGrossa = new ImageIcon(this.getClass().getResource("/pix/line_heavy.gif"));
    private ImageIcon i2mGrande = new ImageIcon(this.getClass().getResource("/pix/I2M_bianco.png"));
    private JFormattedTextField minimoLegendaTF;
    private JFormattedTextField massimoLegendaTF;
    private JCheckBox mostraLegendaMappaCB;
    private JCheckBox autoScalingMappaCB;
    private JComboBox comboBoxDato;
    private JComboBox comboBoxSpessore;
    private JComboBox comboBoxCarattere;
    private JComboBox comboBoxTraguardo;
    private JTable tableMappa1;
    private int dimensioneCarattere;
    private int dimensioneTraguardo;
    private float minimoLegenda;
    private float massimoLegenda;
    private boolean legendaVisibile;
    private ImageIcon iconaLinea;
    private Color coloreSfondo;
    private Color coloreTesto;
    public static int MAPPA = 0;
    public static int OPZIONI = 1;
    private JPopupMenu popup;
    private JCheckBoxMenuItem cbDatiSuMappa;
    private JCheckBoxMenuItem cbAbilitaSplit;
    private JMenuItem opzionipopup;
    private JMenuItem autoscalingpopup;
    private JMenuItem datiPersonalizzatipop;
    private JMenuItem stampaPop;
    private JMenuItem menuPopup;
    private JMenuItem menuItemOpzione1;
    private JMenuItem menuItemOpzione2;
    private JMenuItem menuItemOpzione3;
    private JMenuItem menuItemOpzione4;
    private JMenuItem menuItemOpzione5;
    private JMenuItem menuItemOpzione6;
    private JRadioButtonMenuItem zoomInRadio;
    private JRadioButtonMenuItem zoomOutRadio;
    private JRadioButtonMenuItem zoomWindowRadio;
    private JRadioButtonMenuItem muoviRadio;
    private JRadioButtonMenuItem cursoreRadio;
    private JRadioButtonMenuItem traguardopopup;
    private JRadioButtonMenuItem splitpopup;
    private JRadioButtonMenuItem rimuovipopup;
    private JRadioButtonMenuItem giriRadio;
    private JRadioButtonMenuItem sessioniRadio;
    private JMenuItem fittapopup;
    private boolean nomiDaSettare = true;
    private boolean showTabsHeader = true;
    private Thread elaborazioneMonitorThread;
    private Thread elaborazioneThread;
    private boolean elaborazioneCompletata = true;
    private int indiceOld = -1;
    JPanel datiMappaPanel;
    boolean minimumFocus = false;

    public ContenitoreMappa(Mappa2D map) {
        this.mappa = map;
        this.datiMappaPanel = new JPanel();
        JPanel sottoTbellaMappaPanel = new JPanel();
        JPanel sopraTabellaPanel = new JPanel();
        sopraTabellaPanel.setLayout(new BoxLayout(sopraTabellaPanel, 0));
        sottoTbellaMappaPanel.setLayout(new BoxLayout(sottoTbellaMappaPanel, 0));
        this.datiMappaPanel.setLayout(new BoxLayout(this.datiMappaPanel, 1));
        this.dimensioneCarattere = DanasPreferences.getPrefCaratteremappaSize();
        this.dimensioneTraguardo = DanasPreferences.getPrefsetPrefDimensioneTraguardo();
        this.minimoLegenda = DanasPreferences.getPrefMinimoLegenda();
        this.massimoLegenda = DanasPreferences.getPrefMassimoLegenda();
        this.legendaVisibile = DanasPreferences.getPrefVisibleLegenda();
        this.coloreSfondo = new Color(DanasPreferences.getPrefColoreSfonfdoMappa());
        this.coloreTesto = new Color(DanasPreferences.getPrefColoreTestoMappa());
        if (DanasPreferences.getPrefSpessoreLineaMappa() == 2) {
            this.iconaLinea = this.iconaSottile;
        }
        if (DanasPreferences.getPrefSpessoreLineaMappa() == 4) {
            this.iconaLinea = this.iconaMedia;
        }
        if (DanasPreferences.getPrefSpessoreLineaMappa() == 8) {
            this.iconaLinea = this.iconaGrossa;
        }
        NumberFormat minMaxFormat = NumberFormat.getNumberInstance(Locale.US);
        minMaxFormat.setGroupingUsed(false);
        minMaxFormat.setMinimumFractionDigits(2);
        this.mostraLegendaMappaCB = new JCheckBox(Language.string("Mostra Legenda  "));
        this.mostraLegendaMappaCB.setSelected(this.legendaVisibile);
        this.mostraLegendaMappaCB.addActionListener(this);
        this.autoScalingMappaCB = new JCheckBox(Language.string("Auto"));
        this.autoScalingMappaCB.setSelected(true);
        this.mappa.setAutoscaling(true);
        this.autoScalingMappaCB.addActionListener(this);
        this.minimoLegendaTF = new JFormattedTextField(minMaxFormat);
        this.minimoLegendaTF.setHorizontalAlignment(11);
        this.minimoLegendaTF.setMaximumSize(new Dimension(100, 20));
        this.minimoLegendaTF.setValue(Float.valueOf(this.minimoLegenda));
        this.minimoLegendaTF.addActionListener(this);
        this.minimoLegendaTF.addFocusListener(this);
        JLabel minimoLegendaLabel = new JLabel("  Min: ");
        minimoLegendaLabel.setLabelFor(this.minimoLegendaTF);
        this.massimoLegendaTF = new JFormattedTextField(minMaxFormat);
        this.massimoLegendaTF.setValue(Float.valueOf(this.massimoLegenda));
        this.massimoLegendaTF.setHorizontalAlignment(11);
        this.massimoLegendaTF.setMaximumSize(new Dimension(100, 20));
        this.minimoLegendaTF.setEnabled(false);
        this.massimoLegendaTF.setEnabled(false);
        this.massimoLegendaTF.addActionListener(this);
        this.massimoLegendaTF.addFocusListener(this);
        JLabel massimoLegendaLabel = new JLabel("  Max: ");
        massimoLegendaLabel.setLabelFor(this.massimoLegendaTF);
        sottoTbellaMappaPanel.add(this.mostraLegendaMappaCB);
        sottoTbellaMappaPanel.add(this.autoScalingMappaCB);
        sottoTbellaMappaPanel.add(minimoLegendaLabel);
        sottoTbellaMappaPanel.add(this.minimoLegendaTF);
        sottoTbellaMappaPanel.add(massimoLegendaLabel);
        sottoTbellaMappaPanel.add(this.massimoLegendaTF);
        class TableModelMappa1
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private String[] columnNames = new String[]{Language.string("Sfondo"), Language.string("Linee"), Language.string("Testo"), Language.string("Carattere"), Language.string("Canale"), Language.string("Dim. traguardo")};
            private Object[][] stiliMappa1 = new Object[][]{{ContenitoreMappa.access$000(ContenitoreMappa.this), ContenitoreMappa.access$100(ContenitoreMappa.this), ContenitoreMappa.access$200(ContenitoreMappa.this), ContenitoreMappa.access$300(ContenitoreMappa.this), Language.string("Giri/Sessioni"), ContenitoreMappa.access$400(ContenitoreMappa.this)}};

            TableModelMappa1() {
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return this.stiliMappa1.length;
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                return this.stiliMappa1[row][col];
            }

            public Class<? extends Object> getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                this.stiliMappa1[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
        }
        this.tableMappa1 = new JTable(new TableModelMappa1());
        this.tableMappa1.getTableHeader().setReorderingAllowed(false);
        this.tableMappa1.setFillsViewportHeight(true);
        this.tableMappa1.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.tableMappa1.setDefaultEditor(Color.class, new ColorEditor());
        this.tableMappa1.setSelectionBackground(Color.WHITE);
        this.tableMappa1.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.tableMappa1.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.tableMappa1.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.tableMappa1.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.tableMappa1.getColumnModel().getColumn(4).setPreferredWidth(45);
        TableColumn colonna = this.tableMappa1.getColumnModel().getColumn(1);
        this.comboBoxSpessore = new JComboBox();
        this.comboBoxSpessore.addItem(this.iconaSottile);
        this.comboBoxSpessore.addItem(this.iconaMedia);
        this.comboBoxSpessore.addItem(this.iconaGrossa);
        colonna.setCellEditor(new DefaultCellEditor(this.comboBoxSpessore));
        colonna = this.tableMappa1.getColumnModel().getColumn(3);
        this.comboBoxCarattere = new JComboBox();
        this.comboBoxCarattere.addItem(6);
        this.comboBoxCarattere.addItem(8);
        this.comboBoxCarattere.addItem(10);
        this.comboBoxCarattere.addItem(12);
        this.comboBoxCarattere.addItem(14);
        this.comboBoxCarattere.addItem(16);
        this.comboBoxCarattere.addItem(18);
        this.comboBoxCarattere.addItem(20);
        this.comboBoxCarattere.addItem(22);
        colonna.setCellEditor(new DefaultCellEditor(this.comboBoxCarattere));
        colonna = this.tableMappa1.getColumnModel().getColumn(4);
        this.comboBoxDato = new JComboBox();
        this.comboBoxDato.addItem(Language.string("Giri/Sessioni"));
        this.comboBoxDato.addItem(Language.string("Velocit\u00e0 GPS"));
        this.comboBoxDato.addItem("RPM");
        this.comboBoxDato.addItem(Language.string("Velocit\u00e0 1"));
        this.comboBoxDato.addItem(Language.string("Velocit\u00e0 2"));
        this.comboBoxDato.addItem("Analog1");
        this.comboBoxDato.addItem("Analog2");
        this.comboBoxDato.addItem("Analog3");
        this.comboBoxDato.addItem("Analog4");
        this.comboBoxDato.addItem("Analog5");
        this.comboBoxDato.addItem("Analog6");
        this.comboBoxDato.addItem("Analog7");
        this.comboBoxDato.addItem("Analog8");
        this.comboBoxDato.addItem("Ext-1");
        this.comboBoxDato.addItem("Ext-2");
        this.comboBoxDato.addItem(Language.string("dVelocit\u00e0 GPS"));
        this.comboBoxDato.addItem("dRPM");
        this.comboBoxDato.addItem(Language.string("dVelocit\u00e0 1"));
        this.comboBoxDato.addItem(Language.string("dVelocit\u00e0 2"));
        this.comboBoxDato.addItem("dAnalog1");
        this.comboBoxDato.addItem("dAnalog2");
        this.comboBoxDato.addItem("dAnalog3");
        this.comboBoxDato.addItem("dAnalog4");
        this.comboBoxDato.addItem("dAnalog5");
        this.comboBoxDato.addItem("dAnalog6");
        this.comboBoxDato.addItem("dAnalog7");
        this.comboBoxDato.addItem("dAnalog8");
        this.comboBoxDato.addItem("dExt-1");
        this.comboBoxDato.addItem("dExt-2");
        this.comboBoxDato.addItem(Language.string("marce"));
        this.comboBoxDato.addItem(Language.string("Rapporti"));
        this.comboBoxDato.addItem("Math1");
        this.comboBoxDato.addItem("Math2");
        this.comboBoxDato.addItem("Multi");
        this.comboBoxDato.addItem("Multi2");
        this.comboBoxDato.addItem("Multi3");
        this.comboBoxDato.addItem("Multi4");
        this.comboBoxDato.addItem("Multi5");
        this.comboBoxDato.addItem("Multi6");
        this.comboBoxDato.addItem("Multi7");
        this.comboBoxDato.addItem("Multi8");
        this.comboBoxDato.addItem("Multi9");
        this.comboBoxDato.addItem("Multi10");
        this.comboBoxDato.addItem("GPS Angle");
        this.comboBoxDato.addItem("Acc. Lat.");
        this.comboBoxDato.addItem("Alt.");
        this.comboBoxDato.addItem("Delay");
        this.comboBoxDato.addItem("slip");
        this.comboBoxDato.addActionListener(this);
        colonna.setCellEditor(new DefaultCellEditor(this.comboBoxDato));
        colonna.setMinWidth(100);
        colonna = this.tableMappa1.getColumnModel().getColumn(5);
        this.comboBoxTraguardo = new JComboBox();
        this.comboBoxTraguardo.addItem(50);
        this.comboBoxTraguardo.addItem(55);
        this.comboBoxTraguardo.addItem(60);
        this.comboBoxTraguardo.addItem(65);
        this.comboBoxTraguardo.addItem(70);
        this.comboBoxTraguardo.addItem(75);
        this.comboBoxTraguardo.addItem(80);
        this.comboBoxTraguardo.addItem(85);
        this.comboBoxTraguardo.addItem(90);
        this.comboBoxTraguardo.addItem(95);
        this.comboBoxTraguardo.addItem(100);
        colonna.setCellEditor(new DefaultCellEditor(this.comboBoxTraguardo));
        JLabel topL = new JLabel(this.i2mGrande);
        topL.setAlignmentX(2.0f);
        sopraTabellaPanel.add(topL);
        sopraTabellaPanel.setBackground(Color.WHITE);
        sopraTabellaPanel.setMaximumSize(new Dimension(1600, 40));
        sopraTabellaPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setBackground(null);
        URL testoURL = DanasPreferences.getPrefLanguage().equals("it") ? this.getClass().getResource("/res/SpiegazioneOpzioniMappa.html") : this.getClass().getResource("/res/SpiegazioneOpzioniMappa_en.html");
        try {
            editorPane.setPage(testoURL);
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL: " + testoURL);
        }
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.datiMappaPanel.add(sopraTabellaPanel);
        this.datiMappaPanel.add(this.tableMappa1.getTableHeader());
        this.datiMappaPanel.add(this.tableMappa1);
        this.datiMappaPanel.add(new JLabel(" "));
        this.datiMappaPanel.add(sottoTbellaMappaPanel);
        this.datiMappaPanel.add(new JLabel(" "));
        this.datiMappaPanel.add(editorScrollPane);
        float min = ((Number)this.minimoLegendaTF.getValue()).floatValue();
        float max = ((Number)this.massimoLegendaTF.getValue()).floatValue();
        this.mappa.setMinimoLegenda(min);
        this.mappa.setMassimoLegenda(max);
        this.mappa.setLegendaVisibile(this.mostraLegendaMappaCB.isSelected());
        this.mappa.setBackgroundColor(this.getOptionBackgroundColor());
        this.mappa.setLineWidth(this.getOptionLineWidth());
        this.mappa.setColoreTesto(this.getOptionTextColor());
        this.mappa.setDimensioneCarattere(this.getOptionDimCarattere());
        this.mappa.setDimensioneTraguardo(this.getOptionDimensioneTraguardo());
        this.addTab(Language.string("Mostra mappa"), this.mappa.getMappa());
        this.mostraTabHeader(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addChangeListener(this);
        this.creaMenuPopup();
        this.tableMappa1.getModel().addTableModelListener(this);
    }

    public JPanel getPannelloDati() {
        return this.datiMappaPanel;
    }

    public void mostraFinestraOpzioni(boolean mostra) {
        if (mostra) {
            DanasDataStructure.getInstance().getMainFrame().setTabMappa(1);
            DanasDataStructure.getInstance().getMainFrame().setTastoOpzioniMappa(true);
            if (this.mappa.getModoColore() == 0) {
                this.comboBoxDato.setSelectedIndex(0);
                this.tableMappa1.setValueAt(Language.string("Giri/Sessioni"), 0, 4);
            }
            float min = ((Number)this.minimoLegendaTF.getValue()).floatValue();
            float max = ((Number)this.massimoLegendaTF.getValue()).floatValue();
            this.aggiornaNomi();
            this.mappa.setMinimoLegenda(min);
            this.mappa.setMassimoLegenda(max);
            this.mappa.refresh();
        } else {
            DanasDataStructure.getInstance().getMainFrame().setTabMappa(0);
            DanasDataStructure.getInstance().getMainFrame().setTastoOpzioniMappa(false);
        }
        this.mappa.refresh();
    }

    public void mostraTabHeader(boolean mostra) {
        this.showTabsHeader = mostra;
        this.setUI(new MetalTabbedPaneUI(){

            @Override
            protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
                if (ContenitoreMappa.this.showTabsHeader) {
                    return super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight);
                }
                return -2;
            }
        });
    }

    public boolean getNomiDaSettare() {
        return this.nomiDaSettare;
    }

    public void aggiornaNomi() {
        this.comboBoxDato.removeActionListener(this);
        int sel = this.comboBoxDato.getSelectedIndex();
        if (DanasDataStructure.getInstance().getDefaultSession() == null) {
            return;
        }
        while (this.comboBoxDato.getItemCount() != 1) {
            this.comboBoxDato.removeItemAt(1);
        }
        for (int i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            this.comboBoxDato.addItem(this.getNomeCanale(i));
        }
        this.comboBoxDato.setSelectedIndex(sel);
        this.comboBoxDato.addActionListener(this);
        this.nomiDaSettare = false;
    }

    public String getNomeCanale(int numCanale) {
        return MeasuresUtil.getNomeCanale(numCanale);
    }

    private void creaMenuPopup() {
        this.popup = new JPopupMenu();
        this.traguardopopup = new JRadioButtonMenuItem(Language.string("Posiziona traguardo "));
        this.traguardopopup.addActionListener(this);
        this.popup.add(this.traguardopopup);
        this.splitpopup = new JRadioButtonMenuItem(Language.string("Posiziona split"));
        this.splitpopup.addActionListener(this);
        this.popup.add(this.splitpopup);
        this.rimuovipopup = new JRadioButtonMenuItem(Language.string("Rimuovi split"));
        this.rimuovipopup.addActionListener(this);
        this.popup.add(this.rimuovipopup);
        this.popup.addSeparator();
        ButtonGroup group1 = new ButtonGroup();
        this.zoomInRadio = new JRadioButtonMenuItem(Language.string("Zoom In"));
        this.zoomOutRadio = new JRadioButtonMenuItem(Language.string("Zoom Out"));
        this.zoomWindowRadio = new JRadioButtonMenuItem(Language.string("Zoom Window"));
        this.muoviRadio = new JRadioButtonMenuItem(Language.string("Muovi"));
        this.cursoreRadio = new JRadioButtonMenuItem(Language.string("Cursore"));
        group1.add(this.zoomInRadio);
        group1.add(this.zoomOutRadio);
        group1.add(this.zoomWindowRadio);
        group1.add(this.muoviRadio);
        group1.add(this.cursoreRadio);
        group1.add(this.traguardopopup);
        group1.add(this.splitpopup);
        group1.add(this.rimuovipopup);
        this.zoomInRadio.addActionListener(this);
        this.zoomOutRadio.addActionListener(this);
        this.muoviRadio.addActionListener(this);
        this.zoomWindowRadio.addActionListener(this);
        this.cursoreRadio.addActionListener(this);
        this.popup.add(this.zoomInRadio);
        this.popup.add(this.zoomOutRadio);
        this.popup.add(this.zoomWindowRadio);
        this.popup.add(this.muoviRadio);
        this.popup.add(this.cursoreRadio);
        this.popup.addSeparator();
        ButtonGroup group2 = new ButtonGroup();
        this.giriRadio = new JRadioButtonMenuItem(Language.string("Giri"));
        this.sessioniRadio = new JRadioButtonMenuItem(Language.string("Sessioni"));
        group1.add(this.giriRadio);
        group1.add(this.sessioniRadio);
        this.giriRadio.addActionListener(this);
        this.sessioniRadio.addActionListener(this);
        this.popup.add(this.giriRadio);
        this.popup.add(this.sessioniRadio);
        this.popup.addSeparator();
        this.fittapopup = new JMenuItem(Language.string("Fitta "));
        this.fittapopup.addActionListener(this);
        this.popup.add(this.fittapopup);
        this.popup.addSeparator();
        this.cbDatiSuMappa = new JCheckBoxMenuItem(Language.string("Mostra dati sulla mappa"));
        this.cbDatiSuMappa.addActionListener(this);
        this.popup.add(this.cbDatiSuMappa);
        ButtonGroup group = new ButtonGroup();
        this.menuItemOpzione1 = new JRadioButtonMenuItem(Language.string("Rpm minimi in curva"));
        this.menuItemOpzione2 = new JRadioButtonMenuItem(Language.string("Velocit\u00e0 Gps minima in curva"));
        this.menuItemOpzione3 = new JRadioButtonMenuItem(Language.string("Velocit\u00e0 Gps massima in rettilineo"));
        this.menuItemOpzione4 = new JRadioButtonMenuItem(Language.string("Affondamento forcella (An2) massimo in rettilineo"));
        this.menuItemOpzione5 = new JRadioButtonMenuItem(Language.string("Spin massimo in curva"));
        this.menuItemOpzione6 = new JRadioButtonMenuItem(Language.string("Dati personalizzati"));
        group.add(this.menuItemOpzione1);
        group.add(this.menuItemOpzione2);
        group.add(this.menuItemOpzione3);
        group.add(this.menuItemOpzione4);
        group.add(this.menuItemOpzione5);
        group.add(this.menuItemOpzione6);
        this.menuItemOpzione1.addActionListener(this);
        this.menuItemOpzione2.addActionListener(this);
        this.menuItemOpzione3.addActionListener(this);
        this.menuItemOpzione4.addActionListener(this);
        this.menuItemOpzione5.addActionListener(this);
        this.menuItemOpzione6.addActionListener(this);
        this.datiPersonalizzatipop = new JMenuItem(Language.string("Personalizza posizioni"));
        this.datiPersonalizzatipop.addActionListener(this);
        this.stampaPop = new JMenuItem(Language.string("Stampa"));
        this.stampaPop.addActionListener(this);
        JMenu menuItemDati = new JMenu(Language.string("Tipo dati su mappa"));
        menuItemDati.add(this.menuItemOpzione1);
        menuItemDati.add(this.menuItemOpzione2);
        menuItemDati.add(this.menuItemOpzione3);
        menuItemDati.add(this.menuItemOpzione4);
        menuItemDati.add(this.menuItemOpzione5);
        menuItemDati.add(this.menuItemOpzione6);
        this.popup.add(menuItemDati);
        this.popup.add(this.datiPersonalizzatipop);
        this.popup.addSeparator();
        this.opzionipopup = new JMenuItem(Language.string("Opzioni"));
        this.opzionipopup.addActionListener(this);
        this.popup.add(this.opzionipopup);
        this.popup.addSeparator();
        this.cbAbilitaSplit = new JCheckBoxMenuItem(Language.string("Disabilita calcolo Split"));
        this.cbAbilitaSplit.addActionListener(this);
        this.popup.add(this.cbAbilitaSplit);
        this.popup.addSeparator();
        this.popup.add(this.stampaPop);
    }

    public void mostraPopup(int x, int y) {
        this.zoomInRadio.setSelected(this.mappa.getMode() == 3);
        this.zoomOutRadio.setSelected(this.mappa.getMode() == 4);
        this.muoviRadio.setSelected(this.mappa.getMode() == 5);
        this.zoomWindowRadio.setSelected(this.mappa.getMode() == 2);
        this.cursoreRadio.setSelected(this.mappa.getMode() == 7);
        this.traguardopopup.setSelected(this.mappa.getMode() == 10);
        this.splitpopup.setSelected(this.mappa.getMode() == 1);
        this.rimuovipopup.setSelected(this.mappa.getMode() == 6);
        this.giriRadio.setSelected(this.mappa.getModoVisualizzazioni() != 1);
        this.sessioniRadio.setSelected(this.mappa.getModoVisualizzazioni() == 1);
        int tipoVista = DanasDataStructure.getInstance().getMainFrame().getVistaSuMappaImpostata();
        switch (tipoVista) {
            case 1: {
                this.menuItemOpzione1.setSelected(true);
                break;
            }
            case 2: {
                this.menuItemOpzione2.setSelected(true);
                break;
            }
            case 3: {
                this.menuItemOpzione3.setSelected(true);
                break;
            }
            case 4: {
                this.menuItemOpzione4.setSelected(true);
                break;
            }
            case 5: {
                this.menuItemOpzione5.setSelected(true);
                break;
            }
            case 6: {
                this.menuItemOpzione6.setSelected(true);
                break;
            }
        }
        this.cbDatiSuMappa.setSelected(DanasDataStructure.getInstance().getMainFrame().getDatiSuMappa());
        this.cbAbilitaSplit.setSelected(!DanasDataStructure.getInstance().getCalcolaSplit());
        this.getMousePosition().getY();
        this.popup.show(this, x, (int)this.getMousePosition().getY());
    }

    public void abilitaSceltaDati(boolean abilita) {
        this.comboBoxDato.setEnabled(abilita);
    }

    public void setModoColore() {
        this.comboBoxDato.setSelectedIndex(0);
        this.tableMappa1.setValueAt(Language.string("Giri/Sessioni"), 0, 4);
        this.mappa.setModoColore(0);
    }

    public int getCanaleVisualizzato() {
        return this.comboBoxDato.getSelectedIndex();
    }

    private Color getOptionBackgroundColor() {
        return (Color)this.tableMappa1.getValueAt(0, 0);
    }

    private double getOptionDimensioneTraguardo() {
        DanasPreferences.setPrefDimensioneTraguardo((Integer)this.tableMappa1.getValueAt(0, 5));
        return ((Integer)this.tableMappa1.getValueAt(0, 5)).intValue();
    }

    public void setOptionDimensioneTraguardoMiniLAP() {
        this.tableMappa1.setValueAt(75, 0, 5);
        this.mappa.setDimensioneTraguardo(this.getOptionDimensioneTraguardo());
        this.mappa.refresh();
    }

    private int getOptionDimCarattere() {
        DanasPreferences.setPrefCaratteremappaSize((Integer)this.tableMappa1.getValueAt(0, 3));
        return (Integer)this.tableMappa1.getValueAt(0, 3);
    }

    private Color getOptionTextColor() {
        return (Color)this.tableMappa1.getValueAt(0, 2);
    }

    private int getOptionLineWidth() {
        if (this.tableMappa1.getValueAt(0, 1).equals(this.iconaSottile)) {
            DanasPreferences.setPrefSpessoreLineaMappa(2);
            return 2;
        }
        if (this.tableMappa1.getValueAt(0, 1).equals(this.iconaMedia)) {
            DanasPreferences.setPrefSpessoreLineaMappa(4);
            return 4;
        }
        if (this.tableMappa1.getValueAt(0, 1).equals(this.iconaGrossa)) {
            DanasPreferences.setPrefSpessoreLineaMappa(8);
            return 8;
        }
        return 2;
    }

    public void visualizza(int pannello) {
        if (pannello > -1 && pannello < 2) {
            this.setSelectedIndex(pannello);
        }
    }

    private void monitorElaborazione() {
        this.setEnabled(false);
        JDialog dlg = new JDialog(DanasDataStructure.getInstance().getMainFrame(), "Progress Dialog", false);
        JProgressBar progressBar = new JProgressBar(0, 500);
        progressBar.setIndeterminate(true);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(new JLabel(Language.string("elaborazione in corso..")));
        panel.add(progressBar);
        dlg.add((Component)panel, "First");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        dlg.setLocationRelativeTo(null);
        dlg.setSize(300, 75);
        dlg.setVisible(true);
        while (!this.elaborazioneCompletata) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        dlg.setVisible(false);
        this.setEnabled(true);
        this.requestFocus();
        this.elaborazioneMonitorThread = null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        float max;
        float min;
        if (e.getSource().equals(this.massimoLegendaTF)) {
            min = ((Number)this.minimoLegendaTF.getValue()).floatValue();
            max = ((Number)this.massimoLegendaTF.getValue()).floatValue();
            this.mappa.setMinimoLegenda(min);
            this.mappa.setMassimoLegenda(max);
            this.mappa.refresh();
        }
        if (e.getSource().equals(this.minimoLegendaTF)) {
            min = ((Number)this.minimoLegendaTF.getValue()).floatValue();
            max = ((Number)this.massimoLegendaTF.getValue()).floatValue();
            this.mappa.setMinimoLegenda(min);
            this.mappa.setMassimoLegenda(max);
            this.mappa.refresh();
        }
        if (e.getSource().equals(this.fittapopup)) {
            DanasDataStructure.getInstance().getMainFrame().centraMappa();
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.giriRadio)) {
            DanasDataStructure.getInstance().getMainFrame().setMappaSessioni(false);
        }
        if (e.getSource().equals(this.sessioniRadio)) {
            DanasDataStructure.getInstance().getMainFrame().setMappaSessioni(true);
        }
        if (e.getSource().equals(this.traguardopopup)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoMappa(2);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.splitpopup)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoMappa(3);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.rimuovipopup)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoMappa(4);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.zoomInRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoMappa(6);
            MainFrame mainFrame2 = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame2.selezionaTastoGrafico(2);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.zoomOutRadio)) {
            DanasDataStructure.getInstance().getMainFrame().selezionaTastoMappa(DanasDataStructure.getInstance().getMainFrame().ZOOM_OUT_MAPPA);
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(3);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.zoomWindowRadio)) {
            DanasDataStructure.getInstance().getMainFrame().selezionaTastoMappa(DanasDataStructure.getInstance().getMainFrame().ZOOM_FINESTRA_MAPPA);
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(4);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.muoviRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoMappa(5);
            MainFrame mainFrame3 = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame3.selezionaTastoGrafico(5);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.cursoreRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoMappa(1);
            MainFrame mainFrame4 = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame4.selezionaTastoGrafico(1);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.opzionipopup)) {
            this.mostraFinestraOpzioni(true);
            this.mappa.setPopUFalse();
        }
        if (e.getSource().equals(this.cbDatiSuMappa)) {
            DanasDataStructure.getInstance().getMainFrame().setVistaDatiMappa(this.cbDatiSuMappa.isSelected());
        }
        if (e.getSource().equals(this.cbAbilitaSplit)) {
            DanasDataStructure.getInstance().getMainFrame().setAbilitaCalcoloSplit(this.cbAbilitaSplit.isSelected());
        }
        if (e.getSource().equals(this.menuItemOpzione1)) {
            DanasDataStructure.getInstance().getMainFrame().configuraVistaSuMappa(1);
            if (this.cbDatiSuMappa.isSelected()) {
                this.mappa.setVistaDatiSpeciali(false);
                this.mappa.setVistaTrattini(true);
            }
        }
        if (e.getSource().equals(this.menuItemOpzione2)) {
            DanasDataStructure.getInstance().getMainFrame().configuraVistaSuMappa(2);
            if (this.cbDatiSuMappa.isSelected()) {
                this.mappa.setVistaDatiSpeciali(false);
                this.mappa.setVistaTrattini(true);
            }
        }
        if (e.getSource().equals(this.menuItemOpzione3)) {
            DanasDataStructure.getInstance().getMainFrame().configuraVistaSuMappa(3);
            if (this.cbDatiSuMappa.isSelected()) {
                this.mappa.setVistaDatiSpeciali(false);
                this.mappa.setVistaTrattini(true);
            }
        }
        if (e.getSource().equals(this.menuItemOpzione4)) {
            DanasDataStructure.getInstance().getMainFrame().configuraVistaSuMappa(4);
            if (this.cbDatiSuMappa.isSelected()) {
                this.mappa.setVistaDatiSpeciali(false);
                this.mappa.setVistaTrattini(true);
            }
        }
        if (e.getSource().equals(this.menuItemOpzione5)) {
            DanasDataStructure.getInstance().getMainFrame().configuraVistaSuMappa(5);
            if (this.cbDatiSuMappa.isSelected()) {
                this.mappa.setVistaDatiSpeciali(false);
                this.mappa.setVistaTrattini(true);
            }
        }
        if (e.getSource().equals(this.menuItemOpzione6)) {
            DanasDataStructure.getInstance().getMainFrame().configuraVistaSuMappa(6);
            if (this.cbDatiSuMappa.isSelected()) {
                this.mappa.setVistaTrattini(false);
                this.mappa.setVistaDatiSpeciali(true);
            }
        }
        if (e.getSource().equals(this.datiPersonalizzatipop)) {
            DanasDataStructure.getInstance().getMainFrame().apriSpecialDialog();
        }
        if (e.getSource().equals(this.stampaPop)) {
            PrinterJob job = PrinterJob.getPrinterJob();
            boolean doPrint = job.printDialog();
            this.mappa.getWindow().print();
        }
        if (e.getSource().equals(this.autoScalingMappaCB)) {
            if (this.autoScalingMappaCB.isSelected()) {
                this.minimoLegendaTF.setEnabled(false);
                this.massimoLegendaTF.setEnabled(false);
                this.mappa.setAutoscaling(true);
                if (this.mappa.getModoColore() == 1) {
                    this.mappa.scegliGiriVisibili();
                    this.minimoLegendaTF.setValue(Float.valueOf(this.mappa.getMinimoLegenda()));
                    this.massimoLegendaTF.setValue(Float.valueOf(this.mappa.getMassimoLegenda()));
                }
            } else {
                this.minimoLegendaTF.setEnabled(true);
                this.massimoLegendaTF.setEnabled(true);
                this.mappa.setAutoscaling(false);
            }
        }
        if (e.getSource().equals(this.mostraLegendaMappaCB)) {
            DanasPreferences.setPrefVisibleLegenda(this.mostraLegendaMappaCB.isSelected());
            this.mappa.setLegendaVisibile(this.mostraLegendaMappaCB.isSelected());
            this.mappa.refresh();
        }
        if (e.getSource().equals(this.comboBoxDato)) {
            if (this.comboBoxDato.getSelectedIndex() == this.indiceOld) {
                return;
            }
            this.indiceOld = this.comboBoxDato.getSelectedIndex();
            if (this.comboBoxDato.getSelectedIndex() != 0 && this.comboBoxDato.isEnabled()) {
                if (this.mappa.getNumeroTracciati() > 5 || this.mappa.getModoVisualizzazioni() == 1) {
                    JOptionPane.showMessageDialog(null, Language.string("Funzione disponibile solo in modalit\u00e0 giri e con max 5 curve."), Language.string("Attenzione"), 2);
                    this.comboBoxDato.setSelectedIndex(0);
                    this.tableMappa1.setValueAt(Language.string("Giri/Sessioni"), 0, 4);
                    return;
                }
                this.elaborazioneCompletata = false;
                this.elaborazioneMonitorThread = new Thread(){

                    @Override
                    public void run() {
                        ContenitoreMappa.this.monitorElaborazione();
                    }
                };
                this.elaborazioneMonitorThread.setDaemon(true);
                this.elaborazioneMonitorThread.start();
                this.elaborazioneThread = new Thread(){

                    @Override
                    public void run() {
                        ContenitoreMappa.this.mappa.setCanale(ContenitoreMappa.this.comboBoxDato.getSelectedIndex() - 1);
                        ContenitoreMappa.this.mappa.setModoColore(1);
                        ContenitoreMappa.this.mappa.scegliGiriVisibili();
                        ContenitoreMappa.this.minimoLegendaTF.setValue(Float.valueOf(ContenitoreMappa.this.mappa.getMinimoLegenda()));
                        ContenitoreMappa.this.massimoLegendaTF.setValue(Float.valueOf(ContenitoreMappa.this.mappa.getMassimoLegenda()));
                        ContenitoreMappa.this.elaborazioneCompletata = true;
                        ContenitoreMappa.this.elaborazioneMonitorThread = null;
                    }
                };
                this.elaborazioneThread.setDaemon(true);
                this.elaborazioneThread.start();
            } else {
                this.mappa.setModoColore(0);
                this.mappa.aggiornaTracciati();
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int col = e.getColumn();
        int row = e.getFirstRow();
        switch (col) {
            case 0: {
                Color coloreSfondo = (Color)this.tableMappa1.getModel().getValueAt(row, col);
                DanasPreferences.setPrefColoreSfonfdoMappa(coloreSfondo.getRGB());
                this.mappa.setBackgroundColor(coloreSfondo);
                this.mappa.refresh();
                break;
            }
            case 1: {
                ImageIcon iconaSpessore = (ImageIcon)this.tableMappa1.getModel().getValueAt(row, col);
                int spessore = 2;
                if (iconaSpessore.equals(this.iconaSottile)) {
                    spessore = 2;
                }
                if (iconaSpessore.equals(this.iconaMedia)) {
                    spessore = 4;
                }
                if (iconaSpessore.equals(this.iconaGrossa)) {
                    spessore = 8;
                }
                DanasPreferences.setPrefSpessoreLineaMappa(spessore);
                this.mappa.setLineWidth(spessore);
                this.mappa.aggiornaSerpentello();
                this.mappa.refresh();
                break;
            }
            case 2: {
                Color coloreTesto = (Color)this.tableMappa1.getModel().getValueAt(row, col);
                DanasPreferences.setPrefColoreTestoMappa(coloreTesto.getRGB());
                this.mappa.setColoreTesto(coloreTesto);
                this.mappa.refresh();
                break;
            }
            case 3: {
                int dimensioneCarattere = (Integer)this.tableMappa1.getModel().getValueAt(row, col);
                DanasPreferences.setPrefCaratteremappaSize(dimensioneCarattere);
                this.mappa.setDimensioneCarattere(dimensioneCarattere);
                this.mappa.refresh();
                break;
            }
            case 5: {
                double dimensioneTraguardo = ((Integer)this.tableMappa1.getModel().getValueAt(row, col)).intValue();
                DanasPreferences.setPrefDimensioneTraguardo((int)dimensioneTraguardo);
                this.mappa.setDimensioneTraguardo(dimensioneTraguardo);
                this.mappa.refresh();
            }
        }
        this.setComponentAt(0, this.mappa.getMappa());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            float min = Float.valueOf(this.minimoLegendaTF.getText()).floatValue();
            float max = Float.valueOf(this.massimoLegendaTF.getText()).floatValue();
            this.mappa.setMinimoLegenda(min);
            this.mappa.setMassimoLegenda(max);
            this.mappa.refresh();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    static /* synthetic */ Color access$000(ContenitoreMappa x0) {
        return x0.coloreSfondo;
    }

    static /* synthetic */ ImageIcon access$100(ContenitoreMappa x0) {
        return x0.iconaLinea;
    }

    static /* synthetic */ Color access$200(ContenitoreMappa x0) {
        return x0.coloreTesto;
    }

    static /* synthetic */ int access$300(ContenitoreMappa x0) {
        return x0.dimensioneCarattere;
    }

    static /* synthetic */ int access$400(ContenitoreMappa x0) {
        return x0.dimensioneTraguardo;
    }
}

