/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class SplitPaneTriplo
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSplitPane splitPrincipale;
    private JSplitPane splitSecondario;
    private int numeroComponentiPresenti = 0;
    private boolean componenteUnoPresente = false;
    private boolean componenteDuePresente = false;
    private boolean componenteTrePresente = false;

    public SplitPaneTriplo() {
        this.setLayout(new BorderLayout());
        this.splitSecondario = new JSplitPane(0, new JPanel(), new JPanel());
        this.splitPrincipale = new JSplitPane(0, new JPanel(), this.splitSecondario);
        this.add((Component)this.splitPrincipale, "Center");
    }

    public void addComponent(Component comp, int posizione) {
        int divider1 = this.splitPrincipale.getDividerLocation();
        int divider2 = this.splitSecondario.getDividerLocation();
        switch (posizione) {
            case 0: {
                this.splitPrincipale.remove(this.splitPrincipale.getTopComponent());
                this.splitPrincipale.add(comp, "top");
                if (!this.componenteUnoPresente) {
                    ++this.numeroComponentiPresenti;
                }
                this.componenteUnoPresente = true;
                break;
            }
            case 1: {
                this.splitSecondario.remove(this.splitSecondario.getTopComponent());
                this.splitSecondario.add(comp, "top");
                if (!this.componenteDuePresente) {
                    ++this.numeroComponentiPresenti;
                }
                this.componenteDuePresente = true;
                break;
            }
            case 2: {
                this.splitSecondario.remove(this.splitSecondario.getBottomComponent());
                this.splitSecondario.add(comp, "bottom");
                if (!this.componenteTrePresente) {
                    ++this.numeroComponentiPresenti;
                }
                this.componenteTrePresente = true;
            }
        }
        this.splitPrincipale.setDividerLocation(divider1);
        this.splitSecondario.setDividerLocation(divider2);
    }

    public Component removeComponent(int posizione) {
        Component comp = null;
        int divider1 = this.splitPrincipale.getDividerLocation();
        int divider2 = this.splitSecondario.getDividerLocation();
        switch (posizione) {
            case 0: {
                comp = this.splitPrincipale.getTopComponent();
                this.splitPrincipale.remove(comp);
                this.splitPrincipale.add((Component)new JPanel(), "top");
                if (this.componenteUnoPresente) {
                    --this.numeroComponentiPresenti;
                }
                this.componenteUnoPresente = false;
                break;
            }
            case 1: {
                comp = this.splitSecondario.getTopComponent();
                this.splitSecondario.remove(comp);
                this.splitSecondario.add((Component)new JPanel(), "top");
                if (this.componenteDuePresente) {
                    --this.numeroComponentiPresenti;
                }
                this.componenteDuePresente = false;
                break;
            }
            case 2: {
                comp = this.splitSecondario.getBottomComponent();
                this.splitSecondario.remove(comp);
                this.splitSecondario.add((Component)new JPanel(), "bottom");
                if (this.componenteTrePresente) {
                    --this.numeroComponentiPresenti;
                }
                this.componenteTrePresente = false;
            }
        }
        this.splitPrincipale.setDividerLocation(divider1);
        this.splitSecondario.setDividerLocation(divider2);
        return comp;
    }

    public void azzeraPosizioniDivider() {
        int altezza = this.getHeight() - 300;
        if (altezza <= 0) {
            return;
        }
        this.splitPrincipale.setDividerLocation(altezza / 2);
        this.splitSecondario.setDividerLocation(altezza / 2);
    }

    public int getNumeroComponenti() {
        return this.numeroComponentiPresenti;
    }
}

