/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.Dialog.IstogrammaDialog;
import i2m.grafico.CurvaIstogramma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GInteraction;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GWindow;

public class Istogramma
implements GInteraction,
MouseWheelListener,
ChangeListener,
ComponentListener {
    public static final int larghezzaGrigliaX = 100;
    public static final int larghezzaGrigliaY = 75;
    public static final int larghezzaAsse = 55;
    private Color coloreSfondo = new Color(0.95f, 0.95f, 0.95f, 1.0f);
    private GWindow window;
    private Component canvas;
    private GScene sceneTop;
    private GScene sceneBack;
    private GScene sceneDati;
    private Insets bordo;
    private Cornice corniceGrafico;
    private SfondoGrafico sfondo;
    private Griglia grid;
    private Assi axes;
    boolean visibile = true;
    boolean mostraLegenda = true;
    double minAsseY = 0.0;
    double maxAsseY = 100.0;
    double minAsseX = 0.0;
    double maxAsseX = 100.0;
    IstogrammaDialog dialog;

    public Istogramma(IstogrammaDialog diag) {
        this.dialog = diag;
        this.window = new GWindow(this.coloreSfondo);
        this.sceneBack = new GScene(this.window);
        this.sceneDati = new GScene(this.window);
        this.sceneTop = new GScene(this.window);
        this.sceneDati.setVisibility(240);
        this.canvas = this.window.getCanvas();
        this.canvas.addComponentListener(this);
        this.sceneTop.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.sceneBack.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.sceneDati.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.bordo = new Insets(8, 5, 25, 5);
        this.corniceGrafico = new Cornice();
        this.corniceGrafico.toFront();
        this.sfondo = new SfondoGrafico();
        this.grid = new Griglia();
        this.axes = new Assi();
        this.sceneBack.add(this.sfondo);
        this.sceneTop.add(this.corniceGrafico);
        this.sceneTop.add(this.axes);
        this.sceneTop.toFront();
        this.window.startInteraction(this);
        this.setMargini(5, 25, 55, 5);
        this.setScenaVisibile(true);
        this.setGrigliaOrizzontale(true);
        this.setGriliaVerticale(false);
        this.mostraAssi(true);
    }

    public void setMargini(int top, int bottom, int left, int right) {
        this.bordo.left = left;
        this.bordo.right = right;
        this.bordo.top = top;
        this.bordo.bottom = bottom;
    }

    public void mostraAssi(boolean mostra) {
        this.mostraAsse(mostra);
        if (mostra) {
            this.setMargini(5, 25, 55, 5);
        } else {
            this.setMargini(0, 0, 0, 0);
        }
    }

    public void setMargineLeft(int left) {
        this.bordo.left = left;
    }

    public Component getGrafico() {
        return this.window.getCanvas();
    }

    public void setBackgroundColor(Color colore) {
        this.sfondo.setColor(colore);
        this.sceneBack.redraw();
        this.sceneBack.refresh();
    }

    public void rimuoviTutto() {
        this.sceneDati.removeAll();
    }

    public void setColore(Color colore) {
        int num = this.sceneDati.getNChildren();
        if (num > 1) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            ((CurvaIstogramma)this.sceneDati.getChild(i)).setColore(colore);
        }
        this.sceneDati.refresh();
    }

    public void fittaVerticale() {
        double max = Double.MIN_VALUE;
        GScene s = this.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (!(((CurvaIstogramma)s.getChild(j)).getMaxY() > max)) continue;
            max = ((CurvaIstogramma)s.getChild(j)).getMaxY();
        }
        if ((max *= 1.05) < 0.01) {
            max = 0.01;
        }
        this.setAsseY(0.0, max, true);
    }

    public void fittaOrizzontale() {
        GScene s = this.getScene();
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        for (int j = 0; j < s.getNChildren(); ++j) {
            CurvaIstogramma curva = (CurvaIstogramma)s.getChild(j);
            if (curva.getMaxX() > max) {
                max = curva.getMaxX();
            }
            if (!(curva.getMinX() < min)) continue;
            min = curva.getMinX();
        }
        this.setAsseX(min, max, true);
    }

    public void setAsseX(double min, double max, boolean refresh) {
        double minimoDouble;
        if (max <= min) {
            return;
        }
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w1 = this.sceneDati.getWorldExtent().get(1);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = this.sceneDati.getTransformer().worldToDevice(w1[0], w1[1]);
        int larghezzaIntera = d1[0] - d0[0];
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return;
        }
        double larghezzaDouble = (max - min) * (double)larghezzaIntera / (double)(larghezzaIntera - this.bordo.left - this.bordo.right);
        w0[0] = minimoDouble = min - larghezzaDouble * (double)this.bordo.left / (double)larghezzaIntera;
        w2[0] = minimoDouble;
        w1[0] = minimoDouble + larghezzaDouble;
        this.sceneDati.setWorldExtent(w0, w1, w2);
        this.sceneTop.setWorldExtent(w0, w1, w2);
        if (refresh) {
            this.refresh();
        }
    }

    public void setAsseXY(double minX, double maxX, double minY, double maxY, boolean refresh) {
        double minimoDoubleX;
        double minimoDoubleY;
        if (maxY <= minY) {
            return;
        }
        if (maxX <= minX) {
            return;
        }
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w1 = this.sceneDati.getWorldExtent().get(1);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = this.sceneDati.getTransformer().worldToDevice(w1[0], w1[1]);
        int[] d2 = this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]);
        int altezzaInteraY = d0[1] - d2[1];
        if (altezzaInteraY <= this.bordo.top + this.bordo.bottom) {
            return;
        }
        double altezzaDoubleY = (maxY - minY) * (double)altezzaInteraY / ((double)altezzaInteraY - (double)this.bordo.top - (double)this.bordo.bottom);
        w0[1] = minimoDoubleY = minY - altezzaDoubleY * (double)this.bordo.bottom / (double)altezzaInteraY;
        w2[1] = minimoDoubleY + altezzaDoubleY;
        w1[1] = minimoDoubleY;
        int larghezzaInteraX = d1[0] - d0[0];
        if (larghezzaInteraX <= this.bordo.left + this.bordo.right) {
            return;
        }
        double larghezzaDoubleX = (maxX - minX) * (double)larghezzaInteraX / (double)(larghezzaInteraX - this.bordo.left - this.bordo.right);
        w0[0] = minimoDoubleX = minX - larghezzaDoubleX * (double)this.bordo.left / (double)larghezzaInteraX;
        w2[0] = minimoDoubleX;
        w1[0] = minimoDoubleX + larghezzaDoubleX;
        this.sceneDati.setWorldExtent(w0, w1, w2);
        this.sceneTop.setWorldExtent(w0, w1, w2);
        if (refresh) {
            this.refresh();
        }
    }

    public void setAsseY(double min, double max, boolean refresh) {
        double minimoDouble;
        int[] d2;
        if (max <= min) {
            return;
        }
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w1 = this.sceneDati.getWorldExtent().get(1);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int altezzaIntera = d0[1] - (d2 = this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]))[1];
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return;
        }
        double altezzaDouble = (max - min) * (double)altezzaIntera / (double)(altezzaIntera - this.bordo.top - this.bordo.bottom);
        w0[1] = minimoDouble = min - altezzaDouble * (double)this.bordo.bottom / (double)altezzaIntera;
        w2[1] = minimoDouble + altezzaDouble;
        w1[1] = minimoDouble;
        this.sceneDati.setWorldExtent(w0, w1, w2);
        this.sceneTop.setWorldExtent(w0, w1, w2);
        if (refresh) {
            this.refresh();
        }
    }

    public int getWidth() {
        return this.window.getWidth();
    }

    public int getHeight() {
        return this.window.getHeight();
    }

    public double[] getAsseX() {
        double[] asse = new double[]{0.0, 0.0};
        double[] w0 = this.sceneTop.getWorldExtent().get(0);
        double[] w1 = this.sceneTop.getWorldExtent().get(1);
        int[] d0 = this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = this.sceneTop.getTransformer().worldToDevice(w1[0], w1[1]);
        int larghezzaIntera = d1[0] - d0[0];
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return asse;
        }
        double larghezzaDouble = w1[0] - w0[0];
        double minimoDouble = larghezzaDouble * (double)this.bordo.left / (double)larghezzaIntera;
        asse[0] = w0[0] + minimoDouble;
        asse[1] = asse[0] + ((double)larghezzaIntera - (double)this.bordo.left - (double)this.bordo.right) * larghezzaDouble / (double)larghezzaIntera;
        return asse;
    }

    public double[] getAsseY() {
        int[] d2;
        double[] asse = new double[]{0.0, 0.0};
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int altezzaIntera = d0[1] - (d2 = this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]))[1];
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return asse;
        }
        double altezzaDouble = w2[1] - w0[1];
        double minimoDouble = altezzaDouble * (double)this.bordo.bottom / (double)altezzaIntera;
        asse[0] = w0[1] + minimoDouble;
        asse[1] = asse[0] + (double)(altezzaIntera - this.bordo.top - this.bordo.bottom) * altezzaDouble / (double)altezzaIntera;
        return asse;
    }

    public int getNumeroDivisioniX() {
        int x0 = this.sceneTop.getViewport().getX0();
        int x1 = this.sceneTop.getViewport().getX1();
        int larghezzaIntera = x1 - x0;
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return 1;
        }
        int res = (larghezzaIntera - this.bordo.left - this.bordo.right) / 100;
        if (res != 0) {
            return (larghezzaIntera - this.bordo.left - this.bordo.right) / 100;
        }
        return 1;
    }

    public int getNumeroDivisioniY(GScene scenaTemp) {
        int y0 = scenaTemp.getViewport().getY0();
        int y2 = scenaTemp.getViewport().getY2();
        int altezzaIntera = y2 - y0;
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return 1;
        }
        int res = (altezzaIntera - this.bordo.top - this.bordo.bottom) / 75;
        if (res != 0) {
            return (altezzaIntera - this.bordo.top - this.bordo.bottom) / 75;
        }
        return 1;
    }

    public void aggiungiCurva(CurvaIstogramma curva) {
        this.sceneDati.add(curva);
    }

    public synchronized void refresh() {
        try {
            if (this.sceneDati.getNChildren() != 0) {
                int num = this.sceneDati.getNChildren();
                for (int i = 0; i < num; ++i) {
                    ((CurvaIstogramma)this.sceneDati.getChild(i)).abilitaDisegno(true);
                }
            }
            this.window.redraw();
            this.window.refresh();
        }
        catch (Exception e) {
            System.out.println("Errore nel refresh Istogramma");
        }
    }

    public static String stampaValoreAsse(Double valore) {
        String s = null;
        s = valore.toString();
        if (valore > 1000.0) {
            s = String.format("%.0f", valore);
        }
        if (valore >= 1000000.0) {
            s = String.format("%.1fM", valore / 1000000.0);
        }
        if (valore < -1000.0) {
            s = String.format("%.0f", valore);
        }
        if (valore <= -1000000.0) {
            s = String.format("%.1fM", valore / 1000000.0);
        }
        return s;
    }

    private void setScenaVisibile(boolean visibile) {
        this.sceneDati.setVisibility(240);
        this.mostraAsse(false);
        if (visibile) {
            this.sceneDati.setVisibility(15);
            this.mostraAsse(true);
            double[] asse = this.getAsseX();
            this.setAsseX(asse[0], asse[1], false);
            this.sceneTop.add(this.grid);
        } else {
            this.sceneTop.remove(this.grid);
        }
    }

    public void mostraAsse(boolean mostra) {
        this.visibile = mostra;
    }

    public void ridisegnaSfondo() {
        this.sfondo.redraw();
    }

    public void setAllInvisible() {
        this.sceneDati.setVisibility(240);
        this.sceneTop.remove(this.grid);
    }

    private double getDivisioneDouble(double min, double max, int numDivisioni) {
        double datoGrezzo = (max - min) / (double)numDivisioni;
        double logaritmo = Math.log10(datoGrezzo);
        int numeroZeri = logaritmo > 0.0 ? (int)logaritmo : (int)logaritmo - 1;
        double cifraSignificativa = datoGrezzo / Math.pow(10.0, numeroZeri);
        int cifraSignificativaIntera = (int)Math.round(cifraSignificativa);
        int matrice = 1;
        switch (cifraSignificativaIntera) {
            case 1: {
                matrice = 1;
                break;
            }
            case 2: 
            case 3: {
                matrice = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                matrice = 5;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                matrice = 10;
            }
        }
        double base = (double)matrice * Math.pow(10.0, numeroZeri);
        return base;
    }

    private double getNumeroPulito(double valore, double matrice) {
        int numeroZeri = Math.log10(matrice) > 0.0 ? (int)Math.abs(Math.log10(matrice)) : (int)Math.abs(Math.log10(matrice)) + 1;
        long arrotondamento = (long)(valore * Math.pow(10.0, numeroZeri));
        return (double)arrotondamento / Math.pow(10.0, numeroZeri);
    }

    public GScene getScene() {
        return this.sceneDati;
    }

    public void setGriliaVerticale(boolean attiva) {
        this.grid.setGrigliaVerticale(attiva);
    }

    public void setGrigliaOrizzontale(boolean attiva) {
        this.grid.setGrigliaOrizzontale(attiva);
    }

    public String getNomeAsse() {
        return "%";
    }

    public String getNomeAsseX() {
        if (this.dialog == null) {
            return "Rpm";
        }
        String s = this.dialog.getNomeX();
        if (s.length() > 4) {
            return s.substring(0, 4) + ".";
        }
        return s + ".";
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.dialog == null) {
            return;
        }
        if (!this.dialog.getAutoY()) {
            this.setAsseY(0.0, this.dialog.getMaxY(), false);
        } else {
            this.fittaVerticale();
        }
        if (!this.dialog.getAutoX()) {
            this.setAsseX(this.dialog.getMinX(), this.dialog.getMaxX(), true);
        } else {
            this.fittaOrizzontale();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
    }

    @Override
    public void event(GScene arg0, int arg1, int arg2, int arg3) {
    }

    public class Griglia
    extends GObject {
        GSegment segmento;
        GSegment trattino;
        double[] asseX;
        double[] asseY;
        double divisione;
        int numeroDivisioniX;
        int startX;
        int stopX;
        int numeroDivisioniY;
        int startY;
        int stopY;
        double asseXMoltiplicato;
        double asseYMoltiplicato;
        double minimo;
        double massimo;
        double numero;
        Insets margini;
        GStyle stile;
        GStyle stile2;
        GStyle stile3;
        GStyle stile4;
        GStyle textStyle;
        GStyle textStyle2;
        GText text;
        String s = "test1";
        boolean grigliaOrizzontale = true;
        boolean grigliaVerticale = true;

        public Griglia() {
            this.margini = Istogramma.this.bordo;
            this.stile = new GStyle();
            this.stile.setBackgroundColor(null);
            this.stile.setLineWidth(1);
            this.stile.setLineStyle(3);
            this.stile.setForegroundColor(Color.GRAY);
            this.stile2 = new GStyle();
            this.stile2.setBackgroundColor(null);
            this.stile2.setLineWidth(1);
            this.stile2.setForegroundColor(Color.BLACK);
            this.stile3 = new GStyle();
            this.stile3.setBackgroundColor(null);
            this.stile3.setLineWidth(1);
            this.stile3.setForegroundColor(Color.GRAY);
            this.stile4 = new GStyle();
            this.stile4.setBackgroundColor(null);
            this.stile4.setLineWidth(1);
            this.stile4.setForegroundColor(null);
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(Color.BLACK);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.textStyle2 = new GStyle();
            this.textStyle2.setForegroundColor(Color.BLACK);
            this.textStyle2.setBackgroundColor(null);
            this.textStyle2.setFont(new Font("Dialog", 1, 12));
        }

        public void setGrigliaVerticale(boolean accesa) {
            this.grigliaVerticale = accesa;
        }

        public void setGrigliaOrizzontale(boolean accesa) {
            this.grigliaOrizzontale = accesa;
        }

        @Override
        public void draw() {
            int[] dg;
            this.asseX = Istogramma.this.getAsseX();
            this.asseY = Istogramma.this.getAsseY();
            this.numeroDivisioniX = Istogramma.this.getNumeroDivisioniX();
            this.numeroDivisioniY = Istogramma.this.getNumeroDivisioniY(Istogramma.this.sceneDati);
            if (this.asseX[1] <= this.asseX[0] || this.asseY[1] <= this.asseY[0]) {
                return;
            }
            this.removeSegments();
            double[] w0 = Istogramma.this.sceneDati.getWorldExtent().get(0);
            double[] w1 = Istogramma.this.sceneDati.getWorldExtent().get(1);
            double[] w2 = Istogramma.this.sceneDati.getWorldExtent().get(2);
            int[] d0 = Istogramma.this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = Istogramma.this.sceneDati.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = Istogramma.this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]);
            this.divisione = Istogramma.this.getDivisioneDouble(this.asseX[0], this.asseX[1], this.numeroDivisioniX);
            this.minimo = this.asseX[0] / this.divisione;
            this.massimo = this.asseX[1] / this.divisione;
            this.startX = (int)this.minimo;
            this.stopX = (int)this.massimo;
            int i = 0;
            while ((double)(this.startX + i) < this.minimo) {
                ++i;
            }
            while ((double)(this.startX + i) <= this.massimo) {
                this.segmento = new GSegment();
                this.trattino = new GSegment();
                this.trattino.setStyle(this.stile2);
                this.segmento.setStyle(this.stile);
                if (this.grigliaVerticale) {
                    this.addSegment(this.segmento);
                }
                this.addSegment(this.trattino);
                this.numero = Istogramma.this.getNumeroPulito((double)(this.startX + i) * this.divisione, this.divisione);
                if (this.numero == 0.0) {
                    this.segmento.setStyle(this.stile3);
                }
                dg = Istogramma.this.sceneTop.getTransformer().worldToDevice(this.numero, w2[1]);
                this.segmento.setGeometry(dg[0], d0[1] - this.margini.bottom, dg[0], d2[1] + this.margini.top);
                this.trattino.setGeometry(dg[0], d0[1] - this.margini.bottom + 4, dg[0], d0[1] - this.margini.bottom);
                this.text = new GText(Double.valueOf(this.numero).toString(), 32784);
                this.text.setStyle(this.textStyle);
                this.trattino.setText(this.text);
                ++i;
            }
            this.segmento = new GSegment();
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + this.margini.left - 4, d2[1] + this.margini.top, d0[0] + this.margini.left, d2[1] + this.margini.top);
            this.segmento = new GSegment();
            this.segmento.setGeometry(d0[0] + this.margini.left - 4, d2[1] + this.margini.top + 6);
            this.segmento.setStyle(this.stile4);
            this.addSegment(this.segmento);
            this.text = new GText(Istogramma.this.getNomeAsse(), 4104);
            this.text.setStyle(this.textStyle2);
            this.segmento.setText(this.text);
            this.divisione = Istogramma.this.getDivisioneDouble(this.asseY[0], this.asseY[1], this.numeroDivisioniY);
            this.minimo = this.asseY[0] / this.divisione;
            this.massimo = this.asseY[1] / this.divisione;
            this.startY = (int)this.minimo;
            this.stopY = (int)this.massimo;
            i = 0;
            this.segmento = new GSegment();
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + this.margini.left, d0[1] - this.margini.bottom - 1, d1[0] - this.margini.right, d0[1] - this.margini.bottom - 1);
            while ((double)(this.startY + i) < this.minimo) {
                ++i;
            }
            while ((double)(this.startY + i) <= this.massimo) {
                this.segmento = new GSegment();
                this.trattino = new GSegment();
                this.trattino.setStyle(this.stile2);
                this.segmento.setStyle(this.stile);
                if (this.grigliaOrizzontale) {
                    this.addSegment(this.segmento);
                }
                this.addSegment(this.trattino);
                this.numero = Istogramma.this.getNumeroPulito((double)(this.startY + i) * this.divisione, this.divisione);
                if (this.numero == 0.0) {
                    this.segmento.setStyle(this.stile3);
                }
                dg = Istogramma.this.sceneDati.getTransformer().worldToDevice(w0[0], this.numero);
                this.segmento.setGeometry(d0[0] + this.margini.left, dg[1], d1[0] - this.margini.right, dg[1]);
                this.trattino.setGeometry(d0[0] + this.margini.left - 4, dg[1], d0[0] + this.margini.left, dg[1]);
                this.text = new GText(Istogramma.stampaValoreAsse(this.numero), 4128);
                this.text.setStyle(this.textStyle);
                this.trattino.setText(this.text);
                ++i;
            }
        }
    }

    public class Assi
    extends GObject {
        GSegment segmento;
        GSegment trattino;
        double[] asseY;
        double divisione;
        int numeroDivisioniY;
        int startY;
        int stopY;
        double asseYMoltiplicato;
        double minimo;
        double massimo;
        double numero;
        Insets margini;
        GStyle stile2;
        GStyle stile3;
        GStyle textStyle;
        GStyle textStyle2;
        GText text;

        public Assi() {
            this.margini = Istogramma.this.bordo;
            this.stile2 = new GStyle();
            this.stile2.setBackgroundColor(null);
            this.stile2.setLineWidth(1);
            this.stile2.setForegroundColor(Color.BLACK);
            this.stile3 = new GStyle();
            this.stile3.setBackgroundColor(null);
            this.stile3.setLineWidth(1);
            this.stile3.setForegroundColor(null);
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(Color.BLACK);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.textStyle2 = new GStyle();
            this.textStyle2.setForegroundColor(Color.BLACK);
            this.textStyle2.setBackgroundColor(null);
            this.textStyle2.setFont(new Font("Dialog", 1, 12));
        }

        @Override
        public void draw() {
            this.removeSegments();
            if (!Istogramma.this.visibile) {
                return;
            }
            double[] w0 = Istogramma.this.sceneTop.getWorldExtent().get(0);
            double[] w2 = Istogramma.this.sceneTop.getWorldExtent().get(2);
            int[] d0 = Istogramma.this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d2 = Istogramma.this.sceneTop.getTransformer().worldToDevice(w2[0], w2[1]);
            this.asseY = Istogramma.this.getAsseY();
            this.numeroDivisioniY = Istogramma.this.getNumeroDivisioniY(Istogramma.this.sceneDati);
            this.divisione = Istogramma.this.getDivisioneDouble(this.asseY[0], this.asseY[1], this.numeroDivisioniY);
            this.minimo = 5.0 * this.asseY[0] / this.divisione;
            this.massimo = 5.0 * this.asseY[1] / this.divisione;
            this.startY = (int)this.minimo;
            this.stopY = (int)this.massimo;
            this.segmento = new GSegment();
            this.segmento.setStyle(this.stile2);
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + 55 - 4, d0[1] - this.margini.bottom, d0[0] + 55, d0[1] - this.margini.bottom);
            this.segmento = new GSegment();
            this.segmento.setStyle(this.stile2);
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + 55, d0[1] - this.margini.bottom, d0[0] + 55, d2[1] + this.margini.top);
            this.segmento = new GSegment();
            this.segmento.setStyle(this.stile2);
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top, d0[0] + 55, d2[1] + this.margini.top);
            this.segmento = new GSegment();
            this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top + 6);
            this.addSegment(this.segmento);
            this.segmento.setStyle(this.stile3);
            this.text = new GText(Istogramma.this.getNomeAsse(), 4352);
            this.text.setStyle(this.textStyle2);
            this.segmento.setText(this.text);
            this.segmento = new GSegment();
            if (Istogramma.this.dialog != null) {
                this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top + 545);
            } else {
                this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top + 460);
            }
            this.addSegment(this.segmento);
            this.segmento.setStyle(this.stile3);
            this.text = new GText(Istogramma.this.getNomeAsseX(), 4352);
            this.text.setStyle(this.textStyle2);
            this.segmento.setText(this.text);
            int i = 0;
            while ((double)(this.startY + i) < this.minimo) {
                ++i;
            }
            while ((double)(this.startY + i) <= this.massimo) {
                this.trattino = new GSegment();
                this.trattino.setStyle(this.stile2);
                this.addSegment(this.trattino);
                this.numero = Istogramma.this.getNumeroPulito((double)(this.startY + i) * this.divisione / 5.0, this.divisione);
                int[] dg = Istogramma.this.sceneDati.getTransformer().worldToDevice(w0[0], this.numero);
                this.text = new GText(Istogramma.stampaValoreAsse(this.numero), 4128);
                this.text.setStyle(this.textStyle);
                if ((this.startY + i) % 5 == 0) {
                    this.trattino.setText(this.text);
                    this.trattino.setGeometry(d0[0] + 55 - 4, dg[1], d0[0] + 55, dg[1]);
                } else {
                    this.trattino.setGeometry(d0[0] + 55 - 2, dg[1], d0[0] + 55, dg[1]);
                }
                ++i;
            }
        }
    }

    public class Cornice
    extends GObject {
        GSegment segmentoSx;
        GSegment segmentoDx;
        GSegment segmentoUp;
        GSegment segmentoDn;
        Insets margini;

        public Cornice() {
            this.margini = Istogramma.this.bordo;
            this.segmentoSx = new GSegment();
            this.segmentoDx = new GSegment();
            this.segmentoUp = new GSegment();
            this.segmentoDn = new GSegment();
            GStyle stile = new GStyle();
            stile.setBackgroundColor(new Color(0.9f, 0.9f, 0.9f, 1.0f));
            stile.setForegroundColor(new Color(0.9f, 0.9f, 0.9f, 1.0f));
            this.segmentoSx.setStyle(stile);
            this.segmentoDx.setStyle(stile);
            this.segmentoUp.setStyle(stile);
            this.segmentoDn.setStyle(stile);
            this.addSegment(this.segmentoSx);
            this.addSegment(this.segmentoDx);
            this.addSegment(this.segmentoUp);
            this.addSegment(this.segmentoDn);
        }

        @Override
        public void draw() {
            double[] w0 = Istogramma.this.sceneTop.getWorldExtent().get(0);
            double[] w1 = Istogramma.this.sceneTop.getWorldExtent().get(1);
            double[] w2 = Istogramma.this.sceneTop.getWorldExtent().get(2);
            int[] d0 = Istogramma.this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = Istogramma.this.sceneTop.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = Istogramma.this.sceneTop.getTransformer().worldToDevice(w2[0], w2[1]);
            this.segmentoSx.setGeometry(Geometry.createRectangle(d0[0], d0[1], this.margini.left, d2[1] - d0[1]));
            this.segmentoDx.setGeometry(Geometry.createRectangle(d1[0] - this.margini.right, d0[1], this.margini.right, d2[1] - d0[1]));
            this.segmentoUp.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d2[1] + this.margini.top, d1[0] - d0[0] - this.margini.right - this.margini.left, -this.margini.top));
            this.segmentoDn.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d0[1], d1[0] - d0[0] - this.margini.right - this.margini.left, -this.margini.bottom));
        }
    }

    public class SfondoGrafico
    extends GObject {
        GSegment segmento;
        Insets margini;
        GStyle stile;

        public SfondoGrafico() {
            this.margini = Istogramma.this.bordo;
            this.segmento = new GSegment();
            this.stile = new GStyle();
            this.stile.setBackgroundColor(Color.BLACK);
            this.stile.setForegroundColor(null);
            this.segmento.setStyle(this.stile);
            this.addSegment(this.segmento);
        }

        public void setColor(Color colore) {
            this.stile.setBackgroundColor(colore);
            this.draw();
        }

        @Override
        public void draw() {
            double[] w0 = Istogramma.this.sceneBack.getWorldExtent().get(0);
            double[] w1 = Istogramma.this.sceneBack.getWorldExtent().get(1);
            double[] w2 = Istogramma.this.sceneBack.getWorldExtent().get(2);
            int[] d0 = Istogramma.this.sceneBack.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = Istogramma.this.sceneBack.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = Istogramma.this.sceneBack.getTransformer().worldToDevice(w2[0], w2[1]);
            this.segmento.setStyle(this.stile);
            this.segmento.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d0[1] - this.margini.bottom, d1[0] - d0[0] - this.margini.right - this.margini.left, d2[1] - d0[1] + this.margini.top + this.margini.bottom));
        }
    }
}

