/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.ColorRenderer;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.MainFrame;
import i2m.grafico.InfoCellRender;
import i2m.grafico.JMyTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class InfoNewDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JMyTable table;
    MyTableModel model;
    JScrollPane scrollPane;
    Vector<String> elencoColonne = new Vector();
    JPanel tablePanel;
    MainFrame padre;
    ArrayList<Integer> listaCampi = new ArrayList();
    ArrayList<Boolean> listaSelezionati = new ArrayList();

    public InfoNewDialog(MainFrame owner) {
        super((Frame)owner, "Info [n]");
        this.padre = owner;
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.listaCampi.clear();
        this.model = new MyTableModel();
        this.table = new JMyTable(this.model);
        this.table.setFillsViewportHeight(false);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(this.table);
        this.scrollPane = new JScrollPane(this.tablePanel);
        this.table.setDefaultRenderer(String.class, new InfoCellRender());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && InfoNewDialog.this.table.getRowCount() > 0) {
                    int rowNumber = InfoNewDialog.this.table.rowAtPoint(e.getPoint());
                    boolean column = false;
                    if (rowNumber > 2 && rowNumber < InfoNewDialog.this.table.getModel().getRowCount() - 1) {
                        int canale = InfoNewDialog.this.listaCampi.get(rowNumber - 3);
                        int numeroCanale = MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[canale]);
                        if (DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getCanaleEvidenziato(numeroCanale)) {
                            DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().setCanaleEvidenziato(numeroCanale, false);
                        } else {
                            DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().setCanaleEvidenziato(numeroCanale, true);
                        }
                        InfoNewDialog.this.table.repaint();
                    }
                }
            }
        });
        this.add(this.scrollPane);
        this.setMinimumSize(new Dimension(160, 80));
        this.pack();
        this.setFocusableWindowState(false);
    }

    public void aggiorna() {
        this.model.fireTableDataChanged();
    }

    public ArrayList<Integer> getListaCampi() {
        return this.listaCampi;
    }

    public void svuotaListaCampi() {
        this.listaCampi.clear();
    }

    public void addCampo(Integer numeroCampo) {
        this.listaCampi.add(numeroCampo);
    }

    public void addColonna(String colonna) {
        this.model.addColumn(colonna);
        this.elencoColonne.add(colonna);
        if (this.table.getColumnCount() == 1) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
            this.table.getColumnModel().getColumn(0).setWidth(30);
            this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        } else {
            this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).setPreferredWidth(80);
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
    }

    public void svuota() {
        this.model.rimuoviTutto();
        this.elencoColonne.clear();
        this.listaCampi.clear();
    }

    public void rimuoviTutto() {
        this.model.rimuoviTutto();
        this.elencoColonne.clear();
        this.listaCampi.clear();
        this.setSize(new Dimension(300, 200));
    }

    public Vector<String> getElencoColonne() {
        return this.elencoColonne;
    }

    public void setValore(int indiceColonna, int campo, Object valore) {
        this.model.setValueAt(valore, campo, indiceColonna);
    }

    public void refresh() {
        this.aggiorna();
        this.pack();
    }

    public static void main(String[] args) {
        InfoNewDialog i = new InfoNewDialog(null);
        i.setVisible(true);
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<Object[]> listaDati = new ArrayList();

        @Override
        public int getColumnCount() {
            return this.listaDati.size();
        }

        @Override
        public int getRowCount() {
            return InfoNewDialog.this.listaCampi.size() + 4;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Language.string("Colore");
            }
            return (String)this.listaDati.get(col)[0];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.listaDati.get(col)[row];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 0) {
                return Color.class;
            }
            return String.class;
        }

        public void addColumn(String nome) {
            Object[] colonna = new Object[InfoNewDialog.this.listaCampi.size() + 4];
            if (this.listaDati.size() == 0) {
                for (int i = 0; i < InfoNewDialog.this.listaCampi.size() + 4; ++i) {
                    colonna[i] = Color.WHITE;
                }
            } else {
                colonna[0] = nome;
            }
            this.listaDati.add(colonna);
            this.fireTableStructureChanged();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.listaDati.get((int)col)[row] = value;
            this.fireTableCellUpdated(row, col);
        }

        public void rimuoviTutto() {
            this.listaDati.clear();
            this.fireTableStructureChanged();
        }
    }
}

