/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.ColorRenderer;
import i2m.Language;
import i2m.MainFrame;
import i2m.grafico.TableRowInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class InfoDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 1L;
    JTable table;
    MyTableModel model;
    JScrollPane scrollPane;
    Vector<TableRowInfo> elencoRighe = new Vector();
    JPanel tablePanel;
    MainFrame padre;

    public InfoDialog(MainFrame owner) {
        super((Frame)owner, "Info [s]");
        this.padre = owner;
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(22);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(90);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.table.getTableHeader(), "First");
        this.tablePanel.add((Component)this.table, "Center");
        this.scrollPane = new JScrollPane(this.tablePanel);
        this.table.setFillsViewportHeight(true);
        this.add(this.scrollPane);
        this.addWindowListener(this);
        this.setMinimumSize(new Dimension(160, 70));
        this.pack();
        this.setFocusableWindowState(false);
        this.setAlwaysOnTop(true);
    }

    public void aggiorna() {
        this.model.fireTableDataChanged();
    }

    public Container getContenuto() {
        return this.getContentPane();
    }

    public void addRiga(TableRowInfo riga) {
        this.model.addRow(riga);
        this.elencoRighe.add(riga);
    }

    public void svuota() {
        this.model.rimuoviTutto();
        this.elencoRighe.clear();
    }

    public void rimuoviTutto() {
        this.model.rimuoviTutto();
        this.elencoRighe.clear();
        this.setSize(new Dimension(200, 0));
    }

    public Vector<TableRowInfo> getElencoRighe() {
        return this.elencoRighe;
    }

    public void setValore(int indiceRiga, String valore) {
        this.elencoRighe.get(indiceRiga).setValore(valore);
    }

    public void setValore(int indiceRiga, String valore, String valore2) {
        this.elencoRighe.get(indiceRiga).setValore(valore);
        this.elencoRighe.get(indiceRiga).setValore2(valore2);
    }

    public void setValore(int indiceRiga, String valore, String valore2, String valore3, String valore4) {
        this.elencoRighe.get(indiceRiga).setValore(valore);
        this.elencoRighe.get(indiceRiga).setValore2(valore2);
        this.elencoRighe.get(indiceRiga).setDelta(valore3);
        this.elencoRighe.get(indiceRiga).setMedia(valore4);
    }

    public void setValore(int indiceRiga, String valore, String valore2, String valore3, String valore4, String valore5, String valore6, String valore7) {
        this.elencoRighe.get(indiceRiga).setValore(valore);
        this.elencoRighe.get(indiceRiga).setValore2(valore2);
        this.elencoRighe.get(indiceRiga).setDelta(valore3);
        this.elencoRighe.get(indiceRiga).setMedia(valore4);
        this.elencoRighe.get(indiceRiga).setMin(valore5);
        this.elencoRighe.get(indiceRiga).setMax(valore6);
        this.elencoRighe.get(indiceRiga).setDerivata(valore7);
    }

    public void setValore(int indiceRiga, String valore, String valore2, String valore3) {
        this.elencoRighe.get(indiceRiga).setValore(valore);
        this.elencoRighe.get(indiceRiga).setValore2(valore2);
        this.elencoRighe.get(indiceRiga).setDelta(valore3);
    }

    public void refresh() {
        this.aggiorna();
        this.remove(this.scrollPane);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(this.table.getTableHeader());
        this.tablePanel.add(this.table);
        this.scrollPane = new JScrollPane(this.tablePanel);
        this.add(this.scrollPane);
        this.pack();
    }

    public static void main(String[] args) {
        InfoDialog i = new InfoDialog(null);
        i.setVisible(true);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.padre.chiusaInfoDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        Vector<String> columnNames = new Vector();
        private Vector<TableRowInfo> datiInfo = new Vector();

        public MyTableModel() {
            this.columnNames.add("");
            this.columnNames.add(Language.string("Canale"));
            this.columnNames.add(Language.string("Nome"));
            this.columnNames.add(Language.string("Valore"));
            this.columnNames.add(Language.string("Valore2"));
            this.columnNames.add(Language.string("Delta"));
            this.columnNames.add(Language.string("Media"));
            this.columnNames.add(Language.string("Min"));
            this.columnNames.add(Language.string("Max"));
            this.columnNames.add(Language.string("Derivata"));
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.datiInfo.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.datiInfo.get(row).getCampo(col);
        }

        public Class<? extends Object> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.datiInfo.get(row).setCampo(value, col);
            this.fireTableCellUpdated(row, col);
        }

        public void addRow(TableRowInfo riga) {
            this.datiInfo.add(riga);
        }

        public TableRowInfo getRow(int indice) {
            return this.datiInfo.get(indice);
        }

        public void rimuoviTutto() {
            this.datiInfo.clear();
        }
    }
}

