/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.grafico.SincronizzatoreGrafico;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GInteraction;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GWindow;

public class GraficoBarra
implements GInteraction,
ChangeListener,
MouseWheelListener {
    private GWindow window;
    GScene sceneBase;
    private double altezza = 100.0;
    private double durata = 1000.0;
    double x0;
    double y0;
    boolean abilitaTraslazione = false;
    boolean abilitaModificaMinimo = false;
    boolean abilitaModificaMassimo = false;
    Rettangolo rect;
    Rettangolo rectBest;
    Bordo bordo;
    Giri giri;
    Thread zoomThread = null;
    int notchesZoom = 0;
    boolean zoomBufferPieno = false;
    int bufferZoomValue = 0;
    int bufferZoomNotches = 0;
    private SincronizzatoreGrafico sincro;
    long tempoClick = 0L;
    boolean bordoVisibile = false;
    Color colore = Color.magenta;

    public GraficoBarra() {
        this.window = new GWindow(Color.black);
        this.sceneBase = new GScene(this.window);
        this.rect = new Rettangolo();
        this.rectBest = new Rettangolo();
        this.rectBest.setColor(new Color(this.colore.getRed(), this.colore.getGreen(), this.colore.getBlue(), 130));
        this.bordo = new Bordo();
        this.giri = new Giri();
        this.sceneBase.add(this.rect);
        this.sceneBase.add(this.giri);
        this.window.startInteraction(this);
        DanasDataStructure.getInstance().addChangeListener(this);
        this.setDurata(1000.0);
        this.rect.setDimensioni(0.0, 1000.0, false);
    }

    public void gestisciBordo(boolean aggiungi) {
        if (aggiungi) {
            this.sceneBase.add(this.bordo);
        } else {
            this.sceneBase.remove(this.giri);
            this.sceneBase.remove(this.bordo);
            if (DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni()) {
                this.sceneBase.add(this.giri);
            }
            this.sceneBase.redraw();
            this.sceneBase.refresh();
        }
    }

    public Component getCanvas() {
        return this.window.getCanvas();
    }

    public void setDurata(double durata) {
        this.durata = durata;
        this.setWorldExtent();
    }

    public void setWorldExtent() {
        this.sceneBase.setWorldExtent(0.0, 0.0, this.durata, this.altezza);
        this.sceneBase.refresh();
    }

    public void aggiungiSincronizzatore(SincronizzatoreGrafico sincro) {
        this.sincro = sincro;
        sincro.addChangeListener(this);
    }

    public double getBestDuration() {
        int numeroGiri = 0;
        double best = Double.MAX_VALUE;
        for (DanasSession dss : DanasDataStructure.getInstance().getSessions()) {
            if (!dss.isSelected()) continue;
            for (DanasLap dl : dss.getLaps()) {
                ++numeroGiri;
                if (!(dl.getDuration() < best) || !(dl.getDuration() >= dss.getTempoMinimo())) continue;
                best = dl.getDuration();
            }
        }
        return best;
    }

    public void verificaDoppioClick(double posizione) {
        if (!DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni()) {
            return;
        }
        if (this.giri.getNumeroLinee() < 2) {
            return;
        }
        if (posizione < this.giri.getLinea(0)) {
            return;
        }
        if (posizione > this.giri.getLinea(this.giri.getNumeroLinee() - 1)) {
            return;
        }
        int indice = 0;
        int i = 0;
        while (i < this.giri.getNumeroLinee() && !(posizione < this.giri.getLinea(i))) {
            indice = i++;
        }
        this.rect.setDimensioni(this.giri.getLinea(indice), this.giri.getLinea(indice + 1), true);
    }

    public void pulisciBarra() {
        this.giri.inserisciGiri(new Vector<Double>(), new Vector<Double>());
        this.sceneBase.remove(this.giri);
        this.sceneBase.remove(this.rectBest);
        this.sceneBase.redraw();
        this.sceneBase.refresh();
        this.setDurata(0.0);
        this.setDurata(0.0);
    }

    public void aggiornaGiri() {
        this.sceneBase.remove(this.giri);
        this.sceneBase.remove(this.rectBest);
        if (!DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni()) {
            this.sceneBase.redraw();
            this.sceneBase.refresh();
            return;
        }
        if (DanasDataStructure.getInstance().getDefaultSession() == null) {
            return;
        }
        double best = this.getBestDuration();
        DanasSession sess = DanasDataStructure.getInstance().getDefaultSession();
        Vector<Double> elencoPosizioni = new Vector<Double>();
        Vector<Double> elencoTempi = new Vector<Double>();
        for (int k = 1; k <= sess.getNumberOfLaps(); ++k) {
            DanasLap lap = sess.getLap(k);
            if (lap.getDuration() == best) {
                this.sceneBase.add(this.rectBest);
                if (DanasDataStructure.getInstance().getMainFrame().getModoSpazio()) {
                    double start = sess.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, lap.getStart());
                    double stop = sess.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, lap.getEnd());
                    this.rectBest.setDimensioni(start, stop, false);
                } else {
                    this.rectBest.setDimensioni(lap.getStart() - sess.getStartTelemetryTime(), lap.getEnd() - sess.getStartTelemetryTime(), false);
                }
            }
            if (DanasDataStructure.getInstance().getMainFrame().getModoSpazio()) {
                if (k == 1) {
                    elencoPosizioni.add(sess.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, lap.getStart()));
                }
                if (k == 1) {
                    elencoTempi.add(lap.getStart() - sess.getStartTelemetryTime());
                }
                elencoPosizioni.add(sess.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, lap.getEnd()));
                elencoTempi.add(lap.getEnd() - sess.getStartTelemetryTime());
                continue;
            }
            if (k == 1) {
                elencoPosizioni.add(lap.getStart() - sess.getStartTelemetryTime());
            }
            if (k == 1) {
                elencoTempi.add(lap.getStart() - sess.getStartTelemetryTime());
            }
            elencoPosizioni.add(lap.getEnd() - sess.getStartTelemetryTime());
            elencoTempi.add(lap.getEnd() - sess.getStartTelemetryTime());
        }
        this.sceneBase.add(this.giri);
        this.giri.inserisciGiri(elencoPosizioni, elencoTempi);
        this.sceneBase.redraw();
        this.sceneBase.refresh();
    }

    public void aggiornaRettangolo() {
        this.sceneBase.remove(this.giri);
        double min = this.sincro.getMin();
        double max = this.sincro.getMax();
        this.rect.setDimensioni(min, max, false);
        if (DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni()) {
            this.sceneBase.add(this.giri);
        }
        this.sceneBase.redraw();
        this.sceneBase.refresh();
    }

    public void aggiornaEstremi() {
        if (!DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni()) {
            if (DanasDataStructure.getInstance().getDefaultLap() == null) {
                this.pulisciBarra();
                return;
            }
            DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
            if (DanasDataStructure.getInstance().getMainFrame().getModoSpazio()) {
                double spazio = l.getDistanceCovered(DanasDataStructureConstants.DataType.GPS);
                this.setDurata(spazio);
            } else {
                double tempo = l.getDuration() / 10.0;
                this.setDurata(tempo);
            }
        } else {
            if (DanasDataStructure.getInstance().getDefaultSession() == null) {
                this.pulisciBarra();
                return;
            }
            DanasSession s = DanasDataStructure.getInstance().getDefaultSession();
            if (DanasDataStructure.getInstance().getMainFrame().getModoSpazio()) {
                double spazio = s.getDistanceCovered(DanasDataStructureConstants.DataType.GPS);
                this.setDurata(spazio);
            } else {
                double tempo = s.getDuration() / 10L;
                this.setDurata(tempo);
            }
        }
        this.aggiornaGiri();
        System.out.println("DEBUG: aggiorna giri");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(DanasDataStructure.getInstance())) {
            this.aggiornaEstremi();
        }
        if (e.getSource().equals(this.sincro)) {
            this.aggiornaRettangolo();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.zoomThread == null || !this.zoomThread.isAlive()) {
            this.zoomBufferPieno = false;
            this.bufferZoomValue = 0;
            this.bufferZoomNotches = 0;
            this.notchesZoom = event.getWheelRotation();
            if (this.notchesZoom == 0) {
                return;
            }
            this.zoomThread = new Thread(){

                @Override
                public void run() {
                    GraficoBarra.this.zoomWheel();
                }
            };
            this.zoomThread.start();
        } else {
            this.bufferZoomNotches += event.getWheelRotation();
            ++this.bufferZoomValue;
            this.zoomBufferPieno = true;
        }
    }

    public void zoomWheel() {
        if (this.notchesZoom < 0) {
            this.rect.zoom(0.9);
        } else {
            this.rect.zoom(1.1);
        }
        if (this.zoomBufferPieno) {
            if (this.bufferZoomNotches < 0) {
                this.rect.zoom(Math.pow(0.8, this.bufferZoomValue));
            } else {
                this.rect.zoom(Math.pow(1.2, this.bufferZoomValue));
            }
        }
        this.zoomBufferPieno = false;
        this.bufferZoomValue = 0;
        this.bufferZoomNotches = 0;
        this.sceneBase.redraw();
        this.sceneBase.refresh();
    }

    @Override
    public void event(GScene scene, int event, int x, int y) {
        if (y < 1 || y > 14 || event == 16) {
            this.gestisciBordo(false);
            this.bordoVisibile = false;
            return;
        }
        if (scene == null || scene == (GObject)null) {
            return;
        }
        double[] d0 = scene.getTransformer().deviceToWorld(x, y);
        int[] dstart = scene.getTransformer().worldToDevice(this.rect.getStart(), 0.0);
        int[] dstop = scene.getTransformer().worldToDevice(this.rect.getStop(), 0.0);
        if (x > dstart[0] - 10 && x < dstart[0] + 10 || x > dstop[0] - 10 && x < dstop[0] + 10) {
            this.gestisciBordo(true);
            if (x > dstart[0] - 10 && x < dstart[0] + 10) {
                this.bordo.setPosizione(this.rect.getStart());
            } else {
                this.bordo.setPosizione(this.rect.getStop());
            }
            this.bordoVisibile = true;
            this.giri.draw();
            this.sceneBase.redraw();
            this.sceneBase.refresh();
        } else if (this.bordoVisibile) {
            this.bordoVisibile = false;
            this.gestisciBordo(false);
        }
        switch (event) {
            case 3: {
                long tempoAttuale = System.currentTimeMillis();
                if (this.tempoClick != 0L && tempoAttuale - this.tempoClick < 200L) {
                    this.verificaDoppioClick(d0[0]);
                    return;
                }
                if (d0[0] > this.rect.getStart() && d0[0] < this.rect.getStop()) {
                    this.abilitaTraslazione = true;
                }
                if (x > dstart[0] - 5 && x < dstart[0] + 5) {
                    this.abilitaTraslazione = false;
                    this.abilitaModificaMassimo = false;
                    this.abilitaModificaMinimo = true;
                }
                if (x > dstop[0] - 5 && x < dstop[0] + 5) {
                    this.abilitaTraslazione = false;
                    this.abilitaModificaMinimo = false;
                    this.abilitaModificaMassimo = true;
                }
                this.x0 = d0[0];
                break;
            }
            case 4: {
                if (!(this.abilitaTraslazione || this.abilitaModificaMinimo || this.abilitaModificaMassimo)) {
                    return;
                }
                double[] d1 = scene.getTransformer().deviceToWorld(x, y);
                double differenza = d1[0] - this.x0;
                if (this.abilitaTraslazione) {
                    this.rect.muovi(differenza);
                }
                if (this.abilitaModificaMinimo) {
                    this.rect.spostaInizio(differenza, true);
                }
                if (this.abilitaModificaMassimo) {
                    this.rect.spostaFine(differenza, true);
                }
                this.sceneBase.redraw();
                this.sceneBase.refresh();
                this.x0 = d1[0];
                break;
            }
            case 5: {
                this.tempoClick = System.currentTimeMillis();
                this.abilitaTraslazione = false;
                this.abilitaModificaMinimo = false;
                this.abilitaModificaMassimo = false;
            }
        }
    }

    public static void main(String[] args) {
        GraficoBarra barra = new GraficoBarra();
        JFrame f = new JFrame();
        f.getContentPane().add(barra.getCanvas());
        f.pack();
        f.setSize(new Dimension(1000, 40));
        f.setVisible(true);
    }

    public class Giri
    extends GObject {
        private GSegment rect;
        private Vector<Double> elencoPosizioni = new Vector();
        private Vector<Double> elencoTempi = new Vector();
        private Vector<GSegment> elencoSegmenti = new Vector();
        private Vector<GSegment> elencoTesti = new Vector();
        GStyle style;
        GStyle textStyle;

        public Giri() {
            this.rect = new GSegment();
            this.style = new GStyle();
            this.style.setForegroundColor(Color.white);
            this.style.setBackgroundColor(Color.white);
            this.style.setLineWidth(1);
            this.setStyle(this.style);
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(Color.white);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 1, 10));
        }

        public double getLinea(int indice) {
            if (indice < this.elencoPosizioni.size()) {
                return this.elencoPosizioni.get(indice);
            }
            return -1.0;
        }

        public int getNumeroLinee() {
            return this.elencoPosizioni.size();
        }

        public void inserisciGiri(Vector<Double> posizioni, Vector<Double> tempi) {
            int i;
            this.textStyle.setFont(new Font("Dialog", 1, 12));
            if (posizioni.size() > 6) {
                this.textStyle.setFont(new Font("Dialog", 1, 10));
            }
            if (posizioni.size() > 10) {
                this.textStyle.setFont(new Font("Dialog", 1, 9));
            }
            this.elencoPosizioni.clear();
            this.elencoTempi.clear();
            for (i = 0; i < this.elencoSegmenti.size(); ++i) {
                this.removeSegment(this.elencoSegmenti.get(i));
                this.removeSegment(this.elencoTesti.get(i));
            }
            this.elencoSegmenti.clear();
            this.elencoTesti.clear();
            for (i = 0; i < posizioni.size(); ++i) {
                this.elencoPosizioni.add(posizioni.get(i));
                this.elencoTempi.add(tempi.get(i));
                this.elencoSegmenti.add(new GSegment());
                this.elencoTesti.add(new GSegment());
                String tempo = "";
                if (i < posizioni.size() - 1) {
                    tempo = MeasuresUtil.timeToHumanReadableCompact(10 * (int)(tempi.get(i + 1) - tempi.get(i)));
                }
                GText text = new GText(tempo, 128);
                text.setStyle(this.textStyle);
                this.elencoTesti.get(i).setText(text);
            }
            for (i = 0; i < this.elencoSegmenti.size(); ++i) {
                this.elencoSegmenti.get(i).setStyle(this.style);
                this.addSegment(this.elencoSegmenti.get(i));
                this.addSegment(this.elencoTesti.get(i));
            }
            this.draw();
        }

        @Override
        public void draw() {
            double posizioneTesto = 0.0;
            for (int i = 0; i < this.elencoSegmenti.size(); ++i) {
                try {
                    this.elencoSegmenti.get(i).setGeometry(this.elencoPosizioni.get(i), 0.0, this.elencoPosizioni.get(i), GraficoBarra.this.altezza);
                    posizioneTesto = i < this.elencoSegmenti.size() - 1 ? (this.elencoPosizioni.get(i + 1) + this.elencoPosizioni.get(i)) / 2.0 : GraficoBarra.this.durata * 2.0;
                    this.elencoTesti.get(i).setGeometry(posizioneTesto, GraficoBarra.this.altezza / 2.0);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class Rettangolo
    extends GObject {
        private GSegment rect = new GSegment();
        private double inizio = 0.0;
        private double fine = 1000.0;

        public Rettangolo() {
            GStyle starStyle = new GStyle();
            starStyle.setForegroundColor(Color.blue);
            starStyle.setBackgroundColor(Color.blue);
            this.setStyle(starStyle);
            this.addSegment(this.rect);
        }

        public void setDimensioni(double start, double stop, boolean aggiorna) {
            this.inizio = start;
            this.fine = stop;
            this.draw();
            if (aggiorna) {
                GraficoBarra.this.sincro.setMin(this.inizio);
                GraficoBarra.this.sincro.setMax(this.fine);
                GraficoBarra.this.sincro.setAggiornaAsse(true);
            }
        }

        public void setColor(Color colore) {
            GStyle starStyle = new GStyle();
            starStyle.setForegroundColor(colore);
            starStyle.setBackgroundColor(colore);
            this.setStyle(starStyle);
        }

        public void zoom(double scala) {
            double centro = (this.fine + this.inizio) / 2.0;
            double larghezza = (this.fine - this.inizio) * scala;
            this.inizio = centro - larghezza / 2.0;
            this.fine = centro + larghezza / 2.0;
            if (this.inizio < 0.0) {
                this.inizio = 0.0;
            }
            if (this.fine > GraficoBarra.this.durata) {
                this.fine = GraficoBarra.this.durata;
            }
            GraficoBarra.this.sincro.setMin(this.inizio);
            GraficoBarra.this.sincro.setMax(this.fine);
            GraficoBarra.this.sincro.setAggiornaAsse(true);
        }

        public void muovi(double distanza) {
            this.spostaInizio(distanza, false);
            this.spostaFine(distanza, false);
            GraficoBarra.this.sincro.setMin(this.inizio);
            GraficoBarra.this.sincro.setMax(this.fine);
            GraficoBarra.this.sincro.setAggiornaAsse(true);
        }

        public void spostaInizio(double distanza, boolean aggiorna) {
            this.inizio += distanza;
            if (aggiorna) {
                GraficoBarra.this.sincro.setMin(this.inizio);
                GraficoBarra.this.sincro.setAggiornaAsse(true);
            }
        }

        public void spostaFine(double distanza, boolean aggiorna) {
            this.fine += distanza;
            if (aggiorna) {
                GraficoBarra.this.sincro.setMax(this.fine);
                GraficoBarra.this.sincro.setAggiornaAsse(true);
            }
        }

        public double getStart() {
            return this.inizio;
        }

        public double getStop() {
            return this.fine;
        }

        @Override
        public void draw() {
            this.rect.setGeometryXy(Geometry.createRectangle(this.inizio, 0.0, this.fine - this.inizio, GraficoBarra.this.altezza));
        }
    }

    public class Bordo
    extends GObject {
        private GSegment linea = new GSegment();
        private double posizione = 0.0;

        public Bordo() {
            GStyle starStyle = new GStyle();
            starStyle.setForegroundColor(Color.yellow);
            starStyle.setBackgroundColor(null);
            starStyle.setLineWidth(5);
            this.setStyle(starStyle);
            this.addSegment(this.linea);
        }

        public void setPosizione(double posizione) {
            GraficoBarra.this.sceneBase.remove(GraficoBarra.this.giri);
            this.posizione = posizione;
            this.draw();
            if (DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni()) {
                GraficoBarra.this.sceneBase.add(GraficoBarra.this.giri);
            }
        }

        @Override
        public void draw() {
            this.linea.setGeometry(this.posizione, 0.0, this.posizione, GraficoBarra.this.altezza);
        }
    }
}

