/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.AssiDialog;
import i2m.MainFrame;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.grafico.Curva;
import i2m.grafico.SincronizzatoreGrafico;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Objects;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GInteraction;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GWindow;

public class Grafico2D
implements GInteraction,
MouseWheelListener,
ChangeListener {
    public static final int larghezzaGrigliaX = 100;
    public static final int larghezzaGrigliaY = 75;
    public static final int larghezzaAsse = 55;
    public static final int ZOOM_WINDOW = 2;
    public static final int ZOOM_IN = 3;
    public static final int ZOOM_OUT = 4;
    public static final int MUOVI = 5;
    public static final int CURSORE = 7;
    public static final int TRASLA = 8;
    public static final int CURSORE_2 = 9;
    public static final int ASSE_TEMPO = 0;
    public static final int ASSE_SPAZIO = 1;
    public static final int ASSE_TEMPO_MIL = 2;
    public static final int SCENE_NULL = -1;
    public static final int SCENE_VELGPS = 0;
    public static final int SCENE_RPM = 1;
    public static final int SCENE_VEL1 = 2;
    public static final int SCENE_VEL2 = 3;
    public static final int SCENE_ANALOG1 = 4;
    public static final int SCENE_ANALOG2 = 5;
    public static final int SCENE_ANALOG3 = 6;
    public static final int SCENE_ANALOG4 = 7;
    public static final int SCENE_ANALOG5 = 8;
    public static final int SCENE_ANALOG6 = 9;
    public static final int SCENE_DVELGPS = 10;
    public static final int SCENE_DRPM = 11;
    public static final int SCENE_DVEL1 = 12;
    public static final int SCENE_DVEL2 = 13;
    public static final int SCENE_DANALOG1 = 14;
    public static final int SCENE_DANALOG2 = 15;
    public static final int SCENE_DANALOG3 = 16;
    public static final int SCENE_DANALOG4 = 17;
    public static final int SCENE_DANALOG5 = 18;
    public static final int SCENE_DANALOG6 = 19;
    public static final int STILE_NORMALE = 1;
    public static final int STILE_PUNTINI = 3;
    public static final int STILE_TRATTEGGIO = 2;
    public static final int STILE_ALTERNATO = 4;
    private int mode = 5;
    private int tipoAsse = 0;
    private Color coloreSfondo = new Color(0.95f, 0.95f, 0.95f, 1.0f);
    private GWindow window;
    private Component canvas;
    private GScene sceneTop;
    private GScene sceneBack;
    private Insets bordo;
    private Cornice corniceGrafico;
    private SfondoGrafico sfondo;
    private Griglia grid;
    private Assi axes;
    private GObject selezione;
    private boolean bloccaX = false;
    private boolean bloccaY = false;
    private boolean bloccaMargini = false;
    private int x0;
    private int y0;
    private int xc0;
    private int yc0;
    private double t0 = 0.0;
    private DefaultListModel elencoScene;
    private DefaultListModel elencoSceneVisibili;
    private DefaultListModel elencoSceneAssi;
    private SincronizzatoreGrafico sincro;
    private LineaCursore lineaCursore;
    private LineaCursore2 lineaCursore2;
    private boolean modoSpazio = false;
    private final int NUM_CURVE = MeasuresUtil.getNumeroCurve();
    private SincronizzatoreMappaGraficoVideo multiSincro = null;
    private Vector<LineaIntertempo> elencoLinee = new Vector();
    private Vector<MarkerMassimoMinimo> elencoMassimiMinimi = new Vector();
    boolean bloccaSincro = false;
    Thread zoomThread = null;
    boolean muoviConCursore = false;
    boolean traslazioneInCorso = false;
    boolean cursore2Aggiunto = false;
    MainFrame mainF = DanasDataStructure.getInstance().getMainFrame();
    long tempoClick = 0L;
    private Vector<GSegment> elencoSegmentiPuntoInfo = new Vector();
    private Vector<Double> elencoValoriPuntoInfo = new Vector();
    private Vector<Color> elencoColoriPuntoInfo = new Vector();
    private Vector<Integer> elencoCampiPuntoInfo = new Vector();
    public int i = 0;
    public int tempo = 0;
    public int lastTime = 0;
    public boolean isRunning = false;
    int Xzoom = 0;
    int Yzoom = 0;
    int notchesZoom = 0;
    boolean zoomBufferPieno = false;
    int bufferZoomValue = 0;
    int bufferZoomNotches = 0;

    public Grafico2D() {
        this.elencoScene = new DefaultListModel();
        this.elencoScene.clear();
        this.elencoSceneVisibili = new DefaultListModel();
        this.elencoSceneVisibili.clear();
        this.elencoSceneAssi = new DefaultListModel();
        this.elencoSceneAssi.clear();
        this.window = new GWindow(this.coloreSfondo);
        this.sceneBack = new GScene(this.window);
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            GScene scenaLista = new GScene(this.window);
            scenaLista.setWorldExtent(0.0, 0.0, 10.0, 10.0);
            scenaLista.setVisibility(240);
            this.elencoScene.addElement(scenaLista);
        }
        this.sceneTop = new GScene(this.window);
        this.canvas = this.window.getCanvas();
        this.canvas.addMouseWheelListener(this);
        this.sceneTop.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.sceneBack.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.bordo = new Insets(8, 5, 25, 5);
        this.corniceGrafico = new Cornice();
        this.corniceGrafico.toFront();
        this.sfondo = new SfondoGrafico();
        this.grid = new Griglia();
        this.axes = new Assi();
        this.selezione = new GObject();
        GStyle selezioneStyle = new GStyle();
        selezioneStyle.setLineStyle(new float[]{10.0f, 10.0f});
        selezioneStyle.setForegroundColor(Color.WHITE);
        selezioneStyle.setBackgroundColor(new Color(0.4f, 0.4f, 0.4f, 0.2f));
        this.selezione.setStyle(selezioneStyle);
        this.selezione.toFront();
        this.lineaCursore = new LineaCursore(0.0);
        this.lineaCursore2 = new LineaCursore2(0.0);
        this.sceneBack.add(this.sfondo);
        this.sceneTop.add(this.corniceGrafico);
        this.sceneTop.add(this.axes);
        this.sceneTop.add(this.selezione);
        this.sceneTop.toFront();
        this.window.startInteraction(this);
    }

    public void setMargini(int top, int bottom, int left, int right) {
        this.bordo.left = left;
        this.bordo.right = right;
        this.bordo.top = top;
        this.bordo.bottom = bottom;
    }

    public void setMargineLeft(int left) {
        this.bordo.left = left;
    }

    public void setBloccaMargini(boolean blocca) {
        this.bloccaMargini = blocca;
    }

    public boolean getBloccaMargini() {
        return this.bloccaMargini;
    }

    public void setSincronizzatoreMappaGraficoVideo(SincronizzatoreMappaGraficoVideo sincro) {
        this.multiSincro = sincro;
    }

    public Component getGrafico() {
        return this.window.getCanvas();
    }

    public void setModoSpazio(boolean spazio) {
        if (spazio == this.modoSpazio) {
            return;
        }
        this.modoSpazio = spazio;
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            GScene s = this.getScene(i);
            int numeroCurve = s.getNChildren();
            for (int j = 0; j < numeroCurve; ++j) {
                ((Curva)s.getChild(j)).setModoSpazio(this.modoSpazio, true);
            }
        }
        this.tipoAsse = this.modoSpazio ? 1 : 0;
        this.refresh();
    }

    public void setBackgroundColor(Color colore, boolean refresh) {
        this.sfondo.setColor(colore);
        if (refresh) {
            this.sceneBack.redraw();
            this.sceneBack.refresh();
        }
    }

    public void aggiungiCurva(int scenaIndex, Curva curve) {
        ((GScene)this.elencoScene.getElementAt(scenaIndex)).add(curve);
    }

    public void rimuoviCurva(int scenaIndex, String nome) {
        Curva c;
        int i;
        GScene scena = (GScene)this.elencoScene.getElementAt(scenaIndex);
        int num = scena.getNChildren();
        for (i = 0; i < num; ++i) {
            c = (Curva)scena.getChild(i);
            if (!c.getNome().equals(nome)) continue;
            scena.remove(c);
            break;
        }
        num = scena.getNChildren();
        for (i = 0; i < num; ++i) {
            c = (Curva)scena.getChild(i);
            if (!c.getNome().equals(nome)) continue;
            scena.remove(c);
            System.out.println("Tolto due volte la stessa curva!!");
            break;
        }
    }

    public Curva getCurva(int scenaIndex, String nome) {
        GScene scena = (GScene)this.elencoScene.getElementAt(scenaIndex);
        int num = scena.getNChildren();
        for (int i = 0; i < num; ++i) {
            Curva c = (Curva)scena.getChild(i);
            if (!c.getNome().equals(nome)) continue;
            return c;
        }
        return null;
    }

    public void rimuoviTutto(int scenaIndex) {
        ((GScene)this.elencoScene.getElementAt(scenaIndex)).removeAll();
    }

    public void setSpessore(int scenaIndex, int spessore) {
        GScene scena = (GScene)this.elencoScene.getElementAt(scenaIndex);
        int num = scena.getNChildren();
        for (int i = 0; i < num; ++i) {
            ((Curva)scena.getChild(i)).setSpessore(spessore);
        }
        scena.refresh();
    }

    public void setRef(int scenaIndex, int tipoRef, double valore) {
        GScene scena = (GScene)this.elencoScene.getElementAt(scenaIndex);
        int num = scena.getNChildren();
        for (int i = 0; i < num; ++i) {
            ((Curva)scena.getChild(i)).setTipoRef(tipoRef);
            ((Curva)scena.getChild(i)).setValoreRef(valore);
        }
        scena.refresh();
    }

    public void setStile(int scenaIndex, int stile) {
        GScene scena = (GScene)this.elencoScene.getElementAt(scenaIndex);
        int num = scena.getNChildren();
        for (int i = 0; i < num; ++i) {
            ((Curva)scena.getChild(i)).setStile(stile);
        }
        scena.refresh();
    }

    public void setColore(int scenaIndex, Color colore) {
        GScene scena = (GScene)this.elencoScene.getElementAt(scenaIndex);
        int num = scena.getNChildren();
        for (int i = 0; i < num; ++i) {
            ((Curva)scena.getChild(i)).setColore(colore);
        }
        scena.refresh();
    }

    public void setAllFuturoAsseX(double min, double max, int larghezza, boolean refresh) {
        this.getAsseX();
        if (max <= min) {
            return;
        }
        for (int i = -1; i < this.elencoSceneVisibili.size(); ++i) {
            int scena = i == -1 ? -1 : (Integer)this.elencoSceneVisibili.getElementAt(i);
            this.setFuturoAsseX(min, max, scena, larghezza);
        }
        if (refresh) {
            this.refresh();
        }
    }

    private void setFuturoAsseX(double min, double max, int scenaIndex, int larghezza) {
        double minimoDouble;
        if (max <= min) {
            return;
        }
        GScene sceneTemp = scenaIndex == -1 ? this.sceneTop : (GScene)this.elencoScene.getElementAt(scenaIndex);
        double[] w0 = sceneTemp.getWorldExtent().get(0);
        double[] w1 = sceneTemp.getWorldExtent().get(1);
        double[] w2 = sceneTemp.getWorldExtent().get(2);
        int larghezzaIntera = larghezza;
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return;
        }
        double larghezzaDouble = (max - min) * (double)larghezzaIntera / (double)(larghezzaIntera - this.bordo.left - this.bordo.right);
        w0[0] = minimoDouble = min - larghezzaDouble * (double)this.bordo.left / (double)larghezzaIntera;
        w2[0] = minimoDouble;
        w1[0] = minimoDouble + larghezzaDouble;
        sceneTemp.setWorldExtent(w0, w1, w2);
    }

    private synchronized void setAsseX(double min, double max, int scenaIndex) {
        double minimoDouble;
        if (max <= min) {
            return;
        }
        GScene sceneTemp = scenaIndex == -1 ? this.sceneTop : (GScene)this.elencoScene.getElementAt(scenaIndex);
        double[] w0 = sceneTemp.getWorldExtent().get(0);
        double[] w1 = sceneTemp.getWorldExtent().get(1);
        double[] w2 = sceneTemp.getWorldExtent().get(2);
        int[] d0 = sceneTemp.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = sceneTemp.getTransformer().worldToDevice(w1[0], w1[1]);
        int larghezzaIntera = d1[0] - d0[0];
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return;
        }
        double larghezzaDouble = (max - min) * (double)larghezzaIntera / (double)(larghezzaIntera - this.bordo.left - this.bordo.right);
        w0[0] = minimoDouble = min - larghezzaDouble * (double)this.bordo.left / (double)larghezzaIntera;
        w2[0] = minimoDouble;
        w1[0] = minimoDouble + larghezzaDouble;
        sceneTemp.setWorldExtent(w0, w1, w2);
    }

    public synchronized void setAllAsseX(double min, double max, boolean refresh) {
        this.getAsseX();
        if (max <= min) {
            return;
        }
        for (int i = -1; i < this.elencoSceneVisibili.size(); ++i) {
            int scena = i == -1 ? -1 : (Integer)this.elencoSceneVisibili.getElementAt(i);
            this.setAsseX(min, max, scena);
        }
        if (refresh) {
            this.refresh();
        }
    }

    public void setAsseY(double min, double max, int sceneIndex, boolean refresh) {
        double minimoDouble;
        int[] d2;
        if (max <= min) {
            return;
        }
        GScene scenaTemp = sceneIndex == -1 ? this.sceneTop : (GScene)this.elencoScene.getElementAt(sceneIndex);
        double[] w0 = scenaTemp.getWorldExtent().get(0);
        double[] w1 = scenaTemp.getWorldExtent().get(1);
        double[] w2 = scenaTemp.getWorldExtent().get(2);
        int[] d0 = scenaTemp.getTransformer().worldToDevice(w0[0], w0[1]);
        int altezzaIntera = d0[1] - (d2 = scenaTemp.getTransformer().worldToDevice(w2[0], w2[1]))[1];
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return;
        }
        double altezzaDouble = (max - min) * (double)altezzaIntera / (double)(altezzaIntera - this.bordo.top - this.bordo.bottom);
        w0[1] = minimoDouble = min - altezzaDouble * (double)this.bordo.bottom / (double)altezzaIntera;
        w2[1] = minimoDouble + altezzaDouble;
        w1[1] = minimoDouble;
        scenaTemp.setWorldExtent(w0, w1, w2);
        if (refresh) {
            scenaTemp.redraw();
        }
    }

    public void setAsseY(double min, double max, int sceneIndex, int altezza, boolean refresh) {
        double minimoDouble;
        if (max <= min) {
            return;
        }
        GScene scenaTemp = sceneIndex == -1 ? this.sceneTop : (GScene)this.elencoScene.getElementAt(sceneIndex);
        double[] w0 = scenaTemp.getWorldExtent().get(0);
        double[] w1 = scenaTemp.getWorldExtent().get(1);
        double[] w2 = scenaTemp.getWorldExtent().get(2);
        int altezzaIntera = altezza;
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return;
        }
        double altezzaDouble = (max - min) * (double)altezzaIntera / (double)(altezzaIntera - this.bordo.top - this.bordo.bottom);
        w0[1] = minimoDouble = min - altezzaDouble * (double)this.bordo.bottom / (double)altezzaIntera;
        w2[1] = minimoDouble + altezzaDouble;
        w1[1] = minimoDouble;
        scenaTemp.setWorldExtent(w0, w1, w2);
        if (refresh) {
            scenaTemp.redraw();
            scenaTemp.refresh();
        }
    }

    public double[] getAsseY(GScene scenaTemp) {
        int[] d2;
        double[] asse = new double[]{0.0, 0.0};
        double[] w0 = scenaTemp.getWorldExtent().get(0);
        double[] w2 = scenaTemp.getWorldExtent().get(2);
        int[] d0 = scenaTemp.getTransformer().worldToDevice(w0[0], w0[1]);
        int altezzaIntera = d0[1] - (d2 = scenaTemp.getTransformer().worldToDevice(w2[0], w2[1]))[1];
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return asse;
        }
        double altezzaDouble = w2[1] - w0[1];
        double minimoDouble = altezzaDouble * (double)this.bordo.bottom / (double)altezzaIntera;
        asse[0] = w0[1] + minimoDouble;
        asse[1] = asse[0] + ((double)altezzaIntera - (double)(this.bordo.top + this.bordo.bottom)) * altezzaDouble / (double)altezzaIntera;
        return asse;
    }

    public int getWidth() {
        return this.window.getWidth();
    }

    public double[] getAsseX() {
        double[] asse = new double[]{0.0, 0.0};
        double[] w0 = this.sceneTop.getWorldExtent().get(0);
        double[] w1 = this.sceneTop.getWorldExtent().get(1);
        int[] d0 = this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = this.sceneTop.getTransformer().worldToDevice(w1[0], w1[1]);
        int larghezzaIntera = d1[0] - d0[0];
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return asse;
        }
        double larghezzaDouble = w1[0] - w0[0];
        double minimoDouble = larghezzaDouble * (double)this.bordo.left / (double)larghezzaIntera;
        asse[0] = w0[0] + minimoDouble;
        asse[1] = asse[0] + (double)(larghezzaIntera - this.bordo.left - this.bordo.right) * larghezzaDouble / (double)larghezzaIntera;
        return asse;
    }

    public double[] getAsseY(int scenaIndex) {
        GScene s = (GScene)this.elencoScene.getElementAt(scenaIndex);
        return this.getAsseY(s);
    }

    public int getNumeroDivisioniX() {
        int x0 = this.sceneTop.getViewport().getX0();
        int x1 = this.sceneTop.getViewport().getX1();
        int larghezzaIntera = x1 - x0;
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return 1;
        }
        int res = (larghezzaIntera - this.bordo.left - this.bordo.right) / 100;
        if (res != 0) {
            return (larghezzaIntera - this.bordo.left - this.bordo.right) / 100;
        }
        return 1;
    }

    public int getNumeroDivisioniY(GScene scenaTemp) {
        int y0 = scenaTemp.getViewport().getY0();
        int y2 = scenaTemp.getViewport().getY2();
        int altezzaIntera = y2 - y0;
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return 1;
        }
        int res = (altezzaIntera - this.bordo.top - this.bordo.bottom) / 75;
        if (res != 0) {
            return (altezzaIntera - this.bordo.top - this.bordo.bottom) / 75;
        }
        return 1;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int modo) {
        this.mode = modo;
        if (this.mode == 7) {
            this.sceneTop.add(this.lineaCursore);
            this.lineaCursore.draw();
            this.refresh();
        } else if (this.mode != 9) {
            this.sceneTop.remove(this.lineaCursore);
            this.refresh();
        }
    }

    public void addCursore2(boolean visualizza) {
        if (visualizza) {
            this.sceneTop.add(this.lineaCursore2);
            this.lineaCursore2.draw();
            this.refresh();
        } else {
            this.sceneTop.remove(this.lineaCursore2);
            this.refresh();
        }
    }

    public void aggiungiSincronizzatore(SincronizzatoreGrafico sinc) {
        this.sincro = sinc;
        this.sincro.addChangeListener(this);
    }

    public void rimuoviSincronizzatore() {
        if (this.sincro != null) {
            this.sincro.removeChangeListener(this);
        }
    }

    private void zoomPoint(int x, int y, double zoom) {
        for (int i = 0; i < this.elencoSceneVisibili.size(); ++i) {
            GScene temp = (GScene)this.elencoScene.getElementAt((Integer)this.elencoSceneVisibili.getElementAt(i));
            this.myZoom(x, y, zoom, temp);
        }
        this.myZoom(x, y, zoom, this.sceneTop);
        this.refresh();
    }

    private void zoomPoint(int x, int y, double zoom, boolean orizzontale) {
        for (int i = 0; i < this.elencoSceneVisibili.size(); ++i) {
            GScene temp = (GScene)this.elencoScene.getElementAt((Integer)this.elencoSceneVisibili.getElementAt(i));
            this.myZoom(x, y, zoom, temp, orizzontale);
        }
        this.myZoom(x, y, zoom, this.sceneTop, orizzontale);
        this.refresh();
    }

    private void panMouse(int dx) {
        if (this.elencoSceneVisibili.size() != 0) {
            for (int i = 0; i < this.elencoSceneVisibili.size(); ++i) {
                GScene temp = (GScene)this.elencoScene.getElementAt((Integer)this.elencoSceneVisibili.getElementAt(i));
                this.myPan(dx, 0, temp);
            }
        }
        this.myPan(dx, 0, this.sceneTop);
        this.refresh();
    }

    private void myPan(int dx, int dy, GScene scena) {
        int x0 = scena.getViewport().getX0() - dx;
        int y0 = scena.getViewport().getY0() - dy;
        int x1 = scena.getViewport().getX3() - dx;
        int y1 = scena.getViewport().getY3() - dy;
        this.myZoom(x0, y0, x1, y1, scena);
    }

    private void myZoom(int x, int y, double zoomFactor, GScene scena) {
        int x0 = scena.getViewport().getX0();
        int y0 = scena.getViewport().getY0();
        int x1 = scena.getViewport().getX3();
        int y1 = scena.getViewport().getY3();
        if (!this.bloccaX) {
            x0 = (int)((double)x0 + (1.0 - zoomFactor) * (double)(x - x0));
            x1 = (int)((double)x1 - (1.0 - zoomFactor) * (double)(x1 - x));
        }
        if (!this.bloccaY) {
            y0 = (int)((double)y0 + (1.0 - zoomFactor) * (double)(y - y0));
            y1 = (int)((double)y1 - (1.0 - zoomFactor) * (double)(y1 - y));
        }
        double[] w0 = scena.getTransformer().deviceToWorld(x0, y1);
        double[] w1 = scena.getTransformer().deviceToWorld(x1, y1);
        double[] w2 = scena.getTransformer().deviceToWorld(x0, y0);
        scena.setWorldExtent(w0, w1, w2);
    }

    private void myZoom(int x0, int y0, int x1, int y1, GScene scena) {
        int temp;
        int y1Out;
        int y0Out;
        int x1Out;
        int x0Out;
        int x0In = scena.getViewport().getX0();
        int y0In = scena.getViewport().getY0();
        int x1In = scena.getViewport().getX3();
        int y1In = scena.getViewport().getY3();
        if (this.bloccaX) {
            x0Out = x0In;
            x1Out = x1In;
        } else {
            x0Out = x0;
            x1Out = x1;
        }
        if (this.bloccaY) {
            y0Out = y0In;
            y1Out = y1In;
        } else {
            y0Out = y0;
            y1Out = y1;
        }
        if (x1 < x0) {
            temp = x0Out;
            x0Out = x1Out;
            x1Out = temp;
        }
        if (y1 < y0) {
            temp = y0Out;
            y0Out = y1Out;
            y1Out = temp;
        }
        double[] w0 = scena.getTransformer().deviceToWorld(x0Out, y1Out);
        double[] w1 = scena.getTransformer().deviceToWorld(x1Out, y1Out);
        double[] w2 = scena.getTransformer().deviceToWorld(x0Out, y0Out);
        scena.setWorldExtent(w0, w1, w2);
    }

    private void zoomWindow(int x1, int y1, int x2, int y2) {
        if (x1 != x2 && y1 != y2) {
            for (int i = 0; i < this.elencoSceneVisibili.size(); ++i) {
                GScene temp = (GScene)this.elencoScene.getElementAt((Integer)this.elencoSceneVisibili.getElementAt(i));
                this.myZoom(x1, y1, x2, y2, temp);
            }
            this.myZoom(x1, y1, x2, y2, this.sceneTop);
            this.refresh();
        }
    }

    private void zoomWindow(int x1, int x2) {
        if (x1 != x2) {
            for (int i = 0; i < this.elencoSceneVisibili.size(); ++i) {
                GScene temp = (GScene)this.elencoScene.getElementAt((Integer)this.elencoSceneVisibili.getElementAt(i));
                this.myZoomOrizzontaleOrizzontale(x1, x2, temp);
            }
            this.myZoomOrizzontaleOrizzontale(x1, x2, this.sceneTop);
            this.refresh();
        }
    }

    private void myZoomOrizzontaleOrizzontale(int x0, int x1, GScene scena) {
        int y0In = scena.getViewport().getY0();
        int y1In = scena.getViewport().getY3();
        int x0Out = x0;
        int x1Out = x1;
        int y0Out = y0In;
        int y1Out = y1In;
        if (x1 < x0) {
            int temp = x0Out;
            x0Out = x1Out;
            x1Out = temp;
        }
        double[] w0 = scena.getTransformer().deviceToWorld(x0Out, y1Out);
        double[] w1 = scena.getTransformer().deviceToWorld(x1Out, y1Out);
        double[] w2 = scena.getTransformer().deviceToWorld(x0Out, y0Out);
        scena.setWorldExtent(w0, w1, w2);
    }

    private void myZoom(int x, int y, double zoomFactor, GScene scena, boolean orizzontale) {
        int x0 = scena.getViewport().getX0();
        int y0 = scena.getViewport().getY0();
        int x1 = scena.getViewport().getX3();
        int y1 = scena.getViewport().getY3();
        if (orizzontale) {
            x0 = (int)((double)x0 + (1.0 - zoomFactor) * (double)(x - x0));
            x1 = (int)((double)x1 - (1.0 - zoomFactor) * (double)(x1 - x));
        }
        if (!orizzontale) {
            y0 = (int)((double)y0 + (1.0 - zoomFactor) * (double)(y - y0));
            y1 = (int)((double)y1 - (1.0 - zoomFactor) * (double)(y1 - y));
        }
        double[] w0 = scena.getTransformer().deviceToWorld(x0, y1);
        double[] w1 = scena.getTransformer().deviceToWorld(x1, y1);
        double[] w2 = scena.getTransformer().deviceToWorld(x0, y0);
        scena.setWorldExtent(w0, w1, w2);
    }

    public synchronized void refresh() {
        try {
            this.window.redraw();
            this.window.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Errore nel refresh iniziale grafico");
        }
    }

    public void setBloccaX(boolean blocca) {
        this.bloccaX = blocca;
    }

    public void setBloccaY(boolean blocca) {
        this.bloccaY = blocca;
    }

    public void stampaAssi() {
        this.sceneTop.getWorldExtent().get(0);
        this.sceneTop.getWorldExtent().get(1);
        for (int i = 0; i < this.elencoScene.size(); ++i) {
            GScene temp = (GScene)this.elencoScene.getElementAt(i);
            temp.getWorldExtent().get(0);
            temp.getWorldExtent().get(1);
        }
    }

    public static String stampaValoreAsse(Double valore) {
        String s = null;
        s = valore.toString();
        if (valore > 1000.0) {
            s = String.format("%.0f", valore);
        }
        if (valore >= 1000000.0) {
            s = String.format("%.1fM", valore / 1000000.0);
        }
        if (valore < -1000.0) {
            s = String.format("%.0f", valore);
        }
        if (valore <= -1000000.0) {
            s = String.format("%.1fM", valore / 1000000.0);
        }
        return s;
    }

    public static String stampaSpazioTempo(double valore, int tipo) {
        if (tipo == 0) {
            double positivo = Math.abs(valore);
            int ore = (int)(positivo / 360000.0);
            int minuti = (int)((positivo - (double)(ore * 360000)) / 6000.0);
            int secondi = (int)((positivo - (double)(minuti * 6000) - (double)(ore * 360000)) / 100.0);
            int centesimi = (int)(positivo - (double)(secondi * 100) - (double)(minuti * 6000) - (double)(ore * 360000));
            if (valore >= 0.0) {
                return String.format("%d:%02d:%02d.%02d", ore, minuti, secondi, centesimi);
            }
            return String.format("-%d:%02d:%02d.%02d", ore, minuti, secondi, centesimi);
        }
        if (tipo == 2) {
            double positivo = Math.abs(valore);
            int ore = (int)(positivo / 360000.0);
            int minuti = (int)((positivo - (double)(ore * 360000)) / 6000.0);
            int secondi = (int)((positivo - (double)(minuti * 6000) - (double)(ore * 360000)) / 100.0);
            int centesimi = (int)((positivo - (double)secondi * 100.0 - (double)minuti * 6000.0 - (double)ore * 360000.0) * 10.0);
            if (valore >= 0.0) {
                return String.format("%d:%02d:%02d.%03d", ore, minuti, secondi, centesimi);
            }
            return String.format("-%d:%02d:%02d.%03d", ore, minuti, secondi, centesimi);
        }
        return Double.valueOf(valore).toString();
    }

    public void setScenaVisibile(int scenaIndex, boolean visibile) {
        if (scenaIndex < 0 || scenaIndex > this.elencoScene.size() - 1) {
            return;
        }
        GScene temp = (GScene)this.elencoScene.getElementAt(scenaIndex);
        for (int i = 0; i < this.elencoSceneVisibili.size(); ++i) {
            if ((Integer)this.elencoSceneVisibili.getElementAt(i) != scenaIndex) continue;
            if (!visibile) {
                this.elencoSceneVisibili.removeElementAt(i);
                temp.setVisibility(240);
                this.mostraAsse(scenaIndex, false);
                break;
            }
            return;
        }
        if (visibile) {
            this.elencoSceneVisibili.add(0, scenaIndex);
            temp.setVisibility(15);
            this.mostraAsse(scenaIndex, true);
            double[] asse = this.getAsseX();
            this.setAsseX(asse[0], asse[1], scenaIndex);
        }
        if (this.elencoSceneVisibili.size() == 0) {
            this.sceneTop.remove(this.grid);
        } else {
            this.sceneTop.add(this.grid);
        }
    }

    public void mostraAsse(int scenaIndex, boolean mostra) {
        if (scenaIndex < 0 || scenaIndex > this.elencoScene.size() - 1) {
            return;
        }
        for (int i = 0; i < this.elencoSceneAssi.size(); ++i) {
            if ((Integer)this.elencoSceneAssi.getElementAt(i) != scenaIndex) continue;
            if (!mostra) {
                this.elencoSceneAssi.removeElementAt(i);
                break;
            }
            return;
        }
        if (mostra) {
            this.elencoSceneAssi.add(0, scenaIndex);
        }
        if (!this.bloccaMargini) {
            this.bordo.left = this.elencoSceneAssi.size() == 0 ? 5 : 55 * this.elencoSceneAssi.size();
        }
    }

    public void ridisegnaSfondo() {
        this.sfondo.redraw();
    }

    public int getNumeroAssi() {
        return this.elencoSceneAssi.size();
    }

    public void rimuoviAllAssi() {
        this.elencoSceneAssi.clear();
        if (!this.bloccaMargini) {
            this.bordo.left = 5;
        }
    }

    public void setAllInvisible() {
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            ((GScene)this.elencoScene.getElementAt(i)).setVisibility(240);
        }
        this.elencoSceneVisibili.clear();
        this.sceneTop.remove(this.grid);
    }

    private double getDivisioneDouble(double min, double max, int numDivisioni) {
        double datoGrezzo = (max - min) / (double)numDivisioni;
        double logaritmo = Math.log10(datoGrezzo);
        int numeroZeri = logaritmo > 0.0 ? (int)logaritmo : (int)logaritmo - 1;
        double cifraSignificativa = datoGrezzo / Math.pow(10.0, numeroZeri);
        int cifraSignificativaIntera = (int)Math.round(cifraSignificativa);
        int matrice = 1;
        switch (cifraSignificativaIntera) {
            case 1: {
                matrice = 1;
                break;
            }
            case 2: 
            case 3: {
                matrice = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                matrice = 5;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                matrice = 10;
            }
        }
        double base = (double)matrice * Math.pow(10.0, numeroZeri);
        return base;
    }

    private double getNumeroPulito(double valore, double matrice) {
        int numeroZeri = Math.log10(matrice) > 0.0 ? (int)Math.abs(Math.log10(matrice)) : (int)Math.abs(Math.log10(matrice)) + 1;
        long arrotondamento = (long)(valore * Math.pow(10.0, numeroZeri));
        return (double)arrotondamento / Math.pow(10.0, numeroZeri);
    }

    public GScene getScene(int sceneIndex) {
        return (GScene)this.elencoScene.getElementAt(sceneIndex);
    }

    public void rimuoviPuntiInfo() {
        this.elencoValoriPuntoInfo.clear();
        this.elencoColoriPuntoInfo.clear();
        this.elencoCampiPuntoInfo.clear();
        this.lineaCursore.redraw();
    }

    public void aggiungiPuntoInfo(Double valore, Color colore, int campo) {
        this.elencoValoriPuntoInfo.addElement(valore);
        this.elencoColoriPuntoInfo.addElement(colore);
        this.elencoCampiPuntoInfo.addElement(campo);
    }

    public void aggiungiLineaIntertempo(double spazio, double tempo, String scritta, String ID, Color colore) {
        LineaIntertempo linea = new LineaIntertempo(spazio, tempo, scritta, ID, colore);
        this.elencoLinee.add(linea);
        this.sceneTop.add(linea);
    }

    public void rimuoviLineaIntertempo(String ID) {
        if (this.elencoLinee.size() == 0) {
            return;
        }
        for (int i = 0; i < this.elencoLinee.size(); ++i) {
            if (!this.elencoLinee.get(i).getId().equals(ID)) continue;
            this.sceneTop.remove(this.elencoLinee.get(i));
            this.elencoLinee.removeElement(this.elencoLinee.get(i));
            --i;
        }
    }

    public void rimuoviAllLineeIntertempo() {
        if (this.elencoLinee.size() == 0) {
            return;
        }
        for (int i = 0; i < this.elencoLinee.size(); ++i) {
            this.sceneTop.remove(this.elencoLinee.get(i));
            this.elencoLinee.removeElement(this.elencoLinee.get(i));
            --i;
        }
    }

    public void aggiungiMarkerMaxMin(double y, double spazio, double tempo, String scritta, Color colore, boolean mostra) {
        MarkerMassimoMinimo linea = new MarkerMassimoMinimo(y, spazio, tempo, scritta, colore, mostra);
        this.elencoMassimiMinimi.add(linea);
        this.sceneTop.add(linea);
    }

    public void rimuoviAllMarkerMaxMin() {
        if (this.elencoMassimiMinimi.size() == 0) {
            return;
        }
        for (int i = 0; i < this.elencoMassimiMinimi.size(); ++i) {
            this.sceneTop.remove(this.elencoMassimiMinimi.get(i));
            this.elencoMassimiMinimi.removeElement(this.elencoMassimiMinimi.get(i));
            --i;
        }
    }

    public void setGriliaVerticale(boolean attiva) {
        this.grid.setGrigliaVerticale(attiva);
    }

    public void setGrigliaOrizzontale(boolean attiva) {
        this.grid.setGrigliaOrizzontale(attiva);
    }

    public String getNomeAsse(int index) {
        String s = MeasuresUtil.getNomeCanale(index);
        if (s.length() > 4) {
            return s.substring(0, 4) + ".";
        }
        return s;
    }

    public void zoomWheel() {
        boolean modTrasla = this.mainF.getModTrasla();
        if (this.notchesZoom > 0) {
            if (modTrasla) {
                if (this.mainF.getCtrlPressed()) {
                    this.zoomPoint(this.Xzoom, this.Yzoom, 0.85, true);
                } else if (this.mainF.getAltPressed()) {
                    this.zoomPoint(this.Xzoom, this.Yzoom, 0.85, false);
                } else {
                    this.panMouse(-50);
                }
            } else if (this.mainF.getCtrlPressed()) {
                this.panMouse(-50);
            } else if (this.mainF.getAltPressed()) {
                this.zoomPoint(this.Xzoom, this.Yzoom, 0.85, false);
            } else {
                this.zoomPoint(this.Xzoom, this.Yzoom, 0.85, true);
            }
        } else if (modTrasla) {
            if (this.mainF.getCtrlPressed()) {
                this.zoomPoint(this.Xzoom, this.Yzoom, 1.15, true);
            } else if (this.mainF.getAltPressed()) {
                this.zoomPoint(this.Xzoom, this.Yzoom, 1.15, false);
            } else {
                this.panMouse(50);
            }
        } else if (this.mainF.getCtrlPressed()) {
            this.panMouse(50);
        } else if (this.mainF.getAltPressed()) {
            this.zoomPoint(this.Xzoom, this.Yzoom, 1.15, false);
        } else {
            this.zoomPoint(this.Xzoom, this.Yzoom, 1.15, true);
        }
        this.chiamaSincronizzazione();
        if (this.zoomBufferPieno) {
            if (this.bufferZoomNotches > 0) {
                if (modTrasla) {
                    if (this.mainF.getCtrlPressed()) {
                        this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(0.8, this.bufferZoomValue), true);
                    } else if (this.mainF.getAltPressed()) {
                        this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(0.8, this.bufferZoomValue), false);
                    } else {
                        this.panMouse(-90 * this.bufferZoomValue / 2);
                    }
                } else if (this.mainF.getCtrlPressed()) {
                    this.panMouse(-90 * this.bufferZoomValue / 2);
                } else if (this.mainF.getAltPressed()) {
                    this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(0.8, this.bufferZoomValue), false);
                } else {
                    this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(0.8, this.bufferZoomValue), true);
                }
            } else if (modTrasla) {
                if (this.mainF.getCtrlPressed()) {
                    this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(1.2, this.bufferZoomValue), true);
                } else if (this.mainF.getAltPressed()) {
                    this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(1.2, this.bufferZoomValue), false);
                } else {
                    this.panMouse(90 * this.bufferZoomValue / 2);
                }
            } else if (this.mainF.getCtrlPressed()) {
                this.panMouse(90 * this.bufferZoomValue / 2);
            } else if (this.mainF.getAltPressed()) {
                this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(1.2, this.bufferZoomValue), false);
            } else {
                this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(1.2, this.bufferZoomValue), true);
            }
            this.chiamaSincronizzazione();
        }
        this.zoomBufferPieno = false;
        this.bufferZoomValue = 0;
        this.bufferZoomNotches = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        int rotazione;
        block19: {
            block18: {
                if (this.getMode() != 5 && this.getMode() != 7) {
                    if (this.getMode() != 9) return;
                }
                rotazione = event.getWheelRotation();
                boolean modTrasla = this.mainF.getModTrasla();
                if (!modTrasla) break block18;
                if (this.mainF.getCtrlPressed() || this.mainF.getAltPressed()) {
                    if (this.mainF.getModInvertiZoom()) {
                        rotazione = -rotazione;
                    }
                    break block19;
                } else if (this.mainF.getModInvertiTrasla()) {
                    rotazione = -rotazione;
                }
                break block19;
            }
            if (this.mainF.getCtrlPressed()) {
                if (this.mainF.getModInvertiTrasla()) {
                    rotazione = -rotazione;
                }
            } else if (this.mainF.getModInvertiZoom()) {
                rotazione = -rotazione;
            }
        }
        try {
            block21: {
                block20: {
                    if (event.getWheelRotation() == 0) {
                        return;
                    }
                    if (this.zoomThread == null || !this.zoomThread.isAlive()) break block20;
                    Grafico2D grafico2D = this;
                    if (!grafico2D.zoomThread.interrupted()) break block21;
                }
                this.zoomBufferPieno = false;
                this.bufferZoomValue = 0;
                this.bufferZoomNotches = 0;
                this.notchesZoom = rotazione;
                this.Xzoom = event.getX();
                this.Yzoom = event.getY();
                this.zoomThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Grafico2D.this.zoomWheel();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.zoomThread.start();
                return;
            }
            this.bufferZoomNotches += rotazione;
            if (this.bufferZoomValue != 0) {
                ++this.bufferZoomValue;
            }
            this.zoomBufferPieno = true;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void chiamaSincronizzazione() {
        double[] asseSincro = this.getAsseX();
        this.sincro.setMin(asseSincro[0]);
        this.sincro.setMax(asseSincro[1]);
        this.sincro.setAggiornaAsse(true);
        DanasDataStructure.getInstance().getMainFrame().aggiornaMassimiMinimi();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void event(GScene scene, int event, int x, int y) {
        try {
            block68: {
                if (this.zoomThread != null && this.zoomThread.isAlive()) {
                    Grafico2D grafico2D = this;
                    if (!grafico2D.zoomThread.interrupted()) {
                        return;
                    }
                }
                if (y > this.sceneTop.getViewport().getY2() + 3 - this.bordo.bottom && event == 3) {
                    float min = 1.0f;
                    float max = 2.0f;
                    DanasDataStructure.getInstance().getMainFrame().chiudiFinestre();
                    AssiDialog assiD = new AssiDialog(null, false);
                    assiD.setLocationRelativeTo(null);
                    assiD.setMin(min);
                    assiD.setMax(max);
                    assiD.setVisible(true);
                    DanasDataStructure.getInstance().getMainFrame().riapriFinestre();
                }
                if (x < this.elencoSceneAssi.size() * 55) {
                    if (x < (this.elencoSceneAssi.size() - 1) * 55) {
                        if (event != 3) return;
                        int asse = x / 55 + 1;
                        Object nuovo = this.elencoSceneAssi.elementAt(asse);
                        this.elencoSceneAssi.remove(asse);
                        this.elencoSceneAssi.add(0, nuovo);
                        this.axes.draw();
                        this.grid.draw();
                        scene.refresh();
                        return;
                    } else {
                        int asse;
                        if (event != 3 || (asse = x / 55 + 1) != this.elencoSceneAssi.size()) return;
                        GScene temp = (GScene)this.elencoScene.getElementAt((Integer)this.elencoSceneAssi.elementAt(0));
                        float min = (float)this.getAsseY(temp)[0];
                        float max = (float)this.getAsseY(temp)[1];
                        DanasDataStructure.getInstance().getMainFrame().chiudiFinestre();
                        AssiDialog assiD = new AssiDialog(null, true);
                        assiD.setLocationRelativeTo(null);
                        assiD.setMin(min);
                        assiD.setMax(max);
                        assiD.setIndice((Integer)this.elencoSceneAssi.getElementAt(0));
                        assiD.setVisible(true);
                        DanasDataStructure.getInstance().getMainFrame().riapriFinestre();
                    }
                    return;
                }
                if (event == 13) {
                    if (!this.traslazioneInCorso) {
                        DanasDataStructure.getInstance().getMainFrame().mostraPopup(this.getGrafico(), x, y);
                    }
                    this.traslazioneInCorso = false;
                }
                if (this.mode != 7 && DanasDataStructure.getInstance().getMainFrame().getSelezioneAttiva()) {
                    DanasDataStructure.getInstance().getMainFrame().setInfoSelezionateAttive(false);
                    this.sincro.rimuoviCursore2();
                    this.cursore2Aggiunto = false;
                    this.refresh();
                }
                switch (this.mode) {
                    case 4: {
                        if (event != 3) return;
                        this.zoomPoint(x, y, 1.3);
                        this.chiamaSincronizzazione();
                        return;
                    }
                    case 3: {
                        if (event != 3) return;
                        this.zoomPoint(x, y, 0.7);
                        this.chiamaSincronizzazione();
                        return;
                    }
                    case 5: {
                        double[] posizione;
                        switch (event) {
                            case 3: {
                                this.x0 = x;
                                this.y0 = y;
                                long tempoAttuale = System.currentTimeMillis();
                                if (this.tempoClick == 0L || tempoAttuale - this.tempoClick >= 200L) return;
                                MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
                                Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
                                mainFrame.selezionaTastoGrafico(1);
                                MainFrame mainFrame2 = DanasDataStructure.getInstance().getMainFrame();
                                Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
                                mainFrame2.selezionaTastoMappa(1);
                                posizione = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                if (this.multiSincro == null || !this.multiSincro.getAggionrnaMappaGrafico()) return;
                                this.sincro.setPosizioneCursore(posizione[0]);
                                this.sincro.setAggiornaCursore(true);
                                return;
                            }
                            case 4: {
                                if (this.elencoSceneVisibili.size() != 0) {
                                    for (int i = 0; i < this.elencoSceneVisibili.size(); ++i) {
                                        GScene temp = (GScene)this.elencoScene.getElementAt((Integer)this.elencoSceneVisibili.getElementAt(i));
                                        this.myPan(x - this.x0, y - this.y0, temp);
                                    }
                                }
                                this.myPan(x - this.x0, y - this.y0, this.sceneTop);
                                this.refresh();
                                this.x0 = x;
                                this.y0 = y;
                                this.chiamaSincronizzazione();
                                return;
                            }
                            case 5: {
                                this.tempoClick = System.currentTimeMillis();
                                return;
                            }
                            case 11: {
                                double[] pos = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                this.t0 = pos[0];
                                return;
                            }
                            case 12: {
                                this.traslazioneInCorso = true;
                                if (this.elencoSceneVisibili.size() == 0) return;
                                double[] pos1 = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                this.sincro.setOffsetAttualeTemporaneo(pos1[0] - this.t0);
                                return;
                            }
                            case 13: {
                                this.sincro.consolidaOffset();
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    case 8: {
                        switch (event) {
                            case 3: {
                                double[] pos = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                this.t0 = pos[0];
                                return;
                            }
                            case 11: {
                                this.traslazioneInCorso = true;
                                if (this.elencoSceneVisibili.size() == 0) return;
                                double[] pos1 = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                this.sincro.setOffsetAttualeRapido(pos1[0] - this.t0);
                                return;
                            }
                        }
                        return;
                    }
                    case 2: {
                        switch (event) {
                            case 3: {
                                this.x0 = x;
                                this.y0 = y;
                                this.selezione.addSegment(new GSegment());
                                return;
                            }
                            case 5: {
                                this.selezione.removeSegments();
                                if (x < this.x0) {
                                    int copia = x;
                                    x = this.x0;
                                    this.x0 = copia;
                                }
                                if (y < this.y0) {
                                    int copia = y;
                                    y = this.y0;
                                    this.y0 = copia;
                                }
                                this.zoomWindow(this.x0, this.y0, x, y);
                                this.chiamaSincronizzazione();
                                return;
                            }
                            case 4: {
                                int[] xSelezione = new int[]{this.x0, x, x, this.x0, this.x0};
                                int[] ySelezione = new int[]{this.y0, this.y0, y, y, this.y0};
                                GSegment segmentoSelezione = this.selezione.getSegment();
                                segmentoSelezione.setGeometry(xSelezione, ySelezione);
                                scene.refresh();
                                this.refresh();
                            }
                        }
                        return;
                    }
                    case 7: {
                        double[] posizione;
                        switch (event) {
                            case 3: {
                                this.x0 = x;
                                this.y0 = y;
                                this.xc0 = x;
                            }
                            case 4: {
                                long tempoAttuale = System.currentTimeMillis();
                                if (this.tempoClick != 0L && tempoAttuale - this.tempoClick < 200L) {
                                    if (DanasDataStructure.getInstance().getMainFrame().getInfoAttive()) {
                                        if (!DanasDataStructure.getInstance().getMainFrame().isInfoFuori()) {
                                            DanasDataStructure.getInstance().getMainFrame().togglePuntiInfo();
                                            return;
                                        }
                                        DanasDataStructure.getInstance().getMainFrame().setInfoAttive(false);
                                        return;
                                    }
                                    DanasDataStructure.getInstance().getMainFrame().setInfoAttive(true);
                                    Objects.requireNonNull(this.mainF);
                                    this.mainF.selezionaTastoMappa(1);
                                    return;
                                }
                                if (DanasDataStructure.getInstance().getMainFrame().getSelezioneAttiva()) {
                                    this.sincro.rimuoviCursore2();
                                    DanasDataStructure.getInstance().getMainFrame().setInfoSelezionateAttive(false);
                                    this.cursore2Aggiunto = false;
                                    this.refresh();
                                }
                                posizione = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                if (this.multiSincro == null || !this.multiSincro.getAggionrnaMappaGrafico()) return;
                                this.sincro.setPosizioneCursore(posizione[0]);
                                this.sincro.setAggiornaCursore(true);
                                return;
                            }
                            case 5: {
                                this.tempoClick = System.currentTimeMillis();
                                if (Math.abs(y - this.y0) <= 10 || Math.abs(x - this.x0) >= 10) return;
                                double zoomFactor = 1.0;
                                zoomFactor = 1.0 + (double)(y - this.y0) / 500.0;
                                if (zoomFactor > 2.0) {
                                    zoomFactor = 6.0;
                                }
                                if (zoomFactor < 0.5) {
                                    zoomFactor = 0.16;
                                }
                                this.zoomPoint(this.x0, this.y0, zoomFactor, true);
                                return;
                            }
                            case 12: {
                                if (DanasDataStructure.getInstance().getMainFrame().getFftMode()) return;
                                this.cursore2Aggiunto = true;
                                this.traslazioneInCorso = true;
                                double[] posizione2 = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                if (this.multiSincro == null || !this.multiSincro.getAggionrnaMappaGrafico()) return;
                                this.sincro.setPosizioneCursore2(posizione2[0]);
                                this.sincro.setAggiornaCursore2(true);
                                return;
                            }
                            case 11: {
                                this.x0 = x;
                                this.y0 = y;
                                this.muoviConCursore = true;
                                return;
                            }
                            case 13: {
                                if (!this.cursore2Aggiunto) return;
                                if (!DanasDataStructure.getInstance().getMainFrame().getFftMode()) {
                                    DanasDataStructure.getInstance().getMainFrame().setInfoSelezionateAttive(true);
                                }
                                if (!this.mainF.getCtrlPressed()) return;
                                this.zoomWindow(x, this.xc0);
                                this.chiamaSincronizzazione();
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    case 9: {
                        switch (event) {
                            case 3: 
                            case 4: {
                                double[] posizione = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                if (this.multiSincro == null || !this.multiSincro.getAggionrnaMappaGrafico()) return;
                                this.sincro.setPosizioneCursore2(posizione[0]);
                                this.sincro.setAggiornaCursore2(true);
                                break block68;
                            }
                            case 11: 
                            case 12: {
                                this.traslazioneInCorso = true;
                                this.sceneTop.add(this.lineaCursore);
                                this.lineaCursore.draw();
                                double[] posizione2 = this.sceneTop.getTransformer().deviceToWorld(x, 0);
                                if (this.multiSincro == null || !this.multiSincro.getAggionrnaMappaGrafico()) return;
                                this.sincro.setPosizioneCursore(posizione2[0]);
                                this.sincro.setAggiornaCursore(true);
                            }
                        }
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource().equals(this.sincro)) {
            double max;
            double min;
            if (this.zoomThread != null && this.zoomThread.isAlive()) {
                Grafico2D grafico2D = this;
                if (!grafico2D.zoomThread.interrupted()) {
                    return;
                }
            }
            if (this.sincro.getTipoEvento() == 0 && !this.bloccaSincro) {
                min = this.sincro.getMin();
                max = this.sincro.getMax();
                this.setAllAsseX(min, max, true);
            }
            if (this.sincro.getTipoEvento() == 2) {
                min = this.sincro.getMin();
                max = this.sincro.getMax();
                this.setAllFuturoAsseX(min, max, this.sincro.getLarghezza(), true);
            }
            if (this.sincro.getTipoEvento() == 1) {
                this.lineaCursore.setPosizione(this.sincro.getPosizioneCursore());
                this.window.redraw();
            }
            if (this.sincro.getTipoEvento() == 5) {
                this.sceneTop.add(this.lineaCursore2);
                this.lineaCursore2.setPosizione(this.sincro.getPosizioneCursore2());
                this.lineaCursore2.draw();
                this.window.redraw();
            }
            if (this.sincro.getTipoEvento() == 7) {
                this.sceneTop.remove(this.lineaCursore2);
                this.window.redraw();
            }
            if (this.sincro.getTipoEvento() == 6) {
                this.lineaCursore.setPosizione(this.sincro.getPosizioneCursore());
                this.lineaCursore2.setPosizione(this.sincro.getPosizioneCursore2());
                min = this.sincro.getMin();
                max = this.sincro.getMax();
                this.setAllFuturoAsseX(min, max, this.sincro.getLarghezza(), false);
            }
        }
    }

    public class Griglia
    extends GObject {
        GSegment segmento;
        GSegment trattino;
        double[] asseX;
        double[] asseY;
        double divisione;
        int numeroDivisioniX;
        int startX;
        int stopX;
        int numeroDivisioniY;
        int startY;
        int stopY;
        double asseXMoltiplicato;
        double asseYMoltiplicato;
        double minimo;
        double massimo;
        double numero;
        Insets margini;
        GStyle stile;
        GStyle stile2;
        GStyle stile3;
        GStyle stile4;
        GStyle textStyle;
        GStyle textStyle2;
        GText text;
        String s = "test1";
        boolean grigliaOrizzontale = true;
        boolean grigliaVerticale = true;

        public Griglia() {
            this.margini = Grafico2D.this.bordo;
            this.stile = new GStyle();
            this.stile.setBackgroundColor(null);
            this.stile.setLineWidth(1);
            this.stile.setLineStyle(3);
            this.stile.setForegroundColor(Color.GRAY);
            this.stile2 = new GStyle();
            this.stile2.setBackgroundColor(null);
            this.stile2.setLineWidth(1);
            this.stile2.setForegroundColor(Color.BLACK);
            this.stile3 = new GStyle();
            this.stile3.setBackgroundColor(null);
            this.stile3.setLineWidth(1);
            this.stile3.setForegroundColor(Color.GRAY);
            this.stile4 = new GStyle();
            this.stile4.setBackgroundColor(null);
            this.stile4.setLineWidth(1);
            this.stile4.setForegroundColor(null);
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(Color.BLACK);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.textStyle2 = new GStyle();
            this.textStyle2.setForegroundColor(Color.BLACK);
            this.textStyle2.setBackgroundColor(null);
            this.textStyle2.setFont(new Font("Dialog", 1, 12));
        }

        public void setGrigliaVerticale(boolean accesa) {
            this.grigliaVerticale = accesa;
        }

        public void setGrigliaOrizzontale(boolean accesa) {
            this.grigliaOrizzontale = accesa;
        }

        @Override
        public void draw() {
            try {
                GScene scenaTemp = Grafico2D.this.elencoSceneAssi.size() == 0 ? (GScene)Grafico2D.this.elencoScene.getElementAt((Integer)Grafico2D.this.elencoSceneVisibili.elementAt(0)) : (GScene)Grafico2D.this.elencoScene.getElementAt((Integer)Grafico2D.this.elencoSceneAssi.elementAt(0));
                this.asseX = Grafico2D.this.getAsseX();
                this.asseY = Grafico2D.this.getAsseY(scenaTemp);
                this.numeroDivisioniX = Grafico2D.this.getNumeroDivisioniX();
                this.numeroDivisioniY = Grafico2D.this.getNumeroDivisioniY(scenaTemp);
                if (this.asseX[1] <= this.asseX[0] || this.asseY[1] <= this.asseY[0]) {
                    return;
                }
                this.removeSegments();
                double[] w0 = scenaTemp.getWorldExtent().get(0);
                double[] w1 = scenaTemp.getWorldExtent().get(1);
                double[] w2 = scenaTemp.getWorldExtent().get(2);
                int[] d0 = scenaTemp.getTransformer().worldToDevice(w0[0], w0[1]);
                int[] d1 = scenaTemp.getTransformer().worldToDevice(w1[0], w1[1]);
                int[] d2 = scenaTemp.getTransformer().worldToDevice(w2[0], w2[1]);
                this.divisione = Grafico2D.this.getDivisioneDouble(this.asseX[0], this.asseX[1], this.numeroDivisioniX);
                this.minimo = this.asseX[0] / this.divisione;
                this.massimo = this.asseX[1] / this.divisione;
                this.startX = (int)this.minimo;
                this.stopX = (int)this.massimo;
                int i = 0;
                while ((double)(this.startX + i) < this.minimo) {
                    ++i;
                }
                while ((double)(this.startX + i) <= this.massimo) {
                    this.segmento = new GSegment();
                    this.trattino = new GSegment();
                    this.trattino.setStyle(this.stile2);
                    this.segmento.setStyle(this.stile);
                    if (this.grigliaVerticale) {
                        this.addSegment(this.segmento);
                    }
                    this.addSegment(this.trattino);
                    this.numero = Grafico2D.this.getNumeroPulito((double)(this.startX + i) * this.divisione, this.divisione);
                    if (this.numero == 0.0) {
                        this.segmento.setStyle(this.stile3);
                    }
                    int[] dg = Grafico2D.this.sceneTop.getTransformer().worldToDevice(this.numero, w2[1]);
                    this.segmento.setGeometry(dg[0], d0[1] - this.margini.bottom, dg[0], d2[1] + this.margini.top);
                    this.trattino.setGeometry(dg[0], d0[1] - this.margini.bottom + 4, dg[0], d0[1] - this.margini.bottom);
                    this.text = new GText(Grafico2D.stampaSpazioTempo(this.numero, Grafico2D.this.tipoAsse), 32784);
                    this.text.setStyle(this.textStyle);
                    this.trattino.setText(this.text);
                    ++i;
                }
                this.segmento = new GSegment();
                this.addSegment(this.segmento);
                int n = Grafico2D.this.elencoSceneAssi.size();
                if (n != 0) {
                    this.segmento.setGeometry(d0[0] + this.margini.left - 4, d2[1] + this.margini.top, d0[0] + this.margini.left, d2[1] + this.margini.top);
                    this.segmento = new GSegment();
                    this.segmento.setGeometry(d0[0] + this.margini.left - 4, d2[1] + this.margini.top + 6);
                    this.segmento.setStyle(this.stile4);
                    this.addSegment(this.segmento);
                    this.text = new GText(Grafico2D.this.getNomeAsse((Integer)Grafico2D.this.elencoSceneAssi.elementAt(0)), 4104);
                    this.text.setStyle(this.textStyle2);
                    this.segmento.setText(this.text);
                }
                this.divisione = Grafico2D.this.getDivisioneDouble(this.asseY[0], this.asseY[1], this.numeroDivisioniY);
                this.minimo = this.asseY[0] / this.divisione;
                this.massimo = this.asseY[1] / this.divisione;
                this.startY = (int)this.minimo;
                this.stopY = (int)this.massimo;
                i = 0;
                this.segmento = new GSegment();
                this.addSegment(this.segmento);
                this.segmento.setGeometry(d0[0] + this.margini.left, d0[1] - this.margini.bottom - 1, d1[0] - this.margini.right, d0[1] - this.margini.bottom - 1);
                while ((double)(this.startY + i) < this.minimo) {
                    ++i;
                }
                while ((double)(this.startY + i) <= this.massimo) {
                    this.segmento = new GSegment();
                    this.trattino = new GSegment();
                    this.trattino.setStyle(this.stile2);
                    this.segmento.setStyle(this.stile);
                    if (this.grigliaOrizzontale) {
                        this.addSegment(this.segmento);
                    }
                    this.addSegment(this.trattino);
                    this.numero = Grafico2D.this.getNumeroPulito((double)(this.startY + i) * this.divisione, this.divisione);
                    if (this.numero == 0.0) {
                        this.segmento.setStyle(this.stile3);
                    }
                    int[] dg = scenaTemp.getTransformer().worldToDevice(w0[0], this.numero);
                    this.segmento.setGeometry(d0[0] + this.margini.left, dg[1], d1[0] - this.margini.right, dg[1]);
                    if (n != 0) {
                        this.trattino.setGeometry(d0[0] + this.margini.left - 4, dg[1], d0[0] + this.margini.left, dg[1]);
                        this.text = new GText(Grafico2D.stampaValoreAsse(this.numero), 4128);
                        this.text.setStyle(this.textStyle);
                        this.trattino.setText(this.text);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("Errore ridisegno griglia");
                e.printStackTrace();
            }
        }
    }

    public class Assi
    extends GObject {
        GSegment segmento;
        GSegment trattino;
        double[] asseY;
        double divisione;
        int numeroDivisioniY;
        int startY;
        int stopY;
        double asseYMoltiplicato;
        double minimo;
        double massimo;
        double numero;
        Insets margini;
        GStyle stile2;
        GStyle stile3;
        GStyle textStyle;
        GStyle textStyle2;
        GText text;

        public Assi() {
            this.margini = Grafico2D.this.bordo;
            this.stile2 = new GStyle();
            this.stile2.setBackgroundColor(null);
            this.stile2.setLineWidth(1);
            this.stile2.setForegroundColor(Color.BLACK);
            this.stile3 = new GStyle();
            this.stile3.setBackgroundColor(null);
            this.stile3.setLineWidth(1);
            this.stile3.setForegroundColor(null);
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(Color.BLACK);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.textStyle2 = new GStyle();
            this.textStyle2.setForegroundColor(Color.BLACK);
            this.textStyle2.setBackgroundColor(null);
            this.textStyle2.setFont(new Font("Dialog", 1, 12));
        }

        @Override
        public void draw() {
            this.removeSegments();
            if (Grafico2D.this.elencoSceneAssi.size() < 2) {
                return;
            }
            double[] w0 = Grafico2D.this.sceneTop.getWorldExtent().get(0);
            double[] w2 = Grafico2D.this.sceneTop.getWorldExtent().get(2);
            int[] d0 = Grafico2D.this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d2 = Grafico2D.this.sceneTop.getTransformer().worldToDevice(w2[0], w2[1]);
            for (int j = 1; j < Grafico2D.this.elencoSceneAssi.size(); ++j) {
                GScene scenaTemp = (GScene)Grafico2D.this.elencoScene.getElementAt((Integer)Grafico2D.this.elencoSceneAssi.elementAt(j));
                this.asseY = Grafico2D.this.getAsseY(scenaTemp);
                this.numeroDivisioniY = Grafico2D.this.getNumeroDivisioniY(scenaTemp);
                this.divisione = Grafico2D.this.getDivisioneDouble(this.asseY[0], this.asseY[1], this.numeroDivisioniY);
                this.minimo = 5.0 * this.asseY[0] / this.divisione;
                this.massimo = 5.0 * this.asseY[1] / this.divisione;
                this.startY = (int)this.minimo;
                this.stopY = (int)this.massimo;
                this.segmento = new GSegment();
                this.segmento.setStyle(this.stile2);
                this.addSegment(this.segmento);
                this.segmento.setGeometry(d0[0] + j * 55 - 4, d0[1] - this.margini.bottom, d0[0] + j * 55, d0[1] - this.margini.bottom);
                this.segmento = new GSegment();
                this.segmento.setStyle(this.stile2);
                this.addSegment(this.segmento);
                this.segmento.setGeometry(d0[0] + j * 55, d0[1] - this.margini.bottom, d0[0] + j * 55, d2[1] + this.margini.top);
                this.segmento = new GSegment();
                this.segmento.setStyle(this.stile2);
                this.addSegment(this.segmento);
                this.segmento.setGeometry(d0[0] + j * 55 - 4, d2[1] + this.margini.top, d0[0] + j * 55, d2[1] + this.margini.top);
                this.segmento = new GSegment();
                this.segmento.setGeometry(d0[0] + j * 55 - 4, d2[1] + this.margini.top + 6);
                this.addSegment(this.segmento);
                this.segmento.setStyle(this.stile3);
                this.text = new GText(Grafico2D.this.getNomeAsse((Integer)Grafico2D.this.elencoSceneAssi.elementAt(j)), 4352);
                this.text.setStyle(this.textStyle2);
                this.segmento.setText(this.text);
                int i = 0;
                while ((double)(this.startY + i) < this.minimo) {
                    ++i;
                }
                while ((double)(this.startY + i) <= this.massimo) {
                    this.trattino = new GSegment();
                    this.trattino.setStyle(this.stile2);
                    this.addSegment(this.trattino);
                    this.numero = Grafico2D.this.getNumeroPulito((double)(this.startY + i) * this.divisione / 5.0, this.divisione);
                    int[] dg = scenaTemp.getTransformer().worldToDevice(w0[0], this.numero);
                    this.text = new GText(Grafico2D.stampaValoreAsse(this.numero), 4128);
                    this.text.setStyle(this.textStyle);
                    if ((this.startY + i) % 5 == 0) {
                        this.trattino.setText(this.text);
                        this.trattino.setGeometry(d0[0] + j * 55 - 4, dg[1], d0[0] + j * 55, dg[1]);
                    } else {
                        this.trattino.setGeometry(d0[0] + j * 55 - 2, dg[1], d0[0] + j * 55, dg[1]);
                    }
                    ++i;
                }
            }
        }
    }

    public class Cornice
    extends GObject {
        GSegment segmentoSx;
        GSegment segmentoDx;
        GSegment segmentoUp;
        GSegment segmentoDn;
        Insets margini;

        public Cornice() {
            this.margini = Grafico2D.this.bordo;
            this.segmentoSx = new GSegment();
            this.segmentoDx = new GSegment();
            this.segmentoUp = new GSegment();
            this.segmentoDn = new GSegment();
            GStyle stile = new GStyle();
            stile.setBackgroundColor(new Color(0.9f, 0.9f, 0.9f, 1.0f));
            stile.setForegroundColor(new Color(0.9f, 0.9f, 0.9f, 1.0f));
            this.segmentoSx.setStyle(stile);
            this.segmentoDx.setStyle(stile);
            this.segmentoUp.setStyle(stile);
            this.segmentoDn.setStyle(stile);
            this.addSegment(this.segmentoSx);
            this.addSegment(this.segmentoDx);
            this.addSegment(this.segmentoUp);
            this.addSegment(this.segmentoDn);
        }

        @Override
        public void draw() {
            double[] w0 = Grafico2D.this.sceneTop.getWorldExtent().get(0);
            double[] w1 = Grafico2D.this.sceneTop.getWorldExtent().get(1);
            double[] w2 = Grafico2D.this.sceneTop.getWorldExtent().get(2);
            int[] d0 = Grafico2D.this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = Grafico2D.this.sceneTop.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = Grafico2D.this.sceneTop.getTransformer().worldToDevice(w2[0], w2[1]);
            this.segmentoSx.setGeometry(Geometry.createRectangle(d0[0], d0[1], this.margini.left, d2[1] - d0[1]));
            this.segmentoDx.setGeometry(Geometry.createRectangle(d1[0] - this.margini.right, d0[1], this.margini.right, d2[1] - d0[1]));
            this.segmentoUp.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d2[1] + this.margini.top, d1[0] - d0[0] - this.margini.right - this.margini.left, -this.margini.top));
            this.segmentoDn.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d0[1], d1[0] - d0[0] - this.margini.right - this.margini.left, -this.margini.bottom));
        }
    }

    public class SfondoGrafico
    extends GObject {
        GSegment segmento;
        Insets margini;
        GStyle stile;

        public SfondoGrafico() {
            this.margini = Grafico2D.this.bordo;
            this.segmento = new GSegment();
            this.stile = new GStyle();
            this.stile.setBackgroundColor(Color.BLACK);
            this.stile.setForegroundColor(null);
            this.segmento.setStyle(this.stile);
            this.addSegment(this.segmento);
        }

        public void setColor(Color colore) {
            this.stile.setBackgroundColor(colore);
            this.draw();
        }

        @Override
        public void draw() {
            double[] w0 = Grafico2D.this.sceneBack.getWorldExtent().get(0);
            double[] w1 = Grafico2D.this.sceneBack.getWorldExtent().get(1);
            double[] w2 = Grafico2D.this.sceneBack.getWorldExtent().get(2);
            int[] d0 = Grafico2D.this.sceneBack.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = Grafico2D.this.sceneBack.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = Grafico2D.this.sceneBack.getTransformer().worldToDevice(w2[0], w2[1]);
            this.segmento.setStyle(this.stile);
            this.segmento.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d0[1] - this.margini.bottom, d1[0] - d0[0] - this.margini.right - this.margini.left, d2[1] - d0[1] + this.margini.top + this.margini.bottom));
        }
    }

    public class MarkerMassimoMinimo
    extends GObject {
        GSegment segmento;
        GStyle markerStyle;
        double posizioneSpazio;
        double posizioneTempo;
        double posizioneY;
        GStyle textStyle;
        GText text;
        String Id;
        int raggio = 10;

        public MarkerMassimoMinimo(double y, double spazio, double tempo, String scritta, Color colore, boolean mostraScritta) {
            GStyle markerStyle = new GStyle();
            markerStyle.setForegroundColor(colore);
            markerStyle.setBackgroundColor(colore);
            markerStyle.setLineWidth(1);
            this.segmento = new GSegment();
            this.segmento.setStyle(markerStyle);
            this.addSegment(this.segmento);
            this.posizioneSpazio = spazio;
            this.posizioneTempo = tempo;
            this.posizioneY = y;
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(colore);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.text = new GText(scritta, 32784);
            this.text.setStyle(this.textStyle);
            if (mostraScritta) {
                this.segmento.setText(this.text);
            }
        }

        @Override
        public void draw() {
            int[] w = Grafico2D.this.modoSpazio ? Grafico2D.this.sceneTop.getTransformer().worldToDevice(this.posizioneSpazio, this.posizioneY) : Grafico2D.this.sceneTop.getTransformer().worldToDevice(this.posizioneTempo, this.posizioneY);
            this.segmento.setGeometry(Geometry.createCircle(w[0], w[1], this.raggio));
        }
    }

    public class LineaIntertempo
    extends GObject {
        GSegment segmento;
        GStyle lineaPosizioneStyle;
        double posizioneSpazio;
        double posizioneTempo;
        GStyle textStyle;
        GText text;
        String Id;

        public LineaIntertempo(double spazio, double tempo, String scritta, String ID, Color colore) {
            GStyle lineaPosizioneStyle = new GStyle();
            lineaPosizioneStyle.setForegroundColor(colore);
            lineaPosizioneStyle.setBackgroundColor(null);
            lineaPosizioneStyle.setLineWidth(1);
            this.segmento = new GSegment();
            this.segmento.setStyle(lineaPosizioneStyle);
            this.addSegment(this.segmento);
            this.posizioneSpazio = spazio;
            this.posizioneTempo = tempo;
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(colore);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.text = new GText(scritta, 16392);
            this.text.setStyle(this.textStyle);
            this.segmento.setText(this.text);
            this.Id = ID;
        }

        public String getId() {
            return this.Id;
        }

        @Override
        public void draw() {
            int[] x = Grafico2D.this.modoSpazio ? Grafico2D.this.sceneTop.getTransformer().worldToDevice(this.posizioneSpazio, 0.0) : Grafico2D.this.sceneTop.getTransformer().worldToDevice(this.posizioneTempo, 0.0);
            int base = Grafico2D.this.sceneTop.getViewport().getY2();
            int altezza = Grafico2D.this.sceneTop.getViewport().getY0();
            int larghezza = Grafico2D.this.sceneTop.getViewport().getX1();
            if (Grafico2D.this.modoSpazio) {
                this.addSegment(this.segmento);
                if (x[0] > ((Grafico2D)Grafico2D.this).bordo.left && x[0] < larghezza - ((Grafico2D)Grafico2D.this).bordo.right) {
                    this.segmento.setGeometry(x[0], base - ((Grafico2D)Grafico2D.this).bordo.bottom, x[0], altezza + ((Grafico2D)Grafico2D.this).bordo.top);
                } else {
                    this.removeSegment(this.segmento);
                }
            } else {
                this.addSegment(this.segmento);
                if (x[0] > ((Grafico2D)Grafico2D.this).bordo.left && x[0] < larghezza - ((Grafico2D)Grafico2D.this).bordo.right) {
                    this.segmento.setGeometry(x[0], base - ((Grafico2D)Grafico2D.this).bordo.bottom, x[0], altezza + ((Grafico2D)Grafico2D.this).bordo.top);
                } else {
                    this.removeSegment(this.segmento);
                }
            }
        }
    }

    public class LineaCursore2
    extends GObject {
        GSegment segmento;
        GStyle lineaPosizioneStyle;
        double posizioneDouble;

        public LineaCursore2(double posizione) {
            GStyle lineaPosizioneStyle = new GStyle();
            lineaPosizioneStyle.setForegroundColor(Color.GREEN);
            lineaPosizioneStyle.setBackgroundColor(null);
            lineaPosizioneStyle.setLineWidth(3);
            this.segmento = new GSegment();
            this.segmento.setStyle(lineaPosizioneStyle);
            this.addSegment(this.segmento);
        }

        public synchronized void setPosizione(double posizione) {
            this.posizioneDouble = posizione;
            this.draw();
            Grafico2D.this.sceneTop.refresh();
        }

        @Override
        public void draw() {
            int[] x = Grafico2D.this.sceneTop.getTransformer().worldToDevice(this.posizioneDouble, 0.0);
            int base = Grafico2D.this.sceneTop.getViewport().getY2();
            int altezza = Grafico2D.this.sceneTop.getViewport().getY0();
            int larghezza = Grafico2D.this.sceneTop.getViewport().getX1();
            if (x[0] > ((Grafico2D)Grafico2D.this).bordo.left && x[0] < larghezza - ((Grafico2D)Grafico2D.this).bordo.right) {
                this.segmento.setGeometry(x[0], base - ((Grafico2D)Grafico2D.this).bordo.bottom, x[0], altezza + ((Grafico2D)Grafico2D.this).bordo.top);
            } else if (x[0] <= ((Grafico2D)Grafico2D.this).bordo.left) {
                this.segmento.setGeometry(((Grafico2D)Grafico2D.this).bordo.left, base - ((Grafico2D)Grafico2D.this).bordo.bottom, ((Grafico2D)Grafico2D.this).bordo.left, altezza + ((Grafico2D)Grafico2D.this).bordo.top);
            } else {
                this.segmento.setGeometry(larghezza - ((Grafico2D)Grafico2D.this).bordo.right, base - ((Grafico2D)Grafico2D.this).bordo.bottom, larghezza - ((Grafico2D)Grafico2D.this).bordo.right, altezza + ((Grafico2D)Grafico2D.this).bordo.top);
            }
        }
    }

    public class LineaCursore
    extends GObject {
        GSegment segmento;
        GStyle lineaPosizioneStyle;
        double posizioneDouble;

        public LineaCursore(double posizione) {
            GStyle lineaPosizioneStyle = new GStyle();
            lineaPosizioneStyle.setForegroundColor(Color.RED);
            lineaPosizioneStyle.setBackgroundColor(null);
            lineaPosizioneStyle.setLineWidth(3);
            this.segmento = new GSegment();
            this.segmento.setStyle(lineaPosizioneStyle);
            this.addSegment(this.segmento);
        }

        public synchronized void setPosizione(double posizione) {
            this.posizioneDouble = posizione;
            this.draw();
            try {
                Grafico2D.this.sceneTop.refresh();
            }
            catch (Exception e) {
                System.out.println("Errore scene Top refresh in grafico 2D");
                e.printStackTrace();
            }
        }

        @Override
        public void draw() {
            int i;
            int[] x = Grafico2D.this.sceneTop.getTransformer().worldToDevice(this.posizioneDouble, 0.0);
            int base = Grafico2D.this.sceneTop.getViewport().getY2();
            int altezza = Grafico2D.this.sceneTop.getViewport().getY0();
            int larghezza = Grafico2D.this.sceneTop.getViewport().getX1();
            if (x[0] > ((Grafico2D)Grafico2D.this).bordo.left && x[0] < larghezza - ((Grafico2D)Grafico2D.this).bordo.right) {
                this.segmento.setGeometry(x[0], base - ((Grafico2D)Grafico2D.this).bordo.bottom, x[0], altezza + ((Grafico2D)Grafico2D.this).bordo.top);
            } else if (x[0] <= ((Grafico2D)Grafico2D.this).bordo.left) {
                this.segmento.setGeometry(((Grafico2D)Grafico2D.this).bordo.left, base - ((Grafico2D)Grafico2D.this).bordo.bottom, ((Grafico2D)Grafico2D.this).bordo.left, altezza + ((Grafico2D)Grafico2D.this).bordo.top);
            } else {
                this.segmento.setGeometry(larghezza - ((Grafico2D)Grafico2D.this).bordo.right, base - ((Grafico2D)Grafico2D.this).bordo.bottom, larghezza - ((Grafico2D)Grafico2D.this).bordo.right, altezza + ((Grafico2D)Grafico2D.this).bordo.top);
            }
            for (i = 0; i < Grafico2D.this.elencoSegmentiPuntoInfo.size(); ++i) {
                this.removeSegment((GSegment)Grafico2D.this.elencoSegmentiPuntoInfo.elementAt(i));
            }
            if (DanasDataStructure.getInstance().getMostraPuntiInfo()) {
                for (i = 0; i < Grafico2D.this.elencoValoriPuntoInfo.size(); ++i) {
                    GSegment nuovoPunto = new GSegment();
                    Color colorePunto = (Color)Grafico2D.this.elencoColoriPuntoInfo.elementAt(i);
                    double valorePunto = (Double)Grafico2D.this.elencoValoriPuntoInfo.elementAt(i);
                    int campoPunto = (Integer)Grafico2D.this.elencoCampiPuntoInfo.elementAt(i);
                    Grafico2D.this.elencoSegmentiPuntoInfo.addElement(nuovoPunto);
                    GStyle markerStyle = new GStyle();
                    markerStyle.setForegroundColor(colorePunto);
                    markerStyle.setBackgroundColor(colorePunto);
                    markerStyle.setLineWidth(1);
                    GStyle textStyle = new GStyle();
                    textStyle.setForegroundColor(colorePunto);
                    textStyle.setBackgroundColor(null);
                    Font fontCarattere = new Font("Dialog", 0, 12);
                    textStyle.setFont(fontCarattere);
                    GScene scenaPunto = (GScene)Grafico2D.this.elencoScene.getElementAt(campoPunto);
                    int[] xc = scenaPunto.getTransformer().worldToDevice(this.posizioneDouble, valorePunto);
                    this.addSegment(nuovoPunto);
                    nuovoPunto.setStyle(markerStyle);
                    nuovoPunto.setGeometry(Geometry.createCircle(xc[0], xc[1], 5));
                    GText text = new GText(String.format("%.2f", valorePunto), 2048);
                    text.setStyle(textStyle);
                    nuovoPunto.setText(text);
                }
            }
        }
    }
}

