/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Vector;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;

public class Curva
extends GObject {
    private double[] x;
    private double[] y;
    private double[] t;
    private double[] asseSottocampionato;
    private double[] ySottocampionato;
    private double[] posizioniStechio;
    private boolean[] usaDato;
    private Color coloreCurva;
    private int spessoreLinea = 1;
    private int stileLinea = 1;
    private GSegment segmento;
    private GStyle stile;
    private GStyle stileRef;
    private String nomeCurva;
    private boolean modoSpazio = false;
    private double max;
    private double min;
    private double maxTempo;
    private double maxSpazio;
    private double avg;
    private double offset = 0.0;
    private double memoriaLarghezza = 0.0;
    private boolean aggiornaSottocampioni = true;
    private final int RISOLUZIONE_ORIZZONTALE = 600;
    private double[] porzioneAsseOrizzontale;
    private double[] porzioneAsseVerticale;
    private Vector<Double> posizioneMassimi = new Vector();
    private Vector<Double> posizioneMinimi = new Vector();
    private Vector<Double> tempiMassimi = new Vector();
    private Vector<Double> tempiMinimi = new Vector();
    private Vector<GSegment> elencoSegmentiMassimi = new Vector();
    private Vector<GSegment> elencoSegmentiMinimi = new Vector();
    private Vector<GSegment> elencoSegmentiPosizioni = new Vector();
    private Vector<Double> posizioneAllarmiSopra = new Vector();
    private Vector<Double> posizioneAllarmiSotto = new Vector();
    private Vector<Double> tempiAllarmiSopra = new Vector();
    private Vector<Double> tempiAllarmiSotto = new Vector();
    private Vector<Double> valoriAllarmiSopra = new Vector();
    private Vector<Double> valoriAllarmiSotto = new Vector();
    private Vector<GSegment> elencoSegmentiAllarmiSopra = new Vector();
    private Vector<GSegment> elencoSegmentiAllarmiSotto = new Vector();
    private double allarmeMassimo = Double.MAX_VALUE;
    private double allarmeMinimo = Double.MIN_VALUE;
    boolean MostraMassimiMinimi = true;
    boolean mostraAvg = false;
    boolean mostraMassimi = false;
    boolean mostraMinimi = false;
    double refValore = 0.0;
    int tipoRef = 0;
    private GSegment ref;
    private GSegment avgRef;
    int posizioneAttuale = 0;
    boolean posizioniCreate = false;
    boolean isDelay = false;

    public Curva() {
    }

    public Curva(double[] asseX, double[] asseT, double[] valoriCurva, Color colore, String nome, double[] elencoPosizioniTabella, boolean[] usaPosizioni, double alarmHi, double alarmLow) {
        if (valoriCurva.length != asseX.length) {
            return;
        }
        long inizio = System.currentTimeMillis();
        this.x = asseX;
        this.y = valoriCurva;
        this.t = asseT;
        this.max = this.y[0];
        this.min = this.y[0];
        this.avg = 0.0;
        this.posizioniStechio = elencoPosizioniTabella;
        this.usaDato = usaPosizioni;
        if (this.t.length != 0) {
            this.offset = this.t[0];
        }
        for (int i = 0; i < this.y.length; ++i) {
            if (this.y[i] < this.min) {
                this.min = this.y[i];
            }
            if (this.y[i] > this.max) {
                this.max = this.y[i];
            }
            this.avg += this.y[i];
        }
        if (this.y.length != 0) {
            this.avg /= (double)this.y.length;
        }
        boolean maxTrovato = false;
        boolean minTrovato = false;
        for (int i = 0; i < this.y.length; ++i) {
            if (this.y[i] >= this.max) {
                if (!maxTrovato) {
                    this.tempiMassimi.add(this.t[i]);
                    this.posizioneMassimi.add(this.x[i]);
                    this.elencoSegmentiMassimi.add(new GSegment());
                    maxTrovato = true;
                }
            } else {
                maxTrovato = false;
            }
            if (this.y[i] <= this.min) {
                if (minTrovato) continue;
                this.tempiMinimi.add(this.t[i]);
                this.posizioneMinimi.add(this.x[i]);
                this.elencoSegmentiMinimi.add(new GSegment());
                minTrovato = true;
                continue;
            }
            minTrovato = false;
        }
        if (this.y.length == 0 && this.elencoSegmentiMassimi.size() == 0) {
            this.tempiMassimi.add(this.t[0]);
            this.posizioneMassimi.add(this.x[0]);
            this.elencoSegmentiMassimi.add(new GSegment());
        }
        if (this.y.length == 0 && this.elencoSegmentiMinimi.size() == 0) {
            this.tempiMinimi.add(this.t[0]);
            this.posizioneMinimi.add(this.x[0]);
            this.elencoSegmentiMinimi.add(new GSegment());
        }
        this.maxSpazio = this.x[this.x.length - 1];
        this.maxTempo = this.t[this.t.length - 1];
        this.coloreCurva = colore;
        this.nomeCurva = nome;
        this.segmento = new GSegment();
        this.ref = new GSegment();
        this.avgRef = new GSegment();
        this.addSegment(this.ref);
        this.addSegment(this.avgRef);
        this.addSegment(this.segmento);
        this.stile = new GStyle();
        this.stileRef = new GStyle();
        this.stile.setLineWidth(2);
        this.stile.setForegroundColor(this.coloreCurva);
        this.stile.setLineWidth(this.spessoreLinea);
        this.stile.setLineStyle(this.stileLinea);
        this.calcolaAllarmi(alarmLow, alarmHi);
    }

    public void calcolaAllarmi(double min, double max) {
        this.allarmeMassimo = max;
        this.allarmeMinimo = min;
        for (int i = 0; i < this.y.length; ++i) {
            if (this.y[i] >= this.allarmeMassimo) {
                this.tempiAllarmiSopra.add(this.t[i]);
                this.posizioneAllarmiSopra.add(this.x[i]);
                this.valoriAllarmiSopra.add(this.y[i]);
                this.elencoSegmentiAllarmiSopra.add(new GSegment());
            }
            if (!(this.y[i] <= this.allarmeMinimo)) continue;
            this.tempiAllarmiSotto.add(this.t[i]);
            this.posizioneAllarmiSotto.add(this.x[i]);
            this.valoriAllarmiSotto.add(this.y[i]);
            this.elencoSegmentiAllarmiSotto.add(new GSegment());
        }
        if (this.y.length == 0 && this.elencoSegmentiAllarmiSopra.size() == 0) {
            this.tempiAllarmiSopra.add(this.t[0]);
            this.posizioneAllarmiSopra.add(this.x[0]);
            this.valoriAllarmiSopra.add(this.y[0]);
            this.elencoSegmentiAllarmiSopra.add(new GSegment());
        }
        if (this.y.length == 0 && this.elencoSegmentiAllarmiSotto.size() == 0) {
            this.tempiAllarmiSotto.add(this.t[0]);
            this.posizioneAllarmiSotto.add(this.x[0]);
            this.valoriAllarmiSotto.add(this.y[0]);
            this.elencoSegmentiAllarmiSotto.add(new GSegment());
        }
    }

    public double getPrimoMassimo() {
        if (this.tempiMassimi.size() != 0) {
            return this.tempiMassimi.get(0);
        }
        return -1.0;
    }

    public double getPrimoMinimo() {
        if (this.tempiMinimi.size() != 0) {
            return this.tempiMinimi.get(0);
        }
        return -1.0;
    }

    private void creaSegmentiPosizioni() {
        for (int i = 0; i < this.y.length; ++i) {
            this.elencoSegmentiPosizioni.add(new GSegment());
        }
        this.posizioniCreate = true;
    }

    public double[] getPosizioniStechio() {
        return this.posizioniStechio;
    }

    public void mostraAvg(boolean mostra) {
        this.mostraAvg = mostra;
    }

    public void mostraMassimi(boolean mostra) {
        this.mostraMassimi = mostra;
    }

    public void mostraMinimi(boolean mostra) {
        this.mostraMinimi = mostra;
    }

    public boolean[] usaStechio() {
        return this.usaDato;
    }

    public double getOffset() {
        return this.offset;
    }

    public double[] getAsseX() {
        return this.x;
    }

    public double[] getAsseT() {
        return this.t;
    }

    public double[] getAsseValori() {
        return this.y;
    }

    public void setValoreRef(double valore) {
        this.refValore = valore;
    }

    public double getValoreRef() {
        switch (this.tipoRef) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return this.max;
            }
            case 2: {
                return this.min;
            }
            case 3: {
                return this.avg;
            }
            case 4: {
                return this.refValore;
            }
        }
        return this.refValore;
    }

    public double getAvg() {
        return this.avg;
    }

    public void setTipoRef(int tipo) {
        this.tipoRef = tipo;
    }

    public void setIsDelay(boolean delayOn) {
        this.isDelay = delayOn;
    }

    public boolean getIsDelay() {
        return this.isDelay;
    }

    public double getValore(int index) {
        if (this.y.length == 0) {
            return 0.0;
        }
        if (index < 0) {
            return this.y[0];
        }
        if (index >= this.y.length) {
            return this.y[this.y.length - 1];
        }
        return this.y[index];
    }

    public Vector<Double> getPosizioneMassimi() {
        return this.posizioneMassimi;
    }

    public Vector<Double> getPosizioneMinimi() {
        return this.posizioneMinimi;
    }

    public Vector<Double> getTempiMassimi() {
        return this.tempiMassimi;
    }

    public Vector<Double> getTempiMinimi() {
        return this.tempiMinimi;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMaxSpazio() {
        return this.maxSpazio;
    }

    public double getMaxTempo() {
        return this.maxTempo;
    }

    public void setModoSpazio(boolean spazio, boolean ridisegna) {
        if (this.modoSpazio == spazio) {
            return;
        }
        this.aggiornaSottocampioni = true;
        this.modoSpazio = spazio;
        if (ridisegna) {
            this.draw();
        }
    }

    public boolean getModoSpazio() {
        return this.modoSpazio;
    }

    public void setSpessore(int spessore) {
        this.spessoreLinea = spessore;
        this.stile.setLineWidth(this.spessoreLinea);
    }

    public void setColore(Color nuovoColore) {
        this.coloreCurva = nuovoColore;
        this.stile.setForegroundColor(this.coloreCurva);
    }

    public Color getColore() {
        return this.coloreCurva;
    }

    public void setStile(int nuovoStile) {
        this.stileLinea = nuovoStile;
        this.stile.setLineStyle(this.stileLinea);
    }

    public String getNome() {
        return this.nomeCurva;
    }

    public int getLunghezza() {
        return this.x.length;
    }

    public void aggiornaSottocampionata(double larghezza) {
        int i;
        double massimoY;
        double minimoY;
        if (!this.aggiornaSottocampioni && larghezza < 2.0 * this.memoriaLarghezza && larghezza > 0.5 * this.memoriaLarghezza) {
            return;
        }
        this.memoriaLarghezza = larghezza;
        Double numeroPixel = DanasDataStructure.getInstance().getMainFrame().getLarghezzaGrafico();
        double passo = larghezza / numeroPixel;
        double temp = 0.0;
        int indice = 0;
        double[] asseSottocampionatoTemp = new double[2 * this.x.length];
        double[] ySottocampionatoTemp = new double[2 * this.x.length];
        int indiceOld = 0;
        boolean sottocampiona = true;
        if (this.x.length < 2) {
            this.asseSottocampionato = this.x;
            this.ySottocampionato = this.y;
            return;
        }
        if (this.modoSpazio) {
            asseSottocampionatoTemp[0] = this.x[0];
            ySottocampionatoTemp[0] = this.y[0];
            temp = asseSottocampionatoTemp[0];
            ++indice;
            minimoY = this.y[0];
            massimoY = this.y[0];
            for (i = 1; i < this.x.length; ++i) {
                if (this.y[i] > massimoY) {
                    massimoY = this.y[i];
                }
                if (this.y[i] < minimoY) {
                    minimoY = this.y[i];
                }
                if (!(this.x[i] - temp >= passo) && sottocampiona) continue;
                if (indiceOld + 1 != i) {
                    asseSottocampionatoTemp[indice] = this.x[i];
                    ySottocampionatoTemp[indice] = minimoY;
                    temp = asseSottocampionatoTemp[indice];
                    asseSottocampionatoTemp[++indice] = this.x[i];
                    ySottocampionatoTemp[indice] = massimoY;
                    ++indice;
                } else {
                    asseSottocampionatoTemp[indice] = this.x[i];
                    ySottocampionatoTemp[indice] = this.y[i];
                    temp = asseSottocampionatoTemp[indice];
                    ++indice;
                }
                massimoY = Double.NEGATIVE_INFINITY;
                minimoY = Double.POSITIVE_INFINITY;
                indiceOld = i;
            }
        } else {
            asseSottocampionatoTemp[0] = this.t[0];
            ySottocampionatoTemp[0] = this.y[0];
            temp = asseSottocampionatoTemp[0];
            ++indice;
            minimoY = this.y[0];
            massimoY = this.y[0];
            for (i = 1; i < this.t.length; ++i) {
                if (this.y[i] > massimoY) {
                    massimoY = this.y[i];
                }
                if (this.y[i] < minimoY) {
                    minimoY = this.y[i];
                }
                if (!(this.t[i] - temp >= passo) && sottocampiona) continue;
                if (indiceOld + 1 != i) {
                    asseSottocampionatoTemp[indice] = this.t[i];
                    ySottocampionatoTemp[indice] = minimoY;
                    temp = asseSottocampionatoTemp[indice];
                    asseSottocampionatoTemp[++indice] = this.t[i];
                    ySottocampionatoTemp[indice] = massimoY;
                    ++indice;
                } else {
                    asseSottocampionatoTemp[indice] = this.t[i];
                    ySottocampionatoTemp[indice] = this.y[i];
                    temp = asseSottocampionatoTemp[indice];
                    ++indice;
                }
                massimoY = Double.NEGATIVE_INFINITY;
                minimoY = Double.POSITIVE_INFINITY;
                indiceOld = i;
            }
        }
        this.asseSottocampionato = new double[indice];
        this.ySottocampionato = new double[indice];
        for (i = 0; i < indice; ++i) {
            this.asseSottocampionato[i] = asseSottocampionatoTemp[i];
            this.ySottocampionato[i] = ySottocampionatoTemp[i];
        }
        this.aggiornaSottocampioni = false;
    }

    public void aggiornaSottocampionataOld(double larghezza) {
        int i;
        if (!this.aggiornaSottocampioni && larghezza < 2.0 * this.memoriaLarghezza && larghezza > 0.5 * this.memoriaLarghezza) {
            return;
        }
        this.memoriaLarghezza = larghezza;
        double passo = larghezza / 600.0;
        double temp = 0.0;
        int indice = 0;
        double[] asseSottocampionatoTemp = new double[this.x.length];
        double[] ySottocampionatoTemp = new double[this.x.length];
        if (this.x.length < 2) {
            this.asseSottocampionato = this.x;
            this.ySottocampionato = this.y;
            return;
        }
        if (this.modoSpazio) {
            asseSottocampionatoTemp[0] = this.x[0];
            ySottocampionatoTemp[0] = this.y[0];
            temp = asseSottocampionatoTemp[0];
            ++indice;
            for (i = 1; i < this.x.length; ++i) {
                if (!(this.x[i] - temp >= passo)) continue;
                asseSottocampionatoTemp[indice] = this.x[i];
                ySottocampionatoTemp[indice] = this.y[i];
                temp = asseSottocampionatoTemp[indice];
                ++indice;
            }
        } else {
            asseSottocampionatoTemp[0] = this.t[0];
            ySottocampionatoTemp[0] = this.y[0];
            temp = asseSottocampionatoTemp[0];
            ++indice;
            for (i = 1; i < this.t.length; ++i) {
                if (!(this.t[i] - temp >= passo)) continue;
                asseSottocampionatoTemp[indice] = this.t[i];
                ySottocampionatoTemp[indice] = this.y[i];
                temp = asseSottocampionatoTemp[indice];
                ++indice;
            }
        }
        this.asseSottocampionato = new double[indice];
        this.ySottocampionato = new double[indice];
        for (i = 0; i < indice; ++i) {
            this.asseSottocampionato[i] = asseSottocampionatoTemp[i];
            this.ySottocampionato[i] = ySottocampionatoTemp[i];
        }
        this.aggiornaSottocampioni = false;
    }

    public void setProzioneAssex(double min, double max) {
        if (this.asseSottocampionato == null) {
            System.out.println("asse nullo!!");
        }
        int inizio = Arrays.binarySearch(this.asseSottocampionato, min);
        int fine = Arrays.binarySearch(this.asseSottocampionato, max);
        if (inizio < 0) {
            inizio = -(inizio + 1) - 1;
        }
        if (fine < 0) {
            fine = -(fine + 1);
        }
        if (inizio < 0) {
            inizio = 0;
        }
        if (fine < 0) {
            fine = 0;
        }
        this.porzioneAsseOrizzontale = Arrays.copyOfRange(this.asseSottocampionato, inizio, fine);
        this.porzioneAsseVerticale = Arrays.copyOfRange(this.ySottocampionato, inizio, fine);
    }

    @Override
    public void draw() {
        GText text;
        int i;
        int[] w;
        int i2;
        int raggio = 15;
        int raggioPosizioni = 10;
        double[] w0 = this.getScene().getWorldExtent().get(0);
        double[] w1 = this.getScene().getWorldExtent().get(1);
        double minimo = w0[0];
        double massimo = w1[0];
        double larghezza = w1[0] - w0[0];
        this.aggiornaSottocampionata(larghezza);
        this.setProzioneAssex(minimo, massimo);
        GStyle textStyle = new GStyle();
        textStyle.setForegroundColor(this.coloreCurva);
        textStyle.setBackgroundColor(null);
        Font fontCarattere = new Font("Dialog", 0, 12);
        textStyle.setFont(fontCarattere);
        this.segmento.setStyle(this.stile);
        this.segmento.setGeometry(this.porzioneAsseOrizzontale, this.porzioneAsseVerticale);
        GStyle markerStyle = new GStyle();
        markerStyle.setForegroundColor(new Color(this.coloreCurva.getRed(), this.coloreCurva.getGreen(), this.coloreCurva.getBlue(), 128));
        markerStyle.setBackgroundColor(new Color(this.coloreCurva.getRed(), this.coloreCurva.getGreen(), this.coloreCurva.getBlue(), 128));
        markerStyle.setLineWidth(1);
        if (DanasDataStructure.getInstance().getMostraPosizioniTabella()) {
            if (!this.posizioniCreate) {
                this.creaSegmentiPosizioni();
            }
            if (DanasDataStructure.getInstance().getPosizioneTabellaAttuale() != this.posizioneAttuale) {
                this.posizioneAttuale = DanasDataStructure.getInstance().getPosizioneTabellaAttuale();
                for (i2 = 0; i2 < this.elencoSegmentiPosizioni.size(); ++i2) {
                    this.removeSegment(this.elencoSegmentiPosizioni.get(i2));
                }
            }
            if (this.modoSpazio) {
                for (i2 = 0; i2 < this.elencoSegmentiPosizioni.size(); ++i2) {
                    if ((double)this.posizioneAttuale != this.posizioniStechio[i2] || !this.usaDato[i2]) continue;
                    this.addSegment(this.elencoSegmentiPosizioni.get(i2));
                    this.elencoSegmentiPosizioni.get(i2).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.x[i2], this.y[i2]);
                    this.elencoSegmentiPosizioni.get(i2).setGeometry(Geometry.createCircle(w[0], w[1], raggioPosizioni));
                }
            } else {
                for (i2 = 0; i2 < this.elencoSegmentiPosizioni.size(); ++i2) {
                    if ((double)this.posizioneAttuale != this.posizioniStechio[i2] || !this.usaDato[i2]) continue;
                    this.addSegment(this.elencoSegmentiPosizioni.get(i2));
                    this.elencoSegmentiPosizioni.get(i2).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.t[i2], this.y[i2]);
                    this.elencoSegmentiPosizioni.get(i2).setGeometry(Geometry.createCircle(w[0], w[1], raggioPosizioni));
                }
            }
        } else {
            for (i2 = 0; i2 < this.elencoSegmentiPosizioni.size(); ++i2) {
                this.removeSegment(this.elencoSegmentiPosizioni.get(i2));
            }
        }
        if (DanasDataStructure.getInstance().getMostraAllarmi()) {
            int i3;
            int lastXSopra = Integer.MIN_VALUE;
            int lastYSopra = Integer.MIN_VALUE;
            int lastYSotto = Integer.MIN_VALUE;
            int lastXSotto = Integer.MIN_VALUE;
            if (this.modoSpazio) {
                for (i3 = 0; i3 < this.elencoSegmentiAllarmiSopra.size(); ++i3) {
                    this.elencoSegmentiAllarmiSopra.get(i3).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.posizioneAllarmiSopra.get(i3), this.valoriAllarmiSopra.get(i3));
                    this.elencoSegmentiAllarmiSopra.get(i3).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    if (w[0] > lastXSopra + 2 * raggio || w[1] > lastYSopra + 2 * raggio || w[1] < lastYSopra - 2 * raggio) {
                        this.addSegment(this.elencoSegmentiAllarmiSopra.get(i3));
                        lastXSopra = w[0];
                        lastYSopra = w[1];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiAllarmiSopra.get(i3));
                }
                for (i3 = 0; i3 < this.elencoSegmentiAllarmiSotto.size(); ++i3) {
                    this.elencoSegmentiAllarmiSotto.get(i3).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.posizioneAllarmiSotto.get(i3), this.valoriAllarmiSotto.get(i3));
                    this.elencoSegmentiAllarmiSotto.get(i3).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    if (w[0] > lastXSotto + 2 * raggio || w[1] > lastYSotto + 2 * raggio || w[1] < lastYSopra - 2 * raggio) {
                        this.addSegment(this.elencoSegmentiAllarmiSotto.get(i3));
                        lastXSotto = w[0];
                        lastYSotto = w[0];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiAllarmiSotto.get(i3));
                }
            } else {
                for (i3 = 0; i3 < this.elencoSegmentiAllarmiSopra.size(); ++i3) {
                    this.elencoSegmentiAllarmiSopra.get(i3).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.tempiAllarmiSopra.get(i3), this.valoriAllarmiSopra.get(i3));
                    this.elencoSegmentiAllarmiSopra.get(i3).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    if (w[0] > lastXSopra + 2 * raggio || w[1] > lastYSopra + 2 * raggio || w[1] < lastYSopra - 2 * raggio) {
                        this.addSegment(this.elencoSegmentiAllarmiSopra.get(i3));
                        lastXSopra = w[0];
                        lastYSopra = w[1];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiAllarmiSopra.get(i3));
                }
                for (i3 = 0; i3 < this.elencoSegmentiAllarmiSotto.size(); ++i3) {
                    this.elencoSegmentiAllarmiSotto.get(i3).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.tempiAllarmiSotto.get(i3), this.valoriAllarmiSotto.get(i3));
                    this.elencoSegmentiAllarmiSotto.get(i3).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    if (w[0] > lastXSotto + 2 * raggio || w[1] > lastYSotto + 2 * raggio || w[1] < lastYSopra - 2 * raggio) {
                        this.addSegment(this.elencoSegmentiAllarmiSotto.get(i3));
                        lastXSotto = w[0];
                        lastYSotto = w[0];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiAllarmiSotto.get(i3));
                }
            }
        } else {
            for (i2 = 0; i2 < this.elencoSegmentiAllarmiSopra.size(); ++i2) {
                this.removeSegment(this.elencoSegmentiAllarmiSopra.get(i2));
            }
            for (i2 = 0; i2 < this.elencoSegmentiAllarmiSotto.size(); ++i2) {
                this.removeSegment(this.elencoSegmentiAllarmiSotto.get(i2));
            }
        }
        if (DanasDataStructure.getInstance().getMostramassimiMinimi() || this.mostraMassimi) {
            int lastXMax = Integer.MIN_VALUE;
            if (this.modoSpazio) {
                for (i = 0; i < this.elencoSegmentiMassimi.size(); ++i) {
                    this.elencoSegmentiMassimi.get(i).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.posizioneMassimi.get(i), this.max);
                    this.elencoSegmentiMassimi.get(i).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    text = new GText(String.format("%.2f", this.max), 8);
                    text.setStyle(textStyle);
                    this.elencoSegmentiMassimi.get(i).setText(text);
                    if (w[0] > lastXMax + raggio) {
                        this.addSegment(this.elencoSegmentiMassimi.get(i));
                        lastXMax = w[0];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiMassimi.get(i));
                }
            } else {
                for (i = 0; i < this.elencoSegmentiMassimi.size(); ++i) {
                    this.elencoSegmentiMassimi.get(i).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.tempiMassimi.get(i), this.max);
                    this.elencoSegmentiMassimi.get(i).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    text = new GText(String.format("%.2f", this.max), 8);
                    text.setStyle(textStyle);
                    this.elencoSegmentiMassimi.get(i).setText(text);
                    if (w[0] > lastXMax + raggio) {
                        this.addSegment(this.elencoSegmentiMassimi.get(i));
                        lastXMax = w[0];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiMassimi.get(i));
                }
            }
        } else {
            for (i2 = 0; i2 < this.elencoSegmentiMassimi.size(); ++i2) {
                this.removeSegment(this.elencoSegmentiMassimi.get(i2));
            }
        }
        if (DanasDataStructure.getInstance().getMostramassimiMinimi() || this.mostraMinimi) {
            int lastXMin = Integer.MIN_VALUE;
            if (this.modoSpazio) {
                for (i = 0; i < this.elencoSegmentiMinimi.size(); ++i) {
                    this.elencoSegmentiMinimi.get(i).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.posizioneMinimi.get(i), this.min);
                    this.elencoSegmentiMinimi.get(i).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    text = new GText(String.format("%.2f", this.min), 16);
                    text.setStyle(textStyle);
                    this.elencoSegmentiMinimi.get(i).setText(text);
                    if (w[0] > lastXMin + raggio) {
                        this.addSegment(this.elencoSegmentiMinimi.get(i));
                        lastXMin = w[0];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiMinimi.get(i));
                }
            } else {
                for (i = 0; i < this.elencoSegmentiMinimi.size(); ++i) {
                    this.elencoSegmentiMinimi.get(i).setStyle(markerStyle);
                    w = this.getScene().getTransformer().worldToDevice(this.tempiMinimi.get(i), this.min);
                    this.elencoSegmentiMinimi.get(i).setGeometry(Geometry.createCircle(w[0], w[1], raggio));
                    text = new GText(String.format("%.2f", this.min), 16);
                    text.setStyle(textStyle);
                    this.elencoSegmentiMinimi.get(i).setText(text);
                    if (w[0] > lastXMin + raggio) {
                        this.addSegment(this.elencoSegmentiMinimi.get(i));
                        lastXMin = w[0];
                        continue;
                    }
                    this.removeSegment(this.elencoSegmentiMinimi.get(i));
                }
            }
        } else {
            for (i2 = 0; i2 < this.elencoSegmentiMinimi.size(); ++i2) {
                this.removeSegment(this.elencoSegmentiMinimi.get(i2));
            }
        }
        if (this.tipoRef != 0) {
            this.stileRef.setForegroundColor(this.coloreCurva);
            this.stileRef.setLineWidth(this.spessoreLinea);
            this.stileRef.setLineStyle(2);
            this.addSegment(this.ref);
            this.ref.setStyle(this.stileRef);
            w = this.getScene().getTransformer().worldToDevice(1.0, this.getValoreRef());
            this.ref.setGeometry(this.getScene().getViewport().getX0(), w[1], this.getScene().getViewport().getX1(), w[1]);
        } else {
            this.removeSegment(this.ref);
        }
        if (this.mostraAvg) {
            this.stileRef.setForegroundColor(this.coloreCurva);
            this.stileRef.setLineWidth(this.spessoreLinea + 2);
            this.stileRef.setLineStyle(2);
            this.addSegment(this.avgRef);
            this.avgRef.setStyle(this.stileRef);
            w = this.getScene().getTransformer().worldToDevice(1.0, this.getAvg());
            this.avgRef.setGeometry(this.getScene().getViewport().getX0(), w[1], this.getScene().getViewport().getX1(), w[1]);
        } else {
            this.removeSegment(this.avgRef);
        }
    }
}

