/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.ColorEditor;
import i2m.ColorRenderer;
import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasTable.TableWindow;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.StatisticheDialog;
import i2m.Dialog.TableRowChannels;
import i2m.Dialog.TableRowStat;
import i2m.Language;
import i2m.MainFrame;
import i2m.MyTableModel;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.grafico.Curva;
import i2m.grafico.Grafico2D;
import i2m.grafico.GraficoBarra;
import i2m.grafico.InfoDialog;
import i2m.grafico.InfoNewDialog;
import i2m.grafico.SincronizzatoreGrafico;
import i2m.grafico.TableRowInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;

public class ContenitoreGrafico
extends JTabbedPane
implements ActionListener,
ChangeListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    public final int GRAFICO_SINGOLO = 1;
    public final int GRAFICO_DOPPIO = 2;
    public final int GRAFICO_MULTIPLO = 3;
    private final int TOP = 1;
    private final int BOTTOM = 0;
    private DefaultListModel elencoGrafici;
    private ImageIcon iconaSottile = new ImageIcon(this.getClass().getResource("/pix/line_normal.gif"));
    private ImageIcon iconaMedia = new ImageIcon(this.getClass().getResource("/pix/line_medium.gif"));
    private ImageIcon iconaGrossa = new ImageIcon(this.getClass().getResource("/pix/line_heavy.gif"));
    private ImageIcon iconaUp = new ImageIcon(this.getClass().getResource("/pix/go-up.png"));
    private ImageIcon iconaDn = new ImageIcon(this.getClass().getResource("/pix/go-down.png"));
    private ImageIcon iconaPuntini = new ImageIcon(this.getClass().getResource("/pix/line_dotted.gif"));
    private ImageIcon iconaTratteggio = new ImageIcon(this.getClass().getResource("/pix/line_hatched.gif"));
    private ImageIcon iconaPuntoLinea = new ImageIcon(this.getClass().getResource("/pix/line_alternate.gif"));
    private JButton coloreSfondoB;
    private JTextField coloreGrafico;
    private JTextField minimoAsseX;
    private JTextField massimoAsseX;
    private JTable table;
    private JCheckBox bloccaX;
    private JCheckBox bloccaY;
    private JCheckBox stileColoriGrafico;
    private JCheckBox auto;
    private JCheckBox grigliaH;
    private JCheckBox grigliaV;
    private JCheckBox decima;
    private int numeroGrafici = 1;
    private JSplitPane splitGrafici;
    private JSplitPane splitBarra;
    private boolean letturaDatiAssi = false;
    private boolean modoSpazio = false;
    private boolean inseritiNuoviGrafici = false;
    private boolean autofit = true;
    private boolean sessioni = true;
    private boolean localModoSpazio;
    private boolean aggiornamentoTabella = true;
    private boolean forzaAssiAbilitato = false;
    private boolean graficoInVista;
    private boolean aggiornamentoCompletato = true;
    private boolean showTabsHeader = true;
    private boolean aggiornaIntertempi = true;
    private SincronizzatoreGrafico sincro;
    private SincronizzatoreMappaGraficoVideo multiSincro = null;
    private double posizioneCursore = 0.0;
    private final int NUM_CURVE = MeasuresUtil.getNumeroCurve();
    private Integer[] elencoNumeroCurve = new Integer[this.NUM_CURVE];
    private boolean[] elencoCanaliEvidenziati = new boolean[this.NUM_CURVE];
    private DanasDataStructure dati = DanasDataStructure.getInstance();
    private Curva curvaDefault = null;
    private InfoDialog infoD = null;
    private StatisticheDialog statD = null;
    private InfoNewDialog infoNewD = null;
    private JDialog frameAttesa;
    private static JDialog frame;
    private int localNumeroGrafici;
    private JPopupMenu popup;
    private JMenuItem menuPopup;
    private JMenuItem menuPopupCanali;
    private JMenuItem menuPopupDerivate;
    private JMenuItem menuPopupMulti;
    private JMenuItem menuPopupMath;
    private JMenuItem menuPopTrasla;
    private JMenuItem menuPopupTPMS;
    private JMenuItem opzioniFftPop;
    private JMenuItem menuPopupCan1;
    private JMenuItem menuPopupCan2;
    private JMenuItem menuPopupCan3;
    private JMenuItem menuPopupCan4;
    private JMenuItem popupMenu1;
    private JMenuItem popupMenu2;
    private JMenuItem popupMenu3;
    private JMenuItem popupMenu4;
    private JMenuItem popupMenu5;
    private JMenuItem popupMenu6;
    private JMenuItem popupMenu7;
    private JMenuItem popupMenu8;
    private JMenuItem popupMenu9;
    private JMenuItem popupMenu10;
    private JMenuItem opzionipopup;
    private JCheckBoxMenuItem[] menuItemCanali = new JCheckBoxMenuItem[this.NUM_CURVE];
    private JMenuItem autoscalingpopup;
    private JRadioButtonMenuItem zoomInRadio;
    private JRadioButtonMenuItem zoomOutRadio;
    private JRadioButtonMenuItem zoomWindowRadio;
    private JRadioButtonMenuItem muoviRadio;
    private JRadioButtonMenuItem cursoreRadio;
    private JRadioButtonMenuItem traslaRadio;
    private JRadioButtonMenuItem giriRadio;
    private JRadioButtonMenuItem sessioniRadio;
    private JMenuItem fittapopup;
    private JMenuItem fittaHpopup;
    private JMenuItem fittaVpopup;
    private JMenuItem istoPop;
    private JMenuItem fftPop;
    private JMenuItem filtriPopup;
    private JMenuItem zoomSelezionePop;
    private JCheckBoxMenuItem bloccaXpopup;
    private JCheckBoxMenuItem bloccaYpopup;
    private JCheckBoxMenuItem grigliaXpopup;
    private JCheckBoxMenuItem grigliaYpopup;
    private JCheckBoxMenuItem coloriPopup;
    private JCheckBoxMenuItem sbloccaPopup;
    private DefaultListModel listaSplit;
    private int altezzaTab = 32;
    private Vector<JCheckBoxMenuItem> giriTralazione = new Vector();
    GraficoBarra barra;
    private boolean mostraProgress = false;
    int rowT;
    MyTableModel model1;
    ContenitoreGrafico contenitore = this;

    public ContenitoreGrafico() {
        int i;
        this.createAndShowGUIAttesa();
        Locale.setDefault(Locale.US);
        for (i = 0; i < this.NUM_CURVE; ++i) {
            this.elencoNumeroCurve[i] = 0;
        }
        for (i = 0; i < this.NUM_CURVE; ++i) {
            this.elencoCanaliEvidenziati[i] = false;
        }
        Border empty = BorderFactory.createEmptyBorder();
        this.setBorder(empty);
        JPanel datiGrafico = new JPanel(new BorderLayout());
        JPanel tablePanel = new JPanel(new BorderLayout());
        JPanel sottoTabellaPanel = new JPanel();
        this.sincro = new SincronizzatoreGrafico();
        DanasDataStructure.getInstance().addChangeListener(this);
        int[] posizioneCanale = new int[MeasuresUtil.getNumeroCurve()];
        this.table = new JTable(new MyTableModel());
        class MyTableCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            MyTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(0);
                return this;
            }
        }
        MyTableCellRenderer renderer = new MyTableCellRenderer();
        this.table.setDefaultRenderer(Object.class, renderer);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getModel().addTableModelListener(this);
        this.table.setPreferredSize(new Dimension(220, 1056));
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultEditor(Color.class, new ColorEditor());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.table.setSelectionMode(0);
        this.table.setDragEnabled(true);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        DanasDataStructure.getInstance().setNomiMulti();
        this.aggiornaNomiCanali();
        TableColumn colonna = this.table.getColumnModel().getColumn(7);
        JComboBox<Object> comboBox = new JComboBox<Object>();
        comboBox.addItem(this.iconaSottile);
        comboBox.addItem(this.iconaMedia);
        comboBox.addItem(this.iconaGrossa);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        colonna = this.table.getColumnModel().getColumn(8);
        comboBox = new JComboBox();
        comboBox.addItem(this.iconaMedia);
        comboBox.addItem(this.iconaPuntini);
        comboBox.addItem(this.iconaTratteggio);
        comboBox.addItem(this.iconaPuntoLinea);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        colonna = this.table.getColumnModel().getColumn(0);
        comboBox = new JComboBox();
        comboBox.addItem(this.iconaUp);
        comboBox.addItem(this.iconaDn);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        colonna = this.table.getColumnModel().getColumn(13);
        comboBox = new JComboBox();
        comboBox.addItem("No Ref.");
        comboBox.addItem("Max");
        comboBox.addItem("Min");
        comboBox.addItem("Avg.");
        comboBox.addItem(Language.string("Valore"));
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        this.stileColoriGrafico = new JCheckBox(Language.string("Colori divisi per giro  "));
        this.stileColoriGrafico.addActionListener(this);
        this.coloreSfondoB = new JButton(Language.string("Colore sfondo"));
        this.coloreSfondoB.addActionListener(this);
        this.minimoAsseX = new JTextField("0", 10);
        this.minimoAsseX.setHorizontalAlignment(11);
        this.minimoAsseX.setMaximumSize(new Dimension(100, 20));
        JLabel minimoAsseXLabel = new JLabel(Language.string("  min. tempo/spazio : "));
        minimoAsseXLabel.setLabelFor(this.minimoAsseX);
        this.massimoAsseX = new JTextField("1", 10);
        this.massimoAsseX.setHorizontalAlignment(11);
        this.massimoAsseX.setMaximumSize(new Dimension(100, 20));
        this.massimoAsseX.setEditable(true);
        JLabel massimoAsseXLabel = new JLabel(Language.string("  max. tempo/spazio : "));
        massimoAsseXLabel.setLabelFor(this.massimoAsseX);
        this.coloreGrafico = new JTextField(10);
        this.coloreGrafico.setMaximumSize(new Dimension(60, 40));
        this.coloreGrafico.setBackground(Color.BLACK);
        this.coloreGrafico.setEditable(false);
        JLabel coloreLabel = new JLabel("      ");
        coloreLabel.setLabelFor(this.coloreGrafico);
        this.bloccaX = new JCheckBox(Language.string("Blocca asse x  "));
        this.bloccaX.addActionListener(this);
        this.bloccaY = new JCheckBox(Language.string("Blocca asse y  "));
        JLabel spazio = new JLabel("   ");
        JLabel spazio2 = new JLabel("   ");
        this.bloccaY.addActionListener(this);
        this.grigliaH = new JCheckBox(Language.string("Griglia Orizz.  "));
        this.grigliaH.addActionListener(this);
        this.grigliaH.setSelected(true);
        this.grigliaV = new JCheckBox(Language.string("Griglia Vert.  "));
        this.grigliaV.addActionListener(this);
        this.grigliaV.setSelected(true);
        this.decima = new JCheckBox(Language.string("Sottocampiona grafico"));
        this.decima.addActionListener(this);
        this.decima.setSelected(true);
        this.auto = new JCheckBox(Language.string("Autoscaling"));
        this.auto.setSelected(true);
        this.auto.addActionListener(this);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setBackground(null);
        URL testoURL = DanasPreferences.getPrefLanguage().equals("it") ? this.getClass().getResource("/res/SpiegazioneOpzioniGrafico.html") : this.getClass().getResource("/res/SpiegazioneOpzioniGrafico_en.html");
        try {
            editorPane.setPage(testoURL);
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL: " + testoURL);
        }
        JPanel sottoTabellaPanel3 = new JPanel();
        sottoTabellaPanel3.setLayout(new BoxLayout(sottoTabellaPanel3, 0));
        sottoTabellaPanel.setLayout(new BoxLayout(sottoTabellaPanel, 0));
        sottoTabellaPanel.add(spazio);
        sottoTabellaPanel.add(this.stileColoriGrafico);
        sottoTabellaPanel.add(this.coloreSfondoB);
        sottoTabellaPanel.add(coloreLabel);
        sottoTabellaPanel.add(this.coloreGrafico);
        sottoTabellaPanel.add(minimoAsseXLabel);
        sottoTabellaPanel.add(this.minimoAsseX);
        sottoTabellaPanel.add(massimoAsseXLabel);
        sottoTabellaPanel.add(this.massimoAsseX);
        sottoTabellaPanel3.add(spazio2);
        sottoTabellaPanel3.add(this.bloccaX);
        sottoTabellaPanel3.add(this.bloccaY);
        sottoTabellaPanel3.add(this.auto);
        sottoTabellaPanel3.add(this.grigliaH);
        sottoTabellaPanel3.add(this.grigliaV);
        JPanel sottoTabellaPanelCoppia = new JPanel(new BorderLayout());
        sottoTabellaPanelCoppia.add((Component)sottoTabellaPanel, "North");
        sottoTabellaPanelCoppia.add((Component)new JLabel(" "), "Center");
        sottoTabellaPanelCoppia.add((Component)sottoTabellaPanel3, "South");
        JPanel sottoTabellaPanel2 = new JPanel(new BorderLayout());
        sottoTabellaPanel2.add((Component)sottoTabellaPanelCoppia, "North");
        editorPane.setPreferredSize(new Dimension(10, 80));
        sottoTabellaPanel2.add((Component)editorPane, "Center");
        tablePanel.add((Component)this.table.getTableHeader(), "North");
        tablePanel.add((Component)this.table, "Center");
        tablePanel.add((Component)new JLabel("  "), "South");
        datiGrafico.add((Component)tablePanel, "North");
        datiGrafico.add((Component)sottoTabellaPanel2, "Center");
        datiGrafico.setPreferredSize(new Dimension(800, 1250));
        JScrollPane scrollPane = new JScrollPane(datiGrafico);
        this.elencoGrafici = new DefaultListModel();
        this.elencoGrafici.clear();
        for (int i2 = 0; i2 < this.NUM_CURVE + 2; ++i2) {
            Grafico2D graficoTemp = new Grafico2D();
            this.elencoGrafici.addElement(graficoTemp);
            graficoTemp.setSincronizzatoreMappaGraficoVideo(this.multiSincro);
        }
        Grafico2D g = (Grafico2D)this.elencoGrafici.getElementAt(0);
        g.aggiungiSincronizzatore(this.sincro);
        this.addTab(Language.string("Mostra grafico curve"), this.getGrafico());
        this.addTab(Language.string("Opzioni grafico Curve"), scrollPane);
        this.setSelectedIndex(0);
        this.addChangeListener(this);
        this.sincro.addChangeListener(this);
        this.sincro.setAggiornaAsse(true);
        this.creaMenuPopup();
        this.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("RIGHT"), "none");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("RIGHT"), "none");
        this.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("LEFT"), "none");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("LEFT"), "none");
        this.infoD = new InfoDialog(DanasDataStructure.getInstance().getMainFrame());
    }

    private void createAndShowGUIAttesa() {
        this.frameAttesa = new JDialog((Frame)DanasDataStructure.getInstance().getMainFrame(), "Data analysis");
        this.frameAttesa.setResizable(false);
        this.frameAttesa.setLocationRelativeTo(null);
        this.frameAttesa.setResizable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(new JLabel(Language.string("Caricamento in corso..")));
        panel.add(new JLabel(Language.string("L'operazione potrebbe richiedere 1 minuto")));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        this.frameAttesa.setContentPane(panel);
        this.frameAttesa.pack();
        this.frameAttesa.setAlwaysOnTop(true);
    }

    public void mostraTabHeader(boolean mostra) {
        this.altezzaTab = mostra ? 32 : 10;
        this.showTabsHeader = mostra;
        this.setUI(new MetalTabbedPaneUI(){

            @Override
            protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
                if (ContenitoreGrafico.this.showTabsHeader) {
                    return super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight);
                }
                return -2;
            }
        });
    }

    private void creaMenuPopup() {
        int i;
        this.popup = new JPopupMenu();
        this.coloriPopup = new JCheckBoxMenuItem(Language.string("Colori divisi per giro"));
        this.coloriPopup.addActionListener(this);
        this.popup.add(this.coloriPopup);
        this.popup.addSeparator();
        for (i = 0; i < this.NUM_CURVE; ++i) {
            this.menuItemCanali[i] = new JCheckBoxMenuItem(this.getNomeAsse(i));
            this.menuItemCanali[i].addActionListener(this);
        }
        this.menuPopupCanali = new JMenu(Language.string("Canali visualizzati"));
        this.menuPopupDerivate = new JMenu(Language.string("Canali derivate"));
        this.menuPopupTPMS = new JMenu(Language.string("Canali TPMS"));
        this.menuPopupMulti = new JMenu(Language.string("Canali multi"));
        this.menuPopupMath = new JMenu(Language.string("Canali math"));
        this.menuPopupCan1 = new JMenu(Language.string("Canali can-bus (1-32)"));
        this.menuPopupCan2 = new JMenu(Language.string("Canali can-bus (33-64)"));
        this.menuPopupCan3 = new JMenu(Language.string("Canali can-bus (65-97)"));
        this.menuPopupCan4 = new JMenu(Language.string("Canali can-bus (97-128)"));
        this.menuPopTrasla = new JMenu(Language.string("Giri traslati"));
        for (i = 0; i < 16; ++i) {
            this.menuPopupCanali.add(this.menuItemCanali[i]);
        }
        this.menuPopupCanali.add(this.menuItemCanali[32]);
        this.menuPopupCanali.add(this.menuItemCanali[33]);
        this.menuPopupCanali.add(this.menuItemCanali[34]);
        this.menuPopupCanali.add(this.menuItemCanali[35]);
        this.menuPopupCanali.add(this.menuItemCanali[46]);
        this.menuPopupCanali.add(this.menuItemCanali[47]);
        this.menuPopupCanali.add(this.menuItemCanali[48]);
        this.menuPopupCanali.add(this.menuItemCanali[49]);
        this.menuPopupCanali.add(this.menuItemCanali[50]);
        this.menuPopupTPMS.add(this.menuItemCanali[62]);
        this.menuPopupTPMS.add(this.menuItemCanali[63]);
        this.menuPopupTPMS.add(this.menuItemCanali[64]);
        this.menuPopupTPMS.add(this.menuItemCanali[65]);
        for (i = 16; i < 32; ++i) {
            this.menuPopupDerivate.add(this.menuItemCanali[i]);
        }
        this.menuPopupCanali.add(this.menuPopupDerivate);
        for (i = 36; i < 46; ++i) {
            this.menuPopupMulti.add(this.menuItemCanali[i]);
        }
        for (i = 66; i < 98; ++i) {
            this.menuPopupCan1.add(this.menuItemCanali[i]);
        }
        for (i = 98; i < 130; ++i) {
            this.menuPopupCan2.add(this.menuItemCanali[i]);
        }
        for (i = 130; i < 162; ++i) {
            this.menuPopupCan3.add(this.menuItemCanali[i]);
        }
        for (i = 162; i < 194; ++i) {
            this.menuPopupCan4.add(this.menuItemCanali[i]);
        }
        this.menuPopupCanali.add(this.menuPopupMulti);
        for (i = 51; i < 61; ++i) {
            this.menuPopupMath.add(this.menuItemCanali[i]);
        }
        this.menuPopupCanali.add(this.menuPopupCan1);
        this.menuPopupCanali.add(this.menuPopupCan2);
        this.menuPopupCanali.add(this.menuPopupCan3);
        this.menuPopupCanali.add(this.menuPopupCan4);
        this.menuPopupCanali.add(this.menuPopupMath);
        this.menuPopupCanali.add(this.menuPopupTPMS);
        this.popup.add(this.menuPopupCanali);
        this.popup.addSeparator();
        this.popup.add(this.menuPopTrasla);
        this.popup.addSeparator();
        this.bloccaXpopup = new JCheckBoxMenuItem(Language.string("Blocca asse X"));
        this.bloccaXpopup.addActionListener(this);
        this.bloccaYpopup = new JCheckBoxMenuItem(Language.string("Blocca asse Y"));
        this.bloccaYpopup.addActionListener(this);
        this.autoscalingpopup = new JCheckBoxMenuItem(Language.string("Autoscaling"));
        this.autoscalingpopup.addActionListener(this);
        this.popup.add(this.autoscalingpopup);
        this.popup.addSeparator();
        this.grigliaXpopup = new JCheckBoxMenuItem(Language.string("Griglia orizzontale"));
        this.grigliaXpopup.addActionListener(this);
        this.popup.add(this.grigliaXpopup);
        this.grigliaYpopup = new JCheckBoxMenuItem(Language.string("Griglia verticale"));
        this.grigliaYpopup.addActionListener(this);
        this.popup.add(this.grigliaYpopup);
        this.popup.addSeparator();
        this.zoomSelezionePop = new JMenuItem(Language.string("Zoom selezione tra cursori"));
        this.zoomSelezionePop.addActionListener(this);
        this.popup.add(this.zoomSelezionePop);
        this.popup.addSeparator();
        ButtonGroup group1 = new ButtonGroup();
        this.zoomInRadio = new JRadioButtonMenuItem(Language.string("Zoom In"));
        this.zoomOutRadio = new JRadioButtonMenuItem(Language.string("Zoom Out"));
        this.zoomWindowRadio = new JRadioButtonMenuItem(Language.string("Zoom Window"));
        this.muoviRadio = new JRadioButtonMenuItem(Language.string("Muovi/Trasla"));
        this.cursoreRadio = new JRadioButtonMenuItem(Language.string("Cursore"));
        this.traslaRadio = new JRadioButtonMenuItem(Language.string("Trasla da punto a punto"));
        group1.add(this.zoomInRadio);
        group1.add(this.zoomOutRadio);
        group1.add(this.zoomWindowRadio);
        group1.add(this.muoviRadio);
        group1.add(this.cursoreRadio);
        group1.add(this.traslaRadio);
        this.zoomInRadio.addActionListener(this);
        this.zoomOutRadio.addActionListener(this);
        this.muoviRadio.addActionListener(this);
        this.grigliaYpopup.addActionListener(this);
        this.zoomWindowRadio.addActionListener(this);
        this.cursoreRadio.addActionListener(this);
        this.traslaRadio.addActionListener(this);
        this.popup.add(this.zoomInRadio);
        this.popup.add(this.zoomOutRadio);
        this.popup.add(this.zoomWindowRadio);
        this.popup.add(this.muoviRadio);
        this.popup.add(this.cursoreRadio);
        this.popup.add(this.traslaRadio);
        this.popup.addSeparator();
        this.sbloccaPopup = new JCheckBoxMenuItem(Language.string("Sblocca curve"));
        this.sbloccaPopup.addActionListener(this);
        this.popup.add(this.sbloccaPopup);
        this.popup.addSeparator();
        ButtonGroup group2 = new ButtonGroup();
        this.giriRadio = new JRadioButtonMenuItem(Language.string("Giri"));
        this.sessioniRadio = new JRadioButtonMenuItem(Language.string("Sessioni"));
        group2.add(this.giriRadio);
        group2.add(this.sessioniRadio);
        this.giriRadio.addActionListener(this);
        this.sessioniRadio.addActionListener(this);
        this.popup.add(this.giriRadio);
        this.popup.add(this.sessioniRadio);
        this.popup.addSeparator();
        this.fittapopup = new JMenuItem(Language.string("Fitta tutto"));
        this.fittapopup.addActionListener(this);
        this.popup.add(this.fittapopup);
        this.fittaVpopup = new JMenuItem(Language.string("Fitta verticale"));
        this.fittaVpopup.addActionListener(this);
        this.popup.add(this.fittaVpopup);
        this.menuPopup = new JMenu(Language.string("Azzera analogici"));
        this.popupMenu1 = new JMenuItem(Language.string("Azzera analog1"));
        this.popupMenu1.addActionListener(this);
        this.menuPopup.add(this.popupMenu1);
        this.popupMenu2 = new JMenuItem(Language.string("Azzera analog2"));
        this.popupMenu2.addActionListener(this);
        this.menuPopup.add(this.popupMenu2);
        this.popupMenu3 = new JMenuItem(Language.string("Azzera analog3"));
        this.popupMenu3.addActionListener(this);
        this.menuPopup.add(this.popupMenu3);
        this.popupMenu4 = new JMenuItem(Language.string("Azzera analog4"));
        this.popupMenu4.addActionListener(this);
        this.menuPopup.add(this.popupMenu4);
        this.popupMenu5 = new JMenuItem(Language.string("Azzera analog5"));
        this.popupMenu5.addActionListener(this);
        this.menuPopup.add(this.popupMenu5);
        this.popupMenu6 = new JMenuItem(Language.string("Azzera analog6"));
        this.popupMenu6.addActionListener(this);
        this.menuPopup.add(this.popupMenu6);
        this.popupMenu7 = new JMenuItem(Language.string("Azzera analog7"));
        this.popupMenu7.addActionListener(this);
        this.menuPopup.add(this.popupMenu7);
        this.popupMenu8 = new JMenuItem(Language.string("Azzera analog8"));
        this.popupMenu8.addActionListener(this);
        this.menuPopup.add(this.popupMenu8);
        this.popupMenu9 = new JMenuItem(Language.string("Azzera Ext-1"));
        this.popupMenu9.addActionListener(this);
        this.menuPopup.add(this.popupMenu9);
        this.popupMenu10 = new JMenuItem(Language.string("Azzera Ext-2"));
        this.popupMenu10.addActionListener(this);
        this.menuPopup.add(this.popupMenu10);
        this.popup.add(this.menuPopup);
        this.opzionipopup = new JMenuItem(Language.string("Lista canali"));
        this.opzionipopup.addActionListener(this);
        this.popup.addSeparator();
        this.filtriPopup = new JMenuItem(Language.string("Configura filtri"));
        this.filtriPopup.addActionListener(this);
        this.istoPop = new JMenuItem(Language.string("Calcola istogrammi della selezione"));
        this.istoPop.addActionListener(this);
        this.popup.add(this.istoPop);
        this.fftPop = new JMenuItem(Language.string("Calcola FFT della selezione"));
        this.fftPop.addActionListener(this);
        this.popup.add(this.fftPop);
        this.popup.addSeparator();
        this.opzioniFftPop = new JMenuItem(Language.string("Opzioni FFT"));
        this.opzioniFftPop.addActionListener(this);
        this.popup.add(this.opzionipopup);
        this.popup.addSeparator();
        this.popup.add(this.opzioniFftPop);
    }

    public void mostraPopup(Component invoker, int x, int y) {
        int i;
        this.opzioniFftPop.setEnabled(DanasDataStructure.getInstance().getMainFrame().getFftMode());
        this.sbloccaPopup.setEnabled(true);
        this.menuPopTrasla.setEnabled(true);
        this.menuPopup.setEnabled(true);
        this.istoPop.setEnabled(true);
        this.fftPop.setEnabled(true);
        this.traslaRadio.setEnabled(true);
        this.istoPop.setEnabled(DanasDataStructure.getInstance().getMainFrame().getSelezioneAttiva());
        this.fftPop.setEnabled(DanasDataStructure.getInstance().getMainFrame().getSelezioneAttiva());
        this.zoomSelezionePop.setEnabled(DanasDataStructure.getInstance().getMainFrame().getSelezioneAttiva());
        this.grigliaXpopup.setSelected(this.grigliaH.isSelected());
        this.grigliaYpopup.setSelected(this.grigliaV.isSelected());
        this.zoomInRadio.setSelected(this.getMode() == 3);
        this.zoomOutRadio.setSelected(this.getMode() == 4);
        this.muoviRadio.setSelected(this.getMode() == 5);
        this.zoomWindowRadio.setSelected(this.getMode() == 2);
        this.cursoreRadio.setSelected(this.getMode() == 7);
        this.bloccaXpopup.setSelected(this.bloccaX.isSelected());
        this.bloccaYpopup.setSelected(this.bloccaY.isSelected());
        this.autoscalingpopup.setSelected(this.auto.isSelected());
        this.menuPopup.setEnabled(this.getMode() == 7);
        this.coloriPopup.setSelected(this.stileColoriGrafico.isSelected());
        this.sbloccaPopup.setSelected(DanasDataStructure.getInstance().getMainFrame().getCurveBloccate());
        this.giriRadio.setSelected(!this.sessioni);
        this.sessioniRadio.setSelected(this.sessioni);
        if (DanasDataStructure.getInstance().getMainFrame().getBloccaCurve()) {
            this.menuPopTrasla.setEnabled(true);
        } else {
            this.menuPopTrasla.setEnabled(false);
        }
        this.giriTralazione.clear();
        this.menuPopTrasla.removeAll();
        Vector<String> giri = DanasDataStructure.getInstance().getSelectedLapList();
        for (i = 0; i < giri.size(); ++i) {
            JCheckBoxMenuItem riga = new JCheckBoxMenuItem(giri.get(i));
            riga.addActionListener(this);
            this.giriTralazione.add(riga);
            this.menuPopTrasla.add(riga);
            String[] ID = giri.get(i).split("-");
            if (ID.length < 3) continue;
            DanasSession sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(ID[1]));
            DanasLap lap = sess.getLap(Integer.valueOf(ID[2]));
            DanasSession s = DanasDataStructure.getInstance().getDefaultLap().getSession();
            DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
            if (Integer.valueOf(ID[1]).intValue() == s.getSessionID() && Integer.valueOf(ID[2]).intValue() == l.getLapID()) {
                riga.setEnabled(false);
            }
            if (!lap.getTraslabile()) continue;
            riga.setSelected(true);
        }
        if (this.numeroGrafici > 2) {
            this.menuPopupCanali.setEnabled(true);
        } else {
            this.menuPopupCanali.setEnabled(true);
        }
        for (i = 0; i < this.NUM_CURVE; ++i) {
            this.menuItemCanali[i].setText(this.getNomeAsse(i));
            this.menuItemCanali[i].setSelected((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2));
        }
        if (DanasDataStructure.getInstance().getMainFrame().getFftMode()) {
            this.sbloccaPopup.setEnabled(false);
            this.menuPopTrasla.setEnabled(false);
            this.menuPopup.setEnabled(false);
            this.zoomSelezionePop.setEnabled(false);
            this.istoPop.setEnabled(false);
            this.fftPop.setEnabled(false);
            this.traslaRadio.setEnabled(false);
        }
        this.popup.show(invoker, x, y);
    }

    public void controllaSpuntaCanaliSimulazioni() {
        if (DanasDataStructure.getInstance().getSimulazioneMarcieAttiva()) {
            if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(26, 2)).booleanValue() && ((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(26, 3)).booleanValue()) {
                ((MyTableModel)this.table.getModel()).setValueAt(false, 26, 3);
            }
            if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(27, 2)).booleanValue() && ((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(27, 3)).booleanValue()) {
                ((MyTableModel)this.table.getModel()).setValueAt(false, 27, 3);
            }
        }
    }

    public void controllaConfronto() {
        if (!this.sessioni && DanasDataStructure.getInstance().getNumberSelectedLaps() > 1 && !this.stileColoriGrafico.isSelected() && DanasPreferences.getPrefConfronto()) {
            this.stileColoriGrafico.setSelected(true);
            this.aggiornaCurve();
        }
    }

    public void setModoSpazioFft() {
        this.modoSpazio = true;
        DanasDataStructure.getInstance().getMainFrame().aggiornaEstremiBarra();
    }

    public void setModoSpazio(boolean spazio) {
        if (DanasDataStructure.getInstance().getMainFrame().getFftMode()) {
            spazio = true;
        }
        if (spazio == this.modoSpazio) {
            return;
        }
        this.modoSpazio = spazio;
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).setModoSpazio(this.modoSpazio);
        }
        this.fittaOrizzontale(true);
        this.sincro.setAggiornaAsse(true);
        this.posizioneCursore = 0.0;
        this.multiSincro.setAggiornaPosizioneCursore(true);
        if (this.modoSpazio) {
            this.sincro.setPosizioneCursore2(this.convertiTempoInSpazio(this.sincro.getPosizioneCursore2()));
            this.sincro.setAggiornaCursore2(true);
        } else {
            this.sincro.setPosizioneCursore2(this.convertiSpazioInTempo(this.sincro.getPosizioneCursore2()));
            this.sincro.setAggiornaCursore2(true);
        }
        this.aggiornaCanaliInfo();
        this.aggiornaCanaliInfoNew();
        DanasDataStructure.getInstance().getMainFrame().aggiornaEstremiBarra();
    }

    public void setModo(int modo, boolean spazio, int numeroGrafici) {
        try {
            int i;
            if (DanasDataStructure.getInstance().getMainFrame().getFftMode()) {
                spazio = true;
            }
            for (int i2 = 0; i2 < this.NUM_CURVE; ++i2) {
                this.elencoCanaliEvidenziati[i2] = false;
            }
            int[] posizioneCanale = new int[MeasuresUtil.getNumeroCurve()];
            this.bloccaY.setEnabled(true);
            this.bloccaX.setEnabled(true);
            this.bloccaX.setSelected(DanasPreferences.getOpzioniGenerali(DanasPreferences.OpzioniGenerali.ASSE_X, modo));
            this.bloccaY.setSelected(DanasPreferences.getOpzioniGenerali(DanasPreferences.OpzioniGenerali.ASSE_Y, modo));
            if (this.bloccaX.isSelected()) {
                this.bloccaY.setEnabled(false);
            }
            if (this.bloccaY.isSelected()) {
                this.bloccaX.setEnabled(false);
            }
            this.auto.setSelected(DanasPreferences.getOpzioniGenerali(DanasPreferences.OpzioniGenerali.AUTOSCALING, modo));
            if (DanasDataStructure.getInstance().getMainFrame().getChannelsDialog() != null) {
                DanasDataStructure.getInstance().getMainFrame().getChannelsDialog().setAutoscale(this.auto.isSelected());
            }
            this.grigliaH.setSelected(DanasPreferences.getOpzioniGenerali(DanasPreferences.OpzioniGenerali.GRIGLIA_H, modo));
            this.grigliaV.setSelected(DanasPreferences.getOpzioniGenerali(DanasPreferences.OpzioniGenerali.GRIGLIA_V, modo));
            this.stileColoriGrafico.setSelected(DanasPreferences.getOpzioniGenerali(DanasPreferences.OpzioniGenerali.DIVISI, modo));
            if (!this.sessioni && DanasDataStructure.getInstance().getNumberSelectedLaps() > 1 && !this.stileColoriGrafico.isSelected() && DanasPreferences.getPrefConfronto()) {
                this.stileColoriGrafico.setSelected(true);
            }
            this.coloreGrafico.setBackground(new Color(DanasPreferences.getOpzioneSfondo(modo)));
            this.autofit = this.auto.isSelected();
            this.decima.setSelected(DanasPreferences.getOpzioneCampionatura(modo));
            if (this.bloccaX.isSelected()) {
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaX(true);
                }
            } else {
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaX(false);
                }
            }
            if (this.bloccaY.isSelected()) {
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaY(true);
                }
            } else {
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaY(false);
                }
            }
            try {
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBackgroundColor(new Color(DanasPreferences.getOpzioneSfondo(modo)), false);
                }
            }
            catch (Exception i3) {
                // empty catch block
            }
            this.attivaGrigliaH(this.grigliaH.isSelected());
            this.attivaGrigliaV(this.grigliaV.isSelected());
            this.aggiornamentoTabella = false;
            block28: for (int i4 = 0; i4 < this.NUM_CURVE; ++i4) {
                if (DanasPreferences.getOpzioniComboGrafico(0, i4, modo) == 0) {
                    ((MyTableModel)this.table.getModel()).setValueAt(this.iconaUp, i4, 0);
                } else {
                    ((MyTableModel)this.table.getModel()).setValueAt(this.iconaDn, i4, 0);
                }
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniGrafico(2, i4, modo), i4, 2);
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniGrafico(1, i4, modo), i4, 1);
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniGrafico(3, i4, modo), i4, 3);
                if (DanasPreferences.getOpzioniComboGrafico(7, i4, modo) != -1) {
                    ((MyTableModel)this.table.getModel()).setValueAt(new Color(DanasPreferences.getOpzioniComboGrafico(6, i4, modo)), i4, 6);
                }
                switch (DanasPreferences.getOpzioniComboGrafico(7, i4, modo)) {
                    case 1: {
                        ((MyTableModel)this.table.getModel()).setValueAt(this.iconaSottile, i4, 7);
                        break;
                    }
                    case 2: {
                        ((MyTableModel)this.table.getModel()).setValueAt(this.iconaMedia, i4, 7);
                        break;
                    }
                    case 4: {
                        ((MyTableModel)this.table.getModel()).setValueAt(this.iconaGrossa, i4, 7);
                    }
                }
                switch (DanasPreferences.getOpzioniComboGrafico(8, i4, modo)) {
                    case 1: {
                        ((MyTableModel)this.table.getModel()).setValueAt(this.iconaMedia, i4, 8);
                        break;
                    }
                    case 2: {
                        ((MyTableModel)this.table.getModel()).setValueAt(this.iconaTratteggio, i4, 8);
                        break;
                    }
                    case 3: {
                        ((MyTableModel)this.table.getModel()).setValueAt(this.iconaPuntini, i4, 8);
                        break;
                    }
                    case 4: {
                        ((MyTableModel)this.table.getModel()).setValueAt(this.iconaPuntoLinea, i4, 8);
                    }
                }
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniAssiGrafico(9, i4, modo), i4, 9);
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniAssiGrafico(10, i4, modo), i4, 10);
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniAssiGrafico(11, i4, modo), i4, 11);
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniAssiGrafico(12, i4, modo), i4, 12);
                ((MyTableModel)this.table.getModel()).setValueAt(DanasPreferences.getOpzioniAssiGrafico(14, i4, modo), i4, 14);
                switch (DanasPreferences.getOpzioniComboGrafico(13, i4, modo)) {
                    case 0: {
                        ((MyTableModel)this.table.getModel()).setValueAt("No Ref.", i4, 13);
                        continue block28;
                    }
                    case 1: {
                        ((MyTableModel)this.table.getModel()).setValueAt("Max", i4, 13);
                        continue block28;
                    }
                    case 2: {
                        ((MyTableModel)this.table.getModel()).setValueAt("Min", i4, 13);
                        continue block28;
                    }
                    case 3: {
                        ((MyTableModel)this.table.getModel()).setValueAt("Avg.", i4, 13);
                        continue block28;
                    }
                    case 4: {
                        ((MyTableModel)this.table.getModel()).setValueAt(Language.string("Valore"), i4, 13);
                    }
                }
            }
            this.aggiornaIntertempi = false;
            this.ricalcolaTutto(spazio, numeroGrafici);
            if (this.bloccaX.isSelected()) {
                this.sincro.setAggiornaFuturoAsse(true);
            }
            this.posizioneCursore = 0.0;
            this.multiSincro.setAggiornaPosizioneCursore(true);
            this.aggiornamentoTabella = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContenitoreGrafico.this.refreshAll();
                    DanasDataStructure.getInstance().getMainFrame().ricalcolaChannelsDialog();
                }
            });
        }
        catch (Exception e) {
            System.out.println("Log: Catch del set modo grafico tabbed");
            e.printStackTrace();
        }
    }

    public void salvaModo(int modo) {
        DanasPreferences.setOpzioniGenerali(DanasPreferences.OpzioniGenerali.ASSE_X, modo, this.bloccaX.isSelected());
        DanasPreferences.setOpzioniGenerali(DanasPreferences.OpzioniGenerali.ASSE_Y, modo, this.bloccaY.isSelected());
        DanasPreferences.setOpzioniGenerali(DanasPreferences.OpzioniGenerali.AUTOSCALING, modo, this.auto.isSelected());
        DanasPreferences.setOpzioniGenerali(DanasPreferences.OpzioniGenerali.GRIGLIA_H, modo, this.grigliaH.isSelected());
        DanasPreferences.setOpzioniGenerali(DanasPreferences.OpzioniGenerali.GRIGLIA_V, modo, this.grigliaV.isSelected());
        DanasPreferences.setOpzioniGenerali(DanasPreferences.OpzioniGenerali.DIVISI, modo, this.stileColoriGrafico.isSelected());
        DanasPreferences.setOpzioneSfondo(modo, this.coloreGrafico.getBackground().getRGB());
        DanasPreferences.setOpzioneCampionatura(modo, this.decima.isSelected());
        MyTableModel tableModel = (MyTableModel)this.table.getModel();
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            if (tableModel.getValueAtBase(i, 0).equals(this.iconaUp)) {
                DanasPreferences.setOpzioniComboGrafico(0, i, modo, 0);
            } else {
                DanasPreferences.setOpzioniComboGrafico(0, i, modo, 1);
            }
            DanasPreferences.setOpzioniGrafico(1, i, modo, (Boolean)tableModel.getValueAtBase(i, 1));
            DanasPreferences.setOpzioniGrafico(2, i, modo, (Boolean)tableModel.getValueAtBase(i, 2));
            DanasPreferences.setOpzioniGrafico(3, i, modo, (Boolean)tableModel.getValueAtBase(i, 3));
            DanasPreferences.setOpzioniComboGrafico(6, i, modo, ((Color)tableModel.getValueAtBase(i, 6)).getRGB());
            DanasPreferences.setOpzioniComboGrafico(7, i, modo, this.getValoreSpessoreSalvataggio(i));
            DanasPreferences.setOpzioniComboGrafico(8, i, modo, this.getValoreStile(i));
            DanasPreferences.setOpzioniAssiGrafico(9, i, modo, (Double)tableModel.getValueAtBase(i, 9));
            DanasPreferences.setOpzioniAssiGrafico(10, i, modo, (Double)tableModel.getValueAtBase(i, 10));
            DanasPreferences.setOpzioniAssiGrafico(11, i, modo, (Double)tableModel.getValueAtBase(i, 11));
            DanasPreferences.setOpzioniAssiGrafico(12, i, modo, (Double)tableModel.getValueAtBase(i, 12));
            DanasPreferences.setOpzioniComboGrafico(13, i, modo, this.getModoRef(i));
            DanasPreferences.setOpzioniAssiGrafico(14, i, modo, (Double)tableModel.getValueAtBase(i, 14));
        }
    }

    public void setModoVisualizzazione(boolean modoSessione) {
        double posizioneAttuale;
        double offset;
        this.sessioni = modoSessione;
        if (this.dati.getDefaultSession() == null) {
            return;
        }
        if (this.multiSincro == null) {
            return;
        }
        if (this.sessioni) {
            this.curvaDefault = this.dati.getCurva(DanasDataStructureConstants.ValueType.VEL_GPS, this.dati.getDefaultSession().getSessionID());
            offset = this.multiSincro.getOffsetVideo();
            posizioneAttuale = this.multiSincro.getPosizioneCursoreDecimale();
            this.aggiornaCanaliInfo();
            this.aggiornaCanaliInfoNew();
            this.multiSincro.setOffsetVideo(0.0);
            this.multiSincro.setPosizioneCursore(posizioneAttuale + offset);
            this.multiSincro.setAggiornaPosizioneCursore(true);
        }
        if (this.dati.getDefaultLap() == null) {
            return;
        }
        if (!this.sessioni) {
            if (DanasDataStructure.getInstance().getNumberSelectedLaps() > 1 && !this.stileColoriGrafico.isSelected() && DanasPreferences.getPrefConfronto()) {
                this.stileColoriGrafico.setSelected(true);
            }
            this.curvaDefault = this.dati.getCurvaLap(DanasDataStructureConstants.ValueType.VEL_GPS, this.dati.getDefaultLap().getSession().getSessionID(), this.dati.getDefaultLap().getLapID());
            posizioneAttuale = this.multiSincro.getPosizioneCursoreDecimale();
            this.aggiornaCanaliInfo();
            this.aggiornaCanaliInfoNew();
            this.multiSincro.setOffsetVideo(this.dati.getDefaultLap().getStart() - this.dati.getDefaultLap().getSession().getStartTelemetryTime());
            offset = this.multiSincro.getOffsetVideo();
            this.multiSincro.setPosizioneCursore(posizioneAttuale - offset);
            this.multiSincro.setAggiornaPosizioneCursore(true);
        }
        this.aggiornaStat();
        DanasDataStructure.getInstance().getMainFrame().aggiornaEstremiBarra();
        DanasDataStructure.getInstance().getMainFrame().getMappa().aggiornaSerpentello();
    }

    public void setMode(int mode) {
        this.multiSincro.setAggiornaPosizioneCursore(true);
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).setMode(mode);
        }
    }

    public int getMode() {
        return ((Grafico2D)this.elencoGrafici.elementAt(1)).getMode();
    }

    public boolean getModoVisualizzazione() {
        return this.sessioni;
    }

    public boolean getModoSpazio() {
        return this.modoSpazio;
    }

    public double convertiSpazioInTempo(double spazio) {
        if (this.curvaDefault == null) {
            return 0.0;
        }
        double[] space = this.curvaDefault.getAsseX();
        double[] time = this.curvaDefault.getAsseT();
        if (space.length == 0) {
            return 0.0;
        }
        for (int i = 1; i < space.length; ++i) {
            if (!(space[i] > spazio)) continue;
            double s1 = space[i] - spazio;
            double s2 = spazio - space[i - 1];
            double sp1 = time[i];
            double sp2 = time[i - 1];
            return s2 / (s2 + s1) * (sp1 - sp2) + sp2;
        }
        return time[time.length - 1];
    }

    public double convertiTempoInSpazio(double tempo) {
        if (this.curvaDefault == null) {
            return 0.0;
        }
        double[] space = this.curvaDefault.getAsseX();
        double[] time = this.curvaDefault.getAsseT();
        if (time.length == 0) {
            return 0.0;
        }
        for (int i = 1; i < time.length; ++i) {
            if (!(time[i] > tempo)) continue;
            double s1 = time[i] - tempo;
            double s2 = tempo - time[i - 1];
            double sp1 = space[i];
            double sp2 = space[i - 1];
            return s2 / (s2 + s1) * (sp1 - sp2) + sp2;
        }
        return space[space.length - 1];
    }

    public void fitta() {
        this.fittaVerticale(false);
        this.fittaOrizzontale(true);
        this.sincro.setAggiornaAsse(true);
        this.refreshAll();
    }

    public void fittaAsseOrizzontale() {
        this.fittaOrizzontale(true);
        this.sincro.setAggiornaAsse(true);
        this.refreshAll();
    }

    public void fittaVerticale(boolean refresh) {
        double min = 0.0;
        double max = 1.0;
        int numTot = 1;
        if (this.numeroGrafici == 1) {
            numTot = 1;
        }
        if (this.numeroGrafici == 2) {
            numTot = 2;
        }
        if (this.numeroGrafici > 2) {
            numTot = this.NUM_CURVE + 2;
        }
        for (int i = 0; i < numTot; ++i) {
            Grafico2D g = (Grafico2D)this.elencoGrafici.elementAt(i);
            for (int numeroScena = 0; numeroScena < this.NUM_CURVE; ++numeroScena) {
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 2)).booleanValue()) continue;
                GScene s = g.getScene(numeroScena);
                for (int j = 0; j < s.getNChildren(); ++j) {
                    if (j == 0) {
                        max = ((Curva)s.getChild(j)).getMax();
                    }
                    if (j == 0) {
                        min = ((Curva)s.getChild(j)).getMin();
                    }
                    if (((Curva)s.getChild(j)).getMax() > max) {
                        max = ((Curva)s.getChild(j)).getMax();
                    }
                    if (!(((Curva)s.getChild(j)).getMin() < min)) continue;
                    min = ((Curva)s.getChild(j)).getMin();
                }
                if ((max += Math.abs(max - (min -= Math.abs(max - min) * 0.05)) * 0.05) == min) {
                    max += 1.0;
                    min -= 1.0;
                }
                double sopra = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 12) / 100.0;
                double sotto = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 11) / 100.0;
                if (this.numeroGrafici != 1) {
                    sopra = 1.0;
                    sotto = 0.0;
                }
                double realMin = (min * sopra - max * sotto) / (sopra - sotto);
                double realMax = (max - min + min * sopra - max * sotto) / (sopra - sotto);
                g.setAsseY(realMin, realMax, numeroScena, false);
                this.aggiornaValoriMinMax();
            }
            if (!refresh) continue;
            g.refresh();
        }
    }

    public void fittaScenaVerticale(int numeroCanale, boolean refresh) {
        double min = 0.0;
        double max = 1.0;
        Grafico2D g = this.getGraficoCampo(numeroCanale);
        GScene s = g.getScene(numeroCanale);
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (j == 0) {
                max = ((Curva)s.getChild(j)).getMax();
            }
            if (j == 0) {
                min = ((Curva)s.getChild(j)).getMin();
            }
            if (((Curva)s.getChild(j)).getMax() > max) {
                max = ((Curva)s.getChild(j)).getMax();
            }
            if (!(((Curva)s.getChild(j)).getMin() < min)) continue;
            min = ((Curva)s.getChild(j)).getMin();
        }
        if ((max += Math.abs(max - (min -= Math.abs(max - min) * 0.05)) * 0.05) == min) {
            max += 1.0;
            min -= 1.0;
        }
        int altezza = this.getHeight();
        int num = 0;
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) continue;
            ++num;
        }
        if (this.numeroGrafici == 3) {
            if (num != 0) {
                altezza /= num;
            }
        } else {
            altezza /= this.numeroGrafici;
        }
        double sopra = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(numeroCanale, 12) / 100.0;
        double sotto = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(numeroCanale, 11) / 100.0;
        if (this.numeroGrafici != 1) {
            sopra = 1.0;
            sotto = 0.0;
        }
        double realMin = (min * sopra - max * sotto) / (sopra - sotto);
        double realMax = (max - min + min * sopra - max * sotto) / (sopra - sotto);
        g.setAsseY(realMin, realMax, numeroCanale, altezza, false);
        this.aggiornaValoriMinMax();
        if (refresh) {
            g.refresh();
        }
    }

    public void fittaOrizzontale(boolean refresh) {
        double max = 0.0;
        int numeroScena = 0;
        while (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 2)).booleanValue() && numeroScena < this.NUM_CURVE) {
            if (++numeroScena != this.NUM_CURVE) continue;
            return;
        }
        GScene s = this.getGraficoCampo(numeroScena).getScene(numeroScena);
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (j == 0) {
                max = ((Curva)s.getChild(j)).getMax();
            }
            if (this.modoSpazio) {
                if (j == 0) {
                    max = ((Curva)s.getChild(j)).getMaxSpazio();
                }
                if (!(((Curva)s.getChild(j)).getMaxSpazio() > max)) continue;
                max = ((Curva)s.getChild(j)).getMaxSpazio();
                continue;
            }
            if (j == 0) {
                max = ((Curva)s.getChild(j)).getMaxTempo();
            }
            if (!(((Curva)s.getChild(j)).getMaxTempo() > max)) continue;
            max = ((Curva)s.getChild(j)).getMaxTempo();
        }
        int numTot = 1;
        if (this.numeroGrafici == 1) {
            numTot = 1;
        }
        if (this.numeroGrafici == 2) {
            numTot = 2;
        }
        if (this.numeroGrafici > 2) {
            numTot = this.NUM_CURVE + 2;
        }
        for (int i = 0; i < numTot; ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).setAllAsseX(0.0, max, refresh);
        }
        this.sincro.setMin(0.0);
        this.sincro.setMax(max);
        this.sincro.setAggiornaAsse(true);
        if (this.modoSpazio) {
            this.minimoAsseX.setText(String.format("%.2f", this.sincro.getMin()));
            this.massimoAsseX.setText(String.format("%.2f", this.sincro.getMax()));
        } else {
            this.minimoAsseX.setText(Grafico2D.stampaSpazioTempo(this.sincro.getMin(), 0));
            this.massimoAsseX.setText(Grafico2D.stampaSpazioTempo(this.sincro.getMax(), 0));
        }
    }

    public void setAbilitaForzaAssi(boolean abilita) {
        this.forzaAssiAbilitato = abilita;
    }

    public void forzaRefreshAssiY(int altezza, boolean multi) {
        if (!this.forzaAssiAbilitato) {
            return;
        }
        boolean usaSplit = true;
        int numeroTotaleGrafici = 0;
        int campoAttuale = 0;
        int numeroGrafico = 0;
        int numTot = 1;
        int altezzaGrafici = altezza;
        int[] arrayAltezzeGrafici = new int[1];
        if (multi && altezza != 0) {
            usaSplit = false;
        }
        if (multi && this.numeroGrafici < 3) {
            return;
        }
        if (!multi && this.numeroGrafici > 2) {
            return;
        }
        if (this.numeroGrafici == 1) {
            numTot = 1;
        }
        if (this.numeroGrafici == 2) {
            numTot = 2;
            this.splitGrafici.setDividerLocation((this.getHeight() - this.altezzaTab) / 2);
        }
        if (this.numeroGrafici > 2) {
            numTot = this.NUM_CURVE + 2;
            if (this.listaSplit.size() == 0) {
                return;
            }
            for (int numeroScena = 0; numeroScena < this.NUM_CURVE; ++numeroScena) {
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 2)).booleanValue()) continue;
                ++numeroTotaleGrafici;
            }
            if (numeroTotaleGrafici == 0) {
                return;
            }
            arrayAltezzeGrafici = new int[numeroTotaleGrafici];
            int hTabbed = altezza - 2;
            int hAltezza = hTabbed - this.altezzaTab - 20;
            int hSingolo = hAltezza / numeroTotaleGrafici;
            int altezzaResidua = hAltezza;
            int primaDimensione = altezza - (this.altezzaTab - 3) - (altezzaResidua - hSingolo) - 1;
            for (int j = 0; j < this.listaSplit.size(); ++j) {
                arrayAltezzeGrafici[j] = j == 0 ? primaDimensione : hSingolo - 1;
                altezzaResidua -= hSingolo;
            }
            if (numeroTotaleGrafici > 1) {
                arrayAltezzeGrafici[this.listaSplit.size()] = altezzaResidua;
            }
        }
        this.forzaAssiAbilitato = false;
        block6: for (int i = 0; i < numTot; ++i) {
            Grafico2D g = (Grafico2D)this.elencoGrafici.elementAt(i);
            switch (this.numeroGrafici) {
                case 1: {
                    if (altezzaGrafici <= this.altezzaTab - 3) break;
                    altezzaGrafici -= this.altezzaTab - 3;
                    break;
                }
                case 2: {
                    int graficoSotto;
                    int altezzaTabbed = altezza - 2;
                    int graficoSopra = (altezzaTabbed - this.altezzaTab) / 2;
                    if (graficoSopra <= 0) {
                        graficoSopra = 10;
                    }
                    if ((graficoSotto = altezza - (this.altezzaTab - 3) - 1 - graficoSopra) <= 0) {
                        graficoSotto = 10;
                    }
                    if (i == 0) {
                        altezzaGrafici = graficoSotto;
                    }
                    if (i != 1) break;
                    altezzaGrafici = graficoSopra;
                    break;
                }
                default: {
                    if (i < 2) continue block6;
                    campoAttuale = i - 2;
                    if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(campoAttuale, 2)).booleanValue()) continue block6;
                    ++numeroGrafico;
                    if (usaSplit) {
                        if (numeroGrafico == 1) {
                            if (numeroTotaleGrafici == 1) {
                                altezzaGrafici = ((JSplitPane)this.listaSplit.getElementAt(this.listaSplit.size() - 1)).getBottomComponent().getHeight();
                                break;
                            }
                            altezzaGrafici = ((JSplitPane)this.listaSplit.getElementAt(this.listaSplit.size() - 1)).getTopComponent().getHeight();
                            break;
                        }
                        altezzaGrafici = ((JSplitPane)this.listaSplit.getElementAt(this.listaSplit.size() - numeroGrafico + 1)).getBottomComponent().getHeight();
                        break;
                    }
                    altezzaGrafici = arrayAltezzeGrafici[numeroTotaleGrafici - numeroGrafico];
                }
            }
            for (int numeroScena = 0; numeroScena < this.NUM_CURVE; ++numeroScena) {
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 2)).booleanValue()) continue;
                g.setAsseY(this.getRealMin(numeroScena), this.getRealMax(numeroScena), numeroScena, altezzaGrafici, true);
            }
        }
    }

    public void cambiaValoriAsse(double min, double max, int indice) {
        ((MyTableModel)this.table.getModel()).setValueAt(min, indice, 9);
        ((MyTableModel)this.table.getModel()).setValueAt(max, indice, 10);
        this.getGraficoCampo(indice).setAsseY(this.getRealMin(indice), this.getRealMax(indice), indice, true);
        this.getGraficoCampo(indice).refresh();
    }

    private void limitaAssi() {
        int numeroAssiSopra = 0;
        int numeroAssiSotto = 0;
        int numeroAssi = 0;
        this.letturaDatiAssi = true;
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) continue;
            if (this.numeroGrafici == 1) {
                if (numeroAssi < 4) {
                    ++numeroAssi;
                } else {
                    ((MyTableModel)this.table.getModel()).setValueAt(false, i, 1);
                }
            }
            if (this.numeroGrafici != 2) continue;
            if (((MyTableModel)this.table.getModel()).getValueAtBase(i, 0).equals(this.iconaUp) && numeroAssiSopra < 4) {
                ++numeroAssiSopra;
            }
            if (((MyTableModel)this.table.getModel()).getValueAtBase(i, 0).equals(this.iconaDn) && numeroAssiSotto < 4) {
                ++numeroAssiSotto;
            }
            if ((!((MyTableModel)this.table.getModel()).getValueAtBase(i, 0).equals(this.iconaDn) || numeroAssiSotto < 4) && (!((MyTableModel)this.table.getModel()).getValueAtBase(i, 0).equals(this.iconaUp) || numeroAssiSopra < 4)) continue;
            ((MyTableModel)this.table.getModel()).setValueAt(false, i, 1);
        }
        this.letturaDatiAssi = false;
    }

    public static double parseHumanTime(String str) {
        boolean negative = false;
        if ((str = str.trim()).startsWith("-")) {
            negative = true;
            str = str.substring(1);
        }
        long time = 0L;
        int p = str.indexOf(".") + 1;
        if (p > 0) {
            String ms_str = str.substring(p);
            int m = 100;
            for (int i = 0; i < ms_str.length(); ++i) {
                int c = Integer.parseInt(ms_str.charAt(i) + "");
                time += (long)(m * c);
                m /= 10;
            }
            str = str.substring(0, p - 1);
        }
        int hc = 0;
        int[] tks = new int[3];
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            tks[hc++] = Integer.parseInt(st.nextToken());
        }
        if (hc == 1) {
            time += (long)(tks[0] * 1000);
        } else if (hc == 2) {
            time += (long)(tks[1] * 1000);
            time += (long)(tks[0] * 60000);
        } else if (hc == 3) {
            time += (long)(tks[2] * 1000);
            time += (long)(tks[1] * 60000);
            time += (long)(tks[0] * 60 * 60000);
        }
        double timeDouble = time;
        if (negative) {
            return -timeDouble;
        }
        return timeDouble;
    }

    public SincronizzatoreGrafico getSincro() {
        return this.sincro;
    }

    public void aggiungiSincronizzazione(SincronizzatoreMappaGraficoVideo sincro) {
        this.multiSincro = sincro;
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).setSincronizzatoreMappaGraficoVideo(this.multiSincro);
        }
        this.multiSincro.addChangeListener(this);
    }

    public void rimuoviSincronizzatore(SincronizzatoreMappaGraficoVideo sincro) {
        sincro.removeChangeListener(this);
        this.multiSincro = null;
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).setSincronizzatoreMappaGraficoVideo(this.multiSincro);
        }
    }

    private int getModoRef(int canale) {
        Object data = ((MyTableModel)this.table.getModel()).getValueAtBase(canale, 13);
        if (data.equals("No Ref.")) {
            return 0;
        }
        if (data.equals("Max")) {
            return 1;
        }
        if (data.equals("Min")) {
            return 2;
        }
        if (data.equals("Avg.")) {
            return 3;
        }
        if (data.equals(Language.string("Valore"))) {
            return 4;
        }
        return 0;
    }

    public void aggiornaNomiCanali() {
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            ((MyTableModel)this.table.getModel()).setValueAt(this.getNomeAsse(i), i, 5);
        }
        if (DanasDataStructure.getInstance().getDefaultSession() != null) {
            this.popupMenu1.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG1));
            this.popupMenu2.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG2));
            this.popupMenu3.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG3));
            this.popupMenu4.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG4));
            this.popupMenu5.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG5));
            this.popupMenu6.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG6));
            this.popupMenu7.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG7));
            this.popupMenu8.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.ANALOG8));
            this.popupMenu9.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.EXT1));
            this.popupMenu10.setText(Language.string("Azzera ") + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.EXT2));
        }
    }

    public String getNomeAsse(int index, int sessioneID) {
        return MeasuresUtil.getNomeCanale(index, sessioneID);
    }

    public String getNomeAsse(int index) {
        return MeasuresUtil.getNomeCanale(index);
    }

    public int getValoreSpessore(int numeroCurva) {
        Object data = ((MyTableModel)this.table.getModel()).getValueAtBase(numeroCurva, 7);
        boolean selezionato = this.elencoCanaliEvidenziati[numeroCurva];
        int aggiunta = 0;
        if (selezionato) {
            aggiunta = 2;
        }
        if (data.equals(this.iconaSottile)) {
            return 1 + aggiunta;
        }
        if (data.equals(this.iconaMedia)) {
            return 2 + aggiunta;
        }
        if (data.equals(this.iconaGrossa)) {
            return 4 + aggiunta;
        }
        return 1 + aggiunta;
    }

    public int getValoreSpessoreSalvataggio(int numeroCurva) {
        Object data = ((MyTableModel)this.table.getModel()).getValueAtBase(numeroCurva, 7);
        if (data.equals(this.iconaSottile)) {
            return 1;
        }
        if (data.equals(this.iconaMedia)) {
            return 2;
        }
        if (data.equals(this.iconaGrossa)) {
            return 4;
        }
        return 1;
    }

    public int getValoreStile(int numeroCurva) {
        Object data = ((MyTableModel)this.table.getModel()).getValueAtBase(numeroCurva, 8);
        if (data.equals(this.iconaMedia)) {
            return 1;
        }
        if (data.equals(this.iconaTratteggio)) {
            return 2;
        }
        if (data.equals(this.iconaPuntini)) {
            return 3;
        }
        if (data.equals(this.iconaPuntoLinea)) {
            return 4;
        }
        return 1;
    }

    public Color getColoreCanale(DanasDataStructureConstants.ValueType canale) {
        int index = canale.ordinal();
        return (Color)((MyTableModel)this.table.getModel()).getValueAtBase(MeasuresUtil.getPositionType(canale), 6);
    }

    public void aggiornaValoriMinMax() {
        this.letturaDatiAssi = true;
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            double max;
            double min;
            if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) continue;
            Grafico2D g = this.getGraficoCampo(i);
            double[] asse = g.getAsseY(i);
            double[] asseUtente = new double[2];
            if (this.numeroGrafici != 3) {
                asseUtente[0] = (asse[1] - asse[0]) * (Double)((MyTableModel)this.table.getModel()).getValueAtBase(i, 11) / 100.0 + asse[0];
                asseUtente[1] = (asse[1] - asse[0]) * (Double)((MyTableModel)this.table.getModel()).getValueAtBase(i, 12) / 100.0 + asse[0];
                min = Math.rint(asseUtente[0] * 100.0) / 100.0;
                max = Math.rint(asseUtente[1] * 100.0) / 100.0;
                ((MyTableModel)this.table.getModel()).setValueAt(min, i, 9);
                ((MyTableModel)this.table.getModel()).setValueAt(max, i, 10);
            } else {
                min = Math.rint(asse[0] * 100.0) / 100.0;
                max = Math.rint(asse[1] * 100.0) / 100.0;
                ((MyTableModel)this.table.getModel()).setValueAt(min, i, 9);
                ((MyTableModel)this.table.getModel()).setValueAt(max, i, 10);
            }
            if (DanasDataStructure.getInstance().getMainFrame().getChannelsDialog() == null) continue;
            DanasDataStructure.getInstance().getMainFrame().getChannelsDialog().setValoriAsse(i, min, max);
        }
        this.letturaDatiAssi = false;
    }

    private double getRealMax(int riga) {
        double sotto;
        double max = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 10);
        double min = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 9);
        double sopra = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 12) / 100.0;
        if (sopra == (sotto = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 11) / 100.0)) {
            sopra = sotto + 0.1;
        }
        if (this.numeroGrafici == 3) {
            sopra = 1.0;
            sotto = 0.0;
        }
        return (max - min + min * sopra - max * sotto) / (sopra - sotto);
    }

    private double getRealMin(int riga) {
        double sotto;
        double max = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 10);
        double min = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 9);
        double sopra = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 12) / 100.0;
        if (sopra == (sotto = (Double)((MyTableModel)this.table.getModel()).getValueAtBase(riga, 11) / 100.0)) {
            sopra = sotto + 0.1;
        }
        if (this.numeroGrafici == 3) {
            sopra = 1.0;
            sotto = 0.0;
        }
        return (min * sopra - max * sotto) / (sopra - sotto);
    }

    private void setMargineLeft() {
        if (this.numeroGrafici == 1) {
            Grafico2D g = (Grafico2D)this.elencoGrafici.getElementAt(0);
            int nBot = g.getNumeroAssi();
            g.setBloccaMargini(false);
            g.setMargineLeft(55 * nBot);
            g.ridisegnaSfondo();
            return;
        }
        int max = 0;
        if (this.numeroGrafici == 2) {
            int n2;
            Grafico2D gTop = (Grafico2D)this.elencoGrafici.getElementAt(1);
            Grafico2D gBot = (Grafico2D)this.elencoGrafici.getElementAt(0);
            int n1 = gTop.getNumeroAssi();
            max = n1 > (n2 = gBot.getNumeroAssi()) ? n1 : n2;
            gBot.setBloccaMargini(true);
            gTop.setBloccaMargini(true);
            gTop.setMargineLeft(55 * max);
            gBot.setMargineLeft(55 * max);
            gTop.ridisegnaSfondo();
            gBot.ridisegnaSfondo();
            return;
        }
        for (int i = 2; i < this.NUM_CURVE + 2; ++i) {
            int n = ((Grafico2D)this.elencoGrafici.getElementAt(i)).getNumeroAssi();
            if (n <= 0) continue;
            max = 1;
        }
        for (int i = 2; i < this.NUM_CURVE + 2; ++i) {
            Grafico2D g = (Grafico2D)this.elencoGrafici.getElementAt(i);
            g.setMargineLeft(55 * max);
            g.setBloccaMargini(true);
            g.ridisegnaSfondo();
        }
    }

    public void setNumeroGrafici(int nGrafici) {
        if (this.numeroGrafici == nGrafici) {
            return;
        }
        this.setSelectedIndex(0);
        this.numeroGrafici = nGrafici;
        this.limitaAssi();
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.getElementAt(i)).rimuoviSincronizzatore();
        }
        DefaultListModel[] campi = new DefaultListModel[this.NUM_CURVE];
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            DefaultListModel lista;
            campi[i] = lista = new DefaultListModel();
        }
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            Grafico2D g = (Grafico2D)this.elencoGrafici.elementAt(i);
            g.rimuoviAllAssi();
            g.setAllInvisible();
            for (int numeroScena = 0; numeroScena < this.NUM_CURVE; ++numeroScena) {
                GScene s = g.getScene(numeroScena);
                int numeroCurve = s.getNChildren();
                for (int j = 0; j < numeroCurve; ++j) {
                    campi[numeroScena].addElement(s.getChild(j));
                }
                s.removeAll();
            }
        }
        if (this.numeroGrafici == 2) {
            this.setComponentAt(0, null);
            int altezza = this.getHeight() - this.altezzaTab;
            this.splitGrafici = new JSplitPane(0);
            Border empty = BorderFactory.createEmptyBorder();
            this.splitGrafici.setBorder(empty);
            this.splitGrafici.setDividerLocation(altezza / 2);
            this.splitGrafici.setResizeWeight(0.5);
            this.splitGrafici.setDividerSize(1);
            Grafico2D graficoTop = (Grafico2D)this.elencoGrafici.getElementAt(1);
            graficoTop.setMargini(1, 1, 5, 5);
            Grafico2D graficoBottom = (Grafico2D)this.elencoGrafici.getElementAt(0);
            graficoBottom.setMargini(1, 25, 5, 5);
            this.splitGrafici.setTopComponent(graficoTop.getGrafico());
            this.splitGrafici.setBottomComponent(graficoBottom.getGrafico());
            this.setComponentAt(0, this.splitGrafici);
            for (int i = 0; i < this.NUM_CURVE; ++i) {
                GObject obj;
                int j;
                if (((MyTableModel)this.table.getModel()).getValueAtBase(i, 0).equals(this.iconaUp)) {
                    if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                        this.getGraficoCampo(i).setAsseY(this.getRealMin(i), this.getRealMax(i), i, true);
                        graficoTop.setScenaVisibile(i, true);
                    }
                    if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                        graficoTop.mostraAsse(i, false);
                    }
                    for (j = 0; j < campi[i].size(); ++j) {
                        obj = (GObject)campi[i].getElementAt(j);
                        graficoTop.getScene(i).add(obj);
                    }
                    continue;
                }
                if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                    this.getGraficoCampo(i).setAsseY(this.getRealMin(i), this.getRealMax(i), i, true);
                    graficoBottom.setScenaVisibile(i, true);
                }
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                    graficoBottom.mostraAsse(i, false);
                }
                for (j = 0; j < campi[i].size(); ++j) {
                    obj = (GObject)campi[i].getElementAt(j);
                    graficoBottom.getScene(i).add(obj);
                }
            }
            this.setMargineLeft();
            graficoTop.aggiungiSincronizzatore(this.sincro);
            graficoBottom.aggiungiSincronizzatore(this.sincro);
            graficoTop.refresh();
            graficoBottom.refresh();
            this.sincro.setLarghezza(this.getWidth() - 5);
            this.sincro.setAggiornaFuturoAsse(true);
            this.sincro.setAggiornaCursore(true);
            this.sincro.setAggiornaCursore2(true);
        }
        if (this.numeroGrafici == 1) {
            this.setComponentAt(0, null);
            Grafico2D graf = (Grafico2D)this.elencoGrafici.getElementAt(0);
            graf.setMargini(5, 25, 5, 5);
            for (int i = 0; i < this.NUM_CURVE; ++i) {
                if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                    graf.setAsseY(this.getRealMin(i), this.getRealMax(i), i, true);
                    graf.setScenaVisibile(i, true);
                }
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                    graf.mostraAsse(i, false);
                }
                for (int j = 0; j < campi[i].size(); ++j) {
                    GObject obj = (GObject)campi[i].getElementAt(j);
                    graf.getScene(i).add(obj);
                }
            }
            this.setMargineLeft();
            graf.aggiungiSincronizzatore(this.sincro);
            this.setComponentAt(0, graf.getGrafico());
            graf.refresh();
            this.sincro.setLarghezza(this.contenitore.getWidth() - 5);
            this.sincro.setAggiornaFuturoAsse(true);
            this.sincro.setAggiornaCursore(true);
            this.sincro.setAggiornaCursore2(true);
        }
        if (this.numeroGrafici > 2) {
            int i;
            this.setComponentAt(0, null);
            this.splitGrafici = this.getDivisioneMulti();
            this.setComponentAt(0, this.getGrafico());
            for (i = 0; i < this.NUM_CURVE; ++i) {
                if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                    this.getGraficoCampo(i).setAsseY(this.getRealMin(i), this.getRealMax(i), i, true);
                    this.getGraficoCampo(i).setScenaVisibile(i, true);
                }
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                    this.getGraficoCampo(i).mostraAsse(i, false);
                }
                for (int j = 0; j < campi[i].size(); ++j) {
                    GObject ob = (GObject)campi[i].getElementAt(j);
                    this.getGraficoCampo(i).getScene(i).add(ob);
                }
            }
            this.setMargineLeft();
            for (i = 0; i < this.NUM_CURVE; ++i) {
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) continue;
                this.getGraficoCampo(i).aggiungiSincronizzatore(this.sincro);
            }
            for (i = 0; i < this.NUM_CURVE; ++i) {
                this.getGraficoCampo(i).refresh();
            }
            this.sincro.setLarghezza(this.getWidth() - 5);
            this.sincro.setAggiornaFuturoAsse(true);
            this.sincro.setAggiornaCursore(true);
            this.sincro.setAggiornaCursore2(true);
        }
    }

    private JSplitPane getDivisioneMulti() {
        this.listaSplit = new DefaultListModel();
        this.listaSplit.clear();
        DefaultListModel<Integer> listaCampi = new DefaultListModel<Integer>();
        listaCampi.clear();
        for (int linea = 0; linea < this.NUM_CURVE; ++linea) {
            if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAt(linea, 2)).booleanValue()) continue;
            listaCampi.addElement(linea);
        }
        int numeroSplit = listaCampi.size() - 1;
        int altezza = this.getHeight() - this.altezzaTab - 20;
        JSplitPane splitPrincipale = new JSplitPane(0);
        splitPrincipale.setBorder(BorderFactory.createEmptyBorder());
        splitPrincipale.setDividerSize(1);
        splitPrincipale.setBackground(Color.black);
        this.listaSplit.addElement(splitPrincipale);
        if (listaCampi.size() == 0) {
            splitPrincipale.setBottomComponent(((Grafico2D)this.elencoGrafici.getElementAt(0)).getGrafico());
            return splitPrincipale;
        }
        int spazioRimanente = altezza;
        splitPrincipale.setDividerLocation(altezza - altezza / (numeroSplit + 1));
        splitPrincipale.setResizeWeight((double)(altezza - altezza / (numeroSplit + 1)) / (double)spazioRimanente);
        spazioRimanente = altezza - altezza / (numeroSplit + 1);
        Grafico2D g = (Grafico2D)this.elencoGrafici.getElementAt((Integer)listaCampi.lastElement() + 2);
        g.setMargini(1, 25, 5, 5);
        splitPrincipale.setBottomComponent(g.getGrafico());
        JSplitPane split = splitPrincipale;
        for (int i = listaCampi.size() - 2; i > 0; --i) {
            JSplitPane splitSuperiore = split;
            split = new JSplitPane(0);
            this.listaSplit.addElement(split);
            Border empty = BorderFactory.createEmptyBorder();
            split.setBorder(empty);
            split.setDividerSize(1);
            split.setDividerLocation(spazioRimanente - altezza / (numeroSplit + 1));
            split.setResizeWeight((double)(spazioRimanente - altezza / (numeroSplit + 1)) / (double)spazioRimanente);
            spazioRimanente -= altezza / (numeroSplit + 1);
            g = (Grafico2D)this.elencoGrafici.getElementAt((Integer)listaCampi.getElementAt(i) + 2);
            g.setMargini(1, 1, 5, 5);
            split.setBottomComponent(g.getGrafico());
            splitSuperiore.setTopComponent(split);
        }
        ((JSplitPane)this.listaSplit.get(this.listaSplit.size() - 1)).addPropertyChangeListener(DanasDataStructure.getInstance().getMainFrame());
        if (listaCampi.size() > 1) {
            g = (Grafico2D)this.elencoGrafici.getElementAt((Integer)listaCampi.getElementAt(0) + 2);
            g.setMargini(1, 1, 5, 5);
            split.setTopComponent(g.getGrafico());
        }
        return splitPrincipale;
    }

    public JSplitPane getLastSplit() {
        if (this.listaSplit == null || this.listaSplit.size() == 0) {
            return null;
        }
        return (JSplitPane)this.listaSplit.getElementAt(this.listaSplit.size() - 1);
    }

    private Component getGrafico() {
        if (this.numeroGrafici == 1) {
            return ((Grafico2D)this.elencoGrafici.getElementAt(0)).getGrafico();
        }
        return this.splitGrafici;
    }

    public Grafico2D getGraficoCampo(int campo) {
        if (this.numeroGrafici == 2) {
            if (((MyTableModel)this.table.getModel()).getValueAtBase(campo, 0).equals(this.iconaUp)) {
                return (Grafico2D)this.elencoGrafici.elementAt(1);
            }
            return (Grafico2D)this.elencoGrafici.elementAt(0);
        }
        if (this.numeroGrafici > 1) {
            return (Grafico2D)this.elencoGrafici.elementAt(campo + 2);
        }
        return (Grafico2D)this.elencoGrafici.elementAt(0);
    }

    public void addCursore2(boolean visualizza) {
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).addCursore2(visualizza);
        }
    }

    public double getValoreCurva(int indicePunto, int campo, String id) {
        Grafico2D graph = this.getGraficoCampo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[campo]));
        Curva c = graph.getCurva(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[campo]), id);
        if (c != null) {
            return c.getValore(indicePunto);
        }
        return 0.0;
    }

    public void setCanaleEvidenziato(int numeroCanaleOrdinale, boolean evidenziato) {
        this.elencoCanaliEvidenziati[numeroCanaleOrdinale] = evidenziato;
        this.getGraficoCampo(numeroCanaleOrdinale).setSpessore(numeroCanaleOrdinale, this.getValoreSpessore(numeroCanaleOrdinale));
    }

    public boolean getCanaleEvidenziato(int numeroCanaleOrdinale) {
        return this.elencoCanaliEvidenziati[numeroCanaleOrdinale];
    }

    private boolean isLineaSelected(int campo) {
        if (campo < 0 || campo > this.NUM_CURVE) {
            return false;
        }
        return (Boolean)((MyTableModel)this.table.getModel()).getValueAt(campo, 2);
    }

    public boolean isLineaOnInfo(int index) {
        if (index >= this.NUM_CURVE) {
            return false;
        }
        return (Boolean)((MyTableModel)this.table.getModel()).getValueAt(index, 3);
    }

    public boolean isChannelOnInfo(int index) {
        if (index >= this.NUM_CURVE) {
            return false;
        }
        return (Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(index, 3);
    }

    public Point getPosizioneInfo() {
        if (this.infoD == null) {
            return null;
        }
        if (!this.infoD.isVisible()) {
            return null;
        }
        return this.infoD.getLocationOnScreen();
    }

    public void setPosizioneInfo(int x, int y) {
        this.infoD.setLocation(x, y);
    }

    public void setInfoDialog(InfoDialog inD) {
        this.infoD = inD;
    }

    public void setInfoNewDialog(InfoNewDialog inD) {
        this.infoNewD = inD;
    }

    public InfoNewDialog getInfoNewDialog() {
        return this.infoNewD;
    }

    public void setStatDialog(StatisticheDialog sD) {
        this.statD = sD;
    }

    public void mostraDialogInfo(MainFrame owner, boolean mostra) {
        if (mostra) {
            this.infoD.setVisible(true);
        } else {
            if (this.infoD == null) {
                return;
            }
            this.infoD.setVisible(false);
        }
    }

    public void aggiornaFinestre() {
        this.aggiornaCanaliInfo();
        this.aggiornaCanaliInfoNew();
        this.aggiornaCanaliStat();
        this.aggiornaStat();
        this.splitGrafici = this.getDivisioneMulti();
    }

    public boolean isInfoVisible() {
        if (this.infoD == null) {
            return false;
        }
        return this.infoD.isVisible();
    }

    public void aggiornaInfo() {
        String der;
        double max;
        double min;
        Double media;
        Double delta;
        int i;
        int indice = 0;
        int indice2 = 0;
        Double valore = 0.0;
        Double valore2 = 0.0;
        Double derivata = 0.0;
        String idPrecedente = null;
        if (this.infoD == null) {
            return;
        }
        if (this.multiSincro == null) {
            return;
        }
        Vector<TableRowInfo> elencoRighe = this.infoD.getElencoRighe();
        if (elencoRighe.size() == 0) {
            return;
        }
        double tempo_1 = 0.0;
        double tempo_2 = 0.0;
        double spazio_1 = 0.0;
        double spazio_2 = 0.0;
        double correzioneDerivata = 1.0;
        if (this.sessioni) {
            for (i = 0; i < elencoRighe.size() - 2; ++i) {
                DanasSession sess = DanasDataStructure.getInstance().getSession("Session" + elencoRighe.get(i).getID());
                int indiceCampo = elencoRighe.get(i).getNumeroCanale();
                if (indiceCampo < 0) continue;
                if (elencoRighe.get(i).getID() != idPrecedente) {
                    idPrecedente = elencoRighe.get(i).getID();
                }
                DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[indiceCampo];
                if (this.modoSpazio) {
                    spazio_1 = this.sincro.getPosizioneCursore();
                    spazio_2 = this.sincro.getPosizioneCursore2();
                    tempo_1 = sess.getTimeAtSpazio(spazio_1, DanasDataStructureConstants.BoundLap.NEAREST);
                    tempo_2 = sess.getTimeAtSpazio(spazio_2, DanasDataStructureConstants.BoundLap.NEAREST);
                    correzioneDerivata = 1.0;
                } else {
                    tempo_1 = this.sincro.getPosizioneCursore() + sess.getStartTelemetryTime();
                    tempo_2 = this.sincro.getPosizioneCursore2() + sess.getStartTelemetryTime();
                    spazio_1 = sess.getSpazioAtTime(tempo_1, DanasDataStructureConstants.BoundLap.NEAREST);
                    spazio_2 = sess.getSpazioAtTime(tempo_2, DanasDataStructureConstants.BoundLap.NEAREST);
                    correzioneDerivata = 100.0;
                }
                if (sess.getFrequenzaCanale(vt) == 0.0) {
                    valore = 0.0;
                    valore2 = 0.0;
                } else {
                    valore = sess.getDatoAtTime(vt, tempo_1, DanasDataStructureConstants.BoundLap.NEAREST, true);
                    valore2 = sess.getDatoAtTime(vt, tempo_2, DanasDataStructureConstants.BoundLap.NEAREST, true);
                }
                indice = sess.getIndiceAtTime(vt, tempo_1, DanasDataStructureConstants.BoundLap.NEAREST);
                indice2 = sess.getIndiceAtTime(vt, tempo_2, DanasDataStructureConstants.BoundLap.NEAREST);
                delta = valore - valore2;
                media = valore;
                min = valore;
                max = valore;
                if (indice == indice2) {
                    min = valore;
                    max = valore;
                } else {
                    if (indice > indice2) {
                        int indiceProvvisorio = indice2;
                        indice2 = indice;
                        indice = indiceProvvisorio;
                    }
                    min = Double.MAX_VALUE;
                    max = Double.MIN_VALUE;
                    media = 0.0;
                    ArrayDouble valori = sess.getAllValueData(vt, true);
                    for (int k = indice; k <= indice2; ++k) {
                        double v = valori.get(k);
                        media = media + v;
                        if (v > max) {
                            max = v;
                        }
                        if (!(v < min)) continue;
                        min = v;
                    }
                    media = media / (double)(indice2 - indice + 1);
                }
                if (this.multiSincro.getPosizioneCursoreDecimale() != this.sincro.getPosizioneCursore2()) {
                    derivata = correzioneDerivata * (valore - valore2) / (this.sincro.getPosizioneCursore() - this.sincro.getPosizioneCursore2());
                    der = String.format("%.2f", derivata);
                } else {
                    der = "--";
                }
                this.infoD.setValore(i, MeasuresUtil.getValorePulito(vt, valore), MeasuresUtil.getValorePulito(vt, valore2), String.format("%.2f", delta), String.format("%.2f", media), MeasuresUtil.getValorePulito(vt, min), MeasuresUtil.getValorePulito(vt, max), der);
            }
        } else {
            for (i = 0; i < elencoRighe.size() - 2; ++i) {
                int indiceCampo = elencoRighe.get(i).getNumeroCanale();
                if (indiceCampo < 0) continue;
                String[] ID = elencoRighe.get(i).getID().split("-");
                if (ID.length < 2) {
                    return;
                }
                DanasSession sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(ID[0]));
                DanasLap lap = sess.getLap(Integer.valueOf(ID[1]));
                if (elencoRighe.get(i).getID() != idPrecedente) {
                    idPrecedente = elencoRighe.get(i).getID();
                }
                DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[indiceCampo];
                if (this.modoSpazio) {
                    spazio_1 = this.sincro.getPosizioneCursore();
                    spazio_2 = this.sincro.getPosizioneCursore2();
                    tempo_1 = lap.getTimeSessionAtSpazio(this.sincro.getPosizioneCursore(), DanasDataStructureConstants.BoundLap.NEAREST);
                    tempo_2 = lap.getTimeSessionAtSpazio(this.sincro.getPosizioneCursore2(), DanasDataStructureConstants.BoundLap.NEAREST);
                    correzioneDerivata = 1.0;
                } else {
                    tempo_1 = this.sincro.getPosizioneCursore() - lap.getOffsetTempo() + lap.getStart();
                    tempo_2 = this.sincro.getPosizioneCursore2() - lap.getOffsetTempo() + lap.getStart();
                    spazio_1 = sess.getSpazioAtTime(tempo_1, DanasDataStructureConstants.BoundLap.NEAREST) - lap.getDistanzaInizio();
                    spazio_2 = sess.getSpazioAtTime(tempo_2, DanasDataStructureConstants.BoundLap.NEAREST) - lap.getDistanzaInizio();
                    correzioneDerivata = 100.0;
                }
                if (sess.getFrequenzaCanale(vt) == 0.0) {
                    valore = 0.0;
                    valore2 = 0.0;
                } else {
                    valore = sess.getDatoAtTime(vt, tempo_1, DanasDataStructureConstants.BoundLap.NEAREST, true);
                    valore2 = sess.getDatoAtTime(vt, tempo_2, DanasDataStructureConstants.BoundLap.NEAREST, true);
                }
                indice = sess.getIndiceAtTime(vt, tempo_1, DanasDataStructureConstants.BoundLap.NEAREST);
                indice2 = sess.getIndiceAtTime(vt, tempo_2, DanasDataStructureConstants.BoundLap.NEAREST);
                delta = valore - valore2;
                media = valore;
                min = valore;
                max = valore;
                if (indice == indice2) {
                    min = valore;
                    max = valore;
                } else {
                    if (indice > indice2) {
                        int indiceProvvisorio = indice2;
                        indice2 = indice;
                        indice = indiceProvvisorio;
                    }
                    min = Double.MAX_VALUE;
                    max = Double.MIN_VALUE;
                    media = 0.0;
                    ArrayDouble valori = sess.getAllValueData(vt, true);
                    for (int k = indice; k <= indice2; ++k) {
                        double v = valori.get(k);
                        media = media + v;
                        if (v > max) {
                            max = v;
                        }
                        if (!(v < min)) continue;
                        min = v;
                    }
                    media = media / (double)(indice2 - indice + 1);
                }
                if (this.sincro.getPosizioneCursore() != this.sincro.getPosizioneCursore2()) {
                    derivata = correzioneDerivata * (valore - valore2) / (this.sincro.getPosizioneCursore() - this.sincro.getPosizioneCursore2());
                    der = String.format("%.2f", derivata);
                } else {
                    der = "--";
                }
                this.infoD.setValore(i, MeasuresUtil.getValorePulito(vt, valore), MeasuresUtil.getValorePulito(vt, valore2), String.format("%.2f", delta), String.format("%.2f", media), MeasuresUtil.getValorePulito(vt, min), MeasuresUtil.getValorePulito(vt, max), der);
            }
        }
        for (i = 0; i < elencoRighe.size(); ++i) {
            DanasLap lap;
            DanasSession sess;
            int indiceCampo = elencoRighe.get(i).getNumeroCanale();
            if (indiceCampo == -1) {
                if (this.modoSpazio) {
                    this.infoD.setValore(i, String.format("%.2f", this.sincro.getPosizioneCursore()), String.format("%.2f", this.sincro.getPosizioneCursore2()), String.format("%.2f", this.sincro.getPosizioneCursore() - this.sincro.getPosizioneCursore2()));
                } else {
                    this.infoD.setValore(i, Grafico2D.stampaSpazioTempo(this.sincro.getPosizioneCursore(), 2), Grafico2D.stampaSpazioTempo(this.sincro.getPosizioneCursore2(), 2), Grafico2D.stampaSpazioTempo(this.sincro.getPosizioneCursore() - this.sincro.getPosizioneCursore2(), 2));
                }
            }
            if (indiceCampo != -2) continue;
            if (this.sessioni) {
                sess = DanasDataStructure.getInstance().getSession("Session" + elencoRighe.get(i).getID());
                if (this.modoSpazio) {
                    spazio_1 = this.sincro.getPosizioneCursore();
                    spazio_2 = this.sincro.getPosizioneCursore2();
                    tempo_1 = sess.getTimeAtSpazio(spazio_1, DanasDataStructureConstants.BoundLap.NEAREST);
                    tempo_2 = sess.getTimeAtSpazio(spazio_2, DanasDataStructureConstants.BoundLap.NEAREST);
                    this.infoD.setValore(i, Grafico2D.stampaSpazioTempo(tempo_1, 0), Grafico2D.stampaSpazioTempo(tempo_2, 0), Grafico2D.stampaSpazioTempo(tempo_1 - tempo_2, 0));
                    continue;
                }
                tempo_1 = this.sincro.getPosizioneCursore() + sess.getStartTelemetryTime();
                tempo_2 = this.sincro.getPosizioneCursore2() + sess.getStartTelemetryTime();
                spazio_1 = sess.getSpazioAtTime(tempo_1, DanasDataStructureConstants.BoundLap.NEAREST);
                spazio_2 = sess.getSpazioAtTime(tempo_2, DanasDataStructureConstants.BoundLap.NEAREST);
                this.infoD.setValore(i, String.format("%.2f", spazio_1), String.format("%.2f", spazio_2), String.format("%.2f", spazio_1 - spazio_2));
                continue;
            }
            try {
                String[] ID = elencoRighe.get(i).getID().split("-");
                sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(ID[0]));
                lap = sess.getLap(Integer.valueOf(ID[1]));
            }
            catch (Exception e) {
                System.out.println("ERROR: errore visualizzazione contenitore grafico");
                return;
            }
            if (this.modoSpazio) {
                spazio_1 = this.sincro.getPosizioneCursore();
                spazio_2 = this.sincro.getPosizioneCursore2();
                tempo_1 = lap.getTimeSessionAtSpazio(this.sincro.getPosizioneCursore(), DanasDataStructureConstants.BoundLap.NEAREST) - lap.getStart();
                tempo_2 = lap.getTimeSessionAtSpazio(this.sincro.getPosizioneCursore2(), DanasDataStructureConstants.BoundLap.NEAREST) - lap.getStart();
                this.infoD.setValore(i, Grafico2D.stampaSpazioTempo(tempo_1, 0), Grafico2D.stampaSpazioTempo(tempo_2, 0), Grafico2D.stampaSpazioTempo(tempo_1 - tempo_2, 0));
                continue;
            }
            tempo_1 = this.sincro.getPosizioneCursore() - lap.getOffsetTempo() + lap.getStart();
            tempo_2 = this.sincro.getPosizioneCursore2() - lap.getOffsetTempo() + lap.getStart();
            spazio_1 = sess.getSpazioAtTime(tempo_1, DanasDataStructureConstants.BoundLap.NEAREST) - lap.getDistanzaInizio();
            spazio_2 = sess.getSpazioAtTime(tempo_2, DanasDataStructureConstants.BoundLap.NEAREST) - lap.getDistanzaInizio();
            this.infoD.setValore(i, String.format("%.2f", spazio_1), String.format("%.2f", spazio_2), String.format("%.2f", spazio_1 - spazio_2));
        }
        this.infoD.aggiorna();
    }

    public void aggiornaInfoNew() {
        double time = 0.0;
        if (this.infoNewD == null) {
            return;
        }
        if (this.sincro == null) {
            return;
        }
        time = this.sincro.getPosizioneCursore();
        Vector<String> elencoColonne = this.infoNewD.getElencoColonne();
        if (elencoColonne.size() == 2) {
            return;
        }
        this.rimuoviPuntiInfo();
        if (this.sessioni) {
            for (int i = 2; i < elencoColonne.size(); ++i) {
                String[] ID = elencoColonne.get(i).split("-");
                if (ID.length < 2) {
                    return;
                }
                DanasSession sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(ID[1]));
                double tempoValore = this.modoSpazio ? sess.getTimeAtSpazio(this.sincro.getPosizioneCursore(), DanasDataStructureConstants.BoundLap.NEAREST) : time + sess.getStartTelemetryTime();
                for (int campo = 0; campo < this.infoNewD.getListaCampi().size(); ++campo) {
                    DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)];
                    Double valore = sess.getFrequenzaCanale(vt) == 0.0 ? Double.valueOf(0.0) : Double.valueOf(sess.getDatoAtTime(vt, tempoValore, DanasDataStructureConstants.BoundLap.NEAREST, true));
                    this.infoNewD.setValore(i, campo + 3, MeasuresUtil.getValorePulito(vt, valore));
                    Grafico2D graficoPunto = this.getGraficoCampo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)]));
                    Color colorePunto = !this.stileColoriGrafico.isSelected() ? (Color)((MyTableModel)this.table.getModel()).getValueAtBase(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)]), 6) : sess.getColor();
                    graficoPunto.aggiungiPuntoInfo(valore, colorePunto, MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)]));
                }
                this.infoNewD.setValore(i, 1, MeasuresUtil.timeToHumanHours((int)sess.getSessionStartHour()));
                this.infoNewD.setValore(i, 2, sess.getColor());
                if (this.modoSpazio) {
                    Double val = this.sincro.getPosizioneCursore();
                    this.infoNewD.setValore(i, this.infoNewD.getListaCampi().size() + 3, String.format("%.2f", val));
                    continue;
                }
                double tempoDecimale = this.multiSincro.getPosizioneCursoreDecimale();
                this.infoNewD.setValore(i, this.infoNewD.getListaCampi().size() + 3, Grafico2D.stampaSpazioTempo(tempoDecimale, 2));
            }
        } else {
            for (int i = 2; i < elencoColonne.size(); ++i) {
                String[] ID = elencoColonne.get(i).split("-");
                if (ID.length < 3) {
                    return;
                }
                DanasSession sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(ID[1]));
                DanasLap lap = sess.getLap(Integer.valueOf(ID[2]));
                double tempoValore = 0.0;
                tempoValore = this.modoSpazio ? lap.getTimeSessionAtSpazio(this.sincro.getPosizioneCursore(), DanasDataStructureConstants.BoundLap.NEAREST) : this.sincro.getPosizioneCursore() - lap.getOffsetTempo() + lap.getStart();
                for (int campo = 0; campo < this.infoNewD.getListaCampi().size(); ++campo) {
                    DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)];
                    Double valore = sess.getFrequenzaCanale(vt) == 0.0 ? Double.valueOf(0.0) : Double.valueOf(sess.getDatoAtTime(vt, tempoValore, DanasDataStructureConstants.BoundLap.NEAREST, true));
                    this.infoNewD.setValore(i, campo + 3, MeasuresUtil.getValorePulito(vt, valore));
                    Grafico2D graficoPunto = this.getGraficoCampo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)]));
                    Color colorePunto = !this.stileColoriGrafico.isSelected() ? (Color)((MyTableModel)this.table.getModel()).getValueAtBase(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)]), 6) : lap.getColor();
                    graficoPunto.aggiungiPuntoInfo(valore, colorePunto, MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(campo)]));
                }
                this.infoNewD.setValore(i, 1, MeasuresUtil.timeToHumanReadable((int)lap.getDuration()));
                this.infoNewD.setValore(i, 2, lap.getColor());
                if (this.modoSpazio) {
                    Double val = this.sincro.getPosizioneCursore();
                    this.infoNewD.setValore(i, this.infoNewD.getListaCampi().size() + 3, String.format("%.2f", val));
                    continue;
                }
                double tempoDecimale = this.multiSincro.getPosizioneCursoreDecimale();
                this.infoNewD.setValore(i, this.infoNewD.getListaCampi().size() + 3, Grafico2D.stampaSpazioTempo(tempoDecimale, 2));
            }
        }
        this.infoNewD.aggiorna();
    }

    private boolean usaDecimali(int campo) {
        int tipo = 8;
        if (campo == 1) {
            return false;
        }
        if (DanasDataStructure.getInstance().getDefaultSession() != null) {
            tipo = DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getTipoMoto();
            switch (tipo) {
                case 44: {
                    switch (campo) {
                        case 1: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: {
                            return false;
                        }
                    }
                    return true;
                }
            }
            return true;
        }
        return true;
    }

    public void aggiornaCanaliInfo() {
        String nomeCampo;
        Color colore;
        String nome;
        DanasSession sess;
        int i;
        int campo;
        int linea;
        if (this.infoD == null) {
            return;
        }
        this.infoD.svuota();
        if (this.sessioni) {
            for (linea = 0; linea < this.NUM_CURVE; ++linea) {
                if (!this.isLineaSelected(linea)) continue;
                campo = linea;
                for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                    sess = DanasDataStructure.getInstance().getSession(i);
                    if (!sess.isSelected()) continue;
                    nome = "Sess. " + sess.getSessionID();
                    colore = this.stileColoriGrafico.isSelected() ? sess.getColor() : (Color)((MyTableModel)this.table.getModel()).getValueAtBase(campo, 6);
                    nomeCampo = this.getNomeAsse(campo, i);
                    TableRowInfo riga = new TableRowInfo(colore, nome, nomeCampo, "-", "-", "-", "-", "-", "-", "-", "" + sess.getSessionID(), MeasuresUtil.getValueType(campo).ordinal());
                    this.infoD.addRiga(riga);
                }
            }
        } else {
            for (linea = 0; linea < this.NUM_CURVE; ++linea) {
                if (!this.isLineaSelected(linea)) continue;
                campo = linea;
                for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                    sess = DanasDataStructure.getInstance().getSession(i);
                    if (!sess.isSelected()) continue;
                    for (int giro = 1; giro <= sess.getNumberOfLaps(); ++giro) {
                        if (!sess.getLap(giro).getSelected()) continue;
                        nome = "Lap " + sess.getSessionID() + "-" + sess.getLap(giro).getLapID();
                        colore = this.stileColoriGrafico.isSelected() ? sess.getLap(giro).getColor() : (Color)((MyTableModel)this.table.getModel()).getValueAtBase(campo, 6);
                        nomeCampo = this.getNomeAsse(campo, i);
                        TableRowInfo riga = new TableRowInfo(colore, nome, nomeCampo, "-", "-", "-", "-", "-", "-", "-", "" + sess.getSessionID() + "-" + sess.getLap(giro).getLapID(), MeasuresUtil.getValueType(campo).ordinal());
                        this.infoD.addRiga(riga);
                    }
                }
            }
        }
        if (this.modoSpazio) {
            TableRowInfo riga = new TableRowInfo(Color.BLACK, Language.string("Spazio"), Language.string("Spazio"), "0", "0", "0", "-", "-", "-", "-", "1", -1);
            this.infoD.addRiga(riga);
        } else {
            TableRowInfo riga2 = new TableRowInfo(Color.BLACK, Language.string("Tempo"), Language.string("Tempo"), "0", "0", "0", "-", "-", "-", "-", "1", -1);
            this.infoD.addRiga(riga2);
        }
        if (this.sessioni) {
            for (int i2 = 1; i2 <= DanasDataStructure.getInstance().getNSessions(); ++i2) {
                DanasSession sess2 = DanasDataStructure.getInstance().getSession(i2);
                if (!sess2.isSelected()) continue;
                nome = "Sess. " + sess2.getSessionID();
                colore = sess2.getColor();
                nomeCampo = !this.modoSpazio ? Language.string("Spazio") : Language.string("Tempo");
                TableRowInfo riga3 = new TableRowInfo(colore, nome, nomeCampo, "-", "-", "-", "-", "-", "-", "-", "" + sess2.getSessionID(), -2);
                this.infoD.addRiga(riga3);
            }
        } else {
            for (int i3 = 1; i3 <= DanasDataStructure.getInstance().getNSessions(); ++i3) {
                DanasSession sess3 = DanasDataStructure.getInstance().getSession(i3);
                if (!sess3.isSelected()) continue;
                for (int giro = 1; giro <= sess3.getNumberOfLaps(); ++giro) {
                    if (!sess3.getLap(giro).getSelected()) continue;
                    nome = "Lap " + sess3.getSessionID() + "-" + sess3.getLap(giro).getLapID();
                    colore = sess3.getLap(giro).getColor();
                    nomeCampo = !this.modoSpazio ? Language.string("Spazio") : Language.string("Tempo");
                    TableRowInfo riga4 = new TableRowInfo(colore, nome, nomeCampo, "-", "-", "-", "-", "-", "-", "-", "" + sess3.getSessionID() + "-" + sess3.getLap(giro).getLapID(), -2);
                    this.infoD.addRiga(riga4);
                }
            }
        }
        this.infoD.aggiorna();
        this.infoD.pack();
        this.aggiornaInfo();
    }

    public void aggiornaStat() {
        if (this.statD == null) {
            return;
        }
        Vector<TableRowStat> elencoRighe = this.statD.getElencoRighe();
        if (elencoRighe.size() == 0) {
            return;
        }
        DanasSession s = DanasDataStructure.getInstance().getDefaultSession();
        DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
        if (this.sessioni) {
            if (s == null) {
                return;
            }
            s.aggiornaAnalisi();
            for (int i = 0; i < elencoRighe.size() - 8; ++i) {
                int indiceCampo = elencoRighe.get(i).getNumeroCanale();
                String min = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(indiceCampo), s.getMinGenericData(MeasuresUtil.getValueType(indiceCampo)));
                String max = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(indiceCampo), s.getMaxGenericData(MeasuresUtil.getValueType(indiceCampo)));
                String media = MeasuresUtil.valueToHumanReadable(s.getAvgGenericData(MeasuresUtil.getValueType(indiceCampo)), 2);
                this.statD.setValore(i, min, max, media);
            }
            this.statD.setValore(elencoRighe.size() - 7, "" + s.getSessionID());
            long time = s.getSessionEndHour() - s.getSessionStartHour();
            this.statD.setValore(elencoRighe.size() - 6, MeasuresUtil.timeToHumanHours(time));
            String percentuale = String.format("%.2f%%", s.getPercentualeGasAperto() * 100.0);
            this.statD.setValore(elencoRighe.size() - 5, percentuale);
            percentuale = String.format("%.2f%%", s.getPercentualeM(1) * 100.0);
            if (s.getPercentualeM(1) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 4, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 4, "-");
            }
            percentuale = String.format("%.2f%%", s.getPercentualeM(2) * 100.0);
            if (s.getPercentualeM(2) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 3, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 3, "-");
            }
            percentuale = String.format("%.2f%%", s.getPercentualeM(3) * 100.0);
            if (s.getPercentualeM(3) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 2, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 2, "-");
            }
            percentuale = String.format("%.2f%%", s.getPercentualeM(4) * 100.0);
            if (s.getPercentualeM(4) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 1, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 1, "-");
            }
        } else {
            if (l == null) {
                return;
            }
            l.aggiornaAnalisi();
            for (int i = 0; i < elencoRighe.size() - 8; ++i) {
                int indiceCampo = elencoRighe.get(i).getNumeroCanale();
                String min = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(indiceCampo), l.getMinGenericData(MeasuresUtil.getValueType(indiceCampo)));
                String max = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(indiceCampo), l.getMaxGenericData(MeasuresUtil.getValueType(indiceCampo)));
                String media = MeasuresUtil.valueToHumanReadable(l.getAvgGenericData(MeasuresUtil.getValueType(indiceCampo)), 2);
                this.statD.setValore(i, min, max, media);
            }
            this.statD.setValore(elencoRighe.size() - 7, l.getSession().getSessionID() + "-" + l.getLapID());
            this.statD.setValore(elencoRighe.size() - 6, MeasuresUtil.timeToHumanReadable((int)l.getDuration()));
            String percentuale = String.format("%.2f%%", l.getPercentualeGasAperto() * 100.0);
            this.statD.setValore(elencoRighe.size() - 5, percentuale);
            percentuale = String.format("%.2f%%", l.getPercentualeM(1) * 100.0);
            if (l.getPercentualeM(1) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 4, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 4, "-");
            }
            percentuale = String.format("%.2f%%", l.getPercentualeM(2) * 100.0);
            if (l.getPercentualeM(2) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 3, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 3, "-");
            }
            percentuale = String.format("%.2f%%", l.getPercentualeM(3) * 100.0);
            if (l.getPercentualeM(3) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 2, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 2, "-");
            }
            percentuale = String.format("%.2f%%", l.getPercentualeM(4) * 100.0);
            if (l.getPercentualeM(4) != -1.0) {
                this.statD.setValore(elencoRighe.size() - 1, percentuale);
            } else {
                this.statD.setValore(elencoRighe.size() - 1, "-");
            }
        }
        this.statD.aggiorna();
    }

    public void aggiornaCanaliStat() {
        String nomeCampo;
        if (this.statD == null) {
            return;
        }
        this.statD.svuota();
        for (int linea = 0; linea < this.NUM_CURVE; ++linea) {
            int campo = linea;
            if (MeasuresUtil.getValueType(campo) == DanasDataStructureConstants.ValueType.SIM1 || MeasuresUtil.getValueType(campo) == DanasDataStructureConstants.ValueType.SIM2 || !this.isLineaOnInfo(linea)) continue;
            nomeCampo = this.getNomeAsse(campo);
            Color colore = this.stileColoriGrafico.isSelected() ? Color.white : (Color)((MyTableModel)this.table.getModel()).getValueAtBase(campo, 6);
            TableRowStat riga = new TableRowStat(colore, nomeCampo, "-", "-", "-", campo);
            this.statD.addRiga(riga);
        }
        TableRowStat riga = new TableRowStat(new Color(240, 240, 240), Language.string("Funzione"), Language.string("Valore"), " ", " ", 0);
        this.statD.addRiga(riga);
        riga = new TableRowStat(Color.WHITE, Language.string("Nome"), "-", "-", "-", 0);
        this.statD.addRiga(riga);
        riga = new TableRowStat(Color.WHITE, Language.string("Tempo"), "-", "-", "-", 0);
        this.statD.addRiga(riga);
        riga = new TableRowStat(Color.WHITE, "TPS>95%", "-", "-", "-", 0);
        this.statD.addRiga(riga);
        nomeCampo = MeasuresUtil.getNomeCanale(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_1));
        riga = new TableRowStat(Color.WHITE, nomeCampo + ">0", "-", "-", "-", 0);
        this.statD.addRiga(riga);
        nomeCampo = MeasuresUtil.getNomeCanale(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_2));
        riga = new TableRowStat(Color.WHITE, nomeCampo + ">0", "-", "-", "-", 0);
        this.statD.addRiga(riga);
        nomeCampo = MeasuresUtil.getNomeCanale(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_3));
        riga = new TableRowStat(Color.WHITE, nomeCampo + ">0", "-", "-", "-", 0);
        this.statD.addRiga(riga);
        nomeCampo = MeasuresUtil.getNomeCanale(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_4));
        riga = new TableRowStat(Color.WHITE, nomeCampo + ">0", "-", "-", "-", 0);
        this.statD.addRiga(riga);
        this.statD.refresh();
        this.statD.pack();
    }

    public void aggiornaCanaliInfoNew() {
        int i;
        if (this.infoNewD == null) {
            return;
        }
        int posizione = DanasDataStructure.getInstance().getMainFrame().getSplitPaneInfoDividerPosition();
        this.infoNewD.svuota();
        for (int linea = 0; linea < this.NUM_CURVE; ++linea) {
            if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAt(linea, 3)).booleanValue()) continue;
            int i2 = linea;
            this.infoNewD.addCampo(MeasuresUtil.getValueType(i2).ordinal());
        }
        this.infoNewD.addColonna(Language.string("Colore"));
        this.infoNewD.addColonna(Language.string("Canale"));
        for (i = 0; i < this.infoNewD.getListaCampi().size(); ++i) {
            Color colore = this.stileColoriGrafico.isSelected() ? Color.WHITE : (Color)((MyTableModel)this.table.getModel()).getValueAtBase(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(i)]), 6);
            String nomeCampo = (String)((MyTableModel)this.table.getModel()).getValueAtBase(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[this.infoNewD.getListaCampi().get(i)]), 5);
            this.infoNewD.setValore(0, i + 3, colore);
            this.infoNewD.setValore(1, i + 3, nomeCampo);
        }
        if (this.modoSpazio) {
            this.infoNewD.setValore(1, this.infoNewD.getListaCampi().size() + 3, Language.string("Spazio"));
        } else {
            this.infoNewD.setValore(1, this.infoNewD.getListaCampi().size() + 3, Language.string("Tempo"));
        }
        this.infoNewD.setValore(1, 1, Language.string("Starting time"));
        this.infoNewD.setValore(1, 2, Language.string("Colore"));
        if (this.sessioni) {
            for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                DanasSession sess = DanasDataStructure.getInstance().getSession(i);
                if (!sess.isSelected()) continue;
                String nome = "Sess.-" + sess.getSessionID();
                this.infoNewD.addColonna(nome);
            }
        } else {
            this.infoNewD.setValore(1, 1, Language.string("Lap time"));
            for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                DanasSession sess = DanasDataStructure.getInstance().getSession(i);
                if (!sess.isSelected()) continue;
                for (int giro = 1; giro <= sess.getNumberOfLaps(); ++giro) {
                    if (!sess.getLap(giro).getSelected()) continue;
                    String nome = "Lap-" + sess.getSessionID() + "-" + sess.getLap(giro).getLapID();
                    this.infoNewD.addColonna(nome);
                }
            }
        }
        this.infoNewD.refresh();
        this.infoNewD.pack();
        this.aggiornaInfoNew();
    }

    public double getValoreCursore(int indiceAnalog) {
        DanasSession sess;
        DanasDataStructureConstants.ValueType vt;
        if (this.sincro == null) {
            return 0.0;
        }
        switch (indiceAnalog) {
            case 0: {
                vt = DanasDataStructureConstants.ValueType.ANALOG1;
                break;
            }
            case 1: {
                vt = DanasDataStructureConstants.ValueType.ANALOG2;
                break;
            }
            case 2: {
                vt = DanasDataStructureConstants.ValueType.ANALOG3;
                break;
            }
            case 3: {
                vt = DanasDataStructureConstants.ValueType.ANALOG4;
                break;
            }
            case 4: {
                vt = DanasDataStructureConstants.ValueType.ANALOG5;
                break;
            }
            case 5: {
                vt = DanasDataStructureConstants.ValueType.ANALOG6;
                break;
            }
            case 6: {
                vt = DanasDataStructureConstants.ValueType.ANALOG7;
                break;
            }
            case 7: {
                vt = DanasDataStructureConstants.ValueType.ANALOG8;
                break;
            }
            case 8: {
                vt = DanasDataStructureConstants.ValueType.EXT1;
                break;
            }
            case 9: {
                vt = DanasDataStructureConstants.ValueType.EXT2;
                break;
            }
            default: {
                return 0.0;
            }
        }
        double tempoValore = 0.0;
        if (this.sessioni) {
            if (DanasDataStructure.getInstance().getDefaultSession() == null) {
                return 0.0;
            }
            sess = DanasDataStructure.getInstance().getDefaultSession();
            if (sess.getFrequenzaCanale(vt) == 0.0) {
                return 0.0;
            }
            tempoValore = this.modoSpazio ? sess.getTimeAtSpazio(this.sincro.getPosizioneCursore(), DanasDataStructureConstants.BoundLap.NEAREST) : this.sincro.getPosizioneCursore() + sess.getStartTelemetryTime();
        } else {
            if (DanasDataStructure.getInstance().getDefaultLap() == null) {
                return 0.0;
            }
            DanasLap lap = DanasDataStructure.getInstance().getDefaultLap();
            sess = lap.getSession();
            if (sess.getFrequenzaCanale(vt) == 0.0) {
                return 0.0;
            }
            tempoValore = this.modoSpazio ? lap.getTimeSessionAtSpazio(this.sincro.getPosizioneCursore(), DanasDataStructureConstants.BoundLap.NEAREST) : this.sincro.getPosizioneCursore() + lap.getStart();
        }
        return sess.getDatoAtTime(vt, tempoValore, DanasDataStructureConstants.BoundLap.NEAREST, true);
    }

    public void rimuoviPuntiInfo() {
        for (int i = 0; i < this.elencoGrafici.size(); ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).rimuoviPuntiInfo();
        }
    }

    public void refreshGrafici() {
        for (int i = 0; i < this.elencoGrafici.size(); ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).refresh();
        }
    }

    public void refreshAll() {
        if (this.numeroGrafici == 1) {
            ((Grafico2D)this.elencoGrafici.elementAt(0)).refresh();
            return;
        }
        if (this.numeroGrafici == 2) {
            ((Grafico2D)this.elencoGrafici.elementAt(0)).refresh();
            ((Grafico2D)this.elencoGrafici.elementAt(1)).refresh();
            return;
        }
        if (this.numeroGrafici > 2) {
            for (int i = 2; i < this.NUM_CURVE + 2; ++i) {
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i - 2, 2)).booleanValue()) continue;
                ((Grafico2D)this.elencoGrafici.elementAt(i)).refresh();
            }
        }
    }

    public void ricalcolaTutto() {
        this.ricalcolaTutto(this.modoSpazio, this.numeroGrafici);
    }

    public void ricalcolaTutto(boolean spazio, int nGrafici) {
        System.out.println("Inizio ricalcola tutto grafico:" + (double)(System.currentTimeMillis() - DanasDataStructure.getTempoApertura()) / 1000.0);
        this.localModoSpazio = spazio;
        this.localNumeroGrafici = nGrafici;
        this.table.setEnabled(false);
        DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(false);
        MyTableModel modelloTabella = (MyTableModel)this.table.getModel();
        this.setSelectedIndex(0);
        this.numeroGrafici = this.localNumeroGrafici;
        this.limitaAssi();
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.getElementAt(i)).rimuoviSincronizzatore();
        }
        DefaultListModel[] campi = new DefaultListModel[this.NUM_CURVE];
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            DefaultListModel lista;
            campi[i] = lista = new DefaultListModel();
        }
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            Grafico2D g = (Grafico2D)this.elencoGrafici.elementAt(i);
            g.rimuoviAllAssi();
            g.setAllInvisible();
            for (int numeroScena = 0; numeroScena < this.NUM_CURVE; ++numeroScena) {
                GScene s = g.getScene(numeroScena);
                s.removeAll();
            }
            g.setModoSpazio(this.localModoSpazio);
        }
        System.out.println("Fine rimozione curve:" + (double)(System.currentTimeMillis() - DanasDataStructure.getTempoApertura()) / 1000.0);
        long inizioCurva = System.currentTimeMillis();
        for (int numeroScena = 0; numeroScena < this.NUM_CURVE; ++numeroScena) {
            if (((Boolean)modelloTabella.getValueAtBase(numeroScena, 2)).booleanValue()) {
                inizioCurva = System.currentTimeMillis();
                Vector<Curva> elencoCurve = this.sessioni ? DanasDataStructure.getInstance().getCurvaSelected(MeasuresUtil.getValueType(numeroScena)) : DanasDataStructure.getInstance().getCurvaSelectedLap(MeasuresUtil.getValueType(numeroScena));
                for (int j = 0; j < elencoCurve.size(); ++j) {
                    Curva c = elencoCurve.elementAt(j);
                    if (!this.stileColoriGrafico.isSelected()) {
                        c.setColore((Color)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 6));
                    }
                    c.setSpessore(this.getValoreSpessore(numeroScena));
                    c.setStile(this.getValoreStile(numeroScena));
                    c.setModoSpazio(this.localModoSpazio, false);
                    c.setTipoRef(this.getModoRef(numeroScena));
                    c.setValoreRef((Double)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 14));
                    campi[numeroScena].addElement(c);
                }
                this.elencoNumeroCurve[numeroScena] = elencoCurve.size();
                continue;
            }
            this.elencoNumeroCurve[numeroScena] = 0;
        }
        System.out.println("Fine creazione curve:" + (double)(System.currentTimeMillis() - DanasDataStructure.getTempoApertura()) / 1000.0);
        this.numeroGrafici = this.localNumeroGrafici;
        if (this.numeroGrafici == 2) {
            this.setComponentAt(0, null);
            int altezza = this.getHeight() - this.altezzaTab;
            this.splitGrafici = new JSplitPane(0);
            Border empty = BorderFactory.createEmptyBorder();
            this.splitGrafici.setBorder(empty);
            this.splitGrafici.setDividerLocation(altezza / 2);
            this.splitGrafici.setResizeWeight(0.5);
            this.splitGrafici.setDividerSize(1);
            int[] elencoAltezzeDue = this.getAtltezzeGrafici(this.getAltezza() + 2);
            Grafico2D graficoTop = (Grafico2D)this.elencoGrafici.getElementAt(1);
            graficoTop.setMargini(1, 1, 5, 5);
            Grafico2D graficoBottom = (Grafico2D)this.elencoGrafici.getElementAt(0);
            graficoBottom.setMargini(1, 25, 5, 5);
            this.splitGrafici.setTopComponent(graficoTop.getGrafico());
            this.splitGrafici.setBottomComponent(graficoBottom.getGrafico());
            this.setComponentAt(0, this.splitGrafici);
            for (int i = 0; i < this.NUM_CURVE; ++i) {
                GObject obj;
                int j;
                if (((MyTableModel)this.table.getModel()).getValueAtBase(i, 0).equals(this.iconaUp)) {
                    if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                        this.getGraficoCampo(i).setAsseY(this.getRealMin(i), this.getRealMax(i), i, elencoAltezzeDue[1], false);
                        graficoTop.setScenaVisibile(i, true);
                    }
                    if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                        graficoTop.mostraAsse(i, false);
                    }
                    for (j = 0; j < campi[i].size(); ++j) {
                        obj = (GObject)campi[i].getElementAt(j);
                        graficoTop.getScene(i).add(obj);
                    }
                } else {
                    if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                        this.getGraficoCampo(i).setAsseY(this.getRealMin(i), this.getRealMax(i), i, elencoAltezzeDue[0], false);
                        graficoBottom.setScenaVisibile(i, true);
                    }
                    if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                        graficoBottom.mostraAsse(i, false);
                    }
                    for (j = 0; j < campi[i].size(); ++j) {
                        obj = (GObject)campi[i].getElementAt(j);
                        graficoBottom.getScene(i).add(obj);
                    }
                }
                if (!this.autofit || this.bloccaY.isSelected()) continue;
                this.fittaScenaVerticale(i, false);
            }
            this.setMargineLeft();
            graficoTop.aggiungiSincronizzatore(this.sincro);
            graficoBottom.aggiungiSincronizzatore(this.sincro);
            this.modoSpazio = this.localModoSpazio;
            if (!this.bloccaX.isSelected()) {
                this.fittaOrizzontale(false);
            }
            this.sincro.setLarghezza(this.getWidth() - 5);
            this.sincro.setAggiornaModo(true);
        }
        if (this.numeroGrafici == 1) {
            int[] elencoAltezze = this.getAtltezzeGrafici(this.getAltezza() + 2);
            this.setComponentAt(0, null);
            Grafico2D graf = (Grafico2D)this.elencoGrafici.getElementAt(0);
            graf.setMargini(5, 25, 5, 5);
            for (int i = 0; i < this.NUM_CURVE; ++i) {
                if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                    graf.setAsseY(this.getRealMin(i), this.getRealMax(i), i, elencoAltezze[0], false);
                    graf.setScenaVisibile(i, true);
                }
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                    graf.mostraAsse(i, false);
                }
                for (int j = 0; j < campi[i].size(); ++j) {
                    GObject obj = (GObject)campi[i].getElementAt(j);
                    graf.getScene(i).add(obj);
                }
                if (!this.autofit || this.bloccaY.isSelected()) continue;
                this.fittaScenaVerticale(i, false);
            }
            this.setMargineLeft();
            graf.aggiungiSincronizzatore(this.sincro);
            this.setComponentAt(0, graf.getGrafico());
            this.modoSpazio = this.localModoSpazio;
            if (!this.bloccaX.isSelected()) {
                this.fittaOrizzontale(false);
            }
            this.sincro.setLarghezza(this.contenitore.getWidth() - 5);
            this.sincro.setAggiornaModo(true);
        }
        if (this.numeroGrafici > 2) {
            int i;
            this.setComponentAt(0, null);
            this.splitGrafici = this.getDivisioneMulti();
            int[] elencoAltezzeTre = this.getAtltezzeGrafici(this.getAltezza() + 2);
            int numeroTotale = elencoAltezzeTre.length;
            int numeroGrafico = 0;
            for (i = 0; i < this.NUM_CURVE; ++i) {
                if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                    this.getGraficoCampo(i).setAsseY(this.getRealMin(i), this.getRealMax(i), i, elencoAltezzeTre[numeroTotale - ++numeroGrafico], true);
                    this.getGraficoCampo(i).setScenaVisibile(i, true);
                }
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 1)).booleanValue()) {
                    this.getGraficoCampo(i).mostraAsse(i, false);
                }
                for (int j = 0; j < campi[i].size(); ++j) {
                    GObject ob = (GObject)campi[i].getElementAt(j);
                    this.getGraficoCampo(i).getScene(i).add(ob);
                }
                if (!this.autofit || this.bloccaY.isSelected()) continue;
                this.fittaScenaVerticale(i, false);
            }
            this.setMargineLeft();
            this.setComponentAt(0, this.getGrafico());
            for (i = 0; i < this.NUM_CURVE; ++i) {
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) continue;
                this.getGraficoCampo(i).aggiungiSincronizzatore(this.sincro);
            }
            this.modoSpazio = this.localModoSpazio;
            if (!this.bloccaX.isSelected()) {
                this.fittaOrizzontale(false);
            }
            this.sincro.setLarghezza(this.getWidth() - 5);
            this.sincro.setAggiornaModo(true);
        }
        if (this.aggiornaIntertempi) {
            this.aggiornaLineeIntertempo();
        }
        this.aggiornaIntertempi = true;
        this.aggiornaCanaliInfo();
        this.aggiornaCanaliInfoNew();
        this.posizioneCursore = 0.0;
        this.multiSincro.setAggiornaPosizioneCursore(true);
        this.aggiornaInfo();
        this.aggiornaInfoNew();
        this.table.setEnabled(true);
        DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(true);
        long parziale = System.currentTimeMillis();
        System.out.println("Fine ricalcola tutto grafico:" + (double)(System.currentTimeMillis() - DanasDataStructure.getTempoApertura()) / 1000.0);
        System.out.println("Aggiorno canali stat");
        this.aggiornaCanaliStat();
        this.aggiornaStat();
        DanasDataStructure.getInstance().getMainFrame().aggiornaEstremiBarra();
    }

    public void refreshCampo(int campo) {
        this.getGraficoCampo(campo).refresh();
    }

    public void aggiungiCurva(String id) {
        int i;
        boolean fitta = true;
        boolean graficoPieno = false;
        boolean aggiuntaSessione = true;
        if (id.contains("-")) {
            aggiuntaSessione = false;
        }
        String[] sessioniGiri = id.split("-");
        for (i = 0; i < this.NUM_CURVE; ++i) {
            if (this.elencoNumeroCurve[i] == 0) continue;
            fitta = false;
        }
        for (i = 0; i < this.NUM_CURVE; ++i) {
            Grafico2D graph = this.getGraficoCampo(i);
            if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                Curva curvaAggiunta = aggiuntaSessione ? DanasDataStructure.getInstance().getCurva(MeasuresUtil.getValueType(i), Integer.valueOf(id)) : DanasDataStructure.getInstance().getCurvaLap(MeasuresUtil.getValueType(i), Integer.valueOf(sessioniGiri[0]), Integer.valueOf(sessioniGiri[1]));
                if (curvaAggiunta == null) continue;
                if (!this.stileColoriGrafico.isSelected()) {
                    curvaAggiunta.setColore((Color)((MyTableModel)this.table.getModel()).getValueAtBase(i, 6));
                }
                curvaAggiunta.setSpessore(this.getValoreSpessore(i));
                curvaAggiunta.setStile(this.getValoreStile(i));
                curvaAggiunta.setModoSpazio(this.modoSpazio, false);
                curvaAggiunta.setTipoRef(this.getModoRef(i));
                curvaAggiunta.setValoreRef((Double)((MyTableModel)this.table.getModel()).getValueAtBase(i, 14));
                graph.aggiungiCurva(i, curvaAggiunta);
                if (this.elencoNumeroCurve[i] == 0 && this.autofit && !this.bloccaY.isSelected()) {
                    this.fittaScenaVerticale(i, false);
                }
                if (this.elencoNumeroCurve[i] == 1 && this.autofit && !this.bloccaY.isSelected() && i == DanasDataStructureConstants.ValueType.DELAY.ordinal()) {
                    this.fittaScenaVerticale(i, false);
                }
                this.elencoNumeroCurve[i] = this.elencoNumeroCurve[i] + 1;
                continue;
            }
            this.elencoNumeroCurve[i] = 0;
        }
        for (i = 0; i < this.NUM_CURVE; ++i) {
            if (this.elencoNumeroCurve[i] == 0) continue;
            graficoPieno = true;
        }
        if (graficoPieno && fitta && !this.bloccaX.isSelected()) {
            this.fittaOrizzontale(true);
        }
        this.aggiungiLineaIntertempo(id);
        this.refreshAll();
    }

    public void aggiornaLineeIntertempo() {
        int i;
        for (int j = 0; j < this.elencoGrafici.size(); ++j) {
            ((Grafico2D)this.elencoGrafici.get(j)).rimuoviAllLineeIntertempo();
        }
        if (DanasDataStructure.getInstance().getMainFrame().getFftMode()) {
            return;
        }
        if (this.sessioni) {
            for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                if (!DanasDataStructure.getInstance().getSession(i).isSelected()) continue;
                this.aggiungiLineaIntertempo(Integer.valueOf(i).toString());
            }
        } else {
            for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                DanasSession sess = DanasDataStructure.getInstance().getSession(i);
                if (!sess.isSelected()) continue;
                for (int j = 1; j <= sess.getNumberOfLaps(); ++j) {
                    if (!sess.getLap(j).getSelected()) continue;
                    this.aggiungiLineaIntertempo(Integer.valueOf(i).toString() + "-" + Integer.valueOf(j));
                }
            }
        }
    }

    public void rimuoviLineeIntertempo() {
        for (int j = 0; j < this.elencoGrafici.size(); ++j) {
            ((Grafico2D)this.elencoGrafici.get(j)).rimuoviAllLineeIntertempo();
        }
    }

    public void aggiungiLineaIntertempo(String id) {
        boolean aggiuntaSessione = true;
        if (id.contains("-")) {
            aggiuntaSessione = false;
        }
        String[] sessioniGiri = id.split("-");
        if (!aggiuntaSessione) {
            DanasLap defLap = DanasDataStructure.getInstance().getDefaultLap();
            DanasSession sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(sessioniGiri[0]));
            DanasLap lap = sess.getLap(Integer.valueOf(sessioniGiri[1]));
            for (int i = 1; i < lap.getNSplit(); ++i) {
                double tempo = lap.getSplit(i).getEndTime() + lap.getOffsetTempo() - lap.getStart();
                if (defLap == null || defLap.getSplit(i) == null) {
                    System.out.println("Log:AggiungiLineaIntertempo: defLap \u00e8 nullo o non ha lo split");
                    return;
                }
                Double tempoTemp = defLap.getSplit(i).getEndTime() - defLap.getStart();
                double spazio = 0.0;
                try {
                    spazio = defLap.getDistanzaInizioLap(tempoTemp);
                }
                catch (Exception e) {
                    System.out.println("Error:AggiungiLineaIntertempo: tempoTemp \u00e8 nullo");
                }
                String scritta = Integer.valueOf(i).toString();
                Color colore = lap.getColor();
                for (int j = 0; j < this.elencoGrafici.size(); ++j) {
                    ((Grafico2D)this.elencoGrafici.get(j)).aggiungiLineaIntertempo(spazio, tempo, scritta, id, colore);
                }
            }
            double tempo = lap.getDuration() / 10.0 + lap.getOffsetTempo();
            double spazio = defLap.getDistanceCovered(DanasDataStructureConstants.DataType.GPS);
            String scritta = "F";
            Color colore = lap.getColor();
            for (int j = 0; j < this.elencoGrafici.size(); ++j) {
                ((Grafico2D)this.elencoGrafici.get(j)).aggiungiLineaIntertempo(spazio, tempo, scritta, id, colore);
            }
        } else {
            DanasSession sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(id));
            for (int k = 1; k <= sess.getNumberOfLaps(); ++k) {
                DanasLap lap = sess.getLap(k);
                for (int i = 1; i < lap.getNSplit(); ++i) {
                    double tempo = lap.getSplit(i).getEndTime() - sess.getStartTelemetryTime();
                    double spazio = sess.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, lap.getSplit(i).getEndTime());
                    String scritta = Integer.valueOf(k).toString() + "-" + Integer.valueOf(i).toString();
                    Color colore = sess.getColor();
                    for (int j = 0; j < this.elencoGrafici.size(); ++j) {
                        ((Grafico2D)this.elencoGrafici.get(j)).aggiungiLineaIntertempo(spazio, tempo, scritta, id, colore);
                    }
                }
                double tempo = lap.getEnd() - sess.getStartTelemetryTime();
                double spazio = sess.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, lap.getEnd());
                String scritta = "F";
                Color colore = sess.getColor();
                for (int j = 0; j < this.elencoGrafici.size(); ++j) {
                    ((Grafico2D)this.elencoGrafici.get(j)).aggiungiLineaIntertempo(spazio, tempo, scritta, id, colore);
                }
            }
        }
    }

    public void rimuoviTutto() {
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            Grafico2D graph = this.getGraficoCampo(i);
            graph.rimuoviTutto(i);
        }
        for (int j = 0; j < this.elencoGrafici.size(); ++j) {
            ((Grafico2D)this.elencoGrafici.get(j)).rimuoviAllLineeIntertempo();
        }
        this.refreshAll();
    }

    public void rimuoviCurva(String id) {
        for (int i = 0; i < this.NUM_CURVE; ++i) {
            Grafico2D graph = this.getGraficoCampo(i);
            if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                graph.rimuoviCurva(i, id);
                this.elencoNumeroCurve[i] = this.elencoNumeroCurve[i] - 1;
                continue;
            }
            this.elencoNumeroCurve[i] = 0;
        }
        for (int j = 0; j < this.elencoGrafici.size(); ++j) {
            ((Grafico2D)this.elencoGrafici.get(j)).rimuoviLineaIntertempo(id);
        }
        this.refreshAll();
    }

    public void aggiornaCurveCanale(int canale) {
        Grafico2D graph = this.getGraficoCampo(canale);
        graph.rimuoviTutto(canale);
        Vector<Curva> elencoCurve = this.sessioni ? DanasDataStructure.getInstance().getCurvaSelected(MeasuresUtil.getValueType(canale)) : DanasDataStructure.getInstance().getCurvaSelectedLap(MeasuresUtil.getValueType(canale));
        for (int j = 0; j < elencoCurve.size(); ++j) {
            Curva c = elencoCurve.elementAt(j);
            if (!this.stileColoriGrafico.isSelected()) {
                c.setColore((Color)((MyTableModel)this.table.getModel()).getValueAtBase(canale, 6));
            }
            c.setSpessore(this.getValoreSpessore(canale));
            c.setStile(this.getValoreStile(canale));
            c.setModoSpazio(this.modoSpazio, false);
            c.setTipoRef(this.getModoRef(canale));
            c.setValoreRef((Double)((MyTableModel)this.table.getModel()).getValueAtBase(canale, 14));
            graph.aggiungiCurva(canale, c);
        }
    }

    public void aggiornaCanaliMatematici(boolean mostraFinestra, boolean canaliMath) {
        this.mostraProgress = mostraFinestra;
        this.aggiornaNomiCanali();
        if (canaliMath) {
            return;
        }
        if (!DanasDataStructure.getInstance().getSimulazioneMarcieAttiva()) {
            return;
        }
        if (this.mostraProgress) {
            this.frameAttesa.setVisible(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                    DanasDataStructure.getInstance().getSession(i).setArraySimuNotCreated();
                }
                ContenitoreGrafico.this.aggiornaCurve();
                ContenitoreGrafico.this.frameAttesa.setVisible(false);
            }
        });
    }

    public void aggiungiCurva(int tipoCurva, Curva c) {
        this.getGraficoCampo(tipoCurva).aggiungiCurva(tipoCurva, c);
    }

    public boolean isMathSelected(int numeroCanale) {
        if (numeroCanale <= 0) {
            return false;
        }
        if (numeroCanale > 4) {
            return false;
        }
        DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.MATH_1;
        switch (numeroCanale) {
            case 1: {
                vt = DanasDataStructureConstants.ValueType.MATH_1;
                break;
            }
            case 2: {
                vt = DanasDataStructureConstants.ValueType.MATH_2;
                break;
            }
            case 3: {
                vt = DanasDataStructureConstants.ValueType.MATH_3;
                break;
            }
            case 4: {
                vt = DanasDataStructureConstants.ValueType.MATH_4;
            }
        }
        return (Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(MeasuresUtil.getPositionType(vt), 2) != false || (Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(MeasuresUtil.getPositionType(vt), 3) != false;
    }

    public void aggiornaCurve() {
        int i;
        boolean fitta = true;
        boolean graficoPieno = false;
        for (i = 0; i < this.NUM_CURVE; ++i) {
            if (this.elencoNumeroCurve[i] == 0) continue;
            fitta = false;
        }
        for (i = 0; i < this.NUM_CURVE; ++i) {
            Grafico2D graph = this.getGraficoCampo(i);
            graph.rimuoviTutto(i);
            if (((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(i, 2)).booleanValue()) {
                Vector<Curva> elencoCurve = this.sessioni ? DanasDataStructure.getInstance().getCurvaSelected(MeasuresUtil.getValueType(i)) : DanasDataStructure.getInstance().getCurvaSelectedLap(MeasuresUtil.getValueType(i));
                for (int j = 0; j < elencoCurve.size(); ++j) {
                    Curva c = elencoCurve.elementAt(j);
                    if (!this.stileColoriGrafico.isSelected()) {
                        c.setColore((Color)((MyTableModel)this.table.getModel()).getValueAtBase(i, 6));
                    }
                    c.setSpessore(this.getValoreSpessore(i));
                    c.setStile(this.getValoreStile(i));
                    c.setModoSpazio(this.modoSpazio, false);
                    c.setTipoRef(this.getModoRef(i));
                    c.setValoreRef((Double)((MyTableModel)this.table.getModel()).getValueAtBase(i, 14));
                    graph.aggiungiCurva(i, c);
                }
                if (this.elencoNumeroCurve[i] == 0 && this.autofit && !this.bloccaY.isSelected()) {
                    this.fittaScenaVerticale(i, false);
                }
                this.elencoNumeroCurve[i] = elencoCurve.size();
                continue;
            }
            this.elencoNumeroCurve[i] = 0;
        }
        for (i = 0; i < this.NUM_CURVE; ++i) {
            if (this.elencoNumeroCurve[i] == 0) continue;
            graficoPieno = true;
        }
        if (graficoPieno && fitta && !this.bloccaX.isSelected()) {
            this.fittaOrizzontale(true);
        }
        this.aggiornaLineeIntertempo();
        this.refreshAll();
    }

    public void aggiornaCurvaDefault() {
        this.curvaDefault = this.sessioni ? (this.dati.getDefaultSession() == null ? null : this.dati.getCurva(DanasDataStructureConstants.ValueType.VEL_GPS, this.dati.getDefaultSession().getSessionID())) : (this.dati.getDefaultLap() == null ? null : this.dati.getCurvaLap(DanasDataStructureConstants.ValueType.VEL_GPS, this.dati.getDefaultLap().getSession().getSessionID(), this.dati.getDefaultLap().getLapID()));
        this.aggiornaCanaliStat();
        this.aggiornaStat();
    }

    public int[] getAtltezzeGrafici(int altezza) {
        int numeroTotaleGrafici = 0;
        boolean campoAttuale = false;
        boolean numeroGrafico = false;
        int numTot = 1;
        int altezzaGrafici = altezza;
        int[] arrayAltezzeGrafici = new int[1];
        if (this.numeroGrafici == 1) {
            numTot = 1;
            arrayAltezzeGrafici[0] = altezzaGrafici > 29 ? altezza - 29 : altezza;
        }
        if (this.numeroGrafici == 2) {
            int graficoSotto;
            numTot = 2;
            this.splitGrafici.setDividerLocation((this.getHeight() - this.altezzaTab) / 2);
            int altezzaTabbed = altezza - 2;
            int graficoSopra = (altezzaTabbed - this.altezzaTab) / 2;
            if (graficoSopra <= 0) {
                graficoSopra = 10;
            }
            if ((graficoSotto = altezza - (this.altezzaTab - 3) - 1 - graficoSopra) <= 0) {
                graficoSotto = 10;
            }
            arrayAltezzeGrafici = new int[]{graficoSotto, graficoSopra};
        }
        if (this.numeroGrafici > 2) {
            numTot = this.NUM_CURVE + 2;
            for (int numeroScena = 0; numeroScena < this.NUM_CURVE; ++numeroScena) {
                if (!((Boolean)((MyTableModel)this.table.getModel()).getValueAtBase(numeroScena, 2)).booleanValue()) continue;
                ++numeroTotaleGrafici;
            }
            if (numeroTotaleGrafici == 0) {
                arrayAltezzeGrafici = new int[]{altezza - (this.altezzaTab - 3)};
                return arrayAltezzeGrafici;
            }
            arrayAltezzeGrafici = new int[numeroTotaleGrafici];
            int hTabbed = altezza - 2;
            int hAltezza = hTabbed - this.altezzaTab - 20;
            int hSingolo = hAltezza / numeroTotaleGrafici;
            int altezzaResidua = hAltezza;
            int primaDimensione = altezza - (this.altezzaTab - 3) - (altezzaResidua - hSingolo) - 1;
            for (int j = 0; j < this.listaSplit.size(); ++j) {
                arrayAltezzeGrafici[j] = j == 0 ? primaDimensione : hSingolo - 1;
                altezzaResidua -= hSingolo;
            }
            if (numeroTotaleGrafici > 1) {
                arrayAltezzeGrafici[this.listaSplit.size()] = altezzaResidua;
            }
        }
        return arrayAltezzeGrafici;
    }

    private void azzeraCanale(int analog) {
        float zero = 0.0f;
        DanasSession sess = null;
        zero = (float)this.getValoreCursore(analog);
        if (this.sessioni) {
            if (DanasDataStructure.getInstance().getDefaultSession() == null) {
                return;
            }
            sess = DanasDataStructure.getInstance().getDefaultSession();
        } else {
            if (DanasDataStructure.getInstance().getDefaultLap() == null) {
                return;
            }
            sess = DanasDataStructure.getInstance().getDefaultLap().getSession();
        }
        float min = sess.getSessionSettings().getMinimo(sess.getSessionSettings().getValueAnalogico(analog + 1));
        float max = sess.getSessionSettings().getMassimo(sess.getSessionSettings().getValueAnalogico(analog + 1));
        sess.getSessionSettings().setMinimo(sess.getSessionSettings().getValueAnalogico(analog + 1), min -= zero);
        sess.getSessionSettings().setMassimo(sess.getSessionSettings().getValueAnalogico(analog + 1), max -= zero);
        sess.getSessionSettings().salvaSettaggiAnalog();
        DanasDataStructure.getInstance().refreshSettings(false);
        this.aggiornaCanaliStat();
        this.aggiornaStat();
    }

    public int getNumCurve() {
        return this.NUM_CURVE;
    }

    public int getAltezza() {
        return this.getHeight();
    }

    public void stampaDimensioniSplit() {
        System.out.println("Grafico Tabbed=" + this.getHeight());
        if (this.listaSplit == null) {
            return;
        }
        for (int i = 0; i < this.listaSplit.size(); ++i) {
            System.out.println("divisione:" + i + " posizione=" + ((JSplitPane)this.listaSplit.getElementAt(i)).getDividerLocation() + " altezza=" + ((JSplitPane)this.listaSplit.getElementAt(i)).getHeight() + " parte sotto=" + ((JSplitPane)this.listaSplit.getElementAt(i)).getBottomComponent().getHeight() + " parte sopra=" + ((JSplitPane)this.listaSplit.getElementAt(i)).getTopComponent().getHeight());
        }
    }

    public void aggiornamentoDaTabella() {
        if (this.graficoInVista && this.numeroGrafici > 2) {
            this.ricalcolaTutto(this.modoSpazio, this.numeroGrafici);
        } else {
            Object data = this.model1.getValueAtBase(this.rowT, 2);
            Object data2 = this.model1.getValueAtBase(this.rowT, 1);
            if (((Boolean)data).booleanValue()) {
                Grafico2D graph = this.getGraficoCampo(this.rowT);
                graph.setAsseY(this.getRealMin(this.rowT), this.getRealMax(this.rowT), this.rowT, true);
                graph.setScenaVisibile(this.rowT, true);
                this.aggiornaCurveCanale(this.rowT);
                if (this.autofit && !this.bloccaY.isSelected()) {
                    this.contenitore.fittaScenaVerticale(this.rowT, false);
                }
                if (!((Boolean)data2).booleanValue()) {
                    this.getGraficoCampo(this.rowT).mostraAsse(this.rowT, false);
                }
                int numeroCurve = 0;
                for (int i = 0; i < this.NUM_CURVE; ++i) {
                    if (!((Boolean)this.model1.getValueAtBase(i, 2)).booleanValue()) continue;
                    ++numeroCurve;
                }
                if (numeroCurve == 1 && !this.bloccaX.isSelected()) {
                    this.contenitore.fittaOrizzontale(true);
                }
            } else {
                this.getGraficoCampo(this.rowT).setScenaVisibile(this.rowT, false);
            }
            if (this.numeroGrafici > 2) {
                this.splitGrafici = this.getDivisioneMulti();
                this.setMargineLeft();
                if (((Boolean)data).booleanValue()) {
                    this.getGraficoCampo(this.rowT).aggiungiSincronizzatore(this.sincro);
                } else {
                    this.getGraficoCampo(this.rowT).rimuoviSincronizzatore();
                }
                this.sincro.setLarghezza(this.contenitore.getWidth() - 5);
                this.sincro.setAggiornaFuturoAsse(true);
                this.inseritiNuoviGrafici = true;
                this.sincro.setAggiornaCursore(true);
                this.sincro.setAggiornaCursore2(true);
                this.setAbilitaForzaAssi(true);
                this.forzaRefreshAssiY(this.getAltezza() + 2, true);
            }
            if (this.graficoInVista) {
                this.refreshAll();
            }
        }
    }

    public double mostraMaxMinAvg(DanasDataStructureConstants.ValueType vt, boolean mostra, int tipo) {
        String nome;
        double posizione = -1.0;
        int row = MeasuresUtil.getPositionType(vt);
        if (this.sessioni) {
            if (DanasDataStructure.getInstance().getDefaultSession() == null) {
                return -1.0;
            }
            nome = String.valueOf(DanasDataStructure.getInstance().getDefaultSession().getSessionID());
        } else {
            if (DanasDataStructure.getInstance().getDefaultLap() == null) {
                return -1.0;
            }
            DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
            nome = String.valueOf(l.getSession().getSessionID()) + "-" + String.valueOf(l.getLapID());
        }
        Curva c = this.getGraficoCampo(row).getCurva(row, nome);
        if (c == null) {
            return -1.0;
        }
        if (tipo == 0) {
            c.mostraAvg(mostra);
        }
        if (tipo == 1) {
            c.mostraMassimi(mostra);
            posizione = c.getPrimoMassimo();
        }
        if (tipo == 2) {
            c.mostraMinimi(mostra);
            posizione = c.getPrimoMinimo();
        }
        return posizione;
    }

    public void setAsseX(double min, double max) {
        this.sincro.setMin(min);
        this.sincro.setMax(max);
        this.sincro.setAggiornaAsse(true);
    }

    public String getMinimoAsseX() {
        if (this.modoSpazio) {
            return String.format("%.2f", this.sincro.getMin());
        }
        return Grafico2D.stampaSpazioTempo(this.sincro.getMin(), 0);
    }

    public String getMassimoAsseX() {
        if (this.modoSpazio) {
            return String.format("%.2f", this.sincro.getMax());
        }
        return Grafico2D.stampaSpazioTempo(this.sincro.getMax(), 0);
    }

    public Color getColoreSfondo() {
        return this.coloreGrafico.getBackground();
    }

    public void setColoreSfondo(Color color) {
        if (color != null) {
            for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
                ((Grafico2D)this.elencoGrafici.elementAt(i)).setBackgroundColor(color, true);
            }
            this.coloreGrafico.setBackground(color);
        }
    }

    public void abilitaListenerTabella(boolean abilita) {
        if (abilita) {
            this.table.getModel().addTableModelListener(this);
        } else {
            this.table.getModel().removeTableModelListener(this);
        }
    }

    public void setAutoScale(boolean autos) {
        this.auto.setSelected(autos);
        this.bloccaY.setSelected(!autos);
        for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
            ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaY(!autos);
        }
    }

    public void setGrigliaV(boolean attiva) {
        this.attivaGrigliaV(attiva);
        this.refreshAll();
    }

    public void setGrigliaH(boolean attiva) {
        this.attivaGrigliaH(attiva);
        this.refreshAll();
    }

    public boolean autoIsSelected() {
        return this.auto.isSelected();
    }

    public boolean grigliaVIsSelected() {
        return this.grigliaV.isSelected();
    }

    public boolean grigliaHIsSelected() {
        return this.grigliaH.isSelected();
    }

    public void aggiornaBooleanTabella(int row, int col, boolean valore) {
        this.table.setValueAt(valore, row, col);
    }

    public void aggiornaColoreTabella(int row, int col, Color valore) {
        this.table.setValueAt(valore, row, col);
    }

    public void aggiornaIconaTabella(int row, int col, boolean valore) {
        if (valore) {
            this.table.setValueAt(this.iconaUp, row, col);
        } else {
            this.table.setValueAt(this.iconaDn, row, col);
        }
    }

    public void aggiornaSpessoreTabella(int row, int col, int valore) {
        if (valore == 0) {
            this.table.setValueAt(this.iconaSottile, row, col);
        }
        if (valore == 1) {
            this.table.setValueAt(this.iconaMedia, row, col);
        }
        if (valore == 2) {
            this.table.setValueAt(this.iconaGrossa, row, col);
        }
        this.refreshAll();
    }

    public void aggiornaStileTabella(int row, int col, int valore) {
        if (valore == 0) {
            this.table.setValueAt(this.iconaMedia, row, col);
        }
        if (valore == 1) {
            this.table.setValueAt(this.iconaPuntini, row, col);
        }
        if (valore == 2) {
            this.table.setValueAt(this.iconaTratteggio, row, col);
        }
        if (valore == 3) {
            this.table.setValueAt(this.iconaPuntoLinea, row, col);
        }
        this.refreshAll();
    }

    public void aggiornaTipoRefTabella(int row, int col, String valore) {
        this.table.setValueAt(valore, row, col);
        this.refreshAll();
    }

    public void aggiornaDoubleTabella(int row, int col, double valore) {
        this.table.setValueAt(valore, row, col);
        this.refreshAll();
    }

    public void attivaGrigliaH(boolean attiva) {
        this.grigliaH.setSelected(attiva);
        if (this.grigliaH.isSelected()) {
            for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
                ((Grafico2D)this.elencoGrafici.elementAt(i)).setGrigliaOrizzontale(true);
            }
        } else {
            for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
                ((Grafico2D)this.elencoGrafici.elementAt(i)).setGrigliaOrizzontale(false);
            }
        }
        if (DanasDataStructure.getInstance().getMainFrame().getChannelsDialog() != null) {
            DanasDataStructure.getInstance().getMainFrame().getChannelsDialog().setGrigliaH(this.grigliaH.isSelected());
        }
    }

    public void attivaGrigliaV(boolean attiva) {
        this.grigliaV.setSelected(attiva);
        if (this.grigliaV.isSelected()) {
            for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
                ((Grafico2D)this.elencoGrafici.elementAt(i)).setGriliaVerticale(true);
            }
        } else {
            for (int i = 0; i < this.NUM_CURVE + 2; ++i) {
                ((Grafico2D)this.elencoGrafici.elementAt(i)).setGriliaVerticale(false);
            }
        }
        if (DanasDataStructure.getInstance().getMainFrame().getChannelsDialog() != null) {
            DanasDataStructure.getInstance().getMainFrame().getChannelsDialog().setGrigliaV(this.grigliaV.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int i;
        Color color;
        int i2;
        if (arg0.getSource().equals(this.popupMenu1)) {
            this.azzeraCanale(0);
        }
        if (arg0.getSource().equals(this.popupMenu2)) {
            this.azzeraCanale(1);
        }
        if (arg0.getSource().equals(this.popupMenu3)) {
            this.azzeraCanale(2);
        }
        if (arg0.getSource().equals(this.popupMenu4)) {
            this.azzeraCanale(3);
        }
        if (arg0.getSource().equals(this.popupMenu5)) {
            this.azzeraCanale(4);
        }
        if (arg0.getSource().equals(this.popupMenu6)) {
            this.azzeraCanale(5);
        }
        if (arg0.getSource().equals(this.popupMenu7)) {
            this.azzeraCanale(6);
        }
        if (arg0.getSource().equals(this.popupMenu8)) {
            this.azzeraCanale(7);
        }
        if (arg0.getSource().equals(this.popupMenu9)) {
            this.azzeraCanale(8);
        }
        if (arg0.getSource().equals(this.popupMenu10)) {
            this.azzeraCanale(9);
        }
        if (arg0.getSource().equals(this.opzionipopup)) {
            DanasDataStructure.getInstance().getMainFrame().mostraChannelsDialog();
        }
        if (arg0.getSource().equals(this.filtriPopup)) {
            DanasDataStructure.getInstance().getMainFrame().showFiltriDialog();
        }
        if (arg0.getSource().equals(this.fittapopup)) {
            this.fitta();
        }
        if (arg0.getSource().equals(this.fittaVpopup)) {
            this.fittaVerticale(true);
        }
        if (arg0.getSource().equals(this.istoPop)) {
            DanasDataStructure.getInstance().getMainFrame().mostraIstogrammaSelezione(this.sincro.getPosizioneCursore(), this.sincro.getPosizioneCursore2(), true);
        }
        if (arg0.getSource().equals(this.fftPop)) {
            DanasDataStructure.getInstance().getMainFrame().mostraFftSelezione(this.sincro.getPosizioneCursore(), this.sincro.getPosizioneCursore2(), true);
        }
        if (arg0.getSource().equals(this.zoomSelezionePop)) {
            this.sincro.setMin(this.sincro.getPosizioneCursore());
            this.sincro.setMax(this.sincro.getPosizioneCursore2());
            this.sincro.setAggiornaAsse(true);
        }
        if (arg0.getSource().equals(this.fittaHpopup)) {
            this.fittaOrizzontale(true);
        }
        if (arg0.getSource().equals(this.zoomInRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(2);
            MainFrame mainFrame2 = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame2.selezionaTastoMappa(6);
        }
        if (arg0.getSource().equals(this.zoomOutRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(3);
            DanasDataStructure.getInstance().getMainFrame().selezionaTastoMappa(DanasDataStructure.getInstance().getMainFrame().ZOOM_OUT_MAPPA);
        }
        if (arg0.getSource().equals(this.zoomWindowRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(4);
            DanasDataStructure.getInstance().getMainFrame().selezionaTastoMappa(DanasDataStructure.getInstance().getMainFrame().ZOOM_FINESTRA_MAPPA);
        }
        if (arg0.getSource().equals(this.muoviRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(5);
            MainFrame mainFrame3 = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame3.selezionaTastoMappa(5);
        }
        if (arg0.getSource().equals(this.cursoreRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(1);
            MainFrame mainFrame4 = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame4.selezionaTastoMappa(1);
        }
        if (arg0.getSource().equals(this.traslaRadio)) {
            MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
            Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
            mainFrame.selezionaTastoGrafico(6);
        }
        if (arg0.getSource().equals(this.grigliaYpopup)) {
            this.attivaGrigliaV(this.grigliaYpopup.isSelected());
            this.refreshAll();
        }
        if (arg0.getSource().equals(this.grigliaXpopup)) {
            this.attivaGrigliaH(this.grigliaXpopup.isSelected());
            this.refreshAll();
        }
        if (arg0.getSource().equals(this.bloccaYpopup)) {
            this.bloccaY.setSelected(this.bloccaYpopup.isSelected());
            if (this.bloccaY.isSelected()) {
                this.bloccaX.setEnabled(false);
                for (i2 = 0; i2 < this.NUM_CURVE + 2; ++i2) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i2)).setBloccaY(true);
                }
            } else {
                for (i2 = 0; i2 < this.NUM_CURVE + 2; ++i2) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i2)).setBloccaY(false);
                }
                this.bloccaX.setEnabled(true);
            }
        }
        if (arg0.getSource().equals(this.bloccaXpopup)) {
            this.bloccaX.setSelected(this.bloccaXpopup.isSelected());
            if (this.bloccaX.isSelected()) {
                this.bloccaY.setEnabled(false);
                for (i2 = 0; i2 < this.NUM_CURVE + 2; ++i2) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i2)).setBloccaX(true);
                }
            } else {
                for (i2 = 0; i2 < this.NUM_CURVE + 2; ++i2) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i2)).setBloccaX(false);
                }
                this.bloccaY.setEnabled(true);
            }
        }
        if (arg0.getSource().equals(this.autoscalingpopup)) {
            this.auto.setSelected(this.autoscalingpopup.isSelected());
            this.autofit = this.auto.isSelected();
            if (DanasDataStructure.getInstance().getMainFrame().getChannelsDialog() != null) {
                DanasDataStructure.getInstance().getMainFrame().getChannelsDialog().setAutoscale(this.auto.isSelected());
            }
        }
        if (arg0.getSource().equals(this.coloriPopup)) {
            this.stileColoriGrafico.setSelected(this.coloriPopup.isSelected());
            this.aggiornaCanaliInfoNew();
            this.aggiornaInfoNew();
            this.aggiornaCanaliStat();
            this.aggiornaStat();
            this.aggiornaCurve();
        }
        if (arg0.getSource().equals(this.coloreSfondoB) && (color = JColorChooser.showDialog(this, Language.string("Colore sfondo del grafico"), this.coloreGrafico.getBackground())) != null) {
            for (int i3 = 0; i3 < this.NUM_CURVE + 2; ++i3) {
                ((Grafico2D)this.elencoGrafici.elementAt(i3)).setBackgroundColor(color, true);
            }
            this.coloreGrafico.setBackground(color);
            if (DanasDataStructure.getInstance().getMainFrame().getChannelsDialog() != null) {
                DanasDataStructure.getInstance().getMainFrame().getChannelsDialog().setColoreSfondo(color);
            }
        }
        if (arg0.getSource().equals(this.stileColoriGrafico)) {
            this.aggiornaCurve();
            this.aggiornaCanaliStat();
            this.aggiornaStat();
        }
        for (i = 0; i < this.NUM_CURVE; ++i) {
            if (!arg0.getSource().equals(this.menuItemCanali[i])) continue;
            ((MyTableModel)this.table.getModel()).setValueAt(this.menuItemCanali[i].isSelected(), i, 2);
            ((MyTableModel)this.table.getModel()).setValueAt(this.menuItemCanali[i].isSelected(), i, 3);
        }
        for (i = 0; i < this.giriTralazione.size(); ++i) {
            if (arg0.getSource().equals(this.giriTralazione.get(i))) {
                String[] ID = this.giriTralazione.get(i).getText().split("-");
                if (ID.length < 3) continue;
                DanasSession sess = DanasDataStructure.getInstance().getSession(Integer.valueOf(ID[1]));
                DanasLap lap = sess.getLap(Integer.valueOf(ID[2]));
                if (this.giriTralazione.get(i).isSelected()) {
                    lap.setTraslabile(true);
                } else {
                    lap.setTraslabile(false);
                }
                TableWindow.refreshAll();
                MainFrame mainFrame = DanasDataStructure.getInstance().getMainFrame();
                Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
                mainFrame.selezionaTastoGrafico(5);
                MainFrame mainFrame5 = DanasDataStructure.getInstance().getMainFrame();
                Objects.requireNonNull(DanasDataStructure.getInstance().getMainFrame());
                mainFrame5.selezionaTastoMappa(5);
            }
            DanasDataStructure.getInstance().getMainFrame().richiediFuoco();
            this.setVisible(true);
            this.requestFocusInWindow();
        }
        if (arg0.getSource().equals(this.grigliaH)) {
            this.attivaGrigliaH(this.grigliaH.isSelected());
        }
        if (arg0.getSource().equals(this.grigliaV)) {
            this.attivaGrigliaV(this.grigliaV.isSelected());
        }
        if (arg0.getSource().equals(this.decima)) {
            // empty if block
        }
        if (arg0.getSource().equals(this.sbloccaPopup)) {
            DanasDataStructure.getInstance().getMainFrame().setBloccaCurve(this.sbloccaPopup.isSelected());
        }
        if (arg0.getSource().equals(this.opzioniFftPop)) {
            DanasDataStructure.getInstance().getMainFrame().visualizzaOpzioniFFT();
        }
        if (arg0.getSource().equals(this.giriRadio)) {
            DanasDataStructure.getInstance().getMainFrame().setGraficoSessioni(false);
        }
        if (arg0.getSource().equals(this.sessioniRadio)) {
            DanasDataStructure.getInstance().getMainFrame().setGraficoSessioni(true);
        }
        if (arg0.getSource().equals(this.bloccaX)) {
            if (this.bloccaX.isSelected()) {
                this.bloccaY.setEnabled(false);
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaX(true);
                }
            } else {
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaX(false);
                }
                this.bloccaY.setEnabled(true);
            }
        }
        if (arg0.getSource().equals(this.bloccaY)) {
            if (this.bloccaY.isSelected()) {
                this.bloccaX.setEnabled(false);
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaY(true);
                }
            } else {
                for (i = 0; i < this.NUM_CURVE + 2; ++i) {
                    ((Grafico2D)this.elencoGrafici.elementAt(i)).setBloccaY(false);
                }
                this.bloccaX.setEnabled(true);
            }
        }
        if (arg0.getSource().equals(this.auto)) {
            this.autofit = this.auto.isSelected();
            if (DanasDataStructure.getInstance().getMainFrame().getChannelsDialog() != null) {
                DanasDataStructure.getInstance().getMainFrame().getChannelsDialog().setAutoscale(this.auto.isSelected());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.requestFocus();
        if (arg0.getSource().equals(this)) {
            DanasDataStructure.getInstance().getMainFrame().setTabGrafico(this.getSelectedIndex());
            if (this.getSelectedIndex() == 1) {
                DanasDataStructure.getInstance().getMainFrame().setTastoOpzioniGrafico(true);
                DanasDataStructure.getInstance().getMainFrame().chiudiFinestre();
                DanasDataStructure.getInstance().getMainFrame().abilitaNascondi(false);
                this.setComponentAt(0, null);
                this.requestFocus();
                this.aggiornaValoriMinMax();
            }
            if (this.getSelectedIndex() == 0) {
                DanasDataStructure.getInstance().getMainFrame().setTastoOpzioniGrafico(false);
                DanasDataStructure.getInstance().getMainFrame().riapriFinestre();
                DanasDataStructure.getInstance().getMainFrame().abilitaNascondi(true);
                if (DanasDataStructure.getInstance().getRicalcolaTutto()) {
                    DanasDataStructure.getInstance();
                    DanasDataStructure.setRicalcolaTutto(false);
                    this.ricalcolaTutto(this.modoSpazio, this.numeroGrafici);
                }
                this.setComponentAt(0, this.getGrafico());
                this.refreshAll();
                this.aggiornaCanaliInfo();
                this.aggiornaCanaliInfoNew();
                this.aggiornaCanaliStat();
                this.aggiornaStat();
                if (this.modoSpazio) {
                    this.sincro.setMin(Double.valueOf(this.minimoAsseX.getText()));
                    this.sincro.setMax(Double.valueOf(this.massimoAsseX.getText()));
                } else {
                    this.sincro.setMin(ContenitoreGrafico.parseHumanTime(this.minimoAsseX.getText()) / 10.0);
                    this.sincro.setMax(ContenitoreGrafico.parseHumanTime(this.massimoAsseX.getText()) / 10.0);
                }
                if (this.inseritiNuoviGrafici) {
                    this.sincro.setLarghezza(this.getWidth());
                    this.sincro.setAggiornaFuturoAsse(true);
                } else {
                    this.sincro.setAggiornaAsse(true);
                }
            }
        }
        if (arg0.getSource().equals(this.sincro)) {
            int giro;
            DanasSession sess;
            int i;
            if (this.sincro.getTipoEvento() == 0) {
                if (this.modoSpazio) {
                    this.minimoAsseX.setText(String.format("%.2f", this.sincro.getMin()));
                    this.massimoAsseX.setText(String.format("%.2f", this.sincro.getMax()));
                } else {
                    this.minimoAsseX.setText(Grafico2D.stampaSpazioTempo(this.sincro.getMin(), 0));
                    this.massimoAsseX.setText(Grafico2D.stampaSpazioTempo(this.sincro.getMax(), 0));
                }
            }
            if (this.sincro.getTipoEvento() == 5) {
                this.aggiornaInfo();
            }
            if (this.sincro.getTipoEvento() == 1) {
                if (this.multiSincro == null) {
                    return;
                }
                if (!this.modoSpazio) {
                    if (this.multiSincro.getAggionrnaMappaGrafico()) {
                        this.multiSincro.setPosizioneCursore(this.sincro.getPosizioneCursore());
                    }
                } else if (this.multiSincro.getAggionrnaMappaGrafico()) {
                    this.multiSincro.setPosizioneCursore(this.convertiSpazioInTempo(this.sincro.getPosizioneCursore()));
                }
                this.posizioneCursore = this.multiSincro.getPosizioneCursoreDecimale();
                this.multiSincro.setAggiornaPosizioneCursore(true);
            }
            if (this.sincro.getTipoEvento() == 3 && !this.modoSpazio && !this.sessioni && DanasDataStructure.getInstance().getModTraslazione()) {
                for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                    sess = DanasDataStructure.getInstance().getSession(i);
                    if (!sess.isSelected()) continue;
                    for (giro = 1; giro <= sess.getNumberOfLaps(); ++giro) {
                        if (!sess.getLap(giro).getSelected() || !sess.getLap(giro).getTraslabile()) continue;
                        sess.getLap(giro).setOffsetTempo(this.sincro.getOffesetAttuale());
                    }
                }
                this.aggiornaCurve();
            }
            if (this.sincro.getTipoEvento() == 4 && !this.modoSpazio && !this.sessioni && DanasDataStructure.getInstance().getModTraslazione()) {
                for (i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
                    sess = DanasDataStructure.getInstance().getSession(i);
                    if (!sess.isSelected()) continue;
                    for (giro = 1; giro <= sess.getNumberOfLaps(); ++giro) {
                        if (!sess.getLap(giro).getSelected() || !sess.getLap(giro).getTraslabile()) continue;
                        sess.getLap(giro).setOffsetTempo(sess.getLap(giro).getOffsetTempo() + this.sincro.getOffesetAttualeRapido());
                    }
                }
                this.aggiornaCurve();
            }
        }
        if (arg0.getSource().equals(DanasDataStructure.getInstance())) {
            System.out.println("Log:Contenitore grafico: change listener=" + (Object)((Object)this.dati.getChange()));
            if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_REF_LAP && this.dati.getDefaultLap() != null || this.dati.getChange() == DanasDataStructureConstants.ChangeType.ADD_SPLIT || this.dati.getChange() == DanasDataStructureConstants.ChangeType.REMOVE_SPLIT || this.dati.getChange() == DanasDataStructureConstants.ChangeType.REFRESH_ALL || this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_GOAL || this.dati.getChange() == DanasDataStructureConstants.ChangeType.NEW_DATA) {
                if (this.dati.getChange() != DanasDataStructureConstants.ChangeType.NEW_DATA) {
                    DanasDataStructure.getInstance().calcolaSpaziPercorsiLap();
                }
                this.aggiornaLineeIntertempo();
                this.aggiornaStat();
            }
            if (this.sessioni) {
                if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SEL_SESSION) {
                    this.aggiungiCurva(this.dati.getChangeParameter());
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                } else if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.DESEL_SESSION) {
                    this.rimuoviCurva(this.dati.getChangeParameter());
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                } else if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.REMOVE_DATA) {
                    this.rimuoviTutto();
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                } else if (this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.DESEL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_ALL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.DESEL_ALL_LAP && this.dati.getChange() != DanasDataStructureConstants.ChangeType.REMOVE_DATA && this.dati.getChange() != DanasDataStructureConstants.ChangeType.NOTES && this.dati.getChange() != DanasDataStructureConstants.ChangeType.LAP_COLOR) {
                    if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_REF_LAP && this.dati.getDefaultLap() == null) {
                        return;
                    }
                    DanasDataStructure.getInstance().setNomiMulti();
                    this.aggiornaNomiCanali();
                    this.aggiornaCurvaDefault();
                    this.aggiornaCurve();
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                }
                if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_REF_SESSION && this.dati.getDefaultSession() != null) {
                    this.aggiornaStat();
                }
            } else {
                if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SEL_LAP) {
                    this.aggiungiCurva(this.dati.getChangeParameter());
                    if (!this.sessioni && DanasDataStructure.getInstance().getNumberSelectedLaps() > 1 && !this.stileColoriGrafico.isSelected() && DanasPreferences.getPrefConfronto()) {
                        this.stileColoriGrafico.setSelected(true);
                        this.aggiornaCurve();
                    }
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                } else if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.DESEL_LAP) {
                    this.rimuoviCurva(this.dati.getChangeParameter());
                    if (!this.sessioni && DanasDataStructure.getInstance().getNumberSelectedLaps() < 2 && this.stileColoriGrafico.isSelected() && DanasPreferences.getPrefConfronto()) {
                        this.stileColoriGrafico.setSelected(false);
                        this.aggiornaCurve();
                    }
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                } else if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.REMOVE_DATA) {
                    this.rimuoviTutto();
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                } else if (this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_SESSION && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SEL_ALL_SESSION && this.dati.getChange() != DanasDataStructureConstants.ChangeType.NOTES && this.dati.getChange() != DanasDataStructureConstants.ChangeType.REMOVE_DATA && this.dati.getChange() != DanasDataStructureConstants.ChangeType.SESSION_COLOR) {
                    if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_REF_LAP && this.dati.getDefaultLap() == null) {
                        return;
                    }
                    if (this.dati.getDefaultLap() != null) {
                        this.multiSincro.setOffsetVideo(this.dati.getDefaultLap().getStart() - this.dati.getDefaultLap().getSession().getStartTelemetryTime());
                    }
                    DanasDataStructure.getInstance().setNomiMulti();
                    this.aggiornaNomiCanali();
                    this.aggiornaCurvaDefault();
                    this.aggiornaCurve();
                    this.aggiornaCanaliInfo();
                    this.aggiornaCanaliInfoNew();
                }
                if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.SET_REF_SESSION && this.dati.getDefaultSession() != null) {
                    System.out.println("DEBUG: aggiorno stat e info");
                    this.aggiornaStat();
                }
            }
            if (this.dati.getChange() == DanasDataStructureConstants.ChangeType.DESEL_SESSION) {
                // empty if block
            }
        }
        if (arg0.getSource().equals(this.multiSincro)) {
            if (DanasDataStructure.getInstance().getMainFrame().getFftMode()) {
                return;
            }
            this.aggiornaInfo();
            this.aggiornaInfoNew();
            if (this.posizioneCursore == this.multiSincro.getPosizioneCursoreDecimale() || this.getMode() != 7) {
                return;
            }
            if (!this.modoSpazio) {
                this.sincro.setPosizioneCursore(this.multiSincro.getPosizioneCursoreDecimale());
            } else {
                this.sincro.setPosizioneCursore(this.convertiTempoInSpazio(this.multiSincro.getPosizioneCursoreDecimale()));
            }
            this.sincro.setAggiornaCursore(true);
        }
    }

    public TableRowChannels getRowChannels(int indice) {
        int indiceFiltro = DanasPreferences.getLunghezzaFiltro(MeasuresUtil.getValueType(indice));
        int dec = DanasPreferences.getDecimali(MeasuresUtil.getValueType(indice), DanasDataStructure.getInstance().getMainFrame().getModoAttuale());
        double alarmHi = DanasPreferences.getAlarmHi(MeasuresUtil.getValueType(indice), DanasDataStructure.getInstance().getMainFrame().getModoAttuale());
        double alarmLow = DanasPreferences.getAlarmLow(MeasuresUtil.getValueType(indice), DanasDataStructure.getInstance().getMainFrame().getModoAttuale());
        return new TableRowChannels((ImageIcon)this.table.getValueAt(indice, 0), (Boolean)this.table.getValueAt(indice, 1), (Boolean)this.table.getValueAt(indice, 2), (Boolean)this.table.getValueAt(indice, 3), (String)this.table.getValueAt(indice, 4), (String)this.table.getValueAt(indice, 5), (Color)this.table.getValueAt(indice, 6), (ImageIcon)this.table.getValueAt(indice, 7), (ImageIcon)this.table.getValueAt(indice, 8), (Double)this.table.getValueAt(indice, 9), (Double)this.table.getValueAt(indice, 10), (Double)this.table.getValueAt(indice, 11), (Double)this.table.getValueAt(indice, 12), (String)this.table.getValueAt(indice, 13), (Double)this.table.getValueAt(indice, 14), MeasuresUtil.getFiltroDaIndice(indiceFiltro), indice, dec, alarmHi, alarmLow);
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        if (!this.aggiornamentoTabella) {
            return;
        }
        int col = arg0.getColumn();
        int row = arg0.getFirstRow();
        MyTableModel model = (MyTableModel)arg0.getSource();
        switch (col) {
            case 0: {
                if (this.numeroGrafici != 2) {
                    return;
                }
                DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(false);
                Object data = model.getValueAtBase(row, 2);
                Object data2 = model.getValueAtBase(row, 1);
                if (!((Boolean)data).booleanValue()) {
                    DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(true);
                    break;
                }
                if (this.numeroGrafici == 2) {
                    int j;
                    DefaultListModel<GObject> lista = new DefaultListModel<GObject>();
                    Grafico2D gSopra = (Grafico2D)this.elencoGrafici.elementAt(1);
                    Grafico2D gSotto = (Grafico2D)this.elencoGrafici.elementAt(0);
                    GScene s1 = gSopra.getScene(row);
                    lista.clear();
                    int numeroCurve = s1.getNChildren();
                    for (j = 0; j < numeroCurve; ++j) {
                        lista.addElement(s1.getChild(j));
                    }
                    s1.removeAll();
                    gSopra.setScenaVisibile(row, false);
                    gSopra.mostraAsse(row, false);
                    GScene s2 = gSotto.getScene(row);
                    numeroCurve = s2.getNChildren();
                    for (j = 0; j < numeroCurve; ++j) {
                        lista.addElement(s2.getChild(j));
                    }
                    s2.removeAll();
                    gSotto.setScenaVisibile(row, false);
                    gSotto.mostraAsse(row, false);
                    this.getGraficoCampo(row).setScenaVisibile(row, true);
                    if (((Boolean)data2).booleanValue()) {
                        this.getGraficoCampo(row).mostraAsse(row, true);
                    } else {
                        this.getGraficoCampo(row).mostraAsse(row, false);
                    }
                    int numeroTotaleCurve = lista.size();
                    for (int j2 = 0; j2 < numeroTotaleCurve; ++j2) {
                        this.getGraficoCampo(row).getScene(row).add((GObject)lista.getElementAt(j2));
                    }
                    this.setMargineLeft();
                    this.getGraficoCampo(row).setAsseY(this.getRealMin(row), this.getRealMax(row), row, true);
                }
                if (this.getSelectedIndex() == 0) {
                    this.ricalcolaTutto(this.modoSpazio, this.numeroGrafici);
                }
                DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(true);
                break;
            }
            case 1: {
                DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(false);
                Object data = model.getValueAtBase(row, col);
                if (((Boolean)data).booleanValue()) {
                    this.getGraficoCampo(row).mostraAsse(row, true);
                } else {
                    this.getGraficoCampo(row).mostraAsse(row, false);
                }
                if (this.numeroGrafici != 1) {
                    this.setMargineLeft();
                }
                DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(true);
                break;
            }
            case 2: {
                this.table.setEnabled(false);
                DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(false);
                this.graficoInVista = false;
                if (this.getSelectedIndex() == 0) {
                    this.graficoInVista = true;
                }
                this.frameAttesa.setVisible(true);
                this.rowT = row;
                this.model1 = model;
                Object data = model.getValueAtBase(row, 2);
                if (!((Boolean)data).booleanValue()) {
                    this.elencoCanaliEvidenziati[row] = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        long tempoApertura = System.currentTimeMillis();
                        ContenitoreGrafico.this.aggiornamentoDaTabella();
                        ContenitoreGrafico.this.aggiornaCanaliInfoNew();
                        ContenitoreGrafico.this.aggiornaCanaliInfo();
                        ContenitoreGrafico.this.aggiornaCanaliStat();
                        ContenitoreGrafico.this.aggiornaStat();
                        DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(true);
                        ContenitoreGrafico.this.table.setEnabled(true);
                        ContenitoreGrafico.this.frameAttesa.setVisible(false);
                    }
                });
                break;
            }
            case 3: {
                this.frameAttesa.setVisible(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContenitoreGrafico.this.table.setEnabled(false);
                        DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(false);
                        ContenitoreGrafico.this.aggiornaCanaliInfoNew();
                        ContenitoreGrafico.this.aggiornaCanaliInfo();
                        ContenitoreGrafico.this.aggiornaCanaliStat();
                        ContenitoreGrafico.this.aggiornaStat();
                        ContenitoreGrafico.this.frameAttesa.setVisible(false);
                        ContenitoreGrafico.this.table.setEnabled(true);
                        DanasDataStructure.getInstance().getMainFrame().setChannelDialogEditable(true);
                    }
                });
                break;
            }
            case 6: {
                model = (MyTableModel)arg0.getSource();
                Object data = model.getValueAtBase(row, col);
                this.getGraficoCampo(row).setColore(row, (Color)data);
                if (this.getSelectedIndex() != 0) break;
                this.aggiornaCanaliInfoNew();
                this.aggiornaCanaliInfo();
                this.aggiornaCanaliStat();
                this.aggiornaStat();
                break;
            }
            case 7: {
                this.getGraficoCampo(row).setSpessore(row, this.getValoreSpessore(row));
                break;
            }
            case 8: {
                this.getGraficoCampo(row).setStile(row, this.getValoreStile(row));
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (this.letturaDatiAssi) break;
                this.getGraficoCampo(row).setAsseY(this.getRealMin(row), this.getRealMax(row), row, true);
                break;
            }
            case 13: 
            case 14: {
                this.getGraficoCampo(row).setRef(row, this.getModoRef(row), (Double)((MyTableModel)this.table.getModel()).getValueAtBase(row, 14));
            }
        }
    }
}

