/*
 * Decompiled with CFR 0.152.
 */
package i2m.export;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.export.DanasExportDialog;
import i2m.export.DanasExportModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Export2D
implements DanasExportModule {
    private static JPanel panel;
    private DanasExportDialog parent;
    private int percentualeAttuale = 0;
    private int numeroPunti = 1;

    @Override
    public int export(DanasExportDialog parent, int data_mode, boolean only_selected_stuff) {
        this.parent = parent;
        if (DanasDataStructure.getInstance().getNSessions() == 0) {
            JOptionPane.showMessageDialog(parent.getDialog(), Language.string("No sessions loaded!"), Language.string("ATTENZIONE"), 0);
            return -1;
        }
        this.percentualeAttuale = 0;
        File f = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        String s = DanasPreferences.getPrefDirectory("saveEsporta");
        if (s != null) {
            fileChooser.setCurrentDirectory(new File(s));
        }
        int res = fileChooser.showSaveDialog(parent.getDialog());
        DanasPreferences.setPrefDirectory("saveEsporta", fileChooser.getCurrentDirectory().toString());
        if (res == 0) {
            String path = fileChooser.getSelectedFile().toString() + "/";
            parent.initProgress(100);
            this.numeroPunti = this.calcolaNumeroPunti();
            for (int en = 1; en <= DanasDataStructure.getInstance().getNSessions(); ++en) {
                DanasSession session = DanasDataStructure.getInstance().getSession(en);
                if (!session.isSelected()) continue;
                String nome = session.getFilename();
                if (nome.endsWith(".dat") || nome.endsWith(".txt")) {
                    nome = nome.substring(0, nome.length() - 4);
                }
                f = new File(path + nome + "-" + session.getSessionID() + ".MES");
                f.mkdirs();
                this.creaDdd(path + nome + "-" + session.getSessionID(), nome + "-" + session.getSessionID(), session);
                this.creaFile2D(path + nome + "-" + session.getSessionID(), nome + "-" + session.getSessionID(), session);
            }
            parent.closeProgress();
            return 0;
        }
        return -1;
    }

    public int calcolaNumeroPunti() {
        int numeroPunti = 0;
        for (int en = 1; en <= DanasDataStructure.getInstance().getNSessions(); ++en) {
            DanasSession sess = DanasDataStructure.getInstance().getSession(en);
            for (int j = 0; j < DanasDataStructureConstants.ValueType.values().length; ++j) {
                DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[j];
                if (sess.getFrequenzaCanale(vt) == 0.0) continue;
                numeroPunti += sess.getDimensioneCanale(vt);
            }
        }
        return numeroPunti;
    }

    public void creaFile2D(String percorso, String nome, DanasSession s) {
        int puntiScritti = 0;
        double inizioRpm = s.getTempoIniziale(DanasDataStructureConstants.ValueType.RPM);
        double inizioGps = s.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS);
        boolean gpsAssente = false;
        if (s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) == 0.0) {
            gpsAssente = true;
        }
        int campioniGPSAssenti = 0;
        int campioniEliminare = 0;
        int ritardoGPS = (int)(inizioGps - inizioRpm);
        if (ritardoGPS < 0 || gpsAssente) {
            ritardoGPS = 0;
        }
        campioniEliminare = ritardoGPS % 8;
        campioniGPSAssenti = ritardoGPS / 8;
        System.out.println("Export:Campioni da eliminare=" + campioniEliminare + " campioni GPS assenti=" + campioniGPSAssenti);
        double velMax = 0.0;
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[i];
            double frequenza = s.getFrequenzaCanale(vt);
            if (frequenza == 0.0) continue;
            File f = new File(percorso + ".MES/" + nome + "." + Integer.toHexString(2561 + i).toUpperCase());
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                ArrayDouble valori = vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG ? s.getValueCoordinate(vt) : s.getAllValueData(vt, true);
                for (int j = 0; j < valori.size(); ++j) {
                    int percentuale;
                    ++puntiScritti;
                    if (frequenza >= 100.0 && campioniEliminare > 0) {
                        --campioniEliminare;
                        continue;
                    }
                    switch (vt) {
                        case VEL_GPS: {
                            Double vel = valori.get(j);
                            out.write(MeasuresUtil.float2Bytes(vel.floatValue()));
                            break;
                        }
                        case LAT: 
                        case LONG: {
                            Double valore = valori.get(j) / 600000.0;
                            out.write(MeasuresUtil.float2Bytes(valore.floatValue()));
                            break;
                        }
                        default: {
                            out.write(MeasuresUtil.float2Bytes((float)valori.get(j)));
                        }
                    }
                    if (vt == DanasDataStructureConstants.ValueType.SPEED1 && valori.get(j) > velMax) {
                        velMax = valori.get(j);
                    }
                    if ((vt == DanasDataStructureConstants.ValueType.VEL_GPS || vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG || vt == DanasDataStructureConstants.ValueType.ALTITUDE || vt == DanasDataStructureConstants.ValueType.ACC_LAT || vt == DanasDataStructureConstants.ValueType.ANGLE_GPS || vt == DanasDataStructureConstants.ValueType.DELAY || vt == DanasDataStructureConstants.ValueType.dVEL_GPS || vt == DanasDataStructureConstants.ValueType.DDS) && campioniGPSAssenti > 0) {
                        --campioniGPSAssenti;
                        --j;
                    }
                    if ((percentuale = (int)((float)puntiScritti / (float)this.numeroPunti * 100.0f)) != this.percentualeAttuale) {
                        this.parent.setProgress(percentuale);
                    }
                    this.percentualeAttuale = percentuale;
                }
                out.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void creaDdd(String percorso, String nome, DanasSession s) {
        File f_ddd = new File(percorso + ".MES/" + nome + ".DDD");
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f_ddd)));
            for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
                DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[i];
                if ((int)s.getFrequenzaCanale(vt) == 0) continue;
                out.println("[" + Integer.toHexString(768 + i).toUpperCase() + "]\r");
                if (vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG) {
                    out.println("1=2,6,80,0,20,20,190,0,0,0,\r");
                } else {
                    switch ((int)s.getFrequenzaCanale(vt)) {
                        case 400: {
                            out.println("1=2,6,80,0,1,20,190,0,0,0,\r");
                            break;
                        }
                        case 100: {
                            out.println("1=2,6,80,0,4,20,190,0,0,0,\r");
                            break;
                        }
                        case 50: {
                            out.println("1=2,6,80,0,8,20,190,0,0,0,\r");
                            break;
                        }
                        case 20: {
                            out.println("1=2,6,80,0,14,20,190,0,0,0,\r");
                            break;
                        }
                        case 10: {
                            out.println("1=2,6,80,0,28,20,190,0,0,0,\r");
                            break;
                        }
                        case 5: {
                            out.println("1=2,6,80,0,50,20,190,0,0,0,\r");
                            break;
                        }
                        case 1: {
                            out.println("1=2,6,80,0,190,20,190,0,0,0,\r");
                            break;
                        }
                        case 0: {
                            out.println("1=2,6,80,0,28,20,190,0,0,0,\r");
                        }
                    }
                }
                if (vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG) {
                    out.println("2=0,0,0,0,0,0,0,\r");
                } else {
                    out.println("2=0,0,0,80000001,7FFFFFFF,0,0,\r");
                }
                out.println("3=1,1,0,3F800000,0,0,3F800000,0,0,\r");
                if (vt == DanasDataStructureConstants.ValueType.VEL_GPS || vt == DanasDataStructureConstants.ValueType.SPEED1 || vt == DanasDataStructureConstants.ValueType.SPEED2) {
                    out.println("4=" + DanasDataStructure.getInstance().getNomeTipo(vt) + ",km/h,,0,\"\",0,,\r");
                } else if (vt == DanasDataStructureConstants.ValueType.RPM) {
                    out.println("4=RPM,RPM,,0,\"\",0,,\r");
                } else if (vt == DanasDataStructureConstants.ValueType.LAT) {
                    out.println("4=LAT,,,0,\"\",0,,\r");
                } else if (vt == DanasDataStructureConstants.ValueType.LONG) {
                    out.println("4=LONG,,,0,\"\",0,,\r");
                } else {
                    out.println("4=" + DanasDataStructure.getInstance().getNomeTipo(vt) + ",,,0,\"\",0,,\r");
                }
                if (vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG) {
                    out.println("5=0,B7,0,0,0,0,\r");
                } else if (vt == DanasDataStructureConstants.ValueType.RPM) {
                    out.println("5=0,50,0,0,0,0,\r");
                } else {
                    out.println("5=0,51,0,0,0,0,\r");
                }
                out.println("6=4,U,2D," + Integer.toHexString(2561 + i).toUpperCase() + ",," + Integer.toHexString(i).toUpperCase() + ",\r");
                out.println("7=0,0,0,0,0,\r");
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAuthor() {
        return "I2M.it";
    }

    @Override
    public String getName() {
        return "2D Datalogger files";
    }

    @Override
    public String getDescription() {
        return Language.string("Write selected session in files to be parsed by 2D analysis software.The data acquisition frequency has to be set to 100Hz to use this function.");
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public JPanel getPanel() {
        if (panel == null) {
            panel = new JPanel(new GridBagLayout());
            panel.setBackground(Color.WHITE);
            JLabel label = new JLabel();
            label.setHorizontalAlignment(0);
            ImageIcon logo = new ImageIcon(this.getClass().getResource("/pix/2D_icon.gif"));
            label.setIcon(logo);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)label, gc);
        }
        return panel;
    }
}

