/*
 * Decompiled with CFR 0.152.
 */
package i2m.export;

import i2m.Language;
import i2m.export.CSVExport;
import i2m.export.CSVExport_Filled;
import i2m.export.DanasExportModule;
import i2m.export.Export2D;
import i2m.export.KMLExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.border.TitledBorder;

public class DanasExportDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int EXPORT_SESSIONS = 0;
    public static final int EXPORT_LAPS = 1;
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int CANCEL = -1;
    private static int LAST_SELECTED_INDEX = 0;
    private static final String EXPORT_MODULE_SELECTION = "export_module";
    private static final String EXPORT_ACTION = "export";
    private static final String CANCEL_ACTION = "cancel";
    private JComboBox<Object> modList;
    private JEditorPane modDescription;
    private JRadioButton sessionsRadio;
    private JRadioButton lapsRadio;
    private JCheckBox onlySelectedBox;
    private ProgressMonitor progress;
    private JPanel modulePanel;
    private Thread worker;
    private Vector<DanasExportModule> modules;

    public DanasExportDialog(Frame owner) {
        super(owner, "Export", true);
        this.setModal(true);
        this.setSize(600, 300);
        this.setDefaultCloseOperation(2);
        this.initialize();
    }

    public Component getDialog() {
        return this;
    }

    private Vector<DanasExportModule> getExportModules() {
        Vector<DanasExportModule> v = new Vector<DanasExportModule>();
        v.add(new KMLExport());
        v.add(new CSVExport());
        v.add(new Export2D());
        v.add(new CSVExport_Filled());
        return v;
    }

    private JPanel getFormatSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.modules = this.getExportModules();
        String[] modStrings = new String[this.modules.size()];
        for (int i = 0; i < this.modules.size(); ++i) {
            modStrings[i] = this.modules.get(i).getName();
        }
        this.modList = new JComboBox<String>(modStrings);
        if (LAST_SELECTED_INDEX >= 0 && LAST_SELECTED_INDEX < this.modules.size()) {
            this.modList.setSelectedIndex(LAST_SELECTED_INDEX);
        } else {
            this.modList.setSelectedIndex(0);
        }
        this.modList.setActionCommand(EXPORT_MODULE_SELECTION);
        this.modList.addActionListener(this);
        this.modList.setEditable(false);
        this.modDescription = new JEditorPane();
        this.modDescription.setEditable(false);
        this.modDescription.setMargin(new Insets(5, 5, 5, 5));
        this.modDescription.setContentType("text/html");
        if (this.modList.getSelectedItem() != null) {
            this.modDescription.setText(this.modules.get(this.modList.getSelectedIndex()).getDescription());
        }
        this.modDescription.setFont(this.modDescription.getFont().deriveFont(2));
        int y = 0;
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(2, 2, 2, 2);
        gc.gridx = 0;
        gc.gridy = y++;
        panel.add(this.modList, gc);
        gc.fill = 1;
        gc.gridy = y++;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JScrollPane(this.modDescription), gc);
        return panel;
    }

    private JPanel getDataSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.gridy = y++;
        this.onlySelectedBox = new JCheckBox(Language.string("Export only selected sessions or laps"));
        panel.add((Component)this.onlySelectedBox, gc);
        JPanel dsPanel = new JPanel();
        dsPanel.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        this.sessionsRadio = new JRadioButton(Language.string("Sessions"));
        this.sessionsRadio.setSelected(true);
        bg.add(this.sessionsRadio);
        this.lapsRadio = new JRadioButton(Language.string("Laps"));
        bg.add(this.lapsRadio);
        GridBagConstraints dbc = new GridBagConstraints();
        dbc.gridx = 0;
        dbc.gridy = 0;
        dbc.weightx = 1.0;
        dbc.fill = 2;
        dsPanel.add((Component)this.sessionsRadio, dbc);
        dbc.gridy = 1;
        dsPanel.add((Component)this.lapsRadio, dbc);
        dsPanel.setBorder(BorderFactory.createEtchedBorder());
        gc.gridy = y++;
        panel.add((Component)dsPanel, gc);
        this.modulePanel = new JPanel(new BorderLayout());
        if (this.modList.getSelectedItem() != null) {
            JPanel modpanel = this.modules.get(this.modList.getSelectedIndex()).getPanel();
            if (modpanel == null) {
                modpanel = new JPanel();
            }
            this.modulePanel.add((Component)new JScrollPane(modpanel), "Center");
        }
        gc.gridy = y++;
        gc.weighty = 1.0;
        gc.fill = 1;
        panel.add((Component)this.modulePanel, gc);
        return panel;
    }

    private void initialize() {
        this.setTitle(Language.string("Exporting..."));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        JPanel left_panel = this.getFormatSelectionPanel();
        left_panel.setPreferredSize(new Dimension(300, 300));
        left_panel.setBorder(new TitledBorder(Language.string("Export modules")));
        this.getContentPane().add((Component)left_panel, gc);
        JPanel selection_panel = this.getDataSelectionPanel();
        selection_panel.setPreferredSize(new Dimension(300, 250));
        selection_panel.setBorder(new TitledBorder(Language.string("Data")));
        gc.gridheight = 1;
        gc.gridx = 1;
        this.getContentPane().add((Component)selection_panel, gc);
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new GridBagLayout());
        GridBagConstraints bgc = new GridBagConstraints();
        bgc.gridx = 0;
        bgc.gridy = 0;
        bgc.weightx = 1.0;
        bgc.fill = 2;
        bgc.insets = new Insets(2, 2, 2, 2);
        JButton export_button = new JButton(Language.string("Export"));
        export_button.setActionCommand(EXPORT_ACTION);
        export_button.addActionListener(this);
        JButton cancel_button = new JButton(Language.string("Cancel"));
        cancel_button.setActionCommand(CANCEL_ACTION);
        cancel_button.addActionListener(this);
        button_panel.add((Component)export_button, bgc);
        bgc.gridx = 1;
        button_panel.add((Component)cancel_button, bgc);
        button_panel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
        gc.gridy = 1;
        gc.weighty = 0.0;
        gc.fill = 2;
        this.getContentPane().add((Component)button_panel, gc);
    }

    public void initProgress(int max) {
        System.err.println("Init progress: " + max);
        this.progress = new ProgressMonitor(this, "Exporting...", "", 0, max);
        this.progress.setMillisToDecideToPopup(0);
        this.progress.setMillisToPopup(0);
    }

    public void setProgress(int current) {
        if (this.progress == null) {
            return;
        }
        this.progress.setProgress(current);
    }

    public void closeProgress() {
        if (this.progress == null) {
            return;
        }
        this.progress.close();
    }

    public boolean isCanceledProgress() {
        if (this.progress == null) {
            return false;
        }
        return this.progress.isCanceled();
    }

    public void runExport() {
        int midx = this.modList.getSelectedIndex();
        DanasExportModule mod = this.modules.get(midx);
        int data_mode = 0;
        if (this.sessionsRadio.isSelected()) {
            data_mode = 0;
        } else if (this.lapsRadio.isSelected()) {
            data_mode = 1;
        }
        int r = mod.export(this, data_mode, this.onlySelectedBox.isSelected());
        if (r == 0) {
            JOptionPane.showMessageDialog(this, Language.string("Export finished successfully!"), "Export finished", 1);
        } else if (r == 1) {
            JOptionPane.showMessageDialog(this, Language.string("There was an error exporting selected data..."), "Exporting error...", 0);
        } else if (r != -1) {
            JOptionPane.showMessageDialog(this, Language.string("Export module reports unhandled code " + r), "Export report...", 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(EXPORT_MODULE_SELECTION)) {
            DanasExportModule module = this.modules.get(this.modList.getSelectedIndex());
            String description = module.getDescription();
            if (description == null) {
                description = new String("");
            }
            this.modDescription.setText(description);
            this.modulePanel.removeAll();
            JPanel panel = module.getPanel();
            if (panel == null) {
                panel = new JPanel();
            }
            if (this.modList.getSelectedIndex() > 0) {
                this.onlySelectedBox.setSelected(true);
                this.sessionsRadio.setSelected(true);
                this.onlySelectedBox.setEnabled(false);
                this.sessionsRadio.setEnabled(false);
                this.lapsRadio.setEnabled(false);
            } else {
                this.onlySelectedBox.setEnabled(true);
                this.sessionsRadio.setEnabled(true);
                this.lapsRadio.setEnabled(true);
            }
            this.modulePanel.add((Component)new JScrollPane(panel), "Center");
            this.modulePanel.validate();
        } else if (e.getActionCommand().equals(EXPORT_ACTION)) {
            if (this.worker != null && this.worker.isAlive()) {
                this.worker.stop();
            }
            this.worker = new Thread(new Runnable(){

                @Override
                public void run() {
                    DanasExportDialog.this.runExport();
                }
            });
            this.worker.start();
        } else if (e.getActionCommand().equals(CANCEL_ACTION)) {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        DanasExportDialog d = new DanasExportDialog(null);
        d.setLocationRelativeTo(null);
        d.setVisible(true);
    }
}

