/*
 * Decompiled with CFR 0.152.
 */
package i2m;

import i2m.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MemoryWatcher
extends TimerTask {
    private long max = Runtime.getRuntime().maxMemory();
    private int available;
    private long free;
    private long total;
    private int allocated;
    private static final long MB = 0x100000L;
    private JLabel memoryLabel;
    private JPanel memoryPanel;
    public static ImageIcon okIcon;
    public static ImageIcon warnIcon;
    public static ImageIcon errorIcon;

    public static void main(String[] args) {
        new MemoryWatcher();
    }

    public MemoryWatcher() {
        Timer timer = new Timer();
        timer.schedule((TimerTask)this, 1000L, 1000L);
    }

    public static String valueToHumanReadable(double value, int decimals) {
        if (decimals == 0) {
            return "" + Math.round(value);
        }
        int fact = (int)Math.pow(10.0, decimals);
        long rounded = Math.round(value * (double)fact);
        return "" + (double)rounded / (double)fact;
    }

    public long getMax() {
        return this.max;
    }

    public String getMaxMb() {
        return MemoryWatcher.valueToHumanReadable((double)this.max / 1048576.0, 1);
    }

    public long getFree() {
        return this.free;
    }

    public String getFreeMb() {
        return MemoryWatcher.valueToHumanReadable((double)this.free / 1048576.0, 1);
    }

    public long getTotal() {
        return this.total;
    }

    public String getTotalMb() {
        return MemoryWatcher.valueToHumanReadable((double)this.total / 1048576.0, 1);
    }

    public int getAvailable() {
        return this.available;
    }

    public long getUsed() {
        return this.total - this.free;
    }

    public String getUsedMb() {
        return MemoryWatcher.valueToHumanReadable((double)(this.total - this.free) / 1048576.0, 1);
    }

    @Override
    public void run() {
        this.free = Runtime.getRuntime().freeMemory();
        this.total = Runtime.getRuntime().totalMemory();
        this.available = (int)(this.free * 100L / this.total);
        this.setMemoryStatus(this.total, this.max, this.available);
    }

    public void setMemoryStatus(long total, long max, int current) {
        if (this.memoryLabel != null) {
            this.allocated = (int)(total * 100L / max);
            this.memoryLabel.setToolTipText(Language.string("Using ") + this.getUsedMb() + "MB of " + this.getTotalMb() + "MB (max " + this.getMaxMb() + "MB)");
            this.memoryLabel.setText(Language.string("  Using ") + this.getUsedMb() + "MB (max " + this.getMaxMb() + "MB)");
            if (current >= 30) {
                this.memoryLabel.setIcon(okIcon);
            } else if (current >= 5) {
                if (this.allocated < 99) {
                    this.memoryLabel.setIcon(okIcon);
                } else {
                    this.memoryLabel.setIcon(warnIcon);
                }
            } else if (this.allocated < 99) {
                this.memoryLabel.setIcon(warnIcon);
            } else {
                this.memoryLabel.setIcon(errorIcon);
            }
        }
    }

    public synchronized JPanel getPanel() {
        if (this.memoryPanel == null) {
            okIcon = new ImageIcon("./src/pix/ok_icon.gif");
            warnIcon = new ImageIcon("./src/pix/warn_icon.gif");
            errorIcon = new ImageIcon("./src/pix/error_icon.gif");
            this.memoryLabel = new JLabel();
            this.memoryLabel.setIcon(okIcon);
            this.memoryLabel.setText("  Using " + this.getUsedMb() + "MB (max " + this.getMaxMb() + "MB)");
            this.memoryPanel = new JPanel();
            this.memoryPanel.setLayout(new BorderLayout());
            this.memoryPanel.setMaximumSize(new Dimension(250, 20));
            this.memoryPanel.setMinimumSize(new Dimension(250, 20));
            this.memoryPanel.setPreferredSize(new Dimension(250, 20));
            this.memoryPanel.setBorder(BorderFactory.createEmptyBorder());
            this.memoryPanel.add((Component)this.memoryLabel, "Center");
        }
        return this.memoryPanel;
    }
}

