/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasIRData;
import i2m.Language;
import i2m.MainFrame;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.grafico.Grafico2D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TraguardiManualiDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    JButton addB;
    JButton esciB;
    JButton applicaB;
    JButton rimuoviB;
    JButton giroPosizioneB;
    DefaultListModel elencoGiriLM;
    List<Double> listaGiri = new ArrayList<Double>();
    JTextField tempo;
    Vector<Double> elencoTempi;
    boolean modPosizione = true;
    SincronizzatoreMappaGraficoVideo multiSincro;
    double ultimoTempo = 0.0;
    MainFrame padre;
    JList list;

    public TraguardiManualiDialog(MainFrame owner) {
        super(owner, Language.string(Language.string("Inserisci giri manualmente")), false);
        this.setDefaultCloseOperation(0);
        this.padre = owner;
        this.elencoGiriLM = new DefaultListModel();
        this.elencoGiriLM.clear();
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.addB = new JButton(Language.string("Aggiungi"));
        this.addB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.applicaB = new JButton(Language.string("Applica"));
        this.applicaB.addActionListener(this);
        this.rimuoviB = new JButton(Language.string("Rimuovi"));
        this.rimuoviB.addActionListener(this);
        this.giroPosizioneB = new JButton(Language.string("Posizione (s):"));
        this.giroPosizioneB.addActionListener(this);
        this.tempo = new JTextField(13);
        this.tempo.setHorizontalAlignment(4);
        JPanel pannelloBottoni = new JPanel();
        JPanel pannelloTesto = new JPanel();
        pannelloBottoni.add(this.addB);
        pannelloBottoni.add(this.rimuoviB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.add(this.applicaB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloTesto.add(this.giroPosizioneB);
        pannelloTesto.add(this.tempo);
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.list = new JList(this.elencoGiriLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        JPanel pannelloLista = new JPanel(new BorderLayout());
        pannelloLista.add((Component)listScroller, "Center");
        pannelloLista.add((Component)pannelloTesto, "South");
        pannelloPrincipale.add((Component)pannelloLista, "Center");
        this.elencoTempi = new Vector();
        if (DanasDataStructure.getInstance().getDefaultSession() != null) {
            this.importaGiri(DanasDataStructure.getInstance().getDefaultSession().getListaTempiManuali());
        }
        this.pack();
        this.setSize(new Dimension(350, 350));
    }

    public void setMultisincro(SincronizzatoreMappaGraficoVideo multi) {
        this.multiSincro = multi;
        this.multiSincro.addChangeListener(this);
        double letturaMultisincro = this.multiSincro.getPosizioneCursore();
        this.tempo.setText("" + letturaMultisincro / 100.0);
    }

    public void importaGiri(List lista) {
        this.elencoGiriLM.clear();
        this.elencoTempi.clear();
        for (int i = 0; i < lista.size(); ++i) {
            String s = i == 0 ? " Start lap time: " + (Double)lista.get(i) / 100.0 : " Start lap time: " + (Double)lista.get(i) / 100.0 + "   Lap time: " + Grafico2D.stampaSpazioTempo((Double)lista.get(i) - (Double)lista.get(i - 1), 0);
            System.out.println(s);
            this.elencoGiriLM.addElement(s);
            this.elencoTempi.add((Double)lista.get(i));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source.equals(this.esciB)) {
            this.dispose();
        }
        if (source.equals(this.applicaB)) {
            int index = 0;
            if (DanasDataStructure.getInstance().getDefaultSession() == null) {
                return;
            }
            index = DanasDataStructure.getInstance().getDefaultSession().getSessionID();
            DanasDataStructure.getInstance().inserisciTempi(index, this.elencoTempi);
            this.padre.aggiornaTabellaTempi();
            DanasDataStructure.getInstance().calcolaSpaziPercorsiLap();
            DanasDataStructure.getInstance().ricalcolaValoriGiri();
            DanasDataStructure.getInstance().getSession(index).getAllIRData().clear();
            for (int i = 0; i < this.elencoTempi.size(); ++i) {
                DanasIRData irData = new DanasIRData();
                irData.setTelemetry(this.elencoTempi.get(i) + DanasDataStructure.getInstance().getSession(index).getStartTelemetryTime());
                DanasDataStructure.getInstance().getSession(index).getAllIRData().add(irData);
            }
            if (DanasDataStructure.getInstance().getDefaultSession() != null) {
                DanasDataStructure.getInstance().getDefaultSession().setListaTempiManuali(this.listaGiri);
            }
        }
        if (source.equals(this.addB)) {
            double t;
            try {
                t = Double.valueOf(this.tempo.getText()) * 100.0;
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(null, Language.string("Formato testo errato"), Language.string("Error"), 0);
                return;
            }
            double next = !this.modPosizione ? this.ultimoTempo + t : t;
            boolean uguale = false;
            for (int i = 0; i < this.elencoTempi.size(); ++i) {
                if (next != this.elencoTempi.get(i)) continue;
                uguale = true;
            }
            if (uguale) {
                JOptionPane.showMessageDialog(null, Language.string("ATTENZIONE: Tempo uguale ad uno precedente"), Language.string("Error"), 0);
                return;
            }
            this.ultimoTempo = next;
            this.multiSincro.setPosizioneCursore(this.ultimoTempo);
            this.multiSincro.setAggiornaPosizioneCursore(true);
            this.elencoTempi.add(next);
            Collections.sort(this.elencoTempi);
            this.elencoGiriLM.clear();
            this.listaGiri.clear();
            for (int i = 0; i < this.elencoTempi.size(); ++i) {
                String s = i == 0 ? " Start lap time: " + this.elencoTempi.get(i) / 100.0 : " Start lap time: " + this.elencoTempi.get(i) / 100.0 + "   Lap time: " + Grafico2D.stampaSpazioTempo(this.elencoTempi.get(i) - this.elencoTempi.get(i - 1), 0);
                this.elencoGiriLM.addElement(s);
                this.listaGiri.add(this.elencoTempi.get(i));
            }
        }
        if (source.equals(this.rimuoviB) && this.list.getSelectedIndex() != -1) {
            int index = this.list.getSelectedIndex();
            this.elencoGiriLM.remove(index);
            this.elencoTempi.remove(index);
            Collections.sort(this.elencoTempi);
            this.elencoGiriLM.clear();
            this.listaGiri.clear();
            for (int i = 0; i < this.elencoTempi.size(); ++i) {
                String s = i == 0 ? " Start lap time: " + this.elencoTempi.get(i) / 100.0 : " Start lap time: " + this.elencoTempi.get(i) / 100.0 + "   Lap time: " + Grafico2D.stampaSpazioTempo(this.elencoTempi.get(i) - this.elencoTempi.get(i - 1), 0);
                this.elencoGiriLM.addElement(s);
                this.listaGiri.add(this.elencoTempi.get(i));
            }
            this.ultimoTempo = this.elencoTempi.size() != 0 ? this.elencoTempi.get(this.elencoTempi.size() - 1) : 0.0;
            if (this.elencoGiriLM.size() == 0 && !this.modPosizione) {
                this.modPosizione = true;
                this.giroPosizioneB.setText(Language.string("Posizione (centesimi):"));
            }
            this.multiSincro.setPosizioneCursore(this.ultimoTempo);
            this.multiSincro.setAggiornaPosizioneCursore(true);
        }
        if (source.equals(this.giroPosizioneB)) {
            if (this.modPosizione && this.elencoGiriLM.size() != 0) {
                this.modPosizione = false;
                this.giroPosizioneB.setText(Language.string("Lap Time  (s):"));
            } else {
                this.modPosizione = true;
                this.giroPosizioneB.setText(Language.string("Posizione (s):"));
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource().equals(this.multiSincro)) {
            if (!this.multiSincro.getAggionrnaMappaGrafico()) {
                return;
            }
            if (!this.modPosizione) {
                double letturaMultisincro = this.multiSincro.getPosizioneCursore();
                if (this.elencoTempi.size() == 0) {
                    return;
                }
                this.tempo.setText("" + (letturaMultisincro - this.elencoTempi.get(this.elencoTempi.size() - 1)) / 100.0);
            } else {
                double letturaMultisincro = this.multiSincro.getPosizioneCursore();
                this.tempo.setText("" + letturaMultisincro / 100.0);
            }
        }
    }

    public static enum KindOfBike {
        ZX10R_2016;

    }
}

