/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Dialog.SensoreTPMS;
import i2m.Language;
import i2m.MainFrame;
import i2m.onLine.SerialConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.MaskFormatter;

public class TpmsCanDialog
extends JDialog
implements ActionListener,
WindowListener,
ListSelectionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private JComboBox sceltaCOM = null;
    private JComboBox sceltaBaud;
    private JComboBox tipoMoto;
    private JButton connettiB;
    private JButton eliminaBFront;
    private JButton modificaBFront;
    private JButton eliminaBRear;
    private JButton modificaBRear;
    private JButton allRear;
    private JButton allFront;
    private JButton applyB;
    private JButton sendB;
    private DefaultListModel elencoSensoriLmFront;
    private DefaultListModel elencoSensoriLmRear;
    private JLabel canFrontLabel;
    private JLabel canRearLabel;
    private JLabel baudLabel;
    JFormattedTextField idTfFront;
    JFormattedTextField idTfRear;
    private JTextField pressioniTfFront;
    private JTextField temperatureTfFront;
    private JTextField tensioniTfFront;
    private JTextField pressioniTfRear;
    private JTextField temperatureTfRear;
    private JTextField tensioniTfRear;
    private JTextField segnaleTfFront;
    private JTextField segnaleTfRear;
    private JTextField oraTfFront;
    private JTextField oraTfRear;
    private JFormattedTextField canFront;
    private JFormattedTextField canRear;
    private JList listFront;
    private JList listRear;
    private String[] elenco = null;
    private Vector<SensoreTPMS> elencoSensori;
    private SerialConnection conn;
    private boolean connected = false;
    private int riceviDati = 0;
    private Thread acquisitionThread;
    private int conteggioAggiornamentiFront;
    private int conteggioAggiornamentiRear;
    private final int MAX_AGGIORNAMENTI = 800;
    private Long ultimoTempo = 0L;
    private Date ultimoTempoData;
    private JPanel pannelloSotto;
    private int versione = 1;
    private boolean debug = false;

    public TpmsCanDialog(MainFrame owner, String[] lista) {
        super(owner, Language.string(Language.string("TPMS/Can bus configurator")), false);
        this.addWindowListener(this);
        this.elenco = lista;
        this.elencoSensoriLmFront = new DefaultListModel();
        this.elencoSensoriLmFront.clear();
        this.elencoSensoriLmRear = new DefaultListModel();
        this.elencoSensoriLmRear.clear();
        this.elencoSensori = new Vector();
        this.sceltaCOM = new JComboBox();
        this.sceltaCOM.setFocusable(false);
        this.connettiB = new JButton(Language.string("Connetti"));
        this.connettiB.addActionListener(this);
        this.sceltaCOM.setMinimumSize(new Dimension(120, 25));
        this.sceltaCOM.setPreferredSize(new Dimension(120, 25));
        this.sceltaCOM.setMaximumSize(new Dimension(120, 25));
        this.connettiB.setMinimumSize(new Dimension(80, 25));
        this.connettiB.setMaximumSize(new Dimension(80, 25));
        this.connettiB.setFocusable(false);
        JLabel l = new JLabel(Language.string("Porta ricevitore Can/TPMS:"));
        JPanel pannelloConnessione = new JPanel();
        pannelloConnessione.add(l);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.sceltaCOM);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.connettiB);
        this.listFront = new JList(this.elencoSensoriLmFront);
        this.listFront.setSelectionMode(0);
        this.listFront.setLayoutOrientation(0);
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)this.listFront.getCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.listFront.addListSelectionListener(this);
        JScrollPane listScrollerFront = new JScrollPane(this.listFront);
        listScrollerFront.setPreferredSize(new Dimension(50, 100));
        listScrollerFront.setVerticalScrollBarPolicy(22);
        this.listRear = new JList(this.elencoSensoriLmRear);
        this.listRear.setSelectionMode(0);
        this.listRear.setLayoutOrientation(0);
        DefaultListCellRenderer rendererRear = (DefaultListCellRenderer)this.listRear.getCellRenderer();
        rendererRear.setHorizontalAlignment(0);
        this.listRear.addListSelectionListener(this);
        JScrollPane listScrollerRear = new JScrollPane(this.listRear);
        listScrollerRear.setPreferredSize(new Dimension(50, 100));
        listScrollerRear.setVerticalScrollBarPolicy(22);
        MaskFormatter MascheraID = null;
        try {
            MascheraID = new MaskFormatter("*******");
            String caratteriNumerici = "1234567890";
            MascheraID.setValidCharacters(caratteriNumerici);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.idTfFront = new JFormattedTextField(MascheraID);
        this.idTfFront.setValue("0000000");
        this.idTfFront.setHorizontalAlignment(4);
        JPanel idPanelFront = new JPanel();
        JLabel idLabelFront = new JLabel(Language.string("  ID:"));
        GridLayout IDLayot = new GridLayout(1, 2, 2, 2);
        idPanelFront.setLayout(IDLayot);
        idPanelFront.add(idLabelFront);
        idPanelFront.add(this.idTfFront);
        this.idTfRear = new JFormattedTextField(MascheraID);
        this.idTfRear.setValue("0000000");
        this.idTfRear.setHorizontalAlignment(4);
        JPanel idPanelRear = new JPanel();
        JLabel idLabelRear = new JLabel(Language.string("  ID:"));
        idPanelRear.setLayout(IDLayot);
        idPanelRear.add(idLabelRear);
        idPanelRear.add(this.idTfRear);
        this.eliminaBFront = new JButton(Language.string("Elimina"));
        this.eliminaBFront.addActionListener(this);
        this.eliminaBFront.setFocusable(false);
        this.modificaBFront = new JButton(Language.string("Aggiungi"));
        this.modificaBFront.addActionListener(this);
        this.modificaBFront.setFocusable(false);
        this.allFront = new JButton(Language.string("Elimina tutti"));
        this.allFront.addActionListener(this);
        this.allFront.setFocusable(false);
        this.eliminaBRear = new JButton(Language.string("Elimina"));
        this.eliminaBRear.addActionListener(this);
        this.eliminaBRear.setFocusable(false);
        this.modificaBRear = new JButton(Language.string("Aggiungi"));
        this.modificaBRear.addActionListener(this);
        this.modificaBRear.setFocusable(false);
        this.allRear = new JButton(Language.string("Elimina tutti"));
        this.allRear.addActionListener(this);
        this.allRear.setFocusable(false);
        this.applyB = new JButton(Language.string("Applica modifiche"));
        this.applyB.setPreferredSize(new Dimension(150, 25));
        this.applyB.addActionListener(this);
        this.applyB.setFocusable(false);
        GridLayout enterLayout = new GridLayout(4, 1, 2, 2);
        JPanel pannelloFront = new JPanel(new BorderLayout());
        pannelloFront.setLayout(enterLayout);
        pannelloFront.setBorder(BorderFactory.createTitledBorder(Language.string("Modifica ID Front")));
        JPanel pannelloRear = new JPanel(new BorderLayout());
        pannelloRear.setLayout(enterLayout);
        pannelloRear.setBorder(BorderFactory.createTitledBorder(Language.string("Modifica ID Rear")));
        JPanel PanelBorderLeft = new JPanel(new BorderLayout());
        PanelBorderLeft.setBorder(BorderFactory.createTitledBorder(Language.string("Gestione ID")));
        this.pressioniTfFront = new JTextField(6);
        this.pressioniTfFront.setText("--- ");
        this.oraTfFront = new JTextField(6);
        this.oraTfFront.setText("--- ");
        this.temperatureTfFront = new JTextField(6);
        this.temperatureTfFront.setText("--- ");
        this.tensioniTfFront = new JTextField(6);
        this.tensioniTfFront.setText("--- ");
        this.segnaleTfFront = new JTextField(6);
        this.segnaleTfFront.setText("--- ");
        this.pressioniTfFront.setFocusable(false);
        this.oraTfFront.setFocusable(false);
        this.temperatureTfFront.setFocusable(false);
        this.tensioniTfFront.setFocusable(false);
        this.segnaleTfFront.setFocusable(false);
        this.pressioniTfFront.setEditable(false);
        this.oraTfFront.setEditable(false);
        this.temperatureTfFront.setEditable(false);
        this.tensioniTfFront.setEditable(false);
        this.segnaleTfFront.setEditable(false);
        Font font_etichetta = this.pressioniTfFront.getFont().deriveFont(14.0f);
        this.pressioniTfFront.setFont(font_etichetta);
        this.temperatureTfFront.setFont(font_etichetta);
        this.tensioniTfFront.setFont(font_etichetta);
        this.segnaleTfFront.setFont(font_etichetta);
        this.oraTfFront.setFont(font_etichetta);
        this.pressioniTfFront.setHorizontalAlignment(4);
        this.temperatureTfFront.setHorizontalAlignment(4);
        this.tensioniTfFront.setHorizontalAlignment(4);
        this.segnaleTfFront.setHorizontalAlignment(4);
        this.oraTfFront.setHorizontalAlignment(4);
        JPanel internoF = new JPanel(new BorderLayout());
        internoF.setBorder(BorderFactory.createTitledBorder(Language.string("Valori letti")));
        GridLayout internoLayout = new GridLayout(5, 1, 2, 2);
        internoF.setLayout(internoLayout);
        internoF.add(this.pressioniTfFront);
        internoF.add(this.temperatureTfFront);
        internoF.add(this.tensioniTfFront);
        internoF.add(this.segnaleTfFront);
        internoF.add(this.oraTfFront);
        this.pressioniTfRear = new JTextField(6);
        this.pressioniTfRear.setText("--- ");
        this.oraTfRear = new JTextField(6);
        this.oraTfRear.setText("--- ");
        this.temperatureTfRear = new JTextField(6);
        this.temperatureTfRear.setText("--- ");
        this.tensioniTfRear = new JTextField(6);
        this.tensioniTfRear.setText("--- ");
        this.segnaleTfRear = new JTextField(6);
        this.segnaleTfRear.setText("--- ");
        this.pressioniTfRear.setFocusable(false);
        this.oraTfRear.setFocusable(false);
        this.temperatureTfRear.setFocusable(false);
        this.tensioniTfRear.setFocusable(false);
        this.segnaleTfRear.setFocusable(false);
        this.pressioniTfRear.setEditable(false);
        this.oraTfRear.setEditable(false);
        this.temperatureTfRear.setEditable(false);
        this.tensioniTfRear.setEditable(false);
        this.segnaleTfRear.setEditable(false);
        this.pressioniTfRear.setFont(font_etichetta);
        this.temperatureTfRear.setFont(font_etichetta);
        this.tensioniTfRear.setFont(font_etichetta);
        this.segnaleTfRear.setFont(font_etichetta);
        this.oraTfRear.setFont(font_etichetta);
        this.pressioniTfRear.setHorizontalAlignment(4);
        this.temperatureTfRear.setHorizontalAlignment(4);
        this.tensioniTfRear.setHorizontalAlignment(4);
        this.segnaleTfRear.setHorizontalAlignment(4);
        this.oraTfRear.setHorizontalAlignment(4);
        JPanel internoR = new JPanel(new BorderLayout());
        internoR.setBorder(BorderFactory.createTitledBorder(Language.string("Valori letti")));
        internoR.setLayout(internoLayout);
        internoR.add(this.pressioniTfRear);
        internoR.add(this.temperatureTfRear);
        internoR.add(this.tensioniTfRear);
        internoR.add(this.segnaleTfRear);
        internoR.add(this.oraTfRear);
        MaskFormatter MascheraCan = null;
        try {
            MascheraCan = new MaskFormatter("***");
            String caratteriHex = "1234567890ABCDEF";
            MascheraCan.setValidCharacters(caratteriHex);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.canFront = new JFormattedTextField(MascheraCan);
        this.canRear = new JFormattedTextField(MascheraCan);
        this.canFront.setValue("698");
        this.canRear.setValue("699");
        this.canFront.setPreferredSize(new Dimension(40, 25));
        this.canRear.setPreferredSize(new Dimension(40, 25));
        this.canFront.setFont(font_etichetta);
        this.canRear.setFont(font_etichetta);
        this.canFront.setHorizontalAlignment(4);
        this.canRear.setHorizontalAlignment(4);
        this.canFront.addPropertyChangeListener("value", this);
        String[] elencoBaud = new String[]{"125k", "250k", "500k", "1M"};
        this.sceltaBaud = new JComboBox<String>(elencoBaud);
        this.sceltaBaud.addActionListener(this);
        this.sceltaBaud.setFocusable(false);
        this.sceltaBaud.setMinimumSize(new Dimension(800, 25));
        this.sceltaBaud.setPreferredSize(new Dimension(80, 25));
        this.sceltaBaud.setMaximumSize(new Dimension(80, 25));
        String[] elencoMoto = new String[]{"Default", "Dorna WSBK 2021", "Custom"};
        this.tipoMoto = new JComboBox<String>(elencoMoto);
        this.tipoMoto.addActionListener(this);
        this.tipoMoto.setFocusable(false);
        this.tipoMoto.setMinimumSize(new Dimension(150, 25));
        this.tipoMoto.setPreferredSize(new Dimension(150, 25));
        this.tipoMoto.setMaximumSize(new Dimension(150, 25));
        this.canFrontLabel = new JLabel(Language.string("ID Can Front [HEX]:"));
        this.canRearLabel = new JLabel(Language.string("ID Can Rear [HEX]:"));
        this.baudLabel = new JLabel(Language.string("Baud:"));
        JLabel motoLabel = new JLabel(Language.string("Tipo di moto:"));
        JPanel pannelloCan = new JPanel();
        this.pannelloSotto = new JPanel();
        this.pannelloSotto.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers: ---")));
        this.versione = 1;
        GridLayout sottoLayout = new GridLayout(2, 1, 0, 0);
        this.pannelloSotto.setLayout(sottoLayout);
        JPanel pannelloMoto = new JPanel();
        pannelloCan.add(this.canFrontLabel);
        pannelloCan.add(Box.createRigidArea(new Dimension(2, 30)));
        pannelloCan.add(this.canFront);
        pannelloCan.add(Box.createRigidArea(new Dimension(2, 30)));
        pannelloCan.add(this.canRearLabel);
        pannelloCan.add(Box.createRigidArea(new Dimension(2, 30)));
        pannelloCan.add(this.canRear);
        pannelloCan.add(Box.createRigidArea(new Dimension(2, 30)));
        pannelloCan.add(this.baudLabel);
        pannelloCan.add(Box.createRigidArea(new Dimension(2, 30)));
        pannelloCan.add(this.sceltaBaud);
        pannelloCan.add(Box.createRigidArea(new Dimension(2, 30)));
        pannelloMoto.add(motoLabel);
        pannelloMoto.add(Box.createRigidArea(new Dimension(5, 30)));
        pannelloMoto.add(this.tipoMoto);
        pannelloMoto.add(Box.createRigidArea(new Dimension(5, 30)));
        pannelloMoto.add(this.applyB);
        pannelloMoto.add(Box.createRigidArea(new Dimension(5, 30)));
        this.pannelloSotto.add(pannelloCan);
        this.pannelloSotto.add(pannelloMoto);
        pannelloFront.add(idPanelFront);
        pannelloFront.add(this.modificaBFront);
        pannelloFront.add(this.eliminaBFront);
        pannelloFront.add(this.allFront);
        pannelloRear.add(idPanelRear);
        pannelloRear.add(this.modificaBRear);
        pannelloRear.add(this.eliminaBRear);
        pannelloRear.add(this.allRear);
        JPanel pannelloCentrale = new JPanel();
        GridLayout centraleLayout = new GridLayout(3, 2, 2, 2);
        pannelloCentrale.setLayout(centraleLayout);
        pannelloCentrale.add(listScrollerFront);
        pannelloCentrale.add(listScrollerRear);
        pannelloCentrale.add(pannelloFront);
        pannelloCentrale.add(pannelloRear);
        pannelloCentrale.add(internoF);
        pannelloCentrale.add(internoR);
        this.listFront.setFocusable(false);
        this.listRear.setFocusable(false);
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        if (this.elenco != null) {
            for (int i = 0; i < this.elenco.length; ++i) {
                this.sceltaCOM.addItem(lista[i]);
            }
            if (this.elenco.length > 0) {
                this.sceltaCOM.setSelectedIndex(0);
            }
        }
        this.canFront.setEnabled(false);
        this.canRear.setEnabled(false);
        this.sceltaBaud.setEnabled(false);
        this.canFrontLabel.setEnabled(false);
        this.canRearLabel.setEnabled(false);
        this.baudLabel.setEnabled(false);
        this.tipoMoto.setEnabled(false);
        this.applyB.setEnabled(false);
        this.eliminaBFront.setEnabled(false);
        this.modificaBFront.setEnabled(false);
        this.eliminaBRear.setEnabled(false);
        this.modificaBRear.setEnabled(false);
        this.allRear.setEnabled(false);
        this.allFront.setEnabled(false);
        this.idTfFront.setEnabled(false);
        this.idTfRear.setEnabled(false);
        pannelloPrincipale.add((Component)pannelloConnessione, "North");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)this.pannelloSotto, "South");
        this.pack();
        this.setResizable(false);
        Calendar cal = Calendar.getInstance();
        this.ultimoTempoData = cal.getTime();
    }

    public void acquisisciContinuo() {
        String line = null;
        boolean aggiorna = false;
        while (this.connected) {
            boolean ricevutoNulla = false;
            try {
                if (this.leggiRicezioneDati() == 2) {
                    line = this.conn.readLineTPMS();
                    if (line != null) {
                        this.analizzaFraseTpms(line);
                    } else {
                        ricevutoNulla = true;
                    }
                } else {
                    boolean res = true;
                    if (this.debug) {
                        System.out.println("SCrivo M");
                    }
                    this.conn.write("$M\r");
                    String end = this.conn.readLine();
                    while (end != null && end.startsWith("$TPMS")) {
                        end = this.conn.readLine();
                        if (!this.debug) continue;
                        System.out.println("In attesa ricevuto:" + end);
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto stop:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("ATTENZIONE"), 2);
                        return;
                    }
                    if (this.leggiRicezioneDati() == 1) {
                        if (this.debug) {
                            System.out.println("Invio ID");
                        }
                        if (res = this.inviaId()) {
                            if (this.debug) {
                                System.out.println("Invio Can");
                            }
                            res = this.inviaCan();
                        }
                    }
                    if (res) {
                        if (this.debug) {
                            System.out.println("Ricevo ID");
                        }
                        res = this.riceviId();
                    }
                    if (res) {
                        if (this.debug) {
                            System.out.println("Ricevo Can");
                        }
                        res = this.riceviCan();
                    }
                    this.attivaRicezioneDati(2);
                    if (this.debug) {
                        System.out.println("Scrivo $S");
                    }
                    this.conn.write("$S\r");
                    this.conn.readLine();
                    this.applyB.setEnabled(false);
                    this.applyB.setText("Applica modifiche");
                    this.applyB.setBackground(null);
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE -2"), 0);
                this.disconnetti();
                break;
            }
            if (this.conteggioAggiornamentiFront < 800) {
                this.conteggioAggiornamentiFront = !ricevutoNulla ? (this.conteggioAggiornamentiFront += 2) : (this.conteggioAggiornamentiFront += 10);
            }
            if (this.conteggioAggiornamentiFront >= 800) {
                this.azzeraLetturaFront();
            }
            if (this.conteggioAggiornamentiRear < 800) {
                this.conteggioAggiornamentiRear = !ricevutoNulla ? (this.conteggioAggiornamentiRear += 2) : (this.conteggioAggiornamentiRear += 10);
            }
            if (this.conteggioAggiornamentiRear < 800) continue;
            this.azzeraLetturaRear();
        }
    }

    public void azzeraLetturaFront() {
        this.pressioniTfFront.setText("--- ");
        this.temperatureTfFront.setText("--- ");
        this.tensioniTfFront.setText("--- ");
        this.segnaleTfFront.setText("--- ");
        this.oraTfFront.setText("--- ");
    }

    public void azzeraLetturaRear() {
        this.pressioniTfRear.setText("--- ");
        this.temperatureTfRear.setText("--- ");
        this.tensioniTfRear.setText("--- ");
        this.segnaleTfRear.setText("--- ");
        this.oraTfRear.setText("--- ");
    }

    public void analizzaFraseTpms(String frase) {
        int press;
        int temp;
        int volt;
        String id;
        if (frase == null) {
            return;
        }
        if (!frase.startsWith("$TPMS")) {
            return;
        }
        int segn = 0;
        StringTokenizer st = new StringTokenizer(frase, ",");
        String t = st.nextToken();
        try {
            id = t = st.nextToken();
            t = st.nextToken();
            t = st.nextToken();
            volt = Integer.parseInt(t);
            t = st.nextToken();
            temp = Integer.parseInt(t);
            t = st.nextToken();
            press = Integer.parseInt(t);
            t = "";
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                segn = Integer.parseInt(t);
            }
        }
        catch (Exception ex) {
            System.err.println("Errore nel parsing della frase tpms:" + frase);
            return;
        }
        final double percentuale = volt;
        final double temperatura = (double)temp - 55.0;
        final double pressione = (1.376 * (double)press + 98.624) / 100.0;
        final double segnale = (double)segn / 2.0 - 130.0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TpmsCanDialog.this.mostraDati(id, pressione - 1.0, temperatura, percentuale, segnale);
            }
        });
    }

    public void connetti() {
        if (this.connected) {
            return;
        }
        if (this.sceltaCOM.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(null, Language.string("Selezionare una porta"), Language.string("Attenzione"), 2);
            return;
        }
        this.sceltaCOM.setEnabled(false);
        try {
            this.conn = new SerialConnection(this.elenco[this.sceltaCOM.getSelectedIndex()]);
            this.conn.open(5);
            this.conn.clear(3000);
            this.conn.write("\r");
            String end = this.conn.readLine();
            this.conn.clear(1000);
            this.conn.write("\r");
            end = this.conn.readLine();
            this.conn.setTimeOut(1000);
            this.conn.write("\r");
            end = this.conn.readLine();
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return;
            }
            this.connettiB.setText(Language.string("Disconnetti"));
            this.connected = true;
            this.conn.write("$V\r");
            end = this.conn.readLine();
            this.versione = this.estraiVersione(end);
            this.pannelloSotto.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers: ") + this.versione));
            this.attivaRicezioneDati(0);
            this.acquisitionThread = new Thread(){

                @Override
                public void run() {
                    TpmsCanDialog.this.acquisisciContinuo();
                }
            };
            this.acquisitionThread.setDaemon(true);
            this.acquisitionThread.start();
            this.canFront.setEnabled(true);
            this.canRear.setEnabled(true);
            this.sceltaBaud.setEnabled(true);
            this.canFrontLabel.setEnabled(true);
            this.canRearLabel.setEnabled(true);
            this.baudLabel.setEnabled(true);
            this.tipoMoto.setEnabled(true);
            this.eliminaBFront.setEnabled(true);
            this.modificaBFront.setEnabled(true);
            this.eliminaBRear.setEnabled(true);
            this.modificaBRear.setEnabled(true);
            this.allRear.setEnabled(true);
            this.allFront.setEnabled(true);
            this.idTfFront.setEnabled(true);
            this.idTfRear.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sceltaCOM.setEnabled(true);
            JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        }
    }

    public synchronized void attivaRicezioneDati(int modalitaRicezione) {
        this.riceviDati = modalitaRicezione;
    }

    public synchronized int leggiRicezioneDati() {
        return this.riceviDati;
    }

    public void disconnetti() {
        this.sceltaCOM.setEnabled(true);
        this.canFront.setEnabled(false);
        this.canRear.setEnabled(false);
        this.sceltaBaud.setEnabled(false);
        this.canFrontLabel.setEnabled(false);
        this.canRearLabel.setEnabled(false);
        this.baudLabel.setEnabled(false);
        this.tipoMoto.setEnabled(false);
        this.applyB.setEnabled(false);
        this.eliminaBFront.setEnabled(false);
        this.modificaBFront.setEnabled(false);
        this.eliminaBRear.setEnabled(false);
        this.modificaBRear.setEnabled(false);
        this.allRear.setEnabled(false);
        this.allFront.setEnabled(false);
        this.idTfFront.setEnabled(false);
        this.idTfRear.setEnabled(false);
        try {
            this.connected = false;
            this.pannelloSotto.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers: ---")));
            this.versione = 1;
            try {
                if (this.acquisitionThread != null && Thread.currentThread() != this.acquisitionThread) {
                    this.acquisitionThread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.conn.write("$E\r");
            this.conn.setTimeOut(10);
            this.conn.clear(1000);
            while (this.conn.readLine() != null) {
            }
            this.conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connettiB.setText(Language.string("Connetti"));
    }

    public void mostraDati(String id, double pressione, double temperatura, double tensione, double segnale) {
        String s = String.format("%.2f bar ", pressione);
        if (this.idTfRear.getText().equals(id) && this.presenteRear(id)) {
            this.pressioniTfRear.setText(s);
            this.conteggioAggiornamentiRear = 0;
        }
        if (this.idTfFront.getText().equals(id) && this.presenteFront(id)) {
            this.pressioniTfFront.setText(s);
            this.conteggioAggiornamentiFront = 0;
        }
        s = String.format("%.2f C\u00b0 ", temperatura);
        if (this.idTfRear.getText().equals(id) && this.presenteRear(id)) {
            this.temperatureTfRear.setText(s);
        }
        if (this.idTfFront.getText().equals(id) && this.presenteFront(id)) {
            this.temperatureTfFront.setText(s);
        }
        s = String.format("%.0f %% ", tensione);
        if (this.idTfRear.getText().equals(id) && this.presenteRear(id)) {
            this.tensioniTfRear.setText(s);
        }
        if (this.idTfFront.getText().equals(id) && this.presenteFront(id)) {
            this.tensioniTfFront.setText(s);
        }
        s = String.format("RSSI %.0f dBm ", segnale);
        if (this.idTfRear.getText().equals(id) && this.presenteRear(id)) {
            this.segnaleTfRear.setText(s);
        }
        if (this.idTfFront.getText().equals(id) && this.presenteFront(id)) {
            this.segnaleTfFront.setText(s);
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        if (this.idTfRear.getText().equals(id) && this.presenteRear(id)) {
            this.oraTfRear.setText(sdf.format(cal.getTime()));
        }
        if (this.idTfFront.getText().equals(id) && this.presenteFront(id)) {
            this.oraTfFront.setText(sdf.format(cal.getTime()));
            this.ultimoTempo = cal.getTime().getTime();
            this.ultimoTempoData = cal.getTime();
        }
    }

    public boolean inviaId() {
        try {
            String end;
            long valore;
            String s;
            int i;
            int numero = 4;
            for (i = 0; i < this.elencoSensoriLmFront.size(); ++i) {
                if (this.debug) {
                    System.out.println("invio ID numero:" + i + " = " + numero);
                }
                s = String.format("%03d", numero);
                valore = Integer.parseInt((String)this.elencoSensoriLmFront.getElementAt(i));
                this.conn.write("$WD," + s + "," + (valore += 0x1000000L) + "\n\r");
                end = this.conn.readLine();
                if (this.debug) {
                    System.out.println("Ricevuto-idFront:" + end);
                }
                if (end == null || !end.startsWith("Ready")) {
                    this.disconnetti();
                    JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    return false;
                }
                ++numero;
            }
            for (i = 0; i < this.elencoSensoriLmRear.size(); ++i) {
                if (this.debug) {
                    System.out.println("invio ID numero:" + i + " = " + numero);
                }
                s = String.format("%03d", numero);
                valore = Integer.parseInt((String)this.elencoSensoriLmRear.getElementAt(i));
                this.conn.write("$WD," + s + "," + (valore += 0x2000000L) + "\n\r");
                end = this.conn.readLine();
                if (this.debug) {
                    System.out.println("Ricevuto-idRear:" + end);
                }
                if (end == null || !end.startsWith("Ready")) {
                    this.disconnetti();
                    JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    return false;
                }
                ++numero;
            }
            s = String.format("%03d", numero);
            valore = 0xFFFFFFL;
            this.conn.write("$WD," + s + "," + valore + "\n\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto-03:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean riceviId() {
        long valore = 0L;
        int numero = 4;
        try {
            this.elencoSensoriLmFront.clear();
            this.elencoSensoriLmRear.clear();
            while (valore != 0xFFFFFFL && valore != 0xFFFFFFFFL) {
                long idRicevuto;
                String s = String.format("%03d", numero);
                this.conn.write("$RD," + s + "\n\r");
                String end = this.conn.readLine();
                if (this.debug) {
                    System.out.println("Ricevuto-id:" + end);
                }
                if (end == null || !end.startsWith("$RD")) {
                    this.disconnetti();
                    JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    return false;
                }
                valore = this.estraiValoreRicevuto(end);
                if (this.debug) {
                    System.out.println("Valore Ricevuto-id:" + valore);
                }
                if (valore / 0x1000000L == 1L) {
                    idRicevuto = valore - 0x1000000L;
                    this.elencoSensoriLmFront.addElement("" + idRicevuto);
                }
                if (valore / 0x1000000L == 2L) {
                    idRicevuto = valore - 0x2000000L;
                    this.elencoSensoriLmRear.addElement("" + idRicevuto);
                }
                ++numero;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean inviaCan() {
        int front = Integer.parseInt(this.canFront.getText().trim(), 16);
        int rear = Integer.parseInt(this.canRear.getText().trim(), 16);
        int baud = 0;
        switch (this.sceltaBaud.getSelectedIndex()) {
            case 0: {
                baud = 7;
                break;
            }
            case 1: {
                baud = 3;
                break;
            }
            case 2: {
                baud = 1;
                break;
            }
            case 3: {
                baud = 0;
                break;
            }
            default: {
                baud = 1;
            }
        }
        try {
            this.conn.write("$WD,000," + baud + "\n\r");
            String end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto 000:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,001," + front + "\n\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto 001:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,002," + rear + "\n\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto 002:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,003," + this.tipoMoto.getSelectedIndex() + "\n\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto 003:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public long estraiValoreRicevuto(String line) {
        if (line == null) {
            return 1L;
        }
        if (!line.startsWith("$RD")) {
            return 2L;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            t = st.nextToken();
            long res = Long.parseLong(t);
            return res;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public int estraiVersione(String line) {
        if (line == null) {
            return 1;
        }
        if (!line.startsWith("$VER")) {
            return 1;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            int res = Integer.parseInt(t);
            return res;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public boolean riceviCan() {
        try {
            this.conn.write("$RD,000\n\r");
            String end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 000:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            long valore = this.estraiValoreRicevuto(end);
            switch ((int)valore) {
                case 0: {
                    this.sceltaBaud.setSelectedIndex(3);
                    break;
                }
                case 1: {
                    this.sceltaBaud.setSelectedIndex(2);
                    break;
                }
                case 3: {
                    this.sceltaBaud.setSelectedIndex(1);
                    break;
                }
                case 7: {
                    this.sceltaBaud.setSelectedIndex(0);
                    break;
                }
                default: {
                    this.sceltaBaud.setSelectedIndex(0);
                }
            }
            this.conn.write("$RD,001\n\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 001:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            String s = String.format("%03X", (int)valore);
            this.canFront.setText(s);
            this.conn.write("$RD,002\n\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 002:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            s = String.format("%03X", (int)valore);
            this.canRear.setText(s);
            this.conn.write("$RD,003\n\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 003:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            this.tipoMoto.setSelectedIndex((int)valore);
            if (this.versione < 2 && this.tipoMoto.getSelectedIndex() == 1) {
                JOptionPane.showMessageDialog(null, Language.string("Il firmware del ricevitore non supporta questo tipo di protocollo"), Language.string("Attenzione"), 2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (this.tipoMoto.getSelectedIndex() == 2) {
            this.canFront.setEnabled(true);
            this.canRear.setEnabled(true);
            this.sceltaBaud.setEnabled(true);
            this.canFrontLabel.setEnabled(true);
            this.canRearLabel.setEnabled(true);
            this.baudLabel.setEnabled(true);
        } else {
            if (this.tipoMoto.getSelectedIndex() == 1) {
                String s = String.format("%03X", 1536);
                this.canFront.setText(s);
                s = String.format("%03X", 1540);
                this.canRear.setText(s);
            }
            this.canFront.setEnabled(false);
            this.canRear.setEnabled(false);
            this.sceltaBaud.setEnabled(true);
            this.canFrontLabel.setEnabled(false);
            this.canRearLabel.setEnabled(false);
            this.baudLabel.setEnabled(false);
        }
        return true;
    }

    public boolean presenteFront(String id) {
        for (int i = 0; i < this.elencoSensoriLmFront.size(); ++i) {
            if (!((String)this.elencoSensoriLmFront.getElementAt(i)).equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean presenteRear(String id) {
        for (int i = 0; i < this.elencoSensoriLmRear.size(); ++i) {
            if (!((String)this.elencoSensoriLmRear.getElementAt(i)).equals(id)) continue;
            return true;
        }
        return false;
    }

    public void aggiungiSensoreFront() {
        String id = this.idTfFront.getText();
        for (int i = 0; i < this.elencoSensoriLmFront.size(); ++i) {
            if (!((String)this.elencoSensoriLmFront.getElementAt(i)).equals(id)) continue;
            return;
        }
        if (this.elencoSensoriLmFront.size() < 50) {
            this.elencoSensoriLmFront.addElement(id);
        }
    }

    public void aggiungiSensoreRear() {
        String id = this.idTfRear.getText();
        for (int i = 0; i < this.elencoSensoriLmRear.size(); ++i) {
            if (!((String)this.elencoSensoriLmRear.getElementAt(i)).equals(id)) continue;
            return;
        }
        if (this.elencoSensoriLmRear.size() < 50) {
            this.elencoSensoriLmRear.addElement(id);
        }
    }

    public void eliminaSensoreFront() {
        String id = this.idTfFront.getText();
        for (int i = 0; i < this.elencoSensoriLmFront.size(); ++i) {
            if (!((String)this.elencoSensoriLmFront.getElementAt(i)).equals(id)) continue;
            this.elencoSensoriLmFront.removeElementAt(i);
        }
    }

    public void eliminaSensoreRear() {
        String id = this.idTfRear.getText();
        for (int i = 0; i < this.elencoSensoriLmRear.size(); ++i) {
            if (!((String)this.elencoSensoriLmRear.getElementAt(i)).equals(id)) continue;
            this.elencoSensoriLmRear.removeElementAt(i);
        }
    }

    public boolean controllaID() {
        if (this.idTfRear.getText().contains(" ") || this.idTfFront.getText().contains(" ")) {
            JOptionPane.showMessageDialog(this, Language.string("Gli ID Tpms contengono spazi."), Language.string("ATTENZIONE"), 0);
            if (this.idTfRear.getText().contains(" ")) {
                this.idTfRear.setValue("0000000");
            }
            if (this.idTfFront.getText().contains(" ")) {
                this.idTfFront.setValue("0000000");
            }
            return false;
        }
        return true;
    }

    public boolean controllaFrasi() {
        if (this.canRear.getText().contains(" ") || this.canFront.getText().contains(" ")) {
            JOptionPane.showMessageDialog(this, Language.string("Gli ID CAN contengono spazi."), Language.string("ATTENZIONE"), 0);
            if (this.canRear.getText().contains(" ")) {
                this.canRear.setValue("699");
            }
            if (this.canFront.getText().contains(" ")) {
                this.canFront.setValue("698");
            }
            return false;
        }
        return true;
    }

    public void chiudiDialog() {
        if (this.connected) {
            this.disconnetti();
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.connettiB)) {
            if (this.connected) {
                this.disconnetti();
            } else {
                this.connetti();
            }
            this.azzeraLetturaRear();
            this.azzeraLetturaFront();
        }
        if (e.getSource().equals(this.modificaBFront)) {
            if (!this.controllaID()) {
                return;
            }
            this.aggiungiSensoreFront();
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.modificaBRear)) {
            if (!this.controllaID()) {
                return;
            }
            this.aggiungiSensoreRear();
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.eliminaBRear)) {
            this.eliminaSensoreRear();
            this.azzeraLetturaRear();
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.eliminaBFront)) {
            this.eliminaSensoreFront();
            this.azzeraLetturaFront();
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.allFront)) {
            this.elencoSensoriLmFront.clear();
            this.azzeraLetturaFront();
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.allRear)) {
            this.elencoSensoriLmRear.clear();
            this.azzeraLetturaRear();
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.applyB)) {
            if (!this.controllaFrasi()) {
                return;
            }
            this.applyB.setText("Writing..");
            this.applyB.setBackground(Color.red);
            this.attivaRicezioneDati(1);
        }
        if (e.getSource().equals(this.sceltaBaud)) {
            System.out.println("SCelta baud....");
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.tipoMoto)) {
            this.applyB.setEnabled(true);
            if (this.tipoMoto.getSelectedIndex() == 2) {
                this.canFront.setEnabled(true);
                this.canRear.setEnabled(true);
                this.sceltaBaud.setEnabled(true);
                this.canFrontLabel.setEnabled(true);
                this.canRearLabel.setEnabled(true);
                this.baudLabel.setEnabled(true);
            } else {
                String s;
                if (this.tipoMoto.getSelectedIndex() == 0) {
                    s = String.format("%03X", 1688);
                    this.canFront.setText(s);
                    s = String.format("%03X", 1689);
                    this.canRear.setText(s);
                }
                if (this.tipoMoto.getSelectedIndex() == 1) {
                    s = String.format("%03X", 1536);
                    this.canFront.setText(s);
                    s = String.format("%03X", 1540);
                    this.canRear.setText(s);
                }
                this.canFront.setEnabled(false);
                this.canRear.setEnabled(false);
                this.sceltaBaud.setEnabled(true);
                this.canFrontLabel.setEnabled(false);
                this.canRearLabel.setEnabled(false);
                this.baudLabel.setEnabled(false);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (this.listFront.getSelectedIndex() != -1) {
            this.idTfFront.setText("" + this.listFront.getSelectedValue());
        }
        if (arg0.getSource().equals(this.listFront)) {
            this.azzeraLetturaFront();
        }
        if (this.listRear.getSelectedIndex() != -1) {
            this.idTfRear.setText("" + this.listRear.getSelectedValue());
        }
        if (arg0.getSource().equals(this.listRear)) {
            this.azzeraLetturaRear();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connected) {
            this.disconnetti();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TpmsCanDialog t = new TpmsCanDialog(null, null);
        t.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.applyB.setEnabled(true);
    }
}

