/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

class StechioCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;
    double massimo = 1.5;
    double minimo = 0.5;

    public StechioCellRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    public void setMax(double max) {
        this.massimo = max;
    }

    public void setMin(double min) {
        this.minimo = min;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object f, boolean isSelected, boolean hasFocus, int row, int column) {
        Component original = super.getTableCellRendererComponent(table, f, isSelected, hasFocus, row, column);
        if (row == 0 || column == 0) {
            Font font = new Font("sansserif", 1, 12);
            this.setFont(font);
            original.setBackground(Color.WHITE);
        } else {
            if (f == null) {
                original.setBackground(Color.LIGHT_GRAY);
            } else {
                double indice;
                Double valore = Double.valueOf((String)f);
                double delta = this.massimo - this.minimo;
                if (delta == 0.0) {
                    delta = 1.0;
                }
                if ((indice = (valore - this.minimo) / delta) > 1.0) {
                    indice = 1.0;
                }
                if (indice < 0.0) {
                    indice = 0.0;
                }
                int R = (int)(indice * 255.0);
                int G = 255 - R;
                original.setBackground(new Color(R, G, 0));
            }
            if (isSelected) {
                original.setBackground(Color.yellow);
            }
        }
        return original;
    }
}

