/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.SettaggioCurva;
import i2m.Language;
import i2m.MainFrame;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.grafico.Curva;
import i2m.mappa.Mappa2D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SpecialPointDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JButton addB;
    private JButton esciB;
    private JButton rimuoviB;
    private JButton esportaB;
    private JButton importaB;
    private DefaultListModel elencoSettoriLM;
    private JFormattedTextField spazioTF;
    private JLabel posizioneLabel;
    private SincronizzatoreMappaGraficoVideo multiSincro;
    private JList list;
    private Vector<SettaggioCurva> elencoSettaggi;
    private JTabbedPane tabPrincipale;
    private JPanel pannelloCanali = new JPanel();
    private JComboBox canale1CB;
    private JComboBox canale2CB;
    private JComboBox canale3CB;
    private JComboBox canale4CB;
    private JComboBox canale5CB;

    public SpecialPointDialog(MainFrame owner) {
        super(owner, Language.string(Language.string("Punti speciali sulla mappa")), false);
        this.elencoSettoriLM = new DefaultListModel();
        this.elencoSettoriLM.clear();
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.tabPrincipale = new JTabbedPane();
        this.tabPrincipale.addChangeListener(this);
        this.tabPrincipale.addTab(Language.string("Punti"), pannelloPrincipale);
        this.tabPrincipale.addTab(Language.string("Canali"), this.pannelloCanali);
        this.setContentPane(this.tabPrincipale);
        this.addB = new JButton(Language.string("Aggiungi"));
        this.addB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.rimuoviB = new JButton(Language.string("Rimuovi"));
        this.rimuoviB.addActionListener(this);
        this.posizioneLabel = new JLabel(Language.string("    Posizione (m):"));
        this.esportaB = new JButton(Language.string("Esporta"));
        this.esportaB.addActionListener(this);
        this.importaB = new JButton(Language.string("Importa"));
        this.importaB.addActionListener(this);
        NumberFormat TFormat = NumberFormat.getNumberInstance(Locale.US);
        TFormat.setMaximumIntegerDigits(10);
        TFormat.setMaximumFractionDigits(0);
        TFormat.setGroupingUsed(false);
        this.spazioTF = new JFormattedTextField(TFormat);
        this.spazioTF.setValue(0);
        this.spazioTF.setHorizontalAlignment(4);
        JPanel pannelloBottoni = new JPanel();
        JPanel pannelloTesto = new JPanel();
        JPanel pannelloImportazione = new JPanel();
        GridLayout bottoniLayout = new GridLayout(1, 3, 2, 2);
        pannelloBottoni.setLayout(bottoniLayout);
        pannelloBottoni.add(this.addB);
        pannelloBottoni.add(this.rimuoviB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        GridLayout importazioneLayout = new GridLayout(1, 2, 2, 2);
        pannelloImportazione.setLayout(importazioneLayout);
        pannelloImportazione.add(this.importaB);
        pannelloImportazione.add(this.esportaB);
        pannelloImportazione.setBorder(BorderFactory.createEtchedBorder(0));
        GridLayout posizioneLayout = new GridLayout(1, 2, 2, 2);
        pannelloTesto.setLayout(posizioneLayout);
        pannelloTesto.add(this.posizioneLabel);
        pannelloTesto.add(this.spazioTF);
        this.list = new JList(this.elencoSettoriLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setFont(new Font("Courier", 0, 13));
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        JPanel pannelloLista = new JPanel(new BorderLayout());
        pannelloLista.add((Component)listScroller, "Center");
        pannelloLista.add((Component)pannelloTesto, "South");
        pannelloPrincipale.add((Component)pannelloImportazione, "North");
        pannelloPrincipale.add((Component)pannelloLista, "Center");
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.pannelloCanali.setLayout(new GridLayout(5, 2, 0, 10));
        JLabel label1 = new JLabel(Language.string("   Posizione 1 : "));
        JLabel label2 = new JLabel(Language.string("   Posizione 2 : "));
        JLabel label3 = new JLabel(Language.string("   Posizione 3 : "));
        JLabel label4 = new JLabel(Language.string("   Posizione 4 : "));
        JLabel label5 = new JLabel(Language.string("   Posizione 5 : "));
        this.canale1CB = new JComboBox();
        this.canale2CB = new JComboBox();
        this.canale3CB = new JComboBox();
        this.canale4CB = new JComboBox();
        this.canale5CB = new JComboBox();
        this.aggiornaNomi();
        this.canale1CB.setSelectedIndex(0);
        this.canale1CB.setMaximumSize(new Dimension(120, 20));
        this.canale1CB.addActionListener(this);
        this.canale2CB.setSelectedIndex(0);
        this.canale2CB.setMaximumSize(new Dimension(120, 20));
        this.canale2CB.addActionListener(this);
        this.canale3CB.setSelectedIndex(0);
        this.canale3CB.setMaximumSize(new Dimension(120, 20));
        this.canale3CB.addActionListener(this);
        this.canale4CB.setSelectedIndex(0);
        this.canale4CB.setMaximumSize(new Dimension(120, 20));
        this.canale4CB.addActionListener(this);
        this.canale5CB.setSelectedIndex(0);
        this.canale5CB.setMaximumSize(new Dimension(120, 20));
        this.canale5CB.addActionListener(this);
        this.pannelloCanali.add(label1);
        this.pannelloCanali.add(this.canale1CB);
        this.pannelloCanali.add(label2);
        this.pannelloCanali.add(this.canale2CB);
        this.pannelloCanali.add(label3);
        this.pannelloCanali.add(this.canale3CB);
        this.pannelloCanali.add(label4);
        this.pannelloCanali.add(this.canale4CB);
        this.pannelloCanali.add(label5);
        this.pannelloCanali.add(this.canale5CB);
        this.pack();
        this.setSize(new Dimension(300, 230));
        this.elencoSettaggi = new Vector();
        if (DanasDataStructure.getInstance().getDefaultLap() == null) {
            JOptionPane.showMessageDialog(null, Language.string("Nessun giro di default presente"), Language.string("Attenzione"), 2);
            return;
        }
        this.caricaElencoDistanze();
        this.aggiornaCombo();
    }

    public void aggiornaNomi() {
        this.canale1CB.removeAllItems();
        this.canale2CB.removeAllItems();
        this.canale3CB.removeAllItems();
        this.canale4CB.removeAllItems();
        this.canale5CB.removeAllItems();
        for (int i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            this.canale1CB.addItem(MeasuresUtil.getNomeCanale(i));
            this.canale2CB.addItem(MeasuresUtil.getNomeCanale(i));
            this.canale3CB.addItem(MeasuresUtil.getNomeCanale(i));
            this.canale4CB.addItem(MeasuresUtil.getNomeCanale(i));
            this.canale5CB.addItem(MeasuresUtil.getNomeCanale(i));
        }
    }

    private void aggiornaCombo() {
        this.canale1CB.setSelectedIndex(this.getIndiceReale(DanasPreferences.getPrefCanaleBox(1)));
        this.canale2CB.setSelectedIndex(this.getIndiceReale(DanasPreferences.getPrefCanaleBox(2)));
        this.canale3CB.setSelectedIndex(this.getIndiceReale(DanasPreferences.getPrefCanaleBox(3)));
        this.canale4CB.setSelectedIndex(this.getIndiceReale(DanasPreferences.getPrefCanaleBox(4)));
        this.canale5CB.setSelectedIndex(this.getIndiceReale(DanasPreferences.getPrefCanaleBox(5)));
    }

    public DanasDataStructureConstants.ValueType getValueType(int canale) {
        int indice = 0;
        switch (canale) {
            case 1: {
                indice = this.canale1CB.getSelectedIndex();
                break;
            }
            case 2: {
                indice = this.canale2CB.getSelectedIndex();
                break;
            }
            case 3: {
                indice = this.canale3CB.getSelectedIndex();
                break;
            }
            case 4: {
                indice = this.canale4CB.getSelectedIndex();
                break;
            }
            case 5: {
                indice = this.canale5CB.getSelectedIndex();
            }
        }
        return MeasuresUtil.getValueType(indice);
    }

    private int getIndiceReale(int indice) {
        return MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.values()[indice]);
    }

    private void caricaElencoDistanze() {
        int spazio = 0;
        int spazioGps = 0;
        int[] elenco = DanasDataStructure.getElencoDistanze();
        if (elenco == null) {
            return;
        }
        for (int j = 0; j < elenco.length; ++j) {
            spazioGps = spazio = elenco[j];
            for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                if (this.elencoSettaggi.get(i).getSpazioGps() != spazio) continue;
                this.rimuoviSettaggio(i);
            }
            SettaggioCurva set = new SettaggioCurva(spazio, spazioGps, 0, 0, 0, 0, 0);
            this.elencoSettaggi.add(set);
            Collections.sort(this.elencoSettaggi);
            this.elencoSettoriLM.clear();
            for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                this.elencoSettoriLM.addElement(this.getStringaSettaggio(this.elencoSettaggi.get(i)));
            }
        }
    }

    public void impostaCursoreGPS(int metri) {
        DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
        if (l == null) {
            return;
        }
        DanasSession s = l.getSession();
        List<Double> spazio = l.getValoriSpazio();
        double tempo = 0.0;
        for (int i = 1; i < spazio.size(); ++i) {
            if (!(spazio.get(i) >= (double)metri)) continue;
            double inizio = l.getTempoPrimoDato();
            tempo = (double)i * s.getRisoluzioneTemporale() + inizio;
            if (!DanasDataStructure.getInstance().getMainFrame().getVisualizzazioneGrafico()) {
                tempo -= DanasDataStructure.getInstance().getDefaultLap().getStart();
                break;
            }
            tempo -= DanasDataStructure.getInstance().getDefaultLap().getSession().getStartTelemetryTime().doubleValue();
            break;
        }
        this.multiSincro.setPosizioneCursore((int)tempo);
        this.multiSincro.setAggiornaPosizioneCursore(true);
    }

    public void setMultisincro(SincronizzatoreMappaGraficoVideo multi) {
        this.multiSincro = multi;
        this.multiSincro.addChangeListener(this);
        Mappa2D mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
        if (mappa.getNumeroTracciati() != 1 || mappa.getModoVisualizzazioni() == 1 || DanasDataStructure.getInstance().getDefaultLap() == null) {
            JOptionPane.showMessageDialog(null, Language.string("Funzione disponibile solo in modalit\u00e0 giri e con solo il giro di default visualizzato."), Language.string("Attenzione"), 2);
            this.dispose();
        }
    }

    public void esporta() {
        JFileChooser fileChooser = new JFileChooser();
        int res = fileChooser.showSaveDialog(this);
        if (res == 0) {
            File f;
            String nome = fileChooser.getSelectedFile().toString();
            if (!nome.endsWith(".txt")) {
                nome = nome + ".txt";
            }
            if (!(f = new File(nome)).isAbsolute()) {
                f = new File(f.getAbsolutePath());
            }
            if (f.exists() && f.canWrite()) {
                int resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Sovrascrivere il file esistente?"), Language.string("ATTENZIONE"), 0);
                if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                    return;
                }
            } else if (f.exists() || !f.getParentFile().exists() || !f.getParentFile().isDirectory() || !f.getParentFile().canWrite()) {
                JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
                return;
            }
            try {
                PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
                for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                    out.println(this.elencoSettaggi.get(i).getStringa());
                }
                out.close();
                JOptionPane.showMessageDialog(this, Language.string("Configurazione salvata correttamente"), Language.string("INFO"), 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Percorso non valido"), Language.string("ATTENZIONE"), 0);
                ex.printStackTrace();
            }
        }
    }

    public void modificaSettaggio(int index) {
        if (index == -1) {
            return;
        }
        String s = "" + this.elencoSettaggi.get(index).getSpazioGps();
        this.spazioTF.setText(s);
        this.impostaCursoreGPS(this.elencoSettaggi.get(index).getSpazioGps());
    }

    public int[] creaElenco() {
        int[] elenco = new int[this.elencoSettaggi.size()];
        for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
            elenco[i] = this.elencoSettaggi.get(i).getSpazio();
        }
        return elenco;
    }

    public void aggiungiSettaggio() {
        int spazio = 0;
        int spazioGps = 0;
        spazioGps = spazio = Integer.valueOf(this.spazioTF.getText()).intValue();
        for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
            if (this.elencoSettaggi.get(i).getSpazioGps() != spazio) continue;
            this.rimuoviSettaggio(i);
        }
        SettaggioCurva set = new SettaggioCurva(spazio, spazioGps, 0, 0, 0, 0, 0);
        this.elencoSettaggi.add(set);
        Collections.sort(this.elencoSettaggi);
        this.elencoSettoriLM.clear();
        for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
            this.elencoSettoriLM.addElement(this.getStringaSettaggio(this.elencoSettaggi.get(i)));
        }
    }

    public void rimuoviSettaggio(int index) {
        if (index != -1) {
            this.elencoSettaggi.remove(index);
            Collections.sort(this.elencoSettaggi);
            this.elencoSettoriLM.clear();
            for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                this.elencoSettoriLM.addElement(this.getStringaSettaggio(this.elencoSettaggi.get(i)));
            }
        }
    }

    public String getStringaSettaggio(SettaggioCurva set) {
        String s = "   Punto, distanza Gps:" + this.getStringaSpazio(set.getSpazioGps());
        return s;
    }

    public void importa() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Configurazione punti speciali", "txt"));
        int res = fileChooser.showOpenDialog(this);
        if (res == 0) {
            File f = fileChooser.getSelectedFile();
            try {
                f.setReadable(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                this.elencoSettaggi.removeAllElements();
                while ((line = in.readLine()) != null) {
                    if (!line.startsWith("DDS_S,")) continue;
                    SettaggioCurva set = new SettaggioCurva(line);
                    this.elencoSettaggi.add(set);
                }
                in.close();
                Collections.sort(this.elencoSettaggi);
                this.elencoSettoriLM.clear();
                for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                    this.elencoSettoriLM.addElement(this.getStringaSettaggio(this.elencoSettaggi.get(i)));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getStringaSpazio(int space) {
        if (space < 10) {
            String s = "    " + space;
            return s;
        }
        if (space < 100) {
            String s = "   " + space;
            return s;
        }
        if (space < 1000) {
            String s = "  " + space;
            return s;
        }
        String s = " " + space;
        return s;
    }

    public double convertiTempoInSpazio(double tempo) {
        if (DanasDataStructure.getInstance().getDefaultLap() == null) {
            return 0.0;
        }
        Curva curvaDefault = DanasDataStructure.getInstance().getCurvaLap(DanasDataStructureConstants.ValueType.VEL_GPS, DanasDataStructure.getInstance().getDefaultLap().getSession().getSessionID(), DanasDataStructure.getInstance().getDefaultLap().getLapID());
        if (curvaDefault == null) {
            return 0.0;
        }
        double[] space = curvaDefault.getAsseX();
        double[] time = curvaDefault.getAsseT();
        if (time.length == 0) {
            return 0.0;
        }
        for (int i = 1; i < time.length; ++i) {
            if (!(time[i] > tempo)) continue;
            double s1 = time[i] - tempo;
            double s2 = tempo - time[i - 1];
            double sp1 = space[i];
            double sp2 = space[i - 1];
            return s2 / (s2 + s1) * (sp1 - sp2) + sp2;
        }
        return space[space.length - 1];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Mappa2D mappa;
        int[] elenco;
        if (e.getSource().equals(this.addB)) {
            this.aggiungiSettaggio();
            elenco = this.creaElenco();
            DanasDataStructure.setElencoDistanze(elenco);
            DanasDataStructure.getInstance().getMainFrame().aggiornaDatiPersonalizzati();
        }
        if (e.getSource().equals(this.rimuoviB)) {
            this.rimuoviSettaggio(this.list.getSelectedIndex());
            elenco = this.creaElenco();
            DanasDataStructure.setElencoDistanze(elenco);
            DanasDataStructure.getInstance().getMainFrame().aggiornaDatiPersonalizzati();
        }
        if (e.getSource().equals(this.esciB)) {
            this.dispose();
        }
        if (e.getSource().equals(this.esportaB)) {
            this.esporta();
        }
        if (e.getSource().equals(this.importaB)) {
            this.importa();
        }
        if (e.getSource().equals(this.canale1CB)) {
            mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
            mappa.setParametroBox(this.getValueType(1), 1);
            DanasDataStructure.getInstance().getMainFrame().aggiornaDatiPersonalizzati();
        }
        if (e.getSource().equals(this.canale2CB)) {
            mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
            mappa.setParametroBox(this.getValueType(2), 2);
            DanasDataStructure.getInstance().getMainFrame().aggiornaDatiPersonalizzati();
        }
        if (e.getSource().equals(this.canale3CB)) {
            mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
            mappa.setParametroBox(this.getValueType(3), 3);
            DanasDataStructure.getInstance().getMainFrame().aggiornaDatiPersonalizzati();
        }
        if (e.getSource().equals(this.canale4CB)) {
            mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
            mappa.setParametroBox(this.getValueType(4), 4);
            DanasDataStructure.getInstance().getMainFrame().aggiornaDatiPersonalizzati();
        }
        if (e.getSource().equals(this.canale5CB)) {
            mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
            mappa.setParametroBox(this.getValueType(5), 5);
            DanasDataStructure.getInstance().getMainFrame().aggiornaDatiPersonalizzati();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SpecialPointDialog t = new SpecialPointDialog(null);
        t.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource().equals(this.multiSincro)) {
            if (!this.multiSincro.getAggionrnaMappaGrafico()) {
                return;
            }
            this.spazioTF.setText("" + (int)this.convertiTempoInSpazio(this.multiSincro.getPosizioneCursore()));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (this.list.getSelectedIndex() != -1) {
            this.modificaSettaggio(this.list.getSelectedIndex());
        }
    }

    public static enum KindOfBike {
        ZX10R_2016;

    }
}

