/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasParserTask;
import i2m.DataStructure.danasDataStructure.DanasSessionSettings;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.HwDasy6;
import i2m.Dialog.SDLoadDialog;
import i2m.Language;
import i2m.onLine.DeviceConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;

public class SettingsDasyX
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String DanasParseTask = null;
    JButton annullaB;
    JButton scriviSdB;
    JButton caricaSdB;
    JButton leggiDasy;
    JButton scriviDasy;
    JButton testB;
    JCheckBox remotoCB;
    JCheckBox vel1CB;
    JCheckBox rpmCB;
    JCheckBox velGpsCB;
    JCheckBox condizioneAndCB;
    JCheckBox settingsCB;
    JFormattedTextField campionamento;
    JFormattedTextField rpmTF;
    JFormattedTextField vel1TF;
    JFormattedTextField vel2TF;
    JFormattedTextField velocitaMinimaTF;
    JFormattedTextField velocitaGPSMinimaTF;
    JFormattedTextField rpmMinimaTF;
    JFormattedTextField dentiPignoneTF;
    JFormattedTextField dentiCoronaTF;
    JFormattedTextField circonferenzaTF;
    JFormattedTextField tempoMinimoTF;
    public JComboBox comboMoto;
    JLabel label1;
    JLabel label2;
    JLabel label3;
    JLabel label4;
    JLabel label5;
    JLabel label6;
    JLabel label7;
    JLabel label8;
    JLabel label9;
    JLabel label10;
    JLabel label11;
    JLabel label12;
    JLabel label13;
    JLabel label14;
    JLabel label15;
    JLabel label16;
    JLabel label17;
    private DeviceConnection conn;
    String parametroSbagliato = null;
    boolean parametriLetti = false;
    DanasSessionSettings settaggioAttuale;

    public SettingsDasyX(Frame owner) {
        super(owner, Language.string("Settaggi Hardware Dasy-X"), true);
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.annullaB = new JButton(Language.string("Annulla"));
        this.annullaB.addActionListener(this);
        this.scriviSdB = new JButton(Language.string("Salva su UsbKey"));
        this.scriviSdB.addActionListener(this);
        this.caricaSdB = new JButton(Language.string("Carica da UsbKey"));
        this.caricaSdB.addActionListener(this);
        this.leggiDasy = new JButton(Language.string("Leggi da Dasy-X"));
        this.leggiDasy.addActionListener(this);
        this.scriviDasy = new JButton(Language.string("Scrivi su Dasy-X"));
        this.scriviDasy.addActionListener(this);
        this.testB = new JButton(Language.string("Test Lap output"));
        this.testB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.annullaB);
        pannelloBottoni.add(this.leggiDasy);
        pannelloBottoni.add(this.scriviDasy);
        pannelloBottoni.add(this.testB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        JPanel pannelloSopra = new JPanel();
        pannelloSopra.setLayout(new BoxLayout(pannelloSopra, 0));
        JPanel pannelloMinimi = new JPanel();
        pannelloMinimi.setLayout(new BoxLayout(pannelloMinimi, 1));
        Border blackline = BorderFactory.createEtchedBorder(0);
        pannelloMinimi.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Valori minimi")));
        pannelloMinimi.setAlignmentY(0.0f);
        JPanel pannelloStart = new JPanel();
        pannelloStart.setLayout(new BoxLayout(pannelloStart, 1));
        pannelloStart.setBorder(BorderFactory.createTitledBorder(blackline, "Autostart"));
        pannelloStart.setAlignmentY(0.0f);
        JPanel pannelloCampionamento = new JPanel();
        pannelloCampionamento.setLayout(new BoxLayout(pannelloCampionamento, 1));
        pannelloCampionamento.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Campionamento")));
        pannelloCampionamento.setAlignmentY(0.0f);
        JPanel pannelloImpulsi = new JPanel();
        pannelloImpulsi.setLayout(new BoxLayout(pannelloImpulsi, 1));
        pannelloImpulsi.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Impulsi")));
        pannelloImpulsi.setAlignmentY(0.0f);
        JPanel pannelloMoto = new JPanel();
        pannelloMoto.setLayout(new BoxLayout(pannelloMoto, 1));
        pannelloMoto.setBorder(BorderFactory.createTitledBorder(blackline, Language.string("Tipo Moto")));
        pannelloMoto.setAlignmentY(0.0f);
        pannelloSopra.add(pannelloStart);
        pannelloSopra.add(pannelloMinimi);
        pannelloSopra.add(pannelloCampionamento);
        pannelloSopra.add(pannelloImpulsi);
        pannelloSopra.add(pannelloMoto);
        NumberFormat TFormat = NumberFormat.getNumberInstance(Locale.US);
        TFormat.setMaximumIntegerDigits(10);
        TFormat.setMaximumFractionDigits(0);
        TFormat.setGroupingUsed(false);
        pannelloMinimi.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel panel = new JPanel();
        panel.setAlignmentY(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.label1 = new JLabel(Language.string("Velocit\u00e0 (km/h) >       "));
        this.label1.setAlignmentY(0.0f);
        this.velocitaMinimaTF = new JFormattedTextField(TFormat);
        this.velocitaMinimaTF.setHorizontalAlignment(11);
        this.velocitaMinimaTF.setAlignmentY(0.0f);
        this.velocitaMinimaTF.setMaximumSize(new Dimension(60, 20));
        this.velocitaMinimaTF.setPreferredSize(new Dimension(60, 20));
        this.velocitaMinimaTF.setMinimumSize(new Dimension(60, 20));
        this.velocitaMinimaTF.setValue(5);
        this.label1.setLabelFor(this.velocitaMinimaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label1);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.velocitaMinimaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloMinimi.add(panel);
        pannelloMinimi.add(Box.createRigidArea(new Dimension(0, 5)));
        panel = new JPanel();
        panel.setAlignmentY(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.label2 = new JLabel(Language.string("Velocit\u00e0 GPS (km/h) >"));
        this.label2.setAlignmentY(0.0f);
        this.velocitaGPSMinimaTF = new JFormattedTextField(TFormat);
        this.velocitaGPSMinimaTF.setHorizontalAlignment(11);
        this.velocitaGPSMinimaTF.setAlignmentY(0.0f);
        this.velocitaGPSMinimaTF.setMaximumSize(new Dimension(60, 20));
        this.velocitaGPSMinimaTF.setPreferredSize(new Dimension(60, 20));
        this.velocitaGPSMinimaTF.setMinimumSize(new Dimension(60, 20));
        this.velocitaGPSMinimaTF.setValue(5);
        this.label2.setLabelFor(this.velocitaMinimaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label2);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.velocitaGPSMinimaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloMinimi.add(panel);
        pannelloMinimi.add(Box.createRigidArea(new Dimension(0, 5)));
        panel = new JPanel();
        panel.setAlignmentY(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.label3 = new JLabel("RPM (rpm)  >                ");
        this.label3.setAlignmentY(0.0f);
        this.rpmMinimaTF = new JFormattedTextField(TFormat);
        this.rpmMinimaTF.setHorizontalAlignment(11);
        this.rpmMinimaTF.setAlignmentY(0.0f);
        this.rpmMinimaTF.setMaximumSize(new Dimension(60, 20));
        this.rpmMinimaTF.setPreferredSize(new Dimension(60, 20));
        this.rpmMinimaTF.setMinimumSize(new Dimension(60, 20));
        this.rpmMinimaTF.setValue(4000);
        this.label3.setLabelFor(this.rpmMinimaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label3);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.rpmMinimaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloMinimi.add(panel);
        pannelloMinimi.add(Box.createRigidArea(new Dimension(0, 25)));
        panel = new JPanel();
        panel.setAlignmentY(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.label4 = new JLabel(Language.string("Numero denti pignone:         "));
        this.label4.setAlignmentY(0.0f);
        this.dentiPignoneTF = new JFormattedTextField(TFormat);
        this.dentiPignoneTF.setHorizontalAlignment(11);
        this.dentiPignoneTF.setAlignmentY(0.0f);
        this.dentiPignoneTF.setMaximumSize(new Dimension(60, 20));
        this.dentiPignoneTF.setPreferredSize(new Dimension(60, 20));
        this.dentiPignoneTF.setMinimumSize(new Dimension(60, 20));
        this.dentiPignoneTF.setValue(16);
        this.label4.setLabelFor(this.dentiPignoneTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label4);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.dentiPignoneTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloMinimi.add(panel);
        pannelloMinimi.add(Box.createRigidArea(new Dimension(0, 5)));
        panel = new JPanel();
        panel.setAlignmentY(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.label5 = new JLabel(Language.string("Numero denti corona:           "));
        this.label5.setAlignmentY(0.0f);
        this.dentiCoronaTF = new JFormattedTextField(TFormat);
        this.dentiCoronaTF.setHorizontalAlignment(11);
        this.dentiCoronaTF.setAlignmentY(0.0f);
        this.dentiCoronaTF.setMaximumSize(new Dimension(60, 20));
        this.dentiCoronaTF.setPreferredSize(new Dimension(60, 20));
        this.dentiCoronaTF.setMinimumSize(new Dimension(60, 20));
        this.dentiCoronaTF.setValue(45);
        this.label5.setLabelFor(this.dentiCoronaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label5);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.dentiCoronaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloMinimi.add(panel);
        pannelloMinimi.add(Box.createRigidArea(new Dimension(0, 5)));
        panel = new JPanel();
        panel.setAlignmentY(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.label6 = new JLabel(Language.string("Circonferenza ruota (mm) :"));
        this.label6.setAlignmentY(0.0f);
        this.circonferenzaTF = new JFormattedTextField(TFormat);
        this.circonferenzaTF.setHorizontalAlignment(11);
        this.circonferenzaTF.setAlignmentY(0.0f);
        this.circonferenzaTF.setMaximumSize(new Dimension(60, 20));
        this.circonferenzaTF.setPreferredSize(new Dimension(60, 20));
        this.circonferenzaTF.setMinimumSize(new Dimension(60, 20));
        this.circonferenzaTF.setValue(2000);
        this.label6.setLabelFor(this.rpmMinimaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label6);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.circonferenzaTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloMinimi.add(panel);
        pannelloMinimi.add(Box.createRigidArea(new Dimension(0, 33)));
        this.label1.setForeground(Color.GRAY);
        this.label3.setForeground(Color.GRAY);
        this.label4.setForeground(Color.GRAY);
        this.label5.setForeground(Color.GRAY);
        this.label6.setForeground(Color.GRAY);
        this.velocitaMinimaTF.setEnabled(false);
        this.dentiPignoneTF.setEnabled(false);
        this.dentiCoronaTF.setEnabled(false);
        this.circonferenzaTF.setEnabled(false);
        this.rpmMinimaTF.setEnabled(false);
        this.remotoCB = new JCheckBox(Language.string("Comando remoto"));
        this.remotoCB.addActionListener(this);
        this.remotoCB.setAlignmentY(0.0f);
        this.vel1CB = new JCheckBox(Language.string("Vel1"));
        this.vel1CB.addActionListener(this);
        this.vel1CB.setAlignmentY(0.0f);
        this.rpmCB = new JCheckBox(Language.string("RPM"));
        this.rpmCB.addActionListener(this);
        this.rpmCB.setAlignmentY(0.0f);
        this.velGpsCB = new JCheckBox(Language.string("Vel. GPS"));
        this.velGpsCB.addActionListener(this);
        this.velGpsCB.setSelected(false);
        this.velGpsCB.setAlignmentY(0.0f);
        this.condizioneAndCB = new JCheckBox(Language.string("Tutte rispettate"));
        this.condizioneAndCB.setAlignmentY(0.0f);
        pannelloStart.add(Box.createRigidArea(new Dimension(0, 5)));
        this.label17 = new JLabel(Language.string("Inizia campionamento con:"));
        pannelloStart.add(this.label17);
        pannelloStart.add(Box.createRigidArea(new Dimension(0, 5)));
        pannelloStart.add(this.vel1CB);
        pannelloStart.add(this.rpmCB);
        pannelloStart.add(this.velGpsCB);
        pannelloStart.add(Box.createRigidArea(new Dimension(0, 33)));
        this.label12 = new JLabel(Language.string("Campiona solo se:"));
        pannelloStart.add(this.label12);
        pannelloStart.add(Box.createRigidArea(new Dimension(0, 5)));
        pannelloStart.add(this.condizioneAndCB);
        pannelloStart.add(Box.createRigidArea(new Dimension(0, 10)));
        this.label16 = new JLabel(Language.string("Per almeno (sec. 3-10):"));
        pannelloStart.add(this.label16);
        pannelloStart.add(Box.createRigidArea(new Dimension(0, 5)));
        this.tempoMinimoTF = new JFormattedTextField(TFormat);
        this.tempoMinimoTF.setValue(3);
        this.tempoMinimoTF.setHorizontalAlignment(11);
        this.tempoMinimoTF.setAlignmentX(0.0f);
        this.tempoMinimoTF.setMinimumSize(new Dimension(150, 20));
        this.tempoMinimoTF.setPreferredSize(new Dimension(150, 20));
        this.tempoMinimoTF.setMaximumSize(new Dimension(150, 20));
        pannelloStart.add(this.tempoMinimoTF);
        pannelloStart.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloCampionamento.add(Box.createRigidArea(new Dimension(0, 5)));
        this.label10 = new JLabel(Language.string("  Tempo campionamento (1-500): "));
        this.label10.setAlignmentX(0.0f);
        this.label11 = new JLabel(Language.string("  in centesimi di secondo "));
        this.label11.setAlignmentX(0.0f);
        pannelloCampionamento.add(this.label10);
        pannelloCampionamento.add(this.label11);
        pannelloCampionamento.add(Box.createRigidArea(new Dimension(0, 20)));
        JPanel pannelloInterno = new JPanel();
        pannelloInterno.setLayout(new BoxLayout(pannelloInterno, 0));
        this.campionamento = new JFormattedTextField(TFormat);
        this.campionamento.setValue(10);
        this.campionamento.setHorizontalAlignment(11);
        this.campionamento.setAlignmentX(0.0f);
        this.campionamento.setMinimumSize(new Dimension(80, 20));
        this.campionamento.setPreferredSize(new Dimension(80, 20));
        this.campionamento.setMaximumSize(new Dimension(80, 20));
        pannelloInterno.setAlignmentX(0.0f);
        pannelloInterno.add(Box.createRigidArea(new Dimension(80, 0)));
        pannelloInterno.add(this.campionamento);
        pannelloCampionamento.add(pannelloInterno);
        pannelloCampionamento.add(Box.createRigidArea(new Dimension(0, 161)));
        pannelloImpulsi.add(Box.createRigidArea(new Dimension(0, 5)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.label7 = new JLabel(Language.string("Impulsi  RPM:"));
        this.rpmTF = new JFormattedTextField(TFormat);
        this.rpmTF.setHorizontalAlignment(11);
        this.rpmTF.setMaximumSize(new Dimension(60, 20));
        this.rpmTF.setPreferredSize(new Dimension(60, 20));
        this.rpmTF.setMinimumSize(new Dimension(60, 20));
        this.rpmTF.setValue(1);
        this.label7.setLabelFor(this.rpmTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label7);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.rpmTF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloImpulsi.add(panel);
        pannelloImpulsi.add(Box.createRigidArea(new Dimension(0, 25)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.label8 = new JLabel(Language.string("Impulsi Vel1:"));
        this.vel1TF = new JFormattedTextField(TFormat);
        this.vel1TF.setHorizontalAlignment(11);
        this.vel1TF.setMaximumSize(new Dimension(60, 20));
        this.vel1TF.setPreferredSize(new Dimension(60, 20));
        this.vel1TF.setMinimumSize(new Dimension(60, 20));
        this.vel1TF.setValue(4);
        this.label8.setLabelFor(this.vel1TF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label8);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.vel1TF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloImpulsi.add(panel);
        pannelloImpulsi.add(Box.createRigidArea(new Dimension(0, 25)));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.label9 = new JLabel(Language.string("Impulsi Vel2:"));
        this.vel2TF = new JFormattedTextField(TFormat);
        this.vel2TF.setHorizontalAlignment(11);
        this.vel2TF.setMaximumSize(new Dimension(60, 20));
        this.vel2TF.setPreferredSize(new Dimension(60, 20));
        this.vel2TF.setMinimumSize(new Dimension(60, 20));
        this.vel2TF.setValue(4);
        this.label9.setLabelFor(this.vel2TF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.label9);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        panel.add(this.vel2TF);
        panel.add(Box.createRigidArea(new Dimension(5, 10)));
        pannelloImpulsi.add(panel);
        pannelloImpulsi.add(Box.createRigidArea(new Dimension(0, 123)));
        String[] baudList = new String[]{"Default", "Kawasaki ZX10R", "Kawasaki ZX10R Race", "BMW S1000RR", "BMW HP4", "BMW HL", "MV F3", "Ducati 1198", "Panigale", "RSV4 APRC", "Yamaha R1 2015/R6 2017", "BMW >2015"};
        this.label15 = new JLabel(Language.string(" Tipo di Moto:"));
        this.label15.setAlignmentX(0.0f);
        pannelloInterno = new JPanel();
        pannelloInterno.setLayout(new BoxLayout(pannelloInterno, 0));
        this.comboMoto = new JComboBox<String>(baudList);
        this.comboMoto.setSelectedIndex(0);
        this.comboMoto.setAlignmentX(0.0f);
        this.comboMoto.setMinimumSize(new Dimension(170, 20));
        this.comboMoto.setPreferredSize(new Dimension(170, 20));
        this.comboMoto.setMaximumSize(new Dimension(170, 20));
        this.comboMoto.setEnabled(false);
        this.comboMoto.addActionListener(this);
        this.label15.setLabelFor(this.comboMoto);
        this.settingsCB = new JCheckBox(Language.string("Sovrascrivi tutti i settaggi"));
        this.settingsCB.setSelected(true);
        this.settingsCB.setAlignmentY(0.0f);
        this.settingsCB.setEnabled(false);
        pannelloInterno.setAlignmentX(0.0f);
        pannelloInterno.add(Box.createRigidArea(new Dimension(10, 0)));
        pannelloInterno.add(this.label15);
        pannelloInterno.add(Box.createRigidArea(new Dimension(10, 0)));
        pannelloInterno.add(this.comboMoto);
        pannelloMoto.add(Box.createRigidArea(new Dimension(0, 5)));
        pannelloMoto.add(pannelloInterno);
        pannelloMoto.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloMoto.add(this.settingsCB);
        pannelloMoto.add(Box.createRigidArea(new Dimension(0, 180)));
        pannelloPrincipale.add((Component)pannelloSopra, "Center");
        this.trovaSettaggiDefault();
        this.pack();
        if (this.comboMoto.getSelectedIndex() != 0) {
            this.dentiPignoneTF.setValue(1);
            this.dentiCoronaTF.setValue(1);
        }
        this.abilitaTutto(false);
        this.conn = new DeviceConnection(DanasPreferences.getPrefCom());
    }

    private void trovaSettaggiDefault() {
        this.settaggioAttuale = new DanasSessionSettings();
        File f = new File("./defaultSettings.dfs");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                line.replace(" ", "");
                if (line.startsWith("$SETTAGGIBASE")) {
                    DanasParserTask.parseSettaggiBase(line, this.settaggioAttuale);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dentiPignoneTF.setValue(this.settaggioAttuale.getPinion(1));
        this.dentiCoronaTF.setValue(this.settaggioAttuale.getGearTeeth(1));
        int tipoMoto = this.settaggioAttuale.getTipoMoto();
        this.setIndexComboMoto(tipoMoto);
    }

    private void setIndexComboMoto(int moto) {
        switch (moto) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.comboMoto.setSelectedIndex(0);
                break;
            }
            case 14: {
                this.comboMoto.setSelectedIndex(1);
                break;
            }
            case 21: 
            case 22: {
                this.comboMoto.setSelectedIndex(2);
                break;
            }
            case 15: 
            case 16: {
                this.comboMoto.setSelectedIndex(3);
                break;
            }
            case 19: {
                this.comboMoto.setSelectedIndex(4);
                break;
            }
            case 20: {
                this.comboMoto.setSelectedIndex(5);
                break;
            }
            case 17: 
            case 18: {
                this.comboMoto.setSelectedIndex(7);
                break;
            }
            case 29: {
                this.comboMoto.setSelectedIndex(6);
                break;
            }
            case 38: 
            case 39: {
                this.comboMoto.setSelectedIndex(8);
                break;
            }
            case 40: {
                this.comboMoto.setSelectedIndex(9);
                break;
            }
            case 44: 
            case 45: {
                this.comboMoto.setSelectedIndex(10);
                break;
            }
            case 43: {
                this.comboMoto.setSelectedIndex(11);
                break;
            }
            default: {
                this.comboMoto.setSelectedIndex(0);
            }
        }
    }

    private void setIndexComboCan(int tipoCan) {
        switch (tipoCan) {
            case 0: {
                this.comboMoto.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.comboMoto.setSelectedIndex(1);
                break;
            }
            case 2: 
            case 3: {
                this.comboMoto.setSelectedIndex(3);
                break;
            }
            case 4: 
            case 5: {
                this.comboMoto.setSelectedIndex(7);
                break;
            }
            case 6: {
                this.comboMoto.setSelectedIndex(4);
                break;
            }
            case 7: {
                this.comboMoto.setSelectedIndex(5);
                break;
            }
            case 8: {
                this.comboMoto.setSelectedIndex(2);
                break;
            }
            case 10: {
                this.comboMoto.setSelectedIndex(6);
                break;
            }
            case 14: {
                this.comboMoto.setSelectedIndex(8);
                break;
            }
            case 15: {
                this.comboMoto.setSelectedIndex(9);
                break;
            }
            case 16: {
                this.comboMoto.setSelectedIndex(11);
                break;
            }
            case 17: {
                this.comboMoto.setSelectedIndex(10);
                break;
            }
            default: {
                this.comboMoto.setSelectedIndex(0);
            }
        }
    }

    private int getTipoCanSelected() {
        switch (this.comboMoto.getSelectedIndex()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 14;
            }
            case 9: {
                return 15;
            }
            case 10: {
                return 17;
            }
            case 11: {
                return 16;
            }
        }
        return 0;
    }

    public void abilitaTutto(boolean abilita) {
        this.velocitaMinimaTF.setEnabled(abilita);
        this.dentiPignoneTF.setEnabled(abilita);
        this.dentiCoronaTF.setEnabled(abilita);
        this.circonferenzaTF.setEnabled(abilita);
        this.velocitaGPSMinimaTF.setEnabled(abilita);
        this.rpmMinimaTF.setEnabled(abilita);
        this.remotoCB.setEnabled(abilita);
        this.vel1CB.setEnabled(abilita);
        this.rpmCB.setEnabled(abilita);
        this.velGpsCB.setEnabled(abilita);
        this.condizioneAndCB.setEnabled(abilita);
        this.scriviSdB.setEnabled(abilita);
        this.scriviDasy.setEnabled(abilita);
        this.campionamento.setEnabled(abilita);
        this.rpmTF.setEnabled(abilita);
        this.vel1TF.setEnabled(abilita);
        this.vel2TF.setEnabled(abilita);
        this.tempoMinimoTF.setEnabled(abilita);
        this.comboMoto.setEnabled(abilita);
        this.settingsCB.setEnabled(abilita);
        this.label1.setEnabled(abilita);
        this.label2.setEnabled(abilita);
        this.label3.setEnabled(abilita);
        this.label4.setEnabled(abilita);
        this.label5.setEnabled(abilita);
        this.label6.setEnabled(abilita);
        this.label7.setEnabled(abilita);
        this.label8.setEnabled(abilita);
        this.label9.setEnabled(abilita);
        this.label10.setEnabled(abilita);
        this.label11.setEnabled(abilita);
        this.label12.setEnabled(abilita);
        this.label15.setEnabled(abilita);
        this.label16.setEnabled(abilita);
        this.label17.setEnabled(abilita);
        if (this.comboMoto.getSelectedIndex() != 0) {
            this.dentiPignoneTF.setEnabled(false);
            this.dentiCoronaTF.setEnabled(false);
            this.dentiPignoneTF.setValue(1);
            this.dentiCoronaTF.setValue(1);
            this.rpmTF.setEnabled(false);
            this.vel1TF.setEnabled(false);
            this.vel2TF.setEnabled(false);
        }
    }

    public void abilitaTasti(boolean abilita) {
        this.leggiDasy.setEnabled(abilita);
        if (this.parametriLetti) {
            this.scriviDasy.setEnabled(abilita);
        }
    }

    private void scriviTestLap() {
        this.abilitaTasti(false);
        System.out.println("apro connessione su porta " + DanasPreferences.getPrefCom());
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JDialog f1 = new JDialog((Dialog)SettingsDasyX.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                new JButton(new ImageIcon(ImgUrl));
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Il sistema sta verificando le porte COM disponibili") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                progressBar.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(progressBar);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                try {
                    SettingsDasyX.this.conn.connect(2);
                    f1.setVisible(false);
                    SettingsDasyX.this.setVisible(true);
                    DanasDataStructure.getInstance();
                    SettingsDasyX.this.conn.scriviTestLap();
                    JOptionPane.showMessageDialog(SettingsDasyX.this, Language.string("Segnale inviato"), Language.string("Info"), 1);
                    SettingsDasyX.this.conn.disconnect();
                    System.out.println("disconnesso");
                }
                catch (Exception e) {
                    f1.setVisible(false);
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(SettingsDasyX.this, Language.string("Errore di connessione: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    SettingsDasyX.this.requestFocus();
                    return;
                }
                finally {
                    f1.setVisible(false);
                    System.out.println("finita la connessione");
                    try {
                        SettingsDasyX.this.conn.disconnect();
                    }
                    catch (IOException e) {
                        System.out.println("Doppia sconnessione...");
                        e.printStackTrace();
                    }
                    SettingsDasyX.this.abilitaTasti(true);
                }
            }
        }.start();
        this.requestFocus();
        this.setVisible(true);
    }

    private void scriviDaDasy6() {
        this.abilitaTasti(false);
        System.out.println("apro connessione su porta " + DanasPreferences.getPrefCom());
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JDialog f1 = new JDialog((Dialog)SettingsDasyX.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                new JButton(new ImageIcon(ImgUrl));
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Il sistema sta verificando le porte COM disponibili") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                progressBar.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(progressBar);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                try {
                    String settaggi;
                    SettingsDasyX.this.conn.connect(2);
                    f1.setVisible(false);
                    SettingsDasyX.this.setVisible(true);
                    DanasDataStructure.getInstance();
                    String imposStringa = HwDasy6.createImposString6();
                    SettingsDasyX.this.conn.impostaSettaggi6(imposStringa);
                    System.out.println("impostati i settaggi");
                    switch (SettingsDasyX.this.getTipoCanSelected()) {
                        case 1: {
                            settaggi = "$SETTINGS,TPS,0,814,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,TC,0,14614,1980,1,1,1950,1,1,1,2,3,4,5,6,14,";
                            break;
                        }
                        case 8: {
                            settaggi = "$SETTINGS,TPS,0,814,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,TC,0,14614,1980,1,1,1950,1,1,1,2,3,4,5,6,22,";
                            break;
                        }
                        case 3: {
                            settaggi = "$SETTINGS,TPS,0,400,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,DTCtot,0,100,DTCspn,0,100,1980,1,1,1950,1,1,1,2,3,4,5,6,16,";
                            break;
                        }
                        case 6: {
                            settaggi = "$SETTINGS,TPS,0,400,Fork,0,204.6,Shock,0,84.4,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,DTCtot,0,100,DTCspn,0,100,1980,1,1,1950,1,1,1,2,3,4,5,6,19,";
                            break;
                        }
                        case 7: {
                            settaggi = "$SETTINGS,TPS,0,400,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,DTCtot,0,100,DTCspn,0,100,1980,1,1,1950,1,1,1,2,3,4,5,6,20,";
                            break;
                        }
                        case 10: {
                            settaggi = "$SETTINGS,TPS,0,1023,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,APS,0,1023,1980,1,1,1950,1,1,1,2,3,4,5,6,29,";
                            break;
                        }
                        case 5: {
                            settaggi = "$SETTINGS,TPS,0,512,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,Analog8,0,1023,1980,1,1,1950,1,1,1,2,3,4,5,6,18,";
                            break;
                        }
                        case 14: {
                            settaggi = "$SETTINGS,TPS,0,512,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,TC,0,512,1980,1,1,1950,1,1,1,2,3,4,5,6,39,";
                            break;
                        }
                        case 15: {
                            settaggi = "$SETTINGS,TPS,0,401,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,Analog8,0,1023,1980,1,1,1950,1,1,1,2,3,4,5,6,40,";
                            break;
                        }
                        case 16: {
                            settaggi = "$SETTINGS,TPS,0,400,Fork,0,204.6,Shock,0,84.4,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,DTCtot,0,100,1980,1,1,1950,1,1,1,2,3,4,5,6,43,";
                            break;
                        }
                        case 17: {
                            settaggi = "$SETTINGS,TPS,0,147,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,APS,0,147,TC,0,1023,1980,1,1,1950,1,1,1,2,3,4,5,6,44,";
                            break;
                        }
                        default: {
                            settaggi = "$SETTINGS,Analog1,0,1023,Analog2,0,1023,Analog3,0,1023,Analog4,0,1023,Lambda,8,22,Analog6,0,1023,Analog7,0,1023,Analog8,0,1023,1980,1,1,1950,1,1,1,2,3,4,5,6,8,";
                        }
                    }
                    if (SettingsDasyX.this.settingsCB.isSelected()) {
                        SettingsDasyX.this.conn.scriviInternalSettings(settaggi);
                    }
                    SettingsDasyX.this.conn.disconnect();
                    System.out.println("disconnesso");
                }
                catch (Exception e) {
                    f1.setVisible(false);
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(SettingsDasyX.this, Language.string("Errore di connessione: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    SettingsDasyX.this.requestFocus();
                    return;
                }
                finally {
                    f1.setVisible(false);
                    SettingsDasyX.this.setVisible(true);
                    System.out.println("finita la connessione");
                    try {
                        SettingsDasyX.this.conn.disconnect();
                    }
                    catch (IOException e) {
                        System.out.println("Doppia sconnessione...");
                        e.printStackTrace();
                    }
                    SettingsDasyX.this.abilitaTasti(true);
                }
            }
        }.start();
        this.requestFocus();
        this.setVisible(true);
    }

    private void leggiDaDasy6() {
        this.abilitaTasti(false);
        System.out.println("apro connessione su porta " + DanasPreferences.getPrefCom());
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JDialog f1 = new JDialog((Dialog)SettingsDasyX.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                new JButton(new ImageIcon(ImgUrl));
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Il sistema sta verificando le porte COM disponibili") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                progressBar.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(progressBar);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                try {
                    System.out.println("Provo a connettermi per leggere");
                    SettingsDasyX.this.conn.connect(2);
                    f1.setVisible(false);
                    SettingsDasyX.this.setVisible(true);
                    System.out.println("stabilita la connessione");
                    String imposLette = SettingsDasyX.this.conn.leggiSettaggi6();
                    DanasDataStructure.getInstance();
                    DanasDataStructure.impostazioni6 = new HwDasy6();
                    DanasDataStructure.getInstance();
                    DanasDataStructure.impostazioni6.parseImposString6(imposLette);
                    SettingsDasyX.this.importaSettaggi();
                    SettingsDasyX.this.conn.disconnect();
                    SettingsDasyX.this.scriviDasy.setEnabled(true);
                    SettingsDasyX.this.parametriLetti = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    f1.setVisible(false);
                    JOptionPane.showMessageDialog(SettingsDasyX.this, Language.string("Errore di connessione: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    SettingsDasyX.this.requestFocus();
                    return;
                }
                finally {
                    f1.setVisible(false);
                    SettingsDasyX.this.setVisible(true);
                    System.out.println("finita la connessione");
                    try {
                        SettingsDasyX.this.conn.disconnect();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    SettingsDasyX.this.leggiDasy.setEnabled(true);
                }
            }
        }.start();
        this.requestFocus();
        this.setVisible(true);
    }

    public void scriviValori() {
        int sGps = 0;
        int sRpm = 0;
        int sRemoto = 0;
        int sVel1 = 0;
        int rpm = Integer.valueOf(this.rpmTF.getText());
        int vel1 = Integer.valueOf(this.vel1TF.getText());
        int vel2 = Integer.valueOf(this.vel2TF.getText());
        int tempo = Integer.valueOf(this.campionamento.getText());
        double den1 = (double)Integer.valueOf(this.velocitaMinimaTF.getText()).intValue() * 2.56E-5;
        double correzione = 3.6 * (double)Integer.valueOf(this.dentiPignoneTF.getText()).intValue() * (double)(Integer.valueOf(this.circonferenzaTF.getText()) / 1000) / (double)Integer.valueOf(this.dentiCoronaTF.getText()).intValue();
        if (this.comboMoto.getSelectedIndex() != 0) {
            correzione = MeasuresUtil.convertiRealToCanSpeed(Integer.valueOf(this.velocitaMinimaTF.getText()), this.getTipoCanSelected()) * (Integer.valueOf(this.circonferenzaTF.getText()) / 1980);
            den1 = 1.0;
        }
        int velocitaMinima1 = (int)(correzione / den1);
        int velocitaMinimaGPS = Integer.valueOf(this.velocitaGPSMinimaTF.getText());
        velocitaMinimaGPS = (int)((double)velocitaMinimaGPS / 1.852);
        if (velocitaMinima1 > 65535) {
            velocitaMinima1 = 65535;
        }
        double den = (double)Integer.valueOf(this.rpmMinimaTF.getText()).intValue() * 1.6E-6;
        int rpmMinima = (int)(60.0 / den);
        if (this.comboMoto.getSelectedIndex() != 0) {
            rpmMinima = MeasuresUtil.convertiRealtoCanRpm(Integer.valueOf(this.rpmMinimaTF.getText()), this.getTipoCanSelected());
        }
        if (rpmMinima > 65535) {
            rpmMinima = 65535;
        }
        int centesimiRitardo = Integer.valueOf(this.tempoMinimoTF.getText()) * 100;
        int utilizzaAnd = 0;
        utilizzaAnd = this.condizioneAndCB.isSelected() ? 1 : 0;
        if (this.velGpsCB.isSelected()) {
            sGps = 1;
        }
        if (this.rpmCB.isSelected()) {
            sRpm = 1;
        }
        if (this.remotoCB.isSelected()) {
            sRemoto = 1;
        }
        if (this.vel1CB.isSelected()) {
            sVel1 = 1;
        }
        int can = this.getTipoCanSelected();
        DanasDataStructure.getInstance();
        DanasDataStructure.impostazioni6 = new HwDasy6(rpm, vel1, vel2, tempo, sGps, sVel1, sRemoto, sRpm, velocitaMinima1, velocitaMinimaGPS, rpmMinima, centesimiRitardo, utilizzaAnd, 0, 0, 5, can);
    }

    public boolean controllaValori() {
        this.parametroSbagliato = null;
        if (this.vel1TF.getValue() == null || Integer.valueOf(this.vel1TF.getText()) > 100 || Integer.valueOf(this.vel1TF.getText()) < 1) {
            this.parametroSbagliato = "Impulsi vel1";
        }
        if (this.vel2TF.getValue() == null || Integer.valueOf(this.vel2TF.getText()) > 100 || Integer.valueOf(this.vel2TF.getText()) < 1) {
            this.parametroSbagliato = "Impulsi vel2";
        }
        if (this.rpmTF.getValue() == null || Integer.valueOf(this.rpmTF.getText()) > 50 || Integer.valueOf(this.rpmTF.getText()) < 1) {
            this.parametroSbagliato = "Impulsi RPM";
        }
        if (this.velocitaMinimaTF.getValue() == null || Integer.valueOf(this.velocitaMinimaTF.getText()) > 250 || Integer.valueOf(this.velocitaMinimaTF.getText()) < 0) {
            this.parametroSbagliato = "velocit\u00e01 minima";
        }
        if (this.velocitaGPSMinimaTF.getValue() == null || Integer.valueOf(this.velocitaGPSMinimaTF.getText()) > 250 || Integer.valueOf(this.velocitaGPSMinimaTF.getText()) < 0) {
            this.parametroSbagliato = "velocit\u00e0 GPS minima";
        }
        if (this.dentiPignoneTF.getValue() == null || Integer.valueOf(this.dentiPignoneTF.getText()) > 100 || Integer.valueOf(this.dentiPignoneTF.getText()) < 1) {
            this.parametroSbagliato = "Numero denti pignone";
        }
        if (this.dentiCoronaTF.getValue() == null || Integer.valueOf(this.dentiCoronaTF.getText()) > 100 || Integer.valueOf(this.dentiCoronaTF.getText()) < 1) {
            this.parametroSbagliato = "Numero denti corona";
        }
        if (this.circonferenzaTF.getValue() == null || Integer.valueOf(this.circonferenzaTF.getText()) > 3000 || Integer.valueOf(this.circonferenzaTF.getText()) < 1) {
            this.parametroSbagliato = "Dimesione circonferenza";
        }
        if (this.tempoMinimoTF.getValue() == null || Integer.valueOf(this.tempoMinimoTF.getText()) > 10 || Integer.valueOf(this.tempoMinimoTF.getText()) < 3) {
            this.parametroSbagliato = "Tempo minimo campionamento";
        }
        if (this.campionamento.getValue() == null || Integer.valueOf(this.campionamento.getText()) > 500 || Integer.valueOf(this.campionamento.getText()) < 1) {
            this.parametroSbagliato = "Tempo di campionamento";
        }
        if (!(this.velGpsCB.isSelected() || this.rpmCB.isSelected() || this.remotoCB.isSelected() || this.vel1CB.isSelected())) {
            this.parametroSbagliato = "Nessun autostart selezionato";
        }
        return this.parametroSbagliato == null;
    }

    public void importaSettaggi() {
        this.abilitaTutto(true);
        DanasDataStructure.getInstance();
        HwDasy6 impos = DanasDataStructure.impostazioni6;
        if (impos == null) {
            impos = new HwDasy6();
        }
        this.vel1TF.setValue(impos.getSetting(1));
        this.vel2TF.setValue(impos.getSetting(2));
        this.rpmTF.setValue(impos.getSetting(0));
        this.campionamento.setValue(impos.getSetting(3));
        if (impos.getSetting(4) == 1) {
            this.velGpsCB.setSelected(true);
        } else {
            this.velGpsCB.setSelected(false);
        }
        if (impos.getSetting(5) == 1) {
            this.rpmCB.setSelected(true);
        } else {
            this.rpmCB.setSelected(false);
        }
        if (impos.getSetting(7) == 1) {
            this.vel1CB.setSelected(true);
        } else {
            this.vel1CB.setSelected(false);
        }
        if (impos.getSetting(6) == 1) {
            this.remotoCB.setSelected(true);
        } else {
            this.remotoCB.setSelected(false);
        }
        this.condizioneAndCB.setSelected(impos.getSetting(13) == 1);
        if (impos.getSetting(17) != 0) {
            double r = MeasuresUtil.convertiCantoRealRpm(impos.getSetting(11), impos.getSetting(17));
            this.rpmMinimaTF.setValue((int)r);
        } else {
            double den = (double)impos.getSetting(11) * 1.6E-6;
            this.rpmMinimaTF.setValue((int)(60.0 / den));
        }
        this.tempoMinimoTF.setValue(impos.getSetting(12) / 100);
        this.velocitaGPSMinimaTF.setValue((double)impos.getSetting(10) * 1.8);
        if (impos.getSetting(17) != 0) {
            double v = MeasuresUtil.convertiCanToRealSpeed(impos.getSetting(9), impos.getSetting(17));
            this.velocitaMinimaTF.setValue((int)(v *= 1980.0) / Integer.valueOf(this.circonferenzaTF.getText()));
        } else {
            double den1 = (double)impos.getSetting(9) * 2.56E-5;
            double correzione = 3.6 * (double)Integer.valueOf(this.dentiPignoneTF.getText()).intValue() * (double)(Integer.valueOf(this.circonferenzaTF.getText()) / 1000) / (double)Integer.valueOf(this.dentiCoronaTF.getText()).intValue();
            this.velocitaMinimaTF.setValue((int)(correzione / den1));
        }
        if (this.vel1CB.isSelected()) {
            this.label1.setForeground(Color.BLACK);
            this.label4.setForeground(Color.BLACK);
            this.label5.setForeground(Color.BLACK);
            this.label6.setForeground(Color.BLACK);
            this.velocitaMinimaTF.setEnabled(true);
            this.dentiPignoneTF.setEnabled(true);
            this.dentiCoronaTF.setEnabled(true);
            this.circonferenzaTF.setEnabled(true);
        } else {
            this.velocitaMinimaTF.setEnabled(false);
            this.dentiPignoneTF.setEnabled(false);
            this.dentiCoronaTF.setEnabled(false);
            this.circonferenzaTF.setEnabled(false);
            this.label1.setForeground(Color.GRAY);
            this.label4.setForeground(Color.GRAY);
            this.label5.setForeground(Color.GRAY);
            this.label6.setForeground(Color.GRAY);
        }
        if (this.velGpsCB.isSelected()) {
            this.label2.setForeground(Color.BLACK);
            this.velocitaGPSMinimaTF.setEnabled(true);
        } else {
            this.velocitaGPSMinimaTF.setEnabled(false);
            this.label2.setForeground(Color.GRAY);
        }
        if (this.rpmCB.isSelected()) {
            this.label3.setForeground(Color.BLACK);
            this.rpmMinimaTF.setEnabled(true);
        } else {
            this.rpmMinimaTF.setEnabled(false);
            this.label3.setForeground(Color.GRAY);
        }
        this.setIndexComboCan(impos.getSetting(17));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.vel1CB)) {
            if (this.vel1CB.isSelected()) {
                JOptionPane.showMessageDialog(this, Language.string("Controllare tutti i parmetri del pannello valori minimi"), Language.string("Attenzione"), 2);
                this.label1.setForeground(Color.BLACK);
                this.label4.setForeground(Color.BLACK);
                this.label5.setForeground(Color.BLACK);
                this.label6.setForeground(Color.BLACK);
                this.velocitaMinimaTF.setEnabled(true);
                this.dentiPignoneTF.setEnabled(true);
                this.dentiCoronaTF.setEnabled(true);
                this.circonferenzaTF.setEnabled(true);
            } else {
                this.velocitaMinimaTF.setEnabled(false);
                this.dentiPignoneTF.setEnabled(false);
                this.dentiCoronaTF.setEnabled(false);
                this.circonferenzaTF.setEnabled(false);
                this.label1.setForeground(Color.GRAY);
                this.label4.setForeground(Color.GRAY);
                this.label5.setForeground(Color.GRAY);
                this.label6.setForeground(Color.GRAY);
            }
        }
        if (arg0.getSource().equals(this.comboMoto)) {
            if (this.comboMoto.getSelectedIndex() != 0) {
                this.dentiPignoneTF.setEnabled(false);
                this.dentiCoronaTF.setEnabled(false);
                this.dentiPignoneTF.setValue(1);
                this.dentiCoronaTF.setValue(1);
                this.rpmTF.setEnabled(false);
                this.vel1TF.setEnabled(false);
                this.vel2TF.setEnabled(false);
            } else {
                if (this.vel1CB.isSelected()) {
                    this.dentiPignoneTF.setEnabled(true);
                    this.dentiCoronaTF.setEnabled(true);
                }
                this.rpmTF.setEnabled(true);
                this.vel1TF.setEnabled(true);
                this.vel2TF.setEnabled(true);
            }
        }
        if (arg0.getSource().equals(this.velGpsCB)) {
            if (this.velGpsCB.isSelected()) {
                this.label2.setForeground(Color.BLACK);
                this.velocitaGPSMinimaTF.setEnabled(true);
            } else {
                this.velocitaGPSMinimaTF.setEnabled(false);
                this.label2.setForeground(Color.GRAY);
            }
        }
        if (arg0.getSource().equals(this.rpmCB)) {
            if (this.rpmCB.isSelected()) {
                this.label3.setForeground(Color.BLACK);
                this.rpmMinimaTF.setEnabled(true);
            } else {
                this.rpmMinimaTF.setEnabled(false);
                this.label3.setForeground(Color.GRAY);
            }
        }
        if (arg0.getSource().equals(this.caricaSdB)) {
            this.scriviValori();
            SDLoadDialog.showLoadSDDialog(this, 0, true);
            this.importaSettaggi();
        }
        if (arg0.getSource().equals(this.scriviDasy)) {
            if (!this.controllaValori()) {
                JOptionPane.showMessageDialog(null, Language.string("Controllare i valori impostati: mancanti o fuori dai limiti") + "  (Errore:" + this.parametroSbagliato + ")", Language.string("Attenzione"), 2);
                return;
            }
            this.scriviValori();
            this.scriviDaDasy6();
        }
        if (arg0.getSource().equals(this.testB)) {
            this.scriviTestLap();
        }
        if (arg0.getSource().equals(this.leggiDasy)) {
            this.leggiDaDasy6();
        }
        if (arg0.getSource().equals(this.scriviSdB)) {
            if (!this.controllaValori()) {
                JOptionPane.showMessageDialog(null, Language.string("Controllare i valori impostati: mancanti o fuori dai limiti"), Language.string("Attenzione"), 2);
                return;
            }
            this.scriviValori();
            SDLoadDialog.showLoadSDDialog(this, 1, true);
        }
        if (arg0.getSource().equals(this.annullaB)) {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        SettingsDasyX test = new SettingsDasyX(null);
        test.setVisible(true);
    }
}

