/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Dialog.MathDialog;
import i2m.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ScriptDialog
extends JDialog
implements ActionListener {
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea textArea;
    private JButton apriButton;
    private JButton salvaButton;
    private JButton verificaButton;
    private JButton applicaButton;
    private JButton esciButton;
    private JButton stopButton;
    private String filePath = null;
    private MathDialog padre;
    private int versione = 0;
    private boolean stessoFile = false;
    Thread verificaThread = null;

    public ScriptDialog(MathDialog padre) {
        super((Dialog)padre, "Danas Java Script Editor");
        this.padre = padre;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel("Try typing 'spectacular' or 'Swing'...");
        this.textArea = new JTextArea();
        this.textArea.setColumns(50);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(25);
        this.textArea.setWrapStyleWord(true);
        JPanel buttonPanel = new JPanel();
        this.apriButton = new JButton(Language.string("Apri script"));
        this.apriButton.addActionListener(this);
        this.salvaButton = new JButton(Language.string("Salva con nome"));
        this.salvaButton.addActionListener(this);
        this.verificaButton = new JButton(Language.string("Verifica"));
        this.verificaButton.addActionListener(this);
        this.applicaButton = new JButton(Language.string("Salva e applica"));
        this.applicaButton.addActionListener(this);
        this.esciButton = new JButton(Language.string("Esci"));
        this.esciButton.addActionListener(this);
        this.stopButton = new JButton(Language.string("stop verifica"));
        this.stopButton.addActionListener(this);
        buttonPanel.add(this.apriButton);
        buttonPanel.add(this.salvaButton);
        buttonPanel.add(this.verificaButton);
        buttonPanel.add(this.stopButton);
        buttonPanel.add(this.applicaButton);
        buttonPanel.add(this.esciButton);
        buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        this.jScrollPane1 = new JScrollPane(this.textArea);
        JPanel helpPanel = new JPanel();
        helpPanel.setLayout(new GridLayout(9, 1));
        helpPanel.add(new JLabel(""));
        helpPanel.add(new JLabel(Language.string("  Variable:  rpm[x],spd1[x],spd2[x],An1[x],An2[x],An3[x],An4[x],An5[x],An6[x],An7[x],An8[x]  ")));
        helpPanel.add(new JLabel(Language.string("  Variable:  mu1[x],mu2[x],mu3[x],mu4[x],mu5[x],mu6[x],mu7[x],mu8[x],mu9[x],mu10[x]  ")));
        helpPanel.add(new JLabel(Language.string("  Variable:  drpm[x],dspd1[x],dspd2[x],dAn1[x],dAn2[x],dAn3[x],dAn4[x],dAn5[x],dAn6[x],dAn7[x],dAn8[x]  ")));
        helpPanel.add(new JLabel(Language.string("  Variable:  gpsS[x],dgpsS[x],lacc[x],ang[x],alt[x]  ")));
        helpPanel.add(new JLabel(Language.string("  Variable:  dExt1[x],dExt2[x],dExt3[x],dExt4[x]  ")));
        helpPanel.add(new JLabel(Language.string("  Variable:  size,time[x],pAnt[x],tAnt[x],pPost[x],tPost[x],can001[x],can002[x]...can128[x]")));
        helpPanel.add(new JLabel(Language.string("  Output:    output[x]  ")));
        helpPanel.add(new JLabel(""));
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.setSize(new Dimension(700, 300));
        pannelloPrincipale.add((Component)this.jScrollPane1, "Center");
        pannelloPrincipale.add((Component)buttonPanel, "South");
        pannelloPrincipale.add((Component)helpPanel, "North");
        this.pack();
        this.statoVerifica(false);
    }

    void setVersione(int vers) {
        this.versione = vers;
    }

    public void setNomeFile(String path) {
        this.filePath = path;
    }

    public void apriFile(File f) {
        try {
            f.setReadable(true);
            FileReader reader = new FileReader(f);
            BufferedReader br = new BufferedReader(reader);
            this.textArea.read(br, null);
            String percorso = f.getAbsolutePath();
            this.stessoFile = percorso.equals(this.filePath);
            this.filePath = percorso;
            br.close();
            this.textArea.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void apriScript() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Java script", "txt"));
        int res = fileChooser.showOpenDialog(this);
        if (res == 0) {
            File f = fileChooser.getSelectedFile();
            this.apriFile(f);
        }
    }

    private void salvaScript() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Java script", "txt"));
        int res = fileChooser.showSaveDialog(this);
        if (res == 0) {
            File f = fileChooser.getSelectedFile();
            this.scriviFile(f);
            String percorso = f.getAbsolutePath();
            this.stessoFile = percorso.equals(this.filePath);
            this.filePath = percorso;
        }
    }

    private void scriviFile(File f) {
        try {
            FileWriter writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            this.textArea.write(bw);
            bw.close();
            this.textArea.requestFocus();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void verifica() {
        int i;
        ScriptEngineManager factory = new ScriptEngineManager();
        final ScriptEngine engine = factory.getEngineByName("JavaScript");
        final MyBuffer fineScript = new MyBuffer();
        int size = 1000;
        double[] tempob = new double[size];
        double[] rpmb = new double[size];
        double[] spd1b = new double[size];
        double[] spd2b = new double[size];
        double[] An1b = new double[size];
        double[] An2b = new double[size];
        double[] An3b = new double[size];
        double[] An4b = new double[size];
        double[] An5b = new double[size];
        double[] An6b = new double[size];
        double[] An7b = new double[size];
        double[] An8b = new double[size];
        double[] mu1b = new double[size];
        double[] mu2b = new double[size];
        double[] mu3b = new double[size];
        double[] mu4b = new double[size];
        double[] mu5b = new double[size];
        double[] mu6b = new double[size];
        double[] mu7b = new double[size];
        double[] mu8b = new double[size];
        double[] mu9b = new double[size];
        double[] muXb = new double[size];
        double[] pantb = new double[size];
        double[] tantb = new double[size];
        double[] ppostb = new double[size];
        double[] tpostb = new double[size];
        double[] output = new double[size];
        double[] Ext1b = new double[size];
        double[] Ext2b = new double[size];
        double[] Ext3b = new double[size];
        double[] Ext4b = new double[size];
        double[] gpsSb = new double[size];
        double[] angb = new double[size];
        double[] laccb = new double[size];
        double[] altb = new double[size];
        double[] drpmb = new double[size];
        double[] dspd1b = new double[size];
        double[] dspd2b = new double[size];
        double[] dAn1b = new double[size];
        double[] dAn2b = new double[size];
        double[] dAn3b = new double[size];
        double[] dAn4b = new double[size];
        double[] dAn5b = new double[size];
        double[] dAn6b = new double[size];
        double[] dAn7b = new double[size];
        double[] dAn8b = new double[size];
        double[] dExt1b = new double[size];
        double[] dExt2b = new double[size];
        double[] dExt3b = new double[size];
        double[] dExt4b = new double[size];
        double[] dgpsSb = new double[size];
        for (i = 0; i < size; ++i) {
            double currentt;
            tempob[i] = currentt = (double)i;
            rpmb[i] = 1.0;
            spd1b[i] = 1.0;
            spd2b[i] = 1.0;
            An1b[i] = 1.0;
            An2b[i] = 1.0;
            An3b[i] = 1.0;
            An4b[i] = 1.0;
            An5b[i] = 1.0;
            An6b[i] = 1.0;
            An7b[i] = 1.0;
            An8b[i] = 1.0;
            Ext1b[i] = 1.0;
            Ext2b[i] = 1.0;
            Ext3b[i] = 1.0;
            Ext4b[i] = 1.0;
            mu1b[i] = 1.0;
            mu2b[i] = 1.0;
            mu3b[i] = 1.0;
            mu4b[i] = 1.0;
            mu5b[i] = 1.0;
            mu6b[i] = 1.0;
            mu7b[i] = 1.0;
            mu8b[i] = 1.0;
            mu9b[i] = 1.0;
            muXb[i] = 1.0;
            pantb[i] = 1.0;
            tantb[i] = 1.0;
            ppostb[i] = 1.0;
            tpostb[i] = 1.0;
            gpsSb[i] = 1.0;
            laccb[i] = 1.0;
            angb[i] = 1.0;
            altb[i] = 1.0;
            dgpsSb[i] = 1.0;
            drpmb[i] = 1.0;
            dspd1b[i] = 1.0;
            dspd2b[i] = 1.0;
            dAn1b[i] = 1.0;
            dAn2b[i] = 1.0;
            dAn3b[i] = 1.0;
            dAn4b[i] = 1.0;
            dAn5b[i] = 1.0;
            dAn6b[i] = 1.0;
            dAn7b[i] = 1.0;
            dAn8b[i] = 1.0;
            dExt1b[i] = 1.0;
            dExt2b[i] = 1.0;
            dExt3b[i] = 1.0;
            dExt4b[i] = 1.0;
        }
        for (i = 0; i < 128; ++i) {
            double[] valori = new double[size];
            for (int j = 0; j < size; ++j) {
                valori[j] = 1.0;
            }
            String nome = String.format("can%03d", i + 1);
            engine.put(nome, valori);
        }
        engine.put("rpm", rpmb);
        engine.put("spd1", spd1b);
        engine.put("spd2", spd2b);
        engine.put("An1", An1b);
        engine.put("An2", An2b);
        engine.put("An3", An3b);
        engine.put("An4", An4b);
        engine.put("An5", An5b);
        engine.put("An6", An6b);
        engine.put("An7", An7b);
        engine.put("An8", An8b);
        engine.put("Ext1", Ext1b);
        engine.put("Ext2", Ext2b);
        engine.put("Ext3", Ext3b);
        engine.put("Ext4", Ext4b);
        engine.put("mu1", mu1b);
        engine.put("mu2", mu2b);
        engine.put("mu3", mu3b);
        engine.put("mu4", mu4b);
        engine.put("mu5", mu5b);
        engine.put("mu6", mu6b);
        engine.put("mu7", mu7b);
        engine.put("mu8", mu8b);
        engine.put("mu9", mu9b);
        engine.put("mu10", muXb);
        engine.put("pAnt", pantb);
        engine.put("tAnt", tantb);
        engine.put("pPost", ppostb);
        engine.put("tPost", tpostb);
        engine.put("gpsS", gpsSb);
        engine.put("ang", angb);
        engine.put("lacc", laccb);
        engine.put("alt", altb);
        engine.put("dgpsS", dgpsSb);
        engine.put("drpm", drpmb);
        engine.put("dspd1", dspd1b);
        engine.put("dspd2", dspd2b);
        engine.put("dAn1", dAn1b);
        engine.put("dAn2", dAn2b);
        engine.put("dAn3", dAn3b);
        engine.put("dAn4", dAn4b);
        engine.put("dAn5", dAn5b);
        engine.put("dAn6", dAn6b);
        engine.put("dAn7", dAn7b);
        engine.put("dAn8", dAn8b);
        engine.put("dExt1", dExt1b);
        engine.put("dExt2", dExt2b);
        engine.put("dExt3", dExt3b);
        engine.put("dExt4", dExt4b);
        engine.put("fineScript", fineScript);
        engine.put("output", output);
        engine.put("size", size);
        engine.put("time", tempob);
        this.statoVerifica(true);
        this.verificaThread = new Thread(){

            @Override
            public void run() {
                try {
                    File f = File.createTempFile("tempScript", "tmp");
                    f.deleteOnExit();
                    ScriptDialog.this.scriviFile(f);
                    try {
                        PrintWriter output = new PrintWriter(new FileWriter(f, true));
                        output.printf("\n\r fineScript.put(1);", new Object[0]);
                        output.close();
                    }
                    catch (Exception output) {
                        // empty catch block
                    }
                    FileReader reader = new FileReader(f);
                    engine.eval(reader);
                    JOptionPane.showMessageDialog(null, Language.string("Lo script risulta corretto"), "INFO", 1);
                    ScriptDialog.this.statoVerifica(false);
                }
                catch (Exception ex) {
                    try {
                        fineScript.put(1.0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(null, Language.string("Errore nello script, controllare il testo: ") + ex.toString(), "Attenzione", 2);
                    ScriptDialog.this.statoVerifica(false);
                }
            }
        };
        this.verificaThread.start();
        System.out.println("Risultato x test=" + output[0]);
    }

    public void statoVerifica(boolean attiva) {
        if (attiva) {
            this.apriButton.setEnabled(false);
            this.salvaButton.setEnabled(false);
            this.verificaButton.setEnabled(false);
            this.applicaButton.setEnabled(false);
            this.esciButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.setDefaultCloseOperation(0);
        } else {
            this.apriButton.setEnabled(true);
            this.salvaButton.setEnabled(true);
            this.verificaButton.setEnabled(true);
            this.applicaButton.setEnabled(true);
            this.esciButton.setEnabled(true);
            this.stopButton.setEnabled(false);
            this.setDefaultCloseOperation(2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.apriButton)) {
            this.apriScript();
        }
        if (e.getSource().equals(this.salvaButton)) {
            this.salvaScript();
        }
        if (e.getSource().equals(this.verificaButton)) {
            this.verifica();
        }
        if (e.getSource().equals(this.stopButton) && this.verificaThread != null) {
            System.out.println("stop thread");
            this.verificaThread.stop();
            this.statoVerifica(false);
        }
        if (e.getSource().equals(this.applicaButton)) {
            if (this.filePath == null) {
                this.salvaScript();
            } else {
                this.scriviFile(new File(this.filePath));
            }
            if (this.filePath != null) {
                System.out.println("path=" + this.filePath);
                if (this.stessoFile) {
                    this.padre.scriviFunzione("JavaScript(" + this.filePath + "," + (this.versione + 1) + ",)");
                } else {
                    this.padre.scriviFunzione("JavaScript(" + this.filePath + ",0,)");
                }
                this.dispose();
            }
        }
        if (e.getSource().equals(this.esciButton)) {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ScriptDialog(null).setVisible(true);
            }
        });
    }

    public class MyBuffer {
        private Double data = null;

        public synchronized double get() throws Exception {
            while (this.data == null) {
                this.wait();
            }
            double d = this.data;
            this.data = null;
            this.notifyAll();
            return d;
        }

        public synchronized void put(double d) throws Exception {
            while (this.data != null) {
                this.wait();
            }
            this.data = d;
            this.notifyAll();
        }
    }
}

