/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Dialog.DanasSD;
import i2m.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SDLoadDialog {
    private JDialog dialog;
    private JTextField fileTextField;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private int modeLoad = 0;
    private boolean dasy6 = false;

    private SDLoadDialog(JDialog dialog, int load, boolean isDasy6) {
        this.dialog = dialog;
        this.dasy6 = isDasy6;
        this.modeLoad = load;
    }

    public static void showLoadSDDialog(JDialog parent, int load, boolean isDasy6) {
        JDialog dialog = load == 0 ? (isDasy6 ? new JDialog((Dialog)parent, Language.string("Loading memory")) : new JDialog((Dialog)parent, Language.string("Loading SD"))) : (isDasy6 ? new JDialog((Dialog)parent, Language.string("Saving memory")) : new JDialog((Dialog)parent, Language.string("Saving SD")));
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        SDLoadDialog fdialog = new SDLoadDialog(dialog, load, isDasy6);
        dialog.getContentPane().add(fdialog.getLoadSDDialog());
        dialog.setSize(new Dimension(450, 160));
        dialog.setLocationRelativeTo(null);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    private JPanel getCentralPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 3;
        String msg = this.modeLoad == 0 ? Language.string("I valori della SD verranno caricati.Selezionare il file DATI.TXT sulla memoria.") : Language.string("I valori verranno salvati su SD.Selezionare il file DATI.TXT sulla memoria.");
        JLabel saveInfoTextArea = new JLabel(msg);
        panel.add((Component)saveInfoTextArea, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        JLabel saveFileLabel = this.dasy6 ? new JLabel(Language.string("USB Key file: ")) : new JLabel(Language.string("SD file: "));
        panel.add((Component)saveFileLabel, gc);
        gc.gridx = 1;
        this.fileTextField = new JTextField();
        this.fileTextField.setEditable(true);
        this.fileTextField.setColumns(20);
        panel.add((Component)this.fileTextField, gc);
        gc.gridx = 2;
        JButton selectFileButton = new JButton(Language.string("Sfoglia"));
        selectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(0);
                fc.setMultiSelectionEnabled(false);
                fc.showOpenDialog(SDLoadDialog.this.dialog);
                File f = fc.getSelectedFile();
                try {
                    f.setReadable(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (f != null) {
                    SDLoadDialog.this.fileTextField.setText(f.getPath());
                }
            }
        });
        panel.add((Component)selectFileButton, gc);
        return panel;
    }

    private JPanel getLoadSDDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.getCentralPanel()), "Center");
        JPanel buttons = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.insets = new Insets(5, 5, 5, 5);
        JButton cancelButton = new JButton(Language.string("Annulla"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SDLoadDialog.this.dialog.dispose();
            }
        });
        buttons.add((Component)cancelButton, gc);
        gc.gridx = 1;
        JButton saveButton = this.modeLoad == 0 ? new JButton(Language.string("Carica")) : new JButton(Language.string("Salva"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (SDLoadDialog.this.modeLoad == 0) {
                        DanasSD.loadSD(SDLoadDialog.this.fileTextField.getText(), SDLoadDialog.this.dasy6);
                    } else {
                        DanasSD.saveSD(SDLoadDialog.this.fileTextField.getText(), SDLoadDialog.this.dasy6);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                SDLoadDialog.this.dialog.dispose();
            }
        });
        buttons.add((Component)saveButton, gc);
        panel.add((Component)buttons, "South");
        return panel;
    }
}

