/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Language;
import i2m.grafico.CurvaXY;
import i2m.grafico.GraficoXY;
import i2m.onLine.ChromeSettingsDialog;
import i2m.onLine.DasyProSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ParametriciDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton applicaB;
    private JButton esciB;
    private JButton esportaB;
    private JButton importaB;
    private GraficoXY graphXy;
    JComboBox sensoreCB;
    JComboBox numeroCB;
    JComboBox selezionatoCB;
    JFormattedTextField outTF;
    JFormattedTextField inTF;
    double[] sensoreA;
    double[] sensoreB;
    double[] sensoreC;
    int numeroA;
    int numeroB;
    int numeroC;
    int selezionato;
    ChromeSettingsDialog padre;
    DasyProSettingsDialog padreDasy;
    boolean isDasy = false;

    public ParametriciDialog(ChromeSettingsDialog owner, DasyProSettingsDialog ownerDasy) {
        super(owner, Language.string("Configura sensori parametrici"), true);
        this.padre = owner;
        this.padreDasy = ownerDasy;
        if (owner == null) {
            this.isDasy = true;
        }
        JPanel pannelloBottoni = new JPanel();
        this.applicaB = new JButton(Language.string("Applica"));
        this.applicaB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.esportaB = new JButton(Language.string("Esporta"));
        this.esportaB.addActionListener(this);
        this.importaB = new JButton(Language.string("Importa"));
        this.importaB.addActionListener(this);
        pannelloBottoni.add(this.applicaB);
        pannelloBottoni.add(this.importaB);
        pannelloBottoni.add(this.esportaB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        this.graphXy = new GraficoXY(null);
        this.graphXy.setGraficoMarce();
        this.graphXy.mostraAssi(false);
        this.graphXy.setBackgroundColor(Color.WHITE);
        this.graphXy.abilitaModifiche(false);
        JLabel numeroSensoreLabel = new JLabel(Language.string("Numero sensore : "));
        JLabel numeroPuntiLabel = new JLabel(Language.string("Numero punti : "));
        JLabel selezionatoLabel = new JLabel(Language.string("Punto selezionato : "));
        JLabel outLabel = new JLabel(Language.string("Valore Out : "));
        JLabel inLabel = new JLabel(Language.string("Valore In (V) : "));
        NumberFormat analogFormatt = NumberFormat.getNumberInstance(Locale.US);
        analogFormatt.setGroupingUsed(false);
        this.outTF = new JFormattedTextField(analogFormatt);
        this.outTF.setHorizontalAlignment(11);
        this.outTF.setMaximumSize(new Dimension(70, 20));
        this.outTF.addActionListener(this);
        this.inTF = new JFormattedTextField(analogFormatt);
        this.inTF.setHorizontalAlignment(11);
        this.inTF.setMaximumSize(new Dimension(70, 20));
        this.inTF.setEditable(false);
        String[] sensoriList = new String[]{"A", "B", "C"};
        this.sensoreCB = new JComboBox<String>(sensoriList);
        this.sensoreCB.setSelectedIndex(0);
        this.sensoreCB.setMaximumSize(new Dimension(120, 20));
        this.sensoreCB.addActionListener(this);
        String[] numeroPuntiList = new String[]{"3", "4", "5", "6", "7", "8", "9", "10"};
        this.numeroCB = new JComboBox<String>(numeroPuntiList);
        this.numeroCB.setSelectedIndex(0);
        this.numeroCB.setMaximumSize(new Dimension(120, 20));
        this.numeroCB.addActionListener(this);
        String[] selezionatoList = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        this.selezionatoCB = new JComboBox<String>(selezionatoList);
        this.selezionatoCB.setSelectedIndex(0);
        this.selezionatoCB.setMaximumSize(new Dimension(120, 20));
        this.selezionatoCB.addActionListener(this);
        JPanel pannelloPrincipale = new JPanel();
        pannelloPrincipale.setLayout(new GridLayout(1, 2, 0, 0));
        JPanel pannelloScelte = new JPanel();
        pannelloScelte.setLayout(new GridLayout(8, 2, 0, 10));
        pannelloScelte.add(new JLabel(""));
        pannelloScelte.add(new JLabel(""));
        pannelloScelte.add(numeroSensoreLabel);
        pannelloScelte.add(this.sensoreCB);
        pannelloScelte.add(numeroPuntiLabel);
        pannelloScelte.add(this.numeroCB);
        pannelloScelte.add(selezionatoLabel);
        pannelloScelte.add(this.selezionatoCB);
        pannelloScelte.add(outLabel);
        pannelloScelte.add(this.outTF);
        pannelloScelte.add(inLabel);
        pannelloScelte.add(this.inTF);
        pannelloScelte.add(new JLabel(""));
        pannelloScelte.add(new JLabel(""));
        pannelloScelte.add(new JLabel(""));
        pannelloScelte.add(new JLabel(""));
        JPanel pannelloOpzioni = new JPanel(new BorderLayout());
        pannelloOpzioni.add((Component)pannelloScelte, "Center");
        pannelloOpzioni.add(Box.createRigidArea(new Dimension(50, 10)), "West");
        pannelloOpzioni.add(Box.createRigidArea(new Dimension(50, 10)), "East");
        pannelloOpzioni.add((Component)pannelloBottoni, "South");
        pannelloPrincipale.add(pannelloOpzioni);
        pannelloPrincipale.add(this.graphXy.getGrafico());
        this.setContentPane(pannelloPrincipale);
        this.setSize(new Dimension(790, 395));
        this.setResizable(false);
        this.sensoreA = new double[10];
        this.sensoreB = new double[10];
        this.sensoreC = new double[10];
        this.numeroC = 3;
        this.numeroB = 3;
        this.numeroA = 3;
        for (int i = 0; i < 10; ++i) {
            this.sensoreA[i] = i;
            this.sensoreB[i] = i;
            this.sensoreC[i] = i;
        }
        this.aggiornaGrafico();
        this.graphXy.refresh();
        this.aggiornaScelteSelezionato();
        this.aggiornaTF();
    }

    public void aggiornaGrafico() {
        this.graphXy.rimuoviTutto();
        int numeroPunti = this.numeroCB.getSelectedIndex() + 3;
        double[] x = new double[numeroPunti];
        double[] y = new double[numeroPunti];
        double[] z = new double[]{0.0, 1.0};
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < numeroPunti; ++i) {
            x[i] = (double)i * 5.0 / ((double)numeroPunti - 1.0);
            switch (this.sensoreCB.getSelectedIndex()) {
                case 0: {
                    y[i] = this.sensoreA[i];
                    break;
                }
                case 1: {
                    y[i] = this.sensoreB[i];
                    break;
                }
                case 2: {
                    y[i] = this.sensoreC[i];
                }
            }
            if (y[i] < min) {
                min = y[i];
            }
            if (!(y[i] > max)) continue;
            max = y[i];
        }
        this.graphXy.setEstremiMarce(-0.5, 5.5, min - (max - min) * 0.05, max + (max - min) * 0.05);
        CurvaXY c = new CurvaXY(x, y, Color.BLUE, "");
        c.mostraCerchi(true);
        c.setCerchioSelezionato(this.selezionatoCB.getSelectedIndex());
        this.graphXy.aggiungiCurvaXY(c);
        this.graphXy.refresh();
    }

    public void aggiornaTF() {
        switch (this.sensoreCB.getSelectedIndex()) {
            case 0: {
                this.outTF.setValue(this.sensoreA[this.selezionatoCB.getSelectedIndex()]);
                break;
            }
            case 1: {
                this.outTF.setValue(this.sensoreB[this.selezionatoCB.getSelectedIndex()]);
                break;
            }
            case 2: {
                this.outTF.setValue(this.sensoreC[this.selezionatoCB.getSelectedIndex()]);
            }
        }
        int numeroPunti = this.numeroCB.getSelectedIndex() + 3;
        this.inTF.setValue((double)this.selezionatoCB.getSelectedIndex() * 5.0 / ((double)numeroPunti - 1.0));
    }

    public void aggiornaScelteSelezionato() {
        this.selezionatoCB.removeAllItems();
        this.selezionatoCB.addItem(1);
        this.selezionatoCB.addItem(2);
        for (int i = 0; i < this.numeroCB.getSelectedIndex() + 1; ++i) {
            this.selezionatoCB.addItem(i + 3);
        }
        this.selezionatoCB.setSelectedIndex(0);
    }

    public void resettaSensore() {
        int numeroPunti = this.numeroCB.getSelectedIndex() + 3;
        block5: for (int i = 0; i < numeroPunti; ++i) {
            switch (this.sensoreCB.getSelectedIndex()) {
                case 0: {
                    this.sensoreA[i] = i * 1023 / (numeroPunti - 1);
                    this.numeroA = numeroPunti;
                    continue block5;
                }
                case 1: {
                    this.sensoreB[i] = i * 1023 / (numeroPunti - 1);
                    this.numeroB = numeroPunti;
                    continue block5;
                }
                case 2: {
                    this.sensoreC[i] = i * 1023 / (numeroPunti - 1);
                    this.numeroC = numeroPunti;
                }
            }
        }
    }

    public void esportaFile(String Directorypath) {
        File f = null;
        f = new File(Directorypath, "sensor.sen");
        int numeroPunti = this.numeroCB.getSelectedIndex() + 3;
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            out.print("SENSOR");
            block7: for (int i = 0; i < numeroPunti; ++i) {
                switch (this.sensoreCB.getSelectedIndex()) {
                    case 0: {
                        out.print(";" + this.sensoreA[i]);
                        continue block7;
                    }
                    case 1: {
                        out.print(";" + this.sensoreB[i]);
                        continue block7;
                    }
                    case 2: {
                        out.print(";" + this.sensoreC[i]);
                    }
                }
            }
            out.println(";");
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void importaFile(String path) {
        File f = new File(path);
        if (!f.exists()) {
            return;
        }
        try {
            int indice;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String line = in.readLine();
            System.out.println("linea=" + line);
            if (line == null) {
                return;
            }
            if (!line.startsWith("SENSOR;")) {
                return;
            }
            StringTokenizer st = new StringTokenizer(line, ";");
            String valore = st.nextToken();
            block7: for (indice = 0; st.hasMoreTokens() && indice < 10; ++indice) {
                valore = st.nextToken();
                double numero = Double.valueOf(valore);
                switch (this.sensoreCB.getSelectedIndex()) {
                    case 0: {
                        this.sensoreA[indice] = numero;
                        this.numeroA = indice + 1;
                        continue block7;
                    }
                    case 1: {
                        this.sensoreB[indice] = numero;
                        this.numeroB = indice + 1;
                        continue block7;
                    }
                    case 2: {
                        this.sensoreC[indice] = numero;
                        this.numeroC = indice + 1;
                    }
                }
            }
            in.close();
            if (indice < 3) {
                return;
            }
            this.numeroCB.removeActionListener(this);
            this.numeroCB.setSelectedIndex(indice - 3);
            this.numeroCB.addActionListener(this);
            this.aggiornaScelteSelezionato();
            this.aggiornaGrafico();
            if (this.selezionatoCB.getSelectedIndex() != -1) {
                this.aggiornaTF();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void aggiornaSensori(double[] a, double[] b, double[] c, int na, int nb, int nc) {
        for (int i = 0; i < 10; ++i) {
            this.sensoreA[i] = a[i];
            this.sensoreB[i] = b[i];
            this.sensoreC[i] = c[i];
        }
        this.numeroA = na;
        this.numeroB = nb;
        this.numeroC = nc;
        this.numeroCB.removeActionListener(this);
        switch (this.sensoreCB.getSelectedIndex()) {
            case 0: {
                this.numeroCB.setSelectedIndex(this.numeroA - 3);
                break;
            }
            case 1: {
                this.numeroCB.setSelectedIndex(this.numeroB - 3);
                break;
            }
            case 2: {
                this.numeroCB.setSelectedIndex(this.numeroC - 3);
            }
        }
        this.numeroCB.addActionListener(this);
        this.aggiornaScelteSelezionato();
        this.aggiornaGrafico();
        if (this.selezionatoCB.getSelectedIndex() != -1) {
            this.aggiornaTF();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int res;
        if (evt.getSource().equals(this.numeroCB)) {
            int res2 = JOptionPane.showConfirmDialog(this, "Cambiando il numero di punti la curva verr\u00e0 resettata. Preoseguire?", " ", 0, 2);
            if (res2 == 0) {
                this.resettaSensore();
                this.aggiornaScelteSelezionato();
                this.aggiornaGrafico();
            } else {
                switch (this.sensoreCB.getSelectedIndex()) {
                    case 0: {
                        this.numeroCB.setSelectedIndex(this.numeroA - 3);
                        break;
                    }
                    case 1: {
                        this.numeroCB.setSelectedIndex(this.numeroB - 3);
                        break;
                    }
                    case 2: {
                        this.numeroCB.setSelectedIndex(this.numeroC - 3);
                    }
                }
            }
        }
        if (evt.getSource().equals(this.sensoreCB)) {
            this.numeroCB.removeActionListener(this);
            switch (this.sensoreCB.getSelectedIndex()) {
                case 0: {
                    this.numeroCB.setSelectedIndex(this.numeroA - 3);
                    break;
                }
                case 1: {
                    this.numeroCB.setSelectedIndex(this.numeroB - 3);
                    break;
                }
                case 2: {
                    this.numeroCB.setSelectedIndex(this.numeroC - 3);
                }
            }
            this.numeroCB.addActionListener(this);
            this.aggiornaScelteSelezionato();
            this.aggiornaGrafico();
            if (this.selezionatoCB.getSelectedIndex() != -1) {
                this.aggiornaTF();
            }
        }
        if (evt.getSource().equals(this.selezionatoCB)) {
            if (this.selezionatoCB.getSelectedIndex() == -1) {
                return;
            }
            this.aggiornaGrafico();
            this.aggiornaTF();
        }
        if (evt.getSource().equals(this.outTF)) {
            double valore = Double.valueOf(this.outTF.getText());
            switch (this.sensoreCB.getSelectedIndex()) {
                case 0: {
                    this.sensoreA[this.selezionatoCB.getSelectedIndex()] = valore;
                    break;
                }
                case 1: {
                    this.sensoreB[this.selezionatoCB.getSelectedIndex()] = valore;
                    break;
                }
                case 2: {
                    this.sensoreC[this.selezionatoCB.getSelectedIndex()] = valore;
                }
            }
            this.aggiornaGrafico();
        }
        if (evt.getSource().equals(this.esciB)) {
            this.dispose();
        }
        if (evt.getSource().equals(this.applicaB)) {
            if (this.isDasy) {
                this.padreDasy.aggiornaSensori(this.sensoreA, this.sensoreB, this.sensoreC, this.numeroA, this.numeroB, this.numeroC);
            } else {
                this.padre.aggiornaSensori(this.sensoreA, this.sensoreB, this.sensoreC, this.numeroA, this.numeroB, this.numeroC);
            }
            this.dispose();
        }
        if (evt.getSource().equals(this.importaB)) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileNameExtensionFilter("Parametric sensor", "sen"));
            res = fileChooser.showOpenDialog(this);
            if (res == 0) {
                this.importaFile(fileChooser.getSelectedFile().toString());
            }
        }
        if (evt.getSource().equals(this.esportaB)) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            res = fileChooser.showSaveDialog(this);
            if (res == 0) {
                int resultSovrascrivo;
                File f = new File(fileChooser.getSelectedFile().toString(), "sensor.sen");
                if (!f.isAbsolute()) {
                    f = new File(f.getAbsolutePath());
                }
                if (f.exists() && f.canWrite() && ((resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Sovrascrivere il file esistente?"), Language.string("ATTENZIONE"), 0)) == -1 || resultSovrascrivo == 1)) {
                    return;
                }
                if (!f.exists() && f.getParentFile().exists() && f.getParentFile().isDirectory() && f.getParentFile().canWrite() || f.exists() && f.canWrite()) {
                    this.esportaFile(fileChooser.getSelectedFile().toString());
                } else {
                    JOptionPane.showMessageDialog(this, Language.string("Il file non puo essere scritto"), Language.string("ATTENZIONE"), 0);
                    return;
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ParametriciDialog test = new ParametriciDialog(null, null);
        test.setVisible(true);
    }
}

