/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.ScriptDialog;
import i2m.Dialog.inserisciNomeDialog;
import i2m.Language;
import i2m.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.StringTokenizer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MathDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private JButton applicaB;
    private JButton esciB;
    private JButton verificaB;
    private JButton usaFunzioneB;
    private JButton usavariabileB;
    private JButton salvaB;
    private JButton caricaB;
    private JButton cancellaB;
    private JButton resetB;
    private JButton editB;
    private JTextField pathTField;
    private JTextField nameTField;
    private MainFrame padre;
    JRadioButton bottoneMath1;
    JRadioButton bottoneMath2;
    JRadioButton bottoneMath3;
    JRadioButton bottoneMath4;
    JRadioButton bottoneMath5;
    JRadioButton bottoneMath6;
    JRadioButton bottoneMath7;
    JRadioButton bottoneMath8;
    JRadioButton bottoneMath9;
    JRadioButton bottoneMath10;
    JList funzioniJL;
    JList variabiliJL;
    JList memoriaJL;
    private DefaultListModel nomiMemoriaLM;
    private DefaultListModel funzioniMemoriaLM;
    String[] listaFunzioni = new String[]{"(", ")", "+", "-", "*", "/", "pow(a,b)", "log10", "log()", "E", "PI", "sqrt()", "sin()", "cos()", "tan()", "asin()", "acos()", "atan()", "abs()", "IF(condizione,then,else)", "DERIVATIVE(non-recursive expression)", "DERIVATIVE2(non-recursive expression)", "EXTRACT(value,digit)", "BIT(valore,bit)"};
    String[] listaVariabili = new String[]{"Rpm rpm", "speed1 spd1", "speed2 spd2", "Analog1 An1", "Analog2 An2", "Analog3 An3", "Analog4 An4", "Analog5 An5", "Analog6 An6", "Analog7 An7", "Analog8 An8", "dRpm", "dspeed1 dspd1", "dspeed2 dspd2", "dAnalog1 dAn1", "dAnalog2 dAn2", "dAnalog3 dAn3", "dAnalog4 dAn4", "dAnalog5 dAn5", "dAnalog6 dAn6", "dAnalog7 dAn7", "dAnalog8 dAn8", "Multi1 mu1", "Multi2 mu2", "Multi3 mu3", "Multi4 mu4", "Multi5 mu5", "Multi6 mu6", "Multi7 mu7", "Multi8 mu8", "Multi9 mu9", "Multi10 mu10", "Ext-1 Ext1", "Ext-2 Ext2", "Ext-3 Ext3", "Ext-4 Ext4", "d(Ext-1) dExt1", "d(Ext-2) dExt2", "d(Ext-3) dExt3", "d(Ext-4) dExt4", "P.Ant pAnt", "P.Post pPost", "T.Ant. tAnt", "T.Post. tPost", "can001", "can002", "can003", "can004", "can005", "can006", "can007", "can008", "can009", "can010", "can011", "can012", "can013", "can014", "can015", "can016", "can017", "can018", "can019", "can020", "can021", "can022", "can023", "can024", "can025", "can026", "can027", "can028", "can029", "can030", "can031", "can032", "can033", "can034", "can035", "can036", "can037", "can038", "can039", "can040", "can041", "can042", "can043", "can044", "can045", "can046", "can047", "can048", "can049", "can050", "can051", "can052", "can053", "can054", "can055", "can056", "can057", "can058", "can059", "can060", "can061", "can062", "can063", "can064", "can065", "can066", "can067", "can068", "can069", "can070", "can071", "can072", "can073", "can074", "can075", "can076", "can077", "can078", "can079", "can080", "can081", "can082", "can083", "can084", "can085", "can086", "can087", "can088", "can089", "can090", "can091", "can092", "can093", "can094", "can095", "can096", "can097", "can098", "can099", "can100", "can101", "can102", "can103", "can104", "can105", "can106", "can107", "can108", "can109", "can110", "can111", "can112", "can113", "can114", "can115", "can116", "can117", "can118", "can119", "can120", "can121", "can122", "can123", "can124", "can125", "can126", "can127", "can128", "GPS_speed gpsS", "Long_Acc. dgpsS", "Lat_Acc. lacc", "Angle ang", "Altitude alt"};
    String nomeFunzione = null;
    boolean funzioneVerificata;
    JPanel pannelloOld;
    JPanel pannelloNew;
    JPanel pannelloOpzioni;
    JPanel pannelloSopra;
    boolean isJavaScript;
    Reader reader;

    public MathDialog(MainFrame owner) {
        super(owner, Language.string("Configura canali matematici"), true);
        this.padre = owner;
        JPanel pannelloBottoni = new JPanel();
        this.applicaB = new JButton(Language.string("Applica"));
        this.applicaB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.verificaB = new JButton(Language.string("Verifica"));
        this.verificaB.addActionListener(this);
        this.resetB = new JButton(Language.string("Reset"));
        this.resetB.addActionListener(this);
        this.editB = new JButton(Language.string("Edit script"));
        this.editB.addActionListener(this);
        pannelloBottoni.add(this.applicaB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.add(this.verificaB);
        pannelloBottoni.add(this.resetB);
        pannelloBottoni.add(this.editB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        this.pannelloSopra = new JPanel();
        this.pannelloSopra.setLayout(new BoxLayout(this.pannelloSopra, 1));
        this.pannelloSopra.add(Box.createRigidArea(new Dimension(10, 10)));
        JLabel messageLabel = new JLabel(Language.string("Formula:  "));
        JPanel formulaPanel = new JPanel();
        this.pathTField = new JTextField(60);
        this.pathTField.setEnabled(true);
        formulaPanel.setLayout(new BorderLayout());
        formulaPanel.add((Component)messageLabel, "West");
        formulaPanel.add((Component)this.pathTField, "Center");
        this.pannelloSopra.add(formulaPanel);
        JPanel sceltaPanel = new JPanel();
        this.bottoneMath1 = new JRadioButton("Math.1");
        this.bottoneMath2 = new JRadioButton("Math.2");
        this.bottoneMath3 = new JRadioButton("Math.3");
        this.bottoneMath4 = new JRadioButton("Math.4");
        this.bottoneMath5 = new JRadioButton("Math.5");
        this.bottoneMath6 = new JRadioButton("Math.6");
        this.bottoneMath7 = new JRadioButton("Math.7");
        this.bottoneMath8 = new JRadioButton("Math.8");
        this.bottoneMath9 = new JRadioButton("Math.9");
        this.bottoneMath10 = new JRadioButton("Math.10");
        this.bottoneMath1.addActionListener(this);
        this.bottoneMath2.addActionListener(this);
        this.bottoneMath3.addActionListener(this);
        this.bottoneMath4.addActionListener(this);
        this.bottoneMath5.addActionListener(this);
        this.bottoneMath6.addActionListener(this);
        this.bottoneMath7.addActionListener(this);
        this.bottoneMath8.addActionListener(this);
        this.bottoneMath9.addActionListener(this);
        this.bottoneMath10.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.bottoneMath1);
        group.add(this.bottoneMath2);
        group.add(this.bottoneMath3);
        group.add(this.bottoneMath4);
        group.add(this.bottoneMath5);
        group.add(this.bottoneMath6);
        group.add(this.bottoneMath7);
        group.add(this.bottoneMath8);
        group.add(this.bottoneMath9);
        group.add(this.bottoneMath10);
        this.bottoneMath1.setSelected(true);
        this.nameTField = new JTextField(10);
        this.nameTField.setEnabled(true);
        JLabel nameLabel = new JLabel(Language.string("     Nome canale:  "));
        sceltaPanel.add(this.bottoneMath1);
        sceltaPanel.add(this.bottoneMath2);
        sceltaPanel.add(this.bottoneMath3);
        sceltaPanel.add(this.bottoneMath4);
        sceltaPanel.add(this.bottoneMath5);
        sceltaPanel.add(this.bottoneMath6);
        sceltaPanel.add(this.bottoneMath7);
        sceltaPanel.add(this.bottoneMath8);
        sceltaPanel.add(this.bottoneMath9);
        sceltaPanel.add(this.bottoneMath10);
        pannelloBottoni.add(nameLabel);
        pannelloBottoni.add(this.nameTField);
        sceltaPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JPanel pannelloSotto = new JPanel(new BorderLayout());
        pannelloSotto.add((Component)sceltaPanel, "North");
        pannelloSotto.add((Component)pannelloBottoni, "South");
        JPanel pannelloSCroll = new JPanel();
        JPanel pannelloFunzioni = new JPanel(new BorderLayout());
        JPanel pannelloVariabili = new JPanel(new BorderLayout());
        JPanel pannelloSalvataggio = new JPanel(new BorderLayout());
        JLabel funzioniLabel = new JLabel(Language.string("Elenco Funzioni:"));
        this.usaFunzioneB = new JButton(Language.string("Inserisci"));
        this.usaFunzioneB.addActionListener(this);
        this.funzioniJL = new JList<String>(this.listaFunzioni);
        JScrollPane scrollFunzioni = new JScrollPane(this.funzioniJL, 22, 30);
        pannelloFunzioni.add((Component)scrollFunzioni, "Center");
        pannelloFunzioni.add((Component)funzioniLabel, "North");
        pannelloFunzioni.add((Component)this.usaFunzioneB, "South");
        scrollFunzioni.setPreferredSize(new Dimension(200, 120));
        this.usaFunzioneB.setPreferredSize(new Dimension(200, 30));
        JLabel variabiliLabel = new JLabel(Language.string("Elenco Variabili:"));
        this.usavariabileB = new JButton(Language.string("Inserisci"));
        this.usavariabileB.addActionListener(this);
        this.variabiliJL = new JList<String>(this.listaVariabili);
        this.aggiornaNomi();
        JScrollPane scrollVariabili = new JScrollPane(this.variabiliJL, 22, 30);
        pannelloVariabili.add((Component)scrollVariabili, "Center");
        pannelloVariabili.add((Component)variabiliLabel, "North");
        pannelloVariabili.add((Component)this.usavariabileB, "South");
        scrollVariabili.setPreferredSize(new Dimension(200, 120));
        this.usavariabileB.setPreferredSize(new Dimension(200, 30));
        JLabel memoriaLabel = new JLabel(Language.string("Funzioni in memoria:"));
        this.salvaB = new JButton(Language.string("Salva"));
        this.salvaB.setPreferredSize(new Dimension(90, 25));
        this.salvaB.setMaximumSize(new Dimension(90, 25));
        this.salvaB.setMinimumSize(new Dimension(90, 25));
        this.salvaB.addActionListener(this);
        this.caricaB = new JButton(Language.string("Carica"));
        this.caricaB.setPreferredSize(new Dimension(90, 25));
        this.caricaB.setMaximumSize(new Dimension(90, 25));
        this.caricaB.setMinimumSize(new Dimension(90, 25));
        this.caricaB.addActionListener(this);
        this.cancellaB = new JButton(Language.string("Elimina"));
        this.cancellaB.setPreferredSize(new Dimension(90, 25));
        this.cancellaB.setMaximumSize(new Dimension(90, 25));
        this.cancellaB.setMinimumSize(new Dimension(90, 25));
        this.cancellaB.addActionListener(this);
        JPanel pannelloComandi = new JPanel();
        pannelloComandi.setLayout(new BoxLayout(pannelloComandi, 1));
        pannelloComandi.setAlignmentX(0.0f);
        pannelloComandi.add(Box.createRigidArea(new Dimension(5, 5)));
        pannelloComandi.add(this.caricaB);
        pannelloComandi.add(Box.createRigidArea(new Dimension(5, 5)));
        pannelloComandi.add(this.salvaB);
        pannelloComandi.add(Box.createRigidArea(new Dimension(5, 5)));
        pannelloComandi.add(this.cancellaB);
        this.nomiMemoriaLM = new DefaultListModel();
        this.funzioniMemoriaLM = new DefaultListModel();
        this.memoriaJL = new JList(this.nomiMemoriaLM);
        JScrollPane scrollMemoria = new JScrollPane(this.memoriaJL, 22, 30);
        pannelloSalvataggio.add((Component)scrollMemoria, "Center");
        pannelloSalvataggio.add((Component)memoriaLabel, "North");
        scrollMemoria.setPreferredSize(new Dimension(200, 150));
        pannelloComandi.setPreferredSize(new Dimension(100, 150));
        pannelloSCroll.add(Box.createRigidArea(new Dimension(5, 0)));
        pannelloSCroll.add(pannelloFunzioni);
        pannelloSCroll.add(Box.createRigidArea(new Dimension(5, 0)));
        pannelloSCroll.add(pannelloVariabili);
        pannelloSCroll.add(Box.createRigidArea(new Dimension(5, 0)));
        pannelloSCroll.add(pannelloSalvataggio);
        pannelloSCroll.add(Box.createRigidArea(new Dimension(5, 0)));
        pannelloSCroll.add(pannelloComandi);
        pannelloSCroll.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        pannelloPrincipale.add((Component)this.pannelloSopra, "North");
        pannelloPrincipale.add((Component)pannelloSCroll, "Center");
        pannelloPrincipale.add((Component)pannelloSotto, "South");
        this.pathTField.setText(DanasPreferences.getFormulaMath(0, false));
        this.nameTField.setText(DanasPreferences.getNomeMath(0, false));
        this.apriFile();
        this.setContentPane(pannelloPrincipale);
        this.setSize(new Dimension(780, 330));
    }

    public void aggiornaNomi() {
        int i;
        if (DanasDataStructure.getInstance().getDefaultSession() == null) {
            return;
        }
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        listModel.addElement("Rpm rpm");
        listModel.addElement("speed1 spd1");
        listModel.addElement("speed2 spd2");
        for (i = 0; i < 8; ++i) {
            listModel.addElement(DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNomeAnalogici(i + 1) + " An" + (i + 1));
        }
        listModel.addElement("dRpm drpm");
        listModel.addElement("dspeed1 dspd1");
        listModel.addElement("dspeed2 dspd2");
        for (i = 0; i < 8; ++i) {
            listModel.addElement("d(" + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNomeAnalogici(i + 1) + ") dAn" + (i + 1));
        }
        for (i = 0; i < 10; ++i) {
            listModel.addElement(DanasDataStructure.getInstance().getNomeMulti(i) + " mu" + (i + 1));
        }
        for (i = 0; i < 4; ++i) {
            listModel.addElement(DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNomeAnalogici(i + 9) + " Ext" + (i + 1));
        }
        for (i = 0; i < 4; ++i) {
            listModel.addElement("d(" + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNomeAnalogici(i + 9) + ") dExt" + (i + 1));
        }
        listModel.addElement("P.Ant pAnt");
        listModel.addElement("P.Post pPost");
        listModel.addElement("T.Ant. tAnt");
        listModel.addElement("T.Post. tPost");
        for (i = 0; i < 128; ++i) {
            listModel.addElement(DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(DanasDataStructureConstants.ValueType.values()[DanasDataStructureConstants.ValueType.CAN1.ordinal() + i]) + String.format(" can%03d", i + 1));
        }
        listModel.addElement("GPS_speed gpsS");
        listModel.addElement("Long_acc dgpsS");
        listModel.addElement("Lat_Acc. lacc");
        listModel.addElement("Angle ang");
        listModel.addElement("Altitude alt");
        this.variabiliJL = new JList(listModel);
    }

    public synchronized void setFunzioneVerificata(boolean funzioneOk) {
        this.funzioneVerificata = funzioneOk;
    }

    public synchronized boolean getFunzioneVerificata() {
        return this.funzioneVerificata;
    }

    public void scriviFunzione(String testo) {
        this.pathTField.setText(testo);
    }

    public boolean verifica() {
        String prog;
        this.setFunzioneVerificata(true);
        if (this.pathTField.getText().startsWith("FRIZIONE(")) {
            double[] valori = MeasuresUtil.estraiParametriFrizione(this.pathTField.getText());
            return valori[10] == 0.0;
        }
        if (this.pathTField.getText().startsWith("TAGLIO(") || this.pathTField.getText().startsWith("ENGINE_BRAKE(")) {
            int[] valori = MeasuresUtil.estraiParametriTaglioBrake(this.pathTField.getText(), this.pathTField.getText().startsWith("ENGINE_BRAKE("));
            return valori[2] == 0;
        }
        ScriptEngineManager factory = new ScriptEngineManager();
        final ScriptEngine engine = factory.getEngineByName("JavaScript");
        String nuovaVersione = this.pathTField.getText();
        final MyBuffer fineScript = new MyBuffer();
        if (!this.pathTField.getText().startsWith("JavaScript(")) {
            System.out.println("espressione normale");
            this.isJavaScript = false;
            double rpm = 1.0;
            double spd1 = 1.0;
            double spd2 = 1.0;
            double An1 = 1.0;
            double An2 = 1.0;
            double An3 = 1.0;
            double An4 = 1.0;
            double An5 = 1.0;
            double An6 = 1.0;
            double An7 = 1.0;
            double An8 = 1.0;
            double Ext1 = 1.0;
            double Ext2 = 1.0;
            double dExt1 = 1.0;
            double dExt2 = 1.0;
            double Ext3 = 1.0;
            double Ext4 = 1.0;
            double dExt3 = 1.0;
            double dExt4 = 1.0;
            double drpm = 1.0;
            double dspd1 = 1.0;
            double dspd2 = 1.0;
            double dAn1 = 1.0;
            double dAn2 = 1.0;
            double dAn3 = 1.0;
            double dAn4 = 1.0;
            double dAn5 = 1.0;
            double dAn6 = 1.0;
            double dAn7 = 1.0;
            double dAn8 = 1.0;
            double mu1 = 1.0;
            double mu2 = 1.0;
            double mu3 = 1.0;
            double mu4 = 1.0;
            double mu5 = 1.0;
            double mu6 = 1.0;
            double mu7 = 1.0;
            double mu8 = 1.0;
            double mu9 = 1.0;
            double mu10 = 1.0;
            double pant = 1.0;
            double tant = 1.0;
            double ppost = 1.0;
            double tpost = 1.0;
            double gpsS = 1.0;
            double dgpsS = 1.0;
            double ang = 1.0;
            double lacc = 1.0;
            double alt = 1.0;
            double[] canaliCan = new double[128];
            for (int i = 0; i < 128; ++i) {
                canaliCan[i] = 1.0;
                String nome = String.format("can%03d", i + 1);
                engine.put(nome, canaliCan[i]);
            }
            engine.put("rpm", rpm);
            engine.put("spd1", spd1);
            engine.put("spd2", spd2);
            engine.put("gpsS", gpsS);
            engine.put("dgpsS", dgpsS);
            engine.put("ang", ang);
            engine.put("lacc", lacc);
            engine.put("alt", alt);
            engine.put("An1", An1);
            engine.put("An2", An2);
            engine.put("An3", An3);
            engine.put("An4", An4);
            engine.put("An5", An5);
            engine.put("An6", An6);
            engine.put("An7", An7);
            engine.put("An8", An8);
            engine.put("Ext1", Ext1);
            engine.put("Ext2", Ext2);
            engine.put("dExt1", dExt1);
            engine.put("dExt2", dExt2);
            engine.put("Ext3", Ext3);
            engine.put("Ext4", Ext4);
            engine.put("dExt3", dExt3);
            engine.put("dExt4", dExt4);
            engine.put("drpm", drpm);
            engine.put("dspd1", dspd1);
            engine.put("dspd2", dspd2);
            engine.put("mu1", mu1);
            engine.put("mu2", mu2);
            engine.put("mu3", mu3);
            engine.put("mu4", mu4);
            engine.put("mu5", mu5);
            engine.put("mu6", mu6);
            engine.put("mu7", mu7);
            engine.put("mu8", mu8);
            engine.put("mu9", mu9);
            engine.put("mu10", mu10);
            engine.put("pAnt", pant);
            engine.put("tAnt", tant);
            engine.put("pPost", ppost);
            engine.put("tPost", tpost);
            engine.put("dAn1", dAn1);
            engine.put("dAn2", dAn2);
            engine.put("dAn3", dAn3);
            engine.put("dAn4", dAn4);
            engine.put("dAn5", dAn5);
            engine.put("dAn6", dAn6);
            engine.put("dAn7", dAn7);
            engine.put("dAn8", dAn8);
            engine.put("fineScript", fineScript);
            nuovaVersione = this.replaceDerivative(nuovaVersione);
            nuovaVersione = this.replaceDerivative2(nuovaVersione);
            System.out.println("Nuova espressione math=" + nuovaVersione);
            prog = "function log10(x){return Math.log(x)/Math.log(10);}function BIT(x,indice){return (x&(Math.pow(2,indice)))/Math.pow(2,indice);}function DER(expr){ prec=eval(expr); return prec;}function DER2(expr){ prec=eval(expr); return prec;}function EXTRACT(valore,cifra){if (cifra==0) {return 0};res=valore; if (valore<0) {res=-valore};  sopra=res-(Math.floor(res/Math.pow(10,cifra))*Math.pow(10,cifra));res=Math.floor(sopra/Math.pow(10,cifra-1))  ;return res;}function IF(cond,a,b){if (cond){return a;}else{return b;}}with (Math){y=" + nuovaVersione + ";}   fineScript.put(y);";
        } else {
            int i;
            prog = "";
            this.isJavaScript = true;
            int size = 1000;
            double[] tempob = new double[size];
            double[] rpmb = new double[size];
            double[] spd1b = new double[size];
            double[] spd2b = new double[size];
            double[] An1b = new double[size];
            double[] An2b = new double[size];
            double[] An3b = new double[size];
            double[] An4b = new double[size];
            double[] An5b = new double[size];
            double[] An6b = new double[size];
            double[] An7b = new double[size];
            double[] An8b = new double[size];
            double[] mu1b = new double[size];
            double[] mu2b = new double[size];
            double[] mu3b = new double[size];
            double[] mu4b = new double[size];
            double[] mu5b = new double[size];
            double[] mu6b = new double[size];
            double[] mu7b = new double[size];
            double[] mu8b = new double[size];
            double[] mu9b = new double[size];
            double[] muXb = new double[size];
            double[] pantb = new double[size];
            double[] tantb = new double[size];
            double[] ppostb = new double[size];
            double[] tpostb = new double[size];
            double[] output = new double[size];
            double[] Ext1b = new double[size];
            double[] Ext2b = new double[size];
            double[] Ext3b = new double[size];
            double[] Ext4b = new double[size];
            double[] gpsSb = new double[size];
            double[] angb = new double[size];
            double[] laccb = new double[size];
            double[] altb = new double[size];
            double[] drpmb = new double[size];
            double[] dspd1b = new double[size];
            double[] dspd2b = new double[size];
            double[] dAn1b = new double[size];
            double[] dAn2b = new double[size];
            double[] dAn3b = new double[size];
            double[] dAn4b = new double[size];
            double[] dAn5b = new double[size];
            double[] dAn6b = new double[size];
            double[] dAn7b = new double[size];
            double[] dAn8b = new double[size];
            double[] dExt1b = new double[size];
            double[] dExt2b = new double[size];
            double[] dExt3b = new double[size];
            double[] dExt4b = new double[size];
            double[] dgpsSb = new double[size];
            for (i = 0; i < 128; ++i) {
                double[] valori = new double[size];
                for (int j = 0; j < size; ++j) {
                    valori[j] = 1.0;
                }
                String nome = String.format("can%03d", i + 1);
                engine.put(nome, valori);
            }
            for (i = 0; i < size; ++i) {
                double currentt;
                tempob[i] = currentt = (double)i;
                rpmb[i] = 1.0;
                spd1b[i] = 1.0;
                spd2b[i] = 1.0;
                An1b[i] = 1.0;
                An2b[i] = 1.0;
                An3b[i] = 1.0;
                An4b[i] = 1.0;
                An5b[i] = 1.0;
                An6b[i] = 1.0;
                An7b[i] = 1.0;
                An8b[i] = 1.0;
                Ext1b[i] = 1.0;
                Ext2b[i] = 1.0;
                Ext3b[i] = 1.0;
                Ext4b[i] = 1.0;
                mu1b[i] = 1.0;
                mu2b[i] = 1.0;
                mu3b[i] = 1.0;
                mu4b[i] = 1.0;
                mu5b[i] = 1.0;
                mu6b[i] = 1.0;
                mu7b[i] = 1.0;
                mu8b[i] = 1.0;
                mu9b[i] = 1.0;
                muXb[i] = 1.0;
                pantb[i] = 1.0;
                tantb[i] = 1.0;
                ppostb[i] = 1.0;
                tpostb[i] = 1.0;
                gpsSb[i] = 1.0;
                angb[i] = 1.0;
                laccb[i] = 1.0;
                altb[i] = 1.0;
                dgpsSb[i] = 1.0;
                drpmb[i] = 1.0;
                dspd1b[i] = 1.0;
                dspd2b[i] = 1.0;
                dAn1b[i] = 1.0;
                dAn2b[i] = 1.0;
                dAn3b[i] = 1.0;
                dAn4b[i] = 1.0;
                dAn5b[i] = 1.0;
                dAn6b[i] = 1.0;
                dAn7b[i] = 1.0;
                dAn8b[i] = 1.0;
                dExt1b[i] = 1.0;
                dExt2b[i] = 1.0;
                dExt3b[i] = 1.0;
                dExt4b[i] = 1.0;
            }
            engine.put("rpm", rpmb);
            engine.put("spd1", spd1b);
            engine.put("spd2", spd2b);
            engine.put("An1", An1b);
            engine.put("An2", An2b);
            engine.put("An3", An3b);
            engine.put("An4", An4b);
            engine.put("An5", An5b);
            engine.put("An6", An6b);
            engine.put("An7", An7b);
            engine.put("An8", An8b);
            engine.put("Ext1", Ext1b);
            engine.put("Ext2", Ext2b);
            engine.put("Ext3", Ext3b);
            engine.put("Ext4", Ext4b);
            engine.put("mu1", mu1b);
            engine.put("mu2", mu2b);
            engine.put("mu3", mu3b);
            engine.put("mu4", mu4b);
            engine.put("mu5", mu5b);
            engine.put("mu6", mu6b);
            engine.put("mu7", mu7b);
            engine.put("mu8", mu8b);
            engine.put("mu9", mu9b);
            engine.put("mu10", muXb);
            engine.put("pAnt", pantb);
            engine.put("tAnt", tantb);
            engine.put("pPost", ppostb);
            engine.put("tPost", tpostb);
            engine.put("gpsS", gpsSb);
            engine.put("ang", angb);
            engine.put("lacc", laccb);
            engine.put("alt", altb);
            engine.put("dgpsS", dgpsSb);
            engine.put("drpm", drpmb);
            engine.put("dspd1", dspd1b);
            engine.put("dspd2", dspd2b);
            engine.put("dAn1", dAn1b);
            engine.put("dAn2", dAn2b);
            engine.put("dAn3", dAn3b);
            engine.put("dAn4", dAn4b);
            engine.put("dAn5", dAn5b);
            engine.put("dAn6", dAn6b);
            engine.put("dAn7", dAn7b);
            engine.put("dAn8", dAn8b);
            engine.put("dExt1", dExt1b);
            engine.put("dExt2", dExt2b);
            engine.put("dExt3", dExt3b);
            engine.put("dExt4", dExt4b);
            engine.put("fineScript", fineScript);
            engine.put("output", output);
            engine.put("size", size);
            engine.put("time", tempob);
            String percorsoFile = this.pathTField.getText().substring(11);
            StringTokenizer st = new StringTokenizer(percorsoFile, ",");
            if (!st.hasMoreTokens()) {
                return false;
            }
            percorsoFile = st.nextToken();
            System.out.println("Percorso file javascript=" + percorsoFile);
            if (st.hasMoreTokens()) {
                String ver = st.nextToken();
                try {
                    Integer versione = Integer.valueOf(ver);
                }
                catch (Exception dAn8) {}
            } else {
                return false;
            }
            try {
                File f = File.createTempFile("tempScript", "tmp");
                f.deleteOnExit();
                boolean res = MeasuresUtil.copy(new File(percorsoFile), f);
                if (!res) {
                    return false;
                }
                PrintWriter scriviFile = new PrintWriter(new FileWriter(f, true));
                scriviFile.printf("\n\r fineScript.put(1);", new Object[0]);
                scriviFile.close();
                this.reader = new FileReader(f);
            }
            catch (Exception e) {
                return false;
            }
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    if (MathDialog.this.isJavaScript) {
                        engine.eval(MathDialog.this.reader);
                    } else {
                        engine.eval(prog);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Errore JavaScript");
                    MathDialog.this.setFunzioneVerificata(false);
                    try {
                        fineScript.put(0.0);
                    }
                    catch (Exception e) {
                        System.out.println("Errore asegnamento");
                    }
                }
            }
        };
        t.start();
        try {
            System.out.println("Risultato test Script=" + fineScript.get());
        }
        catch (Exception e) {
            System.out.println("Errore lettura get");
        }
        return this.getFunzioneVerificata();
    }

    public String replaceDerivative(String s) {
        if (!s.contains("DERIVATIVE(")) {
            return s;
        }
        int parentesiAperte = 1;
        int pos = s.indexOf("DERIVATIVE(");
        while (pos != -1) {
            parentesiAperte = 1;
            for (int i = pos + 11; i < s.length(); ++i) {
                if (s.charAt(i) == '(') {
                    ++parentesiAperte;
                }
                if (s.charAt(i) == ')') {
                    --parentesiAperte;
                }
                if (parentesiAperte != 0) continue;
                String contenuto = s.substring(pos + 11, i);
                if (contenuto.contains("DERIVATIVE")) {
                    contenuto = "cccccc";
                }
                s = s.substring(0, pos) + "DER(" + contenuto + ")" + s.substring(i + 1, s.length());
                break;
            }
            pos = s.indexOf("DERIVATIVE(");
        }
        return s;
    }

    public String replaceDerivative2(String s) {
        if (!s.contains("DERIVATIVE2(")) {
            return s;
        }
        int parentesiAperte = 1;
        int pos = s.indexOf("DERIVATIVE2(");
        while (pos != -1) {
            parentesiAperte = 1;
            for (int i = pos + 12; i < s.length(); ++i) {
                if (s.charAt(i) == '(') {
                    ++parentesiAperte;
                }
                if (s.charAt(i) == ')') {
                    --parentesiAperte;
                }
                if (parentesiAperte != 0) continue;
                String contenuto = s.substring(pos + 12, i);
                if (contenuto.contains("DERIVATIVE") || contenuto.contains("DERIVATIVE2")) {
                    contenuto = "cccccc";
                }
                s = s.substring(0, pos) + "DER2(" + contenuto + ")" + s.substring(i + 1, s.length());
                break;
            }
            pos = s.indexOf("DERIVATIVE2(");
        }
        return s;
    }

    public void caricaFunzione() {
        if (this.memoriaJL.getSelectedIndices().length != 1) {
            return;
        }
        String funzione = (String)this.funzioniMemoriaLM.getElementAt(this.memoriaJL.getSelectedIndex());
        this.pathTField.setText(funzione);
        this.nameTField.setText((String)this.memoriaJL.getSelectedValue());
    }

    public void rimuoviFunzione() {
        if (this.memoriaJL.getSelectedIndices().length != 1) {
            return;
        }
        int index = this.memoriaJL.getSelectedIndex();
        int res = JOptionPane.showConfirmDialog(this, Language.string("La funzione verr\u00e0 eliminata. Proseguire?"), Language.string("Attenzione"), 0);
        if (res == -1 || res == 1) {
            return;
        }
        this.funzioniMemoriaLM.removeElementAt(index);
        this.nomiMemoriaLM.removeElementAt(index);
        this.saveFile();
    }

    public void salvaFunzione() {
        if (!this.verifica()) {
            JOptionPane.showMessageDialog(this, Language.string("L'espressione non risulta corretta"), Language.string("ATTENZIONE"), 2);
            return;
        }
        inserisciNomeDialog d = new inserisciNomeDialog(this);
        d.setLocationRelativeTo(null);
        d.setVisible(true);
        this.nomeFunzione = d.getName();
        if (this.nomeFunzione != null) {
            this.funzioniMemoriaLM.addElement(this.pathTField.getText());
            this.nomiMemoriaLM.addElement(this.nomeFunzione);
            this.saveFile();
        }
    }

    public void inserisciFunzione() {
        String funzione;
        if (this.funzioniJL.getSelectedIndices().length != 1) {
            return;
        }
        String s = this.pathTField.getText();
        switch (this.funzioniJL.getSelectedIndex()) {
            case 0: {
                funzione = "(";
                break;
            }
            case 1: {
                funzione = ")";
                break;
            }
            case 2: {
                funzione = "+";
                break;
            }
            case 3: {
                funzione = "-";
                break;
            }
            case 4: {
                funzione = "*";
                break;
            }
            case 5: {
                funzione = "/";
                break;
            }
            case 6: {
                funzione = "pow(";
                break;
            }
            case 7: {
                funzione = "log10(";
                break;
            }
            case 8: {
                funzione = "log(";
                break;
            }
            case 9: {
                funzione = "E";
                break;
            }
            case 10: {
                funzione = "PI";
                break;
            }
            case 11: {
                funzione = "sqrt(";
                break;
            }
            case 12: {
                funzione = "sin(";
                break;
            }
            case 13: {
                funzione = "cos(";
                break;
            }
            case 14: {
                funzione = "tan(";
                break;
            }
            case 15: {
                funzione = "asin(";
                break;
            }
            case 16: {
                funzione = "acos(";
                break;
            }
            case 17: {
                funzione = "atan(";
                break;
            }
            case 18: {
                funzione = "abs(";
                break;
            }
            case 19: {
                funzione = "IF(condizione,then,else)";
                break;
            }
            case 20: {
                funzione = "DERIVATIVE(non-recursive expression)";
                break;
            }
            case 21: {
                funzione = "DERIVATIVE2(non-recursive expression)";
                break;
            }
            case 22: {
                funzione = "EXTRACT(value,digit)";
                break;
            }
            case 23: {
                funzione = "BIT(value,bit)";
                break;
            }
            case 24: {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter("Java script", "txt"));
                int res = fileChooser.showOpenDialog(this);
                if (res == 0) {
                    File f = fileChooser.getSelectedFile();
                    funzione = "JavaScript(" + f.getAbsolutePath() + ",0,)";
                    s = "";
                    break;
                }
                funzione = "";
                break;
            }
            default: {
                funzione = "";
            }
        }
        s = s + funzione;
        this.pathTField.setText(s);
    }

    public void inserisciVariabile() {
        String funzione;
        if (this.variabiliJL.getSelectedIndices().length != 1) {
            return;
        }
        String s = this.pathTField.getText();
        switch (this.variabiliJL.getSelectedIndex()) {
            case 0: {
                funzione = "rpm";
                break;
            }
            case 1: {
                funzione = "spd1";
                break;
            }
            case 2: {
                funzione = "spd2";
                break;
            }
            case 3: {
                funzione = "An1";
                break;
            }
            case 4: {
                funzione = "An2";
                break;
            }
            case 5: {
                funzione = "An3";
                break;
            }
            case 6: {
                funzione = "An4";
                break;
            }
            case 7: {
                funzione = "An5";
                break;
            }
            case 8: {
                funzione = "An6";
                break;
            }
            case 9: {
                funzione = "An7";
                break;
            }
            case 10: {
                funzione = "An8";
                break;
            }
            case 11: {
                funzione = "drpm";
                break;
            }
            case 12: {
                funzione = "dspd1";
                break;
            }
            case 13: {
                funzione = "dspd2";
                break;
            }
            case 14: {
                funzione = "dAn1";
                break;
            }
            case 15: {
                funzione = "dAn2";
                break;
            }
            case 16: {
                funzione = "dAn3";
                break;
            }
            case 17: {
                funzione = "dAn4";
                break;
            }
            case 18: {
                funzione = "dAn5";
                break;
            }
            case 19: {
                funzione = "dAn6";
                break;
            }
            case 20: {
                funzione = "dAn7";
                break;
            }
            case 21: {
                funzione = "dAn8";
                break;
            }
            case 22: {
                funzione = "mu1";
                break;
            }
            case 23: {
                funzione = "mu2";
                break;
            }
            case 24: {
                funzione = "mu3";
                break;
            }
            case 25: {
                funzione = "mu4";
                break;
            }
            case 26: {
                funzione = "mu5";
                break;
            }
            case 27: {
                funzione = "mu6";
                break;
            }
            case 28: {
                funzione = "mu7";
                break;
            }
            case 29: {
                funzione = "mu8";
                break;
            }
            case 30: {
                funzione = "mu9";
                break;
            }
            case 31: {
                funzione = "mu10";
                break;
            }
            case 32: {
                funzione = "Ext1";
                break;
            }
            case 33: {
                funzione = "Ext2";
                break;
            }
            case 34: {
                funzione = "Ext3";
                break;
            }
            case 35: {
                funzione = "Ext4";
                break;
            }
            case 36: {
                funzione = "dExt1";
                break;
            }
            case 37: {
                funzione = "dExt2";
                break;
            }
            case 38: {
                funzione = "dExt3";
                break;
            }
            case 39: {
                funzione = "dExt4";
                break;
            }
            case 40: {
                funzione = "pAnt";
                break;
            }
            case 41: {
                funzione = "pPost";
                break;
            }
            case 42: {
                funzione = "tAnt";
                break;
            }
            case 43: {
                funzione = "tPost";
                break;
            }
            case 172: {
                funzione = "gpsS";
                break;
            }
            case 173: {
                funzione = "dgpsS";
                break;
            }
            case 174: {
                funzione = "lacc";
                break;
            }
            case 175: {
                funzione = "ang";
                break;
            }
            case 176: {
                funzione = "alt";
                break;
            }
            default: {
                funzione = this.variabiliJL.getSelectedIndex() >= 44 && this.variabiliJL.getSelectedIndex() <= 171 ? String.format("can%03d", this.variabiliJL.getSelectedIndex() - 43) : "";
            }
        }
        s = s + funzione;
        this.pathTField.setText(s);
    }

    public void apriFile() {
        File f = new File("./myFunctions.fng");
        this.memoriaJL.removeAll();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.memoriaJL.clearSelection();
            this.nomiMemoriaLM.clear();
            this.funzioniMemoriaLM.clear();
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ";");
                String t = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String t2 = st.nextToken();
                this.nomiMemoriaLM.addElement(t);
                this.funzioniMemoriaLM.addElement(t2);
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("Log: file myFunctions non presente o errore nel parsing");
        }
    }

    public void saveFile() {
        File f = new File("./myFunctions.fng");
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            this.memoriaJL.clearSelection();
            for (int i = 0; i < this.nomiMemoriaLM.size(); ++i) {
                out.println(this.nomiMemoriaLM.getElementAt(i) + ";" + this.funzioniMemoriaLM.getElementAt(i));
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.esciB) {
            this.dispose();
        }
        if (evt.getSource() == this.resetB) {
            this.pathTField.setText("0");
        }
        if (evt.getSource() == this.usaFunzioneB) {
            this.inserisciFunzione();
        }
        if (evt.getSource() == this.caricaB) {
            this.caricaFunzione();
        }
        if (evt.getSource() == this.cancellaB) {
            this.rimuoviFunzione();
        }
        if (evt.getSource() == this.salvaB) {
            this.salvaFunzione();
        }
        if (evt.getSource() == this.bottoneMath1 || evt.getSource() == this.bottoneMath2 || evt.getSource() == this.bottoneMath3 || evt.getSource() == this.bottoneMath4 || evt.getSource() == this.bottoneMath5 || evt.getSource() == this.bottoneMath6 || evt.getSource() == this.bottoneMath7 || evt.getSource() == this.bottoneMath8 || evt.getSource() == this.bottoneMath9 || evt.getSource() == this.bottoneMath10) {
            String s = "0";
            String name = "Math";
            if (this.bottoneMath1.isSelected()) {
                s = DanasPreferences.getFormulaMath(0, false);
                name = DanasPreferences.getNomeMath(0, false);
            }
            if (this.bottoneMath2.isSelected()) {
                s = DanasPreferences.getFormulaMath(1, false);
                name = DanasPreferences.getNomeMath(1, false);
            }
            if (this.bottoneMath3.isSelected()) {
                s = DanasPreferences.getFormulaMath(2, false);
                name = DanasPreferences.getNomeMath(2, false);
            }
            if (this.bottoneMath4.isSelected()) {
                s = DanasPreferences.getFormulaMath(3, false);
                name = DanasPreferences.getNomeMath(3, false);
            }
            if (this.bottoneMath5.isSelected()) {
                s = DanasPreferences.getFormulaMath(4, false);
                name = DanasPreferences.getNomeMath(4, false);
            }
            if (this.bottoneMath6.isSelected()) {
                s = DanasPreferences.getFormulaMath(5, false);
                name = DanasPreferences.getNomeMath(5, false);
            }
            if (this.bottoneMath7.isSelected()) {
                s = DanasPreferences.getFormulaMath(6, false);
                name = DanasPreferences.getNomeMath(6, false);
            }
            if (this.bottoneMath8.isSelected()) {
                s = DanasPreferences.getFormulaMath(7, false);
                name = DanasPreferences.getNomeMath(7, false);
            }
            if (this.bottoneMath9.isSelected()) {
                s = DanasPreferences.getFormulaMath(8, false);
                name = DanasPreferences.getNomeMath(8, false);
            }
            if (this.bottoneMath10.isSelected()) {
                s = DanasPreferences.getFormulaMath(9, false);
                name = DanasPreferences.getNomeMath(9, false);
            }
            this.pathTField.setText(s);
            this.nameTField.setText(name);
        }
        if (evt.getSource() == this.usavariabileB) {
            this.inserisciVariabile();
        }
        if (evt.getSource() == this.verificaB) {
            if (this.verifica()) {
                JOptionPane.showMessageDialog(this, Language.string("Espressione verificata"), Language.string("INFO"), 1);
            } else {
                JOptionPane.showMessageDialog(this, Language.string("L'espressione non risulta corretta"), Language.string("ATTENZIONE"), 2);
            }
        }
        if (evt.getSource() == this.applicaB) {
            if (this.verifica()) {
                int indice = 0;
                if (this.bottoneMath1.isSelected()) {
                    indice = 0;
                }
                if (this.bottoneMath2.isSelected()) {
                    indice = 1;
                }
                if (this.bottoneMath3.isSelected()) {
                    indice = 2;
                }
                if (this.bottoneMath4.isSelected()) {
                    indice = 3;
                }
                if (this.bottoneMath5.isSelected()) {
                    indice = 4;
                }
                if (this.bottoneMath6.isSelected()) {
                    indice = 5;
                }
                if (this.bottoneMath7.isSelected()) {
                    indice = 6;
                }
                if (this.bottoneMath8.isSelected()) {
                    indice = 7;
                }
                if (this.bottoneMath9.isSelected()) {
                    indice = 8;
                }
                if (this.bottoneMath10.isSelected()) {
                    indice = 9;
                }
                DanasPreferences.setFormulaMath(indice, this.pathTField.getText());
                DanasPreferences.setNomeMath(indice, this.nameTField.getText());
                this.padre.aggiornaCanaliMatematici(true, true);
                DanasDataStructure.getInstance().setChange(DanasDataStructureConstants.ChangeType.NEW_SETTINGS);
            } else {
                JOptionPane.showMessageDialog(this, Language.string("L'espressione non risulta corretta"), Language.string("ATTENZIONE"), 2);
            }
        }
        if (evt.getSource() == this.editB) {
            ScriptDialog d = new ScriptDialog(this);
            if (this.pathTField.getText().startsWith("JavaScript")) {
                String s = this.pathTField.getText().substring(11);
                StringTokenizer st = new StringTokenizer(s, ",");
                if (st.hasMoreTokens()) {
                    String pathFile = st.nextToken();
                    d.setNomeFile(pathFile);
                    d.apriFile(new File(pathFile));
                }
                Integer versione = 0;
                if (st.hasMoreTokens()) {
                    String ver = st.nextToken();
                    try {
                        versione = Integer.valueOf(ver);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                d.setVersione(versione);
            }
            d.setLocationRelativeTo(null);
            d.setVisible(true);
        }
    }

    public static void main(String[] args) {
        MathDialog test = new MathDialog(null);
        test.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
    }

    public class MyBuffer {
        private Double data = null;

        public synchronized double get() throws Exception {
            while (this.data == null) {
                this.wait();
            }
            double d = this.data;
            this.data = null;
            this.notifyAll();
            return d;
        }

        public synchronized void put(double d) throws Exception {
            while (this.data != null) {
                this.wait();
            }
            this.data = d;
            this.notifyAll();
        }
    }
}

