/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Language;
import i2m.MainFrame;
import i2m.onLine.SerialConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.MaskFormatter;

public class LambdaDialog
extends JDialog
implements ActionListener,
WindowListener,
ListSelectionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private JComboBox sceltaCOM = null;
    private JComboBox sceltaBaud;
    private JComboBox tipoMoto;
    private JComboBox message1ID;
    private JComboBox message2ID;
    private JComboBox rpmID;
    private JComboBox byte0CB;
    private JComboBox byte1CB;
    private JComboBox multiplexByteCB;
    private JComboBox multiplexValueCB;
    private JComboBox divisioneCB;
    private JCheckBox controlloRpmCB;
    private JCheckBox terminazioneCB;
    private JButton connettiB;
    private JButton applyB;
    private JButton acquireB;
    private JButton readB;
    private String[] elenco = null;
    private SerialConnection conn;
    private boolean connected = false;
    private Thread acquisitionThread;
    private JPanel pannelloRpm;
    private JPanel pannelloRealTime;
    private JPanel pannelloSettaggi;
    private JLabel rpmIdLabel;
    private JLabel Byte0Label;
    private JLabel Byte1Label;
    private JLabel mascheraLabel;
    private JLabel divisioneLabel;
    private JLabel valueLabel;
    private JLabel multiLabel;
    private JLabel lambda1Label;
    private JLabel lambda2Label;
    private JLabel lambda3Label;
    private JLabel lambda4Label;
    private JLabel baudLabel;
    private JLabel message1Label;
    private JLabel message2Label;
    private JLabel rpmLabel;
    private JLabel terminazioneLabel;
    private JLabel motoLabel;
    private JTextField lambda1TF;
    private JTextField lambda2TF;
    private JTextField lambda3TF;
    private JTextField lambda4TF;
    private JTextField temperature1TF;
    private JTextField temperature2TF;
    private JTextField temperature3TF;
    private JTextField temperature4TF;
    private int idRpm;
    private int b0;
    private int b1;
    private int divisione;
    private int multi;
    private int valore;
    private String maschera;
    JFormattedTextField mascheraTF;
    private boolean controlloRpm = false;
    private boolean acquisisciContinuo = false;
    private int versione = 1;
    private boolean settaggiDaInviare = false;
    private boolean threadAttivo = false;

    public LambdaDialog(MainFrame owner, String[] lista) {
        super(owner, Language.string(Language.string("4-Lambda configurator")), false);
        this.addWindowListener(this);
        this.elenco = lista;
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.sceltaCOM = new JComboBox();
        this.sceltaCOM.setFocusable(false);
        this.connettiB = new JButton(Language.string("Connetti"));
        this.connettiB.addActionListener(this);
        this.sceltaCOM.setMinimumSize(new Dimension(120, 25));
        this.sceltaCOM.setPreferredSize(new Dimension(120, 25));
        this.sceltaCOM.setMaximumSize(new Dimension(120, 25));
        this.connettiB.setMinimumSize(new Dimension(80, 25));
        this.connettiB.setMaximumSize(new Dimension(80, 25));
        this.connettiB.setFocusable(false);
        if (this.elenco != null) {
            for (int i = 0; i < this.elenco.length; ++i) {
                this.sceltaCOM.addItem(lista[i]);
            }
            if (this.elenco.length > 0) {
                this.sceltaCOM.setSelectedIndex(0);
            }
        }
        JLabel l = new JLabel(Language.string("Porta ricevitore 4-Lamdbda:"));
        JPanel pannelloConnessione = new JPanel();
        pannelloConnessione.add(l);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.sceltaCOM);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.connettiB);
        pannelloConnessione.setBackground(Color.lightGray);
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new GridLayout(3, 1, 0, 0));
        this.pannelloSettaggi = new JPanel();
        this.pannelloSettaggi.setLayout(new GridLayout(6, 2, 2, 5));
        this.pannelloSettaggi.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers: ---")));
        this.versione = 1;
        String[] elencoBaud = new String[]{"125k", "250k", "500k", "1M"};
        this.sceltaBaud = new JComboBox<String>(elencoBaud);
        this.sceltaBaud.setSelectedIndex(3);
        this.sceltaBaud.setMaximumSize(new Dimension(120, 20));
        this.sceltaBaud.addActionListener(this);
        this.baudLabel = new JLabel(Language.string("  Baud rate can-bus : "));
        this.message1ID = new JComboBox();
        this.message1ID.setMaximumSize(new Dimension(120, 20));
        this.message1ID.addActionListener(this);
        this.message1Label = new JLabel(Language.string("  Message ID 1-2 [HEX] : "));
        this.message2ID = new JComboBox();
        this.message2ID.setMaximumSize(new Dimension(120, 20));
        this.message2ID.addActionListener(this);
        this.message2Label = new JLabel(Language.string("  Message ID 3-4 [HEX] : "));
        this.controlloRpmCB = new JCheckBox();
        this.controlloRpmCB.setSelected(false);
        this.controlloRpmCB.addActionListener(this);
        this.rpmLabel = new JLabel(Language.string("  Controllo RPM : "));
        this.terminazioneCB = new JCheckBox();
        this.terminazioneCB.setSelected(false);
        this.terminazioneCB.addActionListener(this);
        this.terminazioneLabel = new JLabel(Language.string("  Terminazione 120 ohm : "));
        this.tipoMoto = new JComboBox();
        this.tipoMoto.setMaximumSize(new Dimension(120, 20));
        this.tipoMoto.setEnabled(false);
        this.tipoMoto.addActionListener(this);
        this.motoLabel = new JLabel(Language.string("  Modello moto : "));
        this.motoLabel.setEnabled(false);
        this.pannelloSettaggi.add(this.baudLabel);
        this.pannelloSettaggi.add(this.sceltaBaud);
        this.pannelloSettaggi.add(this.message1Label);
        this.pannelloSettaggi.add(this.message1ID);
        this.pannelloSettaggi.add(this.message2Label);
        this.pannelloSettaggi.add(this.message2ID);
        this.pannelloSettaggi.add(this.terminazioneLabel);
        this.pannelloSettaggi.add(this.terminazioneCB);
        this.pannelloSettaggi.add(this.rpmLabel);
        this.pannelloSettaggi.add(this.controlloRpmCB);
        this.pannelloSettaggi.add(this.motoLabel);
        this.pannelloSettaggi.add(this.tipoMoto);
        this.pannelloRpm = new JPanel();
        this.pannelloRpm.setLayout(new GridLayout(7, 2, 2, 3));
        this.pannelloRpm.setBorder(BorderFactory.createTitledBorder(Language.string("RPM settings")));
        this.rpmID = new JComboBox();
        this.rpmID.setMaximumSize(new Dimension(120, 20));
        this.rpmID.addActionListener(this);
        this.rpmIdLabel = new JLabel(Language.string("  RPM ID [HEX] : "));
        this.byte0CB = new JComboBox();
        this.byte0CB.setMaximumSize(new Dimension(120, 20));
        this.byte0CB.addActionListener(this);
        this.Byte0Label = new JLabel(Language.string("  Byte LSB : "));
        this.byte1CB = new JComboBox();
        this.byte1CB.setMaximumSize(new Dimension(120, 20));
        this.byte1CB.addActionListener(this);
        this.Byte1Label = new JLabel(Language.string("  Byte MSB : "));
        MaskFormatter MascheraMaschera = null;
        String caratteriBinari = "01";
        try {
            MascheraMaschera = new MaskFormatter("****************");
            MascheraMaschera.setValidCharacters(caratteriBinari);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.mascheraTF = new JFormattedTextField(MascheraMaschera);
        this.mascheraTF.setHorizontalAlignment(11);
        this.mascheraTF.setText("1111111111111111");
        this.mascheraTF.setMaximumSize(new Dimension(120, 20));
        this.mascheraTF.addActionListener(this);
        this.mascheraLabel = new JLabel(Language.string("  Maschera : "));
        this.divisioneCB = new JComboBox();
        this.divisioneCB.setMaximumSize(new Dimension(120, 20));
        this.divisioneCB.addActionListener(this);
        this.divisioneLabel = new JLabel(Language.string("  Divisione : "));
        this.multiplexByteCB = new JComboBox();
        this.multiplexByteCB.setMaximumSize(new Dimension(120, 20));
        this.multiplexByteCB.addActionListener(this);
        this.multiLabel = new JLabel(Language.string("  Multiplexing Byte : "));
        this.multiplexValueCB = new JComboBox();
        this.multiplexValueCB.setMaximumSize(new Dimension(120, 20));
        this.multiplexValueCB.addActionListener(this);
        this.valueLabel = new JLabel(Language.string("  Codifica Multiplexing [HEX] : "));
        this.pannelloRpm.add(this.rpmIdLabel);
        this.pannelloRpm.add(this.rpmID);
        this.pannelloRpm.add(this.Byte0Label);
        this.pannelloRpm.add(this.byte0CB);
        this.pannelloRpm.add(this.Byte1Label);
        this.pannelloRpm.add(this.byte1CB);
        this.pannelloRpm.add(this.mascheraLabel);
        this.pannelloRpm.add(this.mascheraTF);
        this.pannelloRpm.add(this.divisioneLabel);
        this.pannelloRpm.add(this.divisioneCB);
        this.pannelloRpm.add(this.multiLabel);
        this.pannelloRpm.add(this.multiplexByteCB);
        this.pannelloRpm.add(this.valueLabel);
        this.pannelloRpm.add(this.multiplexValueCB);
        this.pannelloRealTime = new JPanel();
        this.pannelloRealTime.setLayout(new GridLayout(5, 3, 2, 7));
        this.pannelloRealTime.setBorder(BorderFactory.createTitledBorder(Language.string("Real time AFR/Temperature Controller")));
        this.lambda1Label = new JLabel(Language.string("  Lambda 1 : "));
        this.lambda2Label = new JLabel(Language.string("  Lambda 2 : "));
        this.lambda3Label = new JLabel(Language.string("  Lambda 3 : "));
        this.lambda4Label = new JLabel(Language.string("  Lambda 4 : "));
        this.lambda1TF = new JTextField(6);
        this.lambda1TF.setText("--- ");
        this.lambda1TF.setFocusable(false);
        this.lambda1TF.setEditable(false);
        this.lambda1TF.setHorizontalAlignment(4);
        this.lambda2TF = new JTextField(6);
        this.lambda2TF.setText("--- ");
        this.lambda2TF.setFocusable(false);
        this.lambda2TF.setEditable(false);
        this.lambda2TF.setHorizontalAlignment(4);
        this.lambda3TF = new JTextField(6);
        this.lambda3TF.setText("--- ");
        this.lambda3TF.setFocusable(false);
        this.lambda3TF.setEditable(false);
        this.lambda3TF.setHorizontalAlignment(4);
        this.lambda4TF = new JTextField(6);
        this.lambda4TF.setText("--- ");
        this.lambda4TF.setFocusable(false);
        this.lambda4TF.setEditable(false);
        this.lambda4TF.setHorizontalAlignment(4);
        this.temperature1TF = new JTextField(6);
        this.temperature1TF.setText("--- ");
        this.temperature1TF.setFocusable(false);
        this.temperature1TF.setEditable(false);
        this.temperature1TF.setHorizontalAlignment(4);
        this.temperature2TF = new JTextField(6);
        this.temperature2TF.setText("--- ");
        this.temperature2TF.setFocusable(false);
        this.temperature2TF.setEditable(false);
        this.temperature2TF.setHorizontalAlignment(4);
        this.temperature3TF = new JTextField(6);
        this.temperature3TF.setText("--- ");
        this.temperature3TF.setFocusable(false);
        this.temperature3TF.setEditable(false);
        this.temperature3TF.setHorizontalAlignment(4);
        this.temperature4TF = new JTextField(6);
        this.temperature4TF.setText("--- ");
        this.temperature4TF.setFocusable(false);
        this.temperature4TF.setEditable(false);
        this.temperature4TF.setHorizontalAlignment(4);
        this.pannelloRealTime.add(this.lambda1Label);
        this.pannelloRealTime.add(this.lambda1TF);
        this.pannelloRealTime.add(this.temperature1TF);
        this.pannelloRealTime.add(this.lambda2Label);
        this.pannelloRealTime.add(this.lambda2TF);
        this.pannelloRealTime.add(this.temperature2TF);
        this.pannelloRealTime.add(this.lambda3Label);
        this.pannelloRealTime.add(this.lambda3TF);
        this.pannelloRealTime.add(this.temperature3TF);
        this.pannelloRealTime.add(this.lambda4Label);
        this.pannelloRealTime.add(this.lambda4TF);
        this.pannelloRealTime.add(this.temperature4TF);
        this.pannelloRealTime.add(new JLabel(""));
        this.pannelloRealTime.add(new JLabel(""));
        this.pannelloRealTime.add(new JLabel(""));
        pannelloCentrale.add(this.pannelloSettaggi);
        pannelloCentrale.add(this.pannelloRpm);
        pannelloCentrale.add(this.pannelloRealTime);
        pannelloPrincipale.add((Component)pannelloConnessione, "North");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)this.costruisciPannelloBottoni(), "South");
        this.inizializzaScelte();
        this.abilitaRpm(false);
        this.abilitaRealTime(false);
        this.abilitaTasti(false);
        this.abilitaSettaggi(false);
        this.setSize(450, 700);
    }

    public JPanel costruisciPannelloBottoni() {
        this.applyB = new JButton(Language.string("Applica settaggi"));
        this.applyB.addActionListener(this);
        this.readB = new JButton(Language.string("Leggi settaggi"));
        this.readB.addActionListener(this);
        this.acquireB = new JButton(Language.string("Start Real time"));
        this.acquireB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.applyB);
        pannelloBottoni.add(this.readB);
        pannelloBottoni.add(this.acquireB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        return pannelloBottoni;
    }

    public void inizializzaScelte() {
        int i;
        for (i = 1; i < 2046; ++i) {
            this.message1ID.addItem(String.format("%03X", i));
            this.message2ID.addItem(String.format("%03X", i));
            this.rpmID.addItem(String.format("%03X", i));
        }
        this.message1ID.setSelectedIndex(0);
        this.message2ID.setSelectedIndex(0);
        this.rpmID.setSelectedIndex(0);
        for (i = 0; i < 8; ++i) {
            this.byte0CB.addItem(String.format("%d", i));
            this.byte1CB.addItem(String.format("%d", i));
            this.multiplexByteCB.addItem(String.format("%d", i));
        }
        this.multiplexByteCB.addItem("OFF");
        this.byte0CB.setSelectedIndex(0);
        this.byte1CB.setSelectedIndex(1);
        this.multiplexByteCB.setSelectedIndex(8);
        for (i = 0; i < 256; ++i) {
            this.multiplexValueCB.addItem(String.format("%02X", i));
        }
        this.multiplexValueCB.setSelectedIndex(0);
        this.divisioneCB.addItem("1");
        this.divisioneCB.addItem("2");
        this.divisioneCB.addItem("4");
        this.divisioneCB.addItem("8");
        this.divisioneCB.addItem("16");
        this.divisioneCB.addItem("32");
        this.divisioneCB.addItem("64");
        this.divisioneCB.addItem("128");
        this.divisioneCB.setSelectedIndex(0);
        this.tipoMoto.addItem("Custom");
        this.tipoMoto.addItem("Kawasaki ZX10R 11-15");
        this.tipoMoto.addItem("Kawasaki ZX10R 16-21");
        this.tipoMoto.addItem("Kawasaki ZX636");
        this.tipoMoto.addItem("MV F3 675/800 <2021");
        this.tipoMoto.addItem("Ducati 1198");
        this.tipoMoto.addItem("Ducati 899/1199/1299");
        this.tipoMoto.addItem("Ducati V2/V4");
        this.tipoMoto.addItem("Aprilia RSV4/RS660 12-22");
        this.tipoMoto.addItem("Honda CBR 1000 17-19/CBR 600 24");
        this.tipoMoto.addItem("Honda CBR 1000 20-24");
        this.tipoMoto.addItem("BMW 09-14");
        this.tipoMoto.addItem("BMW 15-23");
        this.tipoMoto.addItem("Yamaha R6 17-21");
        this.tipoMoto.addItem("Yamaha R7 2022");
        this.tipoMoto.addItem("Yamaha R1 15-21");
        this.tipoMoto.addItem("WSSP 19-21");
        this.tipoMoto.addItem("NG 2023");
        this.tipoMoto.addItem("R9 2024");
        this.tipoMoto.addItem("ZX6R 2024");
        this.tipoMoto.setSelectedIndex(0);
    }

    public void abilitaSettaggi(boolean abilita) {
        this.sceltaBaud.setEnabled(abilita);
        this.tipoMoto.setEnabled(abilita);
        this.message1ID.setEnabled(abilita);
        this.message2ID.setEnabled(abilita);
        this.pannelloSettaggi.setEnabled(abilita);
        this.terminazioneCB.setEnabled(abilita);
        this.controlloRpmCB.setEnabled(abilita);
        this.baudLabel.setEnabled(abilita);
        this.message1Label.setEnabled(abilita);
        this.message2Label.setEnabled(abilita);
        this.rpmLabel.setEnabled(abilita);
        this.terminazioneLabel.setEnabled(abilita);
        if (!abilita) {
            this.motoLabel.setEnabled(abilita);
            this.tipoMoto.setEnabled(abilita);
        } else {
            this.motoLabel.setEnabled(this.controlloRpmCB.isSelected());
            this.tipoMoto.setEnabled(this.controlloRpmCB.isSelected());
        }
        if (abilita && this.controlloRpmCB.isSelected() && this.tipoMoto.getSelectedIndex() == 0) {
            this.abilitaRpm(true);
        }
    }

    public void abilitaRpm(boolean abilita) {
        this.rpmID.setEnabled(abilita);
        this.byte0CB.setEnabled(abilita);
        this.byte1CB.setEnabled(abilita);
        this.mascheraTF.setEnabled(abilita);
        this.multiplexByteCB.setEnabled(abilita);
        this.multiplexValueCB.setEnabled(abilita);
        this.divisioneCB.setEnabled(abilita);
        this.pannelloRpm.setEnabled(abilita);
        this.rpmIdLabel.setEnabled(abilita);
        this.Byte0Label.setEnabled(abilita);
        this.Byte1Label.setEnabled(abilita);
        this.mascheraLabel.setEnabled(abilita);
        this.divisioneLabel.setEnabled(abilita);
        this.valueLabel.setEnabled(abilita);
        this.multiLabel.setEnabled(abilita);
    }

    public void abilitaRealTime(boolean abilita) {
        this.lambda1TF.setEnabled(abilita);
        this.lambda2TF.setEnabled(abilita);
        this.lambda3TF.setEnabled(abilita);
        this.lambda4TF.setEnabled(abilita);
        this.temperature1TF.setEnabled(abilita);
        this.temperature2TF.setEnabled(abilita);
        this.temperature3TF.setEnabled(abilita);
        this.temperature4TF.setEnabled(abilita);
        this.lambda1Label.setEnabled(abilita);
        this.lambda2Label.setEnabled(abilita);
        this.lambda3Label.setEnabled(abilita);
        this.lambda4Label.setEnabled(abilita);
        this.pannelloRealTime.setEnabled(abilita);
    }

    public void abilitaTasti(boolean abilita) {
        this.applyB.setEnabled(abilita);
        this.readB.setEnabled(abilita);
        this.acquireB.setEnabled(abilita);
    }

    public void leggiSettaggi(String s) {
        if (s == null) {
            return;
        }
        if (!s.startsWith("$SETT")) {
            return;
        }
        boolean datiErrati = false;
        StringTokenizer st = new StringTokenizer(s, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            int baud = Integer.parseInt(t);
            t = st.nextToken();
            int id1 = Integer.parseInt(t);
            t = st.nextToken();
            int id2 = Integer.parseInt(t);
            t = st.nextToken();
            int term = Integer.parseInt(t);
            t = st.nextToken();
            int rpm = Integer.parseInt(t);
            t = st.nextToken();
            int moto = Integer.parseInt(t);
            t = st.nextToken();
            int idRpm = Integer.parseInt(t);
            t = st.nextToken();
            int b0 = Integer.parseInt(t);
            t = st.nextToken();
            int b1 = Integer.parseInt(t);
            String mask = st.nextToken();
            String maskBin = String.format("%16s", Integer.toBinaryString(Integer.parseInt(mask))).replace(" ", "0");
            t = st.nextToken();
            int div = Integer.parseInt(t);
            t = st.nextToken();
            int multi = Integer.parseInt(t);
            t = st.nextToken();
            int multiValue = Integer.parseInt(t);
            if (baud > 4) {
                baud = 3;
                datiErrati = true;
            }
            if (id1 > 2045) {
                id1 = 2045;
                datiErrati = true;
            }
            if (id1 == 0) {
                id1 = 1;
                datiErrati = true;
            }
            if (id2 > 2045) {
                id2 = 2045;
                datiErrati = true;
            }
            if (id2 == 0) {
                id2 = 1;
                datiErrati = true;
            }
            if (term > 1) {
                term = 1;
                datiErrati = true;
            }
            if (rpm > 1) {
                rpm = 1;
                datiErrati = true;
            }
            if (moto > 19) {
                moto = 1;
                datiErrati = true;
            }
            if (idRpm > 2045) {
                idRpm = 2045;
                datiErrati = true;
            }
            if (idRpm == 0) {
                idRpm = 1;
                datiErrati = true;
            }
            if (b0 > 7) {
                b0 = 1;
                datiErrati = true;
            }
            if (b1 > 7) {
                b1 = 1;
                datiErrati = true;
            }
            if (div > 7) {
                div = 0;
                datiErrati = true;
            }
            if (multi > 8) {
                multi = 8;
                datiErrati = true;
            }
            if (multiValue > 255) {
                multiValue = 0;
                datiErrati = true;
            }
            this.sceltaBaud.setSelectedIndex(baud);
            this.message1ID.setSelectedIndex(id1 - 1);
            this.message2ID.setSelectedIndex(id2 - 1);
            if (term == 1) {
                this.terminazioneCB.setSelected(true);
            } else {
                this.terminazioneCB.setSelected(false);
            }
            if (rpm == 1) {
                this.controlloRpmCB.setSelected(true);
            } else {
                this.controlloRpmCB.setSelected(false);
            }
            this.tipoMoto.setSelectedIndex(moto);
            if (moto == 0) {
                this.rpmID.setSelectedIndex(idRpm - 1);
                this.byte0CB.setSelectedIndex(b0);
                this.byte1CB.setSelectedIndex(b1);
                this.mascheraTF.setText(maskBin);
                this.divisioneCB.setSelectedIndex(div);
                this.multiplexByteCB.setSelectedIndex(multi);
                this.multiplexValueCB.setSelectedIndex(multiValue);
            }
            this.controlloRpm = this.controlloRpmCB.isSelected();
            this.tipoMoto.setEnabled(this.controlloRpm);
            this.motoLabel.setEnabled(this.controlloRpm);
            if (this.tipoMoto.getSelectedIndex() == 0) {
                this.abilitaRpm(true);
            } else {
                this.abilitaRpm(false);
            }
            if (!this.controlloRpm) {
                this.abilitaRpm(false);
            }
            if (datiErrati) {
                JOptionPane.showMessageDialog(this, Language.string("I dati ricevuti risultano corrotti"), Language.string("Attenzione"), 2);
            }
        }
        catch (Exception ex) {
            System.err.println("Errore nel parsing della frase dei settaggi lambda:" + s);
            return;
        }
    }

    public void leggiImpostazioniMoto() {
        switch (this.tipoMoto.getSelectedIndex()) {
            case 1: {
                this.idRpm = 256;
                this.b0 = 1;
                this.b1 = 0;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 2: {
                this.idRpm = 256;
                this.b0 = 1;
                this.b1 = 0;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 3: {
                this.idRpm = 256;
                this.b0 = 1;
                this.b1 = 0;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 4: {
                this.idRpm = 256;
                this.b0 = 4;
                this.b1 = 3;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 5: {
                this.idRpm = 128;
                this.b0 = 3;
                this.b1 = 2;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 6: {
                this.idRpm = 128;
                this.b0 = 6;
                this.b1 = 5;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 7: {
                this.idRpm = 36;
                this.b0 = 3;
                this.b1 = 2;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 8: {
                this.idRpm = 256;
                this.b0 = 4;
                this.b1 = 3;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 9: {
                this.idRpm = 476;
                this.b0 = 2;
                this.b1 = 1;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 10: {
                this.idRpm = 476;
                this.b0 = 2;
                this.b1 = 1;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 11: {
                this.idRpm = 268;
                this.b0 = 2;
                this.b1 = 3;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 12: {
                this.idRpm = 268;
                this.b0 = 2;
                this.b1 = 3;
                this.maschera = "0000111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 13: {
                this.idRpm = 521;
                this.b0 = 1;
                this.b1 = 0;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 14: {
                this.idRpm = 522;
                this.b0 = 3;
                this.b1 = 2;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 15: {
                this.idRpm = 521;
                this.b0 = 1;
                this.b1 = 0;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 16: {
                this.idRpm = 513;
                this.b0 = 4;
                this.b1 = 5;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 17: {
                this.idRpm = 516;
                this.b0 = 0;
                this.b1 = 1;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 18: {
                this.idRpm = 636;
                this.b0 = 1;
                this.b1 = 0;
                this.maschera = "1111111111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
            case 19: {
                this.idRpm = 288;
                this.b0 = 1;
                this.b1 = 0;
                this.maschera = "0000011111111111";
                this.divisione = 0;
                this.multi = 8;
                this.valore = 0;
                break;
            }
        }
    }

    public void aggiornaCampi(String s) {
        if (s == null) {
            return;
        }
        if (!s.startsWith("$LAMBDA")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            int l1 = Integer.parseInt(t);
            t = st.nextToken();
            int l2 = Integer.parseInt(t);
            t = st.nextToken();
            int l3 = Integer.parseInt(t);
            t = st.nextToken();
            int l4 = Integer.parseInt(t);
            t = st.nextToken();
            int t1 = Integer.parseInt(t);
            t = st.nextToken();
            int t2 = Integer.parseInt(t);
            t = st.nextToken();
            int t3 = Integer.parseInt(t);
            t = st.nextToken();
            int t4 = Integer.parseInt(t);
            double lambda1 = (double)l1 * 0.013685 + 8.0;
            double lambda2 = (double)l2 * 0.013685 + 8.0;
            double lambda3 = (double)l3 * 0.013685 + 8.0;
            double lambda4 = (double)l4 * 0.013685 + 8.0;
            this.lambda1TF.setText(String.format("%.1f AFR", lambda1));
            this.lambda2TF.setText(String.format("%.1f AFR", lambda2));
            this.lambda3TF.setText(String.format("%.1f AFR", lambda3));
            this.lambda4TF.setText(String.format("%.1f AFR", lambda4));
            this.temperature1TF.setText(String.format("%d", t1));
            this.temperature2TF.setText(String.format("%d", t2));
            this.temperature3TF.setText(String.format("%d", t3));
            this.temperature4TF.setText(String.format("%d", t4));
        }
        catch (Exception ex) {
            System.err.println("Errore nel parsing della frase dei valori lambda:" + s);
            return;
        }
    }

    public synchronized void setThreadAttivo(boolean attivo) {
        this.threadAttivo = attivo;
    }

    public synchronized boolean getThreadAttivo() {
        return this.threadAttivo;
    }

    public String getFraseSettaggi() {
        String s = "";
        int terminazione = 0;
        int rpm = 0;
        int baud = this.sceltaBaud.getSelectedIndex();
        int id1 = this.message1ID.getSelectedIndex() + 1;
        int id2 = this.message2ID.getSelectedIndex() + 1;
        int moto = this.tipoMoto.getSelectedIndex();
        this.idRpm = this.rpmID.getSelectedIndex() + 1;
        this.b0 = this.byte0CB.getSelectedIndex();
        this.b1 = this.byte1CB.getSelectedIndex();
        this.maschera = this.mascheraTF.getText();
        this.divisione = this.divisioneCB.getSelectedIndex();
        this.multi = this.multiplexByteCB.getSelectedIndex();
        this.valore = this.multiplexValueCB.getSelectedIndex();
        if (this.terminazioneCB.isSelected()) {
            terminazione = 1;
        }
        if (this.controlloRpmCB.isSelected()) {
            rpm = 1;
        }
        int mascheraInt = Integer.parseInt(this.maschera, 2);
        this.leggiImpostazioniMoto();
        s = String.format("$SETT,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,\n\r", baud, id1, id2, terminazione, rpm, moto, this.idRpm, this.b0, this.b1, mascheraInt, this.divisione, this.multi, this.valore);
        return s;
    }

    public void leggiContinuo() {
        String s = "$LAMBDA,10,20,30,40,100,110,120,130,";
        String end = null;
        while (this.getThreadAttivo()) {
            try {
                this.conn.write("$LAMBDA\r");
                System.out.println("DEBUG:scrivo : $LAMBDA");
                end = this.conn.readLine();
                System.out.println("DEBUG:Ricevuto :" + end);
                if (end == null || !end.startsWith("$LAMBDA")) {
                    this.disconnetti();
                    JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("ATTENZIONE"), 2);
                    return;
                }
                this.aggiornaCampi(end);
                Thread.sleep(300L);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void acquisisciContinuo(boolean abilita) {
        if (abilita) {
            this.acquireB.setText(Language.string("Stop Real time"));
            this.abilitaRealTime(true);
            this.settaggiDaInviare = this.applyB.isEnabled();
            this.applyB.setEnabled(false);
            this.readB.setEnabled(false);
            this.abilitaRpm(false);
            this.abilitaSettaggi(false);
            this.setThreadAttivo(true);
            this.acquisitionThread = new Thread(){

                @Override
                public void run() {
                    LambdaDialog.this.leggiContinuo();
                }
            };
            this.acquisitionThread.setDaemon(true);
            this.acquisitionThread.start();
        } else {
            this.acquireB.setText(Language.string("Start Real time"));
            this.abilitaRealTime(false);
            this.applyB.setEnabled(this.settaggiDaInviare);
            this.readB.setEnabled(true);
            if (this.controlloRpm && this.tipoMoto.getSelectedIndex() == 0) {
                this.abilitaRpm(true);
            }
            this.abilitaSettaggi(true);
            this.setThreadAttivo(false);
            if (this.acquisitionThread != null) {
                try {
                    this.acquisitionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void connetti() {
        if (this.connected) {
            return;
        }
        if (this.sceltaCOM.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, Language.string("Selezionare una porta"), Language.string("Attenzione"), 2);
        }
        this.sceltaCOM.setEnabled(false);
        try {
            this.conn = new SerialConnection(this.elenco[this.sceltaCOM.getSelectedIndex()]);
            this.conn.open(5);
            this.conn.clear(3000);
            this.conn.write("\r");
            String end = this.conn.readLine();
            System.out.println("DEBUG:Ricevuto:" + end);
            this.conn.clear(1000);
            this.conn.write("\r");
            end = this.conn.readLine();
            System.out.println("DEBUG:Ricevuto:" + end);
            this.conn.setTimeOut(1000);
            this.conn.write("\r");
            end = this.conn.readLine();
            System.out.println("DEBUG:Ricevuto:" + end);
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return;
            }
            this.connettiB.setText(Language.string("Disconnetti"));
            this.abilitaTasti(true);
            this.applyB.setEnabled(false);
            this.connected = true;
            this.conn.write("$V\r");
            end = this.conn.readLine();
            this.versione = this.estraiVersione(end);
            this.pannelloSettaggi.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers: ") + this.versione));
            this.abilitaSettaggi(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sceltaCOM.setEnabled(true);
            JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        }
    }

    public int estraiVersione(String line) {
        if (line == null) {
            return 1;
        }
        if (!line.startsWith("$VER")) {
            return 1;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            int res = Integer.parseInt(t);
            return res;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public void applicaSettaggi() {
        String end = null;
        try {
            this.conn.write(this.getFraseSettaggi());
            System.out.println("DEBUG:scrivo : " + this.getFraseSettaggi());
            end = this.conn.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("DEBUG:Ricevuto:" + end);
        if (end == null || !end.startsWith("$SETT")) {
            this.disconnetti();
            JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        } else {
            this.leggiSettaggi(end);
            JOptionPane.showMessageDialog(this, Language.string("Settaggi inviati"), Language.string("Info"), 1);
        }
    }

    public void riceviSettaggi() {
        String end = null;
        try {
            this.conn.write("$CFG\r");
            System.out.println("DEBUG:scrivo : $CFG");
            end = this.conn.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("DEBUG:Ricevuto:" + end);
        if (end == null || !end.startsWith("$SETT")) {
            this.disconnetti();
            JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        } else {
            this.leggiSettaggi(end);
            JOptionPane.showMessageDialog(this, Language.string("Settaggi ricevuti"), Language.string("Info"), 1);
        }
    }

    public void disconnetti() {
        if (this.acquisisciContinuo) {
            this.acquisisciContinuo = false;
            this.acquisisciContinuo(this.acquisisciContinuo);
        }
        this.sceltaCOM.setEnabled(true);
        try {
            this.connected = false;
            this.versione = 1;
            this.conn.setTimeOut(10);
            this.conn.clear(1000);
            while (this.conn.readLine() != null) {
            }
            this.conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connettiB.setText(Language.string("Connetti"));
        this.abilitaTasti(false);
        this.abilitaSettaggi(false);
        this.abilitaRpm(false);
    }

    public void chiudiDialog() {
        if (this.connected) {
            this.disconnetti();
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.connettiB)) {
            if (this.connected) {
                this.disconnetti();
            } else {
                this.connetti();
            }
        }
        if (e.getSource().equals(this.message1ID)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.message2ID)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.terminazioneCB)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.controlloRpmCB)) {
            this.applyB.setEnabled(true);
            this.controlloRpm = this.controlloRpmCB.isSelected();
            this.tipoMoto.setEnabled(this.controlloRpm);
            this.motoLabel.setEnabled(this.controlloRpm);
            if (this.tipoMoto.getSelectedIndex() == 0) {
                this.abilitaRpm(true);
            } else {
                this.abilitaRpm(false);
            }
            if (!this.controlloRpm) {
                this.abilitaRpm(false);
            }
        }
        if (e.getSource().equals(this.tipoMoto)) {
            this.applyB.setEnabled(true);
            if (this.tipoMoto.getSelectedIndex() == 0) {
                this.abilitaRpm(true);
            } else {
                this.abilitaRpm(false);
            }
        }
        if (e.getSource().equals(this.sceltaBaud)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.byte0CB)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.byte1CB)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.divisioneCB)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.rpmID)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.multiplexByteCB)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.multiplexValueCB)) {
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.applyB)) {
            if (this.mascheraTF.getText().length() < 16) {
                JOptionPane.showMessageDialog(this, Language.string("La maschera non contiene 16 valori"), Language.string("Attenzione"), 2);
                this.mascheraTF.setText("1111111111111111");
                return;
            }
            this.applicaSettaggi();
            this.applyB.setEnabled(false);
        }
        if (e.getSource().equals(this.readB)) {
            this.riceviSettaggi();
            this.applyB.setEnabled(false);
        }
        if (e.getSource().equals(this.mascheraTF)) {
            System.out.println("lunghezza maschera=" + this.mascheraTF.getText().length());
            if (this.mascheraTF.getText().length() < 16) {
                JOptionPane.showMessageDialog(this, Language.string("La maschera non contiene 16 valori"), Language.string("Attenzione"), 2);
                this.mascheraTF.setText("1111111111111111");
                return;
            }
            this.applyB.setEnabled(true);
        }
        if (e.getSource().equals(this.acquireB)) {
            if (!this.connected) {
                return;
            }
            this.acquisisciContinuo = !this.acquisisciContinuo;
            this.acquisisciContinuo(this.acquisisciContinuo);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connected) {
            this.disconnetti();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LambdaDialog t = new LambdaDialog(null, null);
        t.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.applyB.setEnabled(true);
    }
}

