/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.MainFrame;
import i2m.grafico.CurvaIstogramma;
import i2m.grafico.Istogramma;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import no.geosoft.cc.graphics.GScene;

public class IstogrammaDialog
extends JDialog
implements ActionListener,
ChangeListener,
WindowListener,
ListSelectionListener,
ComponentListener {
    private Istogramma isto;
    private JPanel pannelloPrincipale;
    private JCheckBox autoX;
    private JCheckBox autoY;
    private JCheckBox taglia;
    JScrollPane scrollPaneOpzioni;
    JTextField coloreGrafico;
    JTextField coloreIsto;
    JComboBox canaleXCB;
    JComboBox canaleCondizione;
    JPanel pannelloTabella;
    JFormattedTextField minimoX;
    JFormattedTextField massimoX;
    JFormattedTextField massimoY;
    JFormattedTextField step;
    JFormattedTextField limiteBasso;
    JFormattedTextField limiteAlto;
    boolean aggiornaGrafico = false;
    boolean aggiornaCurve = false;
    boolean visibile = true;
    private JComboBox comboMode;
    int modoAttuale = 0;
    private int larghezzaDialog = 650;
    private int altezzaDialog = 650;
    private int posX = 0;
    private int posY = 0;
    private int stepOld = 30;
    private double localStart = 0.0;
    private double localStop = 0.0;
    private boolean soloSelezione = false;
    private static final long serialVersionUID = 1L;
    MainFrame padre;
    JTabbedPane contenitore;
    JButton coloreSfondoXY;
    JButton salvaB;
    JButton coloreIstogramma;
    JLabel descrizione;

    public IstogrammaDialog(MainFrame owner) {
        super((Frame)owner, Language.string("Istogramma"));
        this.padre = owner;
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.costruisciInterfaccia();
        this.isto = new Istogramma(this);
        this.descrizione = new JLabel(Language.string("  Canale selezionato:"));
        this.pannelloTabella = new JPanel(new BorderLayout());
        this.pannelloTabella.add(this.isto.getGrafico(), "Center");
        this.pannelloTabella.add((Component)this.descrizione, "South");
        this.contenitore = new JTabbedPane();
        this.contenitore.addTab(Language.string("Grafico"), this.pannelloTabella);
        this.contenitore.addTab(Language.string("Opzioni"), this.scrollPaneOpzioni);
        this.contenitore.addChangeListener(this);
        this.contenitore.addComponentListener(this);
        double[] valori = new double[]{10.0, 30.0, 40.0, 50.0, 60.0, 70.0, 60.0, 50.0, 40.0, 30.0, 10.0};
        CurvaIstogramma curva = new CurvaIstogramma(0.0, 1000.0, valori, Color.red);
        this.isto.aggiungiCurva(curva);
        this.isto.setAsseX(-50.0, 1050.0, true);
        this.isto.setAsseY(0.0, 80.0, true);
        try {
            this.stepOld = Integer.valueOf(this.step.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add(this.contenitore);
        this.addWindowListener(this);
        this.setSize(450, 450);
        this.setFocusableWindowState(false);
        DanasDataStructure.getInstance().addChangeListener(this);
        this.aggiornaNomi();
        this.aggiornaComboModo();
        this.aggiornaCurve();
    }

    public int getModoVisibile() {
        return this.comboMode.getSelectedIndex();
    }

    public void setModoVisibile(int modo) {
        if (modo < 0) {
            return;
        }
        this.modoAttuale = modo;
        this.comboMode.setSelectedIndex(modo);
    }

    public void aggiornaComboModo() {
        this.comboMode.removeAllItems();
        for (int i = 0; i < 20; ++i) {
            this.comboMode.addItem(DanasPreferences.getOpzioniNomeIstogramma(i));
        }
        this.comboMode.setSelectedIndex(this.modoAttuale);
    }

    public String getNomeX() {
        return (String)this.canaleXCB.getSelectedItem();
    }

    public void setSincronizzazione(boolean attiva) {
        this.visibile = attiva;
    }

    public boolean getAutoX() {
        return this.autoX.isSelected();
    }

    public boolean getAutoY() {
        return this.autoY.isSelected();
    }

    public double getMinX() {
        return Double.valueOf(this.minimoX.getValue().toString());
    }

    public double getMaxX() {
        return Double.valueOf(this.massimoX.getValue().toString());
    }

    public double getMaxY() {
        return Double.valueOf(this.massimoY.getValue().toString());
    }

    public void setSelezione(double start, double stop, boolean segment) {
        this.localStart = start;
        this.localStop = stop;
        this.soloSelezione = segment;
    }

    public void costruisciInterfaccia() {
        this.pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloCentrale = new JPanel();
        GridLayout griglia = new GridLayout(0, 4, 10, 10);
        pannelloCentrale.setLayout(griglia);
        String[] CanaliList = new String[]{"Gps speed", "Rpm", "Speed1", "Speed2", "Analog1", "Analog2", "Analog3", "Analog4", "Analog5", "Analog6", "Analog7", "Analog8", "Ext-1", "Ext-2", "d(Gps speed)", "d(Rpm)", "d(Speed1)", "d(Speed2)", "d(Analog1)", "d(Analog2)", "d(Analog3)", "d(Analog4)", "d(Analog5)", "d(Analog6)", "d(Analog7)", "d(Analog8)", "d(Ext-1)", "d(Ext-2)", "Gears", "Gears ratio", "Math1", "Math2", "Multi1", "Multi2", "Multi3", "Multi4", "Multi5", "Multi6", "Multi7", "Multi8", "Multi9", "Multi10", "Gps angle", "Acc. lat.", "Altitud.", "Delay", "Slip"};
        String[] CanaliList2 = new String[]{Language.string("Nessuno"), "Gps speed", "Rpm", "Speed1", "Speed2", "Analog1", "Analog2", "Analog3", "Analog4", "Analog5", "Analog6", "Analog7", "Analog8", "Ext-1", "Ext-2", "d(Gps speed)", "d(Rpm)", "d(Speed1)", "d(Speed2)", "d(Analog1)", "d(Analog2)", "d(Analog3)", "d(Analog4)", "d(Analog5)", "d(Analog6)", "d(Analog7)", "d(Analog8)", "d(Ext-1)", "d(Ext-2)", "Gears", "Gears ratio", "Math1", "Math2", "Multi1", "Multi2", "Multi3", "Multi4", "Multi5", "Multi6", "Multi7", "Multi8", "Multi9", "Multi10", "Gps angle", "Acc. lat.", "Altitud.", "Delay", "Slip"};
        this.canaleXCB = new JComboBox<String>(CanaliList);
        this.canaleXCB.addActionListener(this);
        this.canaleCondizione = new JComboBox<String>(CanaliList2);
        this.canaleCondizione.addActionListener(this);
        NumberFormat assiFormat = NumberFormat.getNumberInstance(Locale.US);
        assiFormat.setMaximumIntegerDigits(10);
        assiFormat.setMaximumFractionDigits(2);
        assiFormat.setGroupingUsed(false);
        this.minimoX = new JFormattedTextField(assiFormat);
        this.minimoX.setHorizontalAlignment(11);
        this.minimoX.setValue(0.0);
        this.minimoX.addActionListener(this);
        this.massimoX = new JFormattedTextField(assiFormat);
        this.massimoX.setHorizontalAlignment(11);
        this.massimoX.setValue(100.0);
        this.massimoX.addActionListener(this);
        this.massimoY = new JFormattedTextField(assiFormat);
        this.massimoY.setHorizontalAlignment(11);
        this.massimoY.setValue(100.0);
        this.massimoY.addActionListener(this);
        this.limiteBasso = new JFormattedTextField(assiFormat);
        this.limiteBasso.setHorizontalAlignment(11);
        this.limiteBasso.setValue(100.0);
        this.limiteBasso.addActionListener(this);
        this.limiteAlto = new JFormattedTextField(assiFormat);
        this.limiteAlto.setHorizontalAlignment(11);
        this.limiteAlto.setValue(100.0);
        this.limiteAlto.addActionListener(this);
        NumberFormat stepFormat = NumberFormat.getNumberInstance(Locale.US);
        stepFormat.setMaximumIntegerDigits(10);
        stepFormat.setMaximumFractionDigits(0);
        stepFormat.setGroupingUsed(false);
        this.step = new JFormattedTextField(stepFormat);
        this.step.setHorizontalAlignment(11);
        this.step.setValue(50.0);
        this.step.addActionListener(this);
        this.autoX = new JCheckBox(Language.string("Autoscaling X"));
        this.autoY = new JCheckBox(Language.string("Autoscaling Y"));
        this.taglia = new JCheckBox(Language.string("Escludi estremi"));
        this.taglia.setToolTipText(Language.string("Rimuovi primo e ultimo giro della sessione"));
        this.autoX.addActionListener(this);
        this.autoY.addActionListener(this);
        this.taglia.addActionListener(this);
        this.autoX.setSelected(false);
        this.autoY.setSelected(false);
        this.taglia.setSelected(true);
        this.comboMode = new JComboBox();
        this.comboMode.setEditable(true);
        this.comboMode.addActionListener(this);
        this.salvaB = new JButton(Language.string("Salva"));
        this.salvaB.addActionListener(this);
        JLabel canaleXLabel = new JLabel(Language.string("Canale istogramma:"));
        JLabel massimoYLabel = new JLabel(Language.string("Massimo asse Y:"));
        JLabel minimoXLabel = new JLabel(Language.string("Minimo Asse X:"));
        JLabel massimoXLabel = new JLabel(Language.string("Massimo Asse X:"));
        JLabel stepLabel = new JLabel(Language.string("Numero step:"));
        JLabel attenzione = new JLabel(Language.string("      Attenzione: battere invio per confermare OGNI valore immesso."));
        JLabel modoLabel = new JLabel(Language.string("Configurazioni:"));
        JLabel condizioneLabel = new JLabel(Language.string("Condizione:"));
        JLabel canaleCondizioneLabel = new JLabel(Language.string("Canale condizione:"));
        JLabel limiteBassoLabel = new JLabel(Language.string("Limite inferiore:"));
        JLabel limiteAltoLabel = new JLabel(Language.string("Limite superiore:"));
        this.coloreGrafico = new JTextField(10);
        this.coloreGrafico.setBackground(Color.BLACK);
        this.coloreGrafico.setEditable(false);
        JLabel coloreLabel = new JLabel("      ");
        coloreLabel.setLabelFor(this.coloreGrafico);
        this.coloreSfondoXY = new JButton(Language.string("Colore sfondo"));
        this.coloreSfondoXY.addActionListener(this);
        this.coloreIstogramma = new JButton(Language.string("Colore"));
        this.coloreIstogramma.addActionListener(this);
        this.coloreIsto = new JTextField(10);
        this.coloreIsto.setBackground(Color.RED);
        this.coloreIsto.setEditable(false);
        pannelloCentrale.add(canaleXLabel);
        pannelloCentrale.add(this.canaleXCB);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(this.autoX);
        pannelloCentrale.add(minimoXLabel);
        pannelloCentrale.add(this.minimoX);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(this.autoY);
        pannelloCentrale.add(massimoXLabel);
        pannelloCentrale.add(this.massimoX);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(this.taglia);
        pannelloCentrale.add(massimoYLabel);
        pannelloCentrale.add(this.massimoY);
        pannelloCentrale.add(this.coloreIstogramma);
        pannelloCentrale.add(this.coloreIsto);
        pannelloCentrale.add(stepLabel);
        pannelloCentrale.add(this.step);
        pannelloCentrale.add(this.coloreSfondoXY);
        pannelloCentrale.add(this.coloreGrafico);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(condizioneLabel);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(canaleCondizioneLabel);
        pannelloCentrale.add(this.canaleCondizione);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(limiteBassoLabel);
        pannelloCentrale.add(this.limiteBasso);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(limiteAltoLabel);
        pannelloCentrale.add(this.limiteAlto);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(modoLabel);
        pannelloCentrale.add(this.comboMode);
        pannelloCentrale.add(this.salvaB);
        pannelloCentrale.add(new JPanel());
        JPanel pannellosotto = new JPanel();
        GridLayout grigliaSotto = new GridLayout(2, 0, 10, 10);
        pannellosotto.setLayout(grigliaSotto);
        pannellosotto.add(attenzione);
        pannellosotto.add(Box.createRigidArea(new Dimension(10, 50)));
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(30, 0)), "East");
        this.pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(30, 0)), "West");
        this.pannelloPrincipale.add((Component)pannellosotto, "South");
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(30, 20)), "North");
        this.pannelloPrincipale.setPreferredSize(new Dimension(450, 350));
        this.scrollPaneOpzioni = new JScrollPane(this.pannelloPrincipale);
        this.pannelloPrincipale.setPreferredSize(new Dimension(580, 580));
    }

    public void salvaPreferenze() {
        DanasPreferences.setOpzioniNomeIstogramma(this.modoAttuale, (String)this.comboMode.getSelectedItem());
        DanasPreferences.setOpzioniCheckIstogramma(1, this.modoAttuale, this.autoX.isSelected());
        DanasPreferences.setOpzioniCheckIstogramma(2, this.modoAttuale, this.autoY.isSelected());
        DanasPreferences.setOpzioniCheckIstogramma(3, this.modoAttuale, this.taglia.isSelected());
        DanasPreferences.setPrefColoreSfonfdoIstogramma(this.modoAttuale, this.coloreGrafico.getBackground().getRGB());
        DanasPreferences.setPrefColoreIstogramma(this.modoAttuale, this.coloreIsto.getBackground().getRGB());
        DanasPreferences.setOpzioniCanaleIstogramma(1, this.modoAttuale, this.canaleXCB.getSelectedIndex());
        DanasPreferences.setOpzioniCanaleIstogramma(2, this.modoAttuale, this.canaleCondizione.getSelectedIndex());
        DanasPreferences.setOpzioniMinimiIstogramma(1, this.modoAttuale, this.minimoX.getText());
        DanasPreferences.setOpzioniMinimiIstogramma(2, this.modoAttuale, this.limiteBasso.getText());
        DanasPreferences.setOpzioniMassimiIstogramma(1, this.modoAttuale, this.massimoX.getText());
        DanasPreferences.setOpzioniMassimiIstogramma(2, this.modoAttuale, this.limiteAlto.getText());
        DanasPreferences.setOpzioniMassimiIstogramma(3, this.modoAttuale, this.massimoY.getText());
        DanasPreferences.setOpzioniStepIstogramma(this.modoAttuale, this.step.getText());
        this.comboMode.removeActionListener(this);
        this.aggiornaComboModo();
        this.comboMode.addActionListener(this);
    }

    public void caricaPreferenze(int modo) {
        this.autoX.setSelected(DanasPreferences.getOpzioniCheckIstogramma(1, modo));
        this.autoY.setSelected(DanasPreferences.getOpzioniCheckIstogramma(2, modo));
        this.taglia.setSelected(DanasPreferences.getOpzioniCheckIstogramma(3, modo));
        this.coloreGrafico.setBackground(new Color(DanasPreferences.getPrefColoreSfonfdoIstogramma(modo)));
        this.coloreIsto.setBackground(new Color(DanasPreferences.getPrefColoreIstogramma(modo)));
        this.canaleXCB.setSelectedIndex(DanasPreferences.getOpzioniCanaleIstogramma(1, modo));
        this.canaleCondizione.setSelectedIndex(DanasPreferences.getOpzioniCanaleIstogramma(2, modo));
        this.minimoX.setValue(Double.valueOf(DanasPreferences.getOpzioniMinimiIstogramma(1, modo)));
        this.limiteBasso.setValue(Double.valueOf(DanasPreferences.getOpzioniMinimiIstogramma(2, modo)));
        this.massimoX.setValue(Double.valueOf(DanasPreferences.getOpzioniMassimiIstogramma(1, modo)));
        this.massimoY.setValue(Double.valueOf(DanasPreferences.getOpzioniMassimiIstogramma(3, modo)));
        this.limiteAlto.setValue(Double.valueOf(DanasPreferences.getOpzioniMassimiIstogramma(2, modo)));
        this.step.setValue(Double.valueOf(DanasPreferences.getOpzioniStepIstogramma(modo)));
        this.minimoX.setEnabled(!this.autoX.isSelected());
        this.massimoX.setEnabled(!this.autoX.isSelected());
        this.massimoY.setEnabled(!this.autoY.isSelected());
        this.aggiornaGrafico = true;
    }

    public void aggiornaCurve() {
        try {
            int res;
            Object curva = null;
            this.isto.rimuoviTutto();
            int canaleX = this.canaleXCB.getSelectedIndex();
            if (canaleX < 0) {
                this.isto.ridisegnaSfondo();
                this.isto.refresh();
                return;
            }
            int canaleC = this.canaleCondizione.getSelectedIndex() - 1;
            if (canaleC < 0) {
                canaleC = 0;
            }
            DanasDataStructureConstants.ValueType vtX = MeasuresUtil.getValueType(canaleX);
            DanasDataStructureConstants.ValueType vtC = MeasuresUtil.getValueType(canaleC);
            double minimo = Double.valueOf(this.minimoX.getValue().toString());
            double massimo = Double.valueOf(this.massimoX.getValue().toString());
            double limiteL = Double.valueOf(this.limiteBasso.getValue().toString());
            double limiteH = Double.valueOf(this.limiteAlto.getValue().toString());
            boolean condizione = false;
            if (this.canaleCondizione.getSelectedIndex() > 0) {
                condizione = true;
            }
            int stepI = this.stepOld;
            boolean sessioni = DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni();
            if (sessioni && DanasDataStructure.getInstance().getNumberSelectedSessions() > 1 && !DanasPreferences.getStopDialog2Giri() && (res = JOptionPane.showConfirmDialog(null, Language.string("C'e' pi\u00f9 di una sessione selezionata: verr\u00e0 analizzata solo la prima.Continuare a vedere questo messaggio?"), Language.string("Attenzione"), 0)) == 1) {
                DanasPreferences.setStopDialog2Giri(true);
            }
            String stringaCondizione = condizione ? this.canaleCondizione.getSelectedItem() + "  " + this.limiteBasso.getValue().toString() + "/" + this.limiteAlto.getValue().toString() : Language.string("nessuna");
            this.descrizione.setText(Language.string("  Canale selezionato: ") + this.canaleXCB.getSelectedItem() + Language.string("     Condizione: ") + stringaCondizione);
            Vector<CurvaIstogramma> elencoCurve = sessioni ? DanasDataStructure.getInstance().getCurveSelectedSessionIstogramma(vtX, vtC, this.autoX.isSelected(), minimo, massimo, condizione, limiteL, limiteH, stepI, this.taglia.isSelected(), this.localStart, this.localStop, this.soloSelezione) : DanasDataStructure.getInstance().getCurveSelectedLapIstogramma(vtX, vtC, this.autoX.isSelected(), minimo, massimo, condizione, limiteL, limiteH, stepI, this.localStart, this.localStop, this.soloSelezione);
            for (int i = 0; i < elencoCurve.size(); ++i) {
                elencoCurve.get(i).setGraficoALinee(DanasPreferences.getPrefIstogrammiLinee());
                this.isto.aggiungiCurva(elencoCurve.get(i));
            }
            if (elencoCurve.size() == 1) {
                this.isto.setColore(this.coloreIsto.getBackground());
            }
            if (elencoCurve.size() == 0) {
                this.isto.ridisegnaSfondo();
                this.isto.refresh();
                return;
            }
            if (this.autoY.isSelected()) {
                this.fittaVerticale();
            } else {
                this.isto.setAsseY(0.0, Double.valueOf(this.massimoY.getValue().toString()), true);
            }
            if (this.autoX.isSelected()) {
                this.fittaOrizzontale();
            } else {
                this.isto.setAsseX(minimo, massimo, true);
            }
            this.isto.ridisegnaSfondo();
            this.isto.refresh();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
    }

    public String getStringaDescrittiva() {
        int aX = 0;
        int aY = 0;
        int t = 0;
        String s = this.canaleXCB.getSelectedIndex() + "," + this.minimoX.getValue() + "," + this.massimoX.getValue() + "," + this.massimoY.getValue() + "," + this.step.getValue() + "," + this.canaleCondizione.getSelectedIndex() + "," + this.limiteBasso.getValue() + "," + this.limiteAlto.getValue() + ",";
        if (this.autoX.isSelected()) {
            aX = 1;
        }
        if (this.autoY.isSelected()) {
            aY = 1;
        }
        if (this.taglia.isSelected()) {
            t = 1;
        }
        s = s + aX + "," + aY + "," + t + "," + this.coloreIsto.getBackground().getRGB() + "," + this.coloreGrafico.getBackground().getRGB() + "," + this.comboMode.getSelectedIndex() + ",";
        s = s + this.getLocationOnScreen().x + "," + this.getLocationOnScreen().y + "," + this.getWidth() + "," + this.getHeight() + ",";
        return s;
    }

    public void importaStringaDescrittiva(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s, ",");
            String t = st.nextToken();
            this.canaleXCB.setSelectedIndex(Integer.valueOf(t));
            t = st.nextToken();
            this.minimoX.setValue(Double.valueOf(t));
            t = st.nextToken();
            this.massimoX.setValue(Double.valueOf(t));
            t = st.nextToken();
            this.massimoY.setValue(Double.valueOf(t));
            t = st.nextToken();
            this.step.setValue(Double.valueOf(t));
            t = st.nextToken();
            this.canaleCondizione.setSelectedIndex(Integer.valueOf(t));
            t = st.nextToken();
            this.limiteBasso.setValue(Double.valueOf(t));
            t = st.nextToken();
            this.limiteAlto.setValue(Double.valueOf(t));
            t = st.nextToken();
            int b = Integer.valueOf(t);
            if (b == 1) {
                this.autoX.setSelected(true);
            } else {
                this.autoX.setSelected(false);
            }
            t = st.nextToken();
            b = Integer.valueOf(t);
            if (b == 1) {
                this.autoY.setSelected(true);
            } else {
                this.autoY.setSelected(false);
            }
            t = st.nextToken();
            b = Integer.valueOf(t);
            if (b == 1) {
                this.taglia.setSelected(true);
            } else {
                this.taglia.setSelected(false);
            }
            t = st.nextToken();
            this.coloreIsto.setBackground(new Color(Integer.valueOf(t)));
            t = st.nextToken();
            this.coloreGrafico.setBackground(new Color(Integer.valueOf(t)));
            t = st.nextToken();
            this.comboMode.removeActionListener(this);
            this.comboMode.setSelectedIndex(Integer.valueOf(t));
            this.comboMode.addActionListener(this);
            t = st.nextToken();
            int x0 = Integer.valueOf(t);
            t = st.nextToken();
            int y0 = Integer.valueOf(t);
            this.setLocation(x0, y0);
            t = st.nextToken();
            int w = Integer.valueOf(t);
            t = st.nextToken();
            int h = Integer.valueOf(t);
            this.setSize(w, h);
            this.minimoX.setEnabled(!this.autoX.isSelected());
            this.massimoX.setEnabled(!this.autoX.isSelected());
            this.massimoY.setEnabled(!this.autoX.isSelected());
            this.aggiornaCurve();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.out.println("Errore parsing stringa descrizione istogramma");
        }
    }

    public void aggiornaNomi() {
        int selX = this.canaleXCB.getSelectedIndex();
        int selC = this.canaleCondizione.getSelectedIndex();
        if (DanasDataStructure.getInstance().getDefaultSession() == null) {
            return;
        }
        this.canaleXCB.removeAllItems();
        this.canaleCondizione.removeAllItems();
        this.canaleCondizione.addItem(Language.string("Nessuno"));
        for (int i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            this.canaleXCB.addItem(MeasuresUtil.getNomeCanale(i));
            this.canaleCondizione.addItem(MeasuresUtil.getNomeCanale(i));
        }
        this.canaleXCB.setSelectedIndex(selX);
        this.canaleCondizione.setSelectedIndex(selC);
    }

    public void fittaVerticale() {
        if (this.isto.getScene().getNChildren() == 0) {
            return;
        }
        double max = Double.MIN_VALUE;
        GScene s = this.isto.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (!(((CurvaIstogramma)s.getChild(j)).getMaxY() > max)) continue;
            max = ((CurvaIstogramma)s.getChild(j)).getMaxY();
        }
        if ((max *= 1.05) < 0.01) {
            max = 0.01;
        }
        this.isto.setAsseY(0.0, max, true);
    }

    public void fittaOrizzontale() {
        if (this.isto.getScene().getNChildren() == 0) {
            return;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        GScene s = this.isto.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (((CurvaIstogramma)s.getChild(j)).getMaxX() > max) {
                max = ((CurvaIstogramma)s.getChild(j)).getMaxX();
            }
            if (!(((CurvaIstogramma)s.getChild(j)).getMinX() < min)) continue;
            min = ((CurvaIstogramma)s.getChild(j)).getMinX();
        }
        this.isto.setAsseX(min, max, true);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Color color;
        if (arg0.getSource().equals(this.coloreSfondoXY) && (color = JColorChooser.showDialog(this, Language.string("Colore sfondo del grafico"), this.coloreGrafico.getBackground())) != null) {
            this.isto.setBackgroundColor(color);
            this.coloreGrafico.setBackground(color);
        }
        if (arg0.getSource().equals(this.coloreIstogramma) && (color = JColorChooser.showDialog(this, Language.string("Colore Istogramma"), this.coloreIsto.getBackground())) != null) {
            this.isto.setColore(color);
            this.coloreIsto.setBackground(color);
        }
        if (arg0.getSource().equals(this.comboMode)) {
            if (this.comboMode.getSelectedIndex() != -1) {
                this.modoAttuale = this.comboMode.getSelectedIndex();
                this.caricaPreferenze(this.modoAttuale);
            } else {
                return;
            }
        }
        if (arg0.getSource().equals(this.salvaB)) {
            this.salvaPreferenze();
        }
        if (arg0.getSource().equals(this.minimoX) || arg0.getSource().equals(this.massimoX) || arg0.getSource().equals(this.limiteBasso) || arg0.getSource().equals(this.limiteAlto)) {
            this.aggiornaCurve = true;
        }
        if (arg0.getSource().equals(this.step) || arg0.getSource().equals(this.taglia)) {
            this.aggiornaCurve = true;
        }
        if (arg0.getSource().equals(this.massimoY)) {
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.autoY)) {
            this.massimoY.setEnabled(!this.autoY.isSelected());
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.autoX)) {
            this.minimoX.setEnabled(!this.autoX.isSelected());
            this.massimoX.setEnabled(!this.autoX.isSelected());
            this.aggiornaCurve = true;
        }
        if (arg0.getSource().equals(this.canaleXCB) || arg0.getSource().equals(this.canaleCondizione)) {
            this.aggiornaCurve = true;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource().equals(this.contenitore)) {
            if (this.contenitore.getSelectedIndex() == 1) {
                this.setFocusableWindowState(true);
                this.contenitore.setComponentAt(0, null);
                this.altezzaDialog = this.getHeight();
                this.larghezzaDialog = this.getWidth();
                this.posX = this.getLocationOnScreen().x;
                this.posY = this.getLocationOnScreen().y;
                this.setSize(650, 650);
                this.setLocationRelativeTo(null);
            }
            if (this.contenitore.getSelectedIndex() == 0) {
                this.setFocusableWindowState(false);
                this.setSize(this.larghezzaDialog, this.altezzaDialog);
                this.setLocation(this.posX, this.posY);
                this.contenitore.setComponentAt(0, this.pannelloTabella);
                int stepNew = 30;
                try {
                    stepNew = Integer.valueOf(this.step.getText());
                }
                catch (Exception e) {
                    this.step.setValue(30);
                }
                if (this.aggiornaCurve || this.stepOld != stepNew) {
                    this.aggiornaCurve = false;
                    this.stepOld = stepNew;
                    this.aggiornaCurve();
                }
                if (this.aggiornaGrafico) {
                    this.aggiornaGrafico = false;
                    if (!this.autoY.isSelected()) {
                        this.isto.setAsseY(0.0, Double.valueOf(this.massimoY.getValue().toString()), true);
                    } else {
                        this.fittaVerticale();
                    }
                }
            }
        }
        if (arg0.getSource().equals(DanasDataStructure.getInstance())) {
            try {
                if (!this.visibile) {
                    return;
                }
                DanasDataStructure dati = DanasDataStructure.getInstance();
                System.out.println("istogramma: change listener=" + (Object)((Object)dati.getChange()));
                switch (dati.getChange()) {
                    case REFRESH_ALL: 
                    case REMOVE_DATA: 
                    case NEW_DATA: 
                    case SEL_SESSION: 
                    case DESEL_SESSION: 
                    case SEL_ALL_SESSION: 
                    case DESEL_ALL_SESSION: 
                    case SET_REF_SESSION: 
                    case SEL_LAP: 
                    case DESEL_LAP: 
                    case SEL_ALL_LAP: 
                    case DESEL_ALL_LAP: 
                    case SET_REF_LAP: 
                    case SET_GOAL: {
                        this.aggiornaCurve();
                        this.aggiornaNomi();
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("ERRORE aggiornamento Istogramma");
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        IstogrammaDialog i = new IstogrammaDialog(null);
        i.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }
}

