/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;

public class FileLoader {
    private static final int BUFSIZE = 65535;
    private File file;
    private FileReader fr;
    private LineNumberReader lnr;
    private int line;

    public static String load(String filename) throws IOException {
        byte[] buf = new byte[65535];
        String data = new String("");
        FileInputStream is = new FileInputStream(filename);
        int x = 0;
        while ((x = ((InputStream)is).read(buf)) == 65535) {
            data = data + new String(buf);
        }
        if (x == -1) {
            ((InputStream)is).close();
            throw new IOException(filename + ": File is empty!");
        }
        data = data + new String(buf).substring(0, x);
        ((InputStream)is).close();
        return data;
    }

    public File getFile() {
        return this.file;
    }

    public FileLoader(String filename) throws IOException {
        this(new File(filename));
    }

    public FileLoader(File _file) throws IOException {
        this.file = _file;
        this.fr = new FileReader(this.file);
        this.lnr = new LineNumberReader(this.fr);
        this.file = _file;
        this.line = 0;
    }

    public long getSize() {
        return this.file.length();
    }

    public String getNextLine() throws IOException {
        this.lnr.setLineNumber(this.line++);
        String l = this.lnr.readLine();
        if (l == null) {
            --this.line;
        }
        return l;
    }

    public void setLineNumber(int _line) {
        this.line = _line;
    }

    public int getLineNumber() {
        return this.line;
    }

    public void close() {
        try {
            this.lnr.close();
            this.fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

